package samples.stockbroker;

/**
 * This Exception is thrown by methods of <tt>SignatureCard</tt> when a problem
 * occurrs.
 *
 * @see samples.stockbroker.SignatureCard
 *
 * @author Frank Seliger (seliger@de.ibm.com)
 */
public class SignatureCardException extends Exception {

  private Exception primaryException;

  /*
   * Create a new <tt>SignatureCardException</tt> object with the given error
   * message.
   */
  public SignatureCardException(String message)
  {
	super(message);
       primaryException = null;
  }

  /*
   * Create a new <tt>SignatureCardException</tt> object with the given error
   * message and the given exception.
   */
  public SignatureCardException(String message,
                                Exception exception)
  {
	super(message + '\n' + exception.getMessage());
       primaryException = exception;
  }

                                                                                                                                                                                 /*
   * Return the exception contained in this object.  This exception is
   * normally the primary exception that occured and lead to this
   * exception being thrown.  Return null if there is no primary exception
   * contained.
   */
  public Exception getPrimaryException()
  {
       return primaryException;
  }
}