package samples.stockbroker;

public class Test {

/**
 * Starts the test program.
 * @param args an array of command-line arguments
 */
public static void main(java.lang.String[] args) {

  try {
      SignatureCard sc = new SignatureCard();
      say("A SignatureCard object was created.");

      if (sc.cardPresent() == false) {
          say("No smart card is present.");
          return;
      }
      say("A smart card is present.");

      if (sc.fileSystemCardPresent() == false)  {
          say("No file system card is present.");
          return;
      }
      say("A file system card is present.");

      say("Reading the card holder data.");
      displayCardHolderData(sc);

      if (args.length > 0)  {
          String chData = "";
          for (int cnt = 0; cnt < args.length; cnt++)  {
              chData += (args[cnt] + " ");
          }

          say("Writing the card holder data.");
          if (sc.setCardHolderData(chData))
            say("Writing the card holder data was successfull.");
          else
            say("Writing the card holder data failed.");

          say("Reading the card holder data.");
          displayCardHolderData(sc);
      }

      if (sc.signatureCardPresent() == false)  {
          say("No signature card is present.");
      }
      else  {
          say("A signature card is present.");
          byte[] text = { '2','0','0','0' };
          byte[] signature = sc.sign(0, text);
          if (signature != null)
             say("The sign operation was successfull.");
      }

      say("Closing the SignatureCard object (and implicitely OCF).");
      sc.close();

    } catch (Exception e) {
       say("Stack Trace at point of exception:");
    	e.printStackTrace();
    	System.exit(0);
  }
}

protected static void displayCardHolderData(SignatureCard sc)
                               throws Exception               {
  byte[] cData =  sc.getCardHolderData();
  if (cData == null)
     say("Got no data from the card." );
  else
     say("Got from card: \n>" +  new String(cData) + "<" );
}

protected static void say(String text)  {
  System.out.println("Test:   " + text);
}

};