/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import jv.vecmath.P_Vector;
import jv.vecmath.PuData;

public class PgElementEdge
extends P_Vector {
    private int m_size;
    protected int[] m_vertInd;
    protected int[] m_elemInd;
    protected int[] m_neighbourLocInd;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("\t ******* PgElementEdge ***********\n");
        stringBuffer.append("\t Index of vertices = [" + this.m_vertInd[0] + ", " + this.m_vertInd[1] + "]\n");
        stringBuffer.append("\t Number of adjacent elements = " + this.m_size + "\n");
        stringBuffer.append("\t Indices of adjacent elements = [" + this.m_elemInd[0]);
        int n = 1;
        while (n < this.m_size) {
            stringBuffer.append(", " + this.m_elemInd[n]);
            ++n;
        }
        stringBuffer.append("\n");
        stringBuffer.append("\t Local indices of opposite vertices = [" + this.m_neighbourLocInd[0]);
        n = 1;
        while (n < this.m_size) {
            stringBuffer.append(", " + this.m_neighbourLocInd[n]);
            ++n;
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public PgElementEdge(int n, int n2) {
        this.m_vertInd = new int[]{n, n2};
        this.m_size = 0;
        this.m_elemInd = new int[2];
        this.m_neighbourLocInd = new int[2];
    }

    public int getEdgeInd(int n) {
        return this.m_vertInd[n];
    }

    public int getElementInd(int n) {
        return this.m_elemInd[n];
    }

    public void addElement(int n, int n2) {
        ++this.m_size;
        if (this.m_size > this.m_elemInd.length) {
            this.m_elemInd = PuData.realloc(this.m_elemInd, this.m_size);
            this.m_neighbourLocInd = PuData.realloc(this.m_neighbourLocInd, this.m_size);
        }
        this.m_elemInd[this.m_size - 1] = n;
        this.m_neighbourLocInd[this.m_size - 1] = n2;
    }

    public int getSize() {
        return this.m_size;
    }

    public int getNeighbourLocInd(int n) {
        return this.m_neighbourLocInd[n];
    }
}

