/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import java.util.Enumeration;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet_Menu;
import jv.geom.PgPolygon;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.objectGui.PsMethodMenu;
import jv.project.PvDisplayIf;
import jv.vecmath.PiVector;

public class PgPolygon_Menu
extends PgPointSet_Menu {
    public static final int MTHD_CLOSE = 0;
    public static final int MTHD_TRIANGULATE = 1;
    public static final int MTHD_LENGTH = 2;
    public static final int MTHD_MAKE_NORMALS = 3;
    public static final int MTHD_SHOW_POLYGON_START_ARROW = 4;
    public static final int MTHD_SHOW_POLYGON_END_ARROW = 5;
    public static final int MTHD_SHOW_EDGE_LABELS = 6;
    public static final String[] m_polygonMethod = new String[]{PsConfig.getMessage("Close"), PsConfig.getMessage("Triangulate"), PsConfig.getMessage("Length"), PsConfig.getMessage("MakeNormals"), PsConfig.getMessage("ShowPolygonStartArrow"), PsConfig.getMessage("ShowPolygonEndArrow"), PsConfig.getMessage("ShowEdgeLabels")};
    protected PgPolygon m_polygon;

    public boolean applyMethod(String string) {
        if (super.applyMethod(string)) {
            return true;
        }
        int n = PsMethodMenu.getIndexOfMethod(m_polygonMethod, string);
        switch (n) {
            case 6: {
                this.m_polygon.showEdgeLabels(!this.m_polygon.isShowingEdgeLabels());
                break;
            }
            case 0: {
                this.m_polygon.setClosed(!this.m_polygon.isClosed());
                break;
            }
            case 1: {
                PiVector[] piVectorArray = this.m_polygon.triangulate();
                if (piVectorArray == null || piVectorArray.length == 0) break;
                PgElementSet pgElementSet = new PgElementSet(this.m_polygon.getDimOfVertices());
                pgElementSet.setName("Triangulated Polygon");
                pgElementSet.setNumVertices(this.m_polygon.getNumVertices());
                pgElementSet.setVertices(this.m_polygon.getVertices());
                pgElementSet.setNumElements(piVectorArray.length);
                pgElementSet.setElements(piVectorArray);
                Enumeration enumeration = this.m_polygon.getDisplays();
                while (enumeration.hasMoreElements()) {
                    PvDisplayIf pvDisplayIf = (PvDisplayIf)enumeration.nextElement();
                    pvDisplayIf.addGeometry(pgElementSet);
                    pvDisplayIf.selectGeometry(pgElementSet);
                }
                break;
            }
            case 2: {
                PsDebug.message("Polygon = " + this.m_polygon.getName());
                PsDebug.message("\t length = " + this.m_polygon.getLength());
                return true;
            }
            case 3: {
                this.m_polygon.makeNormals();
                break;
            }
            case 4: {
                this.m_polygon.showPolygonStartArrow(!this.m_polygon.isShowingPolygonStartArrow());
                break;
            }
            case 5: {
                this.m_polygon.showPolygonEndArrow(!this.m_polygon.isShowingPolygonEndArrow());
                break;
            }
            case -1: {
                return false;
            }
            default: {
                PsDebug.error("PgPolygon_Menu.applyMethod: method string = " + string + " does not match a constant", this);
                return false;
            }
        }
        return true;
    }

    public void init(PsObject psObject) {
        super.init(psObject);
        this.m_polygon = (PgPolygon)psObject;
        this.addMenu(PsConfig.getMessage("Apply"));
        this.addMenuItem(PsConfig.getMessage("Apply"), m_polygonMethod[0]);
        this.addMenuItem(PsConfig.getMessage("Apply"), m_polygonMethod[3]);
        this.addMenu(PsConfig.getMessage("Build"));
        this.addMenuItem(PsConfig.getMessage("Build"), m_polygonMethod[1]);
        this.addMenu(PsConfig.getMessage("Info"));
        this.addMenuItem(PsConfig.getMessage("Info"), m_polygonMethod[2]);
        this.addMenu(PsConfig.getMessage("Show"));
        this.addMenuItem(PsConfig.getMessage("Show"), m_polygonMethod[6], this.m_polygon.isShowingEdgeLabels());
        this.addMenuItem(PsConfig.getMessage("Show"), m_polygonMethod[4], this.m_polygon.isShowingPolygonStartArrow());
        this.addMenuItem(PsConfig.getMessage("Show"), m_polygonMethod[5], this.m_polygon.isShowingPolygonEndArrow());
    }
}

