/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsDialog;
import jv.object.PsPanel;

public final class PgExport_Dialog
extends PsDialog {
    protected TextArea m_output;
    protected String m_dir;
    protected String m_ext = "txt";
    protected String m_fileName = "javaview";
    protected int[] m_exportBounds = new int[]{10, 10, 400, 400};

    public PgExport_Dialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        if (PsConfig.getViewer() != null) {
            this.removeKeyListener(PsConfig.getViewer());
        }
        this.init();
    }

    public String getDirectory() {
        return this.m_dir;
    }

    public void setDirectory(String string) {
        this.m_dir = string;
    }

    public String getFilename() {
        return this.m_fileName;
    }

    public void setFilename(String string) {
        this.m_fileName = string;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_bSave) {
            FileDialog fileDialog = new FileDialog(PsConfig.getFrame(), this.getTitle(), 1);
            if (this.m_ext != null) {
                fileDialog.setFile(this.m_fileName + "." + this.m_ext);
            } else {
                fileDialog.setFile(this.m_fileName + ".txt");
            }
            if (this.m_dir != null) {
                fileDialog.setDirectory(this.m_dir);
            } else {
                fileDialog.setDirectory(PsConfig.getCodeBase());
            }
            ((Component)fileDialog).setVisible(true);
            if (fileDialog.getDirectory() == null || fileDialog.getFile() == null) {
                PsDebug.warning("missing dir or file name");
                return;
            }
            this.m_dir = fileDialog.getDirectory();
            if (!this.m_dir.endsWith("/") && !this.m_dir.endsWith("\\")) {
                this.m_dir = this.m_dir + "/";
            }
            this.m_fileName = fileDialog.getFile();
            this.m_fileName = this.m_fileName.substring(0, this.m_fileName.lastIndexOf(46));
            File file = null;
            if (PsConfig.isApplication()) {
                file = new File(fileDialog.getDirectory() + fileDialog.getFile());
                if (file == null) {
                    PsDebug.warning("could not open file = " + fileDialog.getFile() + " in directory = " + fileDialog.getDirectory());
                    return;
                }
            } else {
                file = new File(fileDialog.getFile());
                if (file == null) {
                    PsDebug.warning("could not open file = " + fileDialog.getFile());
                    return;
                }
            }
            try {
                FileWriter fileWriter = new FileWriter(file);
                PrintWriter printWriter = new PrintWriter((Writer)new BufferedWriter(fileWriter), true);
                printWriter.println(this.getText());
                printWriter.close();
            }
            catch (IOException iOException) {
                PsDebug.error("could not open file", this);
                PsDebug.warning("\t File Name = " + fileDialog.getFile());
                PsDebug.warning("\t Exception = " + iOException.toString());
                return;
            }
            super.actionPerformed(actionEvent);
            return;
        }
        super.actionPerformed(actionEvent);
    }

    public void setFilenameExtension(String string) {
        this.m_ext = string;
    }

    public void init() {
        Panel panel;
        super.init();
        ((Component)this).setFont(PsConfig.getFont(1));
        this.setLayout(new BorderLayout(5, 5));
        if (!PsConfig.isApplication()) {
            panel = new PsPanel();
            ((PsPanel)panel).setBorderType(1);
            ((PsPanel)panel).addTitle(PsConfig.getMessage("HowToSaveOutput") + ":");
            TextArea textArea = new TextArea(PsConfig.getMessage("tMessage"), 6, 65, 1);
            textArea.setEditable(false);
            panel.add(textArea);
            this.add("North", panel);
        }
        this.m_output = new TextArea(40, 80);
        this.m_output.setEditable(true);
        this.add("Center", this.m_output);
        panel = this.getBottomButtons(48);
        ((Component)panel).setFont(PsConfig.getFont(0));
        this.add("South", panel);
        this.setLocation(this.m_exportBounds[0], this.m_exportBounds[1]);
        ((Component)this).setSize(this.m_exportBounds[2], this.m_exportBounds[3]);
        this.validate();
    }

    public void setText(String string) {
        this.m_output.setText(string);
    }

    public String getText() {
        if (this.m_output == null) {
            return null;
        }
        return this.m_output.getText();
    }
}

