/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.Color;
import java.io.Serializable;
import java.util.Date;
import jv.loader.PsXmlLoader;
import jv.loader.PsXmlNode;
import jv.loader.PsXmlSrc;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.project.PgJvxSrc;
import jv.rsrc.PsAuthorInfo;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuData;

public class PgJvxLoader {
    private static final int UNKNOWN = -1;
    private static final int TRUE = 1;
    private static final int FALSE = 0;

    protected static PgJvxSrc[] parseRsrcTree(PsXmlSrc psXmlSrc) {
        int n;
        Object object;
        PgJvxSrc[] pgJvxSrcArray;
        PsXmlNode psXmlNode;
        String[] stringArray = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        PsXmlNode psXmlNode2 = psXmlSrc.getRootNode();
        if (psXmlNode2 == null) {
            PsDebug.warning("missing root node.");
            return null;
        }
        PsXmlNode psXmlNode3 = PsXmlSrc.getRsrcNode(psXmlNode2, "version");
        if (psXmlNode3 == null) {
            PsDebug.warning("missing version information, using default.");
            string = "0.0";
            string2 = "dump";
        } else {
            string = psXmlNode3.getContent();
            string2 = psXmlNode3.getAttribute("type");
        }
        string3 = PsXmlSrc.getRsrc(psXmlNode2, "title");
        PsXmlNode psXmlNode4 = PsXmlSrc.getRsrcNode(psXmlNode2, "authors");
        PsAuthorInfo psAuthorInfo = null;
        if (psXmlNode4 != null) {
            psAuthorInfo = new PsAuthorInfo();
            psAuthorInfo.getXmlNode(psXmlNode4);
        }
        if ((psXmlNode = PsXmlSrc.getRsrcNode(psXmlNode2, "description")) != null) {
            string5 = PsXmlSrc.getRsrc(psXmlNode, "abstract");
            string6 = PsXmlSrc.getRsrc(psXmlNode, "detail");
            pgJvxSrcArray = PsXmlSrc.getRsrcNode(psXmlNode, "keywords");
            if (pgJvxSrcArray != null && (object = PsXmlSrc.getRsrcNodes((PsXmlNode)pgJvxSrcArray, "keyword")) != null && ((Object[])object).length > 0) {
                stringArray = new String[((Object[])object).length];
                n = 0;
                while (n < ((Object[])object).length) {
                    stringArray[n] = ((PsXmlNode)object[n]).getContent();
                    ++n;
                }
            }
            if ((object = PsXmlSrc.getRsrcNode(psXmlNode, "msc2000")) != null) {
                string7 = PsXmlSrc.getRsrc((PsXmlNode)object, "primary");
                string8 = PsXmlSrc.getRsrc((PsXmlNode)object, "secondary");
            }
            string4 = PsXmlSrc.getRsrc(psXmlNode, "software");
        }
        pgJvxSrcArray = null;
        object = new String[]{"tag", "name"};
        PsXmlNode psXmlNode5 = PsXmlSrc.getRsrcNode(psXmlNode2, "geometries");
        if (psXmlNode5 != null) {
            PsXmlNode[] psXmlNodeArray = PsXmlSrc.getRsrcNodes(psXmlNode5, "geometry");
            if (psXmlNodeArray == null || psXmlNodeArray.length == 0) {
                return null;
            }
            pgJvxSrcArray = new PgJvxSrc[psXmlNodeArray.length];
            n = 0;
            while (n < psXmlNodeArray.length) {
                String string9;
                PiVector[] piVectorArray;
                PdVector[] pdVectorArray;
                Color[] colorArray;
                Color color;
                double d;
                Object object2;
                Object object3;
                PsXmlNode psXmlNode6;
                Object object4;
                PsXmlNode psXmlNode7;
                PgJvxSrc pgJvxSrc = new PgJvxSrc();
                if (psAuthorInfo != null) {
                    pgJvxSrc.setAuthors(psAuthorInfo);
                }
                pgJvxSrcArray[n] = pgJvxSrc;
                pgJvxSrc.setVersion(string);
                pgJvxSrc.setVersionType(string2);
                pgJvxSrc.setTitle(string3);
                pgJvxSrc.setAbstract(string5);
                pgJvxSrc.setDetail(string6);
                pgJvxSrc.setKeywords(stringArray);
                pgJvxSrc.setPrimary(string7);
                pgJvxSrc.setSecondary(string8);
                pgJvxSrc.setSoftware(string4);
                pgJvxSrc.setName(psXmlNodeArray[n].getAttribute("name"));
                pgJvxSrc.setVisible(PgJvxLoader.parseVisibility(psXmlNodeArray[n].getAttribute("visible")) != 0);
                PiVector piVector = PsXmlLoader.parseLabelAtt(PsXmlSrc.getRsrcNode(psXmlNodeArray[n], "labelAtt"));
                if (piVector != null) {
                    pgJvxSrc.setLabelAttribute(5, piVector);
                    pgJvxSrc.showTitle(piVector.getEntry(5) == 1);
                }
                if ((psXmlNode7 = PsXmlSrc.getRsrcNode(psXmlNodeArray[n], "pointSet")) != null) {
                    object4 = psXmlNode7.getAttribute("dim");
                    if (object4 == null) {
                        PsDebug.warning("missing dimension of geometry[" + n + "]");
                        return null;
                    }
                    pgJvxSrc.setDimOfVertices(Integer.parseInt((String)object4));
                    pgJvxSrc.showVertices(PgJvxLoader.parseVisibility(psXmlNode7.getAttribute("point")) != 0);
                    pgJvxSrc.showVertexNormals(PgJvxLoader.parseVisibility(psXmlNode7.getAttribute("normal")) == 1);
                    pgJvxSrc.showVertexNormalArrow(PgJvxLoader.parseVisibility(psXmlNode7.getAttribute("normalArrow")) == 1);
                    pgJvxSrc.showVertexColors(PgJvxLoader.parseVisibility(psXmlNode7.getAttribute("color")) == 1);
                    pgJvxSrc.setType(30);
                    psXmlNode6 = PsXmlSrc.getRsrcNode(psXmlNode7, "points");
                    if (psXmlNode6 != null) {
                        piVector = PsXmlLoader.parseLabelAtt(PsXmlSrc.getRsrcNode(psXmlNode6, "labelAtt"));
                        if (piVector != null) {
                            pgJvxSrc.setLabelAttribute(0, piVector);
                            pgJvxSrc.showVertexLabels(piVector.getEntry(5) == 1);
                        }
                        if ((object3 = PsXmlLoader.parseDoubleList(psXmlNode6, "p", (String[])object)) != null) {
                            pgJvxSrc.setDimOfVertices(((PdVector)((Object)object3[0])).getSize());
                            pgJvxSrc.setNumVertices(((PsXmlNode[])object3).length);
                            pgJvxSrc.setVertices((PdVector[])object3);
                        }
                        if ((object2 = PsXmlLoader.parseFunList(psXmlNode6, "pf", (String[])object)) != null) {
                            pgJvxSrc.setDimOfVertices(object2[0].length);
                            pgJvxSrc.setNumVertices(((String[][])object2).length);
                            pgJvxSrc.setVertexFunctions((String[][])object2);
                        }
                        if ((d = PsXmlSrc.getRsrcAsDouble(psXmlNode6, "thickness")) != 0.0) {
                            pgJvxSrc.setGlobalVertexSize(d);
                        }
                        if ((color = PsXmlLoader.parseColorRGB(psXmlNode6, "color")) != null) {
                            pgJvxSrc.setGlobalVertexColor(color);
                        }
                        if ((color = PsXmlLoader.parseColorRGB(psXmlNode6, "colorTag")) != null) {
                            pgJvxSrc.setGlobalVertexTagColor(color);
                        }
                    }
                    if ((object3 = PsXmlSrc.getRsrcNode(psXmlNode7, "colors")) != null && (colorArray = PsXmlLoader.parseColorList((PsXmlNode)object3, "c")) != null) {
                        pgJvxSrc.setVertexColors(colorArray);
                    }
                    if ((object2 = PsXmlSrc.getRsrcNode(psXmlNode7, "normals")) != null) {
                        pdVectorArray = PsXmlLoader.parseDoubleList((PsXmlNode)object2, "n", null);
                        if (pdVectorArray != null) {
                            pgJvxSrc.setVertexNormals(pdVectorArray);
                        }
                        if ((d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object2, "thickness")) != 0.0) {
                            pgJvxSrc.setGlobalVertexNormalSize(d);
                        }
                        if ((d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object2, "length")) != 0.0) {
                            pgJvxSrc.setGlobalVertexNormalLength(d);
                        }
                        if ((color = PsXmlLoader.parseColorRGB((PsXmlNode)object2, "color")) != null) {
                            pgJvxSrc.setGlobalVertexNormalColor(color);
                        }
                    }
                    if ((piVectorArray = PsXmlSrc.getRsrcNode(psXmlNode7, "textures")) != null) {
                        pdVectorArray = PsXmlLoader.parseDoubleList((PsXmlNode)piVectorArray, "t", null);
                        if (pdVectorArray != null) {
                            pgJvxSrc.setVertexTextures(pdVectorArray);
                        }
                        if ((string9 = PsXmlSrc.getRsrc((PsXmlNode)piVectorArray, "image")) != null) {
                            pgJvxSrc.setTextureImage(string9);
                        }
                    }
                }
                if ((object4 = PsXmlSrc.getRsrcNode(psXmlNodeArray[n], "lineSet")) != null) {
                    pgJvxSrc.showPolygonStartArrow(PgJvxLoader.parseVisibility(((PsXmlNode)object4).getAttribute("startArrow")) == 1);
                    pgJvxSrc.showPolygonEndArrow(PgJvxLoader.parseVisibility(((PsXmlNode)object4).getAttribute("arrow")) == 1);
                    pgJvxSrc.showPolygons(PgJvxLoader.parseVisibility(((PsXmlNode)object4).getAttribute("line")) != 0);
                    pgJvxSrc.showPolygonNormals(PgJvxLoader.parseVisibility(((PsXmlNode)object4).getAttribute("normal")) == 1);
                    pgJvxSrc.showPolygonNormalArrow(PgJvxLoader.parseVisibility(((PsXmlNode)object4).getAttribute("normalArrow")) == 1);
                    pgJvxSrc.showPolygonColors(PgJvxLoader.parseVisibility(((PsXmlNode)object4).getAttribute("color")) == 1);
                    pgJvxSrc.setType(32);
                    psXmlNode6 = PsXmlSrc.getRsrcNode((PsXmlNode)object4, "lines");
                    if (psXmlNode6 != null) {
                        piVector = PsXmlLoader.parseLabelAtt(PsXmlSrc.getRsrcNode(psXmlNode6, "labelAtt"));
                        if (piVector != null) {
                            pgJvxSrc.setLabelAttribute(2, piVector);
                            pgJvxSrc.showPolygonLabels(piVector.getEntry(5) == 1);
                        }
                        if ((object3 = PsXmlLoader.parseIntegerList(psXmlNode6, "l", (String[])object)) != null) {
                            pgJvxSrc.setDimOfPolygons(-1);
                            pgJvxSrc.setNumPolygons(((PsXmlNode[])object3).length);
                            pgJvxSrc.setPolygons((PiVector[])object3);
                        }
                        if ((d = PsXmlSrc.getRsrcAsDouble(psXmlNode6, "thickness")) != 0.0) {
                            pgJvxSrc.setGlobalPolygonSize(d);
                        }
                        if ((color = PsXmlLoader.parseColorRGB(psXmlNode6, "color")) != null) {
                            pgJvxSrc.setGlobalPolygonColor(color);
                        }
                        if ((color = PsXmlLoader.parseColorRGB(psXmlNode6, "colorTag")) != null) {
                            pgJvxSrc.setGlobalPolygonTagColor(color);
                        }
                    }
                    if ((object3 = PsXmlSrc.getRsrcNode((PsXmlNode)object4, "colors")) != null && (colorArray = PsXmlLoader.parseColorList((PsXmlNode)object3, "c")) != null) {
                        pgJvxSrc.setPolygonColors(colorArray);
                    }
                    if ((object2 = PsXmlSrc.getRsrcNode((PsXmlNode)object4, "normals")) != null) {
                        pdVectorArray = PsXmlLoader.parseDoubleList((PsXmlNode)object2, "n", null);
                        if (pdVectorArray != null) {
                            pgJvxSrc.setPolygonNormals(pdVectorArray);
                        }
                        if ((d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object2, "thickness")) != 0.0) {
                            pgJvxSrc.setGlobalPolygonNormalSize(d);
                        }
                        if ((d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object2, "length")) != 0.0) {
                            pgJvxSrc.setGlobalPolygonNormalLength(d);
                        }
                        if ((color = PsXmlLoader.parseColorRGB((PsXmlNode)object2, "color")) != null) {
                            pgJvxSrc.setGlobalPolygonNormalColor(color);
                        }
                    }
                }
                if ((psXmlNode6 = PsXmlSrc.getRsrcNode(psXmlNodeArray[n], "faceSet")) != null) {
                    PsXmlNode psXmlNode8;
                    PsXmlNode psXmlNode9;
                    PsXmlNode psXmlNode10;
                    PiVector[] piVectorArray2;
                    pgJvxSrc.showElements(PgJvxLoader.parseVisibility(psXmlNode6.getAttribute("face")) != 0);
                    pgJvxSrc.showEdges(PgJvxLoader.parseVisibility(psXmlNode6.getAttribute("edge")) != 0);
                    pgJvxSrc.showElementNormals(PgJvxLoader.parseVisibility(psXmlNode6.getAttribute("normal")) == 1);
                    pgJvxSrc.showElementNormalArrow(PgJvxLoader.parseVisibility(psXmlNode6.getAttribute("normalArrow")) == 1);
                    pgJvxSrc.showElementColors(PgJvxLoader.parseVisibility(psXmlNode6.getAttribute("color")) == 1);
                    pgJvxSrc.showElementBackColor(PgJvxLoader.parseVisibility(psXmlNode6.getAttribute("backcolor")) == 1);
                    boolean bl = PgJvxLoader.parseVisibility(psXmlNode6.getAttribute("backface")) != 0;
                    pgJvxSrc.showBackface(bl);
                    pgJvxSrc.showOutline(PgJvxLoader.parseVisibility(psXmlNode6.getAttribute("outline")) == 1);
                    pgJvxSrc.setType(33);
                    object2 = PsXmlSrc.getRsrcNode(psXmlNode6, "faces");
                    if (object2 != null) {
                        piVector = PsXmlLoader.parseLabelAtt(PsXmlSrc.getRsrcNode((PsXmlNode)object2, "labelAtt"));
                        if (piVector != null) {
                            pgJvxSrc.setLabelAttribute(3, piVector);
                            pgJvxSrc.showElementLabels(piVector.getEntry(5) == 1);
                        }
                        if ((piVectorArray = PsXmlLoader.parseIntegerList((PsXmlNode)object2, "f", (String[])object)) != null) {
                            pgJvxSrc.setDimOfElements(-1);
                            pgJvxSrc.setNumElements(piVectorArray.length);
                            pgJvxSrc.setElements(piVectorArray);
                        }
                        if ((color = PsXmlLoader.parseColorRGB((PsXmlNode)object2, "color")) != null) {
                            pgJvxSrc.setGlobalElementColor(color);
                        }
                        if ((color = PsXmlLoader.parseColorRGB((PsXmlNode)object2, "colorBack")) != null) {
                            pgJvxSrc.setGlobalElementTagColor(color);
                        }
                        if ((color = PsXmlLoader.parseColorRGB((PsXmlNode)object2, "colorTag")) != null) {
                            pgJvxSrc.setGlobalElementTagColor(color);
                        }
                    }
                    if ((piVectorArray = PsXmlSrc.getRsrcNode(psXmlNode6, "neighbours")) != null && (piVectorArray2 = PsXmlLoader.parseIntegerList((PsXmlNode)piVectorArray, "nb", null)) != null) {
                        pgJvxSrc.setNeighbours(piVectorArray2);
                    }
                    if ((piVectorArray2 = PsXmlSrc.getRsrcNode(psXmlNode6, "edges")) != null) {
                        PiVector[] piVectorArray3;
                        piVector = PsXmlLoader.parseLabelAtt(PsXmlSrc.getRsrcNode((PsXmlNode)piVectorArray2, "labelAtt"));
                        if (piVector != null) {
                            pgJvxSrc.setLabelAttribute(1, piVector);
                            pgJvxSrc.showEdgeLabels(piVector.getEntry(5) == 1);
                        }
                        if ((piVectorArray3 = PsXmlLoader.parseIntegerList((PsXmlNode)piVectorArray2, "e", null)) != null) {
                            pgJvxSrc.setEdges(piVectorArray3);
                        }
                        if ((d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)piVectorArray2, "thickness")) != 0.0) {
                            pgJvxSrc.setGlobalEdgeSize(d);
                        }
                        if ((color = PsXmlLoader.parseColorRGB((PsXmlNode)piVectorArray2, "color")) != null) {
                            pgJvxSrc.setGlobalEdgeColor(color);
                        }
                        if ((color = PsXmlLoader.parseColorRGB((PsXmlNode)piVectorArray2, "colorTag")) != null) {
                            pgJvxSrc.setGlobalEdgeTagColor(color);
                        }
                    }
                    if ((psXmlNode10 = PsXmlSrc.getRsrcNode(psXmlNode6, "colors")) != null && (colorArray = PsXmlLoader.parseColorList(psXmlNode10, "c")) != null) {
                        pgJvxSrc.setElementColors(colorArray);
                    }
                    if ((psXmlNode9 = PsXmlSrc.getRsrcNode(psXmlNode6, "normals")) != null) {
                        pdVectorArray = PsXmlLoader.parseDoubleList(psXmlNode9, "n", null);
                        if (pdVectorArray != null) {
                            pgJvxSrc.setElementNormals(pdVectorArray);
                        }
                        if ((d = PsXmlSrc.getRsrcAsDouble(psXmlNode9, "thickness")) != 0.0) {
                            pgJvxSrc.setGlobalElementNormalSize(d);
                        }
                        if ((d = PsXmlSrc.getRsrcAsDouble(psXmlNode9, "length")) != 0.0) {
                            pgJvxSrc.setGlobalElementNormalLength(d);
                        }
                        if ((color = PsXmlLoader.parseColorRGB(psXmlNode9, "color")) != null) {
                            pgJvxSrc.setGlobalElementNormalColor(color);
                        }
                    } else if (!bl || pgJvxSrc.isShowingElementNormals()) {
                        pgJvxSrc.makeElementNormals();
                    }
                    if ((psXmlNode8 = PsXmlSrc.getRsrcNode(psXmlNode6, "textures")) != null) {
                        String string10 = psXmlNode8.getAttribute("type");
                        if (string10 != null && string10.equals("vertex")) {
                            pgJvxSrc.showVertexTexture(PgJvxLoader.parseVisibility(psXmlNode6.getAttribute("texture")) == 1);
                        } else {
                            pgJvxSrc.showElementTexture(PgJvxLoader.parseVisibility(psXmlNode6.getAttribute("texture")) == 1);
                        }
                        PdVector[] pdVectorArray2 = PsXmlLoader.parseDoubleList(psXmlNode8, "t", null);
                        int n2 = pgJvxSrc.getNumElements();
                        if (pdVectorArray2 != null && n2 > 0) {
                            PdVector[][] pdVectorArray3 = new PdVector[n2][];
                            int n3 = 0;
                            PiVector[] piVectorArray4 = pgJvxSrc.getElements();
                            int n4 = 0;
                            while (n4 < n2) {
                                int n5 = piVectorArray4[n4].getSize();
                                pdVectorArray3[n4] = new PdVector[n5];
                                int n6 = 0;
                                while (n6 < n5) {
                                    pdVectorArray3[n4][n6] = pdVectorArray2[n3++];
                                    ++n6;
                                }
                                ++n4;
                            }
                            if (n3 != pdVectorArray2.length) {
                                PsDebug.error("element texture coordinates do not match elements.");
                                pgJvxSrc.setElementTextures(null);
                            } else {
                                pgJvxSrc.setElementTextures(pdVectorArray3);
                            }
                        }
                        if ((string9 = PsXmlSrc.getRsrc(psXmlNode8, "image")) != null) {
                            pgJvxSrc.setTextureImage(string9);
                        }
                    }
                }
                if ((object3 = PsXmlSrc.getRsrcNodes(psXmlNodeArray[n], "vectorField")) != null && ((PsXmlNode[])object3).length > 0) {
                    pgJvxSrc.setNumVectorFields(((PsXmlNode[])object3).length);
                    int n7 = 0;
                    while (n7 < ((PsXmlNode[])object3).length) {
                        pgJvxSrc.setVectorFieldName(n7, object3[n7].getAttribute("name"));
                        object2 = object3[n7].getAttribute("base");
                        if (object2 != null) {
                            if (object2.equals("vertex")) {
                                pgJvxSrc.setVectorElementBased(n7, false);
                            } else if (object2.equals("element")) {
                                pgJvxSrc.setVectorElementBased(n7, true);
                            }
                        }
                        pgJvxSrc.setVectorArrowVisible(n7, PgJvxLoader.parseVisibility(object3[n7].getAttribute("arrow")) == 1);
                        piVectorArray = PsXmlSrc.getRsrcNode(object3[n7], "vectors");
                        if (piVectorArray != null) {
                            int n8;
                            pdVectorArray = PsXmlLoader.parseDoubleList((PsXmlNode)piVectorArray, "v", null);
                            if (pdVectorArray != null && (n8 = pdVectorArray.length) > 0) {
                                pgJvxSrc.setNumVectors(n7, n8, pdVectorArray[0].getSize());
                                pgJvxSrc.setVectors(n7, pdVectorArray);
                            }
                            if ((d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)piVectorArray, "thickness")) != 0.0) {
                                pgJvxSrc.setGlobalVectorSize(n7, d);
                            }
                            if ((d = PsXmlSrc.getRsrcAsDouble((PsXmlNode)piVectorArray, "length")) != 0.0) {
                                pgJvxSrc.setGlobalVectorLength(n7, d);
                            }
                            if ((color = PsXmlLoader.parseColorRGB((PsXmlNode)piVectorArray, "color")) != null) {
                                pgJvxSrc.setGlobalVectorColor(n7, color);
                            }
                        }
                        ++n7;
                    }
                }
                ++n;
            }
        } else {
            PsDebug.warning("missing references node.");
        }
        return pgJvxSrcArray;
    }

    public static PgJvxSrc[] read(String string) {
        PsXmlSrc psXmlSrc = PsXmlLoader.read(string);
        if (psXmlSrc == null) {
            PsDebug.warning("failed to parse XML in file = " + string);
            return null;
        }
        PgJvxSrc[] pgJvxSrcArray = PgJvxLoader.parseRsrcTree(psXmlSrc);
        if (pgJvxSrcArray == null) {
            PsDebug.warning("failed to interpret content of JVX file = " + string);
            return null;
        }
        int n = 0;
        while (n < pgJvxSrcArray.length) {
            if (pgJvxSrcArray[n].getName() == null) {
                pgJvxSrcArray[n].setName(PsUtil.getFileBaseName(string));
            }
            ++n;
        }
        return pgJvxSrcArray;
    }

    private static boolean hasAttribute(String string, String string2) {
        return string != null && string.equalsIgnoreCase(string2);
    }

    private static int parseVisibility(String string) {
        if (string == null) {
            return -1;
        }
        if (string.equalsIgnoreCase("show")) {
            return 1;
        }
        return 0;
    }

    public static String write(PgJvxSrc[] pgJvxSrcArray) {
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0) {
            PsDebug.warning("missing geometries.");
            return null;
        }
        PsXmlSrc psXmlSrc = PgJvxLoader.fillRsrcTree(null, pgJvxSrcArray);
        if (psXmlSrc == null) {
            PsDebug.warning("failed to generate XML tree");
            return null;
        }
        return PsXmlLoader.write(psXmlSrc);
    }

    protected static PsXmlSrc fillRsrcTree(PsXmlSrc psXmlSrc, PgJvxSrc[] pgJvxSrcArray) {
        PsXmlNode psXmlNode;
        PsXmlNode psXmlNode2;
        PsXmlNode psXmlNode3;
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0) {
            return null;
        }
        if (psXmlSrc == null) {
            psXmlSrc = new PsXmlSrc();
        }
        if ((psXmlNode3 = psXmlSrc.getRootNode()) == null) {
            psXmlNode3 = new PsXmlNode("jvx-model");
            psXmlSrc.setRootNode(psXmlNode3);
        }
        PgJvxSrc pgJvxSrc = pgJvxSrcArray[0];
        psXmlSrc.setDocName("jvx-model");
        PsXmlNode[] psXmlNodeArray = new PsXmlNode[2];
        psXmlNodeArray[0] = psXmlNode3.addChild("meta");
        psXmlNodeArray[0].addAttribute("generator", PsConfig.getProgram() + " v." + PsConfig.getVersion());
        psXmlNodeArray[1] = psXmlNode3.addChild("meta");
        psXmlNodeArray[1].addAttribute("date", new Date().toString());
        PsXmlNode psXmlNode4 = psXmlNode3.addChild("version", pgJvxSrc.getVersion());
        psXmlNode4.addAttribute("type", pgJvxSrc.getVersionType());
        if (pgJvxSrc.getTitle() != null) {
            psXmlNode3.addChild("title", pgJvxSrc.getTitle());
        } else {
            psXmlNode3.addChild("title", pgJvxSrc.getName());
        }
        PsAuthorInfo psAuthorInfo = pgJvxSrc.getAuthors();
        if (psAuthorInfo != null) {
            PsXmlNode psXmlNode5 = PsXmlSrc.assureChild(psXmlNode3, "authors");
            psAuthorInfo.getXmlNode(psXmlNode5);
        }
        if (pgJvxSrc.getAbstract() != null) {
            psXmlNode2 = psXmlNode3.addChild("description");
            psXmlNode2.addChild("abstract", pgJvxSrc.getAbstract());
            if (pgJvxSrc.getDetail() != null) {
                psXmlNode2.addChild("detail", pgJvxSrc.getDetail());
            }
            if (pgJvxSrc.getKeywords() != null) {
                psXmlNode = psXmlNode2.addChild("keywords");
                int n = 0;
                while (n < pgJvxSrc.getKeywords().length) {
                    psXmlNode.addChild("keyword", pgJvxSrc.getKeyword(n));
                    ++n;
                }
            }
            if (pgJvxSrc.getPrimary() != null) {
                psXmlNode = psXmlNode2.addChild("msc2000");
                psXmlNode.addChild("primary", pgJvxSrc.getPrimary());
                if (pgJvxSrc.getSecondary() != null) {
                    psXmlNode.addChild("secondary", pgJvxSrc.getSecondary());
                }
            }
            if (pgJvxSrc.getSoftware() != null) {
                psXmlNode2.addChild("software", pgJvxSrc.getSoftware());
            }
        }
        psXmlNode2 = psXmlNode3.addChild("geometries");
        if (pgJvxSrcArray != null) {
            int n = 0;
            while (n < pgJvxSrcArray.length) {
                Object object;
                PsXmlNode psXmlNode6;
                Serializable serializable;
                PdVector[] pdVectorArray;
                pgJvxSrc = pgJvxSrcArray[n];
                psXmlNode = psXmlNode2.addChild("geometry");
                psXmlNode.addAttribute("name", pgJvxSrc.getName());
                if (pgJvxSrc.isShowingTitle()) {
                    psXmlNode.addAttribute("title", "show");
                }
                if (!pgJvxSrc.isVisible()) {
                    psXmlNode.addAttribute("visible", "hide");
                }
                if (pgJvxSrc.getType() == 30 || pgJvxSrc.getType() == 31 || pgJvxSrc.getType() == 32 || pgJvxSrc.getType() == 33) {
                    pdVectorArray = psXmlNode.addChild("pointSet");
                    pdVectorArray.addAttribute("dim", String.valueOf(pgJvxSrc.getDimOfVertices()));
                    if (pgJvxSrc.isShowingVertices()) {
                        pdVectorArray.addAttribute("point", "show");
                    } else if (!pgJvxSrc.isShowingVertices()) {
                        pdVectorArray.addAttribute("point", "hide");
                    }
                    if (pgJvxSrc.isShowingVertexColors() && pgJvxSrc.getVertexColors() != null) {
                        pdVectorArray.addAttribute("color", "show");
                    }
                    if (pgJvxSrc.isShowingVertexNormals() && pgJvxSrc.getVertexNormals() != null) {
                        pdVectorArray.addAttribute("normal", "show");
                    }
                    if (pgJvxSrc.isShowingVertexNormalArrow() && pgJvxSrc.getVertexNormals() != null) {
                        pdVectorArray.addAttribute("normalArrow", "show");
                    }
                    if (pgJvxSrc.isShowingIndices()) {
                        pdVectorArray.addAttribute("label", "show");
                    }
                    serializable = pdVectorArray.addChild("points");
                    PsXmlLoader.addVectorList((PsXmlNode)serializable, "p", pgJvxSrc.getVertices(), pgJvxSrc.getNumVertices());
                    if (pgJvxSrc.getGlobalVertexSize() != 0.0) {
                        ((PsXmlNode)serializable).addChild("thickness", pgJvxSrc.getGlobalVertexSize());
                    }
                    if (pgJvxSrc.getGlobalVertexColor() != null) {
                        PsXmlLoader.addColor((PsXmlNode)serializable, "color", pgJvxSrc.getGlobalVertexColor());
                    }
                    if (pgJvxSrc.getGlobalVertexTagColor() != null) {
                        PsXmlLoader.addColor((PsXmlNode)serializable, "colorTag", pgJvxSrc.getGlobalVertexTagColor());
                    }
                    if (pgJvxSrc.getVertexColors() != null) {
                        psXmlNode6 = pdVectorArray.addChild("colors");
                        psXmlNode6.addAttribute("type", "rgb");
                        PsXmlLoader.addVectorList(psXmlNode6, "c", pgJvxSrc.getVertexColors(), pgJvxSrc.getNumVertices());
                    }
                    if (pgJvxSrc.getVertexNormals() != null) {
                        psXmlNode6 = pdVectorArray.addChild("normals");
                        PsXmlLoader.addVectorList(psXmlNode6, "n", pgJvxSrc.getVertexNormals(), pgJvxSrc.getNumVertices());
                        if (pgJvxSrc.getGlobalVertexNormalSize() != 0.0) {
                            psXmlNode6.addChild("thickness", pgJvxSrc.getGlobalVertexNormalSize());
                        }
                        if (pgJvxSrc.getGlobalVertexNormalLength() != 0.0) {
                            psXmlNode6.addChild("length", pgJvxSrc.getGlobalVertexNormalLength());
                        }
                        if (pgJvxSrc.getGlobalVertexNormalColor() != null) {
                            PsXmlLoader.addColor(psXmlNode6, "color", pgJvxSrc.getGlobalVertexNormalColor());
                        }
                    }
                    if (pgJvxSrc.getVertexTextures() != null) {
                        psXmlNode6 = pdVectorArray.addChild("textures");
                        PsXmlLoader.addVectorList(psXmlNode6, "t", pgJvxSrc.getVertexTextures(), pgJvxSrc.getNumVertices());
                    }
                }
                if (pgJvxSrc.getType() == 31 || pgJvxSrc.getType() == 32) {
                    pdVectorArray = psXmlNode.addChild("lineSet");
                    if (pgJvxSrc.isShowingPolygons()) {
                        pdVectorArray.addAttribute("line", "show");
                    } else if (!pgJvxSrc.isShowingPolygons()) {
                        pdVectorArray.addAttribute("line", "hide");
                    }
                    if (pgJvxSrc.isShowingPolygonStartArrow()) {
                        pdVectorArray.addAttribute("arrowStart", "show");
                    }
                    if (pgJvxSrc.isShowingPolygonEndArrow()) {
                        pdVectorArray.addAttribute("arrow", "show");
                    }
                    if (pgJvxSrc.isShowingPolygonColors()) {
                        pdVectorArray.addAttribute("color", "show");
                    }
                    if (pgJvxSrc.isShowingPolygonNormals()) {
                        pdVectorArray.addAttribute("normal", "show");
                    }
                    if (pgJvxSrc.isShowingPolygonNormalArrow()) {
                        pdVectorArray.addAttribute("normalArrow", "show");
                    }
                    serializable = pdVectorArray.addChild("lines");
                    PsXmlLoader.addVectorList((PsXmlNode)serializable, "l", pgJvxSrc.getPolygons(), pgJvxSrc.getNumPolygons());
                    if (pgJvxSrc.getGlobalPolygonSize() != 0.0) {
                        ((PsXmlNode)serializable).addChild("thickness", pgJvxSrc.getGlobalPolygonSize());
                    }
                    if (pgJvxSrc.getGlobalPolygonColor() != null) {
                        PsXmlLoader.addColor((PsXmlNode)serializable, "color", pgJvxSrc.getGlobalPolygonColor());
                    }
                    if (pgJvxSrc.getGlobalPolygonTagColor() != null) {
                        PsXmlLoader.addColor((PsXmlNode)serializable, "colorTag", pgJvxSrc.getGlobalPolygonTagColor());
                    }
                    if (pgJvxSrc.getPolygonColors() != null) {
                        psXmlNode6 = pdVectorArray.addChild("colors");
                        psXmlNode6.addAttribute("type", "rgb");
                        PsXmlLoader.addVectorList(psXmlNode6, "c", pgJvxSrc.getPolygonColors(), pgJvxSrc.getNumPolygons());
                    }
                    if (pgJvxSrc.getPolygonNormals() != null) {
                        psXmlNode6 = pdVectorArray.addChild("normals");
                        PsXmlLoader.addVectorList(psXmlNode6, "n", pgJvxSrc.getPolygonNormals(), pgJvxSrc.getNumPolygons());
                        if (pgJvxSrc.getGlobalPolygonNormalSize() != 0.0) {
                            psXmlNode6.addChild("thickness", pgJvxSrc.getGlobalPolygonNormalSize());
                        }
                        if (pgJvxSrc.getGlobalPolygonNormalLength() != 0.0) {
                            psXmlNode6.addChild("length", pgJvxSrc.getGlobalPolygonNormalLength());
                        }
                        if (pgJvxSrc.getGlobalPolygonNormalColor() != null) {
                            PsXmlLoader.addColor(psXmlNode6, "color", pgJvxSrc.getGlobalPolygonNormalColor());
                        }
                    }
                }
                if (pgJvxSrc.getType() == 33) {
                    pdVectorArray = psXmlNode.addChild("faceSet");
                    if (pgJvxSrc.isShowingEdges()) {
                        pdVectorArray.addAttribute("edge", "show");
                    } else if (!pgJvxSrc.isShowingEdges()) {
                        pdVectorArray.addAttribute("edge", "hide");
                    }
                    if (pgJvxSrc.isShowingElements()) {
                        pdVectorArray.addAttribute("face", "show");
                    } else if (!pgJvxSrc.isShowingElements()) {
                        pdVectorArray.addAttribute("face", "hide");
                    }
                    if (pgJvxSrc.isShowingElementColors() && pgJvxSrc.getElementColors() != null) {
                        pdVectorArray.addAttribute("color", "show");
                    }
                    if (pgJvxSrc.isShowingElementBackColor()) {
                        pdVectorArray.addAttribute("backcolor", "show");
                    }
                    if (pgJvxSrc.isShowingElementNormals() && pgJvxSrc.getElementNormals() != null) {
                        pdVectorArray.addAttribute("normal", "show");
                    }
                    if (pgJvxSrc.isShowingElementNormalArrow() && pgJvxSrc.getElementNormals() != null) {
                        pdVectorArray.addAttribute("normalArrow", "show");
                    }
                    if (pgJvxSrc.isShowingVertexTexture() && pgJvxSrc.getVertexTextures() != null || pgJvxSrc.isShowingElementTexture() && pgJvxSrc.getElementTextures() != null) {
                        pdVectorArray.addAttribute("texture", "show");
                    }
                    if (!pgJvxSrc.isShowingBackface()) {
                        pdVectorArray.addAttribute("backface", "hide");
                    }
                    if (pgJvxSrc.isShowingOutline()) {
                        pdVectorArray.addAttribute("outline", "show");
                    }
                    serializable = pdVectorArray.addChild("faces");
                    PsXmlLoader.addVectorList((PsXmlNode)serializable, "f", pgJvxSrc.getElements(), pgJvxSrc.getNumElements());
                    if (pgJvxSrc.getGlobalElementColor() != null) {
                        PsXmlLoader.addColor((PsXmlNode)serializable, "color", pgJvxSrc.getGlobalElementColor());
                    }
                    if (pgJvxSrc.isShowingElementBackColor()) {
                        PsXmlLoader.addColor((PsXmlNode)serializable, "colorBack", pgJvxSrc.getGlobalElementBackColor());
                    }
                    if (pgJvxSrc.getGlobalElementTagColor() != null) {
                        PsXmlLoader.addColor((PsXmlNode)serializable, "colorTag", pgJvxSrc.getGlobalElementTagColor());
                    }
                    if (pgJvxSrc.getNeighbours() != null) {
                        psXmlNode6 = pdVectorArray.addChild("neighbours");
                        PsXmlLoader.addVectorList(psXmlNode6, "nb", pgJvxSrc.getNeighbours(), pgJvxSrc.getNumElements());
                    }
                    psXmlNode6 = pdVectorArray.addChild("edges");
                    if (pgJvxSrc.getNumEdges() > 0) {
                        PsXmlLoader.addVectorList(psXmlNode6, "e", pgJvxSrc.getEdges(), pgJvxSrc.getNumEdges());
                    }
                    if (pgJvxSrc.getGlobalEdgeSize() != 0.0) {
                        psXmlNode6.addChild("thickness", pgJvxSrc.getGlobalEdgeSize());
                    }
                    if (pgJvxSrc.getGlobalEdgeColor() != null) {
                        PsXmlLoader.addColor(psXmlNode6, "color", pgJvxSrc.getGlobalEdgeColor());
                    }
                    if (pgJvxSrc.getGlobalEdgeTagColor() != null) {
                        PsXmlLoader.addColor(psXmlNode6, "colorTag", pgJvxSrc.getGlobalEdgeTagColor());
                    }
                    if (pgJvxSrc.getElementColors() != null) {
                        object = pdVectorArray.addChild("colors");
                        ((PsXmlNode)object).addAttribute("type", "rgb");
                        PsXmlLoader.addVectorList((PsXmlNode)object, "c", pgJvxSrc.getElementColors(), pgJvxSrc.getNumElements());
                    }
                    if (pgJvxSrc.getElementNormals() != null) {
                        object = pdVectorArray.addChild("normals");
                        PsXmlLoader.addVectorList((PsXmlNode)object, "n", pgJvxSrc.getElementNormals(), pgJvxSrc.getNumElements());
                        if (pgJvxSrc.getGlobalElementNormalSize() != 0.0) {
                            ((PsXmlNode)object).addChild("thickness", pgJvxSrc.getGlobalElementNormalSize());
                        }
                        if (pgJvxSrc.getGlobalElementNormalLength() != 0.0) {
                            ((PsXmlNode)object).addChild("length", pgJvxSrc.getGlobalElementNormalLength());
                        }
                        if (pgJvxSrc.getGlobalElementNormalColor() != null) {
                            PsXmlLoader.addColor((PsXmlNode)object, "color", pgJvxSrc.getGlobalElementNormalColor());
                        }
                    }
                    if (pgJvxSrc.getElementTextures() != null) {
                        object = pdVectorArray.addChild("textures");
                        PsXmlLoader.addVectorList((PsXmlNode)object, "t", pgJvxSrc.getElementTextures());
                    }
                }
                if (pgJvxSrc.getNumVectorFields() != 0) {
                    int n2 = pgJvxSrc.getNumVectorFields();
                    int n3 = 0;
                    while (n3 < n2) {
                        psXmlNode6 = psXmlNode.addChild("vectorField");
                        if (pgJvxSrc.getVectorFieldName(n3) != null) {
                            psXmlNode6.addAttribute("name", pgJvxSrc.getVectorFieldName(n3));
                        }
                        if (pgJvxSrc.isVectorArrowVisible(n3)) {
                            psXmlNode6.addAttribute("arrow", "show");
                        } else if (!pgJvxSrc.isVectorArrowVisible(n3)) {
                            psXmlNode6.addAttribute("arrow", "hide");
                        }
                        if (pgJvxSrc.isVectorElementBased(n3)) {
                            psXmlNode6.addAttribute("base", "element");
                        } else {
                            psXmlNode6.addAttribute("base", "vertex");
                        }
                        object = pgJvxSrc.getVectors(n3);
                        if (object == null || ((PdVector[])object).length == 0) {
                            PsDebug.warning("missing vectors of vector field[" + n3 + "]");
                        } else {
                            PsXmlNode psXmlNode7 = psXmlNode6.addChild("vectors");
                            PsXmlLoader.addVectorList(psXmlNode7, "v", (PdVector[])object, ((PdVector[])object).length);
                            if (pgJvxSrc.getGlobalVectorColor(n3) != null) {
                                PsXmlLoader.addColor(psXmlNode7, "color", pgJvxSrc.getGlobalVectorColor(n3));
                            }
                            if (pgJvxSrc.getGlobalVectorLength(n3) != 0.0) {
                                psXmlNode7.addChild("length", pgJvxSrc.getGlobalVectorLength(n3));
                            }
                            if (pgJvxSrc.getGlobalVectorSize(n3) != 0.0) {
                                psXmlNode7.addChild("thickness", pgJvxSrc.getGlobalVectorSize(n3));
                            }
                            if (pgJvxSrc.getVectorFieldColors(n3) != null) {
                                PsXmlNode psXmlNode8 = psXmlNode6.addChild("colors");
                                psXmlNode8.addAttribute("type", "rgb");
                                PsXmlLoader.addVectorList(psXmlNode8, "c", pgJvxSrc.getVectorFieldColors(n3), ((PdVector[])object).length);
                            }
                        }
                        ++n3;
                    }
                }
                if ((pdVectorArray = pgJvxSrc.getBounds()) != null && pdVectorArray.length == 2) {
                    PsXmlNode psXmlNode9 = psXmlNode.addChild("bndbox");
                    if (pgJvxSrc.isShowingBndBox()) {
                        psXmlNode9.addAttribute("visible", "show");
                    } else {
                        psXmlNode9.addAttribute("visible", "hide");
                    }
                    psXmlNode9.addChild("p", PuData.toString(pdVectorArray[0].getEntries()));
                    psXmlNode9.addChild("p", PuData.toString(pdVectorArray[1].getEntries()));
                }
                if ((serializable = pgJvxSrc.getCenter()) != null) {
                    psXmlNode6 = psXmlNode.addChild("center");
                    if (pgJvxSrc.isShowingCenter()) {
                        psXmlNode6.addAttribute("visible", "show");
                    } else {
                        psXmlNode6.addAttribute("visible", "hide");
                    }
                    psXmlNode6.addChild("p", PuData.toString(((PdVector)serializable).getEntries()));
                }
                ++n;
            }
        }
        return psXmlSrc;
    }
}

