/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.Component;
import java.awt.Image;
import java.awt.List;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.io.StringReader;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygonSet;
import jv.geom.PgTetraSet;
import jv.loader.PgAnsLoader;
import jv.loader.PgBdLoader;
import jv.loader.PgByuLoader;
import jv.loader.PgDxfLoader;
import jv.loader.PgExport_Dialog;
import jv.loader.PgFeLoader;
import jv.loader.PgJvxLoader;
import jv.loader.PgMacroPatch;
import jv.loader.PgMapleLoader;
import jv.loader.PgMathLoader;
import jv.loader.PgObjLoader;
import jv.loader.PgOffLoader;
import jv.loader.PgWrlLoader;
import jv.loader.PsXmlLoader;
import jv.loader.PsXmlNode;
import jv.loader.PsXmlSrc;
import jv.loader.PvDisplayLoader;
import jv.loader.PvDisplayOption;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.thirdParty.acmeEncoders.GifEncoder;
import jv.thirdParty.acmeEncoders.ImageEncoder;
import jv.thirdParty.acmeEncoders.PpmEncoder;

public class PgLoader {
    public static String saveToString(PgGeometryIf[] pgGeometryIfArray, String string) {
        if (pgGeometryIfArray == null || pgGeometryIfArray.length == 0) {
            PsDebug.error("missing geometry to save.");
            return null;
        }
        if (string == null) {
            PsDebug.error("missing file format.");
            return null;
        }
        String string2 = null;
        if (string.equalsIgnoreCase("byu") || string.equalsIgnoreCase("dxf") || string.equalsIgnoreCase("fe") || string.equalsIgnoreCase("mgs") || string.equalsIgnoreCase("mpl") || string.equalsIgnoreCase("obj") || string.equalsIgnoreCase("off")) {
            PgJvxSrc pgJvxSrc;
            if (pgGeometryIfArray[0] instanceof PgJvxSrc) {
                pgJvxSrc = (PgJvxSrc)pgGeometryIfArray[0];
            } else {
                pgJvxSrc = pgGeometryIfArray[0].getJvx();
                if (pgJvxSrc == null) {
                    PsDebug.error("failed to create jvx source from geometry.");
                    return null;
                }
            }
            if (string.equalsIgnoreCase("byu")) {
                string2 = PgByuLoader.write(pgJvxSrc);
            } else if (string.equalsIgnoreCase("fe")) {
                string2 = PgFeLoader.write(pgJvxSrc);
            } else if (string.equalsIgnoreCase("dxf")) {
                string2 = PgDxfLoader.write(pgJvxSrc);
            } else if (string.equalsIgnoreCase("mgs")) {
                string2 = PgMathLoader.write(pgJvxSrc);
            } else if (string.equalsIgnoreCase("mpl")) {
                string2 = PgMapleLoader.write(pgJvxSrc);
            } else if (string.equalsIgnoreCase("obj")) {
                string2 = PgObjLoader.write(pgJvxSrc);
            } else if (string.equalsIgnoreCase("off")) {
                string2 = PgOffLoader.write(pgJvxSrc);
            }
        } else {
            PgJvxSrc[] pgJvxSrcArray = new PgJvxSrc[pgGeometryIfArray.length];
            int n = 0;
            while (n < pgGeometryIfArray.length) {
                if (pgGeometryIfArray[n] == null) {
                    PsDebug.error("null geometry found at index i = " + n);
                } else if (pgGeometryIfArray[n] instanceof PgJvxSrc) {
                    pgJvxSrcArray[n] = (PgJvxSrc)pgGeometryIfArray[n];
                } else {
                    pgJvxSrcArray[n] = pgGeometryIfArray[n].getJvx();
                    if (pgJvxSrcArray[n] == null) {
                        PsDebug.error("failed to create jvx source of geom = " + pgGeometryIfArray[n].getName());
                    }
                }
                ++n;
            }
            if (string.equalsIgnoreCase("jvx")) {
                string2 = PgJvxLoader.write(pgJvxSrcArray);
            } else if (string.equalsIgnoreCase("wrl")) {
                PgWrlLoader pgWrlLoader = new PgWrlLoader();
                string2 = PgWrlLoader.write(pgJvxSrcArray);
            } else {
                PsDebug.warning("unknown export filter = " + string);
                return null;
            }
        }
        if (string2 == null) {
            PsDebug.warning("error during export.");
            return null;
        }
        return string2;
    }

    public static boolean readAll(List list, String string) throws IOException {
        PsXmlNode psXmlNode;
        Object object;
        PsXmlSrc psXmlSrc = PsXmlLoader.read(string);
        if (psXmlSrc == null) {
            PsDebug.warning("failed to read list from file = " + string, list);
            return false;
        }
        PsXmlNode psXmlNode2 = psXmlSrc.getRootNode();
        if (psXmlNode2 == null) {
            PsDebug.warning("missing root node when reading list from file = " + string, list);
            return false;
        }
        list.removeAll();
        PsXmlNode psXmlNode3 = psXmlNode2.getChild("directories");
        if (psXmlNode3 == null) {
            PsDebug.warning("directory contains no directory section, dir = " + string);
            return false;
        }
        PsXmlNode[] psXmlNodeArray = psXmlNode3.getChildren("directory");
        if (psXmlNodeArray != null) {
            PsDebug.message("directory contains no subdirectories, dir = " + string);
            int n = 0;
            while (n < psXmlNodeArray.length) {
                object = psXmlNodeArray[n].getChild("name");
                if (object == null) {
                    PsDebug.warning("directory has no name, dir = " + string);
                }
                list.add(((PsXmlNode)object).getContent());
                ++n;
            }
        }
        if ((psXmlNode = psXmlNode2.getChild("models")) == null) {
            PsDebug.warning("directory contains no directory section, model = " + string);
            return false;
        }
        object = psXmlNode.getChildren("model");
        if (object != null) {
            int n = 0;
            while (n < ((PsXmlNode[])object).length) {
                list.add(object[n].getContent());
                ++n;
            }
        }
        return true;
    }

    public static PgGeometry[] load(String string, String string2) {
        return PgLoader.load(null, string, string2);
    }

    public static PgGeometry[] load(PgGeometry[] pgGeometryArray, String string, String string2) {
        if (string == null) {
            PsDebug.warning("missing data");
            return null;
        }
        if (string2 == null) {
            PsDebug.warning("missing format of data");
            return null;
        }
        string2 = string2.toLowerCase();
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        if (string2.indexOf("mgs") != -1) {
            PgMathLoader pgMathLoader = new PgMathLoader();
            PgJvxSrc[] pgJvxSrcArray = pgMathLoader.convert(pgMathLoader.read(bufferedReader));
            if (pgJvxSrcArray == null) {
                return null;
            }
            pgGeometryArray = PgLoader.assureLength(pgGeometryArray, pgJvxSrcArray.length);
            int n = 0;
            while (n < pgJvxSrcArray.length) {
                pgGeometryArray[n] = PgLoader.assureType(pgGeometryArray[n], pgJvxSrcArray[n].getType(), pgJvxSrcArray[n].getDimOfVertices());
                pgGeometryArray[n].setJvx(pgJvxSrcArray[n]);
                ++n;
            }
        } else if (string2.indexOf("mpl") != -1) {
            PgJvxSrc[] pgJvxSrcArray = PgMapleLoader.read(bufferedReader);
            if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0) {
                return null;
            }
            pgGeometryArray = PgLoader.assureLength(pgGeometryArray, pgJvxSrcArray.length);
            int n = 0;
            while (n < pgJvxSrcArray.length) {
                pgGeometryArray[n] = PgLoader.assureType(pgGeometryArray[n], pgJvxSrcArray[n].getType(), pgJvxSrcArray[n].getDimOfVertices());
                pgGeometryArray[n].setJvx(pgJvxSrcArray[n]);
                ++n;
            }
            n = 0;
            while (n < pgJvxSrcArray.length) {
                switch (pgJvxSrcArray[n].getType()) {
                    case 30: {
                        PgPointSet pgPointSet = (PgPointSet)pgGeometryArray[n];
                        pgPointSet.makeVertexColorsFromXYZ();
                        pgPointSet.showVertexColors(true);
                        break;
                    }
                    case 33: {
                        PgElementSet pgElementSet = (PgElementSet)pgGeometryArray[n];
                        pgElementSet.makeElementColorsFromXYZ();
                        pgElementSet.showElementColors(true);
                        break;
                    }
                    case 32: {
                        PgPolygonSet pgPolygonSet = (PgPolygonSet)pgGeometryArray[n];
                        pgPolygonSet.makePolygonColorsFromXYZ();
                        pgPolygonSet.showPolygonColors(true);
                    }
                }
                ++n;
            }
        } else {
            PsDebug.warning("unknown file extension");
            return null;
        }
        return pgGeometryArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PgGeometry[] load(PgGeometry[] pgGeometryArray, String string) {
        if (string == null) {
            PsDebug.warning("missing fileName");
            return null;
        }
        String string2 = PsUtil.getFileExtension(string);
        if (string2 == null) {
            PsDebug.warning("missing extension in file=" + string);
            return null;
        }
        if ((string2 = string2.toLowerCase()).indexOf("bd") != -1) {
            PgBdLoader pgBdLoader = new PgBdLoader();
            if (!pgBdLoader.read(string)) return null;
            pgGeometryArray = PgLoader.assureLength(pgGeometryArray, 1);
            pgGeometryArray[0] = PgLoader.assureType(pgGeometryArray[0], 33, 3);
            pgGeometryArray[0].setName(PsUtil.getFileBaseName(string));
            PgElementSet pgElementSet = (PgElementSet)pgGeometryArray[0];
            pgElementSet.init();
            int n = 0;
            while (n < pgBdLoader.getNumPatches()) {
                PgMacroPatch pgMacroPatch = pgBdLoader.getPatch(n);
                PgElementSet pgElementSet2 = new PgElementSet(3);
                pgElementSet2 = pgMacroPatch.buildElementSet(pgElementSet2);
                pgElementSet.merge(pgElementSet2);
                ++n;
            }
            pgElementSet.makeNeighbour();
            return pgGeometryArray;
        }
        if (string2.indexOf("ans") != -1) {
            PgAnsLoader pgAnsLoader = new PgAnsLoader();
            PgJvxSrc pgJvxSrc = pgAnsLoader.read(string);
            if (pgJvxSrc == null) return null;
            pgGeometryArray = PgLoader.assureLength(pgGeometryArray, 1);
            pgGeometryArray[0] = PgLoader.assureType(pgGeometryArray[0], pgJvxSrc.getType(), pgJvxSrc.getDimOfVertices());
            pgGeometryArray[0].setJvx(pgJvxSrc);
            switch (pgJvxSrc.getType()) {
                case 33: {
                    PgElementSet pgElementSet = (PgElementSet)pgGeometryArray[0];
                    pgElementSet.makeNeighbour();
                    return pgGeometryArray;
                }
                case 34: {
                    PgTetraSet pgTetraSet = (PgTetraSet)pgGeometryArray[0];
                    pgTetraSet.makeNeighbour();
                    return pgGeometryArray;
                }
                default: {
                    return pgGeometryArray;
                }
            }
        }
        if (string2.indexOf("byu") != -1) {
            PgJvxSrc pgJvxSrc = PgByuLoader.read(string);
            if (pgJvxSrc == null) return null;
            pgGeometryArray = PgLoader.assureLength(pgGeometryArray, 1);
            pgGeometryArray[0] = PgLoader.assureType(pgGeometryArray[0], 33, pgJvxSrc.getDimOfVertices());
            pgGeometryArray[0].setJvx(pgJvxSrc);
            switch (pgJvxSrc.getType()) {
                case 33: {
                    PgElementSet pgElementSet = (PgElementSet)pgGeometryArray[0];
                    pgElementSet.makeNeighbour();
                    return pgGeometryArray;
                }
                default: {
                    return pgGeometryArray;
                }
            }
        }
        if (string2.indexOf("dxf") != -1) {
            PgDxfLoader pgDxfLoader = new PgDxfLoader();
            PgJvxSrc pgJvxSrc = pgDxfLoader.read(string);
            PgJvxSrc[] pgJvxSrcArray = new PgJvxSrc[]{pgJvxSrc};
            if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0) {
                return null;
            }
            pgGeometryArray = PgLoader.assureLength(pgGeometryArray, pgJvxSrcArray.length);
            int n = 0;
            while (n < pgJvxSrcArray.length) {
                pgGeometryArray[n] = PgLoader.assureType(pgGeometryArray[n], pgJvxSrcArray[n].getType(), pgJvxSrcArray[n].getDimOfVertices());
                pgGeometryArray[n].setJvx(pgJvxSrcArray[n]);
                switch (pgJvxSrcArray[n].getType()) {
                    case 33: {
                        PgElementSet pgElementSet = (PgElementSet)pgGeometryArray[n];
                        pgElementSet.makeNeighbour();
                    }
                }
                ++n;
            }
            return pgGeometryArray;
        }
        if (string2.indexOf("fe") != -1) {
            PgFeLoader pgFeLoader = new PgFeLoader();
            PgJvxSrc pgJvxSrc = pgFeLoader.read(string);
            if (pgJvxSrc == null) return null;
            pgGeometryArray = PgLoader.assureLength(pgGeometryArray, 1);
            pgGeometryArray[0] = PgLoader.assureType(pgGeometryArray[0], pgJvxSrc.getType(), pgJvxSrc.getDimOfVertices());
            pgGeometryArray[0].setJvx(pgJvxSrc);
            return pgGeometryArray;
        }
        if (string2.indexOf("jvx") != -1) {
            PgJvxSrc[] pgJvxSrcArray = PgJvxLoader.read(string);
            if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0) {
                return null;
            }
            pgGeometryArray = PgLoader.assureLength(pgGeometryArray, pgJvxSrcArray.length);
            int n = 0;
            while (n < pgJvxSrcArray.length) {
                pgGeometryArray[n] = PgLoader.assureType(pgGeometryArray[n], pgJvxSrcArray[n].getType(), pgJvxSrcArray[n].getDimOfVertices());
                pgGeometryArray[n].setJvx(pgJvxSrcArray[n]);
                ++n;
            }
            return pgGeometryArray;
        }
        if (string2.indexOf("mgs") != -1) {
            PgMathLoader pgMathLoader = new PgMathLoader();
            PgJvxSrc[] pgJvxSrcArray = pgMathLoader.read(string);
            if (pgJvxSrcArray == null) {
                return null;
            }
            pgGeometryArray = PgLoader.assureLength(pgGeometryArray, pgJvxSrcArray.length);
            int n = 0;
            while (n < pgJvxSrcArray.length) {
                pgGeometryArray[n] = PgLoader.assureType(pgGeometryArray[n], pgJvxSrcArray[n].getType(), pgJvxSrcArray[n].getDimOfVertices());
                pgGeometryArray[n].setJvx(pgJvxSrcArray[n]);
                switch (pgJvxSrcArray[n].getType()) {
                    case 33: {
                        PgElementSet pgElementSet = (PgElementSet)pgGeometryArray[n];
                        pgElementSet.makeNeighbour();
                    }
                }
                ++n;
            }
            return pgGeometryArray;
        }
        if (string2.indexOf("mpl") != -1) {
            PgJvxSrc[] pgJvxSrcArray = PgMapleLoader.read(string);
            if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0) {
                return null;
            }
            pgGeometryArray = PgLoader.assureLength(pgGeometryArray, pgJvxSrcArray.length);
            int n = 0;
            while (n < pgJvxSrcArray.length) {
                pgGeometryArray[n] = PgLoader.assureType(pgGeometryArray[n], pgJvxSrcArray[n].getType(), pgJvxSrcArray[n].getDimOfVertices());
                pgGeometryArray[n].setJvx(pgJvxSrcArray[n]);
                switch (pgJvxSrcArray[n].getType()) {
                    case 33: {
                        PgElementSet pgElementSet = (PgElementSet)pgGeometryArray[n];
                        pgElementSet.makeNeighbour();
                    }
                }
                ++n;
            }
            return pgGeometryArray;
        }
        if (string2.indexOf("obj") != -1 || string2.indexOf("edg") != -1) {
            PgObjLoader pgObjLoader = new PgObjLoader();
            PgJvxSrc pgJvxSrc = pgObjLoader.read(string);
            if (pgJvxSrc == null) return null;
            pgGeometryArray = PgLoader.assureLength(pgGeometryArray, 1);
            pgGeometryArray[0] = PgLoader.assureType(pgGeometryArray[0], pgJvxSrc.getType(), pgJvxSrc.getDimOfVertices());
            pgGeometryArray[0].setJvx(pgJvxSrc);
            switch (pgJvxSrc.getType()) {
                case 33: {
                    int[] nArray = pgObjLoader.m_meshType;
                    if (pgObjLoader.m_numMeshType <= 0 || nArray[0] != 1 || nArray[1] != 2) return pgGeometryArray;
                    PgElementSet pgElementSet = (PgElementSet)pgGeometryArray[0];
                    pgElementSet.makeQuadrConn(nArray[3], nArray[2]);
                    return pgGeometryArray;
                }
                case 34: {
                    int[] nArray = pgObjLoader.m_meshType;
                    if (pgObjLoader.m_numMeshType <= 0 || nArray[0] != 1 || nArray[1] != 3) return pgGeometryArray;
                    PgTetraSet pgTetraSet = (PgTetraSet)pgGeometryArray[0];
                    pgTetraSet.makeQuadrConn(nArray[4], nArray[3], nArray[2]);
                    return pgGeometryArray;
                }
                default: {
                    return pgGeometryArray;
                }
            }
        }
        if (string2.indexOf("off") != -1) {
            PgJvxSrc pgJvxSrc = PgOffLoader.read(string);
            if (pgJvxSrc == null) return null;
            pgGeometryArray = PgLoader.assureLength(pgGeometryArray, 1);
            pgGeometryArray[0] = PgLoader.assureType(pgGeometryArray[0], 33, pgJvxSrc.getDimOfVertices());
            pgGeometryArray[0].setJvx(pgJvxSrc);
            switch (pgJvxSrc.getType()) {
                case 33: {
                    PgElementSet pgElementSet = (PgElementSet)pgGeometryArray[0];
                    pgElementSet.makeNeighbour();
                    return pgGeometryArray;
                }
                default: {
                    return pgGeometryArray;
                }
            }
        }
        if (string2.indexOf("xml") != -1) {
            PvDisplayOption[] pvDisplayOptionArray = PvDisplayLoader.read(string);
            if (pvDisplayOptionArray != null && pvDisplayOptionArray.length != 0) return null;
            PsDebug.warning("reading of display configuration failed");
            return null;
        }
        PsDebug.warning("unknown file extension");
        return null;
    }

    public static boolean readDirs(List list, String string) throws IOException {
        list.removeAll();
        list.add("..");
        String[] stringArray = PgLoader.readDirs(string);
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                list.add(stringArray[n]);
                ++n;
            }
        }
        return true;
    }

    public static String[] readDirs(String string) throws IOException {
        PsXmlSrc psXmlSrc = PsXmlLoader.read(string);
        if (psXmlSrc == null) {
            PsDebug.warning("failed to read list from file = " + string);
            return null;
        }
        PsXmlNode psXmlNode = psXmlSrc.getRootNode();
        if (psXmlNode == null) {
            PsDebug.warning("could not read list from file = " + string);
            return null;
        }
        PsXmlNode psXmlNode2 = psXmlNode.getChild("directories");
        if (psXmlNode2 == null) {
            PsDebug.warning("directory contains no directory section, dir = " + string);
            return null;
        }
        PsXmlNode[] psXmlNodeArray = psXmlNode2.getChildren("directory");
        if (psXmlNodeArray == null) {
            return null;
        }
        String[] stringArray = new String[psXmlNodeArray.length];
        int n = 0;
        while (n < psXmlNodeArray.length) {
            PsXmlNode psXmlNode3 = psXmlNodeArray[n].getChild("name");
            if (psXmlNode3 == null) {
                PsDebug.warning("directory has no name, dir = " + string);
            }
            stringArray[n] = psXmlNode3.getContent();
            ++n;
        }
        return stringArray;
    }

    public static boolean save(PgGeometryIf[] pgGeometryIfArray, String string) {
        if (string == null) {
            PsDebug.warning("missing fileName");
            return false;
        }
        String string2 = PsUtil.getFileExtension(string);
        if (string2 == null) {
            PsDebug.warning("missing extension in file name.");
            return false;
        }
        String string3 = PgLoader.saveToString(pgGeometryIfArray, string2 = string2.toLowerCase());
        if (string3 == null) {
            PsDebug.warning("error during export.");
            return false;
        }
        return PgLoader.save(string3, string);
    }

    public static boolean save(String string, String string2) {
        if (string == null) {
            PsDebug.warning("missing data to save.");
            return false;
        }
        if (PsConfig.isApplication()) {
            PrintWriter printWriter = PsUtil.writeFile(string2);
            if (printWriter == null) {
                PsDebug.warning("could not open file = " + string2);
                return false;
            }
            printWriter.println(string);
            printWriter.close();
        } else {
            PgExport_Dialog pgExport_Dialog = new PgExport_Dialog(PsConfig.getFrame(), "JavaView " + PsConfig.getMessage("Export"), false);
            String string3 = PsUtil.getFileExtension(string2);
            if (string3 != null) {
                pgExport_Dialog.setFilenameExtension(string3);
            }
            pgExport_Dialog.setText(string);
            ((Component)pgExport_Dialog).setVisible(true);
        }
        return true;
    }

    public static boolean save(Image image, String string) {
        if (image == null) {
            PsDebug.warning("missing image to save.");
            return false;
        }
        String string2 = string.substring(string.lastIndexOf(46) + 1, string.length());
        if (string2 == null) {
            PsDebug.warning("missing extension in file name.");
            return false;
        }
        try {
            ImageEncoder imageEncoder;
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            if (fileOutputStream == null) {
                PsDebug.warning("could not open file = " + string);
                return false;
            }
            if (string2.equalsIgnoreCase("gif")) {
                imageEncoder = new GifEncoder(image, (OutputStream)fileOutputStream);
            } else if (string2.equalsIgnoreCase("ppm")) {
                imageEncoder = new PpmEncoder(image, (OutputStream)fileOutputStream);
            } else {
                PsDebug.warning("unknown image file format = " + string2);
                return false;
            }
            imageEncoder.encode();
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            PsDebug.error("" + iOException.toString());
            PsDebug.message("\t Save image in format PPM and convert to GIF with any paint program.");
            return false;
        }
        return true;
    }

    public static double parseDouble(StreamTokenizer streamTokenizer) {
        try {
            if (streamTokenizer.ttype != -2) {
                PsDebug.warning("called with tokenType different to TT_NUMBER, st = " + streamTokenizer.toString());
                return 0.0;
            }
            double d = streamTokenizer.nval;
            if (streamTokenizer.nextToken() != -3 || !streamTokenizer.sval.startsWith("e") && !streamTokenizer.sval.startsWith("E")) {
                streamTokenizer.pushBack();
                return d;
            }
            if (streamTokenizer.sval.equals("e") || streamTokenizer.sval.equals("E")) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == 43) {
                    streamTokenizer.nextToken();
                    if (streamTokenizer.nextToken() != -2) {
                        PsDebug.warning("Number expected.");
                        return 0.0;
                    }
                    return d * Math.pow(10.0, streamTokenizer.nval);
                }
                if (streamTokenizer.ttype == 45) {
                    streamTokenizer.nextToken();
                    if (streamTokenizer.nextToken() != -2) {
                        PsDebug.warning("Number expected.");
                        return 0.0;
                    }
                    return d * Math.pow(10.0, -streamTokenizer.nval);
                }
                if (streamTokenizer.nextToken() != -2) {
                    PsDebug.warning("Number expected.");
                    return 0.0;
                }
                return d * Math.pow(10.0, streamTokenizer.nval);
            }
            char[] cArray = new char[streamTokenizer.sval.length() + 2];
            char[] cArray2 = streamTokenizer.sval.toCharArray();
            cArray[0] = "1".charAt(0);
            cArray[1] = ".".charAt(0);
            int n = 2;
            while (n < cArray.length) {
                cArray[n] = cArray2[n - 2];
                ++n;
            }
            return d * Double.valueOf(new String(cArray));
        }
        catch (Exception exception) {
            PsDebug.warning("Exception thrown: " + exception);
            return streamTokenizer.ttype;
        }
    }

    public static double parseDouble(String string) {
        try {
            return new Double(string);
        }
        catch (NumberFormatException numberFormatException) {
            PsDebug.warning("wrong format = " + string);
            return 0.0;
        }
    }

    private static PgGeometry assureType(PgGeometry pgGeometry, int n, int n2) {
        if (pgGeometry != null && pgGeometry.getDimOfVertices() != n2) {
            pgGeometry = null;
        }
        switch (n) {
            case 32: {
                if (pgGeometry != null && pgGeometry instanceof PgPolygonSet) break;
                pgGeometry = new PgPolygonSet(n2);
                break;
            }
            case 33: {
                if (pgGeometry != null && pgGeometry instanceof PgElementSet) break;
                pgGeometry = new PgElementSet(n2);
                break;
            }
            case 34: {
                if (pgGeometry != null && pgGeometry instanceof PgTetraSet) break;
                pgGeometry = new PgTetraSet(n2);
                break;
            }
            default: {
                if (pgGeometry != null && pgGeometry instanceof PgPointSet) break;
                pgGeometry = new PgPointSet(n2);
            }
        }
        return pgGeometry;
    }

    private static PgGeometry[] assureLength(PgGeometry[] pgGeometryArray, int n) {
        if (pgGeometryArray == null) {
            return new PgGeometry[n];
        }
        if (n == pgGeometryArray.length) {
            return pgGeometryArray;
        }
        PgGeometry[] pgGeometryArray2 = new PgGeometry[n];
        int n2 = 0;
        while (n2 < Math.min(n, pgGeometryArray.length)) {
            pgGeometryArray2[n2] = pgGeometryArray[n2];
            ++n2;
        }
        return pgGeometryArray2;
    }
}

