/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Hashtable;
import jv.loader.PgLoader;
import jv.loader.PsXmlNode;
import jv.loader.PsXmlSrc;
import jv.number.PdColor;
import jv.number.PuString;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuData;

public class PsXmlLoader {
    private static final int UNKNOWN = -1;
    private static final int TRUE = 1;
    private static final int FALSE = 0;

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static boolean parse(BufferedReader var0, PsXmlSrc var1_1) throws IOException {
        var2_2 = new StreamTokenizer(var0);
        var2_2.eolIsSignificant(true);
        var2_2.ordinaryChar(60);
        var2_2.ordinaryChar(62);
        var2_2.ordinaryChar(47);
        var2_2.ordinaryChar(33);
        var2_2.ordinaryChar(63);
        var2_2.ordinaryChar(91);
        var2_2.ordinaryChar(93);
        var2_2.ordinaryChar(45);
        var2_2.ordinaryChar(43);
        var2_2.ordinaryChar(46);
        var2_2.ordinaryChars(48, 48);
        var2_2.ordinaryChars(49, 57);
        var2_2.wordChars(35, 35);
        var2_2.wordChars(94, 94);
        var2_2.wordChars(38, 38);
        var2_2.wordChars(36, 36);
        var2_2.wordChars(40, 40);
        var2_2.wordChars(41, 41);
        var2_2.wordChars(126, 126);
        var2_2.wordChars(64, 64);
        var2_2.wordChars(45, 45);
        var2_2.wordChars(43, 43);
        var2_2.wordChars(42, 42);
        var2_2.wordChars(48, 48);
        var2_2.wordChars(49, 57);
        var2_2.wordChars(46, 46);
        var2_2.wordChars(44, 44);
        var2_2.wordChars(59, 59);
        var2_2.wordChars(95, 95);
        var2_2.wordChars(58, 58);
        var2_2.whitespaceChars(61, 61);
        var3_3 = 0;
        var4_4 = null;
        var5_5 = null;
        var6_6 = false;
        var7_7 = false;
        var8_8 = false;
        var9_9 = false;
        var10_10 = true;
        try {
            block51: {
                block17: while (true) {
                    switch (var2_2.nextToken()) {
                        default: {
                            PsDebug.warning("parsing broke abnormally");
                            PsDebug.warning("\t in line=" + var2_2.lineno() + " reading st.sval=" + var2_2.sval + ", st.ttype=" + var2_2.ttype);
                            return false;
                        }
                        case 10: {
                            if (!var7_7 || var4_4 == null) continue block17;
                            var5_5 = var4_4.getContent();
                            if (var5_5 != null) {
                                var5_5 = var5_5 + "\n";
                            }
                            var4_4.setContent(var5_5);
                            continue block17;
                        }
                        case 60: {
                            var9_9 = false;
                            if (var7_7 && var4_4 != null) {
                                var5_5 = var4_4.getContent();
                                if (var5_5 != null && var5_5.endsWith("\n")) {
                                    var5_5 = var5_5.substring(0, var5_5.length() - 1);
                                }
                                var4_4.setContent(var5_5);
                            }
                            var7_7 = false;
                            var11_11 = var2_2.nextToken();
                            if (var11_11 == 33 || var11_11 == 63) {
                                var2_2.nextToken();
                                if (var2_2.sval.equals("xml")) {
                                    while (var2_2.nextToken() != 62) {
                                    }
                                    continue block17;
                                }
                                if (var2_2.sval.equals("DOCTYPE")) {
                                    var2_2.nextToken();
                                    if (var2_2.sval != null) {
                                        var1_1.setDocName(var2_2.sval);
                                    } else {
                                        PsDebug.warning("missing DTD doc name.");
                                    }
                                    var12_13 = var2_2.nextToken();
                                    if (var2_2.sval != null && var2_2.sval.equals("SYSTEM")) {
                                        var2_2.nextToken();
                                        if (var2_2.sval != null) {
                                            var1_1.setDocType(var2_2.sval);
                                            continue block17;
                                        }
                                        PsDebug.warning("missing DTD doc type.");
                                        continue block17;
                                    }
                                    if (var12_13 == 91) {
                                        var8_8 = true;
                                        continue block17;
                                    }
                                    PsDebug.warning("error while parsing doctype.");
                                    PsDebug.warning("\t in line=" + var2_2.lineno() + " reading st.sval=" + var2_2.sval + ", st.ttype=" + var2_2.ttype);
                                    continue block17;
                                }
                                if (var2_2.sval.equals("ENTITY")) {
                                    while (var2_2.nextToken() != 62) {
                                    }
                                    continue block17;
                                }
                                if (var2_2.sval.equals("ELEMENT")) {
                                    while (var2_2.nextToken() != 62) {
                                    }
                                    continue block17;
                                }
                                if (var2_2.sval.equals("ATTLIST")) {
                                    while (var2_2.nextToken() != 62) {
                                    }
                                    continue block17;
                                }
                                if (var2_2.sval.equals("--")) {
                                    while (var2_2.nextToken() != 62) {
                                    }
                                    continue block17;
                                }
                                PsDebug.warning("unknown command.");
                                PsDebug.warning("\t in line=" + var2_2.lineno() + " reading st.sval=" + var2_2.sval + ", st.ttype=" + var2_2.ttype);
                                while (var2_2.nextToken() != 62) {
                                }
                                continue block17;
                            }
                            if (var11_11 == 47) {
                                --var3_3;
                                var2_2.nextToken();
                                if (!var2_2.sval.equals(var4_4.getType())) {
                                    var4_4 = var4_4.getFather();
                                }
                                var4_4.expand(false);
                                continue block17;
                            }
                            if (var10_10) {
                                var10_10 = false;
                                var2_2.wordChars(33, 33);
                                var2_2.wordChars(63, 63);
                                var2_2.wordChars(91, 91);
                                var2_2.wordChars(93, 93);
                            }
                            ++var3_3;
                            var12_14 = new PsXmlNode(var2_2.sval);
                            if (var4_4 != null) {
                                if (var4_4.isExpanded()) {
                                    var4_4.setChild(var12_14);
                                } else {
                                    var4_4.setSibling(var12_14);
                                }
                            }
                            var4_4 = var12_14;
                            var4_4.expand(true);
                            var6_6 = true;
                            var2_2.whitespaceChars(61, 61);
                            continue block17;
                        }
                        case 62: {
                            var6_6 = false;
                            var2_2.ordinaryChar(61);
                            var2_2.wordChars(61, 61);
                            var9_9 = true;
                            continue block17;
                        }
                        case 93: {
                            if (var8_8) {
                                var8_8 = false;
                                continue block17;
                            }
                            if (!var9_9) continue block17;
                            var4_4.appendContent("]");
                            continue block17;
                        }
                        case 47: {
                            if (var6_6) {
                                if (var2_2.nextToken() != 62) {
                                    PsDebug.error("found '/' in attribute mode, error in line=" + var2_2.lineno());
                                    return false;
                                }
                                var6_6 = false;
                                --var3_3;
                                var4_4.expand(false);
                                continue block17;
                            }
                            var4_4.appendContent("/");
                            var7_7 = true;
                            continue block17;
                        }
                        case 91: {
                            if (var9_9) {
                                var4_4.appendContent(" [");
                                continue block17;
                            }
                        }
                        case 34: {
                            if (!var9_9) continue block17;
                            var4_4.appendContent("\"");
                            continue block17;
                        }
                        case 33: {
                            if (!var9_9) continue block17;
                            var4_4.appendContent("!");
                            continue block17;
                        }
                        case 63: {
                            if (!var9_9) continue block17;
                            var4_4.appendContent("?");
                            continue block17;
                        }
                        case 61: {
                            if (!var9_9) continue block17;
                            var4_4.appendContent("=");
                            continue block17;
                        }
                        case -3: {
                            if (var6_6) {
                                var13_15 = var2_2.sval;
                                var2_2.nextToken();
                                var14_16 = var2_2.sval;
                                var4_4.addAttribute(var13_15, var14_16);
                                continue block17;
                            }
                            var5_5 = var4_4.getContent();
                            var5_5 = var5_5 == null ? var2_2.sval : (var5_5.endsWith("\n") != false || var5_5.endsWith("/") != false ? var5_5 + var2_2.sval : var5_5 + " " + var2_2.sval);
                            var4_4.setContent(var5_5);
                            var7_7 = true;
                            continue block17;
                        }
                        case -2: {
                            var5_5 = var4_4.getContent();
                            var5_5 = var5_5 == null ? String.valueOf(var2_2.nval) : var5_5 + " " + String.valueOf(var2_2.nval);
                            var4_4.setContent(var5_5);
                            var7_7 = true;
                            continue block17;
                        }
                        case -1: {
                            ** while ((var4_4 = var4_4.getFather()) != null)
                        }
                    }
                    break;
                }
lbl214:
                // 1 sources

                if ((var4_4 = var4_4.getFather()) == null) break block51;
lbl-1000:
                // 2 sources

                {
                    if (var4_4.getFather() != null) ** GOTO lbl214
                }
            }
            var1_1.setRootNode(var4_4);
            return true;
        }
        catch (Exception var11_12) {
            PsDebug.warning("Exception thrown in line=" + var2_2.lineno() + ", Exception = " + var11_12);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PsXmlSrc read(String string) {
        PsXmlSrc psXmlSrc;
        BufferedReader bufferedReader;
        block10: {
            PsXmlSrc psXmlSrc2;
            bufferedReader = PsUtil.open(string);
            if (bufferedReader == null) {
                PsDebug.warning("could not open = " + string);
                return null;
            }
            psXmlSrc = new PsXmlSrc();
            try {
                try {
                    boolean bl = PsXmlLoader.parse(bufferedReader, psXmlSrc);
                    if (bl) break block10;
                    PsDebug.warning("error when reading file = " + string);
                    psXmlSrc2 = null;
                    Object var5_8 = null;
                }
                catch (IOException iOException) {
                    PsDebug.warning("error when reading file = " + string);
                    iOException.printStackTrace();
                    PsXmlSrc psXmlSrc3 = null;
                    Object var5_9 = null;
                    try {
                        bufferedReader.close();
                        return psXmlSrc3;
                    }
                    catch (IOException iOException2) {}
                    return psXmlSrc3;
                }
            }
            catch (Throwable throwable) {
                Object var5_11 = null;
                try {}
                catch (IOException iOException) {}
                bufferedReader.close();
                throw throwable;
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            bufferedReader.close();
            return psXmlSrc2;
        }
        Object var5_10 = null;
        try {}
        catch (IOException iOException) {
            return psXmlSrc;
        }
        bufferedReader.close();
        return psXmlSrc;
    }

    public static PdVector[] parseDoubleList(PsXmlNode psXmlNode, String string, String[] stringArray) {
        PsXmlNode[] psXmlNodeArray = PsXmlSrc.getRsrcNodes(psXmlNode, string);
        if (psXmlNodeArray == null || psXmlNodeArray.length == 0) {
            return null;
        }
        PdVector[] pdVectorArray = new PdVector[psXmlNodeArray.length];
        int n = 0;
        while (n < psXmlNodeArray.length) {
            pdVectorArray[n] = PsXmlLoader.parsePdVector(psXmlNodeArray[n], stringArray);
            if (pdVectorArray[n] == null) {
                PsDebug.warning("failed to parse vector at index = " + n);
                return null;
            }
            ++n;
        }
        return pdVectorArray;
    }

    public static String[][] parseFunList(PsXmlNode psXmlNode, String string, String[] stringArray) {
        PsXmlNode[] psXmlNodeArray = PsXmlSrc.getRsrcNodes(psXmlNode, string);
        if (psXmlNodeArray == null || psXmlNodeArray.length == 0) {
            return null;
        }
        String[][] stringArray2 = new String[psXmlNodeArray.length][];
        int n = 0;
        while (n < psXmlNodeArray.length) {
            String string2 = psXmlNodeArray[n].getContent();
            if (string2 != null) {
                String[] stringArray3 = PuString.splitString(string2, ' ');
                stringArray2[n] = new String[stringArray3.length];
                int n2 = 0;
                while (n2 < stringArray3.length) {
                    stringArray2[n][n2] = stringArray3[n2];
                    ++n2;
                }
            }
            ++n;
        }
        return stringArray2;
    }

    public static String write(PsXmlSrc psXmlSrc) {
        if (psXmlSrc == null) {
            PsDebug.warning("missing XML source.");
            return null;
        }
        PsXmlNode psXmlNode = psXmlSrc.getRootNode();
        if (psXmlNode == null) {
            PsDebug.warning("missing root node in XML source.");
            return null;
        }
        String string = psXmlSrc.getDocName();
        String string2 = psXmlSrc.getDocType();
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" standalone=\"yes\"?>\n");
        if (string != null && string2 != null) {
            stringBuffer.append("<!DOCTYPE " + string + " SYSTEM \"" + string2 + "\">" + "\n");
        } else {
            PsDebug.message("missing DTD information.");
        }
        PsXmlLoader.writeNode(stringBuffer, psXmlNode, "");
        return stringBuffer.toString();
    }

    public static Color parseColorContent(PsXmlNode psXmlNode) {
        if (psXmlNode == null) {
            return null;
        }
        String string = psXmlNode.getContent();
        return PdColor.parseColor(string);
    }

    public static PiVector parseLabelAtt(PsXmlNode psXmlNode) {
        if (psXmlNode == null) {
            return null;
        }
        PiVector piVector = new PiVector(6);
        String string = psXmlNode.getAttribute("visible");
        if (string != null && "hide".equalsIgnoreCase(string)) {
            piVector.setEntry(5, 0);
        } else {
            piVector.setEntry(5, 1);
        }
        String string2 = psXmlNode.getAttribute("horAlign");
        if (string2 == null || "head".equalsIgnoreCase(string2)) {
            piVector.setEntry(2, 0);
        } else if ("center".equalsIgnoreCase(string2)) {
            piVector.setEntry(2, 1);
        } else if ("tail".equalsIgnoreCase(string2)) {
            piVector.setEntry(2, 2);
        }
        String string3 = psXmlNode.getAttribute("verAlign");
        if (string3 == null || "base".equalsIgnoreCase(string3)) {
            piVector.setEntry(3, 0);
        } else if ("middle".equalsIgnoreCase(string3)) {
            piVector.setEntry(3, 1);
        } else if ("top".equalsIgnoreCase(string3)) {
            piVector.setEntry(3, 2);
        }
        String string4 = psXmlNode.getAttribute("font");
        if (string4 == null || "text".equalsIgnoreCase(string4)) {
            piVector.setEntry(4, 0);
        } else if ("fixed".equalsIgnoreCase(string4)) {
            piVector.setEntry(4, 1);
        } else if ("header2".equalsIgnoreCase(string4)) {
            piVector.setEntry(4, 3);
        } else if ("header4".equalsIgnoreCase(string4)) {
            piVector.setEntry(4, 4);
        } else if ("menu".equalsIgnoreCase(string4)) {
            piVector.setEntry(4, 2);
        } else if (string4 == null) {
            piVector.setEntry(4, 0);
        }
        try {
            PsXmlNode psXmlNode2;
            PsXmlNode psXmlNode3 = PsXmlSrc.getRsrcNode(psXmlNode, "xOffset");
            if (psXmlNode3 != null) {
                piVector.setEntry(0, Integer.parseInt(psXmlNode3.getContent()));
            }
            if ((psXmlNode2 = PsXmlSrc.getRsrcNode(psXmlNode, "yOffset")) != null) {
                piVector.setEntry(1, Integer.parseInt(psXmlNode2.getContent()));
            }
        }
        catch (NumberFormatException numberFormatException) {
            PsDebug.warning("wrong format parsing offset");
            return null;
        }
        return piVector;
    }

    public static void addVectorList(PsXmlNode psXmlNode, String string, PdVector[] pdVectorArray, int n) {
        if (pdVectorArray == null) {
            return;
        }
        boolean bl = "p".equals(string);
        psXmlNode.addAttribute("num", String.valueOf(n));
        int n2 = 0;
        while (n2 < n) {
            PsXmlLoader.addVector(psXmlNode, string, pdVectorArray[n2], bl);
            ++n2;
        }
    }

    public static void addVectorList(PsXmlNode psXmlNode, String string, PiVector[] piVectorArray, int n) {
        if (piVectorArray == null) {
            return;
        }
        boolean bl = "e".equals(string) || "f".equals(string) || "l".equals(string);
        psXmlNode.addAttribute("num", String.valueOf(n));
        int n2 = 0;
        while (n2 < n) {
            PsXmlLoader.addVector(psXmlNode, string, piVectorArray[n2], bl);
            ++n2;
        }
    }

    private static StringBuffer writeNode(StringBuffer stringBuffer, PsXmlNode psXmlNode, String string) {
        Object object;
        Object object2;
        if (psXmlNode == null) {
            return stringBuffer;
        }
        stringBuffer.append(string + "<" + psXmlNode.getType());
        Hashtable hashtable = psXmlNode.getAttributes();
        if (hashtable != null) {
            object2 = hashtable.keys();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                String string2 = psXmlNode.getAttribute((String)object);
                stringBuffer.append(" " + (String)object + "=\"" + string2 + "\"");
            }
        }
        object2 = psXmlNode.getContent();
        object = psXmlNode.getChild();
        if ((object2 == null || ((String)object2).equals("")) && object == null) {
            stringBuffer.append("/>\n");
        } else {
            stringBuffer.append(">");
            boolean bl = true;
            int n = -1;
            if (object2 != null) {
                n = ((String)object2).indexOf(10);
            }
            if (object2 != null && n > -1 || psXmlNode.getChild() != null) {
                bl = false;
                stringBuffer.append("\n");
            }
            if (object2 != null) {
                int n2 = 0;
                String string3 = string + "\t";
                if (n != -1) {
                    do {
                        stringBuffer.append(string3 + ((String)object2).substring(n2, n + 1));
                        n2 = n + 1;
                    } while ((n = ((String)object2).indexOf(10, n + 1)) != -1);
                    if (n2 < ((String)object2).length()) {
                        stringBuffer.append(string3 + ((String)object2).substring(n2, ((String)object2).length()) + "\n");
                    }
                } else {
                    if (!bl) {
                        stringBuffer.append(string3);
                    }
                    stringBuffer.append((String)object2);
                    if (!bl) {
                        stringBuffer.append("\n");
                    }
                }
            }
            if (object != null) {
                stringBuffer = PsXmlLoader.writeNode(stringBuffer, (PsXmlNode)object, new String(string + "\t"));
                PsXmlNode psXmlNode2 = ((PsXmlNode)object).getSibling();
                while (psXmlNode2 != null) {
                    stringBuffer = PsXmlLoader.writeNode(stringBuffer, psXmlNode2, string + "\t");
                    psXmlNode2 = psXmlNode2.getSibling();
                }
            }
            if (!bl) {
                stringBuffer.append(string);
            }
            stringBuffer.append("</" + psXmlNode.getType() + ">\n");
        }
        return stringBuffer;
    }

    public static void addVectorList(PsXmlNode psXmlNode, String string, PdVector[][] pdVectorArray) {
        if (pdVectorArray == null) {
            return;
        }
        int n = 0;
        while (n < pdVectorArray.length) {
            if (pdVectorArray[n] == null) {
                return;
            }
            ++n;
        }
        n = 0;
        int n2 = 0;
        while (n2 < pdVectorArray.length) {
            int n3 = 0;
            while (n3 < pdVectorArray[n2].length) {
                psXmlNode.addChild(string, PuData.toString(pdVectorArray[n2][n3].m_data));
                ++n3;
            }
            n += pdVectorArray[n2].length;
            ++n2;
        }
        psXmlNode.addAttribute("num", String.valueOf(n));
    }

    public static PiVector parsePiVector(String string) {
        if (string == null) {
            PsDebug.warning("missing integer string.");
            return null;
        }
        try {
            String[] stringArray = PuString.splitString(string, ' ');
            if (stringArray == null || stringArray.length == 0) {
                PsDebug.warning("missing integer entries = " + string);
                return null;
            }
            int n = stringArray.length;
            PiVector piVector = new PiVector(n);
            int n2 = 0;
            while (n2 < n) {
                piVector.setEntry(n2, Integer.parseInt(stringArray[n2]));
                ++n2;
            }
            return piVector;
        }
        catch (NumberFormatException numberFormatException) {
            PsDebug.warning("wrong format in integer string = " + string);
            return null;
        }
    }

    public static PiVector parsePiVector(PsXmlNode psXmlNode, String string, String[] stringArray) {
        PsXmlNode psXmlNode2 = PsXmlSrc.getRsrcNode(psXmlNode, string);
        if (psXmlNode2 == null) {
            return null;
        }
        return PsXmlLoader.parsePiVector(psXmlNode2, stringArray);
    }

    public static PiVector parsePiVector(PsXmlNode psXmlNode, String[] stringArray) {
        int n;
        if (psXmlNode == null) {
            PsDebug.warning("missing xml node.");
            return null;
        }
        String string = psXmlNode.getContent();
        if (string == null) {
            PsDebug.warning("missing content of element = " + psXmlNode.getType());
            return null;
        }
        String[] stringArray2 = PuString.splitString(string, ' ');
        PiVector piVector = new PiVector(stringArray2.length);
        try {
            n = 0;
            while (n < stringArray2.length) {
                piVector.m_data[n] = Integer.parseInt(stringArray2[n]);
                ++n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            PsDebug.warning("wrong integer format in: " + string);
            return null;
        }
        if (stringArray != null) {
            n = 0;
            while (n < stringArray.length) {
                String string2 = psXmlNode.getAttribute(stringArray[n]);
                if (string2 != null) {
                    if (string2.equalsIgnoreCase("mark")) {
                        piVector.setTag(1);
                    } else if (stringArray[n].equalsIgnoreCase("name")) {
                        piVector.setName(string2);
                    } else {
                        PsDebug.warning("unknown attribute = " + stringArray[n]);
                        stringArray = null;
                        break;
                    }
                }
                ++n;
            }
        }
        return piVector;
    }

    public static void addVector(PsXmlNode psXmlNode, String string, PdVector pdVector, boolean bl) {
        if (pdVector == null) {
            return;
        }
        PsXmlNode psXmlNode2 = psXmlNode.addChild(string, PuData.toString(pdVector.m_data));
        if (bl && pdVector.getName() != null) {
            psXmlNode2.addAttribute("name", pdVector.getName());
        }
        if (pdVector.hasTag(1)) {
            psXmlNode2.addAttribute("tag", "mark");
        }
    }

    public static void addVector(PsXmlNode psXmlNode, String string, PiVector piVector, boolean bl) {
        if (piVector == null) {
            return;
        }
        PsXmlNode psXmlNode2 = psXmlNode.addChild(string, PuData.toString(piVector.m_data));
        if (bl && piVector.getName() != null) {
            psXmlNode2.addAttribute("name", piVector.getName());
        }
        if (piVector.hasTag(1)) {
            psXmlNode2.addAttribute("tag", "mark");
        }
    }

    public static void addVectorList(PsXmlNode psXmlNode, String string, Color[] colorArray, int n) {
        if (colorArray == null) {
            return;
        }
        psXmlNode.addAttribute("num", String.valueOf(n));
        int n2 = 0;
        while (n2 < n) {
            String string2 = String.valueOf(colorArray[n2].getRed()) + " " + String.valueOf(colorArray[n2].getGreen()) + " " + String.valueOf(colorArray[n2].getBlue());
            psXmlNode.addChild(string, string2);
            ++n2;
        }
    }

    public static PsXmlNode addColor(PsXmlNode psXmlNode, String string, Color color) {
        PsXmlNode psXmlNode2 = psXmlNode.addChild(string);
        psXmlNode2.setContent(String.valueOf(color.getRed()) + " " + String.valueOf(color.getGreen()) + " " + String.valueOf(color.getBlue()));
        psXmlNode2.addAttribute("type", "rgb");
        return psXmlNode2;
    }

    public static PiVector[] parseIntegerList(PsXmlNode psXmlNode, String string, String[] stringArray) {
        PsXmlNode[] psXmlNodeArray = PsXmlSrc.getRsrcNodes(psXmlNode, string);
        if (psXmlNodeArray == null || psXmlNodeArray.length == 0) {
            return null;
        }
        PiVector[] piVectorArray = new PiVector[psXmlNodeArray.length];
        int n = 0;
        while (n < psXmlNodeArray.length) {
            piVectorArray[n] = PsXmlLoader.parsePiVector(psXmlNodeArray[n], stringArray);
            if (piVectorArray[n] == null) {
                PsDebug.warning("failed to parse vector at index = " + n);
                return null;
            }
            ++n;
        }
        return piVectorArray;
    }

    public static Color[] parseColorList(PsXmlNode psXmlNode, String string) {
        PsXmlNode[] psXmlNodeArray = PsXmlSrc.getRsrcNodes(psXmlNode, string);
        if (psXmlNodeArray == null || psXmlNodeArray.length == 0) {
            return null;
        }
        Color[] colorArray = new Color[psXmlNodeArray.length];
        int n = 0;
        while (n < psXmlNodeArray.length) {
            colorArray[n] = PsXmlLoader.parseColorContent(psXmlNodeArray[n]);
            if (colorArray[n] == null) {
                PsDebug.warning("failed to parse color at index = " + n);
                return null;
            }
            ++n;
        }
        return colorArray;
    }

    public static Color parseColorRGB(PsXmlNode psXmlNode, String string) {
        PsXmlNode psXmlNode2 = PsXmlSrc.getRsrcNode(psXmlNode, string);
        if (psXmlNode2 == null) {
            return null;
        }
        return PsXmlLoader.parseColorContent(psXmlNode2);
    }

    public static PdVector parsePdVector(PsXmlNode psXmlNode, String string, String[] stringArray) {
        PsXmlNode psXmlNode2 = PsXmlSrc.getRsrcNode(psXmlNode, string);
        if (psXmlNode2 == null) {
            return null;
        }
        return PsXmlLoader.parsePdVector(psXmlNode2, stringArray);
    }

    public static PdVector parsePdVector(PsXmlNode psXmlNode, String[] stringArray) {
        if (psXmlNode == null) {
            PsDebug.warning("missing xml node.");
            return null;
        }
        String string = psXmlNode.getContent();
        if (string == null) {
            PsDebug.warning("missing content of element = " + psXmlNode.getType());
            return null;
        }
        String[] stringArray2 = PuString.splitString(string, ' ');
        PdVector pdVector = new PdVector(stringArray2.length);
        int n = 0;
        while (n < stringArray2.length) {
            pdVector.m_data[n] = PgLoader.parseDouble(stringArray2[n]);
            ++n;
        }
        if (stringArray != null) {
            n = 0;
            while (n < stringArray.length) {
                String string2 = psXmlNode.getAttribute(stringArray[n]);
                if (string2 != null) {
                    if (string2.equalsIgnoreCase("mark")) {
                        pdVector.setTag(1);
                    } else if (stringArray[n].equalsIgnoreCase("name")) {
                        pdVector.setName(string2);
                    } else {
                        PsDebug.warning("unknown attribute = " + stringArray[n]);
                        stringArray = null;
                        break;
                    }
                }
                ++n;
            }
        }
        return pdVector;
    }

    public static PdVector parsePdVector(String string) {
        if (string == null) {
            PsDebug.warning("missing double string.");
            return null;
        }
        String[] stringArray = PuString.splitString(string, ' ');
        if (stringArray == null || stringArray.length == 0) {
            PsDebug.warning("missing double entries = " + string);
            return null;
        }
        PdVector pdVector = new PdVector(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            pdVector.m_data[n] = PgLoader.parseDouble(stringArray[n]);
            ++n;
        }
        return pdVector;
    }
}

