/*
 * Decompiled with CFR 0.152.
 */
package jv.number;

import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.vecmath.PiVector;

public class PiVector_IP
extends PsPanel
implements TextListener {
    protected PiVector m_vector;
    protected int m_length;
    protected Panel m_pVector;
    protected TextField[] m_text;
    private boolean m_bInteractive = true;
    private static /* synthetic */ Class class$jv$number$PiVector_IP;

    public PiVector_IP() {
        if (this.getClass() == (class$jv$number$PiVector_IP != null ? class$jv$number$PiVector_IP : (class$jv$number$PiVector_IP = PiVector_IP.class$("jv.number.PiVector_IP")))) {
            this.init();
        }
    }

    public boolean setVector(PiVector piVector) {
        if (piVector == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        if (!this.setLength(piVector.getSize())) {
            PsDebug.warning("invalid length");
            return false;
        }
        this.m_vector = piVector;
        this.update(this.m_vector);
        return true;
    }

    public PiVector getVector() {
        return this.m_vector;
    }

    public boolean update(Object object) {
        if (object == null) {
            PsDebug.error("missing object", this);
            return false;
        }
        if (this.m_vector == null) {
            PsDebug.error("missing m_vector", this);
            return false;
        }
        if (object == this.m_vector) {
            this.m_bInteractive = false;
            int n = 0;
            while (n < this.m_length) {
                ((TextComponent)this.m_text[n]).setText(String.valueOf(this.m_vector.getEntry(n)));
                ++n;
            }
            this.m_bInteractive = true;
            return true;
        }
        if (object == this) {
            int n = 0;
            while (n < this.m_length) {
                try {
                    int n2 = Integer.parseInt(this.m_text[n].getText());
                    this.m_vector.setEntry(n, n2);
                }
                catch (NumberFormatException numberFormatException) {
                    PsDebug.warning("wrong format = " + this.m_text[n].getText(), this);
                }
                ++n;
            }
            return super.update(this);
        }
        return super.update(object);
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void init() {
        super.init();
        this.setLayout(new GridLayout(1, 2));
        this.addTitle("");
        this.m_pVector = new Panel();
        this.add(this.m_pVector);
    }

    public void textValueChanged(TextEvent textEvent) {
        if (!this.m_bInteractive) {
            return;
        }
        if (this.m_vector == null) {
            PsDebug.warning("missing vector, return");
            return;
        }
        Object object = textEvent.getSource();
        int n = 0;
        while (n < this.m_length) {
            if (object == this.m_text[n]) {
                String string = this.m_text[n].getText();
                if (string == null || string.equals("")) {
                    return;
                }
                try {
                    int n2 = Integer.parseInt(string);
                    this.m_vector.setEntry(n, n2);
                    this.update(this);
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    PsDebug.warning("wrong format = " + string);
                    return;
                }
            }
            ++n;
        }
    }

    public boolean setLength(int n) {
        if (n == this.m_length) {
            return true;
        }
        if (n > 5) {
            PsDebug.warning("vector length=" + this.m_length + " too large");
            return false;
        }
        this.m_length = n;
        this.m_pVector.removeAll();
        if (this.m_text == null || this.m_text.length != this.m_length) {
            int n2;
            if (this.m_text != null) {
                n2 = 0;
                while (n2 < this.m_text.length) {
                    this.m_text[n2].removeTextListener(this);
                    ++n2;
                }
            }
            this.m_pVector.setLayout(new GridLayout(1, this.m_length));
            this.m_text = new TextField[this.m_length];
            n2 = 0;
            while (n2 < this.m_length) {
                this.m_text[n2] = new TextField();
                this.m_text[n2].addTextListener(this);
                this.m_pVector.add(this.m_text[n2]);
                ++n2;
            }
            this.m_pVector.validate();
        }
        this.update(this.m_vector);
        return true;
    }
}

