/*
 * Decompiled with CFR 0.152.
 */
package jv.number;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.MemoryImageSource;
import jv.number.PdColor;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsStackLayout;
import jv.objectGui.GuiStackLayout;
import jv.vecmath.PiVector;

public class PuColorPicker
extends PsPanel
implements MouseListener,
MouseMotionListener {
    private static final int m_preferredWidth = 600;
    private static final int m_preferredHeight = 230;
    protected PuInteger m_red;
    protected PuInteger m_green;
    protected PuInteger m_blue;
    protected PuInteger m_bright;
    protected int m_wheelXPos = 0;
    protected int m_wheelYPos = 0;
    protected int m_wheelWidth = 176;
    protected int m_wheelHeight = 176;
    protected PsPanel m_pWheel;
    protected PsPanel m_pDefColor;
    protected PsPanel m_pNewColor;
    protected Color m_defColor;
    protected Color m_undimmedColor;
    protected PiVector m_pix;
    private static /* synthetic */ Class class$jv$number$PuColorPicker;

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object == this.m_pWheel) {
            this.setColor(this.colorAt(mouseEvent.getX(), mouseEvent.getY()));
            return;
        }
        if (object == this.m_pDefColor) {
            this.m_bright.setValue(100);
            this.setDimmedColor(this.m_defColor, 100);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mousePressed(mouseEvent);
    }

    public static Image getWheel(int n, int n2, int n3, int[] nArray) {
        if (nArray == null) {
            nArray = new int[n * n2];
        }
        int n4 = 0;
        int n5 = n / 2;
        int n6 = n2 / 2;
        int n7 = n5;
        int n8 = -16777216;
        int n9 = n8 | 0xFF0000 | 0xFF00 | 0xFF;
        int n10 = n8 | 0xC00000 | 0xC000 | 0xC0;
        int n11 = n8 | 0x550000 | 0x5500 | 0x55;
        int n12 = n8;
        int n13 = n6;
        int n14 = 0;
        while (n14 < n2) {
            int n15 = -n5;
            int n16 = 0;
            while (n16 < n) {
                int n17;
                if (n7 == 0) {
                    n17 = n9;
                } else {
                    int n18 = (int)(256.0 * Math.sqrt(n15 * n15 + n13 * n13) / (double)n7);
                    int n19 = (int)(255.0 * (Math.atan2(-n13, -n15) + Math.PI) / (Math.PI * 2));
                    if (n18 > 255) {
                        n17 = n15 < 0 && n13 > 0 ? n9 : (n15 > 0 && n13 > 0 ? n10 : (n15 < 0 && n13 < 0 ? n11 : n12));
                    } else {
                        Color color = PdColor.hsv2rgb(n19, n18, n3);
                        int n20 = color.getRed();
                        int n21 = color.getGreen();
                        int n22 = color.getBlue();
                        n17 = n8 | n20 << 16 | n21 << 8 | n22;
                    }
                }
                nArray[n4++] = n17;
                ++n15;
                ++n16;
            }
            --n13;
            ++n14;
        }
        Image image = PsConfig.getFrame().createImage(new MemoryImageSource(n, n2, nArray, 0, n));
        return image;
    }

    public PuColorPicker(Color color) {
        this.setLayout(new GuiStackLayout(0));
        if (color == null) {
            color = Color.white;
        }
        this.m_defColor = color;
        this.m_pWheel = new PsPanel();
        this.m_pWheel.setBorderType(2);
        this.m_pWheel.setSize(this.m_wheelWidth, this.m_wheelHeight);
        this.m_pix = new PiVector(this.m_wheelWidth * this.m_wheelHeight);
        this.m_pWheel.setImage(PuColorPicker.getWheel(this.m_wheelWidth, this.m_wheelHeight, 255, this.m_pix.m_data));
        this.m_pWheel.addMouseListener(this);
        this.m_pWheel.addMouseMotionListener(this);
        this.add(this.m_pWheel);
        PsPanel psPanel = new PsPanel();
        psPanel.setLayout(new PsStackLayout(10));
        this.m_pDefColor = new PsPanel();
        this.m_pDefColor.addMouseListener(this);
        this.m_pDefColor.setLayout(null);
        this.m_pDefColor.setBorderType(3);
        this.m_pDefColor.setSize(40, 60);
        this.m_pDefColor.setBackground(this.m_defColor);
        psPanel.add(this.m_pDefColor);
        this.m_pNewColor = new PsPanel();
        this.m_pNewColor.setLayout(null);
        this.m_pNewColor.setBorderType(3);
        this.m_pNewColor.setSize(40, 60);
        this.m_pNewColor.setBackground(this.m_defColor);
        psPanel.add(this.m_pNewColor);
        this.add(psPanel);
        PsPanel psPanel2 = new PsPanel();
        psPanel2.setLayout(new PsStackLayout(3));
        psPanel2.addTitle(PsConfig.getMessage("ColorPicker"));
        this.m_red = new PuInteger(PsConfig.getMessage("Red"), this);
        psPanel2.add(this.m_red.getInfoPanel());
        this.m_green = new PuInteger(PsConfig.getMessage("Green"), this);
        psPanel2.add(this.m_green.getInfoPanel());
        this.m_blue = new PuInteger(PsConfig.getMessage("Blue"), this);
        psPanel2.add(this.m_blue.getInfoPanel());
        psPanel2.addLine(1);
        this.m_bright = new PuInteger(PsConfig.getMessage("Brightness"), this);
        psPanel2.add(this.m_bright.getInfoPanel());
        psPanel2.addLine(1);
        this.add("Wide", psPanel2);
        this.validate();
        if (this.getClass() == (class$jv$number$PuColorPicker != null ? class$jv$number$PuColorPicker : (class$jv$number$PuColorPicker = PuColorPicker.class$("jv.number.PuColorPicker")))) {
            this.init();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    private Color colorAt(int n, int n2) {
        if (this.m_pix == null || this.m_pix.getSize() == 0) {
            PsDebug.warning("missing or empty pixel array m_pix");
            return null;
        }
        if (n < 0) {
            n = 0;
        }
        if (n >= this.m_wheelWidth) {
            n = this.m_wheelWidth - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 >= this.m_wheelHeight) {
            n2 = this.m_wheelHeight - 1;
        }
        int n3 = this.m_pix.getEntry(n + n2 * this.m_wheelHeight);
        return new Color(n3);
    }

    public Color getColor() {
        return this.m_pNewColor.getBackground();
    }

    public void setColor(Color color) {
        this.m_undimmedColor = color;
        this.m_red.setValue(color.getRed());
        this.m_green.setValue(color.getGreen());
        this.m_blue.setValue(color.getBlue());
        this.m_pNewColor.setBackground(color);
        this.m_pNewColor.repaint();
        if (this.m_parent != null) {
            this.m_parent.update(this);
        }
    }

    public boolean update(Object object) {
        if (object == this.m_red || object == this.m_green || object == this.m_blue) {
            if (this.m_bright.getValue() != 100) {
                this.m_bright.setValue(100);
                this.setDimmedColor(this.getColor(), 100);
                return true;
            }
            this.setColor(new Color(this.m_red.getValue(), this.m_green.getValue(), this.m_blue.getValue()));
            return true;
        }
        if (object == this.m_bright) {
            this.setDimmedColor(this.m_undimmedColor, this.m_bright.getValue());
            return true;
        }
        return super.update(object);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public Color getDefColor() {
        return this.m_defColor;
    }

    public void setDefColor(Color color) {
        this.m_defColor = color;
    }

    protected void setDimmedColor(Color color, int n) {
        double d = Math.sqrt((double)n / 100.0);
        int n2 = (int)((double)color.getRed() * d);
        int n3 = (int)((double)color.getGreen() * d);
        int n4 = (int)((double)color.getBlue() * d);
        this.m_pWheel.setImage(PuColorPicker.getWheel(this.m_wheelWidth, this.m_wheelHeight, (int)(255.0 * d), this.m_pix.m_data));
        this.m_pWheel.repaint();
        this.m_red.setValue(n2);
        this.m_green.setValue(n3);
        this.m_blue.setValue(n4);
        this.m_pNewColor.setBackground(new Color(n2, n3, n4));
        this.m_pNewColor.repaint();
        if (this.m_parent != null) {
            this.m_parent.update(this);
        }
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(600, 230);
    }

    public void init() {
        super.init();
        this.m_red.setDefBounds(0, 255, 1, 10);
        this.m_red.setDefValue(this.m_defColor.getRed());
        this.m_red.init();
        this.m_green.setDefBounds(0, 255, 1, 10);
        this.m_green.setDefValue(this.m_defColor.getGreen());
        this.m_green.init();
        this.m_blue.setDefBounds(0, 255, 1, 10);
        this.m_blue.setDefValue(this.m_defColor.getBlue());
        this.m_blue.init();
        this.m_bright.setDefBounds(0, 100, 1, 10);
        this.m_bright.setDefValue(100);
        this.m_bright.init();
        this.setColor(this.m_defColor);
    }
}

