/*
 * Decompiled with CFR 0.152.
 */
package jv.object;

import java.applet.Applet;
import java.awt.Font;
import java.awt.Frame;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import jv.object.PsDebug;
import jv.object.PsResource;
import jv.object.PsViewerIf;

public final class PsConfig {
    protected static final String PROGRAM = "JavaView";
    protected static final String PROJECT = "Visual Geometry Pages";
    protected static final String VERSION = "2.00.a9";
    protected static final String TOPIC = "Latest bug removals before release.";
    public static final String[] AUTHOR = new String[]{"Konrad Polthier", "Samy Khadem", "Eike Preu\u00df", "Ulrich Reitebuch"};
    public static String[] CONTRIBUTOR;
    public static final String HOMEPAGE = "http://www.javaview.de/";
    public static final String EMAIL = "vgpAdmin@sfb288.math.tu-berlin.de";
    public static final String HELP_HTML = "jars/help.html";
    public static final String FONTS_HTML = "jars/systemFonts.html";
    protected static ResourceBundle m_messages;
    protected static String m_codeBase;
    protected static char m_fileSeparator;
    protected static boolean m_bStandAlone;
    protected static Applet m_applet;
    protected static Frame m_frame;
    protected static PsViewerIf m_viewer;
    public static final int OS_WIN = 0;
    public static final int OS_IRIX = 1;
    public static final int OS_SOLARIS = 2;
    public static final int OS_LINUX = 3;
    public static final int OS_OTHER = 4;
    public static int m_osId;
    protected static String m_osName;
    protected static final int m_numFonts = 5;
    public static final int FONT_TEXT = 0;
    public static final int FONT_FIXED = 1;
    public static final int FONT_MENU = 2;
    public static final int FONT_HEADER2 = 3;
    public static final int FONT_HEADER4 = 4;
    protected static Font[] m_font;
    protected static String[][] m_fontName;
    protected static int[][] m_fontStyle;
    protected static int[][] m_fontSize;

    public static int getOSId() {
        return m_osId;
    }

    public static String getHomepage() {
        return HOMEPAGE;
    }

    public static String getProject() {
        return PROJECT;
    }

    public static String getTopic() {
        return TOPIC;
    }

    public static String getProgram() {
        return PROGRAM;
    }

    public static Applet getApplet() {
        return m_applet;
    }

    public static PsViewerIf getViewer() {
        return m_viewer;
    }

    private static void parseSystemProperties(String string) {
        if (string != null) {
            PsConfig.setCodeBase(string);
        }
        try {
            m_osName = System.getProperty("os.name");
            if (m_osName != null) {
                if (m_osName.toLowerCase().startsWith("win")) {
                    if (PsConfig.isApplication()) {
                        ((Hashtable)System.getProperties()).put("file", "stdin");
                    }
                    m_osId = 0;
                } else if (m_osName.toLowerCase().startsWith("irix")) {
                    m_osId = 1;
                } else if (m_osName.toLowerCase().startsWith("sun")) {
                    m_osId = 2;
                } else if (m_osName.toLowerCase().startsWith("linux")) {
                    m_osId = 3;
                }
            }
            if (m_codeBase == null && System.getProperty("user.dir") != null) {
                PsConfig.setCodeBase(System.getProperty("user.dir"));
                return;
            }
        }
        catch (SecurityException securityException) {
            System.out.println("... not succeeded to access OS.NAME !!!");
        }
    }

    public static Frame getFrame() {
        if (m_frame == null) {
            m_frame = new Frame(PROGRAM + " v" + VERSION);
        }
        return m_frame;
    }

    public static String getMessage(String string) {
        String string2 = null;
        if (m_messages != null) {
            try {
                string2 = m_messages.getString(string);
            }
            catch (Exception exception) {}
        }
        if (string2 == null) {
            string2 = PsResource.getString(string);
        }
        return string2;
    }

    public static String getVersion() {
        return VERSION;
    }

    public static String getCodeBase() {
        return m_codeBase;
    }

    public static void setCodeBase(String string) {
        m_codeBase = string;
        m_codeBase = m_codeBase.replace('\\', '/');
        if (PsConfig.isApplication()) {
            m_codeBase = m_codeBase + m_fileSeparator;
        }
        PsDebug.message("codeBase = " + m_codeBase);
    }

    public static String getLanguage() {
        if (m_messages == null) {
            return "en";
        }
        return m_messages.getString("_language");
    }

    public static void setLanguage(String string) {
        Locale locale = Locale.ENGLISH;
        try {
            if (string.equalsIgnoreCase("de")) {
                locale = Locale.GERMAN;
                m_messages = ResourceBundle.getBundle("rsrc/Messages", locale);
            } else if (string.equalsIgnoreCase("fr")) {
                locale = Locale.FRENCH;
                m_messages = ResourceBundle.getBundle("rsrc/Messages", locale);
            } else if (string.equalsIgnoreCase("pt")) {
                locale = new Locale("pt", "");
                m_messages = ResourceBundle.getBundle("rsrc/Messages", locale);
            } else if (string.equalsIgnoreCase("ru")) {
                locale = new Locale("ru", "");
                m_messages = ResourceBundle.getBundle("rsrc/Messages", locale);
            } else if (string.equalsIgnoreCase("en")) {
                locale = null;
                m_messages = null;
            }
        }
        catch (Exception exception) {
            m_messages = null;
        }
        if (!(m_messages == null || locale.getLanguage().equals(m_messages.getString("_language")) && locale.getCountry().equals(m_messages.getString("_country")))) {
            m_messages = null;
        }
    }

    public static Font getFont(int n) {
        if (n < 0 || n >= 5) {
            PsDebug.warning("type = " + n + " out of range.");
            n = 0;
        }
        if (m_font == null) {
            m_font = new Font[5];
        }
        if (m_font[n] == null) {
            PsConfig.m_font[n] = new Font(m_fontName[m_osId][n], m_fontStyle[m_osId][n], m_fontSize[m_osId][n]);
        }
        return m_font[n];
    }

    public static boolean setFont(int n, int n2, String string, int n3, int n4) {
        if (n2 < 0 || n2 >= 5) {
            PsDebug.warning("type = " + n2 + " out of range.");
            return false;
        }
        if (n == -1) {
            n = m_osId;
        }
        if (n < 0 || n >= m_fontName.length) {
            PsDebug.warning("os = " + n + " out of range.");
            return false;
        }
        if (string != null) {
            PsConfig.m_fontName[n][n2] = string;
        }
        if (n3 != -1) {
            PsConfig.m_fontStyle[n][n2] = n3;
        }
        if (n4 != -1) {
            PsConfig.m_fontSize[n][n2] = n4;
        }
        return true;
    }

    static {
        m_codeBase = null;
        m_fileSeparator = (char)47;
        m_bStandAlone = false;
        m_osId = 0;
        m_osName = null;
        m_fontName = new String[][]{{"Helvetica", "Courier", "Helvetica", "Helvetica", "Helvetica"}, {"Helvetica", "Courier", "Helvetica", "Helvetica", "Helvetica"}, {"Helvetica", "Courier", "Helvetica", "Helvetica", "Helvetica"}, {"Helvetica", "Courier", "Helvetica", "Helvetica", "Helvetica"}, {"Helvetica", "Courier", "Helvetica", "Helvetica", "Helvetica"}};
        int[][] nArrayArray = new int[5][];
        int[] nArray = new int[5];
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[5];
        nArray2[2] = 1;
        nArray2[3] = 1;
        nArray2[4] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[5];
        nArray3[2] = 1;
        nArray3[3] = 1;
        nArray3[4] = 1;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[5];
        nArray4[2] = 1;
        nArray4[3] = 1;
        nArray4[4] = 1;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[5];
        nArray5[2] = 1;
        nArray5[3] = 1;
        nArray5[4] = 1;
        nArrayArray[4] = nArray5;
        m_fontStyle = nArrayArray;
        m_fontSize = new int[][]{{12, 12, 14, 14, 12}, {8, 8, 10, 10, 8}, {10, 10, 12, 12, 10}, {10, 10, 12, 12, 10}, {8, 8, 10, 10, 8}};
    }

    public static Hashtable getProperties() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string = null;
        try {
            Properties properties = System.getProperties();
            Enumeration enumeration = ((Hashtable)properties).keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                hashtable.put(string, System.getProperty(string));
            }
        }
        catch (SecurityException securityException) {}
        hashtable.put("IsApplication", String.valueOf(PsConfig.isApplication()));
        hashtable.put("Codebase", PsConfig.getCodeBase());
        return hashtable;
    }

    public static boolean isApplication() {
        return m_bStandAlone;
    }

    public static String getOSName() {
        return m_osName;
    }

    public static void init(Applet applet, PsViewerIf psViewerIf, Frame frame) {
        m_viewer = psViewerIf;
        PsConfig.init(applet, frame);
    }

    public static void init(Applet applet, Frame frame) {
        m_applet = applet;
        m_frame = frame;
        String string = null;
        if (m_frame == null && applet != null) {
            m_bStandAlone = false;
            String string2 = m_applet.getAppletInfo();
            if (string2 != null) {
                string2 = string2.replace('\n', '\t');
                string2 = string2.replace('\r', '\n');
                PsDebug.message("*** Info of Current Applet ***\n\t" + string2);
            }
            StringBuffer stringBuffer = new StringBuffer("");
            stringBuffer.append("codeBase = " + m_applet.getCodeBase() + "\n");
            stringBuffer.append("codeBase.getFile() = " + m_applet.getCodeBase().getFile() + "\n");
            stringBuffer.append("codeBase.getHost() = " + m_applet.getCodeBase().getHost() + "\n");
            stringBuffer.append("codeBase.getProtocol() = " + m_applet.getCodeBase().getProtocol() + "\n");
            stringBuffer.append("docBase = " + m_applet.getDocumentBase() + "\n");
            PsConfig.parseSystemProperties(m_applet.getCodeBase().toString());
            string = applet.getParameter("language");
        } else {
            m_bStandAlone = true;
            PsConfig.parseSystemProperties(null);
            try {
                string = System.getProperty("language");
            }
            catch (SecurityException securityException) {}
        }
        if (string != null) {
            PsDebug.message("User defined language = " + string);
        } else {
            string = "en";
        }
        PsConfig.setLanguage(string);
        CONTRIBUTOR = new String[]{"Steve Dugaro / CECM <sdugaro@sfu.ca, www.cecm.sfu.ca> " + PsConfig.getMessage("CoordinateAxes") + ", " + PsConfig.getMessage("Ruler") + ", Maple", "Sergey Koval <512kse@mail.ru> " + PsConfig.getMessage("ClippingOfSurfaces") + ", " + PsConfig.getMessage("Booknot"), "Nick Kvasov <cernos@land6.nsu.ru> " + PsConfig.getMessage("ClippingOfSurfaces") + ", " + PsConfig.getMessage("Booknot"), "Axel Friedrich <axel@sfb288.math.tu-berlin.de> " + PsConfig.getMessage("AdaptiveRefinement"), "Tom Dudziak <tomdz@cs.tu-berlin.de> " + PsConfig.getMessage("VRMLFilter"), "Ernest Friedman-Hill / Sandia National Labs < > " + PsConfig.getMessage("PSGrPostScriptGraphics"), "Darius Bacon <djello@well.com> " + PsConfig.getMessage("ExpressionParsing"), "Bruce R. Miller <bruce.miller@nist.gov> " + PsConfig.getMessage("GuiStackLayoutManager"), "Jef Poskanzer <jef@acme.com, www.acme.com/java> " + PsConfig.getMessage("ImageExport") + ", " + PsConfig.getMessage("ClassFmt") + ", " + PsConfig.getMessage("MessageBoxes"), "Marty Hall <hall@apl.jhu.edu, www.apl.jhu.edu/~hall> " + PsConfig.getMessage("ImageLabel") + ", " + PsConfig.getMessage("ThickEdges")};
    }

    public static String getAuthors() {
        String string = AUTHOR[0];
        int n = 1;
        while (n < AUTHOR.length) {
            string = string + ", " + AUTHOR[n];
            ++n;
        }
        return string;
    }

    public static String getEmail() {
        return EMAIL;
    }

    public static char getFileSeparator() {
        return m_fileSeparator;
    }
}

