/*
 * Decompiled with CFR 0.152.
 */
package jv.object;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TextField;
import java.io.Serializable;
import jv.object.PsConfig;
import jv.object.PsStackLayout;
import jv.object.PsUpdateIf;

public class PsPanel
extends Panel
implements PsUpdateIf,
Serializable {
    public static final int BORDER_NONE = 0;
    public static final int BORDER_LINE = 1;
    public static final int BORDER_SUNK = 2;
    public static final int BORDER_GROOVE = 3;
    protected int m_borderType = 0;
    protected int m_insetSize = 2;
    protected Label m_lTitle;
    protected String m_language;
    protected PsUpdateIf m_parent;
    protected Image m_image;

    private static void drawLineRect(Graphics graphics, Rectangle rectangle) {
        graphics.setColor(Color.black);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y);
        graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1, rectangle.x, rectangle.y + rectangle.height - 1);
        graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x, rectangle.y);
    }

    public void drawText(Graphics graphics, Point point, String string) {
        graphics.setFont(this.getFont());
        graphics.setColor(this.getForeground());
        graphics.drawString(string, point.x, point.y);
    }

    public void setBorderType(int n) {
        this.m_borderType = n;
    }

    public Insets getInsets() {
        return new Insets(this.m_insetSize, this.m_insetSize, this.m_insetSize, this.m_insetSize);
    }

    private static void drawSunkRect(Graphics graphics, Rectangle rectangle) {
        graphics.setColor(Color.darkGray);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 2, rectangle.y);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 2);
        graphics.setColor(Color.black);
        graphics.drawLine(rectangle.x + 2, rectangle.y + 1, rectangle.x + rectangle.width - 3, rectangle.y + 1);
        graphics.drawLine(rectangle.x + 1, rectangle.y + 1, rectangle.x + 1, rectangle.y + rectangle.height - 3);
        graphics.setColor(Color.lightGray);
        graphics.drawLine(rectangle.x + 1, rectangle.y + rectangle.height - 2, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 2);
        graphics.drawLine(rectangle.x + rectangle.width - 2, rectangle.y + 1, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 2);
        graphics.setColor(Color.white);
        graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        this.m_parent = psUpdateIf;
    }

    public PsPanel() {
        this.setLayout(new PsStackLayout(1));
        this.setInsetSize(this.m_insetSize);
        this.m_language = PsConfig.getLanguage();
        if (this.instanceOf("PsPanel")) {
            this.init();
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.m_image != null) {
            Dimension dimension = super.getSize();
            graphics.drawImage(this.m_image, 0, 0, dimension.width, dimension.height, this);
        }
        if (this.m_borderType != 0) {
            this.drawBorder(graphics, this.m_borderType);
        }
    }

    public void setVisible(boolean bl) {
        if (bl && this.m_parent != null) {
            this.update(this.m_parent);
        }
        super.setVisible(bl);
    }

    public Label addSubTitle(String string) {
        Label label = new Label(string, 0);
        label.setFont(PsConfig.getFont(3));
        this.add(label);
        return label;
    }

    public PsUpdateIf getFather() {
        return this.m_parent;
    }

    public TextField addTextField(String string, int n) {
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 2));
        Label label = new Label(string);
        panel.add(label);
        TextField textField = new TextField(n);
        panel.add(textField);
        this.add(panel);
        return textField;
    }

    public void drawBorder(Graphics graphics, int n) {
        Rectangle rectangle = new Rectangle(this.getSize());
        switch (n) {
            case 1: {
                PsPanel.drawLineRect(graphics, rectangle);
                return;
            }
            case 2: {
                PsPanel.drawSunkRect(graphics, rectangle);
                return;
            }
            case 3: {
                PsPanel.drawGrooveRect(graphics, rectangle);
                return;
            }
        }
    }

    public static void drawBorder(Component component, Graphics graphics, int n) {
        Rectangle rectangle = new Rectangle(component.getSize());
        switch (n) {
            case 1: {
                PsPanel.drawLineRect(graphics, rectangle);
                return;
            }
            case 2: {
                PsPanel.drawSunkRect(graphics, rectangle);
                return;
            }
            case 3: {
                PsPanel.drawGrooveRect(graphics, rectangle);
                return;
            }
        }
    }

    public String getLanguage() {
        return this.m_language;
    }

    public boolean update(Object object) {
        if (object == this.m_parent) {
            return true;
        }
        if (object != null) {
            return false;
        }
        if (this.m_parent != null) {
            return this.m_parent.update(this);
        }
        return false;
    }

    public void addLine(int n) {
        this.add(new PsLine(n));
    }

    public Panel addLabelComponent(String string, Component component) {
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 2));
        panel.add(new Label(string));
        panel.add(component);
        this.add(panel);
        return panel;
    }

    public void update(Graphics graphics) {
        if (this.m_image != null) {
            this.paint(graphics);
            return;
        }
        super.update(graphics);
    }

    public Label getTitle() {
        return this.m_lTitle;
    }

    public void setTitle(String string) {
        if (this.m_lTitle == null) {
            this.m_lTitle = new Label(string);
            return;
        }
        this.m_lTitle.setText(string);
    }

    public void setInsetSize(int n) {
        this.m_insetSize = n;
    }

    public void setImage(Image image) {
        if (image != null) {
            this.setLayout(null);
        }
        this.m_image = image;
    }

    private static void drawGrooveRect(Graphics graphics, Rectangle rectangle) {
        graphics.setColor(Color.darkGray);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 1);
        graphics.drawLine(rectangle.x + 2, rectangle.y + rectangle.height - 2, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 2);
        graphics.drawLine(rectangle.x + rectangle.width - 2, rectangle.y + 2, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 2);
        graphics.setColor(Color.white);
        graphics.drawLine(rectangle.x + 1, rectangle.y + 1, rectangle.x + rectangle.width - 1, rectangle.y + 1);
        graphics.drawLine(rectangle.x + 1, rectangle.y + 1, rectangle.x + 1, rectangle.y + rectangle.height - 1);
        graphics.drawLine(rectangle.x + 2, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y + 2, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
    }

    public final boolean instanceOf(String string) {
        String string2 = this.getClass().getName();
        return string2.endsWith(string);
    }

    public void init() {
        ((Component)this).setFont(PsConfig.getFont(0));
    }

    public boolean hasTitle() {
        return this.m_lTitle != null;
    }

    public Label addTitle(String string) {
        this.m_lTitle = new Label(string, 0);
        this.m_lTitle.setFont(PsConfig.getFont(3));
        this.add(this.m_lTitle);
        return this.m_lTitle;
    }

    class PsLine
    extends Canvas {
        protected int m_size;

        public PsLine(int n) {
            PsPanel.this.getClass();
            this.m_size = 1;
            this.m_size = n;
            this.setSize(10, 10);
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            Color color = this.getBackground();
            Color color2 = this.getForeground();
            Dimension dimension = this.getSize();
            int n = 0;
            int n2 = 0;
            int n3 = n + dimension.width;
            int n4 = n2 + dimension.height;
            int n5 = (n2 + n4 - this.m_size) / 2;
            graphics.setColor(new Color(Math.max(color.getRed() - 64, 0), Math.max(color.getGreen() - 64, 0), Math.max(color.getBlue() - 64, 0)));
            graphics.drawLine(n + 1, n5, n3 - 1, n5);
            graphics.setColor(color);
            int n6 = 1;
            while (n6 < this.m_size) {
                graphics.drawLine(n + 1, n5 + n6, n3 - 1, n5 + n6);
                ++n6;
            }
            graphics.setColor(new Color(Math.min(color.getRed() + 32, 255), Math.min(color.getGreen() + 32, 255), Math.min(color.getBlue() + 32, 255)));
            graphics.drawLine(n + 1, n5 + this.m_size, n3 - 1, n5 + this.m_size);
            graphics.setColor(color2);
        }
    }
}

