/*
 * Decompiled with CFR 0.152.
 */
package jv.project;

import java.awt.Menu;
import java.awt.MenuItem;
import java.util.Enumeration;
import java.util.Vector;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsPanel;
import jv.object.PsUtil;
import jv.objectGui.PsMethodMenu;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.project.PvDisplayIf;
import jv.project.PvGeometryIf;
import jv.project.PvPickEvent;
import jv.vecmath.P_Vector;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PgGeometry
extends PsObject
implements PgGeometryIf,
Cloneable {
    protected int m_dim;
    protected int m_dimOfSimplex = 0;
    protected boolean m_bShowing = true;
    protected boolean m_bShowTitle;
    protected boolean m_bShowBndBox;
    protected boolean m_bShowCenter;
    protected PdVector m_center = null;
    protected int m_ambientSpace = 0;
    protected int m_ambientProj = 0;
    protected PdMatrix m_modelMatrix = null;
    protected PsMethodMenu m_methodMenu = null;
    protected transient Vector m_displayList = null;
    protected PiVector[] m_labelAttribute = PiVector.realloc(null, 6, 4);

    public int addPolygon(PiVector piVector) {
        return -1;
    }

    public boolean hasTagPolygon(int n, int n2) {
        return false;
    }

    public PvPickEvent intersectionWithLine(PdVector pdVector, PdVector pdVector2) {
        return null;
    }

    public boolean isShowingBndBox() {
        return this.m_bShowBndBox;
    }

    public PsPanel getMaterialPanel() {
        PsPanel psPanel;
        if (this.hasInspector("Material")) {
            psPanel = this.getInspector("Material");
            if (psPanel.getLanguage().equals(PsConfig.getLanguage())) {
                return psPanel;
            }
            this.removeInspector("Material");
        }
        if ((psPanel = (PsPanel)PsUtil.newInstance(this.getClass(), "_MP")) == null) {
            return null;
        }
        this.addInspector("Material", psPanel);
        return psPanel;
    }

    public void showBndBox(boolean bl) {
        this.m_bShowBndBox = bl;
    }

    public int getAmbientProjection() {
        return this.m_ambientProj;
    }

    public void setAmbientProjection(int n) {
        this.m_ambientProj = n;
    }

    public int addElement(PiVector piVector) {
        return -1;
    }

    public boolean hasTagElement(int n, int n2) {
        return false;
    }

    public boolean isVisible() {
        return this.m_bShowing;
    }

    public int addVertex(PdVector pdVector) {
        return -1;
    }

    public boolean hasTagVertex(int n, int n2) {
        return false;
    }

    public Object clone() {
        PgGeometry pgGeometry = (PgGeometry)super.clone();
        if (pgGeometry == null) {
            return null;
        }
        if (this.m_center != null) {
            pgGeometry.m_center = (PdVector)this.m_center.clone();
        }
        if (this.m_modelMatrix != null) {
            pgGeometry.m_modelMatrix = (PdMatrix)this.m_modelMatrix.clone();
        }
        if (this.m_methodMenu != null) {
            pgGeometry.m_methodMenu = (PsMethodMenu)this.m_methodMenu.clone();
            pgGeometry.m_methodMenu.init(pgGeometry);
        }
        pgGeometry.m_displayList = null;
        pgGeometry.m_labelAttribute = (PiVector[])P_Vector.clone(this.m_labelAttribute);
        return pgGeometry;
    }

    public int getAmbientSpace() {
        return this.m_ambientSpace;
    }

    public void setAmbientSpace(int n) {
        this.m_ambientSpace = n;
    }

    public Enumeration getDisplays() {
        if (this.m_displayList == null) {
            return null;
        }
        return this.m_displayList.elements();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(super.toString());
        stringBuffer.append("\t ******* PgGeometry ***********\n");
        stringBuffer.append("\t Registered Displays:\n");
        if (this.m_displayList != null) {
            Enumeration enumeration = this.m_displayList.elements();
            while (enumeration.hasMoreElements()) {
                PvDisplayIf pvDisplayIf = (PvDisplayIf)enumeration.nextElement();
                stringBuffer.append("\t\t display = " + pvDisplayIf.getName() + "\n");
            }
        } else {
            stringBuffer.append("\t\t no displays\n");
        }
        stringBuffer.append("\t Dimension of vertices: m_dim = " + this.m_dim + "\n");
        return stringBuffer.toString();
    }

    public PdVector getCenter() {
        if (this.m_center == null) {
            this.m_center = new PdVector(this.m_dim);
        }
        return this.m_center;
    }

    public void setCenter(PdVector pdVector) {
        if (pdVector == null) {
            PsDebug.warning("missing argument.");
            return;
        }
        if (this.m_center == null) {
            this.m_center = new PdVector(this.m_dim);
        }
        this.m_center.copy(pdVector);
    }

    public boolean isShowingCenter() {
        return this.m_bShowCenter;
    }

    public void showCenter(boolean bl) {
        this.m_bShowCenter = bl;
    }

    public void copy(PgGeometry pgGeometry) {
        super.copy(pgGeometry);
        this.setCenter(pgGeometry.getCenter());
        PiVector.copy(this.m_labelAttribute, 0, pgGeometry.m_labelAttribute, 0, pgGeometry.m_labelAttribute.length);
    }

    public double getDiameter() {
        PdVector[] pdVectorArray = this.getBounds();
        if (pdVectorArray == null) {
            return 0.0;
        }
        return PdVector.dist(pdVectorArray[0], pdVectorArray[1]);
    }

    public PgGeometry reflect(PdMatrix pdMatrix, boolean bl) {
        if (pdMatrix == null || pdMatrix.getSize() != this.getDimOfVertices() + 1) {
            PsDebug.warning("missing or wrong transformation matrix mat = " + pdMatrix);
            return null;
        }
        PgGeometry pgGeometry = (PgGeometry)this.clone();
        String string = this.getName();
        if (string == null || !string.startsWith("Reflect")) {
            string = "Reflect(0) of " + string;
        } else {
            String string2;
            int n;
            int n2 = string.indexOf("(");
            if (n2 != -1) {
                n = string.indexOf(")");
                string2 = string.substring(n2 + 1, n);
                n2 = Integer.parseInt(string2) + 1;
            }
            n = string.indexOf(" of ");
            string2 = string.substring(n + 4, string.length());
            string = "Reflect(" + n2 + ") of " + string2;
        }
        pgGeometry.setName(string);
        return pgGeometry;
    }

    public void init() {
        super.init();
        this.m_bShowing = true;
        this.m_bShowBndBox = false;
        this.m_bShowCenter = false;
        this.m_bShowTitle = false;
    }

    public Menu fillMethodMenu(Menu menu) {
        Class clazz;
        if (this.m_methodMenu == null || !this.m_methodMenu.getLanguage().equals(PsConfig.getLanguage())) {
            this.m_methodMenu = (PsMethodMenu)PsUtil.newInstance(this.getClass(), "_Menu");
            if (this.m_methodMenu == null) {
                PsDebug.warning("could not create menu");
                return null;
            }
            this.m_methodMenu.init(this);
            clazz = this.getClass();
            try {
                do {
                    String string = clazz.getName();
                    String string2 = string.substring(string.lastIndexOf(46) + 1, string.length());
                    PsMethodMenu psMethodMenu = (PsMethodMenu)PsUtil.newInstance("jvx.geom." + string2 + "_Menu");
                    if (psMethodMenu == null) continue;
                    psMethodMenu.init(this);
                    Enumeration enumeration = psMethodMenu.elements();
                    while (enumeration.hasMoreElements()) {
                        this.m_methodMenu.addElement((MenuItem)enumeration.nextElement());
                    }
                    break;
                } while ((clazz = clazz.getSuperclass()) != null);
            }
            catch (SecurityException securityException) {
                PsDebug.warning("failed with security exception,\n\t SecurityExceptionEx = " + securityException.toString() + ", Message = " + securityException.getMessage());
            }
        }
        menu.removeAll();
        clazz = this.m_methodMenu.elements();
        while (clazz.hasMoreElements()) {
            menu.add((MenuItem)clazz.nextElement());
        }
        return menu;
    }

    public boolean merge(PgGeometryIf pgGeometryIf) {
        if (pgGeometryIf == null) {
            PsDebug.warning("missing argument.", this);
            return false;
        }
        if (this.getDimOfVertices() != pgGeometryIf.getDimOfVertices()) {
            PsDebug.warning("different dimension of vertices.", this);
            return false;
        }
        return true;
    }

    public PiVector getElement(int n) {
        return null;
    }

    public boolean setElement(int n, PiVector piVector) {
        return false;
    }

    public void clearTagElement(int n, int n2) {
    }

    public static PdVector getCenterOfElement(PdVector pdVector, PdVector[] pdVectorArray, int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            PsDebug.warning("missing index array");
            return pdVector;
        }
        pdVector.setConstant(0.0);
        int n = 0;
        while (n < nArray.length) {
            pdVector.add(pdVectorArray[nArray[n]]);
            ++n;
        }
        pdVector.multScalar(1.0 / (double)nArray.length);
        return pdVector;
    }

    public int getDimOfVertices() {
        return this.m_dim;
    }

    public boolean hasDisplay(PvDisplayIf pvDisplayIf) {
        if (this.m_displayList == null) {
            return false;
        }
        return this.m_displayList.contains(pvDisplayIf);
    }

    public boolean removeDisplay(PvDisplayIf pvDisplayIf) {
        if (this.m_displayList == null) {
            return false;
        }
        return this.m_displayList.removeElement(pvDisplayIf);
    }

    public boolean update(Object object) {
        if (!super.update(object)) {
            PsDebug.warning("super has returned 'false'");
            PsDebug.warning("\tthis     = " + this.getClass().getName() + ", name " + this.getName());
            if (object == null) {
                PsDebug.warning("\tevent    = null");
            } else if (object instanceof PsObject) {
                PsDebug.warning("\tevent    = " + object.getClass().getName() + ", name=" + ((PsObject)object).getName());
            } else if (object instanceof PsPanel) {
                PsDebug.warning("\tevent    = " + object.getClass().getName() + ", name=" + ((PsPanel)object).getName());
            } else {
                PsDebug.warning("\tevent    = " + object.getClass().getName());
            }
        }
        if (this.m_displayList != null) {
            Enumeration enumeration = this.m_displayList.elements();
            while (enumeration.hasMoreElements()) {
                PvDisplayIf pvDisplayIf = (PvDisplayIf)enumeration.nextElement();
                pvDisplayIf.update(this);
            }
        }
        return true;
    }

    public PiVector getLabelAttribute(int n) {
        if (n < 0 || this.m_labelAttribute.length <= n) {
            PsDebug.warning("type out of bounds, type = " + n);
            return null;
        }
        return this.m_labelAttribute[n];
    }

    public boolean setLabelAttribute(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n < 0 || this.m_labelAttribute.length <= n) {
            PsDebug.warning("type=" + n + " out of bounds.");
            return false;
        }
        this.m_labelAttribute[n].setEntry(0, n2);
        this.m_labelAttribute[n].setEntry(1, n3);
        this.m_labelAttribute[n].setEntry(2, n4);
        this.m_labelAttribute[n].setEntry(3, n5);
        this.m_labelAttribute[n].setEntry(4, n6);
        return true;
    }

    public boolean setLabelAttribute(int n, PiVector piVector) {
        if (piVector == null || piVector.getSize() < 5) {
            PsDebug.warning("missing attribute parameter.");
            return false;
        }
        int[] nArray = piVector.getEntries();
        this.setLabelAttribute(n, nArray[0], nArray[1], nArray[2], nArray[3], nArray[4]);
        return true;
    }

    public boolean isShowingTitle() {
        return this.m_bShowTitle;
    }

    public void showTitle(boolean bl) {
        this.m_bShowTitle = bl;
    }

    public int getDimOfSimplex() {
        return this.m_dimOfSimplex;
    }

    public void setDimOfSimplex(int n) {
        this.m_dimOfSimplex = n;
    }

    public PiVector getPolygon(int n) {
        return null;
    }

    public boolean setPolygon(int n, PiVector piVector) {
        return false;
    }

    public void clearTagPolygon(int n, int n2) {
    }

    public PdVector[] getBounds() {
        PdVector[] pdVectorArray = new PdVector[]{new PdVector(this.m_dim), new PdVector(this.m_dim)};
        return pdVectorArray;
    }

    public PsPanel getControlPanel() {
        PsPanel psPanel;
        if (this.hasInspector("Control")) {
            psPanel = this.getInspector("Control");
            if (psPanel.getLanguage().equals(PsConfig.getLanguage())) {
                return psPanel;
            }
            this.removeInspector("Control");
        }
        if ((psPanel = (PsPanel)PsUtil.newInstance(this.getClass(), "_CP")) == null) {
            return null;
        }
        this.addInspector("Control", psPanel);
        return psPanel;
    }

    public int[] removePolygon(int n) {
        return null;
    }

    public boolean isConfigurable(int n) {
        return this.hasTag(n);
    }

    public void setTagPolygon(int n, int n2) {
    }

    public void paint(PvGeometryIf pvGeometryIf) {
        pvGeometryIf.setVisible(this.isVisible());
        pvGeometryIf.setState(69, this.m_bShowBndBox);
        pvGeometryIf.setState(70, this.m_bShowCenter);
        pvGeometryIf.setState(86, this.m_bShowTitle);
        pvGeometryIf.setLabelAttributes(this.m_labelAttribute);
        pvGeometryIf.setAmbientSpace(this.getAmbientSpace());
        pvGeometryIf.setAmbientProjection(this.getAmbientProjection());
        if (this.hasModelMatrix()) {
            pvGeometryIf.setModelMatrix(this.getModelMatrix());
        }
    }

    public boolean blend(double d, PgGeometry pgGeometry, double d2, PgGeometry pgGeometry2) {
        if (pgGeometry == null && pgGeometry2 == null) {
            PsDebug.warning("missing arguments");
            return false;
        }
        if (pgGeometry == null) {
            this.copy(pgGeometry2);
            return true;
        }
        if (pgGeometry2 == null) {
            this.copy(pgGeometry);
            return true;
        }
        this.m_dim = pgGeometry.getDimOfVertices();
        return true;
    }

    public int[] removeElement(int n) {
        return null;
    }

    public PdVector getVertex(int n) {
        return null;
    }

    public boolean setVertex(int n, PdVector pdVector) {
        return false;
    }

    public void clearTagVertex(int n, int n2) {
    }

    public void setVisible(boolean bl) {
        this.m_bShowing = bl;
    }

    public void setTagElement(int n, int n2) {
    }

    public PgGeometry() {
        this.setLabelAttribute(0, 0, 0, 0, 0, 1);
        this.setLabelAttribute(1, 4, 4, 0, 0, 1);
        this.setLabelAttribute(2, -10, 10, 0, 0, 1);
        this.setLabelAttribute(3, -3, 5, 0, 0, 1);
        this.setLabelAttribute(4, -3, 5, 0, 0, 1);
        this.setLabelAttribute(5, 4, 4, 0, 0, 3);
    }

    public PgGeometry(int n) {
        this();
        this.m_dim = n;
    }

    public int[] removeVertex(int n) {
        return null;
    }

    public void setTagVertex(int n, int n2) {
    }

    public PdMatrix getModelMatrix() {
        if (this.m_modelMatrix == null) {
            this.m_modelMatrix = new PdMatrix(4);
            this.m_modelMatrix.setIdentity();
        }
        return PdMatrix.copyNew(this.m_modelMatrix);
    }

    public void setModelMatrix(PdMatrix pdMatrix) {
        if (this.m_modelMatrix == null) {
            this.m_modelMatrix = new PdMatrix(4);
        }
        this.m_modelMatrix.copy(pdMatrix);
    }

    public boolean addDisplay(PvDisplayIf pvDisplayIf) {
        if (this.m_displayList == null) {
            this.m_displayList = new Vector();
        } else if (this.hasDisplay(pvDisplayIf)) {
            PsDebug.warning("display = " + pvDisplayIf.getName() + " of display already used.");
            return false;
        }
        this.m_displayList.addElement(pvDisplayIf);
        return true;
    }

    public PgJvxSrc getJvx() {
        PgJvxSrc pgJvxSrc = new PgJvxSrc(this.m_dim);
        pgJvxSrc.setName(this.getName());
        pgJvxSrc.setVisible(this.isVisible());
        pgJvxSrc.showBndBox(this.isShowingBndBox());
        pgJvxSrc.showCenter(this.isShowingCenter());
        pgJvxSrc.showTitle(this.isShowingTitle());
        PiVector.copy(pgJvxSrc.m_labelAttribute, 0, this.m_labelAttribute, 0, this.m_labelAttribute.length);
        return pgJvxSrc;
    }

    public void setJvx(PgJvxSrc pgJvxSrc) {
        this.init();
        this.m_dim = pgJvxSrc.getDimOfVertices();
        this.setName(pgJvxSrc.getName());
        this.setVisible(pgJvxSrc.isVisible());
        this.showBndBox(pgJvxSrc.isShowingBndBox());
        this.showCenter(pgJvxSrc.isShowingCenter());
        this.showTitle(pgJvxSrc.isShowingTitle());
        PiVector.copy(this.m_labelAttribute, 0, pgJvxSrc.m_labelAttribute, 0, pgJvxSrc.m_labelAttribute.length);
    }

    public boolean hasModelMatrix() {
        return this.m_modelMatrix != null;
    }
}

