/*
 * Decompiled with CFR 0.152.
 */
package jv.rsrc;

import java.awt.Component;
import jv.loader.PsXmlLoader;
import jv.loader.PsXmlNode;
import jv.loader.PsXmlSrc;
import jv.number.PdColor;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.rsrc.PsJavaView_IP;
import jv.vecmath.PdVector;

public final class PsJavaView
extends PsObject {
    public static String m_version;
    public static String m_licenseType;
    public static String m_licenseUsage;
    public static String m_licenseId;
    public static String m_licenseExpire;
    public static String m_licenseeFirstName;
    public static String m_licenseeLastName;
    public static String m_licenseeOrganization;
    public static String m_licenseeEmail;
    public static String m_licenseeUrl;
    public static String m_userFirstName;
    public static String m_userLastName;
    public static String m_userOrganization;
    public static String m_userEmail;
    public static String m_userUrl;
    public static int MONITOR_XLARGE;
    public static int MONITOR_LARGE;
    public static int MONITOR_XCGA;
    public static int MONITOR_VGA;
    public static int MONITOR_DOS;
    public static int MONITOR_PALM;
    public static int MONITOR_USER;
    public static int m_monitorType;
    public static String m_monitorMouse;
    protected static int[][] m_monitorSize;
    protected static int[][] m_controlSize;
    protected static int[][] m_aboutSize;
    protected static int[][] m_helpSize;
    protected static int[][] m_consoleSize;
    protected static int[][] m_animationSize;
    protected static int[][] m_newProjectSize;
    protected static int[][] m_importModelSize;
    protected static int[][] m_exportBounds;
    public static final int MONITOR = 0;
    public static final int WINDOW_CONTROL = 1;
    public static final int WINDOW_ABOUT = 2;
    public static final int WINDOW_HELP = 3;
    public static final int WINDOW_CONSOLE = 4;
    public static final int WINDOW_ANIMATION = 5;
    public static final int WINDOW_NEW_PROJECT = 6;
    public static final int WINDOW_IMPORT_MODEL = 7;
    public static final int WINDOW_EXPORT_MODEL = 8;
    public static String m_viewerScreen;
    public static String m_viewerVisible;
    public static String m_controlVisible;
    public static String m_consoleVisible;
    public static String m_cameraProjection;
    public static PdVector m_view;
    public static PdVector m_interest;
    public static double m_cameraDistance;
    public static double m_cameraRoll;
    public static boolean m_transformEnable;
    public static String m_transformAmbient;
    public static String m_transformProjection;
    public static boolean m_cameraClip;
    public static double m_cameraClipNear;
    public static double m_cameraClipFar;
    public static int m_displayHeight;
    public static int m_displayWidth;
    public static boolean m_displayAutorotate;
    public static boolean m_displayBackside;
    public static boolean m_displayBackimage;
    public static boolean m_displayDepth;
    public static boolean m_displayEdgeAura;
    public static boolean m_displayXYGrid;
    public static boolean m_displaySorting;
    public static PdColor m_background;
    public static PdColor m_foreground;
    protected static String m_title;
    private static /* synthetic */ Class class$jv$rsrc$PsJavaView;

    public int[] getWindowSize(int n) {
        int[] nArray;
        switch (n) {
            case 0: {
                nArray = m_monitorSize[m_monitorType];
                break;
            }
            case 1: {
                nArray = m_controlSize[m_monitorType];
                break;
            }
            case 2: {
                nArray = m_aboutSize[m_monitorType];
                break;
            }
            case 3: {
                nArray = m_helpSize[m_monitorType];
                break;
            }
            case 4: {
                nArray = m_consoleSize[m_monitorType];
                break;
            }
            case 5: {
                nArray = m_animationSize[m_monitorType];
                break;
            }
            case 6: {
                nArray = m_newProjectSize[m_monitorType];
                break;
            }
            case 7: {
                nArray = m_importModelSize[m_monitorType];
                break;
            }
            case 8: {
                nArray = m_exportBounds[m_monitorType];
                break;
            }
            default: {
                PsDebug.warning("unknown window identifier = " + n);
                Object var2_3 = null;
                return null;
            }
        }
        int[] nArray2 = new int[]{nArray[0], nArray[1], nArray[2], nArray[3]};
        return nArray2;
    }

    public void showInfoPanel() {
        PsJavaView_IP psJavaView_IP = new PsJavaView_IP();
        psJavaView_IP.setParent(this);
        psJavaView_IP.update(this);
        psJavaView_IP.setLocation(20, 5);
        ((Component)psJavaView_IP).setSize(600, 400);
        ((Component)psJavaView_IP).setVisible(true);
    }

    public PsJavaView() {
        m_licenseType = "non-profit";
        m_licenseId = "100.100.10";
        m_licenseExpire = "unlimited";
        m_licenseeFirstName = "unknown";
        m_licenseeLastName = "unknown";
        m_licenseeOrganization = "unknown";
        m_licenseeEmail = "unknown";
        m_licenseeUrl = "unknown";
        m_userFirstName = "unknown";
        m_userLastName = "unknown";
        m_userOrganization = "unknown";
        m_userEmail = "unknown";
        m_userUrl = "unknown";
        m_view = new PdVector(3);
        m_interest = new PdVector(3);
        m_background = new PdColor();
        m_foreground = new PdColor();
        m_cameraClip = false;
        m_displayAutorotate = false;
        m_displayBackside = true;
        m_displayBackimage = false;
        m_displayDepth = true;
        m_displayEdgeAura = false;
        m_displayXYGrid = false;
        m_displaySorting = true;
        if (this.getClass() == (class$jv$rsrc$PsJavaView != null ? class$jv$rsrc$PsJavaView : (class$jv$rsrc$PsJavaView = PsJavaView.class$("jv.rsrc.PsJavaView")))) {
            this.init();
        }
    }

    public boolean read(String string) {
        if (string == null) {
            PsDebug.warning("missing argument file name.");
            return false;
        }
        PsXmlSrc psXmlSrc = PsXmlLoader.read(string);
        if (psXmlSrc == null) {
            PsDebug.warning("could not read rsrc file = " + string);
            return false;
        }
        this.setXml(psXmlSrc);
        return true;
    }

    private boolean parseFont(int n, PsXmlNode psXmlNode) {
        int n2;
        String string = psXmlNode.getContent();
        if (string == null) {
            PsDebug.warning("missing font type");
            return false;
        }
        if (string.equalsIgnoreCase("text")) {
            n2 = 0;
        } else if (string.equalsIgnoreCase("fixed")) {
            n2 = 1;
        } else if (string.equalsIgnoreCase("menu")) {
            n2 = 2;
        } else if (string.equalsIgnoreCase("header2")) {
            n2 = 3;
        } else if (string.equalsIgnoreCase("header4")) {
            n2 = 4;
        } else {
            PsDebug.warning("invalid font type");
            return false;
        }
        String string2 = psXmlNode.getAttribute("name");
        if (string2 != null && string2.equals("")) {
            string2 = null;
        }
        int n3 = -1;
        String string3 = psXmlNode.getAttribute("style");
        if (string3 != null) {
            if (string3.equalsIgnoreCase("bold")) {
                n3 = 1;
            } else if (string3.equalsIgnoreCase("plain")) {
                n3 = 0;
            } else if (string3.equalsIgnoreCase("italic")) {
                n3 = 2;
            } else if (string3.equalsIgnoreCase("")) {
                n3 = -1;
            } else {
                PsDebug.warning("invalid font style = " + string3);
                return false;
            }
        }
        int n4 = -1;
        String string4 = psXmlNode.getAttribute("size");
        if (string4 != null) {
            if (string4.equals("")) {
                n4 = -1;
            } else {
                try {
                    n4 = Integer.parseInt(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    PsDebug.warning("invalid font size = " + string4);
                    return false;
                }
            }
        }
        PsConfig.setFont(n, n2, string2, n3, n4);
        return true;
    }

    public PsXmlSrc getXml() {
        PsXmlSrc psXmlSrc = new PsXmlSrc();
        psXmlSrc.setDocName("javaview-rsrc");
        psXmlSrc.setDocType("http://www-sfb288.math.tu-berlin.de/vgp/javaview/rsrc/javaview.dtd");
        return this.fillRsrcTree(psXmlSrc);
    }

    public void setXml(PsXmlSrc psXmlSrc) {
        PsXmlNode psXmlNode;
        Object object;
        PsXmlNode psXmlNode2;
        PsXmlNode psXmlNode3;
        Object object2;
        Object object3;
        PsXmlNode psXmlNode4;
        PsXmlNode psXmlNode5;
        if (psXmlSrc == null) {
            PsDebug.warning("missing resource.");
            return;
        }
        PsXmlNode psXmlNode6 = psXmlSrc.getRootNode();
        if (psXmlNode6 == null) {
            PsDebug.warning("missing root node.");
            return;
        }
        m_title = psXmlSrc.getRsrcFile();
        PsXmlNode psXmlNode7 = PsXmlSrc.getRsrcNode(psXmlNode6, "javaview-rsrc");
        if (psXmlNode7 == null) {
            this.fillRsrcTree(psXmlSrc);
            psXmlNode7 = PsXmlSrc.getRsrcNode(psXmlNode6, "javaview-rsrc");
        }
        m_version = PsXmlSrc.getRsrc(psXmlNode7, "version");
        PsXmlNode psXmlNode8 = PsXmlSrc.getRsrcNode(psXmlNode7, "license");
        if (psXmlNode8 != null) {
            m_licenseType = psXmlNode8.getAttribute("type");
            m_licenseUsage = psXmlNode8.getAttribute("usage");
            m_licenseId = PsXmlSrc.getRsrc(psXmlNode8, "license-id");
            m_licenseExpire = PsXmlSrc.getRsrc(psXmlNode8, "license-expire");
            psXmlNode5 = PsXmlSrc.getRsrcNode(psXmlNode8, "licensee");
            if (psXmlNode5 != null) {
                m_licenseeFirstName = PsXmlSrc.getRsrc(psXmlNode5, "firstname");
                m_licenseeLastName = PsXmlSrc.getRsrc(psXmlNode5, "lastname");
                m_licenseeOrganization = PsXmlSrc.getRsrc(psXmlNode5, "organization");
                m_licenseeEmail = PsXmlSrc.getRsrc(psXmlNode5, "email");
                m_licenseeUrl = PsXmlSrc.getRsrc(psXmlNode5, "url");
            }
        }
        if ((psXmlNode5 = PsXmlSrc.getRsrcNode(psXmlNode7, "windows")) != null) {
            psXmlNode4 = PsXmlSrc.getRsrcNode(psXmlNode5, "monitor");
            if (psXmlNode4 != null) {
                object3 = psXmlNode4.getAttribute("size");
                if (object3 != null) {
                    m_monitorType = ((String)object3).startsWith("1600") ? MONITOR_XLARGE : (((String)object3).startsWith("1280") ? MONITOR_LARGE : (((String)object3).startsWith("1024") ? MONITOR_XCGA : (((String)object3).startsWith("800") ? MONITOR_VGA : (((String)object3).startsWith("640") ? MONITOR_DOS : (((String)object3).startsWith("320") ? MONITOR_PALM : MONITOR_USER)))));
                }
                if ((object2 = psXmlNode4.getAttribute("mouse")) != null) {
                    m_monitorMouse = object2;
                }
            }
            if ((object3 = PsXmlSrc.getRsrcNode(psXmlNode5, "viewer")) != null) {
                m_viewerScreen = ((PsXmlNode)object3).getAttribute("show");
                m_viewerVisible = ((PsXmlNode)object3).getAttribute("visible");
            }
            if ((object2 = PsXmlSrc.getRsrcNode(psXmlNode5, "control")) != null) {
                m_controlVisible = ((PsXmlNode)object2).getAttribute("visible");
            }
            if ((psXmlNode3 = PsXmlSrc.getRsrcNode(psXmlNode5, "console")) != null) {
                m_consoleVisible = psXmlNode3.getAttribute("visible");
            }
            if ((psXmlNode2 = PsXmlSrc.getRsrcNode(psXmlNode5, "fonts")) != null) {
                PsXmlNode psXmlNode9;
                PsXmlNode psXmlNode10;
                PsXmlNode psXmlNode11;
                int n;
                object = psXmlNode2.getChildren("font");
                if (object != null) {
                    n = 0;
                    while (n < ((PsXmlNode[])object).length) {
                        this.parseFont(PsConfig.getOSId(), object[n]);
                        ++n;
                    }
                }
                if ((psXmlNode = PsXmlSrc.getRsrcNode(psXmlNode2, "oswin")) != null && (object = psXmlNode.getChildren("font")) != null) {
                    n = 0;
                    while (n < ((PsXmlNode[])object).length) {
                        this.parseFont(0, object[n]);
                        ++n;
                    }
                }
                if ((psXmlNode11 = PsXmlSrc.getRsrcNode(psXmlNode2, "osirix")) != null && (object = psXmlNode11.getChildren("font")) != null) {
                    n = 0;
                    while (n < ((PsXmlNode[])object).length) {
                        this.parseFont(1, object[n]);
                        ++n;
                    }
                }
                if ((psXmlNode10 = PsXmlSrc.getRsrcNode(psXmlNode2, "ossolaris")) != null && (object = psXmlNode10.getChildren("font")) != null) {
                    n = 0;
                    while (n < ((PsXmlNode[])object).length) {
                        this.parseFont(2, object[n]);
                        ++n;
                    }
                }
                if ((psXmlNode9 = PsXmlSrc.getRsrcNode(psXmlNode2, "oslinux")) != null && (object = psXmlNode9.getChildren("font")) != null) {
                    n = 0;
                    while (n < ((PsXmlNode[])object).length) {
                        this.parseFont(3, object[n]);
                        ++n;
                    }
                }
            }
        }
        if ((psXmlNode4 = PsXmlSrc.getRsrcNode(psXmlNode7, "user")) != null) {
            m_userFirstName = PsXmlSrc.getRsrc(psXmlNode4, "firstname");
            m_userLastName = PsXmlSrc.getRsrc(psXmlNode4, "lastname");
            m_userEmail = PsXmlSrc.getRsrc(psXmlNode4, "email");
            m_userUrl = PsXmlSrc.getRsrc(psXmlNode4, "url");
        }
        if ((object3 = PsXmlSrc.getRsrcNode(psXmlNode7, "display")) != null) {
            object2 = PsXmlSrc.getRsrcNode((PsXmlNode)object3, "camera");
            if (object2 != null) {
                m_cameraProjection = PsXmlSrc.getRsrc((PsXmlNode)object2, "projection");
                psXmlNode3 = PsXmlSrc.getRsrcNode((PsXmlNode)object2, "viewpoint");
                if (psXmlNode3 != null) {
                    m_view.setEntry(0, PsXmlSrc.getRsrcAsDouble(psXmlNode3, "x"));
                    m_view.setEntry(1, PsXmlSrc.getRsrcAsDouble(psXmlNode3, "y"));
                    m_view.setEntry(2, PsXmlSrc.getRsrcAsDouble(psXmlNode3, "z"));
                }
                if ((psXmlNode2 = PsXmlSrc.getRsrcNode((PsXmlNode)object2, "interest")) != null) {
                    m_interest.setEntry(0, PsXmlSrc.getRsrcAsDouble(psXmlNode2, "x"));
                    m_interest.setEntry(1, PsXmlSrc.getRsrcAsDouble(psXmlNode2, "y"));
                    m_interest.setEntry(2, PsXmlSrc.getRsrcAsDouble(psXmlNode2, "z"));
                }
                m_cameraDistance = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object2, "distance");
                m_cameraRoll = PsXmlSrc.getRsrcAsDouble((PsXmlNode)object2, "roll");
                object = PsXmlSrc.getRsrcNode((PsXmlNode)object2, "transform");
                if (object != null) {
                    m_transformEnable = PsXmlSrc.getRsrcAsBoolean((PsXmlNode)object, "enable");
                    m_transformAmbient = PsXmlSrc.getRsrc((PsXmlNode)object, "ambient");
                    m_transformProjection = PsXmlSrc.getRsrc((PsXmlNode)object, "projection");
                }
                if ((psXmlNode = PsXmlSrc.getRsrcNode((PsXmlNode)object2, "clipping")) != null) {
                    m_cameraClip = PsXmlSrc.getRsrcAsBoolean(psXmlNode, "enable");
                    m_cameraClipNear = PsXmlSrc.getRsrcAsDouble(psXmlNode, "near");
                    m_cameraClipFar = PsXmlSrc.getRsrcAsDouble(psXmlNode, "far");
                }
            }
            m_displayHeight = PsXmlSrc.getRsrcAsInteger((PsXmlNode)object3, "height");
            m_displayWidth = PsXmlSrc.getRsrcAsInteger((PsXmlNode)object3, "width");
            m_displayAutorotate = PsXmlSrc.getRsrcAsBoolean((PsXmlNode)object3, "autorotate");
            m_displayBackimage = PsXmlSrc.getRsrcAsBoolean((PsXmlNode)object3, "backimge");
            m_displayXYGrid = PsXmlSrc.getRsrcAsBoolean((PsXmlNode)object3, "xygrid");
            m_displayBackside = PsXmlSrc.getRsrcAsBoolean((PsXmlNode)object3, "backside");
            m_displayDepth = PsXmlSrc.getRsrcAsBoolean((PsXmlNode)object3, "depth");
            m_displaySorting = PsXmlSrc.getRsrcAsBoolean((PsXmlNode)object3, "sorting");
            m_displayEdgeAura = PsXmlSrc.getRsrcAsBoolean((PsXmlNode)object3, "edgeaura");
            psXmlNode3 = PsXmlSrc.getRsrcNode((PsXmlNode)object3, "background");
            if (psXmlNode3 != null) {
                m_background.setEntry(0, PsXmlSrc.getRsrcAsInteger(psXmlNode3, "r"));
                m_background.setEntry(1, PsXmlSrc.getRsrcAsInteger(psXmlNode3, "g"));
                m_background.setEntry(2, PsXmlSrc.getRsrcAsInteger(psXmlNode3, "b"));
            }
            if ((psXmlNode2 = PsXmlSrc.getRsrcNode((PsXmlNode)object3, "foreground")) != null) {
                m_foreground.setEntry(0, PsXmlSrc.getRsrcAsInteger(psXmlNode3, "r"));
                m_foreground.setEntry(1, PsXmlSrc.getRsrcAsInteger(psXmlNode3, "g"));
                m_foreground.setEntry(2, PsXmlSrc.getRsrcAsInteger(psXmlNode3, "b"));
            }
        }
    }

    static {
        MONITOR_XLARGE = 0;
        MONITOR_LARGE = 1;
        MONITOR_XCGA = 2;
        MONITOR_VGA = 3;
        MONITOR_DOS = 4;
        MONITOR_PALM = 5;
        MONITOR_USER = 6;
        m_monitorType = MONITOR_LARGE;
        m_monitorSize = new int[][]{{1600, 1200}, {1280, 1024}, {1024, 768}, {800, 600}, {640, 480}, {320, 240}, {320, 240}};
        int[][] nArrayArray = new int[7][];
        nArrayArray[0] = new int[]{5, 5, 390, 680};
        nArrayArray[1] = new int[]{5, 5, 390, 680};
        nArrayArray[2] = new int[]{5, 5, 390, 680};
        int[] nArray = new int[4];
        nArray[2] = 320;
        nArray[3] = 600;
        nArrayArray[3] = nArray;
        int[] nArray2 = new int[4];
        nArray2[2] = 250;
        nArray2[3] = 480;
        nArrayArray[4] = nArray2;
        int[] nArray3 = new int[4];
        nArray3[2] = 250;
        nArray3[3] = 240;
        nArrayArray[5] = nArray3;
        int[] nArray4 = new int[4];
        nArray4[2] = 250;
        nArray4[3] = 240;
        nArrayArray[6] = nArray4;
        m_controlSize = nArrayArray;
        int[][] nArrayArray2 = new int[7][];
        nArrayArray2[0] = new int[]{10, 10, 400, 450};
        nArrayArray2[1] = new int[]{10, 10, 400, 450};
        nArrayArray2[2] = new int[]{10, 10, 400, 450};
        int[] nArray5 = new int[4];
        nArray5[2] = 400;
        nArray5[3] = 450;
        nArrayArray2[3] = nArray5;
        int[] nArray6 = new int[4];
        nArray6[2] = 400;
        nArray6[3] = 450;
        nArrayArray2[4] = nArray6;
        int[] nArray7 = new int[4];
        nArray7[2] = 320;
        nArray7[3] = 240;
        nArrayArray2[5] = nArray7;
        int[] nArray8 = new int[4];
        nArray8[2] = 320;
        nArray8[3] = 240;
        nArrayArray2[6] = nArray8;
        m_aboutSize = nArrayArray2;
        int[][] nArrayArray3 = new int[7][];
        nArrayArray3[0] = new int[]{10, 10, 400, 450};
        nArrayArray3[1] = new int[]{10, 10, 400, 450};
        nArrayArray3[2] = new int[]{10, 10, 400, 450};
        int[] nArray9 = new int[4];
        nArray9[2] = 400;
        nArray9[3] = 450;
        nArrayArray3[3] = nArray9;
        int[] nArray10 = new int[4];
        nArray10[2] = 400;
        nArray10[3] = 450;
        nArrayArray3[4] = nArray10;
        int[] nArray11 = new int[4];
        nArray11[2] = 320;
        nArray11[3] = 240;
        nArrayArray3[5] = nArray11;
        int[] nArray12 = new int[4];
        nArray12[2] = 320;
        nArray12[3] = 240;
        nArrayArray3[6] = nArray12;
        m_helpSize = nArrayArray3;
        int[][] nArrayArray4 = new int[7][];
        nArrayArray4[0] = new int[]{10, 10, 500, 350};
        nArrayArray4[1] = new int[]{10, 10, 500, 350};
        nArrayArray4[2] = new int[]{10, 10, 500, 350};
        int[] nArray13 = new int[4];
        nArray13[2] = 500;
        nArray13[3] = 350;
        nArrayArray4[3] = nArray13;
        int[] nArray14 = new int[4];
        nArray14[2] = 500;
        nArray14[3] = 350;
        nArrayArray4[4] = nArray14;
        int[] nArray15 = new int[4];
        nArray15[2] = 320;
        nArray15[3] = 240;
        nArrayArray4[5] = nArray15;
        int[] nArray16 = new int[4];
        nArray16[2] = 320;
        nArray16[3] = 240;
        nArrayArray4[6] = nArray16;
        m_consoleSize = nArrayArray4;
        int[][] nArrayArray5 = new int[7][];
        nArrayArray5[0] = new int[]{10, 10, 400, 300};
        nArrayArray5[1] = new int[]{10, 10, 400, 300};
        nArrayArray5[2] = new int[]{10, 10, 400, 300};
        int[] nArray17 = new int[4];
        nArray17[2] = 400;
        nArray17[3] = 300;
        nArrayArray5[3] = nArray17;
        int[] nArray18 = new int[4];
        nArray18[2] = 400;
        nArray18[3] = 300;
        nArrayArray5[4] = nArray18;
        int[] nArray19 = new int[4];
        nArray19[2] = 320;
        nArray19[3] = 240;
        nArrayArray5[5] = nArray19;
        int[] nArray20 = new int[4];
        nArray20[2] = 320;
        nArray20[3] = 240;
        nArrayArray5[6] = nArray20;
        m_animationSize = nArrayArray5;
        int[][] nArrayArray6 = new int[7][];
        nArrayArray6[0] = new int[]{10, 10, 400, 350};
        nArrayArray6[1] = new int[]{10, 10, 400, 350};
        nArrayArray6[2] = new int[]{10, 10, 400, 350};
        int[] nArray21 = new int[4];
        nArray21[2] = 400;
        nArray21[3] = 350;
        nArrayArray6[3] = nArray21;
        int[] nArray22 = new int[4];
        nArray22[2] = 400;
        nArray22[3] = 350;
        nArrayArray6[4] = nArray22;
        int[] nArray23 = new int[4];
        nArray23[2] = 320;
        nArray23[3] = 240;
        nArrayArray6[5] = nArray23;
        int[] nArray24 = new int[4];
        nArray24[2] = 320;
        nArray24[3] = 240;
        nArrayArray6[6] = nArray24;
        m_newProjectSize = nArrayArray6;
        int[][] nArrayArray7 = new int[7][];
        nArrayArray7[0] = new int[]{10, 10, 400, 400};
        nArrayArray7[1] = new int[]{10, 10, 400, 400};
        nArrayArray7[2] = new int[]{10, 10, 400, 400};
        int[] nArray25 = new int[4];
        nArray25[2] = 400;
        nArray25[3] = 400;
        nArrayArray7[3] = nArray25;
        int[] nArray26 = new int[4];
        nArray26[2] = 400;
        nArray26[3] = 400;
        nArrayArray7[4] = nArray26;
        int[] nArray27 = new int[4];
        nArray27[2] = 320;
        nArray27[3] = 240;
        nArrayArray7[5] = nArray27;
        int[] nArray28 = new int[4];
        nArray28[2] = 320;
        nArray28[3] = 240;
        nArrayArray7[6] = nArray28;
        m_importModelSize = nArrayArray7;
        int[][] nArrayArray8 = new int[7][];
        nArrayArray8[0] = new int[]{10, 10, 400, 600};
        nArrayArray8[1] = new int[]{10, 10, 400, 600};
        nArrayArray8[2] = new int[]{10, 10, 400, 600};
        int[] nArray29 = new int[4];
        nArray29[2] = 400;
        nArray29[3] = 600;
        nArrayArray8[3] = nArray29;
        int[] nArray30 = new int[4];
        nArray30[2] = 400;
        nArray30[3] = 480;
        nArrayArray8[4] = nArray30;
        int[] nArray31 = new int[4];
        nArray31[2] = 320;
        nArray31[3] = 240;
        nArrayArray8[5] = nArray31;
        int[] nArray32 = new int[4];
        nArray32[2] = 320;
        nArray32[3] = 240;
        nArrayArray8[6] = nArray32;
        m_exportBounds = nArrayArray8;
        m_viewerScreen = "multiple";
        m_viewerVisible = "show";
        m_controlVisible = "hide";
        m_consoleVisible = "hide";
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void init() {
    }

    protected PsXmlSrc fillRsrcTree(PsXmlSrc psXmlSrc) {
        PsXmlNode psXmlNode = psXmlSrc.getRootNode();
        if (psXmlNode == null) {
            psXmlNode = new PsXmlNode("javaview-rsrc");
            psXmlSrc.setRootNode(psXmlNode);
        }
        PsXmlNode psXmlNode2 = PsXmlSrc.assureChild(psXmlNode, "license");
        psXmlNode2.removeChildren();
        psXmlNode2.addAttribute("license-type", m_licenseType);
        psXmlNode2.addAttribute("license-usage", m_licenseUsage);
        psXmlNode2.addChild("license-id", m_licenseId);
        psXmlNode2.addChild("license-expire", m_licenseExpire);
        PsXmlNode psXmlNode3 = PsXmlSrc.assureChild(psXmlNode2, "licensee");
        psXmlNode3.removeChildren();
        psXmlNode3.addChild("firstname", m_licenseeFirstName);
        psXmlNode3.addChild("lastname", m_licenseeLastName);
        psXmlNode3.addChild("organization", m_licenseeOrganization);
        psXmlNode3.addChild("email", m_licenseeEmail);
        psXmlNode3.addChild("url", m_licenseeUrl);
        PsXmlNode psXmlNode4 = PsXmlSrc.assureChild(psXmlNode, "user");
        psXmlNode4.removeChildren();
        psXmlNode4.addChild("firstname", m_userFirstName);
        psXmlNode4.addChild("lastname", m_userLastName);
        psXmlNode4.addChild("organization", m_userOrganization);
        psXmlNode4.addChild("email", m_userEmail);
        psXmlNode4.addChild("url", m_userUrl);
        return psXmlSrc;
    }
}

