/*
 * Decompiled with CFR 0.152.
 */
package jv.rsrc;

import java.awt.Component;
import java.util.Date;
import jv.loader.PsXmlLoader;
import jv.loader.PsXmlNode;
import jv.loader.PsXmlSrc;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsViewerIf;
import jv.rsrc.PsAuthorInfo;
import jv.rsrc.PsModelInfo_IP;

public class PsModelInfo
extends PsObject {
    protected static boolean m_bInsideJavaView = true;
    protected transient PsModelInfo_IP m_dialog;
    protected int m_iDialog = 8;
    protected String m_rsrcFile;
    public static final String USAGE_MASTER = "Master";
    public static final String USAGE_PREVIEW = "Preview";
    public static final String USAGE_APPLET = "Applet";
    public static final String USAGE_ORIGINAL = "Original";
    public static final String USAGE_OTHER = "Other";
    public static final String USAGE_PRINT = "Print";
    public static final String USAGE_README = "Readme";
    public static final String FILE_FORMAT_BYU = "BYU";
    public static final String FILE_FORMAT_EDG = "EDG";
    public static final String FILE_FORMAT_EPS = "EPS";
    public static final String FILE_FORMAT_JVX = "JVX";
    public static final String FILE_FORMAT_MGS = "MGS";
    public static final String FILE_FORMAT_OBJ = "OBJ";
    public static final String FILE_FORMAT_OFF = "OFF";
    public static final String FILE_FORMAT_POLY = "POLY";
    public static final String FILE_FORMAT_PS = "PS";
    public static final String FILE_FORMAT_WRL = "WRL";
    public static final String FILE_FORMAT_SEPARATOR = "---";
    public static final String FILE_FORMAT_GIF = "GIF";
    public static final String FILE_FORMAT_JPG = "JPG";
    public static final String FILE_FORMAT_TXT = "TXT";
    public static final String REFERENCE_ARTICLE = "Article";
    public static final String REFERENCE_BOOK = "Book";
    public static final String REFERENCE_INCOLLECTION = "InCollection";
    public static final String REFERENCE_MISC = "Misc";
    public static final String REFERENCE_URL = "URL";
    public static final String EMPTY_ITEM = "---";
    protected String m_egId;
    protected String m_title;
    protected String m_modelName;
    protected PsAuthorInfo m_author = new PsAuthorInfo();
    protected String m_primary;
    protected String m_secondary;
    protected String[] m_keyword;
    protected static final int m_maxNumFiles = 5;
    protected int m_numFiles;
    protected boolean[] m_autoGen;
    protected String[] m_usage;
    protected String[] m_fileName;
    protected String[] m_fileFormat;
    protected String[] m_fileSize;
    protected String[] m_imageWidth;
    protected String[] m_imageHeight;
    protected String m_softwareProduced;
    protected String m_fileComment;
    protected String m_abstract;
    protected String m_detail;
    protected static final int m_maxNumRefs = 5;
    protected int m_numRefs;
    protected String[] m_refType;
    protected String[] m_refAuthor;
    protected String[] m_refTitle;
    protected String[] m_refBooktitle;
    protected String[] m_refEditor;
    protected String[] m_refJournal;
    protected String[] m_refPages;
    protected String[] m_refLink;
    protected String[] m_refVolume;
    protected String[] m_refNumber;
    protected String[] m_refPublisher;
    protected String[] m_refYear;
    protected String[] m_refNote;

    public int getDialogStatus() {
        return this.m_iDialog;
    }

    public void showDialog(boolean bl, PsViewerIf psViewerIf) {
        this.m_iDialog = 8;
        this.m_dialog = new PsModelInfo_IP(bl);
        this.m_dialog.init();
        this.m_dialog.setParent(this);
        this.m_dialog.setViewer(psViewerIf);
        this.update(this);
        this.m_dialog.setLocation(20, 5);
        ((Component)this.m_dialog).setSize(750, 550);
        ((Component)this.m_dialog).setVisible(true);
    }

    public boolean hasDialog() {
        return this.m_dialog != null;
    }

    public PsModelInfo() {
        this.init();
    }

    public boolean read(String string) {
        if (string == null) {
            PsDebug.warning("missing argument file name.");
            return false;
        }
        PsXmlSrc psXmlSrc = PsXmlLoader.read(string);
        if (psXmlSrc == null) {
            PsDebug.warning("could not read rsrc file = " + string);
            return false;
        }
        this.setXml(psXmlSrc);
        return true;
    }

    private void createReferences(int n) {
        this.m_refType = new String[n];
        this.m_refAuthor = new String[n];
        this.m_refTitle = new String[n];
        this.m_refJournal = new String[n];
        this.m_refBooktitle = new String[n];
        this.m_refEditor = new String[n];
        this.m_refPages = new String[n];
        this.m_refLink = new String[n];
        this.m_refVolume = new String[n];
        this.m_refNumber = new String[n];
        this.m_refPublisher = new String[n];
        this.m_refYear = new String[n];
        this.m_refNote = new String[n];
    }

    public PsXmlSrc getXml() {
        PsXmlSrc psXmlSrc = new PsXmlSrc();
        psXmlSrc.setDocName("eg-model");
        psXmlSrc.setDocType("http://www-sfb288.math.tu-berlin.de/eg-models/rsrc/eg-model.dtd");
        return this.fillRsrcTree(psXmlSrc);
    }

    public void setXml(PsXmlSrc psXmlSrc) {
        Object object;
        Object object2;
        Object object3;
        int n;
        Object object4;
        if (psXmlSrc == null) {
            PsDebug.warning("missing resource.");
            return;
        }
        this.m_rsrcFile = psXmlSrc.getRsrcFile();
        PsXmlNode psXmlNode = psXmlSrc.getRootNode();
        if (psXmlNode == null) {
            psXmlSrc = this.fillRsrcTree(psXmlSrc);
            psXmlNode = psXmlSrc.getRootNode();
        }
        this.m_egId = PsXmlSrc.getRsrc(psXmlNode, "eg-id");
        this.m_title = PsXmlSrc.getRsrc(psXmlNode, "title");
        this.m_modelName = PsXmlSrc.getRsrc(psXmlNode, "modelname");
        PsXmlNode psXmlNode2 = PsXmlSrc.assureChild(psXmlNode, "authors");
        this.m_author.setXmlNode(psXmlNode2);
        PsXmlNode psXmlNode3 = PsXmlSrc.assureChild(psXmlNode, "classification");
        this.m_primary = PsXmlSrc.getRsrc(psXmlNode3, "primary");
        this.m_secondary = PsXmlSrc.getRsrc(psXmlNode3, "secondary");
        PsXmlNode psXmlNode4 = PsXmlSrc.getRsrcNode(psXmlNode3, "keywords");
        if (psXmlNode4 != null) {
            object4 = PsXmlSrc.getRsrcNodes(psXmlNode4, "keyword");
            if (object4 != null && ((PsXmlNode[])object4).length > 0) {
                this.m_keyword = new String[((PsXmlNode[])object4).length];
                n = 0;
                while (n < ((PsXmlNode[])object4).length) {
                    this.m_keyword[n] = PsXmlSrc.getRsrc(object4[n], "keyword");
                    if (this.m_keyword[n] == null) {
                        this.m_keyword[n] = "";
                    }
                    ++n;
                }
            }
        } else {
            PsDebug.warning("missing files node.");
        }
        if ((object4 = PsXmlSrc.assureChild(psXmlNode, "files")) != null) {
            object3 = PsXmlSrc.getRsrcNodes((PsXmlNode)object4);
            this.m_softwareProduced = PsXmlSrc.getRsrc((PsXmlNode)object4, "softwareproduced");
            this.m_fileComment = PsXmlSrc.getRsrc((PsXmlNode)object4, "filecomment");
            if (object3 != null) {
                this.m_numFiles = ((PsXmlNode[])object3).length;
                if (this.m_softwareProduced != null) {
                    this.m_numFiles += -1;
                }
                if (this.m_fileComment != null) {
                    this.m_numFiles += -1;
                }
                this.m_numFiles = Math.max(this.m_numFiles, 0);
                if (this.m_numFiles > 5) {
                    this.m_numFiles = 5;
                }
            } else {
                this.m_numFiles = 0;
            }
            n = 0;
            while (n < this.m_numFiles) {
                object2 = object3[n].getType();
                if (((String)object2).equals("file_master")) {
                    this.m_usage[n] = USAGE_MASTER;
                } else if (((String)object2).equals("file_preview")) {
                    this.m_usage[n] = USAGE_PREVIEW;
                } else if (((String)object2).equals("file_applet")) {
                    this.m_usage[n] = USAGE_APPLET;
                } else if (((String)object2).equals("file_other")) {
                    this.m_usage[n] = USAGE_OTHER;
                } else if (((String)object2).equals("file_original")) {
                    this.m_usage[n] = USAGE_ORIGINAL;
                } else if (((String)object2).equals("file_print")) {
                    this.m_usage[n] = USAGE_PRINT;
                } else {
                    if (!((String)object2).equals("file_readme")) break;
                    this.m_usage[n] = USAGE_README;
                }
                object = object3[n].getAttribute("format");
                this.m_fileFormat[n] = object != null ? ((String)object).toUpperCase() : null;
                this.m_fileName[n] = PsXmlSrc.getRsrc(object3[n], "filename");
                this.m_fileSize[n] = PsXmlSrc.getRsrc(object3[n], "filesize");
                if (this.m_usage[n].equalsIgnoreCase(USAGE_PREVIEW)) {
                    this.m_imageWidth[n] = PsXmlSrc.getRsrc(object3[n], "imagewidth");
                    this.m_imageHeight[n] = PsXmlSrc.getRsrc(object3[n], "imageheight");
                }
                ++n;
            }
        } else {
            this.m_numFiles = 0;
            PsDebug.warning("missing files node.");
        }
        object3 = PsXmlSrc.assureChild(psXmlNode, "description");
        this.m_abstract = PsXmlSrc.getRsrc((PsXmlNode)object3, "abstract");
        object2 = PsXmlSrc.getRsrcNode((PsXmlNode)object3, "detail");
        if (object2 != null) {
            this.m_detail = "";
            if (((PsXmlNode)object2).getContent() != null) {
                this.m_detail = ((PsXmlNode)object2).getContent();
            }
            if ((object = PsXmlSrc.getRsrcNodes((PsXmlNode)object2, "p")) != null && ((PsXmlNode[])object).length > 0) {
                n = 0;
                while (n < ((PsXmlNode[])object).length) {
                    this.m_detail = this.m_detail + "<p>" + ((PsXmlNode)object[n]).getContent() + "</p>\n";
                    ++n;
                }
            }
        }
        if ((object = PsXmlSrc.getRsrcNode((PsXmlNode)object3, "references")) != null) {
            PsXmlNode[] psXmlNodeArray = PsXmlSrc.getRsrcNodes((PsXmlNode)object);
            if (psXmlNodeArray != null && psXmlNodeArray.length > 0) {
                this.m_numRefs = psXmlNodeArray.length;
                if (this.m_numRefs > 5) {
                    this.m_numRefs = 5;
                }
                n = 0;
                while (n < this.m_numRefs) {
                    String string = psXmlNodeArray[n].getType();
                    if (string.equals("refarticle")) {
                        this.m_refType[n] = REFERENCE_ARTICLE;
                        this.m_refAuthor[n] = PsXmlSrc.getRsrc(psXmlNodeArray[n], "refauthor");
                        this.m_refTitle[n] = PsXmlSrc.getRsrc(psXmlNodeArray[n], "reftitle");
                        this.m_refJournal[n] = PsXmlSrc.getRsrc(psXmlNodeArray[n], "refjournal");
                        this.m_refPages[n] = PsXmlSrc.getRsrc(psXmlNodeArray[n], "refpages");
                        this.m_refYear[n] = PsXmlSrc.getRsrc(psXmlNodeArray[n], "refyear");
                        this.m_refVolume[n] = PsXmlSrc.getRsrc(psXmlNodeArray[n], "refvolume");
                        this.m_refNumber[n] = PsXmlSrc.getRsrc(psXmlNodeArray[n], "refnumber");
                    } else if (string.equals("refbook")) {
                        this.m_refType[n] = REFERENCE_BOOK;
                        this.m_refAuthor[n] = PsXmlSrc.getRsrc(psXmlNodeArray[n], "refauthor");
                        this.m_refBooktitle[n] = PsXmlSrc.getRsrc(psXmlNodeArray[n], "refbooktitle");
                        this.m_refPublisher[n] = PsXmlSrc.getRsrc(psXmlNodeArray[n], "refpublisher");
                        this.m_refYear[n] = PsXmlSrc.getRsrc(psXmlNodeArray[n], "refyear");
                    } else if (string.equals("refincollection")) {
                        this.m_refType[n] = REFERENCE_INCOLLECTION;
                        this.m_refAuthor[n] = PsXmlSrc.getRsrc(psXmlNodeArray[n], "refauthor");
                        this.m_refTitle[n] = PsXmlSrc.getRsrc(psXmlNodeArray[n], "reftitle");
                        this.m_refBooktitle[n] = PsXmlSrc.getRsrc(psXmlNodeArray[n], "refbooktitle");
                        this.m_refEditor[n] = PsXmlSrc.getRsrc(psXmlNodeArray[n], "refeditor");
                        this.m_refPublisher[n] = PsXmlSrc.getRsrc(psXmlNodeArray[n], "refpublisher");
                        this.m_refYear[n] = PsXmlSrc.getRsrc(psXmlNodeArray[n], "refyear");
                        this.m_refPages[n] = PsXmlSrc.getRsrc(psXmlNodeArray[n], "refpages");
                    } else if (string.equals("refmisc")) {
                        this.m_refType[n] = REFERENCE_MISC;
                        this.m_refAuthor[n] = PsXmlSrc.getRsrc(psXmlNodeArray[n], "refauthor");
                        this.m_refTitle[n] = PsXmlSrc.getRsrc(psXmlNodeArray[n], "reftitle");
                        this.m_refYear[n] = PsXmlSrc.getRsrc(psXmlNodeArray[n], "refyear");
                        this.m_refNote[n] = PsXmlSrc.getRsrc(psXmlNodeArray[n], "refnote");
                    } else if (string.equals("refurl")) {
                        this.m_refType[n] = REFERENCE_URL;
                        this.m_refAuthor[n] = PsXmlSrc.getRsrc(psXmlNodeArray[n], "refauthor");
                        this.m_refTitle[n] = PsXmlSrc.getRsrc(psXmlNodeArray[n], "reftitle");
                        this.m_refLink[n] = PsXmlSrc.getRsrc(psXmlNodeArray[n], "reflink");
                    } else {
                        PsDebug.warning("void reference type = " + string);
                    }
                    ++n;
                }
                return;
            }
        } else {
            this.m_numRefs = 0;
            PsDebug.warning("missing references node.");
        }
    }

    public boolean update(Object object) {
        if (object == this) {
            this.m_author.update(this.m_author);
            this.m_dialog.update(this);
            super.update(this);
        } else if (object == this.m_dialog) {
            if (this.m_dialog.getUserAction() == 16 || this.m_dialog.getUserAction() == 1) {
                this.m_dialog = null;
                this.m_iDialog = 16;
            }
            return true;
        }
        return super.update(object);
    }

    public static final void runningInsideJavaView(boolean bl) {
        m_bInsideJavaView = bl;
    }

    private void createFiles(int n) {
        this.m_autoGen = new boolean[n];
        this.m_usage = new String[n];
        this.m_fileName = new String[n];
        this.m_fileFormat = new String[n];
        this.m_fileSize = new String[n];
        this.m_imageWidth = new String[n];
        this.m_imageHeight = new String[n];
    }

    public void init() {
        super.init();
        this.m_egId = null;
        this.m_title = null;
        this.m_modelName = null;
        this.m_author.init();
        this.m_primary = null;
        this.m_secondary = null;
        this.m_keyword = null;
        this.createFiles(5);
        this.createReferences(5);
        this.m_numFiles = 3;
        this.m_usage[0] = USAGE_MASTER;
        this.m_autoGen[0] = true;
        this.m_fileFormat[0] = FILE_FORMAT_JVX;
        this.m_fileName[0] = this.m_modelName + "_" + this.m_usage[0];
        this.m_usage[1] = USAGE_APPLET;
        this.m_autoGen[1] = true;
        this.m_fileFormat[1] = FILE_FORMAT_OBJ;
        this.m_fileName[1] = this.m_modelName + "_" + this.m_usage[1];
        this.m_usage[2] = USAGE_PREVIEW;
        this.m_autoGen[2] = true;
        this.m_fileFormat[2] = FILE_FORMAT_GIF;
        this.m_fileName[2] = this.m_modelName + "_" + this.m_usage[2];
        int n = this.m_numFiles;
        while (n < 5) {
            this.m_autoGen[n] = false;
            this.m_usage[n] = null;
            this.m_fileName[n] = null;
            this.m_fileFormat[n] = null;
            this.m_fileSize[n] = null;
            this.m_imageWidth[n] = null;
            this.m_imageHeight[n] = null;
            ++n;
        }
        this.m_softwareProduced = null;
        this.m_fileComment = null;
        this.m_abstract = null;
        this.m_detail = null;
        n = this.m_numRefs = 0;
        while (n < 5) {
            this.m_refType[n] = null;
            this.m_refAuthor[n] = null;
            this.m_refTitle[n] = null;
            this.m_refJournal[n] = null;
            this.m_refBooktitle[n] = null;
            this.m_refEditor[n] = null;
            this.m_refPages[n] = null;
            this.m_refLink[n] = null;
            this.m_refVolume[n] = null;
            this.m_refNumber[n] = null;
            this.m_refPublisher[n] = null;
            this.m_refYear[n] = null;
            this.m_refNote[n] = null;
            ++n;
        }
    }

    /*
     * Unable to fully structure code
     */
    private PsXmlSrc fillRsrcTree(PsXmlSrc var1_1) {
        if (var1_1 == null) {
            var1_1 = new PsXmlSrc();
        }
        if ((var2_2 = var1_1.getRootNode()) == null) {
            var2_2 = new PsXmlNode("eg-model");
            var1_1.setRootNode(var2_2);
        }
        if ((var3_3 = PsXmlSrc.getRsrcNodes(var2_2, "meta")) == null || var3_3.length < 2) {
            var3_3 = new PsXmlNode[2];
        }
        if (var3_3[0] == null) {
            var3_3[0] = var2_2.addChild("meta");
        }
        var3_3[0].addAttribute("generator", PsConfig.getProgram() + " v." + PsConfig.getVersion());
        if (var3_3[1] == null) {
            var3_3[1] = var2_2.addChild("meta");
        }
        var3_3[1].addAttribute("date", new Date().toString());
        var4_4 = PsXmlSrc.assureChild(var2_2, "eg-id");
        var4_4.setContent(this.m_egId);
        var5_5 = PsXmlSrc.assureChild(var2_2, "title");
        var5_5.setContent(this.m_title);
        var6_6 = PsXmlSrc.assureChild(var2_2, "modelname");
        var6_6.setContent(this.m_modelName);
        var7_7 = PsXmlSrc.assureChild(var2_2, "authors");
        this.m_author.getXmlNode(var7_7);
        var9_8 = PsXmlSrc.assureChild(var2_2, "classification");
        var9_8.removeChildren();
        var10_9 = var9_8.addChild("msc2000");
        var10_9.addChild("primary", this.m_primary);
        var10_9.addChild("secondary", this.m_secondary);
        var11_10 = var9_8.addChild("keywords");
        if (this.m_keyword != null) {
            var8_11 = 0;
            while (var8_11 < this.m_keyword.length) {
                if (this.m_keyword[var8_11] != null && !this.m_keyword[var8_11].equals("")) {
                    var11_10.addChild("keyword", this.m_keyword[var8_11]);
                }
                ++var8_11;
            }
        }
        var10_9 = PsXmlSrc.assureChild(var2_2, "files");
        var10_9.removeChildren();
        var8_11 = 0;
        while (var8_11 < this.m_numFiles) {
            block30: {
                block29: {
                    block28: {
                        block27: {
                            block26: {
                                block25: {
                                    var11_10 = null;
                                    if (!this.m_usage[var8_11].equalsIgnoreCase("Master")) break block25;
                                    var11_10 = var10_9.addChild("file_master");
                                    ** GOTO lbl72
                                }
                                if (!this.m_usage[var8_11].equalsIgnoreCase("Preview")) break block26;
                                var11_10 = var10_9.addChild("file_preview");
                                ** GOTO lbl72
                            }
                            if (!this.m_usage[var8_11].equals("Applet")) break block27;
                            var11_10 = var10_9.addChild("file_applet");
                            ** GOTO lbl72
                        }
                        if (!this.m_usage[var8_11].equalsIgnoreCase("Other")) break block28;
                        var11_10 = var10_9.addChild("file_other");
                        ** GOTO lbl72
                    }
                    if (!this.m_usage[var8_11].equalsIgnoreCase("Original")) break block29;
                    var11_10 = var10_9.addChild("file_original");
                    ** GOTO lbl72
                }
                if (!this.m_usage[var8_11].equalsIgnoreCase("Print")) break block30;
                var11_10 = var10_9.addChild("file_print");
                ** GOTO lbl72
            }
            if (!this.m_usage[var8_11].equalsIgnoreCase("Readme")) {
                PsDebug.warning("unknown usage type = " + this.m_usage[var8_11]);
            } else {
                var11_10 = var10_9.addChild("file_readme");
lbl72:
                // 7 sources

                var11_10.addAttribute("format", this.m_fileFormat[var8_11].toLowerCase());
                var11_10.addChild("filename", this.m_fileName[var8_11]);
                var11_10.addChild("filesize", this.m_fileSize[var8_11]);
                if (this.m_usage[var8_11].equalsIgnoreCase("Preview")) {
                    var11_10.addChild("imagewidth", this.m_imageWidth[var8_11]);
                    var11_10.addChild("imageheight", this.m_imageHeight[var8_11]);
                }
            }
            ++var8_11;
        }
        var10_9.addChild("softwareproduced", this.m_softwareProduced);
        var10_9.addChild("filecomment", this.m_fileComment);
        var11_10 = PsXmlSrc.assureChild(var2_2, "description");
        var11_10.removeChildren();
        var11_10.addChild("abstract", this.m_abstract);
        var12_12 = null;
        if (this.m_detail != null && !(var13_13 = this.m_detail.trim()).startsWith("<p>")) {
            var12_12 = var11_10.addChild("detail", "<p>\n" + (String)var13_13 + "\n</p>");
        }
        if (var12_12 == null) {
            var11_10.addChild("detail", this.m_detail);
        }
        var13_13 = var11_10.addChild("references");
        var8_11 = 0;
        while (var8_11 < this.m_numRefs) {
            var14_14 = null;
            if (this.m_refType[var8_11].equals("Article")) {
                var14_14 = var13_13.addChild("refarticle");
                var14_14.addChild("refauthor", this.m_refAuthor[var8_11]);
                var14_14.addChild("reftitle", this.m_refTitle[var8_11]);
                var14_14.addChild("refjournal", this.m_refJournal[var8_11]);
                var14_14.addChild("refpages", this.m_refPages[var8_11]);
                var14_14.addChild("refyear", this.m_refYear[var8_11]);
                var14_14.addChild("refvolume", this.m_refVolume[var8_11]);
                var14_14.addChild("refnumber", this.m_refNumber[var8_11]);
            } else if (this.m_refType[var8_11].equals("Book")) {
                var14_14 = var13_13.addChild("refbook");
                var14_14.addChild("refauthor", this.m_refAuthor[var8_11]);
                var14_14.addChild("refbooktitle", this.m_refBooktitle[var8_11]);
                var14_14.addChild("refpublisher", this.m_refPublisher[var8_11]);
                var14_14.addChild("refyear", this.m_refYear[var8_11]);
            } else if (this.m_refType[var8_11].equals("InCollection")) {
                var14_14 = var13_13.addChild("refincollection");
                var14_14.addChild("refauthor", this.m_refAuthor[var8_11]);
                var14_14.addChild("reftitle", this.m_refTitle[var8_11]);
                var14_14.addChild("refbooktitle", this.m_refBooktitle[var8_11]);
                var14_14.addChild("refeditor", this.m_refEditor[var8_11]);
                var14_14.addChild("refpublisher", this.m_refPublisher[var8_11]);
                var14_14.addChild("refyear", this.m_refYear[var8_11]);
                var14_14.addChild("refpages", this.m_refPages[var8_11]);
            } else if (this.m_refType[var8_11].equals("Misc")) {
                var14_14 = var13_13.addChild("refmisc");
                var14_14.addChild("refauthor", this.m_refAuthor[var8_11]);
                var14_14.addChild("reftitle", this.m_refTitle[var8_11]);
                var14_14.addChild("refyear", this.m_refYear[var8_11]);
                var14_14.addChild("refnote", this.m_refNote[var8_11]);
            } else if (this.m_refType[var8_11].equals("URL")) {
                var14_14 = var13_13.addChild("refurl");
                var14_14.addChild("refauthor", this.m_refAuthor[var8_11]);
                var14_14.addChild("reftitle", this.m_refTitle[var8_11]);
                var14_14.addChild("reflink", this.m_refLink[var8_11]);
            } else {
                PsDebug.warning("void reference type = " + this.m_refType[var8_11]);
            }
            var14_14.addAttribute("num", String.valueOf(var8_11 + 1));
            ++var8_11;
        }
        return var1_1;
    }

    public PsAuthorInfo getAuthors() {
        return this.m_author;
    }

    public void setAuthors(PsAuthorInfo psAuthorInfo) {
        this.m_author = psAuthorInfo;
    }

    public String getRsrcFile() {
        return this.m_rsrcFile;
    }
}

