/*
 * Decompiled with CFR 0.152.
 */
package jv.thirdParty.acmeEncoders;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;

public abstract class ImageEncoder
implements ImageConsumer {
    protected OutputStream out;
    private ImageProducer producer = null;
    private int width = -1;
    private int height = -1;
    private int hintflags = 0;
    private boolean started = false;
    private boolean encoding;
    private IOException iox;
    private static final ColorModel rgbModel = ColorModel.getRGBdefault();
    private Hashtable props = null;
    private Image image = null;
    private boolean wrongColorModel = false;
    private int alpha = 3;
    private int red = 16;
    private int green = 8;
    private int blue = 0;
    private boolean accumulate = false;
    private int[] accumulator;

    private void encodePixelsWrapper(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) throws IOException {
        if (!this.started) {
            this.started = true;
            this.encodeStart(this.width, this.height);
            if ((this.hintflags & 2) == 0) {
                this.accumulate = true;
                this.accumulator = new int[this.width * this.height];
            }
        }
        if (this.accumulate) {
            int n7 = 0;
            while (n7 < n4) {
                System.arraycopy(nArray, n7 * n6 + n5, this.accumulator, (n2 + n7) * this.width + n, n3);
                ++n7;
            }
            return;
        }
        this.encodePixels(n, n2, n3, n4, nArray, n5, n6);
    }

    private synchronized void stop() {
        this.encoding = false;
        this.notifyAll();
    }

    public void setHints(int n) {
        this.hintflags = n;
    }

    public ImageEncoder(Image image, OutputStream outputStream) throws IOException {
        this(image.getSource(), outputStream);
        this.image = image;
    }

    public ImageEncoder(ImageProducer imageProducer, OutputStream outputStream) throws IOException {
        this.producer = imageProducer;
        this.out = outputStream;
    }

    abstract void encodeDone() throws IOException;

    public synchronized void encode() throws IOException {
        this.encoding = true;
        this.iox = null;
        if (this.image != null) {
            PixelGrabber pixelGrabber = new PixelGrabber(this.image, 0, 0, 1, 1, false);
            try {
                pixelGrabber.grabPixels();
            }
            catch (InterruptedException interruptedException) {
                throw new IOException("interrupted waiting for pixels!");
            }
            if ((pixelGrabber.getStatus() & 0x80) != 0) {
                throw new IOException("image fetch aborted or errored");
            }
            Object object = pixelGrabber.getPixels();
            int n = object instanceof int[] ? ((int[])object)[0] : ((byte[])object)[0];
            Graphics graphics = this.image.getGraphics();
            if (graphics != null) {
                graphics.setColor(new Color(262657));
                graphics.drawLine(0, 0, 0, 0);
            }
            pixelGrabber = new PixelGrabber(this.image, 0, 0, 1, 1, false);
            try {
                pixelGrabber.grabPixels();
            }
            catch (InterruptedException interruptedException) {
                throw new IOException("interrupted waiting for pixels!");
            }
            if ((pixelGrabber.getStatus() & 0x80) != 0) {
                throw new IOException("image fetch aborted or errored");
            }
            object = pixelGrabber.getPixels();
            int n2 = object instanceof byte[] ? ((byte[])object)[0] : ((int[])object)[0];
            ColorModel colorModel = pixelGrabber.getColorModel();
            int n3 = colorModel.getRed(n2);
            int n4 = colorModel.getGreen(n2);
            int n5 = colorModel.getBlue(n2);
            if (n3 != 4 || n4 != 2 || n5 != 1) {
                this.wrongColorModel = true;
                int n6 = 0;
                do {
                    int n7;
                    if ((n7 = n2 >> n6 * 8 & 0xFF) == 4) {
                        this.red = n6 * 8;
                        continue;
                    }
                    if (n7 == 2) {
                        this.green = n6 * 8;
                        continue;
                    }
                    if (n7 != 1) continue;
                    this.blue = n6 * 8;
                } while (++n6 < 4);
            }
            if (graphics != null) {
                graphics.setColor(new Color(this.getCorrectRGB(n, colorModel)));
                graphics.drawLine(0, 0, 0, 0);
            }
        }
        this.producer.startProduction(this);
        while (this.encoding) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.iox != null) {
            throw this.iox;
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        int[] nArray = new int[n3];
        int n7 = 0;
        while (n7 < n4) {
            int n8 = n5 + n7 * n6;
            int n9 = 0;
            while (n9 < n3) {
                nArray[n9] = colorModel.getRGB(byArray[n8 + n9] & 0xFF);
                ++n9;
            }
            try {
                this.encodePixelsWrapper(n, n2 + n7, n3, 1, nArray, 0, n3);
            }
            catch (IOException iOException) {
                this.iox = iOException;
                this.stop();
                return;
            }
            ++n7;
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        if (colorModel == rgbModel && !this.wrongColorModel) {
            try {
                this.encodePixelsWrapper(n, n2, n3, n4, nArray, n5, n6);
                return;
            }
            catch (IOException iOException) {
                this.iox = iOException;
                this.stop();
                return;
            }
        }
        int[] nArray2 = new int[n3];
        int n7 = 0;
        while (n7 < n4) {
            int n8 = n5 + n7 * n6;
            int n9 = 0;
            while (n9 < n3) {
                nArray2[n9] = this.wrongColorModel ? this.getCorrectRGB(nArray[n8 + n9], colorModel) : colorModel.getRGB(nArray[n8 + n9]);
                ++n9;
            }
            try {
                this.encodePixelsWrapper(n, n2 + n7, n3, 1, nArray2, 0, n3);
            }
            catch (IOException iOException) {
                this.iox = iOException;
                this.stop();
                return;
            }
            ++n7;
        }
    }

    abstract void encodeStart(int var1, int var2) throws IOException;

    public void setDimensions(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public void setProperties(Hashtable hashtable) {
        this.props = hashtable;
    }

    private int getCorrectRGB(int n, ColorModel colorModel) {
        int n2 = 0;
        n2 += (n >> this.red & 0xFF) << 16;
        n2 += (n >> this.green & 0xFF) << 8;
        n2 += n >> this.blue & 0xFF;
        return n2 += colorModel.getAlpha(n) << 24;
    }

    private void encodeFinish() throws IOException {
        if (this.accumulate) {
            this.encodePixels(0, 0, this.width, this.height, this.accumulator, 0, this.width);
            this.accumulator = null;
            this.accumulate = false;
        }
    }

    public void imageComplete(int n) {
        this.producer.removeConsumer(this);
        if (n == 4) {
            this.iox = new IOException("image aborted");
        } else {
            try {
                this.encodeFinish();
                this.encodeDone();
            }
            catch (IOException iOException) {
                this.iox = iOException;
            }
        }
        this.stop();
    }

    public void setColorModel(ColorModel colorModel) {
    }

    abstract void encodePixels(int var1, int var2, int var3, int var4, int[] var5, int var6, int var7) throws IOException;
}

