/*
 * Decompiled with CFR 0.152.
 */
package jv.thirdParty.ruler;

import java.awt.Color;
import java.text.NumberFormat;
import java.util.Vector;
import jv.geom.PgPolygonSet;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsDebug;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PgRuler
extends PgPolygonSet {
    private static final int MIN = 0;
    private static final int MAX = 1;
    private static final int NORMALHP1 = 0;
    private static final int NORMALHP2 = 1;
    private static final int UPHP1 = 2;
    private static final int UPHP2 = 3;
    private static final int FAIL = 0;
    private static final int FIXED_OK = 1;
    private static final int DYNAMIC_OK = 2;
    public static final int NORMAL_DIRECTION = 0;
    public static final int UP_VECTOR_DIRECTION = 1;
    public static final int ALIGNLEFT = 0;
    public static final int ALIGNRIGHT = 1;
    public static final int ALIGNCENTER = 2;
    protected boolean m_bFixedMode;
    protected boolean m_bMajorMode;
    protected boolean m_bMinorMode;
    protected boolean m_bHashInNormalDir;
    protected boolean m_bHashInUpDir;
    protected boolean m_bShowLabels;
    protected boolean m_bShowRulerName;
    protected String m_rulerName;
    protected int m_rulerNamePos;
    protected PdVector m_minMax;
    protected double[] m_tiMajor;
    protected double[] m_tiMinor;
    protected PdVector m_origin = new PdVector(3);
    protected PdVector m_normalOffset = new PdVector(3);
    protected PdVector m_upOffset = new PdVector(3);
    protected PdVector m_v = new PdVector(3);
    protected PdVector m_n = new PdVector(3);
    protected PdVector m_u = new PdVector(3);
    protected double[] m_hMinor = new double[4];
    protected double[] m_hMajor = new double[4];
    protected Color m_hMajorColor;
    protected Color m_hMinorColor;
    protected PuInteger m_numMajorHashings;
    protected PuInteger m_numMinorHashings;
    protected PuDouble m_majorHashUnits;
    protected PuDouble m_minorHashUnits;
    private double m_defMin = -10.0;
    private double m_defMax = 10.0;
    private double m_defMajorHashUnit = 5.0;
    private double m_defMinorHashUnit = 2.5;
    private int m_defNumMajorHashings = 5;
    private int m_defNumMinorHashings = 2;
    private double m_defhMajor = 0.5;
    private double m_defhMinor = 0.25;
    private boolean m_defbHashInNormalDir = true;
    private boolean m_defbHashInUpDir = false;
    private Color m_defhMajorColor = new Color(0, 0, 255);
    private Color m_defhMinorColor = new Color(113, 113, 255);
    private static /* synthetic */ Class class$jv$thirdParty$ruler$PgRuler;

    public double getMaxParameter() {
        return this.m_minMax.getEntry(1);
    }

    protected void constructHashSet(PgPolygonSet pgPolygonSet, PdVector pdVector, PdVector pdVector2, PdVector pdVector3, double[] dArray, double[] dArray2, boolean bl) {
        PdVector pdVector4 = new PdVector(3);
        PdVector pdVector5 = new PdVector(3);
        PdVector pdVector6 = new PdVector(3);
        PdVector pdVector7 = new PdVector(3);
        pdVector4.copy(pdVector3);
        pdVector4.multScalar(dArray2[0]);
        pdVector5.copy(pdVector4);
        pdVector5.multScalar(-1.0);
        pdVector6.copy(pdVector3);
        pdVector6.multScalar(dArray2[1]);
        int n = pgPolygonSet.getNumVertices();
        int n2 = pgPolygonSet.getNumPolygons();
        pgPolygonSet.setNumVertices(n + 2 * dArray.length);
        pgPolygonSet.setNumPolygons(n2 + dArray.length);
        int n3 = n;
        int n4 = 0;
        while (n4 < dArray.length) {
            pdVector7.copy(pdVector2);
            pdVector7.multScalar(dArray[n4]);
            pdVector7.add(pdVector);
            pdVector7.add(pdVector4);
            pgPolygonSet.setVertex(n3, pdVector7);
            pdVector7.add(pdVector5);
            pdVector7.add(pdVector6);
            pgPolygonSet.setVertex(n3 + 1, pdVector7);
            pgPolygonSet.setPolygon(n2 + n4, new PiVector(n3, n3 + 1));
            this.assurePolygonColors();
            if (bl) {
                this.setPolygonColor(n2 + n4, this.m_hMajorColor);
            } else {
                this.setPolygonColor(n2 + n4, this.m_hMinorColor);
            }
            ++n3;
            ++n3;
            ++n4;
        }
    }

    public void moveRulerOrigin(PdVector pdVector) {
        this.m_origin.copy(pdVector);
    }

    public boolean isShowingMinorHashings() {
        return this.m_bMinorMode;
    }

    public void showMinorHashings(boolean bl) {
        this.m_bMinorMode = bl;
    }

    public void setInitPoint(PdVector pdVector) {
        this.m_origin.copy(pdVector);
    }

    public void setMajorColor(Color color) {
        this.m_hMajorColor = color;
    }

    public boolean isShowingLabels() {
        return this.m_bShowLabels;
    }

    public void showLabels(boolean bl) {
        this.m_bShowLabels = bl;
    }

    public void setMinorColor(Color color) {
        this.m_hMinorColor = color;
    }

    public void setDefDynamicHashing() {
        this.m_numMajorHashings.setDefValue(this.m_defNumMajorHashings);
        this.m_numMinorHashings.setDefValue(this.m_defNumMinorHashings);
    }

    public void setDefFixedHashing() {
        this.m_majorHashUnits.setDefValue(this.m_defMajorHashUnit);
        this.m_minorHashUnits.setDefValue(this.m_defMinorHashUnit);
    }

    public PdVector getUpVector() {
        return this.m_u;
    }

    public void setUpVector(PdVector pdVector) {
        this.m_u.copy(pdVector);
        this.m_u.normalize();
    }

    public void setHashOffsetInNormalDir(double d, double d2, double d3) {
        this.m_normalOffset.m_data[0] = d;
        this.m_normalOffset.m_data[1] = d2;
        this.m_normalOffset.m_data[2] = d3;
    }

    public void setHashOffsetInUpDir(double d, double d2, double d3) {
        this.m_upOffset.m_data[0] = d;
        this.m_upOffset.m_data[1] = d2;
        this.m_upOffset.m_data[2] = d3;
    }

    public boolean isShowingRulerName() {
        return this.m_bShowRulerName;
    }

    public void showRulerName(boolean bl) {
        this.m_bShowRulerName = bl;
    }

    public void setRulerName(String string) {
        this.setRulerName(string, 1, false);
    }

    public void setRulerName(String string, int n) {
        this.setRulerName(string, n, false);
    }

    public void setRulerName(String string, boolean bl) {
        this.setRulerName(string, 1, bl);
    }

    public void setRulerName(String string, int n, boolean bl) {
        this.m_rulerName = string;
        this.m_rulerNamePos = n;
        this.m_bShowRulerName = bl;
        this.setName(this.m_rulerName);
    }

    public void setMinMax(double d, double d2) {
        this.m_minMax.m_data[0] = d;
        this.m_minMax.m_data[1] = d2;
    }

    protected void computeHashings() {
        int n;
        if (this.m_v == null) {
            PsDebug.error("!! The Ruler direction should not be null !!");
        }
        if (this.m_n == null) {
            this.m_n.copy(this.m_v);
            this.makeUnit_PerpUnit(this.m_n);
        }
        if (this.m_u == null) {
            this.computeUpVector();
        }
        if ((n = this.computeBaseLine()) == 1) {
            if (this.m_bHashInNormalDir) {
                this.computeFixedHashings(0);
            }
            if (this.m_bHashInUpDir) {
                this.computeFixedHashings(1);
                return;
            }
        } else if (n == 2) {
            if (this.m_bHashInNormalDir) {
                this.computeDynamicHashings(0);
            }
            if (this.m_bHashInUpDir) {
                this.computeDynamicHashings(1);
            }
        }
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void init() {
        super.init();
        this.m_bHashInNormalDir = this.m_defbHashInNormalDir;
        this.m_bHashInUpDir = this.m_defbHashInUpDir;
        this.m_bMajorMode = true;
        this.m_bMinorMode = true;
        this.m_bFixedMode = true;
        this.m_bShowLabels = true;
        this.m_bShowRulerName = false;
        this.m_hMajor[0] = 0.0;
        this.m_hMajor[1] = this.m_defhMajor;
        this.m_hMajor[2] = 0.0;
        this.m_hMajor[3] = this.m_defhMajor;
        this.m_hMinor[0] = 0.0;
        this.m_hMinor[1] = this.m_defhMinor;
        this.m_hMinor[2] = 0.0;
        this.m_hMinor[3] = this.m_defhMinor;
        this.m_hMajorColor = this.m_defhMajorColor;
        this.m_hMinorColor = this.m_defhMinorColor;
        this.setDefDynamicHashing();
        this.m_numMajorHashings.init();
        this.m_numMinorHashings.init();
        this.m_minMax.m_data[0] = this.m_defMin;
        this.m_minMax.m_data[1] = this.m_defMax;
        this.setDefFixedHashing();
        this.m_majorHashUnits.init();
        this.m_minorHashUnits.init();
        this.showVertices(true);
        this.showIndices(true);
        this.setGlobalPolygonSize(1.0);
        this.setGlobalVertexSize(0);
        this.setDefaultLabelEnabled(false);
        this.showPolygonColors(true);
    }

    public void setHashLabel(int n, int n2, int n3) {
        this.setLabelAttribute(0, n, n2, n3, 0, 1);
    }

    protected void computeFixedHashings(int n) {
        PdVector pdVector;
        PdVector pdVector2;
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        if (n == 0) {
            pdVector2 = PdVector.copyNew(this.m_n);
            pdVector = PdVector.copyNew(this.m_origin);
            pdVector.add(this.m_normalOffset);
            dArray[0] = this.m_hMajor[0];
            dArray[1] = this.m_hMajor[1];
            dArray2[0] = this.m_hMinor[0];
            dArray2[1] = this.m_hMinor[1];
        } else {
            pdVector2 = PdVector.copyNew(this.m_u);
            pdVector = PdVector.copyNew(this.m_origin);
            pdVector.add(this.m_upOffset);
            dArray[0] = this.m_hMajor[2];
            dArray[1] = this.m_hMajor[3];
            dArray2[0] = this.m_hMinor[2];
            dArray2[1] = this.m_hMinor[3];
        }
        double d = this.m_minMax.getEntry(0);
        double d2 = this.m_minMax.getEntry(1);
        double d3 = this.m_minorHashUnits.getValue();
        if (this.m_bMajorMode) {
            this.constructHashSet(this, pdVector, this.m_v, pdVector2, this.m_tiMajor, dArray, true);
            if (this.m_bMinorMode) {
                int n2 = this.m_tiMajor.length;
                if (n2 == 0) {
                    this.m_tiMinor = this.HashInterval(d3, d, true, d2, true);
                    this.constructHashSet(this, pdVector, this.m_v, pdVector2, this.m_tiMinor, dArray2, false);
                } else {
                    this.m_tiMinor = this.HashInterval(d3, d, false, this.m_tiMajor[0], false);
                    this.constructHashSet(this, pdVector, this.m_v, pdVector2, this.m_tiMinor, dArray2, false);
                    this.m_tiMinor = this.HashInterval(d3, this.m_tiMajor[n2 - 1], false, d2, false);
                    this.constructHashSet(this, pdVector, this.m_v, pdVector2, this.m_tiMinor, dArray2, false);
                    int n3 = 1;
                    while (n3 < n2) {
                        this.m_tiMinor = this.HashInterval(d3, this.m_tiMajor[n3 - 1], false, this.m_tiMajor[n3], false);
                        this.constructHashSet(this, pdVector, this.m_v, pdVector2, this.m_tiMinor, dArray2, false);
                        ++n3;
                    }
                }
            }
        }
        if (this.m_bMinorMode && !this.m_bMajorMode) {
            this.m_tiMinor = this.HashInterval(d3, d, true, d2, true);
            this.constructHashSet(this, pdVector, this.m_v, pdVector2, this.m_tiMinor, dArray2, false);
        }
    }

    protected void computeDynamicHashings(int n) {
        int n2;
        PdVector pdVector;
        PdVector pdVector2;
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        if (n == 0) {
            pdVector2 = PdVector.copyNew(this.m_n);
            pdVector = PdVector.copyNew(this.m_origin);
            pdVector.add(this.m_normalOffset);
            dArray[0] = this.m_hMajor[0];
            dArray[1] = this.m_hMajor[1];
            dArray2[0] = this.m_hMinor[0];
            dArray2[1] = this.m_hMinor[1];
        } else {
            pdVector2 = PdVector.copyNew(this.m_u);
            pdVector = PdVector.copyNew(this.m_origin);
            pdVector.add(this.m_upOffset);
            dArray[0] = this.m_hMajor[2];
            dArray[1] = this.m_hMajor[3];
            dArray2[0] = this.m_hMinor[2];
            dArray2[1] = this.m_hMinor[3];
        }
        if (this.m_bMajorMode) {
            this.constructHashSet(this, pdVector, this.m_v, pdVector2, this.m_tiMajor, dArray, true);
            if (this.m_bMinorMode) {
                n2 = 1;
                while (n2 < this.m_tiMajor.length) {
                    this.m_tiMinor = this.PartitionInterval(this.m_numMinorHashings.getValue(), this.m_tiMajor[n2 - 1], false, this.m_tiMajor[n2], false);
                    this.constructHashSet(this, pdVector, this.m_v, pdVector2, this.m_tiMinor, dArray2, false);
                    ++n2;
                }
            }
        }
        if (this.m_bMinorMode && !this.m_bMajorMode) {
            this.constructHashSet(this, pdVector, this.m_v, pdVector2, this.m_tiMajor, dArray2, false);
            n2 = 1;
            while (n2 < this.m_tiMajor.length) {
                this.m_tiMinor = this.PartitionInterval(this.m_numMinorHashings.getValue(), this.m_tiMajor[n2 - 1], false, this.m_tiMajor[n2], false);
                this.constructHashSet(this, pdVector, this.m_v, pdVector2, this.m_tiMinor, dArray2, false);
                ++n2;
            }
        }
    }

    public void setDirection(PdVector pdVector, PdVector pdVector2) {
        this.m_v.sub(pdVector2, pdVector);
        this.m_v.normalize();
    }

    public void setMajorHashSize(double d, double d2, int n) {
        if (n == 0) {
            this.m_hMajor[0] = d;
            this.m_hMajor[1] = d2;
        }
        if (n == 1) {
            this.m_hMajor[2] = d;
            this.m_hMajor[3] = d2;
        }
    }

    public double getMajorUnit() {
        return this.m_majorHashUnits.getValue();
    }

    public void setNameAlignment(int n, int n2, int n3) {
        if (this.m_rulerNamePos == 0) {
            this.setLabelAttribute(2, n2, n3, n, 0, 3);
            return;
        }
        if (this.m_rulerNamePos == 1) {
            this.setLabelAttribute(2, n2, n3, n, 0, 3);
            return;
        }
        if (this.m_rulerNamePos == 2) {
            this.setLabelAttribute(2, n2, n3, n, 0, 3);
        }
    }

    public void setNameAlignment(int n, int n2, int n3, int n4) {
        this.m_rulerNamePos = n;
        this.setNameAlignment(n2, n3, n4);
    }

    public int getNumMajorPartitions() {
        return this.m_numMajorHashings.getValue();
    }

    public boolean update(Object object) {
        if (object == this) {
            this.computeHashings();
            return super.update(this);
        }
        if (object == this.m_minorHashUnits || object == this.m_majorHashUnits) {
            this.m_majorHashUnits.setBounds(0.1, Math.ceil(this.m_minMax.getEntry(1) + 0.25));
            this.m_minorHashUnits.setBounds(0.1, Math.ceil(this.m_minMax.getEntry(1) + 0.25));
            this.computeHashings();
            return super.update(null);
        }
        if (object == this.m_numMajorHashings || object == this.m_numMinorHashings) {
            int n = new Double(2.0 * this.m_minMax.getEntry(1)).intValue();
            this.m_numMajorHashings.setBounds(0, n);
            this.m_numMinorHashings.setBounds(0, n);
            this.computeHashings();
            return super.update(null);
        }
        return super.update(object);
    }

    public PdVector getMinCoordinate() {
        return this.getVertex(this.getPolygon(0).getEntry(1));
    }

    public boolean isShowingHashingsInNormalDir() {
        return this.m_bHashInNormalDir;
    }

    public boolean isShowingHashingsInUpDir() {
        return this.m_bHashInUpDir;
    }

    private void constructorGuts() {
        this.setDimOfPolygons(2);
        this.setTag(6);
        this.setName("Axis Configuration Panel");
        this.m_origin = new PdVector(3);
        this.m_normalOffset = new PdVector(0.0, 0.0, 0.0);
        this.m_upOffset = new PdVector(0.0, 0.0, 0.0);
        this.m_minMax = new PdVector(2);
        this.m_majorHashUnits = new PuDouble("Major Units", this);
        this.m_minorHashUnits = new PuDouble("Minor Units", this);
        this.m_numMajorHashings = new PuInteger("Major Hashings", this);
        this.m_numMinorHashings = new PuInteger("Minor Hashings", this);
        if (this.getClass() == (class$jv$thirdParty$ruler$PgRuler != null ? class$jv$thirdParty$ruler$PgRuler : (class$jv$thirdParty$ruler$PgRuler = PgRuler.class$("jv.thirdParty.ruler.PgRuler")))) {
            this.init();
        }
    }

    public void showHashingsInNormalDir(boolean bl) {
        this.m_bHashInNormalDir = bl;
    }

    public void showHashingsInUpDir(boolean bl) {
        this.m_bHashInUpDir = bl;
    }

    public double getMinParameter() {
        return this.m_minMax.getEntry(0);
    }

    public boolean isShowingMajorHashings() {
        return this.m_bMajorMode;
    }

    public void showMajorHashings(boolean bl) {
        this.m_bMajorMode = bl;
    }

    protected double[] HashInterval(double d, double d2, boolean bl, double d3, boolean bl2) {
        double d4;
        Vector<Double> vector = new Vector<Double>();
        double d5 = 1.0E-6;
        double d6 = bl ? d * Math.ceil(d2 / d) : d * Math.floor((d2 + d) / d);
        double d7 = d4 = bl2 ? d * Math.floor(d3 / d) : d * Math.ceil((d3 - d) / d);
        if (Math.abs(d6 - d2) < d5) {
            d6 += d;
        }
        if (Math.abs(d4 - d3) < d5) {
            d4 -= d;
        }
        double d8 = d6;
        while (d8 <= d4 + 1.0E-7) {
            vector.addElement(new Double(d8));
            d8 += d;
        }
        double[] dArray = new double[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            Double d9 = (Double)vector.elementAt(n);
            dArray[n] = d9;
            ++n;
        }
        return dArray;
    }

    protected double[] PartitionInterval(int n, double d, boolean bl, double d2, boolean bl2) {
        Vector<Double> vector = new Vector<Double>();
        double d3 = !bl ? 1 : 0;
        double d4 = !bl2 ? 1 : 0;
        double d5 = (d2 - d) / (double)(n + 1);
        double d6 = d + d3 * d5;
        double d7 = d2 - d4 * d5;
        double d8 = d6;
        while ((float)d8 <= (float)d7) {
            vector.addElement(new Double(d8));
            d8 += d5;
        }
        double[] dArray = new double[vector.size()];
        int n2 = 0;
        while (n2 < vector.size()) {
            Double d9 = (Double)vector.elementAt(n2);
            dArray[n2] = d9;
            ++n2;
        }
        return dArray;
    }

    public PgRuler() {
        super(3);
        this.constructorGuts();
    }

    public PgRuler(PdVector pdVector, PdVector pdVector2) {
        super(3);
        this.constructorGuts();
        this.setDirection(new PdVector(0.0, 0.0, 0.0), pdVector);
        this.setNormal(pdVector2);
        this.computeUpVector();
    }

    public PgRuler(PdVector pdVector, PdVector pdVector2, double d, double d2) {
        super(3);
        this.constructorGuts();
        this.setDirection(new PdVector(0.0, 0.0, 0.0), pdVector);
        this.setNormal(pdVector2);
        this.computeUpVector();
        this.setMinMax(d, d2);
    }

    public PgRuler(PdVector pdVector, PdVector pdVector2, PdVector pdVector3) {
        super(3);
        this.constructorGuts();
        this.setDirection(pdVector, pdVector2);
        this.setNormal(pdVector3);
        this.computeUpVector();
    }

    public PgRuler(PdVector pdVector, PdVector pdVector2, PdVector pdVector3, double d, double d2) {
        super(3);
        this.constructorGuts();
        this.setDirection(pdVector, pdVector2);
        this.setNormal(pdVector3);
        this.computeUpVector();
        this.setMinMax(d, d2);
    }

    private void makeUnit_PerpUnit(PdVector pdVector) {
        if (pdVector.m_data[0] == 0.0 && pdVector.m_data[1] == 0.0) {
            pdVector.m_data[0] = 1.0;
            pdVector.m_data[1] = 0.0;
            pdVector.m_data[2] = 0.0;
            return;
        }
        double d = pdVector.m_data[0];
        pdVector.m_data[0] = -pdVector.m_data[1];
        pdVector.m_data[1] = d;
        pdVector.m_data[2] = pdVector.m_data[2];
    }

    public double getMinorUnit() {
        return this.m_minorHashUnits.getValue();
    }

    public void measure(PdVector pdVector) {
        this.measure(pdVector, new PdVector(0.0, 0.0, 1.0));
    }

    public void measure(PdVector pdVector, PdVector pdVector2) {
        if (pdVector.m_data.length == 3) {
            this.setDirection(this.m_origin, pdVector);
            this.m_minMax.setEntry(0, 0.0);
            this.m_minMax.setEntry(1, PdVector.dist(pdVector, this.m_origin));
            if (pdVector.m_data[1] < 0.001 && pdVector.m_data[1] > -0.001) {
                this.setNormal(new PdVector(this.m_v.m_data[2], 0.0, this.m_v.m_data[0]));
                return;
            }
            if (pdVector.m_data[0] < 0.001 && pdVector.m_data[0] > -0.001) {
                this.setNormal(new PdVector(0.0, -this.m_v.m_data[2], this.m_v.m_data[1]));
                return;
            }
            if (pdVector.m_data[2] < 0.001 && pdVector.m_data[2] > -0.001) {
                this.setNormal(new PdVector(-this.m_v.m_data[1], this.m_v.m_data[0], 0.0));
                return;
            }
            this.setNormal(pdVector2);
        }
    }

    public void flipNormal() {
        this.m_n.multScalar(-1.0);
    }

    public void setMinorHashSize(double d, double d2, int n) {
        if (n == 0) {
            this.m_hMinor[0] = d;
            this.m_hMinor[1] = d2;
        }
        if (n == 1) {
            this.m_hMinor[2] = d;
            this.m_hMinor[3] = d2;
        }
    }

    public PdVector getNormal() {
        return this.m_n;
    }

    public void setNormal(PdVector pdVector) {
        this.m_n.copy(pdVector);
        this.m_n.normalize();
    }

    public void setFixedHashing(double d, double d2) {
        this.m_majorHashUnits.setValue(d);
        this.m_minorHashUnits.setValue(d2);
    }

    public boolean isShowingFixedMode() {
        return this.m_bFixedMode;
    }

    public void showFixedMode(boolean bl) {
        this.m_bFixedMode = bl;
    }

    public void setDynamicHashing(int n, int n2) {
        this.m_numMajorHashings.setValue(n);
        this.m_numMinorHashings.setValue(n2);
    }

    public int getNumMinorPartitions() {
        return this.m_numMinorHashings.getValue();
    }

    public void setDefaultHashSizes(int n) {
        if (n == 0) {
            this.m_hMajor[0] = this.m_defhMajor;
            this.m_hMajor[1] = 0.0;
            this.m_hMinor[0] = this.m_defhMinor;
            this.m_hMinor[1] = 0.0;
            this.m_bHashInNormalDir = true;
            this.m_bHashInUpDir = false;
        }
        if (n == 1) {
            this.m_hMajor[2] = this.m_defhMajor;
            this.m_hMajor[3] = 0.0;
            this.m_hMinor[2] = this.m_defhMinor;
            this.m_hMinor[3] = 0.0;
            this.m_bHashInNormalDir = false;
            this.m_bHashInUpDir = true;
        }
    }

    protected int computeBaseLine() {
        double d;
        int n = 0;
        double d2 = this.m_minMax.getEntry(0);
        if (d2 < (d = this.m_minMax.getEntry(1))) {
            int n2;
            PdVector pdVector = new PdVector(3);
            PiVector piVector = new PiVector(3);
            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumFractionDigits(1);
            if (this.m_bFixedMode) {
                this.setNumVertices(1);
                pdVector.copy(this.m_v);
                pdVector.multScalar(d2);
                pdVector.add(this.m_origin);
                this.setVertex(0, pdVector);
                piVector.addEntry(0);
                this.m_tiMajor = this.HashInterval(this.m_majorHashUnits.getValue(), d2, true, d, true);
                this.setNumVertices(this.m_tiMajor.length + 2);
                n2 = 0;
                while (n2 < this.m_tiMajor.length) {
                    pdVector.copy(this.m_v);
                    pdVector.multScalar(this.m_tiMajor[n2]);
                    pdVector.add(this.m_origin);
                    if (this.m_bShowLabels) {
                        pdVector.setName(numberFormat.format(this.m_tiMajor[n2]));
                    }
                    this.setVertex(n2 + 1, pdVector);
                    piVector.addEntry(n2 + 1);
                    ++n2;
                }
                pdVector.copy(this.m_v);
                pdVector.multScalar(d);
                pdVector.add(this.m_origin);
                this.setVertex(this.m_tiMajor.length + 1, pdVector);
                piVector.addEntry(this.m_tiMajor.length + 1);
                n = 1;
            } else if (!this.m_bFixedMode) {
                this.m_tiMajor = this.PartitionInterval(this.m_numMajorHashings.getValue(), d2, true, d, true);
                this.setNumVertices(this.m_tiMajor.length);
                n2 = 0;
                while (n2 < this.m_tiMajor.length) {
                    pdVector.copy(this.m_v);
                    pdVector.multScalar(this.m_tiMajor[n2]);
                    pdVector.add(this.m_origin);
                    if (this.m_bShowLabels) {
                        pdVector.setName(numberFormat.format(this.m_tiMajor[n2]));
                    }
                    this.setVertex(n2, pdVector);
                    piVector.addEntry(n2);
                    ++n2;
                }
                n = 2;
            }
            this.setNumPolygons(1);
            this.setPolygon(0, piVector);
            this.assurePolygonColors();
            this.setPolygonColor(0, this.m_hMajorColor);
            if (this.m_bShowRulerName) {
                this.setNumPolygons(2);
                switch (this.m_rulerNamePos) {
                    case 0: {
                        pdVector.copy(this.m_v);
                        pdVector.multScalar(d2);
                        pdVector.add(this.m_origin);
                        break;
                    }
                    case 1: {
                        pdVector.copy(this.m_v);
                        pdVector.multScalar(d);
                        pdVector.add(this.m_origin);
                        break;
                    }
                    case 2: {
                        pdVector.copy(this.m_v);
                        pdVector.multScalar((d2 + d) / 2.0);
                        pdVector.add(this.m_origin);
                        break;
                    }
                    default: {
                        pdVector.copy(this.m_v);
                        pdVector.multScalar(d2);
                        pdVector.add(this.m_origin);
                    }
                }
                n2 = this.getNumVertices();
                this.setVertex(n2, pdVector);
                this.setVertex(n2 + 1, pdVector);
                this.setPolygon(1, new PiVector(n2, n2 + 1));
                this.setPolygonColor(1, this.m_hMajorColor);
                this.getPolygon(1).setName(this.m_rulerName);
            }
        }
        return n;
    }

    public PdVector getMaxCoordinate() {
        return this.getVertex(this.getPolygon(0).getEntry(1));
    }

    protected void computeUpVector() {
        this.m_u.cross(this.m_v, this.m_n);
    }

    public void flipUpVector() {
        this.m_u.multScalar(-1.0);
    }
}

