/*
 * Decompiled with CFR 0.152.
 */
package jv.vecmath;

import jv.object.PsDebug;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;

public class PuProj {
    public static void poincare2Lorentz(PdVector pdVector, PdVector pdVector2) {
        double d = pdVector2.sqrLength();
        if (d > 0.9999999999) {
            d = 0.9999999999;
            pdVector2.setLength(d);
        }
        d = 2.0 / (1.0 - d);
        int n = 2;
        do {
            pdVector.m_data[n + 1] = pdVector2.m_data[n] * d;
        } while (--n >= 0);
        pdVector.m_data[0] = d - 1.0;
    }

    public static void uhm2Lorentz(PdVector pdVector, PdVector pdVector2) {
        if (pdVector2.m_data[2] < 1.0E-10) {
            pdVector2.m_data[2] = 1.0E-10;
        }
        double d = pdVector2.sqrLength();
        double d2 = 2.0 * pdVector2.m_data[2];
        pdVector.m_data[3] = d - 1.0;
        pdVector.m_data[2] = pdVector2.m_data[1];
        pdVector.m_data[1] = pdVector2.m_data[0];
        pdVector.m_data[0] = d + 1.0;
        int n = 0;
        do {
            int n2 = n++;
            pdVector.m_data[n2] = pdVector.m_data[n2] / d2;
        } while (n < 4);
    }

    public static void lorentz2Klein(PdVector pdVector, PdVector pdVector2) {
        if (pdVector2.m_data[0] < 0.9999999999) {
            PsDebug.warning("point pl is not in H3, " + pdVector2.toString());
            pdVector.setConstant(0.0);
            return;
        }
        int n = 2;
        do {
            pdVector.m_data[n] = pdVector2.m_data[n + 1] / pdVector2.m_data[0];
        } while (--n >= 0);
    }

    public static void stereoS3_to_R3(PdVector pdVector, PdVector pdVector2) {
        double d;
        int n;
        double d2 = pdVector2.sqrLength();
        if (Math.abs(d2 - 1.0) > 1.0E-10) {
            d2 = Math.sqrt(d2);
            PsDebug.warning("point not in S3, |p| = " + d2);
            n = 0;
            do {
                int n2 = n++;
                pdVector2.m_data[n2] = pdVector2.m_data[n2] / d2;
            } while (n < 4);
        }
        if (Math.abs(d = pdVector2.m_data[0] + 1.0) < 1.0E-10) {
            PsDebug.warning("argument vertex lies at projection center");
            d = 1.0E-10;
        }
        n = 0;
        do {
            pdVector.m_data[n] = pdVector2.m_data[n + 1] / d;
        } while (++n < 3);
    }

    public static void stereoInvR3_to_S3(PdVector pdVector, PdVector pdVector2) {
        double d = 2.0 / (1.0 + pdVector2.sqrLength());
        int n = 2;
        do {
            pdVector.m_data[n + 1] = pdVector2.m_data[n] * d;
        } while (--n >= 0);
        pdVector.m_data[0] = d - 1.0;
    }

    public static void uhm2Poincare(PdVector pdVector, PdVector pdVector2) {
        if (pdVector2.m_data[2] < 1.0E-10) {
            pdVector2.m_data[2] = 1.0E-10;
        }
        double d = pdVector.sqrLength();
        double d2 = pdVector2.m_data[0] * pdVector2.m_data[0] + pdVector2.m_data[1] * pdVector2.m_data[1] + (pdVector2.m_data[2] + 1.0) * (pdVector2.m_data[2] + 1.0);
        pdVector.m_data[0] = 2.0 * pdVector2.m_data[0];
        pdVector.m_data[1] = 2.0 * pdVector2.m_data[1];
        pdVector.m_data[2] = d - 1.0;
        int n = 0;
        do {
            int n2 = n++;
            pdVector.m_data[n2] = pdVector.m_data[n2] / d2;
        } while (n < 3);
    }

    public static void klein2Lorentz(PdVector pdVector, PdVector pdVector2) {
        double d = pdVector2.sqrLength();
        if (d > 0.9999999999) {
            d = 0.9999999999;
            pdVector2.setLength(d);
        }
        int n = 2;
        do {
            pdVector.m_data[n + 1] = pdVector2.m_data[n] * d;
        } while (--n >= 0);
        pdVector.m_data[0] = d = 1.0 / Math.sqrt(1.0 - d);
    }

    public static void poincare2Uhm(PdVector pdVector, PdVector pdVector2) {
        double d = pdVector2.sqrLength();
        if (d > 0.9999999999) {
            d = 0.9999999999;
            pdVector2.setLength(d);
        }
        double d2 = pdVector2.m_data[0] * pdVector2.m_data[0] + pdVector2.m_data[1] * pdVector2.m_data[1] + (pdVector2.m_data[2] - 1.0) * (pdVector2.m_data[2] - 1.0);
        pdVector.m_data[0] = 2.0 * pdVector2.m_data[0];
        pdVector.m_data[1] = 2.0 * pdVector2.m_data[1];
        pdVector.m_data[2] = 1.0 - d;
        int n = 0;
        do {
            int n2 = n++;
            pdVector.m_data[n2] = pdVector.m_data[n2] / d2;
        } while (n < 3);
    }

    public static void poincare2Klein(PdVector pdVector, PdVector pdVector2) {
        double d = pdVector2.sqrLength();
        if (d > 0.9999999999) {
            d = 0.9999999999;
            pdVector2.setLength(d);
        }
        d = 2.0 / (1.0 + d);
        int n = 0;
        do {
            pdVector.m_data[n] = d * pdVector2.m_data[n];
        } while (++n < 3);
    }

    public static void lorentz2Poincare(PdVector pdVector, PdVector pdVector2) {
        if (pdVector2.m_data[0] < 0.9999999999) {
            PsDebug.warning("point pl is not in H3; " + pdVector2.toString());
            pdVector.setConstant(0.0);
            return;
        }
        int n = 2;
        do {
            pdVector.m_data[n] = pdVector2.m_data[n + 1] / (pdVector2.m_data[0] + 1.0);
        } while (--n >= 0);
    }

    public static void klein2Poincare(PdVector pdVector, PdVector pdVector2) {
        double d = pdVector2.sqrLength();
        if (d > 0.9999999999) {
            d = 0.9999999999;
            pdVector2.setLength(d);
        }
        d = 1.0 / (1.0 + Math.sqrt(1.0 - d));
        int n = 0;
        do {
            pdVector.m_data[n] = d * pdVector2.m_data[n];
        } while (++n < 3);
    }

    public static void diffKlein2Lorentz(PdMatrix pdMatrix, PdVector pdVector) {
        if (pdMatrix.getISize() != 4 || pdMatrix.getJSize() != 3) {
            PsDebug.warning("matrix has invalid size.");
            pdMatrix.setSize(4, 3);
        }
        PdVector pdVector2 = new PdVector(pdVector.getSize());
        double[][] dArray = pdMatrix.m_data;
        double d = pdVector.sqrLength();
        if (d > 0.9999999999) {
            int n;
            int n2 = 0;
            do {
                n = 0;
                do {
                    dArray[n2 + 1][n] = pdVector.m_data[n2] * pdVector2.m_data[n];
                } while (++n < 3);
            } while (++n2 < 3);
            n = 0;
            do {
                dArray[0][n] = 1.0;
            } while (++n < 3);
            dArray[n + 1][n] = 1.0;
            return;
        }
        d = 1.0 / Math.sqrt(1.0 - d);
        int n = 0;
        do {
            dArray[0][n] = pdVector2.m_data[n] = pdVector.m_data[n] * d * d * d;
        } while (++n < 3);
        int n3 = 0;
        do {
            n = 0;
            do {
                dArray[n3 + 1][n] = pdVector.m_data[n3] * pdVector2.m_data[n];
            } while (++n < 3);
        } while (++n3 < 3);
        n = 0;
        do {
            double[] dArray2 = dArray[n + 1];
            int n4 = n++;
            dArray2[n4] = dArray2[n4] + d;
        } while (n < 3);
    }

    public static void diffPoincare2Lorentz(PdMatrix pdMatrix, PdVector pdVector) {
        if (pdMatrix.getISize() != 4 || pdMatrix.getJSize() != 3) {
            PsDebug.warning("matrix has invalid size.");
            pdMatrix.setSize(4, 3);
        }
        PdVector pdVector2 = new PdVector(pdVector.getSize());
        double[][] dArray = pdMatrix.m_data;
        double d = pdVector.sqrLength();
        if (d > 0.9999999999) {
            int n;
            int n2 = 0;
            do {
                n = 0;
                do {
                    dArray[n2 + 1][n] = pdVector.m_data[n2] * pdVector2.m_data[n];
                } while (++n < 3);
            } while (++n2 < 3);
            n = 0;
            do {
                dArray[0][n] = 1.0;
            } while (++n < 3);
            dArray[n + 1][n] = 2.0;
            return;
        }
        d = 2.0 / (1.0 - d);
        int n = 0;
        do {
            dArray[0][n] = pdVector2.m_data[n] = pdVector.m_data[n] * d * d;
        } while (++n < 3);
        int n3 = 0;
        do {
            n = 0;
            do {
                dArray[n3 + 1][n] = pdVector.m_data[n3] * pdVector2.m_data[n];
            } while (++n < 3);
        } while (++n3 < 3);
        n = 0;
        do {
            double[] dArray2 = dArray[n + 1];
            int n4 = n++;
            dArray2[n4] = dArray2[n4] + d;
        } while (n < 3);
    }

    public static void lorentz2Uhm(PdVector pdVector, PdVector pdVector2) {
        if (pdVector2.m_data[0] < 0.9999999999) {
            PsDebug.warning("point pl is not in H3; " + pdVector2.toString());
            pdVector.setConstant(0.0);
            pdVector.setEntry(2, 1.0);
            return;
        }
        double d = pdVector2.m_data[0] - pdVector2.m_data[3];
        pdVector.m_data[0] = pdVector2.m_data[0];
        pdVector.m_data[1] = pdVector2.m_data[1];
        pdVector.m_data[2] = 1.0;
        int n = 0;
        do {
            int n2 = n++;
            pdVector.m_data[n2] = pdVector.m_data[n2] / d;
        } while (n < 3);
    }

    public static void klein2Uhm(PdVector pdVector, PdVector pdVector2) {
        double d = pdVector2.sqrLength();
        if (d > 0.9999999999) {
            d = 0.9999999999;
            pdVector2.setLength(d);
        }
        double d2 = 1.0 - pdVector2.m_data[2];
        pdVector.m_data[0] = pdVector2.m_data[0];
        pdVector.m_data[1] = pdVector2.m_data[1];
        pdVector.m_data[2] = 1.0 - d / (1.0 + Math.sqrt(1.0 - d));
        int n = 0;
        do {
            int n2 = n++;
            pdVector.m_data[n2] = pdVector.m_data[n2] / d2;
        } while (n < 3);
    }

    public static void uhm2Klein(PdVector pdVector, PdVector pdVector2) {
        if (pdVector2.m_data[2] < 1.0E-10) {
            pdVector2.m_data[2] = 1.0E-10;
        }
        double d = pdVector.sqrLength();
        double d2 = 1.0 + d;
        pdVector.m_data[0] = 2.0 * pdVector2.m_data[0];
        pdVector.m_data[1] = 2.0 * pdVector2.m_data[1];
        pdVector.m_data[2] = d - 1.0;
        int n = 0;
        do {
            int n2 = n++;
            pdVector.m_data[n2] = pdVector.m_data[n2] / d2;
        } while (n < 3);
    }

    public static void diffStereoS3_to_R3(PdMatrix pdMatrix, PdVector pdVector) {
        double d;
        if (pdMatrix.getISize() != 3 || pdMatrix.getJSize() != 4) {
            PsDebug.warning("matrix has invalid size.");
            pdMatrix.setSize(3, 4);
        }
        if (Math.abs(d = pdVector.m_data[0] + 1.0) < 1.0E-10) {
            PsDebug.warning("argument vertex lies at projection center");
            d = Math.sqrt(1.0E-10);
        }
        d = 1.0 / d;
        double[][] dArray = pdMatrix.m_data;
        int n = 0;
        do {
            dArray[n][n + 1] = d;
        } while (++n < 3);
        d *= d;
        n = 0;
        do {
            dArray[n][0] = -pdVector.m_data[n + 1] * d;
        } while (++n < 3);
        dArray[1][1] = 0.0;
        dArray[0][3] = 0.0;
        dArray[0][2] = 0.0;
        dArray[2][2] = 0.0;
        dArray[2][1] = 0.0;
        dArray[1][3] = 0.0;
    }

    public static void diffStereoInvR3_to_S3(PdMatrix pdMatrix, PdVector pdVector) {
        if (pdMatrix.getISize() != 4 || pdMatrix.getJSize() != 3) {
            PsDebug.warning("matrix has invalid size.");
            pdMatrix.setSize(4, 3);
        }
        double d = 2.0 / (1.0 + pdVector.sqrLength());
        double d2 = d * d;
        double[][] dArray = pdMatrix.m_data;
        int n = 0;
        do {
            dArray[0][n] = -pdVector.m_data[n] * d2;
        } while (++n < 3);
        int n2 = 0;
        do {
            n = 0;
            do {
                dArray[n2 + 1][n] = pdVector.m_data[n2] * dArray[0][n];
            } while (++n < 3);
        } while (++n2 < 3);
        n2 = 0;
        do {
            double[] dArray2 = dArray[n2 + 1];
            int n3 = n2++;
            dArray2[n3] = dArray2[n3] + d;
        } while (n2 < 3);
    }
}

