/*
 * Decompiled with CFR 0.152.
 */
package jv.vecmath;

import jv.object.PsDebug;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;

public class PuReflect {
    public static PdMatrix planeReflect(PdVector pdVector, PdVector pdVector2) {
        PdMatrix pdMatrix = new PdMatrix(4, 4);
        pdVector2.normalize();
        double d = pdVector2.m_data[0];
        double d2 = pdVector2.m_data[1];
        double d3 = pdVector2.m_data[2];
        double d4 = PdVector.dot(pdVector, pdVector2);
        pdMatrix.m_data[0][0] = 1.0 - 2.0 * d * d;
        pdMatrix.m_data[0][1] = -2.0 * d * d2;
        pdMatrix.m_data[0][2] = -2.0 * d * d3;
        pdMatrix.m_data[0][3] = 2.0 * d * d4;
        pdMatrix.m_data[1][0] = -2.0 * d * d2;
        pdMatrix.m_data[1][1] = 1.0 - 2.0 * d2 * d2;
        pdMatrix.m_data[1][2] = -2.0 * d2 * d3;
        pdMatrix.m_data[1][3] = 2.0 * d2 * d4;
        pdMatrix.m_data[2][0] = -2.0 * d * d3;
        pdMatrix.m_data[2][1] = -2.0 * d2 * d3;
        pdMatrix.m_data[2][2] = 1.0 - 2.0 * d3 * d3;
        pdMatrix.m_data[2][3] = 2.0 * d3 * d4;
        pdMatrix.m_data[3][0] = 0.0;
        pdMatrix.m_data[3][1] = 0.0;
        pdMatrix.m_data[3][2] = 0.0;
        pdMatrix.m_data[3][3] = 1.0;
        return pdMatrix;
    }

    public static PdMatrix pointReflect(PdVector pdVector) {
        PdMatrix pdMatrix = new PdMatrix(4, 4);
        pdMatrix.m_data[0][0] = -1.0;
        pdMatrix.m_data[0][1] = 0.0;
        pdMatrix.m_data[0][2] = 0.0;
        pdMatrix.m_data[0][3] = 2.0 * pdVector.m_data[0];
        pdMatrix.m_data[1][0] = 0.0;
        pdMatrix.m_data[1][1] = -1.0;
        pdMatrix.m_data[1][2] = 0.0;
        pdMatrix.m_data[1][3] = 2.0 * pdVector.m_data[1];
        pdMatrix.m_data[2][0] = 0.0;
        pdMatrix.m_data[2][1] = 0.0;
        pdMatrix.m_data[2][2] = -1.0;
        pdMatrix.m_data[2][3] = 2.0 * pdVector.m_data[2];
        pdMatrix.m_data[3][0] = 0.0;
        pdMatrix.m_data[3][1] = 0.0;
        pdMatrix.m_data[3][2] = 0.0;
        pdMatrix.m_data[3][3] = 1.0;
        return pdMatrix;
    }

    public static PdMatrix rotateLine(PdVector pdVector, PdVector pdVector2) {
        PdMatrix pdMatrix = new PdMatrix(4, 4);
        double d = pdVector.m_data[0];
        double d2 = pdVector.m_data[1];
        double d3 = pdVector.m_data[2];
        double d4 = pdVector2.m_data[0];
        double d5 = pdVector2.m_data[1];
        double d6 = pdVector2.m_data[2];
        double d7 = pdVector2.sqrLength();
        pdMatrix.m_data[0][0] = 2.0 * d4 * d4 / d7;
        pdMatrix.m_data[0][1] = 2.0 * d5 * d4 / d7;
        pdMatrix.m_data[0][2] = 2.0 * d6 * d4 / d7;
        pdMatrix.m_data[0][3] = 2.0 * d - pdMatrix.m_data[0][0] * d - pdMatrix.m_data[0][1] * d2 - pdMatrix.m_data[0][2] * d3;
        pdMatrix.m_data[1][0] = pdMatrix.m_data[0][1];
        pdMatrix.m_data[1][1] = 2.0 * d5 * d5 / d7;
        pdMatrix.m_data[1][2] = 2.0 * d6 * d5 / d7;
        pdMatrix.m_data[1][3] = 2.0 * d2 - pdMatrix.m_data[1][0] * d - pdMatrix.m_data[1][1] * d2 - pdMatrix.m_data[1][2] * d3;
        pdMatrix.m_data[2][0] = pdMatrix.m_data[0][2];
        pdMatrix.m_data[2][1] = pdMatrix.m_data[1][2];
        pdMatrix.m_data[2][2] = 2.0 * d6 * d6 / d7;
        pdMatrix.m_data[2][3] = 2.0 * d3 - pdMatrix.m_data[2][0] * d - pdMatrix.m_data[2][1] * d2 - pdMatrix.m_data[2][2] * d3;
        double[] dArray = pdMatrix.m_data[0];
        dArray[0] = dArray[0] - 1.0;
        double[] dArray2 = pdMatrix.m_data[1];
        dArray2[1] = dArray2[1] - 1.0;
        double[] dArray3 = pdMatrix.m_data[2];
        dArray3[2] = dArray3[2] - 1.0;
        pdMatrix.m_data[3][0] = 0.0;
        pdMatrix.m_data[3][1] = 0.0;
        pdMatrix.m_data[3][2] = 0.0;
        pdMatrix.m_data[3][3] = 1.0;
        return pdMatrix;
    }

    public static PdMatrix rotateLine(PdVector pdVector, PdVector pdVector2, double d) {
        PdMatrix pdMatrix = new PdMatrix(4, 4);
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        pdVector2.normalize();
        pdMatrix.m_data[0][0] = d2 + (1.0 - d2) * pdVector2.m_data[0] * pdVector2.m_data[0];
        pdMatrix.m_data[0][1] = -d3 * pdVector2.m_data[2] + (1.0 - d2) * pdVector2.m_data[0] * pdVector2.m_data[1];
        pdMatrix.m_data[0][2] = d3 * pdVector2.m_data[1] + (1.0 - d2) * pdVector2.m_data[0] * pdVector2.m_data[2];
        pdMatrix.m_data[0][3] = pdVector.m_data[0] - pdMatrix.m_data[0][0] * pdVector.m_data[0] - pdMatrix.m_data[0][1] * pdVector.m_data[1] - pdMatrix.m_data[0][2] * pdVector.m_data[2];
        pdMatrix.m_data[1][0] = d3 * pdVector2.m_data[2] + (1.0 - d2) * pdVector2.m_data[0] * pdVector2.m_data[1];
        pdMatrix.m_data[1][1] = d2 + (1.0 - d2) * pdVector2.m_data[1] * pdVector2.m_data[1];
        pdMatrix.m_data[1][2] = -d3 * pdVector2.m_data[0] + (1.0 - d2) * pdVector2.m_data[1] * pdVector2.m_data[2];
        pdMatrix.m_data[1][3] = pdVector.m_data[1] - pdMatrix.m_data[1][0] * pdVector.m_data[0] - pdMatrix.m_data[1][1] * pdVector.m_data[1] - pdMatrix.m_data[1][2] * pdVector.m_data[2];
        pdMatrix.m_data[2][0] = -d3 * pdVector2.m_data[1] + (1.0 - d2) * pdVector2.m_data[0] * pdVector2.m_data[2];
        pdMatrix.m_data[2][1] = d3 * pdVector2.m_data[0] + (1.0 - d2) * pdVector2.m_data[1] * pdVector2.m_data[2];
        pdMatrix.m_data[2][2] = d2 + (1.0 - d2) * pdVector2.m_data[2] * pdVector2.m_data[2];
        pdMatrix.m_data[2][3] = pdVector.m_data[2] - pdMatrix.m_data[2][0] * pdVector.m_data[0] - pdMatrix.m_data[2][1] * pdVector.m_data[1] - pdMatrix.m_data[2][2] * pdVector.m_data[2];
        pdMatrix.m_data[3][0] = 0.0;
        pdMatrix.m_data[3][1] = 0.0;
        pdMatrix.m_data[3][2] = 0.0;
        pdMatrix.m_data[3][3] = 1.0;
        return pdMatrix;
    }

    public static PdMatrix translate(PdVector pdVector) {
        PdMatrix pdMatrix = new PdMatrix(4, 4);
        pdMatrix.setIdentity();
        pdMatrix.m_data[0][3] = pdVector.m_data[0];
        pdMatrix.m_data[1][3] = pdVector.m_data[1];
        pdMatrix.m_data[2][3] = pdVector.m_data[3];
        return pdMatrix;
    }

    public static boolean makeRotation(PdMatrix pdMatrix, PdVector pdVector, double d) {
        if (pdMatrix == null || pdVector == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        if (!pdVector.normalize()) {
            return false;
        }
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double d4 = 1.0 - d2;
        double d5 = pdVector.m_data[0];
        double d6 = pdVector.m_data[1];
        double d7 = pdVector.m_data[2];
        pdMatrix.m_data[0][0] = d2 + d4 * d5 * d5;
        pdMatrix.m_data[0][1] = -d7 * d3 + d4 * d5 * d6;
        pdMatrix.m_data[0][2] = d6 * d3 + d4 * d5 * d7;
        pdMatrix.m_data[1][0] = d7 * d3 + d4 * d5 * d6;
        pdMatrix.m_data[1][1] = d2 + d4 * d6 * d6;
        pdMatrix.m_data[1][2] = -d5 * d3 + d4 * d6 * d7;
        pdMatrix.m_data[2][0] = -d6 * d3 + d4 * d5 * d7;
        pdMatrix.m_data[2][1] = d5 * d3 + d4 * d6 * d7;
        pdMatrix.m_data[2][2] = d2 + d4 * d7 * d7;
        return true;
    }

    public static PdMatrix planeReflect(PdVector pdVector, PdVector pdVector2, PdVector pdVector3) {
        PdMatrix pdMatrix = new PdMatrix(4, 4);
        PdVector pdVector4 = new PdVector(3);
        pdVector4.normalOfPlane(pdVector, pdVector2, pdVector3);
        double d = pdVector4.m_data[0];
        double d2 = pdVector4.m_data[1];
        double d3 = pdVector4.m_data[2];
        double d4 = PdVector.dot(pdVector, pdVector4);
        pdMatrix.m_data[0][0] = 1.0 - 2.0 * d * d;
        pdMatrix.m_data[0][1] = -2.0 * d * d2;
        pdMatrix.m_data[0][2] = -2.0 * d * d3;
        pdMatrix.m_data[0][3] = 2.0 * d * d4;
        pdMatrix.m_data[1][0] = -2.0 * d * d2;
        pdMatrix.m_data[1][1] = 1.0 - 2.0 * d2 * d2;
        pdMatrix.m_data[1][2] = -2.0 * d2 * d3;
        pdMatrix.m_data[1][3] = 2.0 * d2 * d4;
        pdMatrix.m_data[2][0] = -2.0 * d * d3;
        pdMatrix.m_data[2][1] = -2.0 * d2 * d3;
        pdMatrix.m_data[2][2] = 1.0 - 2.0 * d3 * d3;
        pdMatrix.m_data[2][3] = 2.0 * d3 * d4;
        pdMatrix.m_data[3][0] = 0.0;
        pdMatrix.m_data[3][1] = 0.0;
        pdMatrix.m_data[3][2] = 0.0;
        pdMatrix.m_data[3][3] = 1.0;
        return pdMatrix;
    }
}

