/*
 * Decompiled with CFR 0.152.
 */
package jv.viewer;

import java.applet.Applet;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jv.number.PdColor;
import jv.number.PuInteger;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsMainFrame;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.project.PvCameraEvent;
import jv.project.PvCameraIf;
import jv.project.PvCameraListenerIf;
import jv.project.PvDisplayIf;
import jv.project.PvPickEvent;
import jv.project.PvPickListenerIf;
import jv.project.PvViewerIf;
import jv.thirdParty.ruler.PgAxes;
import jv.thirdParty.ruler.PjAxes;
import jv.vecmath.P_Vector;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuReflect;
import jv.viewer.PsAboutDialog;
import jv.viewer.PvCamera;
import jv.viewer.PvDisplay_IP;
import jv.viewer.PvGeometry;
import jv.viewer.PvGrid;
import jv.viewer.PvModelCamera;
import jv.viewer.PvScene;

public final class PvDisplay
extends Canvas
implements PvDisplayIf,
Runnable,
KeyListener,
MouseListener,
MouseMotionListener,
ActionListener,
Serializable {
    private static final int MOUSE_PICKED = 101;
    private static final int MOUSE_DRAGGED = 102;
    private static final int MOUSE_RELEASED = 103;
    public static final int KEY_0 = 48;
    public static final int KEY_1 = 49;
    public static final int KEY_2 = 50;
    public static final int KEY_3 = 51;
    public static final int KEY_4 = 52;
    public static final int KEY_5 = 53;
    public static final int KEY_6 = 54;
    public static final int KEY_7 = 55;
    public static final int KEY_8 = 56;
    public static final int KEY_9 = 57;
    public static final int KEY_A = 65;
    public static final int KEY_B = 66;
    public static final int KEY_C = 67;
    public static final int KEY_D = 68;
    public static final int KEY_E = 69;
    public static final int KEY_F = 70;
    public static final int KEY_G = 71;
    public static final int KEY_H = 72;
    public static final int KEY_I = 73;
    public static final int KEY_J = 74;
    public static final int KEY_K = 75;
    public static final int KEY_L = 76;
    public static final int KEY_M = 77;
    public static final int KEY_N = 78;
    public static final int KEY_O = 79;
    public static final int KEY_P = 80;
    public static final int KEY_Q = 81;
    public static final int KEY_R = 82;
    public static final int KEY_S = 83;
    public static final int KEY_T = 84;
    public static final int KEY_U = 85;
    public static final int KEY_V = 86;
    public static final int KEY_W = 87;
    public static final int KEY_X = 88;
    public static final int KEY_Y = 89;
    public static final int KEY_Z = 90;
    public static final int M_MODE_ORBIT = 0;
    public static final int M_MODE_SCALE = 1;
    public static final int M_MODE_SCALE_RECT = 2;
    public static final int M_MODE_TRANS = 3;
    public static final int M_MODE_TRANS_Z = 4;
    public static final int M_MODE_PICK = 5;
    public static final int M_MODE_INITIAL_PICK = 6;
    public static final int M_MODE_HIGHLIGHT = 7;
    public static final int M_MODE_DISPLAY_PICK = 8;
    public static final int M_MODE_MARK = 9;
    public static final int M_MODE_MARK_ELEMENTS = 10;
    public static final int M_MODE_UNMARK = 11;
    public static final int M_MODE_ADD = 12;
    public static final int M_MODE_DELETE = 13;
    public static final int M_MODE_DUPLICATE = 14;
    public String m_defBackgroundImage;
    public String m_backgroundImage;
    protected static final String[] m_majorModeMessage = new String[]{PsConfig.getMessage("MODE_ORBIT"), PsConfig.getMessage("MODE_SCALE"), PsConfig.getMessage("MODE_SCALE_RECT"), PsConfig.getMessage("MODE_TRANS"), PsConfig.getMessage("MODE_TRANS_Z"), PsConfig.getMessage("MODE_PICK"), PsConfig.getMessage("MODE_INITIAL_PICK"), PsConfig.getMessage("MODE_HIGHLIGHT"), PsConfig.getMessage("MODE_DISPLAY_PICK"), PsConfig.getMessage("MODE_MARK"), PsConfig.getMessage("MODE_MARK_ELEMENTS"), PsConfig.getMessage("MODE_UNMARK"), PsConfig.getMessage("MODE_ADD"), PsConfig.getMessage("MODE_DELETE"), PsConfig.getMessage("MODE_DUPLICATE")};
    protected static final int M_MODE_RESET = 0;
    protected static final int M_MODE_CENTER = 1;
    protected static final int M_MODE_FOCUS = 2;
    protected static final int M_MODE_START = 3;
    protected static final int M_MODE_STOP = 4;
    protected static final String[] m_minorModeMessage = new String[]{PsConfig.getMessage("MODE_RESET"), PsConfig.getMessage("MODE_CENTER"), PsConfig.getMessage("MODE_FOCUS"), PsConfig.getMessage("MODE_START"), PsConfig.getMessage("MODE_STOP")};
    protected static final boolean M_SWITCH_GRID = true;
    protected static final boolean M_SWITCH_DCUE = false;
    protected static final boolean M_SWITCH_HIDD = false;
    protected boolean m_bMouseInside;
    protected boolean m_bMouseDown;
    protected String m_name;
    private transient Applet m_applet;
    protected transient Frame m_frame;
    protected transient PsUpdateIf m_parent;
    protected transient PvViewerIf m_viewer;
    protected Hashtable m_camera;
    private static String[] m_cameraName = new String[]{"Perspective", "X-Y Projection", "X-Z Projection", "Y-Z Projection"};
    protected PvCamera m_currentCamera;
    protected PsPanel m_cameraPanel;
    protected PsPanel m_infoPanel;
    protected PvScene m_scene;
    protected PvGeometry m_currentGeom;
    private String m_currentFrameName;
    protected PgGeometryIf m_geomIf;
    protected boolean m_bCentered;
    protected static final String GEOM_AXES = "axes frame";
    protected static final String GEOM_AXES_0 = "x-axis";
    protected static final String GEOM_AXES_1 = "y-axis";
    protected static final String GEOM_AXES_2 = "z-axis";
    protected static final String GEOM_BNDBOX = "bndbox";
    protected static final String GEOM_FRAME = "frame";
    protected static final String GEOM_XY_GRID = "xy-grid";
    protected Hashtable m_specialGeom;
    protected int m_mode;
    protected int m_modeMajor;
    protected int m_defModeMajor;
    protected PvModelCamera m_modelCamera;
    protected boolean m_bTransformModel;
    protected int m_ambientSpace;
    protected int m_ambientProj;
    protected Vector m_cameraListener;
    protected Vector m_pickListener;
    protected PvPickListenerIf m_pickFocus;
    protected int m_pickedVertex;
    protected PdVector m_pick;
    protected PiVector m_markBox;
    protected PdVector m_worldPick;
    protected Dimension m_currLoc;
    protected double[] m_currNormLoc;
    protected transient Image m_backImage;
    private transient Image m_image;
    protected int m_nHeight;
    protected int m_nWidth;
    protected static Dimension m_defSize = new Dimension(300, 300);
    protected PuInteger m_height;
    protected PuInteger m_width;
    private transient Graphics m_g;
    protected int m_sceneFlags;
    protected static float PS_ZOOM = 1000.0f;
    protected PdColor m_foregroundColor;
    protected PdColor m_backgroundColor;
    protected boolean m_bShowBackface;
    protected boolean m_bShowBackImage;
    protected boolean m_bShowDepthcue;
    protected boolean m_bShowEdgesOnce;
    protected boolean m_bShowEdgeAura;
    protected boolean m_bShowGrid;
    protected boolean m_bEnableSorting;
    protected transient Thread m_thread;
    protected boolean m_bEnableAnimation;
    protected boolean m_bDrawing;
    private int xUp;
    private int yUp;
    private int xDown;
    private int yDown;
    private boolean bDrag;
    protected PuInteger m_sleep;
    protected boolean m_bFpsEnabled;
    private long m_period;
    private int m_pCount;
    protected transient PopupMenu m_popup;
    protected transient MenuItem[] m_menuItem;
    private int m_prevKey;

    public boolean isShowingBackImage() {
        return this.m_bShowBackImage;
    }

    public void showBackImage(boolean bl) {
        this.m_bShowBackImage = bl;
    }

    public Image getBackgroundImage() {
        return this.m_backImage;
    }

    public boolean isClip() {
        return this.m_currentCamera.m_bEnableClip;
    }

    public void setBackgroundImage(Image image) {
        if (image == null) {
            this.m_backImage = null;
            this.showBackImage(false);
            return;
        }
        this.m_backImage = image;
        this.showBackImage(true);
        Dimension dimension = this.getSize();
        if (dimension.width != 0 && dimension.height != 0 && (this.m_backImage.getWidth(null) < dimension.width || this.m_backImage.getHeight(null) < dimension.height || this.m_backImage.getWidth(null) > dimension.width && this.m_backImage.getHeight(null) > dimension.height)) {
            this.scaleBackgroundImage(dimension.width, dimension.height);
        }
        this.m_backgroundImage = null;
    }

    public void fit() {
        if (this.m_scene == null) {
            return;
        }
        if (this.m_nHeight <= 0) {
            return;
        }
        PdVector[] pdVectorArray = this.m_scene.getBounds();
        if (pdVectorArray == null) {
            return;
        }
        this.m_currentCamera.fit(PdVector.dist(pdVectorArray[0], pdVectorArray[1]));
        PdVector pdVector = new PdVector(3);
        pdVector.blend(0.5, pdVectorArray[0], 0.5, pdVectorArray[1]);
        this.m_currentCamera.setInterest(pdVector);
        if (this.m_bTransformModel) {
            this.m_modelCamera.setCurrentView(this.m_currentCamera.m_view, this.m_currentCamera.m_viewInv);
        }
        this.updateCameraListener(101);
    }

    public boolean isShowingDepthcue() {
        if (this.m_currentCamera.getProjectionMode() == 0) {
            return this.m_bShowDepthcue;
        }
        return false;
    }

    public void showDepthcue(boolean bl) {
        this.m_bShowDepthcue = bl;
    }

    public void setBackgroundImage(String string) {
        Image image = !PsConfig.isApplication() ? PsConfig.getApplet().getImage(PsConfig.getApplet().getCodeBase(), string) : Toolkit.getDefaultToolkit().getImage(string);
        this.setBackgroundImage(image);
    }

    private void drawPickBox(Graphics graphics) {
        if (this.m_markBox == null || this.m_markBox.getSize() < 4) {
            PsDebug.warning("missing mark box.");
            return;
        }
        if (this.m_markBox.getSize() < 4) {
            PsDebug.warning("mark box too small, size = " + this.m_markBox.getSize());
            return;
        }
        int[] nArray = this.m_markBox.m_data;
        graphics.drawLine(nArray[0], nArray[1], nArray[2], nArray[1]);
        graphics.drawLine(nArray[2], nArray[1], nArray[2], nArray[3]);
        graphics.drawLine(nArray[2], nArray[3], nArray[0], nArray[3]);
        graphics.drawLine(nArray[0], nArray[3], nArray[0], nArray[1]);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.m_currLoc.width = n;
        this.m_currLoc.height = this.m_nHeight - 1 - n2;
        if (Math.abs(this.xUp - this.xDown) <= 2 || Math.abs(this.yUp - this.yDown) <= 2) {
            this.bDrag = false;
        }
        this.xUp = n;
        this.yUp = n2;
        this.m_bMouseDown = false;
        if (this.m_mode == 6) {
            this.bDrag = false;
            return;
        }
        if (this.m_mode == 8) {
            this.bDrag = false;
            return;
        }
        if (this.m_mode == 5) {
            this.m_currentGeom.releaseVertex(this.m_pickedVertex);
            if (this.m_geomIf != null) {
                this.m_geomIf.update(this.m_geomIf);
            }
            this.bDrag = false;
            return;
        }
        if (this.m_mode == 13) {
            PvPickEvent pvPickEvent = this.getPickEvent(n, n2);
            if (pvPickEvent == null) {
                return;
            }
            PgGeometryIf pgGeometryIf = pvPickEvent.getGeometry();
            if (pgGeometryIf == null) {
                return;
            }
            this.removeGeometry(pgGeometryIf);
            this.update(this);
            return;
        }
        if (this.m_mode == 9) {
            this.m_markBox.m_data[2] = n;
            this.m_markBox.m_data[3] = n2;
            if (this.m_currentGeom != null) {
                if (this.m_markBox.m_data[0] == this.m_markBox.m_data[2] && this.m_markBox.m_data[1] == this.m_markBox.m_data[3]) {
                    this.m_currentGeom.pickVertex(n, n2);
                } else {
                    this.m_currentGeom.tagVertices(Math.min(this.m_markBox.m_data[0], n), Math.min(this.m_markBox.m_data[1], n2), Math.abs(n - this.m_markBox.m_data[0]), Math.abs(n2 - this.m_markBox.m_data[1]));
                }
            }
            if (this.m_geomIf != null) {
                this.m_geomIf.update(this.m_geomIf);
            }
            this.bDrag = false;
            this.repaint();
            PvPickEvent pvPickEvent = new PvPickEvent(3);
            pvPickEvent.setGeometry(this.m_geomIf);
            pvPickEvent.setMarkBox(this.m_markBox);
            pvPickEvent.setMarkBoxWorld(this.markBox2World(this.m_markBox));
            if (this.m_pickFocus != null) {
                this.m_pickFocus.markVertices(pvPickEvent);
            } else if (this.m_pickListener != null) {
                Enumeration enumeration = this.m_pickListener.elements();
                while (enumeration.hasMoreElements()) {
                    ((PvPickListenerIf)enumeration.nextElement()).markVertices(pvPickEvent);
                }
            }
            this.m_markBox.setConstant(0);
            return;
        }
        if (this.m_mode == 10) {
            this.m_markBox.m_data[2] = n;
            this.m_markBox.m_data[3] = n2;
            this.bDrag = false;
            return;
        }
        if (this.m_mode == 2) {
            this.m_markBox.m_data[2] = n;
            this.m_markBox.m_data[3] = n2;
            this.bDrag = false;
            PdVector[] pdVectorArray = this.markBox2World(this.m_markBox);
            PdVector pdVector = PdVector.blendNew(0.5, pdVectorArray[0], 0.5, pdVectorArray[2]);
            this.m_currentCamera.setInterest(pdVector);
            double d = PdVector.dist(pdVectorArray[0], pdVectorArray[2]);
            if (d > 0.1) {
                this.m_currentCamera.fit(d);
            }
            if (this.m_bTransformModel) {
                this.m_modelCamera.setCurrentView(this.m_currentCamera.m_view, this.m_currentCamera.m_viewInv);
            }
            this.updateCameraListener(103);
            this.repaint();
            this.m_markBox.setConstant(0);
            return;
        }
        if (this.m_mode == 11) {
            this.m_markBox.m_data[2] = n;
            this.m_markBox.m_data[3] = n2;
            if (this.m_currentGeom != null) {
                if (this.m_markBox.m_data[0] == this.m_markBox.m_data[2] && this.m_markBox.m_data[1] == this.m_markBox.m_data[3]) {
                    int n3 = this.m_currentGeom.pickVertex(n, n2);
                    if (n3 != -1) {
                        this.m_currentGeom.releaseVertex(n3);
                    }
                } else {
                    this.m_currentGeom.untagVertices(Math.min(this.m_markBox.m_data[0], n), Math.min(this.m_markBox.m_data[1], n2), Math.abs(n - this.m_markBox.m_data[0]), Math.abs(n2 - this.m_markBox.m_data[1]));
                }
            }
            if (this.m_geomIf != null) {
                this.m_geomIf.update(this.m_geomIf);
            }
            this.bDrag = false;
            this.repaint();
            PvPickEvent pvPickEvent = new PvPickEvent(3);
            pvPickEvent.setGeometry(this.m_geomIf);
            pvPickEvent.setMarkBox(this.m_markBox);
            pvPickEvent.setMarkBoxWorld(this.markBox2World(this.m_markBox));
            if (this.m_pickFocus != null) {
                this.m_pickFocus.unmarkVertices(pvPickEvent);
            } else if (this.m_pickListener != null) {
                Enumeration enumeration = this.m_pickListener.elements();
                while (enumeration.hasMoreElements()) {
                    ((PvPickListenerIf)enumeration.nextElement()).unmarkVertices(pvPickEvent);
                }
            }
            this.m_markBox.setConstant(0);
        }
    }

    public void setSizeWithinFrame(int n, int n2) {
        if (n2 < 0 || n < 0) {
            PsDebug.warning("value <= 0");
            return;
        }
        Frame frame = this.hasParentFrame();
        if (frame == null) {
            return;
        }
        Dimension dimension = frame.getSize();
        int n3 = dimension.width - this.m_nWidth;
        int n4 = dimension.height - this.m_nHeight;
        ((Component)frame).setSize(n3 + n, n4 + n2);
        this.resizeImage();
        frame.validate();
    }

    public Color getBackgroundColor() {
        return this.m_backgroundColor.getColor();
    }

    public void setBackgroundColor(Color color) {
        this.m_backgroundColor.setColor(color);
        super.setBackground(this.m_backgroundColor.getColor());
    }

    public boolean hasPaintTag(int n) {
        return (this.m_sceneFlags & n) != 0;
    }

    protected void paintGeom(Graphics graphics) {
        ++this.m_pCount;
        if (!this.hasPaintTag(1)) {
            return;
        }
        if (this.m_bShowBackImage && this.m_backImage != null) {
            graphics.drawImage(this.m_backImage, 0, 0, this);
        } else if (this.hasPaintTag(2)) {
            graphics.setColor(this.m_backgroundColor.getColor());
            graphics.fillRect(0, 0, this.m_nWidth, this.m_nHeight);
            graphics.setColor(this.m_foregroundColor.getColor());
        }
        PvScene pvScene = this.m_scene;
        synchronized (pvScene) {
            block11: {
                if (this.m_scene == null || this.m_currentGeom == null) break block11;
                this.m_scene.paint(graphics, this);
            }
            Object var3_3 = null;
        }
        if (this.hasPaintTag(4)) {
            PsPanel.drawBorder(this, graphics, 2);
        }
        if (this.hasPaintTag(256) && !this.hasPaintTag(8)) {
            this.drawInfo(graphics);
        }
        if (this.hasPaintTag(16)) {
            this.drawCross(graphics);
        }
        if ((this.m_mode == 9 || this.m_mode == 11 || this.m_mode == 2) && this.m_bMouseDown) {
            this.drawPickBox(graphics);
        }
    }

    public boolean isShowingAxes() {
        return this.hasPaintTag(1024);
    }

    public void showAxes(boolean bl) {
        if (bl) {
            PjAxes pjAxes = null;
            if (!this.m_specialGeom.containsKey(GEOM_AXES)) {
                pjAxes = new PjAxes(3);
                pjAxes.setScene(this.m_scene);
                this.addCameraListener(pjAxes);
                PgAxes pgAxes = pjAxes.getAxes();
                pgAxes.showAxesTitles(true, true, true);
                pgAxes.setName(PsConfig.getMessage("Axes"));
                PgGeometry[] pgGeometryArray = pgAxes.getAxes();
                int n = 0;
                while (n < pgGeometryArray.length) {
                    this.addGeometry(pgGeometryArray[n], 1);
                    this.m_specialGeom.put(GEOM_AXES + "_" + String.valueOf(n), pgGeometryArray[n]);
                    ++n;
                }
                this.addGeometry(pgAxes, 1);
                this.m_specialGeom.put(GEOM_AXES, pgAxes);
            } else {
                pjAxes = (PjAxes)this.m_specialGeom.get(GEOM_AXES);
            }
            pjAxes.update(this.m_scene);
            this.updateCameraListener(101);
        } else if (this.m_specialGeom.containsKey(GEOM_AXES)) {
            int n = 0;
            do {
                String string = GEOM_AXES + "_" + String.valueOf(n);
                this.removeGeometry((PgGeometryIf)this.m_specialGeom.get(string));
                this.m_specialGeom.remove(string);
            } while (++n < 3);
            this.removeGeometry((PgGeometryIf)this.m_specialGeom.get(GEOM_AXES));
            this.m_specialGeom.remove(GEOM_AXES);
        }
        this.setPaintTag(1024, bl);
        this.update(this);
    }

    public int getAmbientSpace() {
        if (this.m_currentGeom != null) {
            return this.m_currentGeom.getAmbientSpace();
        }
        return this.m_ambientSpace;
    }

    public void setAmbientSpace(int n) {
        if (this.m_currentGeom != null) {
            this.m_currentGeom.setAmbientSpace(n);
        }
        this.m_ambientSpace = n;
    }

    public PgGeometryIf[] getGeometries() {
        PvGeometry[] pvGeometryArray = this.getGeometryContainers();
        if (pvGeometryArray == null) {
            return null;
        }
        PgGeometryIf[] pgGeometryIfArray = new PgGeometryIf[pvGeometryArray.length];
        int n = 0;
        while (n < pvGeometryArray.length) {
            pgGeometryIfArray[n] = pvGeometryArray[n].getGeometry();
            ++n;
        }
        return pgGeometryIfArray;
    }

    public Frame getFrame() {
        return this.m_frame;
    }

    public void setFrame(Frame frame) {
        this.m_frame = frame;
    }

    public boolean isShowingFrame() {
        return this.hasPaintTag(512);
    }

    public void showFrame(boolean bl) {
        if (bl) {
            if (!this.m_specialGeom.containsKey(GEOM_FRAME)) {
                PgJvxSrc pgJvxSrc = new PgJvxSrc(3);
                pgJvxSrc.setName(PsConfig.getMessage("CoordinateFrame"));
                pgJvxSrc.showVertices(true);
                pgJvxSrc.showPolygons(true);
                pgJvxSrc.showPolygonEndArrow(true);
                pgJvxSrc.setDefaultLabelEnabled(false);
                pgJvxSrc.showIndices(true);
                pgJvxSrc.setGlobalPolygonSize(1.0);
                pgJvxSrc.setGlobalPolygonColor(Color.black);
                pgJvxSrc.setDimOfVertices(3);
                pgJvxSrc.setNumVertices(4);
                pgJvxSrc.setVertex(0, new PdVector(0.0, 0.0, 0.0));
                pgJvxSrc.setVertex(1, new PdVector(1.0, 0.0, 0.0));
                pgJvxSrc.setVertex(2, new PdVector(0.0, 1.0, 0.0));
                pgJvxSrc.setVertex(3, new PdVector(0.0, 0.0, 1.0));
                pgJvxSrc.getVertex(1).setName("X");
                pgJvxSrc.getVertex(2).setName("Y");
                pgJvxSrc.getVertex(3).setName("Z");
                pgJvxSrc.setDimOfPolygons(2);
                pgJvxSrc.setNumPolygons(3);
                pgJvxSrc.getPolygon(0).set(0, 1);
                pgJvxSrc.getPolygon(1).set(0, 2);
                pgJvxSrc.getPolygon(2).set(0, 3);
                this.addGeometry(pgJvxSrc, 1);
                this.m_specialGeom.put(GEOM_FRAME, pgJvxSrc);
                PvGeometry pvGeometry = this.m_scene.getGeometry(pgJvxSrc);
                pvGeometry.setPosition(100, 100);
            }
        } else if (this.m_specialGeom.containsKey(GEOM_FRAME)) {
            this.removeGeometry((PgGeometryIf)this.m_specialGeom.get(GEOM_FRAME));
            this.m_specialGeom.remove(GEOM_FRAME);
        }
        this.setPaintTag(512, bl);
        this.update(this);
    }

    public void addPickListener(PvPickListenerIf pvPickListenerIf) {
        if (this.m_pickListener == null) {
            this.m_pickListener = new Vector();
        } else if (this.hasPickListener(pvPickListenerIf)) {
            PsDebug.warning("listener = " + pvPickListenerIf.getName() + " of listener already used.");
            return;
        }
        this.m_pickListener.addElement(pvPickListenerIf);
    }

    public void init() {
        this.stop();
        this.m_bTransformModel = false;
        this.m_modelCamera = null;
        this.m_pickedVertex = -1;
        this.m_pick.set(0.0, 0.0, 0.0, 1.0);
        this.setForegroundColor(Color.black);
        if (!PsConfig.isApplication() && PsConfig.getApplet() != null && PsConfig.getApplet().getBackground() != null) {
            this.setBackgroundColor(PsConfig.getApplet().getBackground());
        } else {
            this.setBackgroundColor(Color.lightGray);
        }
        this.selectCamera(0);
        this.m_sceneFlags = 0;
        this.setPaintTag(7, true);
        this.setEnabledAnimation(false);
        this.showBackImage(false);
        this.showBndBox(false);
        this.showDepthcue(true);
        this.showEdgeAura(false);
        this.showEdgesOnce(true);
        this.showFrame(false);
        this.showAxes(false);
        this.setEnabledPainters(true);
        this.enableClip(false);
        this.m_sleep.setDefBounds(0, 100, 1, 5);
        this.m_sleep.setDefValue(40);
        this.m_sleep.setEnabled(false);
        this.m_sleep.init();
        this.m_height.setDefBounds(0, 1024, 1, 10);
        this.m_height.setDefValue(PvDisplay.m_defSize.height);
        this.m_height.init();
        this.m_width.setDefBounds(0, 1280, 1, 10);
        this.m_width.setDefValue(PvDisplay.m_defSize.width);
        this.m_width.init();
        this.setCurrentMajorMode(this.m_defModeMajor);
        if (this.m_currentGeom != null) {
            this.m_currentCamera.init();
            this.fit();
            this.repaint();
        }
    }

    public boolean removeGeometry(PgGeometryIf pgGeometryIf) {
        if (pgGeometryIf == null) {
            return true;
        }
        if (!this.containsGeometry(pgGeometryIf)) {
            if (pgGeometryIf != null) {
                PsDebug.warning("geometry=" + pgGeometryIf.getName() + " not registered in listener");
            }
            return false;
        }
        pgGeometryIf.removeDisplay(this);
        PvGeometry pvGeometry = this.m_scene.getGeometry(pgGeometryIf);
        PvGeometry pvGeometry2 = this.m_scene.removeGeometry(pvGeometry);
        if (this.m_currentGeom != pvGeometry2) {
            if (pvGeometry2 != null && pvGeometry2.getGeometry() != null) {
                this.selectGeometry(pvGeometry2.getGeometry());
            } else {
                this.selectGeometry(null);
            }
        }
        return true;
    }

    public PgGeometryIf getSelectedGeometry() {
        if (this.m_currentGeom == null) {
            return null;
        }
        return this.m_currentGeom.getGeometry();
    }

    public PsPanel getCameraPanel() {
        if (!(this.m_cameraPanel != null && this.m_cameraPanel.getLanguage().equals(PsConfig.getLanguage()) || this.m_currentCamera == null)) {
            this.m_cameraPanel = this.m_currentCamera.getInfoPanel();
        }
        return this.m_cameraPanel;
    }

    public void run() {
        double d = 0.0;
        double d2 = 0.0;
        if (this.m_bFpsEnabled) {
            this.m_pCount = 0;
            d = new Date().getTime();
        }
        while (this.m_thread != null) {
            double d3;
            if (!this.m_bDrawing) {
                if (!this.m_bTransformModel) {
                    this.m_currentCamera.mouseAnimate();
                } else {
                    this.m_modelCamera.mouseAnimate();
                }
                this.updateCameraListener(101);
                this.repaint();
            }
            if (this.m_thread == null) {
                return;
            }
            try {
                Thread.sleep(this.m_sleep.getValue());
            }
            catch (InterruptedException interruptedException) {}
            if (!this.m_bFpsEnabled || !((d3 = (double)new Date().getTime()) - d > (double)(this.m_period * 1000L))) continue;
            d2 = (d2 + (double)this.m_pCount / ((d3 - d) / 1000.0)) / 2.0;
            if (this.m_infoPanel != null && this.m_infoPanel.isShowing()) {
                ((PvDisplay_IP)this.m_infoPanel).m_lFps.setText(String.valueOf((double)((int)(d2 * 100.0)) / 100.0));
            }
            d = d3;
            this.m_pCount = 0;
        }
    }

    protected void enableTransformModel(boolean bl) {
        this.m_bTransformModel = bl;
        if (bl) {
            if (this.m_modelCamera == null) {
                this.m_modelCamera = new PvModelCamera(this);
            }
            this.m_modelCamera.resizeImage(this.m_nWidth, this.m_nHeight);
            this.m_modelCamera.setModelMatrix(this.m_currentGeom.getModelMatrix());
            this.m_modelCamera.setCurrentView(this.m_currentCamera.m_view, this.m_currentCamera.m_viewInv);
            return;
        }
        this.m_modelCamera = null;
    }

    public void resetTransformModel() {
        PdMatrix pdMatrix = new PdMatrix(4);
        pdMatrix.setIdentity();
        if (this.m_modelCamera != null) {
            this.m_modelCamera.setModelMatrix(pdMatrix);
            this.m_modelCamera.setCurrentView(this.m_currentCamera.m_view, this.m_currentCamera.m_viewInv);
        }
        if (this.m_currentGeom.hasModelMatrix()) {
            this.m_currentGeom.setModelMatrix(pdMatrix);
        }
    }

    private void drawCross(Graphics graphics) {
        int n = 2;
        int n2 = this.m_currLoc.width;
        int n3 = this.m_nHeight - 1 - this.m_currLoc.height;
        graphics.drawLine(n2 - n, n3, n2 + n, n3);
        graphics.drawLine(n2, n3 - n, n2, n3 + n);
    }

    public void stop() {
        if (this.m_thread != null) {
            this.m_thread = null;
        }
        if (this.m_bFpsEnabled) {
            this.m_bFpsEnabled = false;
            if (this.m_infoPanel != null && this.m_infoPanel.isShowing()) {
                ((PvDisplay_IP)this.m_infoPanel).m_cFps.setState(this.m_bFpsEnabled);
                ((PvDisplay_IP)this.m_infoPanel).m_lFps.setText(PsConfig.getMessage("lFps"));
                this.m_sleep.setEnabled(false);
            }
        }
    }

    public boolean isEnabledPainters() {
        return this.m_bEnableSorting;
    }

    public PsUpdateIf getFather() {
        return this.m_parent;
    }

    protected int getCurrentCameraType() {
        if (this.m_currentCamera == null) {
            PsDebug.warning("current camera missing.");
            return 0;
        }
        return this.m_currentCamera.getProjectionMode();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.m_bMouseInside = true;
        this.requestFocus();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_menuItem[0]) {
            this.setCurrentMajorMode(0);
            return;
        }
        if (object == this.m_menuItem[1]) {
            this.setCurrentMajorMode(1);
            return;
        }
        if (object == this.m_menuItem[2]) {
            this.setCurrentMajorMode(3);
            return;
        }
        if (object == this.m_menuItem[3]) {
            this.setCurrentMajorMode(6);
            return;
        }
        if (object == this.m_menuItem[4]) {
            if (this.m_viewer != null) {
                this.m_viewer.newDisplay();
                return;
            }
            PvDisplay pvDisplay = new PvDisplay(this.m_applet, this.m_frame);
            PsMainFrame psMainFrame = new PsMainFrame(pvDisplay, "JavaView", null);
            pvDisplay.setFrame(psMainFrame);
            PgGeometryIf[] pgGeometryIfArray = this.getGeometries();
            if (pgGeometryIfArray != null) {
                int n = 0;
                while (n < pgGeometryIfArray.length) {
                    pvDisplay.addGeometry(pgGeometryIfArray[n]);
                    ++n;
                }
                PgGeometryIf pgGeometryIf = this.getSelectedGeometry();
                if (pgGeometryIf != null && pvDisplay.containsGeometry(pgGeometryIf)) {
                    pvDisplay.selectGeometry(pgGeometryIf);
                }
            }
            pvDisplay.selectCamera(this.getCurrentCameraType());
            pvDisplay.showGrid(this.isShowingGrid());
            pvDisplay.showBndBox(this.isShowingBndBox());
            pvDisplay.showFrame(this.isShowingFrame());
            pvDisplay.showAxes(this.isShowingAxes());
            psMainFrame.setBounds(new Rectangle(50, 50, 400, 300));
            ((Component)psMainFrame).setVisible(true);
            return;
        }
        if (object == this.m_menuItem[5]) {
            if (this.m_viewer != null) {
                this.m_viewer.showDialog(46);
                return;
            }
        } else if (object == this.m_menuItem[6]) {
            if (this.m_viewer != null) {
                this.m_viewer.showDialog(25);
                return;
            }
        } else if (object == this.m_menuItem[7]) {
            if (this.m_viewer != null) {
                this.m_viewer.showDialog(24);
                return;
            }
        } else if (object == this.m_menuItem[8]) {
            if (this.m_viewer != null) {
                this.m_viewer.showDialog(26);
                return;
            }
            Applet applet = PsConfig.getApplet();
            if (!PsConfig.isApplication() && applet != null) {
                URL uRL;
                boolean bl = false;
                try {
                    uRL = new URL(PsConfig.getCodeBase() + "jars/help.html");
                    uRL.openConnection();
                    uRL.openStream();
                    applet.getAppletContext().showDocument(uRL, "Help on Viewer");
                    bl = true;
                }
                catch (MalformedURLException malformedURLException) {
                    PsDebug.warning("MalformedURLException when accessing viewer help");
                }
                catch (IOException iOException) {
                    PsDebug.warning("IOException, could not open connection");
                }
                catch (Exception exception) {
                    PsDebug.warning("file not found = " + "jars/help.html");
                }
                if (!bl) {
                    try {
                        uRL = new URL(PsConfig.getCodeBase() + "help.html");
                        uRL.openConnection();
                        uRL.openStream();
                        applet.getAppletContext().showDocument(uRL, "Help on Viewer");
                        return;
                    }
                    catch (MalformedURLException malformedURLException) {
                        PsDebug.warning("MalformedURLException when accessing viewer help");
                        return;
                    }
                    catch (IOException iOException) {
                        PsDebug.warning("IOException, could not open connection");
                        return;
                    }
                    catch (Exception exception) {
                        PsDebug.warning("file not found = " + "jars/help.html");
                        return;
                    }
                }
            }
        } else {
            if (object == this.m_menuItem[9]) {
                PsAboutDialog psAboutDialog = new PsAboutDialog(PsConfig.getFrame());
                int[] nArray = new int[]{10, 10, 400, 450};
                ((Component)psAboutDialog).setLocation(nArray[0], nArray[1]);
                ((Component)psAboutDialog).setSize(nArray[2], nArray[3]);
                psAboutDialog.validate();
                psAboutDialog.setModal(true);
                ((Component)psAboutDialog).setVisible(true);
                return;
            }
            if (object == this.m_menuItem[10]) {
                if (this.m_viewer != null) {
                    this.m_viewer.removeDisplay(this.getName());
                    return;
                }
                Frame frame = this.hasParentFrame();
                if (frame != null) {
                    frame.dispose();
                    return;
                }
            } else if (object == this.m_menuItem[11]) {
                if (this.m_viewer != null) {
                    this.m_viewer.destroy();
                    return;
                }
                System.exit(0);
            }
        }
    }

    public void start() {
        if (this.m_thread == null) {
            this.m_thread = new Thread((Runnable)this, "JavaView: Auto-Rotation");
            this.m_thread.setPriority(5);
            this.m_thread.start();
        }
    }

    private PdVector[] markBox2World(PiVector piVector) {
        PdVector[] pdVectorArray = PdVector.realloc(null, 5, 4);
        pdVectorArray[0].set(Math.min(piVector.m_data[0], piVector.m_data[2]), Math.min(piVector.m_data[1], piVector.m_data[3]), 0.0, 1.0);
        pdVectorArray[1].set(Math.max(piVector.m_data[0], piVector.m_data[2]), Math.min(piVector.m_data[1], piVector.m_data[3]), 0.0, 1.0);
        pdVectorArray[2].set(Math.max(piVector.m_data[0], piVector.m_data[2]), Math.max(piVector.m_data[1], piVector.m_data[3]), 0.0, 1.0);
        pdVectorArray[3].set(Math.min(piVector.m_data[0], piVector.m_data[2]), Math.max(piVector.m_data[1], piVector.m_data[3]), 0.0, 1.0);
        pdVectorArray[4].set(0.0, 0.0, -1000.0, 0.0);
        int n = 0;
        while (n < pdVectorArray.length) {
            pdVectorArray[n].leftMultMatrix(this.m_currentCamera.m_transInv);
            pdVectorArray[n].setSize(3);
            ++n;
        }
        return pdVectorArray;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String string) {
        this.m_name = string;
    }

    public Image getImage() {
        return this.m_image;
    }

    private boolean resizeImage() {
        Dimension dimension = this.getSize();
        if (dimension.width == 0 || dimension.height == 0) {
            return false;
        }
        if (this.m_image != null && dimension.width == this.m_nWidth && dimension.height == this.m_nHeight) {
            return true;
        }
        if (this.m_nHeight == -1) {
            m_defSize = dimension;
        }
        this.m_nHeight = dimension.height;
        this.m_height.setValue(dimension.height);
        this.m_nWidth = dimension.width;
        this.m_width.setValue(dimension.width);
        boolean bl = this.hasParentFrame() != null;
        this.m_height.setEnabled(bl);
        this.m_width.setEnabled(bl);
        this.m_currentCamera.resizeImage(this.m_nWidth, this.m_nHeight);
        if (this.m_bTransformModel) {
            this.m_modelCamera.resizeImage(this.m_nWidth, this.m_nHeight);
        }
        this.m_image = this.createImage(this.m_nWidth, this.m_nHeight);
        if (this.m_image == null) {
            return false;
        }
        this.m_g = this.m_image.getGraphics();
        if (this.m_bShowBackImage && this.m_backImage != null) {
            if (this.m_backImage.getWidth(null) < dimension.width || this.m_backImage.getHeight(null) < dimension.height || this.m_backImage.getWidth(null) > dimension.width && this.m_backImage.getHeight(null) > dimension.height) {
                this.scaleBackgroundImage(dimension.width, dimension.height);
            }
            this.m_g.drawImage(this.m_backImage, 0, 0, this);
        }
        if (this.m_currentGeom != null) {
            this.setFrameTitle(this.m_currentGeom.getGeometry());
            if (!this.m_bCentered) {
                this.m_bCentered = true;
                this.fit();
                this.center();
            }
        }
        this.m_bDrawing = true;
        this.paintGeom(this.m_g);
        this.m_bDrawing = false;
        return true;
    }

    public void enableClip(boolean bl) {
        this.m_currentCamera.m_bEnableClip = bl;
    }

    public double getNearClip() {
        return this.m_currentCamera.m_nearClip.getValue();
    }

    public void setNearClip(double d) {
        this.m_currentCamera.m_nearClip.setValue(d);
    }

    public void releasePickFocus() {
        this.m_pickFocus = null;
    }

    protected boolean isTransformModel() {
        return this.m_bTransformModel;
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        this.m_parent = psUpdateIf;
    }

    public PvDisplay() {
        this(null, null);
    }

    public Color getForegroundColor() {
        return this.m_foregroundColor.getColor();
    }

    public void setForegroundColor(Color color) {
        this.m_foregroundColor.setColor(color);
        super.setForeground(this.m_foregroundColor.getColor());
    }

    public void setPaintTag(int n, boolean bl) {
        if (bl) {
            this.m_sceneFlags |= n;
            if ((n & 8) != 0) {
                if (this.m_currentCamera != null) {
                    this.m_currentCamera.m_trans.multScalar(PS_ZOOM);
                }
                PvGeometry.PS_ZOOM = (int)PS_ZOOM;
                return;
            }
            if ((n & 1) != 0) {
                this.repaint();
                return;
            }
            if ((n & 0x800) != 0) {
                PvGeometry[] pvGeometryArray = this.getGeometryContainers();
                if (pvGeometryArray == null) {
                    return;
                }
                int n2 = 0;
                while (n2 < pvGeometryArray.length) {
                    if (pvGeometryArray[n2].isVisible()) {
                        PgGeometryIf pgGeometryIf = pvGeometryArray[n2].getGeometry();
                        if (pvGeometryArray[n2] != this.m_currentGeom && !this.m_specialGeom.contains(pgGeometryIf)) {
                            pvGeometryArray[n2].setVisible(false);
                            pgGeometryIf.setVisible(false);
                        }
                    }
                    ++n2;
                }
                return;
            }
        } else {
            if (this.hasPaintTag(8) && (n & 8) != 0) {
                if (this.m_currentCamera != null) {
                    this.m_currentCamera.m_trans.multScalar(1.0 / (double)PS_ZOOM);
                }
                PvGeometry.PS_ZOOM = 1;
            }
            this.m_sceneFlags &= ~n;
        }
    }

    public PvDisplay(PvViewerIf pvViewerIf) {
        this(pvViewerIf.getApplet(), pvViewerIf.getFrame());
        this.m_viewer = pvViewerIf;
    }

    public PvDisplay(Applet applet, Frame frame) {
        this.m_backgroundImage = this.m_defBackgroundImage = "images/DisplayBackgrd.gif";
        this.m_bMouseInside = false;
        this.m_bMouseDown = false;
        this.m_cameraPanel = null;
        this.m_infoPanel = null;
        this.m_mode = 0;
        this.m_modeMajor = 0;
        this.m_defModeMajor = 0;
        this.m_ambientSpace = 0;
        this.m_ambientProj = 0;
        this.m_pick = new PdVector(4);
        this.m_markBox = new PiVector(4);
        this.m_worldPick = new PdVector(4);
        this.m_currLoc = new Dimension();
        this.m_currNormLoc = new double[2];
        this.m_nHeight = -1;
        this.m_nWidth = -1;
        this.m_bShowGrid = false;
        this.m_bDrawing = false;
        this.bDrag = false;
        this.m_bFpsEnabled = false;
        this.m_period = 2L;
        this.m_prevKey = -1;
        this.m_frame = frame;
        this.m_applet = applet;
        this.m_specialGeom = new Hashtable(3);
        this.m_camera = new Hashtable(4);
        this.addCamera("Perspective", new PvCamera(this, 0));
        this.m_foregroundColor = new PdColor(PsConfig.getMessage("foregroundColor"), this);
        this.m_backgroundColor = new PdColor(PsConfig.getMessage("backgroundColor"), this);
        this.m_scene = new PvScene();
        this.m_scene.setParent(this);
        this.m_sleep = new PuInteger(PsConfig.getMessage("sleep"), this);
        this.m_height = new PuInteger(PsConfig.getMessage("height"), this);
        this.m_width = new PuInteger(PsConfig.getMessage("width"), this);
        this.enableEvents(48L);
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.init();
    }

    public boolean removeCamera(int n) {
        if (n < 0 || m_cameraName.length <= n) {
            return false;
        }
        return this.m_camera.remove(m_cameraName[n]) != null;
    }

    public void paint(Graphics graphics) {
        if (!this.hasPaintTag(1)) {
            return;
        }
        this.m_bDrawing = true;
        if (this.resizeImage() && this.m_image != null) {
            graphics.drawImage(this.m_image, 0, 0, this);
        }
        this.m_bDrawing = false;
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            if (this.m_popup == null) {
                this.m_popup = new PopupMenu(PsConfig.getMessage("pTitle"));
                this.m_menuItem = new MenuItem[20];
                this.m_menuItem[0] = new MenuItem(PsConfig.getMessage("pOrbit"));
                this.m_menuItem[1] = new MenuItem(PsConfig.getMessage("pScale"));
                this.m_menuItem[2] = new MenuItem(PsConfig.getMessage("pTranslate"));
                this.m_menuItem[3] = new MenuItem(PsConfig.getMessage("pPick"));
                this.m_menuItem[4] = new MenuItem(PsConfig.getMessage("pDisplay"));
                this.m_menuItem[5] = new MenuItem(PsConfig.getMessage("pEPS"));
                this.m_menuItem[6] = new MenuItem(PsConfig.getMessage("pConsole"));
                this.m_menuItem[7] = new MenuItem(PsConfig.getMessage("pControl"));
                this.m_menuItem[8] = new MenuItem(PsConfig.getMessage("pHelp"));
                this.m_menuItem[9] = new MenuItem(PsConfig.getMessage("pAbout"));
                this.m_menuItem[10] = new MenuItem(PsConfig.getMessage("pClose"));
                this.m_menuItem[11] = new MenuItem(PsConfig.getMessage("pExit"));
                int n = 0;
                while (n < this.m_menuItem.length) {
                    if (this.m_menuItem[n] != null) {
                        this.m_menuItem[n].addActionListener(this);
                    }
                    ++n;
                }
                this.m_popup.add(this.m_menuItem[0]);
                this.m_popup.add(this.m_menuItem[1]);
                this.m_popup.add(this.m_menuItem[2]);
                this.m_popup.add(this.m_menuItem[3]);
                this.m_popup.addSeparator();
                this.m_popup.add(this.m_menuItem[4]);
                if (this.m_viewer != null) {
                    this.m_popup.add(this.m_menuItem[5]);
                    this.m_popup.add(this.m_menuItem[6]);
                    this.m_popup.add(this.m_menuItem[7]);
                }
                this.m_popup.addSeparator();
                this.m_popup.add(this.m_menuItem[8]);
                this.m_popup.add(this.m_menuItem[9]);
                if (this.hasParentFrame() != null) {
                    this.m_popup.add(this.m_menuItem[10]);
                }
                if (PsConfig.isApplication()) {
                    this.m_popup.add(this.m_menuItem[11]);
                }
                this.add(this.m_popup);
            }
            this.m_popup.show(this, mouseEvent.getX(), mouseEvent.getY());
            this.m_popup = null;
        }
        super.processMouseEvent(mouseEvent);
    }

    public PvPickEvent getPickEvent(int n, int n2) {
        PdVector[] pdVectorArray = this.getWorldFromPixel(n, n2);
        PdVector pdVector = pdVectorArray[0];
        PdVector pdVector2 = pdVectorArray[1];
        PvPickEvent pvPickEvent = null;
        if (this.m_mode != 8) {
            if (this.m_geomIf != null && this.m_geomIf.isVisible() && (pvPickEvent = this.m_geomIf.intersectionWithLine(pdVector, pdVector2)) != null) {
                pvPickEvent.setGeometry(this.m_geomIf);
            }
            if (pvPickEvent == null) {
                PgGeometryIf[] pgGeometryIfArray = this.getGeometries();
                int n3 = 0;
                while (n3 < pgGeometryIfArray.length) {
                    if (pgGeometryIfArray[n3] != this.m_geomIf && pgGeometryIfArray[n3].isVisible() && (pvPickEvent = pgGeometryIfArray[n3].intersectionWithLine(pdVector, pdVector2)) != null) {
                        pvPickEvent.setGeometry(pgGeometryIfArray[n3]);
                        break;
                    }
                    ++n3;
                }
            }
        }
        if (pvPickEvent == null) {
            pvPickEvent = new PvPickEvent(3);
            pvPickEvent.setVertex(pdVector);
            pvPickEvent.setViewDir(pdVector2);
        }
        pvPickEvent.setLocation(new Point(n, n2));
        return pvPickEvent;
    }

    protected void setCurrentMajorMode(int n) {
        this.m_modeMajor = n;
        this.setMinorMode(n);
        if (this.m_currentCamera != null) {
            this.m_currentCamera.setMode(this.m_modeMajor);
        }
        if (this.m_bTransformModel) {
            this.m_modelCamera.setMode(this.m_modeMajor);
        }
        PsDebug.showStatus(m_majorModeMessage[this.m_modeMajor]);
    }

    private PdVector[] getWorldFromPixel(int n, int n2) {
        PdVector pdVector = new PdVector(n, n2, 0.0, 1.0);
        PdVector pdVector2 = new PdVector(0.0, 0.0, -1000.0, 0.0);
        pdVector.leftMultMatrix(this.m_currentCamera.m_transInv);
        pdVector2.leftMultMatrix(this.m_currentCamera.m_transInv);
        if (this.m_currentGeom != null && this.m_currentGeom.hasModelMatrix()) {
            PdMatrix pdMatrix = new PdMatrix(4);
            pdMatrix.invert34(this.m_currentGeom.getModelMatrix());
            pdVector.leftMultMatrix(pdMatrix);
            pdVector2.leftMultMatrix(pdMatrix);
        }
        pdVector.setSize(3);
        pdVector2.setSize(3);
        pdVector2.normalize();
        return new PdVector[]{pdVector, pdVector2};
    }

    protected PvGeometry[] getAllGeometryContainers() {
        return this.m_scene.getGeometries();
    }

    private void drawInfo(Graphics graphics) {
        int n = this.m_currLoc.width;
        int n2 = this.m_nHeight - 1 - this.m_currLoc.height;
        String string = "";
        PvPickEvent pvPickEvent = this.getPickEvent(n, n2);
        PgGeometryIf pgGeometryIf = pvPickEvent.getGeometry();
        PdVector pdVector = pvPickEvent.getVertex();
        string = string + "\n(" + (float)pdVector.getEntry(0) + "\n " + (float)pdVector.getEntry(1) + "\n " + (float)pdVector.getEntry(2) + ")";
        if (pgGeometryIf != null) {
            string = string + "\ngeom    = " + pgGeometryIf.getName();
            if (pvPickEvent.getElementInd() != -1) {
                string = string + "\nelement = " + pvPickEvent.getElementInd();
            }
            if (pvPickEvent.getVertexInd() != -1) {
                string = string + "\nClose to Vertex = " + pvPickEvent.getVertexInd();
            }
        }
        String[] stringArray = PuString.splitString(string, '\n');
        graphics.setFont(PsConfig.getFont(1));
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = fontMetrics.getHeight();
        int n4 = 20 * fontMetrics.charWidth('0');
        int n5 = 0;
        while (n5 < stringArray.length) {
            n4 = Math.max(n4, fontMetrics.stringWidth(stringArray[n5]));
            ++n5;
        }
        n5 = 7;
        int n6 = 7;
        int n7 = 3;
        int n8 = Math.min(n, this.m_nWidth - n4 - 2 * n7 - n5 - 5);
        int n9 = Math.min(n2, this.m_nHeight - stringArray.length * n3 - 2 * n7 - n6 - 5);
        graphics.setColor(Color.white);
        graphics.fillRect(n8 + n5, n9 + n6, n4 + 2 * n7, stringArray.length * n3 + 2 * n7);
        graphics.setColor(Color.black);
        int n10 = 0;
        while (n10 < stringArray.length) {
            graphics.drawString(stringArray[n10], n8 + n5 + n7, n9 + n6 + n7 + (n10 + 1) * n3);
            ++n10;
        }
    }

    protected void normalizedCoordsFromViewport(double[] dArray, Dimension dimension) {
        double d = Math.min(this.m_nWidth, this.m_nHeight);
        dArray[0] = 2.0 / (d - 1.0) * (double)dimension.width - ((double)this.m_nWidth - 1.0) / d;
        dArray[1] = 2.0 / (d - 1.0) * (double)dimension.height - ((double)this.m_nHeight - 1.0) / d;
    }

    public boolean isShowingEdgesOnce() {
        return this.m_bShowEdgesOnce;
    }

    protected Frame hasParentFrame() {
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof PsMainFrame) {
                return (Frame)container;
            }
            if (container instanceof Frame) {
                return null;
            }
            container = container.getParent();
        }
        return (Frame)container;
    }

    public void addCameraListener(PvCameraListenerIf pvCameraListenerIf) {
        if (this.m_cameraListener == null) {
            this.m_cameraListener = new Vector();
        } else if (this.hasCameraListener(pvCameraListenerIf)) {
            PsDebug.warning("listener = " + pvCameraListenerIf.getName() + " of listener already used.");
            return;
        }
        this.m_cameraListener.addElement(pvCameraListenerIf);
    }

    protected void updateCameraListener(int n) {
        if (this.m_currentCamera == null) {
            return;
        }
        if (this.m_cameraListener != null) {
            PvCameraEvent pvCameraEvent = new PvCameraEvent(this, 3);
            pvCameraEvent.setCamera(this.m_currentCamera);
            pvCameraEvent.setLocation(new Point(this.m_currLoc.width, this.m_nHeight - 1 - this.m_currLoc.height));
            PdVector[] pdVectorArray = this.getWorldFromPixel(this.m_currLoc.width, this.m_nHeight - 1 - this.m_currLoc.height);
            pvCameraEvent.setVertex(pdVectorArray[0]);
            Enumeration enumeration = this.m_cameraListener.elements();
            while (enumeration.hasMoreElements()) {
                if (n == 101) {
                    ((PvCameraListenerIf)enumeration.nextElement()).pickCamera(pvCameraEvent);
                    continue;
                }
                if (n == 102) {
                    ((PvCameraListenerIf)enumeration.nextElement()).dragCamera(pvCameraEvent);
                    continue;
                }
                if (n != 103) continue;
            }
        }
    }

    protected PgGeometryIf[] getAllGeometries() {
        PvGeometry[] pvGeometryArray = this.getAllGeometryContainers();
        if (pvGeometryArray == null) {
            return null;
        }
        PgGeometryIf[] pgGeometryIfArray = new PgGeometryIf[pvGeometryArray.length];
        int n = 0;
        while (n < pvGeometryArray.length) {
            pgGeometryIfArray[n] = pvGeometryArray[n].getGeometry();
            ++n;
        }
        return pgGeometryIfArray;
    }

    public void showEdgesOnce(boolean bl) {
        this.m_bShowEdgesOnce = bl;
    }

    public boolean isShowingBndBox() {
        return this.hasPaintTag(128);
    }

    public void showBndBox(boolean bl) {
        if (bl) {
            if (!this.m_specialGeom.containsKey(GEOM_BNDBOX)) {
                PgJvxSrc pgJvxSrc = new PgJvxSrc(3);
                pgJvxSrc.setName(PsConfig.getMessage("BoundingBox"));
                pgJvxSrc.showElements(false);
                pgJvxSrc.showBackface(false);
                pgJvxSrc.setGlobalEdgeSize(1.0);
                pgJvxSrc.setGlobalEdgeColor(Color.blue);
                pgJvxSrc.setDimOfVertices(3);
                pgJvxSrc.setNumVertices(8);
                pgJvxSrc.setDimOfElements(3);
                pgJvxSrc.setNumElements(6);
                pgJvxSrc.getElement(0).set(0, 3, 2, 1);
                pgJvxSrc.getElement(1).set(0, 1, 5, 4);
                pgJvxSrc.getElement(2).set(1, 2, 6, 5);
                pgJvxSrc.getElement(3).set(2, 3, 7, 6);
                pgJvxSrc.getElement(4).set(3, 0, 4, 7);
                pgJvxSrc.getElement(5).set(4, 5, 6, 7);
                this.addGeometry(pgJvxSrc, 1);
                this.m_specialGeom.put(GEOM_BNDBOX, pgJvxSrc);
            }
            this.recomputeBndBox();
        } else if (this.m_specialGeom.containsKey(GEOM_BNDBOX)) {
            this.removeGeometry((PgGeometryIf)this.m_specialGeom.get(GEOM_BNDBOX));
            this.m_specialGeom.remove(GEOM_BNDBOX);
        }
        this.setPaintTag(128, bl);
        this.update(this);
    }

    public PsPanel getInfoPanel() {
        if (this.m_infoPanel == null || !this.m_infoPanel.getLanguage().equals(PsConfig.getLanguage())) {
            this.m_infoPanel = new PvDisplay_IP();
            this.m_infoPanel.setParent(this);
            this.m_infoPanel.update(this);
        }
        return this.m_infoPanel;
    }

    public boolean containsGeometry(PgGeometryIf pgGeometryIf) {
        if (pgGeometryIf == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        return this.m_scene.containsGeometry(pgGeometryIf);
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n;
        if (keyEvent.isControlDown()) {
            this.setCursor(Cursor.getPredefinedCursor(0));
            int n2 = keyEvent.getKeyCode();
            switch (n2) {
                case 9: {
                    PgGeometryIf pgGeometryIf = this.getSelectedGeometry();
                    PgGeometryIf[] pgGeometryIfArray = this.getGeometries();
                    if (pgGeometryIfArray == null) {
                        return;
                    }
                    int n3 = 0;
                    while (n3 < pgGeometryIfArray.length) {
                        if (pgGeometryIf == pgGeometryIfArray[n3]) {
                            int n4 = 0;
                            while (n4 < pgGeometryIfArray.length) {
                                PgGeometryIf pgGeometryIf2 = pgGeometryIfArray[(n3 + n4 + 1) % pgGeometryIfArray.length];
                                if (pgGeometryIf2 != pgGeometryIf && !this.m_specialGeom.contains(pgGeometryIf2)) {
                                    this.selectGeometry(pgGeometryIf2);
                                    this.update(this);
                                    return;
                                }
                                ++n4;
                            }
                            PsDebug.warning("no other geometry found.");
                        }
                        ++n3;
                    }
                    return;
                }
            }
            return;
        }
        this.m_currentCamera.mousePressed(this.m_currLoc.width, this.m_nHeight - 1 - this.m_currLoc.height);
        if (this.m_bTransformModel) {
            this.m_modelCamera.mousePressed(this.m_currLoc.width, this.m_nHeight - 1 - this.m_currLoc.height);
        }
        if ((n = keyEvent.getKeyCode()) == this.m_prevKey) {
            return;
        }
        this.m_prevKey = n;
        if (keyEvent.isShiftDown()) {
            switch (n) {
                case 65: {
                    this.showEdgeAura(!this.isShowingEdgeAura());
                    break;
                }
                case 66: {
                    this.showBndBox(!this.isShowingBndBox());
                    break;
                }
                case 67: {
                    this.setPaintTag(16, !this.hasPaintTag(16));
                    break;
                }
                case 68: {
                    this.showDepthcue(!this.isShowingDepthcue());
                    break;
                }
                case 69: {
                    this.showEdgeAura(!this.isShowingEdgeAura());
                    break;
                }
                case 70: {
                    this.showFrame(!this.isShowingFrame());
                    break;
                }
                case 71: {
                    this.showGrid(!this.isShowingGrid());
                    break;
                }
                case 72: {
                    if (this.hasPaintTag(256)) {
                        PsDebug.showStatus(m_majorModeMessage[this.getMajorMode()]);
                        this.setPaintTag(256, false);
                        break;
                    }
                    PsDebug.showStatus(m_majorModeMessage[7]);
                    this.setPaintTag(256, true);
                    break;
                }
                case 73: {
                    this.showBackImage(!this.isShowingBackImage());
                    break;
                }
                case 76: {
                    this.setPaintTag(4, !this.hasPaintTag(4));
                    break;
                }
                case 77: {
                    this.showMagnet(!this.isShowingMagnet());
                    break;
                }
                case 80: {
                    this.setEnabledPainters(!this.isEnabledPainters());
                    break;
                }
                case 88: {
                    this.showAxes(!this.isShowingAxes());
                    break;
                }
                default: {
                    return;
                }
                case 82: 
            }
            this.update(this);
        } else {
            switch (n) {
                case 127: {
                    this.setMinorMode(13);
                    PsDebug.showStatus(m_majorModeMessage[13]);
                    break;
                }
                case 8: {
                    this.setMinorMode(13);
                    PsDebug.showStatus(m_majorModeMessage[13]);
                    break;
                }
                case 65: {
                    this.setMinorMode(12);
                    PsDebug.showStatus(m_majorModeMessage[this.m_mode]);
                    break;
                }
                case 67: {
                    PsDebug.showStatus(m_minorModeMessage[1]);
                    this.center();
                    this.repaint();
                    break;
                }
                case 68: {
                    Object object;
                    this.setMinorMode(14);
                    PsDebug.showStatus(m_majorModeMessage[this.m_mode]);
                    if (this.m_currentGeom == null) {
                        PsDebug.warning("missing selected geometry");
                        break;
                    }
                    Vector vector = this.m_currentGeom.getTaggedVertices();
                    if (vector == null || vector.size() == 0) {
                        PsDebug.warning("missing selected vertices");
                        break;
                    }
                    int n5 = vector.size();
                    PdVector[] pdVectorArray = new PdVector[n5];
                    int n6 = 0;
                    while (n6 < n5) {
                        pdVectorArray[n6] = (PdVector)vector.elementAt(n6);
                        ++n6;
                    }
                    this.m_currentGeom.untagAllVertices();
                    PdMatrix pdMatrix = null;
                    boolean bl = true;
                    switch (n5) {
                        case 1: {
                            pdMatrix = PuReflect.pointReflect(pdVectorArray[0]);
                            bl = true;
                            break;
                        }
                        case 2: {
                            object = PdVector.subNew(pdVectorArray[1], pdVectorArray[0]);
                            pdMatrix = PuReflect.rotateLine(pdVectorArray[0], (PdVector)object);
                            bl = false;
                            break;
                        }
                        case 3: {
                            pdMatrix = PuReflect.planeReflect(pdVectorArray[0], pdVectorArray[1], pdVectorArray[2]);
                            bl = false;
                            break;
                        }
                        default: {
                            PsDebug.warning("too many selected vertices");
                        }
                    }
                    if (pdMatrix == null || (object = this.getGeometryContainers()) == null) break;
                    int n7 = 0;
                    while (n7 < ((PvGeometry[])object).length) {
                        if (object[n7].isVisible()) {
                            PgGeometryIf pgGeometryIf = object[n7].getGeometry();
                            PgGeometry pgGeometry = pgGeometryIf.reflect(pdMatrix, bl);
                            this.addGeometry(pgGeometry);
                        }
                        ++n7;
                    }
                    this.update(this);
                    break;
                }
                case 70: {
                    PsDebug.showStatus(m_minorModeMessage[2]);
                    this.fit();
                    this.repaint();
                    break;
                }
                case 72: {
                    if (this.hasPaintTag(256)) {
                        PsDebug.showStatus(m_majorModeMessage[this.getMajorMode()]);
                        this.setPaintTag(256, false);
                        break;
                    }
                    PsDebug.showStatus(m_majorModeMessage[7]);
                    this.setPaintTag(256, true);
                    break;
                }
                case 73: {
                    this.setMinorMode(6);
                    PsDebug.showStatus(m_majorModeMessage[this.m_mode]);
                    break;
                }
                case 77: {
                    this.setMinorMode(9);
                    PsDebug.showStatus(m_majorModeMessage[this.m_mode]);
                    break;
                }
                case 79: {
                    this.setMinorMode(0);
                    PsDebug.showStatus(m_majorModeMessage[this.m_mode]);
                    break;
                }
                case 80: {
                    this.setMinorMode(5);
                    PsDebug.showStatus(m_majorModeMessage[this.m_mode]);
                    break;
                }
                case 81: {
                    PsDebug.showStatus(m_minorModeMessage[4]);
                    this.setEnabledAnimation(false);
                    this.stop();
                    this.update(this);
                    break;
                }
                case 82: {
                    this.init();
                    PsDebug.showStatus(m_minorModeMessage[0]);
                    break;
                }
                case 83: {
                    this.setMinorMode(1);
                    PsDebug.showStatus(m_majorModeMessage[this.m_mode]);
                    break;
                }
                case 84: {
                    this.setMinorMode(3);
                    PsDebug.showStatus(m_majorModeMessage[this.m_mode]);
                    break;
                }
                case 85: {
                    this.setMinorMode(11);
                    PsDebug.showStatus(m_majorModeMessage[this.m_mode]);
                    break;
                }
                case 87: {
                    PsDebug.showStatus(m_minorModeMessage[3]);
                    this.setEnabledAnimation(true);
                    this.start();
                    this.update(this);
                    break;
                }
                case 88: {
                    this.setMinorMode(2);
                    PsDebug.showStatus(m_majorModeMessage[this.m_mode]);
                    break;
                }
                case 90: {
                    this.setMinorMode(4);
                    PsDebug.showStatus(m_majorModeMessage[this.m_mode]);
                    break;
                }
                default: {
                    return;
                }
            }
        }
        if (this.m_currentCamera != null) {
            this.m_currentCamera.setMode(this.m_mode);
        }
        if (this.m_bTransformModel) {
            this.m_modelCamera.setMode(this.m_mode);
        }
        this.bDrag = false;
        this.repaint();
    }

    private synchronized void setCurrentGeometry(PvGeometry pvGeometry) {
        if (pvGeometry == null) {
            this.m_currentGeom = null;
            this.m_geomIf = null;
        } else {
            PgGeometryIf pgGeometryIf;
            if (this.hasPaintTag(2048) && this.m_currentGeom != null && this.m_currentGeom != pvGeometry && !this.m_specialGeom.contains(pgGeometryIf = this.m_currentGeom.getGeometry())) {
                pgGeometryIf.setVisible(false);
                this.m_currentGeom.setVisible(false);
            }
            this.m_currentGeom = pvGeometry;
            this.m_currentGeom.setVisible(true);
            this.m_geomIf = pvGeometry.getGeometry();
        }
        if (this.m_currentGeom != null && this.isShowingBndBox()) {
            this.recomputeBndBox();
        }
        this.setFrameTitle(this.m_geomIf);
    }

    public void requestPickFocus(PvPickListenerIf pvPickListenerIf) {
        this.m_pickFocus = pvPickListenerIf;
    }

    public boolean incrementAutoRotation() {
        this.m_currentCamera.mouseAnimateGeometry();
        this.updateCameraListener(101);
        return true;
    }

    public void setEnabledAnimation(boolean bl) {
        this.m_bEnableAnimation = bl;
        if (!this.m_bEnableAnimation) {
            this.stop();
        }
    }

    public int getAmbientProjection() {
        if (this.m_currentGeom != null) {
            return this.m_currentGeom.getAmbientProjection();
        }
        return this.m_ambientProj;
    }

    public void setAmbientProjection(int n) {
        if (this.m_currentGeom != null) {
            this.m_currentGeom.setAmbientProjection(n);
        }
        this.m_ambientProj = n;
    }

    private void scaleBackgroundImage(int n, int n2) {
        int n3;
        int n4;
        double d;
        if (this.m_backImage == null) {
            return;
        }
        double d2 = (0.5 + (double)n) / (double)n2;
        double d3 = this.m_backImage.getWidth(null);
        double d4 = (0.5 + d3) / (d = (double)this.m_backImage.getHeight(null));
        if (d2 < d4) {
            n4 = -1;
            n3 = n2;
        } else {
            n4 = n;
            n3 = -1;
        }
        this.m_backImage = this.m_backImage.getScaledInstance(n4, n3, 2);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.m_bMouseInside = false;
    }

    public boolean isShowingEdgeAura() {
        return this.m_bShowEdgeAura;
    }

    public void showEdgeAura(boolean bl) {
        this.m_bShowEdgeAura = bl;
    }

    public Dimension getSize() {
        Dimension dimension = super.getSize();
        return dimension;
    }

    public static void setDefaultSize(Dimension dimension) {
        PvDisplay.m_defSize.height = dimension.height;
        PvDisplay.m_defSize.width = dimension.width;
    }

    public void setEnabledPainters(boolean bl) {
        this.m_bEnableSorting = bl;
    }

    private void setMinorMode(int n) {
        this.m_mode = n;
        switch (this.m_mode) {
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                this.setCursor(Cursor.getPredefinedCursor(1));
                return;
            }
            case 1: {
                this.setCursor(Cursor.getPredefinedCursor(9));
                return;
            }
            case 3: {
                this.setCursor(Cursor.getPredefinedCursor(13));
                return;
            }
            case 4: {
                this.setCursor(Cursor.getPredefinedCursor(7));
                return;
            }
            case 0: {
                this.setCursor(Cursor.getPredefinedCursor(12));
                return;
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public boolean isShowingGrid() {
        return this.m_bShowGrid;
    }

    public void showGrid(boolean bl) {
        this.m_bShowGrid = bl;
        if (this.m_bShowGrid) {
            if (!this.m_specialGeom.containsKey(GEOM_XY_GRID)) {
                PvGrid pvGrid = new PvGrid(3);
                pvGrid.setName(PsConfig.getMessage(GEOM_XY_GRID));
                this.addGeometry(pvGrid, -1);
                this.m_specialGeom.put(GEOM_XY_GRID, pvGrid);
            }
        } else if (this.m_specialGeom.containsKey(GEOM_XY_GRID)) {
            this.removeGeometry((PgGeometryIf)this.m_specialGeom.get(GEOM_XY_GRID));
            this.m_specialGeom.remove(GEOM_XY_GRID);
        }
        this.update(this);
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n;
        int n2 = mouseEvent.getX();
        if (!this.updatePosition(n2, n = mouseEvent.getY())) {
            return;
        }
        this.m_currLoc.width = n2;
        this.m_currLoc.height = this.m_nHeight - 1 - n;
        if (this.bDrag) {
            if ((Math.abs(this.xUp - n2) > 0 || Math.abs(this.yUp - n) > 0) && this.isEnabledAnimation()) {
                this.start();
            }
            this.bDrag = false;
        }
        if (this.hasPaintTag(256)) {
            this.repaint();
        }
        if (this.m_currentGeom != null && this.hasPaintTag(4096)) {
            boolean bl = false;
            if (this.m_pickedVertex != -1) {
                this.m_currentGeom.releaseVertex(this.m_pickedVertex);
                bl = true;
            }
            this.m_pickedVertex = this.m_currentGeom.pickVertex(n2, n);
            if (this.m_pickedVertex != -1) {
                bl = true;
            }
            if (bl) {
                this.repaint();
            }
        }
    }

    public boolean hasPickListener(PvPickListenerIf pvPickListenerIf) {
        if (this.m_pickListener == null) {
            return false;
        }
        return this.m_pickListener.contains(pvPickListenerIf);
    }

    public boolean removePickListener(PvPickListenerIf pvPickListenerIf) {
        if (this.m_pickListener == null) {
            return false;
        }
        return this.m_pickListener.removeElement(pvPickListenerIf);
    }

    public void center() {
        if (this.m_scene == null) {
            return;
        }
        PdVector[] pdVectorArray = this.m_scene.getBounds();
        if (pdVectorArray == null) {
            return;
        }
        PdVector pdVector = new PdVector(3);
        pdVector.blend(0.5, pdVectorArray[0], 0.5, pdVectorArray[1]);
        this.m_currentCamera.setInterest(pdVector);
        if (this.m_bTransformModel) {
            this.m_modelCamera.setCurrentView(this.m_currentCamera.m_view, this.m_currentCamera.m_viewInv);
        }
        this.updateCameraListener(101);
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.m_prevKey = -1;
        this.setMinorMode(this.m_modeMajor);
        this.m_currentCamera.mousePressed(this.m_currLoc.width, this.m_nHeight - 1 - this.m_currLoc.height);
        if (this.m_currentCamera != null) {
            this.m_currentCamera.setMode(this.m_mode);
        }
        if (this.m_bTransformModel) {
            this.m_modelCamera.setMode(this.m_mode);
        }
        PsDebug.showStatus(m_majorModeMessage[this.m_mode]);
        this.bDrag = false;
        switch (keyEvent.getKeyCode()) {
            case 77: 
            case 85: {
                this.repaint();
                return;
            }
        }
    }

    public double getFarClip() {
        return this.m_currentCamera.m_farClip.getValue();
    }

    public void setFarClip(double d) {
        this.m_currentCamera.m_farClip.setValue(d);
    }

    public boolean selectGeometry(PgGeometryIf pgGeometryIf) {
        if (pgGeometryIf != null && !this.containsGeometry(pgGeometryIf)) {
            PsDebug.warning("geometry=" + pgGeometryIf.getName() + " not registered in display");
            return false;
        }
        this.setCurrentGeometry(this.m_scene.getGeometry(pgGeometryIf));
        if (this.m_bTransformModel && this.m_currentGeom != null) {
            this.m_modelCamera.setModelMatrix(this.m_currentGeom.getModelMatrix());
        }
        if (this.m_viewer != null) {
            this.m_viewer.setGeometry(pgGeometryIf);
        }
        this.m_scene.selectGeometry(this.m_currentGeom);
        if (this.m_currentCamera.hasInspector("Info") && this.m_cameraPanel.isShowing()) {
            this.m_cameraPanel.update(this.m_currentCamera);
        }
        return true;
    }

    public void removeGeometries() {
        PvGeometry[] pvGeometryArray = this.getAllGeometryContainers();
        if (pvGeometryArray == null) {
            return;
        }
        int n = 0;
        while (n < pvGeometryArray.length) {
            PgGeometryIf pgGeometryIf = pvGeometryArray[n].getGeometry();
            pgGeometryIf.removeDisplay(this);
            this.m_scene.removeGeometry(pvGeometryArray[n]);
            ++n;
        }
        this.m_currentGeom = null;
    }

    public boolean isEnabledAnimation() {
        return this.m_bEnableAnimation;
    }

    public Point getPosition(int n, int n2) {
        Frame frame = this.hasParentFrame();
        if (frame == null) {
            return new Point(0, 0);
        }
        return frame.getLocation();
    }

    public void setDrawingOrder(int n, PgGeometryIf pgGeometryIf) {
        if (!this.containsGeometry(pgGeometryIf)) {
            if (pgGeometryIf != null) {
                PsDebug.warning("geometry=" + pgGeometryIf.getName() + " not registered in listener");
            }
            return;
        }
        PvGeometry pvGeometry = this.m_scene.getGeometry(pgGeometryIf);
        this.m_scene.removeGeometry(pvGeometry);
        pvGeometry.setDrawingOrder(n);
        this.m_scene.addGeometry(pvGeometry);
    }

    public void setPosition(int n, int n2) {
        Frame frame = this.hasParentFrame();
        if (frame == null) {
            return;
        }
        ((Component)frame).setLocation(n, n2);
    }

    public boolean selectCamera(int n) {
        if (n < 0 || m_cameraName.length <= n) {
            return false;
        }
        if (this.getCamera(n) == null) {
            this.addCamera(m_cameraName[n], new PvCamera(this, n));
        }
        this.m_currentCamera = this.getCamera(n);
        this.m_currentCamera.resizeImage(this.m_nWidth, this.m_nHeight);
        this.m_currentCamera.setMode(this.m_mode);
        if (this.m_bTransformModel) {
            this.m_modelCamera.setCurrentView(this.m_currentCamera.m_view, this.m_currentCamera.m_viewInv);
        }
        if (this.m_cameraPanel != null) {
            if (!this.m_currentCamera.hasInspector("Info")) {
                this.m_currentCamera.addInspector("Info", this.m_cameraPanel);
            } else {
                this.m_cameraPanel.setParent(this.m_currentCamera);
                this.m_cameraPanel.update(this.m_currentCamera);
            }
        }
        this.updateCameraListener(101);
        return true;
    }

    public PvCameraIf getCamera() {
        return this.m_currentCamera;
    }

    public PvCamera getCamera(int n) {
        if (n < 0 || m_cameraName.length <= n) {
            return this.m_currentCamera;
        }
        return (PvCamera)this.m_camera.get(m_cameraName[n]);
    }

    public boolean update(Object object) {
        block18: {
            if (object == this.m_sleep) {
                return true;
            }
            PvGeometry[] pvGeometryArray = this.getAllGeometryContainers();
            if (pvGeometryArray == null || pvGeometryArray.length <= 0) break block18;
            int n = 0;
            while (n < pvGeometryArray.length) {
                block19: {
                    if (pvGeometryArray[n].getGeometry() != object) break block19;
                    if (!pvGeometryArray[n].getName().startsWith(pvGeometryArray[n].getGeometry().getName()) && this.m_infoPanel != null && this.m_infoPanel.isShowing()) {
                        this.m_infoPanel.update(this);
                    }
                    PvScene pvScene = this.m_scene;
                    synchronized (pvScene) {
                        pvGeometryArray[n].update(object);
                        if (this.m_currentGeom == pvGeometryArray[n]) {
                            if (this.m_currentGeom != null && this.isShowingBndBox()) {
                                this.recomputeBndBox();
                            }
                            this.setFrameTitle(this.m_geomIf);
                        }
                        this.m_scene.update(pvGeometryArray[n]);
                        Object var5_5 = null;
                    }
                    this.repaint();
                    return true;
                }
                ++n;
            }
        }
        if (object == this) {
            if (this.m_infoPanel != null && this.m_infoPanel.isShowing()) {
                this.m_infoPanel.update(this);
            }
        } else if (object != this.m_infoPanel) {
            if (object == this.m_currentCamera) {
                this.updateCameraListener(101);
            } else if (object != this.m_backgroundColor && object != this.m_foregroundColor) {
                if (object == this.m_height || object == this.m_width) {
                    this.setSizeWithinFrame(this.m_width.getValue(), this.m_height.getValue());
                } else if (object != null) {
                    return false;
                }
            }
        }
        this.repaint();
        return true;
    }

    public void update(Graphics graphics) {
        if (!this.hasPaintTag(1)) {
            return;
        }
        this.m_bDrawing = true;
        PvScene pvScene = this.m_scene;
        synchronized (pvScene) {
            block4: {
                if (!this.resizeImage()) break block4;
                this.paintGeom(this.m_g);
                if (this.m_image == null) break block4;
                graphics.drawImage(this.m_image, 0, 0, this);
            }
            Object var3_3 = null;
        }
        this.m_bDrawing = false;
    }

    public PdMatrix getTransMatrix(int n) {
        if (this.m_modelCamera != null) {
            this.m_currentGeom.setModelMatrix(this.m_modelCamera.getModelMatrix());
        }
        switch (n) {
            case 0: {
                return this.m_currentCamera.m_trans;
            }
            case 16: {
                return this.m_currentCamera.m_transInv;
            }
            case 1: {
                return this.m_currentCamera.m_trans;
            }
            case 32: {
                return this.m_currentCamera.m_transInv;
            }
            case 2: {
                return this.m_currentCamera.m_proj;
            }
            case 64: {
                return this.m_currentCamera.m_projInv;
            }
            case 4: {
                return this.m_currentCamera.m_view;
            }
            case 128: {
                return this.m_currentCamera.m_viewInv;
            }
            case 8: {
                if (this.m_modelCamera != null) {
                    return this.m_modelCamera.getModelMatrix();
                }
                return null;
            }
            case 256: {
                if (this.m_modelCamera != null) {
                    return this.m_modelCamera.getModelInvMatrix();
                }
                return null;
            }
        }
        PsDebug.warning("unknown matrix type.");
        return null;
    }

    public void setTransMatrix(int n, PdMatrix pdMatrix) {
        switch (n) {
            case 0: {
                this.m_currentCamera.m_trans.copy(pdMatrix);
                break;
            }
            case 16: {
                this.m_currentCamera.m_transInv.copy(pdMatrix);
                break;
            }
            case 1: {
                this.m_currentCamera.m_trans.copy(pdMatrix);
                break;
            }
            case 32: {
                this.m_currentCamera.m_transInv.copy(pdMatrix);
                break;
            }
            case 2: {
                this.m_currentCamera.m_proj.copy(pdMatrix);
                break;
            }
            case 64: {
                this.m_currentCamera.m_projInv.copy(pdMatrix);
                break;
            }
            case 4: {
                this.m_currentCamera.m_view.copy(pdMatrix);
                break;
            }
            case 128: {
                this.m_currentCamera.m_viewInv.copy(pdMatrix);
                break;
            }
            default: {
                PsDebug.warning("unknown matrix type.");
            }
        }
        this.updateCameraListener(101);
    }

    private void setFrameTitle(PgGeometryIf pgGeometryIf) {
        if (pgGeometryIf == null) {
            this.m_currentFrameName = null;
        } else {
            if (this.m_currentFrameName != null && this.m_currentFrameName.equals(pgGeometryIf.getName())) {
                return;
            }
            this.m_currentFrameName = pgGeometryIf.getName();
        }
        Frame frame = this.hasParentFrame();
        if (frame == null) {
            return;
        }
        if (this.m_currentFrameName != null) {
            frame.setTitle(PsConfig.getProgram() + " v" + PsConfig.getVersion() + ": " + this.m_currentFrameName);
            return;
        }
        frame.setTitle(PsConfig.getProgram() + " v" + PsConfig.getVersion() + ": ");
    }

    public boolean hasCameraListener(PvCameraListenerIf pvCameraListenerIf) {
        if (this.m_cameraListener == null) {
            return false;
        }
        return this.m_cameraListener.contains(pvCameraListenerIf);
    }

    public boolean removeCameraListener(PvCameraListenerIf pvCameraListenerIf) {
        if (this.m_cameraListener == null) {
            return false;
        }
        return this.m_cameraListener.removeElement(pvCameraListenerIf);
    }

    private void recomputeBndBox() {
        PgJvxSrc pgJvxSrc = (PgJvxSrc)this.m_specialGeom.get(GEOM_BNDBOX);
        if (this.m_currentGeom == null || this.m_currentGeom.getGeometry() == pgJvxSrc) {
            return;
        }
        PdVector[] pdVectorArray = this.m_currentGeom.getBounds();
        if (pdVectorArray == null) {
            return;
        }
        pgJvxSrc.setVertex(0, pdVectorArray[0]);
        pgJvxSrc.setVertex(1, new PdVector(pdVectorArray[1].m_data[0], pdVectorArray[0].m_data[1], pdVectorArray[0].m_data[2]));
        pgJvxSrc.setVertex(2, new PdVector(pdVectorArray[1].m_data[0], pdVectorArray[1].m_data[1], pdVectorArray[0].m_data[2]));
        pgJvxSrc.setVertex(3, new PdVector(pdVectorArray[0].m_data[0], pdVectorArray[1].m_data[1], pdVectorArray[0].m_data[2]));
        pgJvxSrc.setVertex(4, new PdVector(pdVectorArray[0].m_data[0], pdVectorArray[0].m_data[1], pdVectorArray[1].m_data[2]));
        pgJvxSrc.setVertex(5, new PdVector(pdVectorArray[1].m_data[0], pdVectorArray[0].m_data[1], pdVectorArray[1].m_data[2]));
        pgJvxSrc.setVertex(6, pdVectorArray[1]);
        pgJvxSrc.setVertex(7, new PdVector(pdVectorArray[0].m_data[0], pdVectorArray[1].m_data[1], pdVectorArray[1].m_data[2]));
        pgJvxSrc.makeElementNormals();
        pgJvxSrc.update(pgJvxSrc);
    }

    public boolean addGeometry(PgGeometryIf pgGeometryIf) {
        return this.addGeometry(pgGeometryIf, 0);
    }

    private boolean addGeometry(PgGeometryIf pgGeometryIf, int n) {
        if (pgGeometryIf == null) {
            PsDebug.warning("missing geometry.");
            return false;
        }
        if (this.containsGeometry(pgGeometryIf)) {
            return true;
        }
        pgGeometryIf.addDisplay(this);
        PvGeometry pvGeometry = new PvGeometry(pgGeometryIf.getDimOfVertices());
        pvGeometry.setDrawingOrder(n);
        pvGeometry.setDisplay(this);
        pvGeometry.setGeometry(pgGeometryIf);
        this.m_scene.addGeometry(pvGeometry);
        if (this.m_scene.m_numGeometries == 0 && n != 0) {
            this.setCurrentGeometry(pvGeometry);
        }
        if (this.m_scene.m_numGeometries == 1 && n == 0) {
            this.setCurrentGeometry(pvGeometry);
            this.fit();
        }
        return true;
    }

    public void setAutoRotation(PdVector pdVector, double d) {
        if (!PuReflect.makeRotation(this.m_currentCamera.m_incrView, pdVector, d)) {
            return;
        }
        if (!this.m_bTransformModel) {
            this.m_currentCamera.m_incrViewInv.transpose(this.m_currentCamera.m_incrView);
            return;
        }
        this.m_modelCamera.m_incrModelInv.transpose(this.m_currentCamera.m_incrView);
    }

    protected boolean updatePosition(int n, int n2) {
        if (this.m_nWidth == 0 || this.m_nHeight == 0) {
            return false;
        }
        return this.m_currLoc.width != n || this.m_currLoc.height != this.m_nHeight - 1 - n2;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        P_Vector p_Vector;
        int n;
        Object object;
        if (mouseEvent.isPopupTrigger()) {
            return;
        }
        this.m_pickedVertex = -1;
        this.bDrag = false;
        if (this.m_viewer != null) {
            this.m_viewer.selectDisplay(this.getName());
        }
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        if (!this.m_bMouseInside || this.m_nWidth == 0 || this.m_nHeight == 0 || n2 < 0 || n3 < 0 || this.m_nWidth <= n2 || this.m_nHeight <= n3) {
            return;
        }
        this.m_currLoc.width = n2;
        this.m_currLoc.height = this.m_nHeight - 1 - n3;
        this.m_bMouseDown = true;
        this.xDown = n2;
        this.yDown = n3;
        this.m_markBox.m_data[0] = n2;
        this.m_markBox.m_data[1] = n3;
        this.m_markBox.m_data[2] = n2;
        this.m_markBox.m_data[3] = n3;
        if (this.m_thread != null) {
            this.stop();
        }
        this.m_currentCamera.mousePressed(n2, n3);
        if (this.m_bTransformModel) {
            this.m_modelCamera.mousePressed(n2, n3);
        }
        this.updateCameraListener(101);
        if (mouseEvent != null && mouseEvent.isControlDown()) {
            object = this.getAllGeometryContainers();
            n = 0;
            while (n < ((PvGeometry[])object).length) {
                if (object[n].isVisible()) {
                    Serializable serializable;
                    p_Vector = new PdVector(n2, n3, 0.0, 1.0);
                    PdVector pdVector = new PdVector(0.0, 0.0, -1000.0, 0.0);
                    ((PdVector)p_Vector).leftMultMatrix(this.m_currentCamera.m_transInv);
                    pdVector.leftMultMatrix(this.m_currentCamera.m_transInv);
                    if (((PgGeometry)object[n]).hasModelMatrix()) {
                        serializable = new PdMatrix(4);
                        serializable.invert34(((PgGeometry)object[n]).getModelMatrix());
                        ((PdVector)p_Vector).leftMultMatrix((PdMatrix)serializable);
                        pdVector.leftMultMatrix((PdMatrix)serializable);
                    }
                    ((PdVector)p_Vector).setSize(3);
                    pdVector.setSize(3);
                    pdVector.normalize();
                    serializable = null;
                    if (this.m_geomIf != null) {
                        serializable = ((PvGeometry)object[n]).getGeometry().intersectionWithLine((PdVector)p_Vector, pdVector);
                    }
                    if (serializable != null) {
                        this.selectGeometry(((PvGeometry)object[n]).getGeometry());
                        this.update(this);
                        return;
                    }
                }
                ++n;
            }
        }
        if (this.m_mode == 12) {
            this.m_pick.set(n2, n3, 0.0, 1.0);
            this.m_worldPick.leftMultMatrix(this.m_currentCamera.m_transInv, this.m_pick);
            if (this.m_currentGeom.hasModelMatrix()) {
                object = new PdMatrix(4);
                ((PdMatrix)object).invert34(this.m_currentGeom.getModelMatrix());
                this.m_worldPick.leftMultMatrix((PdMatrix)object);
            }
            int n4 = this.m_currentGeom.addGeometryVertex(this.m_worldPick);
            if (this.m_geomIf != null) {
                this.m_geomIf.update(this.m_geomIf);
            }
            PsDebug.showStatus("new vertex[" + n4 + "] = (" + this.m_worldPick.m_data[0] + "," + this.m_worldPick.m_data[1] + "," + this.m_worldPick.m_data[2] + "," + this.m_worldPick.m_data[3]);
            this.repaint();
            return;
        }
        if (this.m_mode == 6) {
            if (this.m_pickListener == null || this.m_pickListener.size() == 0) {
                return;
            }
            object = this.getPickEvent(n2, n3);
            if (this.m_pickFocus != null) {
                this.m_pickFocus.pickInitial((PvPickEvent)object);
                return;
            }
            if (this.m_pickListener != null) {
                Enumeration enumeration = this.m_pickListener.elements();
                while (enumeration.hasMoreElements()) {
                    ((PvPickListenerIf)enumeration.nextElement()).pickInitial((PvPickEvent)object);
                }
                return;
            }
        } else if (this.m_mode == 8) {
            if (this.m_pickListener == null || this.m_pickListener.size() == 0) {
                return;
            }
            object = this.getPickEvent(n2, n3);
            if (this.m_pickFocus != null) {
                this.m_pickFocus.pickDisplay((PvPickEvent)object);
                return;
            }
            if (this.m_pickListener != null) {
                Enumeration enumeration = this.m_pickListener.elements();
                while (enumeration.hasMoreElements()) {
                    ((PvPickListenerIf)enumeration.nextElement()).pickDisplay((PvPickEvent)object);
                }
                return;
            }
        } else {
            if (this.m_mode == 5) {
                if (this.m_currentGeom == null) {
                    return;
                }
                this.m_pickedVertex = this.m_currentGeom.pickVertex(n2, n3);
                if (this.m_pickedVertex == -1) {
                    return;
                }
                object = this.m_currentGeom.getVertex(this.m_pickedVertex);
                this.m_worldPick.copy((PdVector)object);
                this.m_worldPick.setEntry(3, 1.0);
                if (this.m_currentGeom.hasModelMatrix()) {
                    this.m_worldPick.leftMultMatrix(this.m_currentGeom.getModelMatrix());
                }
                this.m_worldPick.leftMultMatrix(this.m_currentCamera.m_trans);
                this.m_pick.set(n2, n3, this.m_worldPick.m_data[2], 1.0);
                if (this.m_pickFocus != null) {
                    this.m_pickFocus.pickVertex(this.m_geomIf, this.m_pickedVertex, (PdVector)object);
                } else if (this.m_pickListener != null) {
                    Enumeration enumeration = this.m_pickListener.elements();
                    while (enumeration.hasMoreElements()) {
                        ((PvPickListenerIf)enumeration.nextElement()).pickVertex(this.m_geomIf, this.m_pickedVertex, (PdVector)object);
                    }
                }
                this.repaint();
                return;
            }
            if (this.m_mode != 9) {
                if (this.m_mode == 10) {
                    object = this.getPickEvent(n2, n3);
                    n = ((PvPickEvent)object).getElementInd();
                    if (n == -1) {
                        return;
                    }
                    p_Vector = this.m_geomIf.getElement(n);
                    if (p_Vector == null) {
                        return;
                    }
                    if (p_Vector.hasTag(1)) {
                        p_Vector.clearTag(1);
                    } else {
                        p_Vector.setTag(1);
                    }
                    this.m_geomIf.update(this.m_geomIf);
                    this.bDrag = false;
                    this.repaint();
                    return;
                }
                if (this.m_mode != 2 && this.m_mode != 11) {
                    return;
                }
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n;
        if (mouseEvent.isPopupTrigger()) {
            return;
        }
        int n2 = mouseEvent.getX();
        if (!this.updatePosition(n2, n = mouseEvent.getY())) {
            return;
        }
        this.m_currLoc.width = n2;
        this.m_currLoc.height = this.m_nHeight - 1 - n;
        this.normalizedCoordsFromViewport(this.m_currNormLoc, this.m_currLoc);
        if (this.m_mode == 6) {
            if (this.m_bDrawing) {
                return;
            }
            if (this.m_pickListener != null && this.m_pickListener.size() > 0) {
                PvPickEvent pvPickEvent = this.getPickEvent(n2, n);
                if (this.m_pickFocus != null) {
                    this.m_pickFocus.dragInitial(pvPickEvent);
                } else if (this.m_pickListener != null) {
                    Enumeration enumeration = this.m_pickListener.elements();
                    while (enumeration.hasMoreElements()) {
                        ((PvPickListenerIf)enumeration.nextElement()).dragInitial(pvPickEvent);
                    }
                }
            }
        } else if (this.m_mode == 8) {
            if (this.m_pickListener != null && this.m_pickListener.size() > 0) {
                PvPickEvent pvPickEvent = this.getPickEvent(n2, n);
                if (this.m_pickFocus != null) {
                    this.m_pickFocus.dragDisplay(pvPickEvent);
                } else if (this.m_pickListener != null) {
                    Enumeration enumeration = this.m_pickListener.elements();
                    while (enumeration.hasMoreElements()) {
                        ((PvPickListenerIf)enumeration.nextElement()).dragDisplay(pvPickEvent);
                    }
                }
            }
        } else if (this.m_mode == 5) {
            Object object;
            if (this.m_pickedVertex == -1) {
                return;
            }
            this.m_pick.m_data[0] = n2;
            this.m_pick.m_data[1] = n;
            this.m_worldPick.leftMultMatrix(this.m_currentCamera.m_transInv, this.m_pick);
            if (this.m_currentGeom != null) {
                this.m_currentGeom.setGeometryVertex(this.m_pickedVertex, this.m_worldPick);
            }
            if (this.m_currentGeom.hasModelMatrix()) {
                object = new PdMatrix(4);
                ((PdMatrix)object).invert34(this.m_currentGeom.getModelMatrix());
                this.m_worldPick.leftMultMatrix((PdMatrix)object);
            }
            if (this.m_pickFocus != null) {
                this.m_pickFocus.dragVertex(this.m_geomIf, this.m_pickedVertex, this.m_worldPick);
            } else if (this.m_pickListener != null) {
                object = this.m_pickListener.elements();
                while (object.hasMoreElements()) {
                    ((PvPickListenerIf)object.nextElement()).dragVertex(this.m_geomIf, this.m_pickedVertex, this.m_worldPick);
                }
            }
            if (this.m_geomIf != null) {
                this.m_geomIf.update(this.m_geomIf);
            }
        } else if (this.m_mode == 9) {
            this.m_markBox.m_data[2] = n2;
            this.m_markBox.m_data[3] = n;
        } else if (this.m_mode == 10) {
            this.m_markBox.m_data[2] = n2;
            this.m_markBox.m_data[3] = n;
        } else if (this.m_mode == 2) {
            this.m_markBox.m_data[2] = n2;
            this.m_markBox.m_data[3] = n;
        } else if (this.m_mode == 11) {
            this.m_markBox.m_data[2] = n2;
            this.m_markBox.m_data[3] = n;
        } else {
            if (!this.m_bTransformModel) {
                this.m_currentCamera.mouseDragged(n2, n);
            } else {
                this.m_modelCamera.mouseDragged(n2, n);
            }
            this.updateCameraListener(102);
            this.bDrag = true;
        }
        this.repaint();
    }

    public boolean isShowingMagnet() {
        return this.hasPaintTag(4096);
    }

    public void showMagnet(boolean bl) {
        if (!bl && this.m_pickedVertex != -1 && this.m_currentGeom != null) {
            this.m_currentGeom.releaseVertex(this.m_pickedVertex);
        }
        this.m_pickedVertex = -1;
        this.setPaintTag(4096, bl);
    }

    public int addCamera(String string, PvCamera pvCamera) {
        if (string == null || pvCamera == null) {
            PsDebug.warning("missing arguments", this);
            return -1;
        }
        int n = -1;
        int n2 = 0;
        while (n2 < m_cameraName.length) {
            if (m_cameraName[n2].equals(string)) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n == -1) {
            return -1;
        }
        this.m_camera.put(string, pvCamera);
        pvCamera.setParent(this);
        pvCamera.setName(string);
        return n;
    }

    public void setMajorMode(int n) {
        this.m_defModeMajor = n;
        this.setCurrentMajorMode(this.m_defModeMajor);
    }

    public int getMajorMode() {
        return this.m_mode;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width = 350;
        dimension.height = 350;
        return dimension;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width = 350;
        dimension.height = 350;
        return dimension;
    }

    protected PvGeometry[] getGeometryContainers() {
        PvGeometry[] pvGeometryArray = this.getAllGeometryContainers();
        if (pvGeometryArray == null) {
            return null;
        }
        int n = pvGeometryArray.length - this.m_specialGeom.size();
        if (n == 0) {
            return null;
        }
        if (n < 0) {
            PsDebug.warning("special geometries not unregistered.");
            return null;
        }
        PvGeometry[] pvGeometryArray2 = new PvGeometry[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < pvGeometryArray.length) {
            if (!this.m_specialGeom.contains(pvGeometryArray[n3].getGeometry())) {
                pvGeometryArray2[n2++] = pvGeometryArray[n3];
            }
            ++n3;
        }
        return pvGeometryArray2;
    }
}

