/*
 * Decompiled with CFR 0.152.
 */
package jv.viewer;

import java.awt.Color;
import jv.number.PuDouble;
import jv.project.PgJvxSrc;
import jv.vecmath.PdVector;

public final class PvGrid
extends PgJvxSrc {
    protected PuDouble m_uMin;
    protected PuDouble m_vMin;
    protected PuDouble m_uMax;
    protected PuDouble m_vMax;
    private double m_defUMin = -20.0;
    private double m_defVMin = -20.0;
    private double m_defUMax = 20.0;
    private double m_defVMax = 20.0;
    protected int m_numULines;
    protected int m_numVLines;
    protected int m_numUSub;
    protected int m_numVSub;
    private int m_numUDiscr;
    private int m_numVDiscr;
    private int m_defNumULines = 9;
    private int m_defNumVLines = 9;
    private int m_defNumUSub = 0;
    private int m_defNumVSub = 0;
    protected PdVector m_origin;
    protected PdVector m_uDir;
    protected PdVector m_vDir;
    protected PdVector m_normal;
    protected PdVector m_defOrigin = new PdVector(0.0, 0.0, 0.0);
    protected PdVector m_defUDir = new PdVector(1.0, 0.0, 0.0);
    protected PdVector m_defVDir = new PdVector(0.0, 1.0, 0.0);

    public void setOrientation(PdVector pdVector, PdVector pdVector2, PdVector pdVector3) {
        this.m_origin.copy(pdVector);
        this.m_uDir.copy(pdVector2);
        this.m_vDir.copy(pdVector3);
        this.m_normal.cross(this.m_uDir, this.m_vDir);
    }

    public PvGrid(int n) {
        super(n);
        this.m_origin = new PdVector(n);
        this.m_uDir = new PdVector(n);
        this.m_vDir = new PdVector(n);
        this.m_normal = new PdVector(n);
        this.m_uMin = new PuDouble("uMin", this);
        this.m_vMin = new PuDouble("vMin", this);
        this.m_uMax = new PuDouble("uMax", this);
        this.m_vMax = new PuDouble("vMax", this);
        this.init();
    }

    public void makeQuadrConn(int n, int n2) {
        if (n < 2 || n2 < 2) {
            return;
        }
        this.setDimOfElements(4);
        this.setNumElements((n - 1) * (n2 - 1));
        int n3 = 0;
        int n4 = 0;
        while (n4 < n - 1) {
            int n5 = 0;
            while (n5 < n2 - 1) {
                this.m_element[n3].m_data[0] = n4 * n2 + n5;
                this.m_element[n3].m_data[1] = (n4 + 1) * n2 + n5;
                this.m_element[n3].m_data[2] = (n4 + 1) * n2 + n5 + 1;
                this.m_element[n3].m_data[3] = n4 * n2 + n5 + 1;
                ++n3;
                ++n5;
            }
            ++n4;
        }
    }

    public void setDefSize(double d, double d2, double d3, double d4) {
        this.m_defUMin = d;
        this.m_defVMin = d2;
        this.m_defUMax = d3;
        this.m_defVMax = d4;
    }

    public void setUMin(double d) {
        this.m_uMin.setValue(d);
    }

    public void setVMin(double d) {
        this.m_vMin.setValue(d);
    }

    public void setDiscr(int n, int n2, int n3, int n4) {
        this.m_numUSub = n3;
        this.m_numVSub = n4;
        this.setNumULines(n);
        this.setNumVLines(n2);
    }

    public double getUMin() {
        return this.m_uMin.getValue();
    }

    public double getVMin() {
        return this.m_vMin.getValue();
    }

    protected void setNumULinesFromPanel(int n) {
        this.m_numULines = n;
        this.m_numUDiscr = (this.m_numULines - 1) * (this.m_numUSub + 1) + 1;
    }

    protected void setNumVLinesFromPanel(int n) {
        this.m_numVLines = n;
        this.m_numVDiscr = (this.m_numVLines - 1) * (this.m_numVSub + 1) + 1;
    }

    public void setNumULines(int n) {
        this.m_numULines = n;
        this.m_numUDiscr = (this.m_numULines - 1) * (this.m_numUSub + 1) + 1;
    }

    public int getNumULines() {
        return this.m_numULines;
    }

    public void setSize(double d, double d2, double d3, double d4) {
        this.m_uMin.setBounds(d - 2.0 * (d3 - d), d + 2.0 * (d3 - d), 0.1, 1.0);
        this.m_uMin.setValue(d);
        this.m_vMin.setBounds(d2 - 2.0 * (d4 - d2), d2 + 2.0 * (d4 - d2), 0.1, 1.0);
        this.m_vMin.setValue(d2);
        this.m_uMax.setBounds(d3 - 2.0 * (d3 - d), d3 + 2.0 * (d3 - d), 0.1, 1.0);
        this.m_uMax.setValue(d3);
        this.m_vMax.setBounds(d4 - 2.0 * (d4 - d2), d4 + 2.0 * (d4 - d2), 0.1, 1.0);
        this.m_vMax.setValue(d4);
    }

    public void setNumVLines(int n) {
        this.m_numVLines = n;
        this.m_numVDiscr = (this.m_numVLines - 1) * (this.m_numVSub + 1) + 1;
    }

    public int getNumVLines() {
        return this.m_numVLines;
    }

    public void init() {
        super.init();
        this.m_uMin.setDefBounds(this.m_defUMin - 2.0 * (this.m_defUMax - this.m_defUMin), this.m_defUMin + 2.0 * (this.m_defUMax - this.m_defUMin), 0.1, 1.0);
        this.m_uMin.setDefValue(this.m_defUMin);
        this.m_uMin.init();
        this.m_vMin.setDefBounds(this.m_defVMin - 2.0 * (this.m_defVMax - this.m_defVMin), this.m_defVMin + 2.0 * (this.m_defVMax - this.m_defVMin), 0.1, 1.0);
        this.m_vMin.setDefValue(this.m_defVMin);
        this.m_uMin.init();
        this.m_uMax.setDefBounds(this.m_defUMax - 2.0 * (this.m_defUMax - this.m_defUMin), this.m_defUMax + 2.0 * (this.m_defUMax - this.m_defUMin), 0.1, 1.0);
        this.m_uMax.setDefValue(this.m_defUMax);
        this.m_uMax.init();
        this.m_vMax.setDefBounds(this.m_defVMax - 2.0 * (this.m_defVMax - this.m_defVMin), this.m_defVMax + 2.0 * (this.m_defVMax - this.m_defVMin), 0.1, 1.0);
        this.m_vMax.setDefValue(this.m_defVMax);
        this.m_vMax.init();
        this.setSize(this.m_defUMin, this.m_defVMin, this.m_defUMax, this.m_defVMax);
        this.setDiscr(this.m_defNumULines, this.m_defNumVLines, this.m_defNumUSub, this.m_defNumVSub);
        this.m_origin.copy(this.m_defOrigin);
        this.m_uDir.copy(this.m_defUDir);
        this.m_vDir.copy(this.m_defVDir);
        this.m_normal.cross(this.m_uDir, this.m_vDir);
        this.setGlobalVertexColor(Color.blue);
        this.setGlobalEdgeColor(Color.gray);
        this.setGlobalElementColor(Color.white);
        this.compute();
    }

    public void compute() {
        this.setNumVertices(this.m_numULines * this.m_numVLines);
        double d = this.m_uMin.getValue();
        double d2 = this.m_vMin.getValue();
        double d3 = (this.m_uMax.getValue() - d) / (-1.0 + (double)this.m_numULines);
        double d4 = (this.m_vMax.getValue() - d2) / (-1.0 + (double)this.m_numVLines);
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_numULines) {
            double d5 = d + d3 * (double)n2;
            int n3 = 0;
            while (n3 < this.m_numVLines) {
                double d6 = d2 + d4 * (double)n3;
                int n4 = 0;
                while (n4 < this.m_dim) {
                    this.m_vertex[n].m_data[n4] = this.m_origin.m_data[n4] + d5 * this.m_uDir.m_data[n4] + d6 * this.m_vDir.m_data[n4];
                    ++n4;
                }
                ++n;
                ++n3;
            }
            ++n2;
        }
        this.makeQuadrConn(this.m_numULines, this.m_numVLines);
        this.assureVertexNormals();
        PdVector.setConstant(this.m_vertexNormal, this.m_normal);
    }

    public void setDefDiscr(int n, int n2, int n3, int n4) {
        this.m_defNumUSub = n3;
        this.m_defNumVSub = n4;
        this.m_defNumULines = n;
        this.m_defNumVLines = n2;
    }

    public void setUMax(double d) {
        this.m_uMax.setValue(d);
    }

    public void setVMax(double d) {
        this.m_vMax.setValue(d);
    }

    public double getUMax() {
        return this.m_uMax.getValue();
    }

    public double getVMax() {
        return this.m_vMax.getValue();
    }
}

