/*
 * Decompiled with CFR 0.152.
 */
package jv.viewer;

import jv.object.PsDebug;
import jv.object.PsObject;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PuMath;
import jv.vecmath.PuReflect;
import jv.viewer.PvDisplay;

final class PvModelCamera
extends PsObject {
    private double SIZE = 10.0;
    protected PdMatrix m_model = new PdMatrix(4);
    protected PdMatrix m_modelInv = new PdMatrix(4);
    protected PdMatrix m_incrModel = new PdMatrix(4);
    protected PdMatrix m_incrModelInv = new PdMatrix(4);
    protected PdMatrix m_viewCamera = new PdMatrix(4);
    protected PdMatrix m_viewInvCamera = new PdMatrix(4);
    protected int m_mode;
    protected double m_nHeight;
    protected double m_nWidth;
    protected double m_scaleTotal = 1.0;
    protected double m_scaleValue;
    protected double m_xTransValue;
    protected double m_yTransValue;
    protected double m_zTransValue;
    protected PdVector m_vecAlt = new PdVector(3);
    protected PdVector m_vec = new PdVector(3);
    protected PdVector m_rotAxis = new PdVector(3);
    protected double[] m_prevNormLoc = new double[2];
    protected double[] m_currNormLoc = new double[2];
    protected PvDisplay m_display;
    private static /* synthetic */ Class class$jv$viewer$PvModelCamera;

    private void translateH3XW(PdMatrix pdMatrix, double d) {
        pdMatrix.setIdentity();
        pdMatrix.m_data[0][0] = PuMath.cosh(d);
        pdMatrix.m_data[0][1] = PuMath.sinh(d);
        pdMatrix.m_data[1][0] = PuMath.sinh(d);
        pdMatrix.m_data[1][1] = PuMath.cosh(d);
    }

    protected void mouseAnimate() {
        this.m_model.leftMult(this.m_incrModel);
        this.m_modelInv.rightMult(this.m_incrModelInv);
    }

    protected void mousePressed(int n, int n2) {
        this.normalizedCoordsFromViewport(this.m_prevNormLoc, n, n2);
        this.m_scaleValue = Math.exp(this.m_prevNormLoc[0] + this.m_prevNormLoc[1]);
        this.m_xTransValue = this.m_prevNormLoc[0] * this.SIZE / 2.0;
        this.m_yTransValue = this.m_prevNormLoc[1] * this.SIZE / 2.0;
        this.m_zTransValue = this.m_xTransValue + this.m_yTransValue;
        this.m_vecAlt.invStereoProj(this.m_prevNormLoc[0], this.m_prevNormLoc[1]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void mouseDragged(int n, int n2) {
        this.normalizedCoordsFromViewport(this.m_currNormLoc, n, n2);
        this.m_incrModel.setIdentity();
        this.m_incrModelInv.setIdentity();
        int n3 = this.m_display.getAmbientSpace();
        if (this.m_mode == 1) {
            double d;
            if (n3 != 0 && n3 != 1) return;
            double d2 = Math.exp(this.m_currNormLoc[0] + this.m_currNormLoc[1]);
            this.m_incrModel.m_data[0][0] = d = d2 / this.m_scaleValue;
            this.m_incrModel.m_data[1][1] = d;
            this.m_incrModel.m_data[2][2] = d;
            this.m_incrModelInv.m_data[0][0] = 1.0 / d;
            this.m_incrModelInv.m_data[1][1] = 1.0 / d;
            this.m_incrModelInv.m_data[2][2] = 1.0 / d;
            this.m_scaleTotal *= d;
            this.m_scaleValue = d2;
        } else if (this.m_mode == 3) {
            double d = this.m_currNormLoc[0] * this.SIZE / 2.0;
            double d3 = this.m_currNormLoc[1] * this.SIZE / 2.0;
            double d4 = d - this.m_xTransValue;
            double d5 = d3 - this.m_yTransValue;
            this.m_xTransValue = d;
            this.m_yTransValue = d3;
            if (n3 == 0 || n3 == 1) {
                this.m_incrModel.m_data[0][3] = d4;
                this.m_incrModel.m_data[1][3] = d5;
                this.m_incrModelInv.m_data[0][3] = -d4;
                this.m_incrModelInv.m_data[1][3] = -d5;
            } else {
                if (n3 == 2) {
                    PdMatrix pdMatrix = new PdMatrix(4);
                    this.rotateS3XW(pdMatrix, d4 *= -Math.PI / this.SIZE);
                    this.rotateS3YW(this.m_incrModel, d5 *= -Math.PI / this.SIZE);
                    this.m_incrModel.rightMult(pdMatrix);
                    this.m_incrModelInv.transpose(this.m_incrModel);
                    this.m_model.leftMult(this.m_incrModel);
                    this.m_modelInv.rightMult(this.m_incrModelInv);
                    return;
                }
                if (n3 == 3) {
                    PdMatrix pdMatrix = new PdMatrix(4);
                    this.translateH3XW(pdMatrix, d4 *= -Math.PI / this.SIZE);
                    this.translateH3YW(this.m_incrModel, d5 *= -Math.PI / this.SIZE);
                    this.m_incrModel.rightMult(pdMatrix);
                    this.m_incrModelInv.transpose(this.m_incrModel);
                    this.m_model.leftMult(this.m_incrModel);
                    this.m_modelInv.rightMult(this.m_incrModelInv);
                    return;
                }
            }
        } else if (this.m_mode == 4) {
            double d = (this.m_currNormLoc[0] + this.m_currNormLoc[1]) * this.SIZE / 2.0;
            double d6 = d - this.m_zTransValue;
            this.m_zTransValue = d;
            if (n3 == 0 || n3 == 1) {
                this.m_incrModel.m_data[2][3] = d6;
                this.m_incrModelInv.m_data[2][3] = -d6;
            } else {
                if (n3 == 2) {
                    this.rotateS3ZW(this.m_incrModel, d6 *= -Math.PI / this.SIZE);
                    this.m_incrModelInv.transpose(this.m_incrModel);
                    this.m_model.leftMult(this.m_incrModel);
                    this.m_modelInv.rightMult(this.m_incrModelInv);
                    return;
                }
                if (n3 == 3) {
                    this.translateH3ZW(this.m_incrModel, d6);
                    this.m_incrModelInv.transpose(this.m_incrModel);
                    this.m_model.leftMult(this.m_incrModel);
                    this.m_modelInv.rightMult(this.m_incrModelInv);
                    return;
                }
            }
        } else {
            if (this.m_mode != 0) return;
            this.m_vec.invStereoProj(this.m_currNormLoc[0], this.m_currNormLoc[1]);
            double d = Math.acos(this.m_vec.dot(this.m_vecAlt));
            if (d < 1.0E-10) {
                return;
            }
            this.m_rotAxis.cross(this.m_vecAlt, this.m_vec);
            this.m_vecAlt.copy(this.m_vec);
            if (this.m_rotAxis.length() < 1.0E-10) {
                return;
            }
            if (!PuReflect.makeRotation(this.m_incrModel, this.m_rotAxis, d)) {
                return;
            }
            this.m_incrModelInv.transpose(this.m_incrModel);
            if (n3 == 2 || n3 == 3) {
                this.m_model.leftMult(this.m_incrModel);
                this.m_modelInv.rightMult(this.m_incrModelInv);
                return;
            }
        }
        this.m_model.leftMult(this.m_viewCamera);
        this.m_model.leftMult(this.m_incrModel);
        this.m_model.leftMult(this.m_viewInvCamera);
        this.m_modelInv.rightMult(this.m_viewInvCamera);
        this.m_modelInv.rightMult(this.m_incrModelInv);
        this.m_modelInv.rightMult(this.m_viewCamera);
    }

    public void setCurrentView(PdMatrix pdMatrix, PdMatrix pdMatrix2) {
        this.m_viewCamera.copy(pdMatrix);
        this.m_viewInvCamera.copy(pdMatrix2);
    }

    public PvModelCamera(PvDisplay pvDisplay) {
        this.m_display = pvDisplay;
        if (this.getClass() == (class$jv$viewer$PvModelCamera != null ? class$jv$viewer$PvModelCamera : (class$jv$viewer$PvModelCamera = PvModelCamera.class$("jv.viewer.PvModelCamera")))) {
            this.init();
        }
    }

    public int getMode() {
        return this.m_mode;
    }

    public void setMode(int n) {
        this.m_mode = n;
    }

    public PdMatrix getModelInvMatrix() {
        return this.m_modelInv;
    }

    private void rotateS3ZW(PdMatrix pdMatrix, double d) {
        pdMatrix.setIdentity();
        pdMatrix.m_data[2][2] = Math.cos(d);
        pdMatrix.m_data[2][3] = -Math.sin(d);
        pdMatrix.m_data[3][2] = Math.sin(d);
        pdMatrix.m_data[3][3] = Math.cos(d);
    }

    private void translateH3YW(PdMatrix pdMatrix, double d) {
        pdMatrix.setIdentity();
        pdMatrix.m_data[0][0] = PuMath.cosh(d);
        pdMatrix.m_data[0][2] = PuMath.sinh(d);
        pdMatrix.m_data[2][0] = PuMath.sinh(d);
        pdMatrix.m_data[2][2] = PuMath.cosh(d);
    }

    private void rotateS3XW(PdMatrix pdMatrix, double d) {
        pdMatrix.setIdentity();
        pdMatrix.m_data[0][0] = Math.cos(d);
        pdMatrix.m_data[0][3] = -Math.sin(d);
        pdMatrix.m_data[3][0] = Math.sin(d);
        pdMatrix.m_data[3][3] = Math.cos(d);
    }

    protected void normalizedCoordsFromViewport(double[] dArray, int n, int n2) {
        double d = (double)n + 0.5;
        double d2 = this.m_nHeight - 1.0 - (double)n2 - 0.5;
        double d3 = Math.min(this.m_nWidth, this.m_nHeight);
        if (d3 < 1.0E-10) {
            dArray[1] = 0.0;
            dArray[0] = 0.0;
            return;
        }
        dArray[0] = 2.0 / (d3 - 1.0) * d - (this.m_nWidth - 1.0) / d3;
        dArray[1] = 2.0 / (d3 - 1.0) * d2 - (this.m_nHeight - 1.0) / d3;
    }

    public PdMatrix getModelMatrix() {
        return this.m_model;
    }

    public void setModelMatrix(PdMatrix pdMatrix) {
        this.m_vecAlt.set(0.0, 0.0, 1.0);
        this.m_model.copy(pdMatrix);
        this.m_modelInv.invert34(pdMatrix);
        this.m_incrModel.setIdentity();
        this.m_incrModelInv.setIdentity();
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void rotateS3YW(PdMatrix pdMatrix, double d) {
        pdMatrix.setIdentity();
        pdMatrix.m_data[1][1] = Math.cos(d);
        pdMatrix.m_data[1][3] = -Math.sin(d);
        pdMatrix.m_data[3][1] = Math.sin(d);
        pdMatrix.m_data[3][3] = Math.cos(d);
    }

    protected void resizeImage(double d, double d2) {
        if (d == 0.0 || d2 == 0.0) {
            PsDebug.warning("window has a dimension==0");
            return;
        }
        this.m_nWidth = d;
        this.m_nHeight = d2;
    }

    public void init() {
        super.init();
        this.m_vecAlt.set(0.0, 0.0, 1.0);
        this.m_model.setIdentity();
        this.m_modelInv.setIdentity();
        this.m_incrModel.setIdentity();
        this.m_incrModelInv.setIdentity();
    }

    private void translateH3ZW(PdMatrix pdMatrix, double d) {
        pdMatrix.setIdentity();
        pdMatrix.m_data[0][0] = PuMath.cosh(d);
        pdMatrix.m_data[0][3] = PuMath.sinh(d);
        pdMatrix.m_data[3][0] = PuMath.sinh(d);
        pdMatrix.m_data[3][3] = PuMath.cosh(d);
    }
}

