/*
 * Decompiled with CFR 0.152.
 */
package jv.viewer;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import jv.anim.PsAnimation;
import jv.loader.PSGr;
import jv.loader.PgFileDialog;
import jv.loader.PgLoader;
import jv.loader.PjImportModel;
import jv.loader.PjImportModel_Dialog;
import jv.loader.PsCategoryList_IP;
import jv.loader.PsXmlLoader;
import jv.number.PdColor;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsConsole;
import jv.object.PsDebug;
import jv.object.PsDialog;
import jv.object.PsMainFrame;
import jv.object.PsObject;
import jv.object.PsUtil;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvDisplayIf;
import jv.project.PvViewerIf;
import jv.rsrc.PsJavaView;
import jv.rsrc.PsModelInfo;
import jv.vecmath.PdVector;
import jv.viewer.PsAboutApplet;
import jv.viewer.PsAboutDialog;
import jv.viewer.PvControl;
import jv.viewer.PvDisplay;
import jv.viewer.PvDisplayHelp;

public final class PvViewer
extends PsObject
implements PvViewerIf,
KeyListener,
WindowListener,
Serializable {
    private static final String[][] PROJECTS = new String[][]{{PsConfig.getMessage("Curves"), PsConfig.getMessage("ClassicCurves"), "vgp.curve.common.PjCurve"}, {PsConfig.getMessage("Curves"), PsConfig.getMessage("CycloidCurves"), "vgp.curve.cycloid.PjCycloid"}, {PsConfig.getMessage("Curves"), PsConfig.getMessage("Geodesics"), "vgp.curve.geodesic.PjGeodesic"}, {PsConfig.getMessage("Curves"), PsConfig.getMessage("TorusKnots"), "vgp.curve.torusknot.PjTorusKnot"}, {PsConfig.getMessage("Games"), PsConfig.getMessage("Game of Life"), "vgp.game.life.PjLife"}, {PsConfig.getMessage("Games"), PsConfig.getMessage("Minesweeper"), "vgp.game.mines.PjMinesweeper"}, {PsConfig.getMessage("Images"), PsConfig.getMessage("MandelbrotSet"), "vgp.tutor.fractal.PjFractalImage"}, {PsConfig.getMessage("Images"), PsConfig.getMessage("TexturedCube"), "vgp.tutor.texture.PjTextureCube"}, {PsConfig.getMessage("Maps"), PsConfig.getMessage("ConformalMaps"), "vgp.discrete.conformal.PjConformal"}, {PsConfig.getMessage("Maps"), PsConfig.getMessage("ConjugateMaps"), "vgp.discrete.conjugate.PjConjugate"}, {PsConfig.getMessage("Maps"), PsConfig.getMessage("HarmonicMaps"), "vgp.discrete.harmonic.PjHarmonic"}, {PsConfig.getMessage("Models"), PsConfig.getMessage("BrowseModels"), "jv.loader.PjImportModel"}, {PsConfig.getMessage("Models"), PsConfig.getMessage("KeyframeAnimation"), "vgp.tutor.key.PjKeyframe"}, {PsConfig.getMessage("Numeric"), PsConfig.getMessage("ODESolver"), "vgp.tutor.ode.PjExprOde"}, {PsConfig.getMessage("Numeric"), PsConfig.getMessage("EnergyMinimization"), "vgp.discrete.harmonic.PjHarmonic"}, {PsConfig.getMessage("Numeric"), PsConfig.getMessage("RootFinder"), "vgp.tutor.rootFinder.PjRootFinder"}, {PsConfig.getMessage("Surfaces"), PsConfig.getMessage("ClassicSurfaces"), "vgp.surface.common.PjSurface"}, {PsConfig.getMessage("Surfaces"), PsConfig.getMessage("DiscreteCatenoid"), "vgp.discrete.catenoid.PjCatenoid"}, {PsConfig.getMessage("Surfaces"), PsConfig.getMessage("Weierstrass"), "vgp.minimal.weier.PjWeierstrass"}, {PsConfig.getMessage("Surfaces"), PsConfig.getMessage("ParametrizedSurface"), "vgp.tutor.parm.PjParmSurface"}, {PsConfig.getMessage("Surfaces"), PsConfig.getMessage("PlatonicSolids"), "vgp.discrete.platonic.PjPlatonic"}, {PsConfig.getMessage("Tutor"), PsConfig.getMessage("FirstProject"), "vgp.tutor.firstProject.MyProject"}, {PsConfig.getMessage("Tutor"), PsConfig.getMessage("LSystem"), "vgp.tutor.lsystem.PjLSystem"}, {PsConfig.getMessage("Tutor"), PsConfig.getMessage("CameraEvents"), "vgp.tutor.eventCamera.PjEventCamera"}, {PsConfig.getMessage("Tutor"), PsConfig.getMessage("PickEvents"), "vgp.tutor.pick.PjPickEvent"}, {PsConfig.getMessage("Tutor"), PsConfig.getMessage("PolygonSet"), "vgp.tutor.polygonSet.PjPolygonSet"}, {PsConfig.getMessage("Tutor"), PsConfig.getMessage("RivaraBisection"), "vgp.tutor.rivara.PjRivara"}, {PsConfig.getMessage("Tutor"), PsConfig.getMessage("ScalarField"), "vgp.tutor.height.PjHeight"}, {PsConfig.getMessage("Tutor"), PsConfig.getMessage("TextureMaps"), "vgp.tutor.texture.PjTexturedSurface"}, {PsConfig.getMessage("Tutor"), PsConfig.getMessage("4DCube"), "vgp.tutor.transform.PjTransform"}, {PsConfig.getMessage("Tutor"), PsConfig.getMessage("VectorField"), "vgp.tutor.vectorfield.PjVectorfield"}, {PsConfig.getMessage("Vector"), PsConfig.getMessage("PotentialFields"), "vgp.tutor.vectorfield.PjVectorfield"}, {PsConfig.getMessage("Vector"), PsConfig.getMessage("HodgeDecomposition"), "vgp.vector.hodge.PjHodge"}, {PsConfig.getMessage("Vector"), PsConfig.getMessage("LineIntegralConv"), "vgp.vector.vectorfield.PjVectorfield"}};
    private static final String[][] GEOMETRIES = new String[][]{{PsConfig.getMessage("Geometry"), PsConfig.getMessage("Point Set"), "jv.geom.PgPointSet"}, {PsConfig.getMessage("Geometry"), PsConfig.getMessage("Polygon"), "jv.geom.PgPolygon"}, {PsConfig.getMessage("Geometry"), PsConfig.getMessage("Polygon Set"), "jv.geom.PgPolygonSet"}, {PsConfig.getMessage("Geometry"), PsConfig.getMessage("Element Set"), "jv.geom.PgElementSet"}};
    protected PsJavaView m_jvRsrc;
    protected Applet m_applet;
    protected Frame m_frame;
    protected String[][] m_parm;
    protected Hashtable m_displayList;
    protected PvDisplayIf m_mainDisplay;
    protected PvDisplayIf m_display;
    protected PvControl m_control;
    protected boolean m_controlShow = false;
    protected transient PvDisplayHelp m_help;
    protected transient PjImportModel_Dialog m_importModelDialog;
    protected int[] m_controlSize = new int[]{5, 5, 390, 680};
    protected int[] m_aboutSize = new int[]{10, 10, 400, 450};
    protected int[] m_helpSize = new int[]{10, 10, 400, 450};
    protected int[] m_consoleSize = new int[]{10, 10, 500, 350};
    protected int[] m_animationSize = new int[]{10, 10, 400, 300};
    protected int[] m_newProjectSize = new int[]{10, 10, 400, 350};
    protected int[] m_importModelSize = new int[]{10, 10, 400, 400};
    protected int[] m_exportBounds = new int[]{10, 10, 400, 600};
    protected String m_imageDirName = null;
    protected String m_importDirName = null;
    protected String m_exportDirName = null;
    protected String m_serialDirName = null;
    protected Hashtable m_geometryCategory;
    protected Hashtable m_geometryClass;
    protected Hashtable m_projectCategory;
    protected Hashtable m_projectList;
    protected Hashtable m_projectClass;
    protected Hashtable m_projectParms;
    protected PjProject m_currentProject;
    protected PgGeometryIf m_currentGeometry;
    private int m_showPanel = -1;
    private boolean m_bShowingDialog = false;
    private boolean m_bStarted = false;
    protected Hashtable m_frameList;

    public int getNumDisplays() {
        if (this.m_displayList == null) {
            return 0;
        }
        return this.m_displayList.size();
    }

    public boolean showDialog(int n) {
        Serializable serializable;
        Point point;
        PgFileDialog pgFileDialog = null;
        String string = null;
        String string2 = null;
        if (this.m_control != null && this.m_control.isShowing()) {
            point = this.m_control.getLocation();
            serializable = this.m_control.getSize();
            this.m_controlSize[0] = ((Dimension)serializable).width;
            this.m_controlSize[1] = ((Dimension)serializable).height;
        } else {
            point = new Point(this.m_controlSize[0], this.m_controlSize[1]);
        }
        this.m_bShowingDialog = true;
        switch (n) {
            case 21: {
                serializable = new PsAboutDialog(PsConfig.getFrame());
                ((Component)serializable).setLocation(point.x + this.m_aboutSize[0], point.y + this.m_aboutSize[1]);
                ((Component)serializable).setSize(this.m_aboutSize[2], this.m_aboutSize[3]);
                ((Container)serializable).validate();
                ((Dialog)serializable).setModal(true);
                ((Component)serializable).setVisible(true);
                break;
            }
            case 22: {
                PsAboutApplet psAboutApplet = new PsAboutApplet(PsConfig.getFrame());
                ((Component)psAboutApplet).setLocation(point.x + this.m_aboutSize[0] + 20, point.y + this.m_aboutSize[1] + 20);
                ((Component)psAboutApplet).setSize(this.m_aboutSize[2], this.m_aboutSize[3]);
                psAboutApplet.validate();
                psAboutApplet.setModal(true);
                ((Component)psAboutApplet).setVisible(true);
                break;
            }
            case 20: {
                if (this.m_jvRsrc == null) break;
                this.m_jvRsrc.showInfoPanel();
                break;
            }
            case 23: {
                PsDialog psDialog = null;
                if (this.m_currentProject != null && this.m_currentProject.hasAnimation()) {
                    psDialog = this.m_currentProject.getAnimation().getAnimationPanel();
                }
                if (psDialog == null) {
                    PsDebug.warning("missing animation");
                    this.m_bShowingDialog = false;
                    return false;
                }
                ((Component)psDialog).setLocation(point.x, point.y + this.m_controlSize[3] - this.m_animationSize[3]);
                ((Component)psDialog).setSize(this.m_animationSize[2], this.m_animationSize[3]);
                ((Component)psDialog).setVisible(true);
                break;
            }
            case 25: {
                boolean bl = PsDebug.hasConsole();
                PsConsole psConsole = PsDebug.getConsole();
                if (psConsole == null) {
                    PsDebug.error("missing console panel", this);
                    this.m_bShowingDialog = false;
                    return false;
                }
                if (!bl) {
                    if (this.m_control != null && this.m_control.isShowing()) {
                        psConsole.setLocation(point.x, point.y + this.m_controlSize[3]);
                    } else {
                        psConsole.setLocation(this.m_consoleSize[0], this.m_consoleSize[1]);
                    }
                    ((Component)psConsole).setSize(this.m_consoleSize[2], this.m_consoleSize[3]);
                }
                ((Component)psConsole).setVisible(true);
                break;
            }
            case 24: {
                if (this.m_control == null) {
                    this.m_control = this.getControl();
                    if (this.m_control == null) {
                        PsDebug.warning("missing control panel");
                        this.m_bShowingDialog = false;
                        return false;
                    }
                }
                this.m_control.setVisible(true);
                break;
            }
            case 26: {
                if (!PsConfig.isApplication() && this.m_applet != null) {
                    try {
                        URL uRL = new URL(PsConfig.getCodeBase() + "jars/help.html");
                        uRL.openConnection();
                        uRL.openStream();
                        this.m_applet.getAppletContext().showDocument(uRL, "Help on Viewer");
                        break;
                    }
                    catch (Exception exception) {
                        PsDebug.warning("file not found = " + "jars/help.html");
                    }
                }
                if (this.m_help == null) {
                    this.m_help = new PvDisplayHelp(PsConfig.getFrame());
                }
                this.m_help.setLocation(point.x + this.m_consoleSize[2] / 2, point.y + this.m_consoleSize[3] / 5);
                ((Component)this.m_help).setSize(this.m_helpSize[2], this.m_helpSize[3]);
                ((Component)this.m_help).setVisible(true);
                break;
            }
            case 27: 
            case 28: {
                Object object;
                Enumeration<Object> enumeration;
                PsDialog psDialog;
                String[] stringArray = PvViewer.getCategories(this.m_projectCategory);
                String[][] stringArray2 = PvViewer.getEntries(this.m_projectCategory, stringArray);
                if (stringArray2 == null) {
                    PsDebug.warning("no registered projects");
                    break;
                }
                PsCategoryList_IP psCategoryList_IP = new PsCategoryList_IP();
                psCategoryList_IP.setCategories(stringArray, stringArray2);
                if (n == 28) {
                    psCategoryList_IP.setTitle("Project is added to current scene");
                    psDialog = new PsDialog(PsConfig.getFrame(), "Select Add Project", true);
                } else {
                    psCategoryList_IP.setTitle("New project replaces current scene");
                    psDialog = new PsDialog(PsConfig.getFrame(), "Select New Project", true);
                }
                psDialog.setLayout(new BorderLayout());
                psDialog.add("Center", psCategoryList_IP);
                psDialog.add("South", psDialog.getBottomButtons(5));
                psDialog.setLocation(point.x + this.m_newProjectSize[0], point.y + this.m_newProjectSize[1]);
                ((Component)psDialog).setSize(this.m_newProjectSize[2], this.m_newProjectSize[3]);
                psDialog.validate();
                ((Component)psDialog).setVisible(true);
                int n2 = psDialog.getUserAction();
                if (n2 != 4) break;
                String string3 = psCategoryList_IP.getSelectedEntry();
                if (string3 == null || string3.equals("")) {
                    this.m_bShowingDialog = false;
                    return false;
                }
                if (n == 27) {
                    if (this.m_displayList != null) {
                        enumeration = this.m_displayList.keys();
                        while (enumeration.hasMoreElements()) {
                            object = (String)enumeration.nextElement();
                            if (this.m_mainDisplay != null && this.m_mainDisplay == this.getDisplay((String)object)) {
                                this.selectDisplay((String)object);
                                this.m_mainDisplay.setMajorMode(0);
                                this.m_mainDisplay.init();
                                continue;
                            }
                            this.removeDisplay((String)object);
                        }
                        if (this.m_display != null) {
                            this.m_display.removeGeometries();
                        }
                    }
                    enumeration = this.m_projectList.keys();
                    while (enumeration.hasMoreElements()) {
                        this.removeProject((String)enumeration.nextElement());
                    }
                }
                if (!this.selectProject(string3)) {
                    this.m_bShowingDialog = false;
                    return false;
                }
                if (!PsConfig.isApplication()) break;
                enumeration = this.m_frameList.elements();
                while (enumeration.hasMoreElements()) {
                    object = (Frame)enumeration.nextElement();
                    String string4 = this.getFrameDisplayName((Frame)object);
                    if (string4 == null || !string4.equals(this.m_mainDisplay.getName())) continue;
                    ((Frame)object).setTitle(PsConfig.getProgram() + " v" + PsConfig.getVersion() + ": " + this.m_currentProject.getName());
                }
                break;
            }
            case 29: 
            case 30: {
                PsDialog psDialog;
                String[] stringArray = PvViewer.getCategories(this.m_geometryCategory);
                String[][] stringArray3 = PvViewer.getEntries(this.m_geometryCategory, stringArray);
                if (stringArray3 == null) {
                    PsDebug.warning("no registered geometrys");
                    break;
                }
                PsCategoryList_IP psCategoryList_IP = new PsCategoryList_IP();
                psCategoryList_IP.setCategories(stringArray, stringArray3);
                if (n == 30) {
                    psCategoryList_IP.setTitle("Empty geometry is added to current scene");
                    psDialog = new PsDialog(PsConfig.getFrame(), "Select Add Geometry", true);
                } else {
                    psCategoryList_IP.setTitle("New geometry replaces current scene");
                    psDialog = new PsDialog(PsConfig.getFrame(), "Select New Geometry", true);
                }
                psDialog.setLayout(new BorderLayout());
                psDialog.add("Center", psCategoryList_IP);
                psDialog.add("South", psDialog.getBottomButtons(5));
                psDialog.setLocation(point.x + this.m_newProjectSize[0], point.y + this.m_newProjectSize[1]);
                ((Component)psDialog).setSize(this.m_newProjectSize[2], this.m_newProjectSize[3]);
                psDialog.validate();
                ((Component)psDialog).setVisible(true);
                int n3 = psDialog.getUserAction();
                if (n3 != 4) break;
                String string5 = psCategoryList_IP.getSelectedEntry();
                if (string5 == null || string5.equals("")) {
                    this.m_bShowingDialog = false;
                    return false;
                }
                PgGeometryIf pgGeometryIf = this.getGeometry(string5);
                if (pgGeometryIf == null) {
                    PsDebug.warning("failed to create geometry.");
                    this.m_bShowingDialog = false;
                    return false;
                }
                if (this.m_display == null) {
                    PsDebug.warning("missing display.");
                    this.newDisplay(pgGeometryIf.getName());
                }
                this.m_display.removeGeometries();
                if (n == 29) {
                    Enumeration enumeration = this.m_projectList.keys();
                    while (enumeration.hasMoreElements()) {
                        PjProject pjProject = this.getProject((String)enumeration.nextElement());
                        pjProject.removeGeometries();
                    }
                }
                this.m_display.addGeometry(pgGeometryIf);
                if (this.m_currentProject == null) break;
                this.m_currentProject.setParent(pgGeometryIf);
                this.m_currentProject.addGeometry(pgGeometryIf);
                this.m_currentProject.selectGeometry(pgGeometryIf);
                break;
            }
            case 31: {
                if (this.m_importModelDialog != null && this.m_importModelDialog.isShowing()) break;
                PjImportModel pjImportModel = new PjImportModel();
                this.m_importModelDialog = new PjImportModel_Dialog(PsConfig.getFrame());
                this.m_importModelDialog.setParent(pjImportModel);
                this.m_importModelDialog.update(pjImportModel);
                this.m_importModelDialog.setLocation(point.x + this.m_importModelSize[0], point.y + this.m_importModelSize[1]);
                ((Component)this.m_importModelDialog).setSize(this.m_importModelSize[2], this.m_importModelSize[3]);
                if (this.m_currentProject == null) {
                    this.m_importModelDialog.setModal(true);
                    if (this.m_display != null && pjImportModel.getGeometry() != null) {
                        pjImportModel.setDisplay(this.m_display);
                        ((Component)this.m_importModelDialog).setVisible(true);
                        pjImportModel.removeDisplay(this.m_display);
                        if (pjImportModel.getConfirm() == PjImportModel.CONFIRM_CANCEL) {
                            int n4 = pjImportModel.getNumGeometries();
                            int n5 = 0;
                            while (n5 < n4) {
                                this.m_display.removeGeometry(pjImportModel.getGeometry(n5));
                                ++n5;
                            }
                            this.m_display.update(this.m_display);
                        } else {
                            this.m_display.selectGeometry(pjImportModel.getGeometry(0));
                        }
                        this.m_bShowingDialog = false;
                        return true;
                    }
                    PsDebug.warning("no project or display available to add geometry.");
                    this.m_bShowingDialog = false;
                    return false;
                }
                pjImportModel.setParentProject(this.m_currentProject);
                ((Component)this.m_importModelDialog).setVisible(true);
                break;
            }
            case 32: {
                if (this.m_importDirName == null) {
                    this.m_importDirName = PsConfig.getCodeBase() + "models/";
                }
                pgFileDialog = new PgFileDialog(PsConfig.getFrame(), "Open Geometry", 0);
                pgFileDialog.setDirectory(this.m_importDirName);
                pgFileDialog.setVisible(true);
                string = pgFileDialog.getFile();
                if (string == null) break;
                this.m_importDirName = pgFileDialog.getDirectory();
                string = this.m_importDirName + string;
                string.trim();
                PjImportModel pjImportModel = new PjImportModel();
                if (this.m_currentProject != null) {
                    pjImportModel.setParentProject(this.m_currentProject);
                }
                if (!pjImportModel.load(string) || this.m_currentProject != null || this.m_display == null) break;
                int n6 = pjImportModel.getNumGeometries();
                int n7 = 0;
                while (n7 < n6) {
                    this.m_display.addGeometry(pjImportModel.getGeometry(n7));
                    ++n7;
                }
                if (n6 != 0) {
                    this.m_display.selectGeometry(pjImportModel.getGeometry(0));
                }
                this.m_display.update(this.m_display);
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                string2 = n == 33 ? "byu" : (n == 34 ? "fe" : (n == 35 ? "jvx" : (n == 36 ? "mgs" : (n == 37 ? "mpl" : (n == 38 ? "obj" : (n == 39 ? "off" : (n == 40 ? "wrl" : "jvx")))))));
                if (PsConfig.isApplication()) {
                    if (this.m_exportDirName == null) {
                        this.m_exportDirName = PsConfig.getCodeBase() + "models/";
                    }
                    pgFileDialog = new PgFileDialog(PsConfig.getFrame(), "Save Geometry", 1);
                    pgFileDialog.setDirectory(this.m_exportDirName);
                    pgFileDialog.setExtension(string2);
                    pgFileDialog.setVisible(true);
                    string = pgFileDialog.getFullFileName();
                    if (string == null) {
                        this.m_bShowingDialog = false;
                        return false;
                    }
                    this.m_exportDirName = pgFileDialog.getDirectory();
                }
                if (string == null) {
                    string = "javaview." + string2;
                }
                this.export(n, string);
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                if (!PsConfig.isApplication()) {
                    PsDebug.warning("cannot export image in applet mode.");
                    this.m_bShowingDialog = false;
                    return false;
                }
            }
            case 46: 
            case 47: {
                double d;
                string2 = n == 41 ? "gif" : (n == 42 ? "001.gif" : (n == 43 ? "ppm" : (n == 44 ? "001.ppm" : (n == 47 ? "ps" : (n == 46 ? "eps" : "ppm")))));
                if (this.m_imageDirName == null) {
                    this.m_imageDirName = PsConfig.getCodeBase() + "images/";
                }
                if (PsConfig.isApplication()) {
                    pgFileDialog = new PgFileDialog(PsConfig.getFrame(), "Save Image", 1);
                    pgFileDialog.setDirectory(this.m_imageDirName);
                    pgFileDialog.setExtension(string2);
                    pgFileDialog.setVisible(true);
                    string = pgFileDialog.getFullFileName();
                    if (string == null) {
                        this.m_bShowingDialog = false;
                        return false;
                    }
                    this.m_imageDirName = pgFileDialog.getDirectory();
                }
                if (string == null) {
                    string = "javaview." + string2;
                }
                if (n != 42 && n != 44) {
                    this.m_bShowingDialog = false;
                    return this.export(n, string);
                }
                PsAnimation psAnimation = null;
                if (this.m_currentProject != null && this.m_currentProject.hasAnimation() && (psAnimation = this.m_currentProject.getAnimation()).isRunning()) {
                    psAnimation.stop();
                }
                double d2 = psAnimation.getMinTime();
                double d3 = psAnimation.getMaxTime();
                int n8 = 1 + (int)((d3 - d2) / (d = psAnimation.getTimePageIncr()));
                if (n8 > 999) {
                    PsDebug.warning("too many images, 999 < num = " + n8);
                    this.m_bShowingDialog = false;
                    return false;
                }
                string2 = n == 42 ? "gif" : "ppm";
                double d4 = d2;
                String string6 = PsUtil.getFileBaseName(pgFileDialog.getFile());
                if (string6.endsWith("001")) {
                    string6 = PsUtil.getFileBaseName(string6);
                }
                int n9 = 0;
                while (n9 < n8) {
                    if (psAnimation != null) {
                        psAnimation.setTime(d4);
                    } else if (this.m_display != null) {
                        this.m_display.incrementAutoRotation();
                    }
                    d4 += d;
                    string = n9 < 9 ? string6 + ".00" + (n9 + 1) + "." + string2 : (n9 < 99 ? string6 + ".0" + (n9 + 1) + "." + string2 : string6 + "." + (n9 + 1) + "." + string2);
                    if (!this.export(n, this.m_imageDirName + "/" + string)) {
                        PsDebug.warning("error during animation export.");
                        this.m_bShowingDialog = false;
                        return false;
                    }
                    ++n9;
                }
                break;
            }
            default: {
                PsDebug.warning("invalid dialog index = " + n);
                this.m_bShowingDialog = false;
                return false;
            }
        }
        this.m_bShowingDialog = false;
        return true;
    }

    public PsDialog getDialog(int n) {
        switch (n) {
            case 23: {
                PsDialog psDialog = null;
                if (this.m_currentProject != null && this.m_currentProject.getAnimation() != null) {
                    psDialog = this.m_currentProject.getAnimation().getAnimationPanel();
                }
                return psDialog;
            }
            case 25: {
                return PsDebug.getConsole();
            }
        }
        PsDebug.warning("invalid dialog index");
        return null;
    }

    private static String[][] getEntries(Hashtable hashtable, String[] stringArray) {
        if (hashtable == null || stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        String[][] stringArray2 = new String[n][];
        int n2 = hashtable.size();
        int n3 = 0;
        while (n3 < n) {
            String[] stringArray3 = new String[n2];
            int n4 = 0;
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)hashtable.get(string);
                if (!string2.equals(stringArray[n3])) continue;
                stringArray3[n4++] = string;
            }
            stringArray2[n3] = new String[n4];
            if (n4 != 0) {
                int n5 = 0;
                while (n5 < n4) {
                    stringArray2[n3][n5] = stringArray3[n5];
                    ++n5;
                }
                PuString.sort(stringArray2[n3]);
            }
            ++n3;
        }
        return stringArray2;
    }

    public boolean hideDialog(int n) {
        switch (n) {
            case 23: {
                Component component = null;
                if (this.m_currentProject != null && this.m_currentProject.getAnimation() != null) {
                    component = this.m_currentProject.getAnimation().getAnimationPanel();
                }
                if (component == null) {
                    return true;
                }
                component.setVisible(false);
                return true;
            }
            case 25: {
                if (PsDebug.hasConsole()) {
                    ((Component)PsDebug.getConsole()).setVisible(false);
                }
                return true;
            }
            case 24: {
                this.m_controlShow = false;
                if (this.m_control != null) {
                    this.m_control.setVisible(false);
                }
                return true;
            }
            case 26: {
                if (this.m_help != null) {
                    ((Component)this.m_help).setVisible(false);
                }
                return true;
            }
        }
        return false;
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        switch (n) {
            case 112: {
                this.showDialog(24);
                return;
            }
            case 113: {
                this.hideDialog(24);
                return;
            }
            case 114: {
                this.showDialog(25);
                return;
            }
            case 115: {
                this.showDialog(23);
                return;
            }
        }
        if (!keyEvent.isControlDown()) {
            return;
        }
        switch (n) {
            case 88: {
                if (!keyEvent.isShiftDown()) break;
                this.destroy();
                break;
            }
            case 83: {
                this.showDialog(24);
                break;
            }
            case 68: {
                this.showDialog(25);
                break;
            }
            case 65: {
                this.showDialog(23);
                break;
            }
            case 80: {
                if (keyEvent.isShiftDown() && this.m_control != null) {
                    this.m_control.releasePanel(10);
                    break;
                }
                this.showPanel(10);
                this.enablePanel(10, true);
                this.showDialog(24);
                break;
            }
            case 73: {
                this.showPanel(12);
                this.enablePanel(12, true);
                this.showDialog(24);
                break;
            }
            case 77: {
                this.showPanel(13);
                this.enablePanel(13, true);
                this.showDialog(24);
                break;
            }
            case 79: {
                if (PsConfig.isApplication()) {
                    this.showDialog(32);
                    break;
                }
                this.showDialog(31);
                break;
            }
            case 67: {
                this.showPanel(15);
                this.showDialog(24);
                break;
            }
            case 86: {
                this.showPanel(16);
                this.showDialog(24);
                break;
            }
            default: {
                return;
            }
        }
        if (this.m_display != null) {
            ((PvDisplay)this.m_display).requestFocus();
        }
    }

    public boolean hasProject(String string) {
        return this.m_projectList.contains(string);
    }

    public boolean removeProject(String string) {
        if (string == null) {
            PsDebug.warning("missing project name");
            return false;
        }
        if (this.m_currentProject == null) {
            return false;
        }
        PjProject pjProject = this.getProject(string);
        if (this.m_currentProject == pjProject) {
            if (this.m_control != null) {
                this.m_control.removeProject(this.m_currentProject);
            }
            this.m_currentProject = null;
        }
        this.m_projectList.remove(string);
        pjProject.dispose();
        return true;
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
        if (!(windowEvent.getSource() instanceof Frame)) {
            return;
        }
        Frame frame = (Frame)windowEvent.getSource();
        if (frame == this.m_control || this.m_bShowingDialog) {
            return;
        }
        String string = this.getFrameDisplayName(frame);
        if (string == null) {
            return;
        }
        this.selectDisplay(string);
    }

    public void enableMenu(int n, boolean bl) {
        if (this.m_control != null) {
            this.m_control.enableMenu(n, bl);
        }
    }

    protected void serialize(String string) {
        Object object = null;
        if (string.equalsIgnoreCase("Display")) {
            object = this.getDisplay();
        } else if (string.equalsIgnoreCase("Geometry")) {
            object = this.getDisplay().getSelectedGeometry();
        } else if (string.equalsIgnoreCase("Applet")) {
            object = this.getApplet();
        } else if (string.equalsIgnoreCase("Project")) {
            object = this.m_currentProject;
        } else {
            return;
        }
        if (object == null) {
            return;
        }
        String string2 = PsConfig.getCodeBase() + "dev/models/serialized/" + object.getClass().getName() + ".ser";
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            objectOutputStream.close();
            fileOutputStream.close();
            return;
        }
        catch (NotSerializableException notSerializableException) {
            PsDebug.message(notSerializableException.toString());
            return;
        }
        catch (IOException iOException) {
            PsDebug.message(iOException.toString());
            return;
        }
    }

    public boolean export(int n, String string) {
        switch (n) {
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                PgLoader.save(this.export(n), string);
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                this.m_display.setPaintTag(4, false);
                ((PvDisplay)this.m_display).update(this.m_display.getGraphics());
                Image image = this.m_display.getImage();
                PgLoader.save(image, string);
                this.m_display.setPaintTag(4, true);
                ((PvDisplay)this.m_display).update(this.m_display.getGraphics());
                return true;
            }
            case 46: 
            case 47: {
                PgLoader.save(this.export(n), string);
                break;
            }
            default: {
                PsDebug.warning("invalid dialog index = " + n);
                return false;
            }
        }
        return true;
    }

    public boolean export(int n, String string, int n2, int n3) {
        PvDisplayIf pvDisplayIf = this.getDisplay();
        Dimension dimension = pvDisplayIf.getSize();
        if (n3 == -1) {
            n3 = (int)((float)n2 * (float)dimension.height / (float)dimension.width);
        }
        pvDisplayIf.setSizeWithinFrame(n2, n3);
        boolean bl = this.export(n, string);
        pvDisplayIf.setSizeWithinFrame(dimension.width, dimension.height);
        return bl;
    }

    public String export(int n) {
        String string = null;
        switch (n) {
            case 33: {
                string = "byu";
                break;
            }
            case 34: {
                string = "fe";
                break;
            }
            case 35: {
                string = "jvx";
                break;
            }
            case 36: {
                string = "mgs";
                break;
            }
            case 37: {
                string = "mpl";
                break;
            }
            case 38: {
                string = "obj";
                break;
            }
            case 39: {
                string = "off";
                break;
            }
            case 40: {
                string = "wrl";
            }
        }
        if (string != null) {
            PgGeometryIf[] pgGeometryIfArray = null;
            if (this.m_display != null) {
                PgGeometryIf[] pgGeometryIfArray2 = this.m_display.getGeometries();
                int n2 = 0;
                int n3 = 0;
                while (n3 < pgGeometryIfArray2.length) {
                    if (pgGeometryIfArray2[n3].isVisible()) {
                        ++n2;
                    }
                    ++n3;
                }
                pgGeometryIfArray = new PgGeometryIf[n2];
                n3 = 0;
                int n4 = 0;
                while (n4 < pgGeometryIfArray2.length) {
                    if (pgGeometryIfArray2[n4].isVisible()) {
                        pgGeometryIfArray[n3++] = pgGeometryIfArray2[n4];
                    }
                    ++n4;
                }
            } else {
                pgGeometryIfArray = new PgGeometryIf[]{this.m_currentGeometry};
            }
            return PgLoader.saveToString(pgGeometryIfArray, string);
        }
        switch (n) {
            case 47: {
                string = "byu";
                break;
            }
            case 46: {
                string = "byu";
                break;
            }
            default: {
                PsDebug.warning("invalid dialog index = " + n);
                return null;
            }
        }
        if (string != null) {
            Object object;
            String string2 = null;
            string2 = this.m_currentGeometry != null ? this.m_currentGeometry.getName() : PsConfig.getProgram();
            Dimension dimension = this.m_display.getSize();
            PSGr pSGr = new PSGr(this.m_display.getGraphics(), string2, dimension.width, dimension.height);
            PvDisplay pvDisplay = (PvDisplay)this.m_display;
            if (!pvDisplay.isClip()) {
                pvDisplay.setPaintTag(8, true);
                pSGr.setZoom(PvDisplay.PS_ZOOM);
                object = pvDisplay.getBackgroundColor();
                pvDisplay.setBackgroundColor(Color.white);
                pvDisplay.paintGeom(pSGr);
                pvDisplay.setBackgroundColor((Color)object);
                pSGr.setZoom(1.0f);
                pvDisplay.setPaintTag(8, false);
            } else {
                PsDebug.warning("PostScript export temporarily does not print high resolution when clipping enabled.\n\tDisable clipping in ->Panel->Camera->Clipping and print again.");
                pvDisplay.paintGeom(pSGr);
            }
            object = pSGr.toString();
            if (n == 47) {
                object = (String)object + "showpage";
            }
            return object;
        }
        return null;
    }

    public Hashtable getProjectClasses() {
        return this.m_projectClass;
    }

    public PvDisplayIf getDisplay() {
        if (this.m_display == null) {
            this.m_display = new PvDisplay(this);
            this.addDisplay("DisplayAWT", this.m_display);
            if (this.m_currentProject != null && !this.m_currentProject.hasDisplay(this.m_display)) {
                this.m_currentProject.setDisplay(this.m_display);
            }
            this.selectDisplay("DisplayAWT");
        }
        return this.m_display;
    }

    public PvDisplayIf getDisplay(String string) {
        if (this.m_displayList == null) {
            return null;
        }
        return (PvDisplayIf)this.m_displayList.get(string);
    }

    public boolean selectDisplay(String string) {
        if (!this.hasDisplay(string)) {
            PsDebug.warning("name = " + string + " of display not found.");
            return false;
        }
        this.m_display = this.getDisplay(string);
        if (this.m_control != null && this.m_control.getDisplay() != this.m_display) {
            this.m_control.setDisplay(this.m_display);
        }
        if (this.m_display.getSelectedGeometry() != null && this.m_display.getSelectedGeometry() != this.m_currentGeometry) {
            this.setGeometry(this.m_display.getSelectedGeometry());
        }
        if (this.m_mainDisplay == null) {
            this.m_mainDisplay = this.m_display;
        }
        return true;
    }

    public Applet getApplet() {
        return this.m_applet;
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void destroy() {
        this.stop();
        if (this.m_currentProject != null) {
            this.m_currentProject.dispose();
        }
        if (PsConfig.getFrame() != null) {
            PsConfig.getFrame().dispose();
        }
        if (this.m_frameList != null) {
            Enumeration enumeration = this.m_frameList.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                ((Frame)this.m_frameList.get(string)).dispose();
            }
        }
        PsDebug.disposeConsole();
        if (PsConfig.isApplication()) {
            System.exit(0);
        }
    }

    private static String[] getCategories(Hashtable hashtable) {
        int n;
        if (hashtable == null || hashtable.size() == 0) {
            return null;
        }
        int n2 = hashtable.size();
        String[] stringArray = new String[n2];
        int n3 = 0;
        String[] stringArray2 = hashtable.elements();
        while (stringArray2.hasMoreElements()) {
            String string = (String)stringArray2.nextElement();
            boolean bl = false;
            n = 0;
            while (n < n3) {
                if (stringArray[n].equals(string)) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (bl) continue;
            stringArray[n3++] = string;
        }
        if (n3 == 0) {
            return null;
        }
        stringArray2 = new String[n3];
        n = 0;
        while (n < n3) {
            stringArray2[n] = stringArray[n];
            ++n;
        }
        PuString.sort(stringArray2);
        return stringArray2;
    }

    public Frame getFrame() {
        return this.m_frame;
    }

    public Frame getFrame(String string) {
        return (Frame)this.m_frameList.get(string);
    }

    protected boolean selectFrame(String string) {
        if (!this.hasFrame(string)) {
            PsDebug.warning("name = " + string + " of frame not found.");
            return false;
        }
        Frame frame = this.getFrame(string);
        Component[] componentArray = frame.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            PvDisplayIf pvDisplayIf;
            String string2;
            if (componentArray[n] instanceof PvDisplayIf && (string2 = this.hasDisplay(pvDisplayIf = (PvDisplayIf)((Object)componentArray[n]))) != null) {
                this.selectDisplay(string2);
                return true;
            }
            ++n;
        }
        return true;
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void setGeometry(PgGeometryIf pgGeometryIf) {
        if (pgGeometryIf == null) {
            // empty if block
        }
        this.m_currentGeometry = pgGeometryIf;
        if (this.m_control != null) {
            this.m_control.setGeometry(pgGeometryIf);
        }
    }

    public PgGeometryIf getGeometry(String string) {
        PgGeometryIf pgGeometryIf = null;
        String string2 = (String)this.m_geometryClass.get(string);
        if (string2 != null) {
            pgGeometryIf = (PgGeometryIf)PsUtil.newInstance(string2);
        }
        if (pgGeometryIf == null) {
            PsDebug.warning("could not create instance of " + string, this);
            return null;
        }
        return pgGeometryIf;
    }

    public void printParameter() {
        if (this.m_parm == null) {
            this.getParameter("Nothing");
        }
        if (this.m_parm == null) {
            PsDebug.message("empty parameter list.");
            return;
        }
        PsDebug.message("parameter list:");
        int n = 0;
        while (n < this.m_parm.length) {
            PsDebug.message("\t Parameter = " + this.m_parm[n][0] + ", Value = " + this.getParameter(this.m_parm[n][0]));
            ++n;
        }
    }

    public boolean addProject(String string, String string2, String[] stringArray) {
        return this.addProject(null, string, string2, stringArray);
    }

    public boolean addProject(PjProject pjProject) {
        if (pjProject == null) {
            PsDebug.warning("missing project");
            return false;
        }
        pjProject.setViewer(this);
        String string = pjProject.getName();
        if (string == null) {
            PsDebug.warning("missing project name");
            return false;
        }
        this.m_projectList.put(string, pjProject);
        return true;
    }

    public boolean addProject(String string, String string2, String string3, String[] stringArray) {
        if (string2 == null || string3 == null) {
            PsDebug.warning("missing name or class");
            return false;
        }
        if (this.m_projectClass.containsKey(string2)) {
            PsDebug.warning("project name already exists, name = " + string2 + "\n\texisting name belong to class = " + (String)this.m_projectClass.get(string2));
            return false;
        }
        if (string == null) {
            string = "Default";
        }
        this.m_projectCategory.put(string2, string);
        this.m_projectClass.put(string2, string3);
        this.enableMenu(100, true);
        this.enableMenu(110, true);
        if (stringArray != null) {
            this.m_projectParms.put(string2, stringArray);
        }
        return true;
    }

    public void init() {
        int n;
        String string;
        super.init();
        this.m_displayList = new Hashtable();
        this.m_frameList = new Hashtable();
        Frame frame = PsConfig.getFrame();
        if (frame != null) {
            this.addFrame(frame.getName(), frame);
        }
        if ((string = this.getParameter("javaview-rsrc")) != null && !string.equals("")) {
            string = PsConfig.getCodeBase() + string;
            this.m_jvRsrc = new PsJavaView();
            if (this.m_jvRsrc.read(string)) {
                this.m_aboutSize = this.m_jvRsrc.getWindowSize(2);
                this.m_animationSize = this.m_jvRsrc.getWindowSize(5);
                this.m_consoleSize = this.m_jvRsrc.getWindowSize(4);
                this.m_controlSize = this.m_jvRsrc.getWindowSize(1);
                this.m_exportBounds = this.m_jvRsrc.getWindowSize(8);
                this.m_helpSize = this.m_jvRsrc.getWindowSize(3);
                this.m_importModelSize = this.m_jvRsrc.getWindowSize(7);
                this.m_newProjectSize = this.m_jvRsrc.getWindowSize(6);
            }
        }
        String string2 = this.getParameter("menu-new-project");
        if (PROJECTS != null && (PsConfig.isApplication() || string2 != null && string2.equalsIgnoreCase("enable"))) {
            n = 0;
            while (n < PROJECTS.length) {
                this.addProject(PROJECTS[n][0], PROJECTS[n][1], PROJECTS[n][2], null);
                ++n;
            }
        }
        if (GEOMETRIES != null) {
            n = 0;
            while (n < GEOMETRIES.length) {
                this.addGeometry(GEOMETRIES[n][0], GEOMETRIES[n][1], GEOMETRIES[n][2]);
                ++n;
            }
        }
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public boolean showPanel(int n) {
        this.m_showPanel = n;
        if (this.m_control != null) {
            return this.m_control.showPanel(n);
        }
        return true;
    }

    public boolean enablePanel(int n, boolean bl) {
        if (this.m_control != null) {
            return this.m_control.enablePanel(n, true);
        }
        return true;
    }

    public Panel getPanel(int n) {
        if (this.m_control == null) {
            this.m_control = this.getControl();
        }
        return this.m_control.getPanel(n);
    }

    public PjProject getCurrentProject() {
        return this.m_currentProject;
    }

    public void stop() {
        this.m_bStarted = false;
        if (this.m_help != null) {
            this.m_help.dispose();
            this.m_help = null;
        }
        if (this.m_control != null) {
            this.m_control.dispose();
            this.m_control = null;
        }
        if (this.m_currentProject != null) {
            this.m_currentProject.stop();
            this.m_currentProject = null;
        }
        if (PsDebug.hasConsole()) {
            ((Component)PsDebug.getConsole()).setVisible(false);
        }
    }

    public int getNumFrames() {
        return this.m_frameList.size();
    }

    private PvControl getControl() {
        if (this.m_control == null) {
            String string;
            this.m_control = new PvControl(this);
            if (this.m_control == null) {
                PsDebug.error("missing control panel", this);
                return null;
            }
            this.m_control.addWindowListener(this);
            this.m_control.addKeyListener(this);
            if (this.m_display != null) {
                this.m_control.setDisplay(this.m_display);
            }
            this.m_control.setProject(this.m_currentProject);
            if (this.m_currentGeometry == null && this.m_display != null) {
                this.setGeometry(this.m_display.getSelectedGeometry());
            }
            this.m_control.setGeometry(this.m_currentGeometry);
            if (this.m_projectClass != null && this.m_projectClass.size() > 0 && ((string = this.getParameter("menu-new-project")) == null || "enable".equalsIgnoreCase(string))) {
                this.enableMenu(100, true);
                this.enableMenu(110, true);
            }
            if (this.m_jvRsrc != null) {
                this.enableMenu(54, true);
            }
            if (this.m_showPanel != -1) {
                this.m_control.showPanel(this.m_showPanel);
            }
        }
        return this.m_control;
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (!(windowEvent.getSource() instanceof Frame)) {
            return;
        }
        Frame frame = (Frame)windowEvent.getSource();
        if (frame == this.m_control) {
            this.removeControl();
        } else {
            Enumeration enumeration = this.m_frameList.elements();
            while (enumeration.hasMoreElements()) {
                String string;
                if (frame != (Frame)enumeration.nextElement() || (string = this.hasFrame(frame)) == null) continue;
                this.removeFrame(string);
                break;
            }
        }
        if (PsConfig.isApplication() && this.getNumFrames() == 0 && (this.m_control == null || !this.m_control.isShowing())) {
            System.exit(0);
        }
    }

    public String hasDisplay(PvDisplayIf pvDisplayIf) {
        if (this.m_displayList == null) {
            return null;
        }
        if (this.m_displayList.contains(pvDisplayIf)) {
            Enumeration enumeration = this.m_displayList.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (this.m_displayList.get(string) != pvDisplayIf) continue;
                return string;
            }
        }
        return null;
    }

    public boolean hasDisplay(String string) {
        return this.m_displayList == null || this.m_displayList.get(string) != null;
    }

    public boolean removeDisplay(String string) {
        if (!this.hasDisplay(string)) {
            return false;
        }
        if (this.hasFrame(string)) {
            Frame frame = this.getFrame(string);
            frame.dispose();
            this.removeFrame(string);
        } else {
            this.m_displayList.remove(string);
        }
        return true;
    }

    public PvDisplayIf getSelectedDisplay() {
        return this.m_display;
    }

    public boolean update(Object object) {
        if (object == this.m_currentProject) {
            return true;
        }
        return super.update(object);
    }

    public void start() {
        Object object;
        this.m_bStarted = true;
        String string = this.getParameter("Animation");
        if (string != null && string.equalsIgnoreCase("Show")) {
            this.showDialog(23);
        }
        if ((string = this.getParameter("Panel")) != null && !string.equalsIgnoreCase("Project")) {
            this.showPanel(PvViewer.getPanelId(string));
        }
        if ((string = this.getParameter("Control")) != null && string.equalsIgnoreCase("Show")) {
            this.showDialog(24);
        }
        if ((string = this.getParameter("Axes")) != null) {
            this.m_mainDisplay.showAxes(string.equalsIgnoreCase("Show"));
        }
        if ((string = this.getParameter("Background")) != null) {
            this.m_mainDisplay.setBackgroundColor(PdColor.parseColor(string));
        }
        if ((string = this.getParameter("BackgroundImage")) != null) {
            this.m_mainDisplay.setBackgroundImage(string);
            this.m_mainDisplay.showBackImage(true);
        }
        if ((string = this.getParameter("Border")) != null) {
            this.m_mainDisplay.setPaintTag(4, string.equalsIgnoreCase("Show"));
        }
        if ((string = this.getParameter("BoundingBox")) != null) {
            this.m_mainDisplay.showBndBox(string.equalsIgnoreCase("Show"));
        }
        if ((string = this.getParameter("Depthcue")) != null) {
            this.m_mainDisplay.showDepthcue(string.equalsIgnoreCase("Show"));
        }
        if ((string = this.getParameter("EdgeAura")) != null) {
            this.m_mainDisplay.showEdgeAura(string.equalsIgnoreCase("Show"));
        }
        if ((string = this.getParameter("Frame")) != null) {
            this.m_mainDisplay.showFrame(string.equalsIgnoreCase("Show"));
        }
        if ((string = this.getParameter("ViewDir")) != null && (object = PsXmlLoader.parsePdVector(string)) != null) {
            this.m_mainDisplay.getCamera().setViewDir((PdVector)object);
        }
        if ((string = this.getParameter("Autorotate")) != null) {
            object = this.getParameter("RotDir");
            if (object != null) {
                PdVector pdVector = PsXmlLoader.parsePdVector((String)object);
                if (pdVector != null) {
                    this.m_mainDisplay.setAutoRotation(pdVector, 0.06283185307179587);
                }
            } else {
                this.m_mainDisplay.setAutoRotation(new PdVector(0.0, 0.1, 0.0), 0.06283185307179587);
            }
            if (string.equalsIgnoreCase("Show")) {
                this.m_mainDisplay.setEnabledAnimation(true);
                this.m_mainDisplay.start();
            }
        }
        if (this.m_currentProject != null) {
            this.m_currentProject.start();
        }
    }

    private String hasFrame(Frame frame) {
        if (this.m_frameList != null && this.m_frameList.contains(frame)) {
            Enumeration enumeration = this.m_frameList.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (this.m_frameList.get(string) != frame) continue;
                return string;
            }
        }
        return null;
    }

    protected boolean hasFrame(String string) {
        return this.m_frameList.get(string) != null;
    }

    public String getParameter(String string) {
        String string2;
        int n;
        string = string.toLowerCase();
        if (this.m_parm == null && this.m_applet != null && (this.m_parm = this.m_applet.getParameterInfo()) != null) {
            n = 0;
            while (n < this.m_parm.length) {
                this.m_parm[n][0] = this.m_parm[n][0].toLowerCase();
                ++n;
            }
            if (!PsConfig.isApplication()) {
                n = 0;
                while (n < this.m_parm.length) {
                    string2 = this.m_applet.getParameter(this.m_parm[n][0]);
                    if (string2 != null) {
                        this.m_parm[n][2] = string2;
                    }
                    ++n;
                }
            } else {
                n = 0;
                while (n < this.m_parm.length) {
                    string2 = System.getProperty(this.m_parm[n][0]);
                    if (string2 != null) {
                        this.m_parm[n][2] = string2;
                    }
                    ++n;
                }
            }
        }
        if (this.m_parm != null) {
            n = 0;
            while (n < this.m_parm.length) {
                if (this.m_parm[n][0].equalsIgnoreCase(string)) {
                    return this.m_parm[n][2].trim();
                }
                ++n;
            }
        }
        if (!PsConfig.isApplication() && this.m_applet != null && (string2 = this.m_applet.getParameter(string)) != null) {
            return string2;
        }
        if (PsConfig.isApplication() && (string2 = System.getProperty(string)) != null) {
            return string2;
        }
        return null;
    }

    protected Frame removeFrame(String string) {
        if (!this.hasFrame(string)) {
            return null;
        }
        Frame frame = this.getFrame(string);
        String string2 = this.getFrameDisplayName(frame);
        if (string2 != null) {
            this.m_displayList.remove(string2);
        }
        frame.removeWindowListener(this);
        this.m_frameList.remove(string);
        return frame;
    }

    private String getFrameDisplayName(Frame frame) {
        Component[] componentArray = frame.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            String string;
            PvDisplayIf pvDisplayIf;
            if (componentArray[n] instanceof PvDisplayIf) {
                pvDisplayIf = (PvDisplayIf)((Object)componentArray[n]);
                string = this.hasDisplay(pvDisplayIf);
                if (string != null) {
                    return string;
                }
            } else if (componentArray[n] instanceof Applet) {
                Component[] componentArray2 = ((Applet)componentArray[n]).getComponents();
                int n2 = 0;
                while (n2 < componentArray2.length) {
                    if (componentArray2[n2] instanceof PvDisplayIf && (string = this.hasDisplay(pvDisplayIf = (PvDisplayIf)((Object)componentArray2[n2]))) != null) {
                        return string;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return null;
    }

    protected void submit() {
        PsModelInfo psModelInfo = new PsModelInfo();
        psModelInfo.showDialog(true, this);
    }

    public boolean addGeometry(String string, String string2, String string3) {
        if (string2 == null || string3 == null) {
            PsDebug.warning("missing name or class");
            return false;
        }
        if (this.m_geometryCategory == null) {
            this.m_geometryCategory = new Hashtable();
        }
        if (this.m_geometryClass == null) {
            this.m_geometryClass = new Hashtable();
        }
        if (this.m_geometryClass.containsKey(string2)) {
            PsDebug.warning("geometry name already exists, name = " + string2 + "\n\texisting name belong to class = " + (String)this.m_geometryClass.get(string2));
            return false;
        }
        if (string == null) {
            string = "Default";
        }
        this.m_geometryCategory.put(string2, string);
        this.m_geometryClass.put(string2, string3);
        this.enableMenu(101, true);
        this.enableMenu(111, true);
        return true;
    }

    public PjProject getProject(String string) {
        PjProject pjProject = (PjProject)this.m_projectList.get(string);
        if (pjProject == null) {
            String string2 = (String)this.m_projectClass.get(string);
            if (string2 != null) {
                pjProject = (PjProject)PsUtil.newInstance(string2);
            }
            if (pjProject == null) {
                PsDebug.warning("could not create instance of " + string, this);
                return null;
            }
            pjProject.setViewer(this);
            this.m_projectList.put(string, pjProject);
        }
        return pjProject;
    }

    public boolean selectProject(String string) {
        PjProject pjProject;
        if (string == null) {
            PsDebug.warning("missing project name");
            return false;
        }
        if (this.m_currentProject != null) {
            if (string.equals(this.m_currentProject.getName())) {
                return true;
            }
            this.m_currentProject.stop();
        }
        if ((pjProject = this.getProject(string)) == null) {
            PsDebug.error("could not find project " + string, this);
            return false;
        }
        if (this.m_applet != null) {
            pjProject.setParameter(this.m_applet.getParameterInfo());
        }
        this.m_currentProject = pjProject;
        this.m_currentProject.setParent(this);
        if (this.m_display != null) {
            if (this.m_currentProject.hasDisplay(this.m_display)) {
                this.m_currentProject.selectDisplay(this.m_display);
            } else {
                this.m_currentProject.setDisplay(this.m_display);
            }
        }
        if (this.m_bStarted) {
            this.m_currentProject.start();
        }
        if (this.m_control != null) {
            this.m_control.setProject(this.m_currentProject);
        }
        return true;
    }

    public PvViewer() {
        this(null, null);
        this.m_bStarted = true;
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public PvViewer(Applet applet, Frame frame) {
        this.m_applet = applet;
        this.m_frame = frame;
        this.m_projectCategory = new Hashtable();
        this.m_projectClass = new Hashtable();
        this.m_projectList = new Hashtable();
        this.m_projectParms = new Hashtable();
        this.setName(PsConfig.getMessage("ViewerOf") + " " + PsConfig.getProgram());
        PsConfig.init(applet, this, frame);
        if (frame != null) {
            PvDisplay.setDefaultSize(frame.getSize());
        } else if (applet != null) {
            PvDisplay.setDefaultSize(applet.getSize());
        }
        if (PsDebug.isNotify()) {
            this.printParameter();
        }
        if ("Show".equalsIgnoreCase(this.getParameter("Console"))) {
            this.showDialog(25);
        }
        this.init();
    }

    protected static int getPanelId(String string) {
        if ("Project".equalsIgnoreCase(string)) {
            return 10;
        }
        if ("Info".equalsIgnoreCase(string)) {
            return 12;
        }
        if ("Material".equalsIgnoreCase(string)) {
            return 13;
        }
        if ("Camera".equalsIgnoreCase(string)) {
            return 15;
        }
        if ("Display".equalsIgnoreCase(string)) {
            return 16;
        }
        return -1;
    }

    private void removeControl() {
        this.m_control.removeWindowListener(this);
        this.m_control.dispose();
        this.m_control = null;
    }

    public void addProjects() {
        String string;
        int n = 1;
        while ((string = this.getParameter("Project" + n)) != null) {
            ++n;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            int n2 = stringTokenizer.countTokens() - 2;
            String[] stringArray = new String[n2];
            String string2 = stringTokenizer.nextToken();
            string2 = string2.trim();
            String string3 = stringTokenizer.nextToken();
            string3 = string3.trim();
            int n3 = 0;
            while (n3 < n2) {
                stringArray[n3] = stringTokenizer.nextToken();
                stringArray[n3] = stringArray[n3].trim();
                ++n3;
            }
            this.addProject(string2, string3, stringArray);
        }
        string = this.getParameter("Select");
        if (string != null) {
            this.selectProject(string);
        }
    }

    public Hashtable getProjectInstances() {
        return this.m_projectList;
    }

    public String newDisplay() {
        PgGeometryIf[] pgGeometryIfArray;
        PvDisplayIf pvDisplayIf = this.m_display;
        PvDisplayIf pvDisplayIf2 = this.newDisplay(null);
        if (pvDisplayIf2 == null) {
            return null;
        }
        if (this.m_currentProject != null) {
            PvDisplayIf pvDisplayIf3 = this.m_currentProject.getDisplay();
            this.m_currentProject.setDisplay(pvDisplayIf2);
            if (pvDisplayIf3 != null) {
                this.m_currentProject.selectDisplay(pvDisplayIf3);
            }
        } else if (pvDisplayIf != null && (pgGeometryIfArray = pvDisplayIf.getGeometries()) != null) {
            int n = 0;
            while (n < pgGeometryIfArray.length) {
                pvDisplayIf2.addGeometry(pgGeometryIfArray[n]);
                ++n;
            }
            if (this.m_currentGeometry != null && pvDisplayIf2.containsGeometry(this.m_currentGeometry)) {
                pvDisplayIf2.selectGeometry(this.m_currentGeometry);
            }
        }
        if (pvDisplayIf != null) {
            pvDisplayIf2.selectCamera(((PvDisplay)pvDisplayIf).getCurrentCameraType());
            pvDisplayIf2.showGrid(((PvDisplay)pvDisplayIf).isShowingGrid());
            pvDisplayIf2.showBndBox(pvDisplayIf.isShowingBndBox());
            pvDisplayIf2.showFrame(pvDisplayIf.isShowingFrame());
        }
        pvDisplayIf2.update(pvDisplayIf2);
        return pvDisplayIf2.getName();
    }

    public PvDisplayIf newDisplay(String string) {
        PvDisplayIf pvDisplayIf = this.newDisplay(string, true);
        Frame frame = pvDisplayIf.getFrame();
        int n = this.getNumDisplays() - 1;
        if (n > 0) {
            ((Component)frame).setBounds(new Rectangle(5 + 400 * ((n - 1) % 3), 5 + 300 * ((n - 1) / 3), 400, 300));
        } else {
            ((Component)frame).setBounds(new Rectangle(50, 50, 400, 300));
        }
        ((Component)frame).setVisible(true);
        return pvDisplayIf;
    }

    public PvDisplayIf newDisplay(String string, boolean bl) {
        int n = this.getNumDisplays();
        if (string == null) {
            string = "DisplayAWT" + String.valueOf(n);
        } else if (this.hasDisplay(string)) {
            PsDebug.warning("name = " + string + " of display already used.");
            return this.getDisplay(string);
        }
        PvDisplay pvDisplay = new PvDisplay(this);
        this.addDisplay(string, pvDisplay);
        this.selectDisplay(string);
        if (bl) {
            PsMainFrame psMainFrame = new PsMainFrame(pvDisplay, string, null);
            pvDisplay.setFrame(psMainFrame);
            this.addFrame(string, psMainFrame);
        }
        return pvDisplay;
    }

    public boolean addDisplay(String string, PvDisplayIf pvDisplayIf) {
        if (this.m_displayList == null) {
            PsDebug.error("missing instance variable m_displayList.", this);
            return false;
        }
        if (this.hasDisplay(string)) {
            PsDebug.warning("name = " + string + " of display already used.");
            return false;
        }
        pvDisplayIf.setParent(this);
        pvDisplayIf.addKeyListener(this);
        pvDisplayIf.setName(string);
        this.m_displayList.put(string, pvDisplayIf);
        return true;
    }

    protected void deserialize() {
        Object object;
        Object object2;
        PgFileDialog pgFileDialog = new PgFileDialog(PsConfig.getFrame(), "Load Serialized Object", 0);
        if (this.m_serialDirName == null) {
            this.m_serialDirName = PsConfig.getCodeBase() + "dev/models/serialized/";
        }
        pgFileDialog.setDirectory(this.m_serialDirName);
        pgFileDialog.setExtension("ser");
        pgFileDialog.setVisible(true);
        String string = pgFileDialog.getFullFileName();
        if (string == null) {
            return;
        }
        this.m_serialDirName = pgFileDialog.getDirectory();
        Object object3 = null;
        try {
            object2 = new FileInputStream(string);
            object = new ObjectInputStream((InputStream)object2);
            object3 = ((ObjectInputStream)object).readObject();
        }
        catch (Exception exception) {
            PsDebug.message(exception.toString());
        }
        if (object3 == null) {
            PsDebug.warning("object not loaded.");
            return;
        }
        object2 = pgFileDialog.getFile();
        if (object3 instanceof PvDisplay) {
            object = (PvDisplay)object3;
            ((PvDisplay)object).setName((String)object2);
            ((PvDisplay)object).m_viewer = this;
            this.addDisplay((String)object2, (PvDisplayIf)object);
            this.selectDisplay((String)object2);
            PsMainFrame psMainFrame = new PsMainFrame((String)object2, null);
            psMainFrame.add("Center", (Component)object);
            ((PvDisplay)object).setFrame(psMainFrame);
            psMainFrame.pack();
            psMainFrame.setBounds(new Rectangle(50, 50, 400, 300));
            ((Component)psMainFrame).setVisible(true);
            this.addFrame((String)object2, psMainFrame);
            return;
        }
        if (object3 instanceof PgGeometryIf) {
            object = (PgGeometryIf)object3;
            object.setName((String)object2);
            this.getDisplay().addGeometry((PgGeometryIf)object);
            this.getDisplay().selectGeometry((PgGeometryIf)object);
            return;
        }
        if (object3 instanceof Applet) {
            object = (Applet)object3;
            ((Component)object).setName((String)object2);
            PsMainFrame psMainFrame = new PsMainFrame((Component)object, (String)object2, null);
            ((Applet)object).init();
            String string2 = System.getProperty("os.name");
            if (string2 != null) {
                if (string2.toLowerCase().startsWith("win")) {
                    ((Component)psMainFrame).setBounds(new Rectangle(420, 5, 640, 550));
                } else {
                    ((Component)psMainFrame).setSize(640, 550);
                }
            }
            ((Component)psMainFrame).setVisible(true);
            return;
        }
        if (object3 instanceof PjProject) {
            object = (PjProject)object3;
            ((PsObject)object).setName((String)object2);
            this.addProject((PjProject)object);
            this.selectProject((String)object2);
        }
    }

    protected boolean addFrame(String string, Frame frame) {
        if (this.hasFrame(string)) {
            PsDebug.warning("name = " + string + " of frame already used.");
            return false;
        }
        this.m_frameList.put(string, frame);
        frame.addWindowListener(this);
        return true;
    }
}

