/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.jlink;

import com.wolfram.jlink.ExprFormatException;
import com.wolfram.jlink.LoopbackLink;
import com.wolfram.jlink.MathLink;
import com.wolfram.jlink.MathLinkException;
import com.wolfram.jlink.MathLinkFactory;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;

public class Expr
implements Serializable {
    public static final int INTEGER = 1;
    public static final int REAL = 2;
    public static final int STRING = 3;
    public static final int SYMBOL = 4;
    public static final int RATIONAL = 5;
    public static final int COMPLEX = 6;
    protected static final int UNKNOWN = 0;
    protected static final int FIRST_COMPOSITE = 7;
    protected static final int FUNCTION = 7;
    protected static final int FIRST_ARRAY_TYPE = 8;
    protected static final int INTARRAY1 = 8;
    protected static final int REALARRAY1 = 9;
    protected static final int INTARRAY2 = 10;
    protected static final int REALARRAY2 = 11;
    public static final Expr SYM_INTEGER = new Expr(4, "Integer");
    public static final Expr SYM_REAL = new Expr(4, "Real");
    public static final Expr SYM_STRING = new Expr(4, "String");
    public static final Expr SYM_SYMBOL = new Expr(4, "Symbol");
    public static final Expr SYM_RATIONAL = new Expr(4, "Rational");
    public static final Expr SYM_COMPLEX = new Expr(4, "Complex");
    public static final Expr SYM_LIST = new Expr(4, "List");
    public static final Expr SYM_TRUE = new Expr(4, "True");
    public static final Expr SYM_FALSE = new Expr(4, "False");
    protected int type;
    protected Expr head;
    protected Expr[] args;
    protected Object val;
    protected transient LoopbackLink link;
    private static boolean okToUseLoopback = false;

    public Expr() {
    }

    public Expr(double d) {
        this.type = 2;
        this.head = SYM_REAL;
        this.val = new Double(d);
    }

    public Expr(int n) {
        this.type = 1;
        this.head = SYM_INTEGER;
        this.val = new Integer(n);
    }

    public Expr(int n, String string) {
        this.type = n;
        switch (n) {
            case 1: {
                this.head = SYM_INTEGER;
                this.val = new Integer(string);
                break;
            }
            case 2: {
                this.head = SYM_REAL;
                this.val = new Double(string);
                break;
            }
            case 3: {
                this.head = SYM_STRING;
                this.val = string;
                break;
            }
            case 4: {
                this.head = SYM_SYMBOL;
                this.val = string;
                break;
            }
        }
    }

    public Expr(Expr expr, Expr[] exprArray) {
        this.type = 7;
        this.head = expr;
        this.args = exprArray;
    }

    public Expr(MathLink mathLink) throws MathLinkException {
        String string = mathLink.getClass().getName();
        if (okToUseLoopback || string.equals("com.wolfram.jlink.NativeLink") || string.equals("com.wolfram.jlink.NativeLoopbackLink")) {
            this.link = MathLinkFactory.createLoopbackLink();
            this.link.transferExpression(mathLink);
            this.type = 0;
            okToUseLoopback = true;
        } else {
            this.readFromLink(mathLink);
        }
    }

    public Expr(String string) {
        this.type = 3;
        this.head = SYM_STRING;
        this.val = string;
    }

    public Expr(double[] dArray) {
        this.type = 9;
        this.head = SYM_LIST;
        this.val = dArray;
    }

    public Expr(int[] nArray) {
        this.type = 8;
        this.head = SYM_LIST;
        this.val = nArray;
    }

    public Expr(double[][] dArray) {
        this.type = 11;
        this.head = SYM_LIST;
        this.val = dArray;
    }

    public Expr(int[][] nArray) {
        this.type = 10;
        this.head = SYM_LIST;
        this.val = nArray;
    }

    public synchronized Expr[] args() {
        this.prepareFromLoopback();
        if (this.args == null && this.type >= 8) {
            this.args = new Expr[Array.getLength(this.val)];
            int n = 0;
            while (n < this.args.length) {
                switch (this.type) {
                    case 8: {
                        this.args[n] = new Expr(((int[])this.val)[n]);
                        break;
                    }
                    case 10: {
                        this.args[n] = new Expr(((int[][])this.val)[n]);
                        break;
                    }
                    case 9: {
                        this.args[n] = new Expr(((double[])this.val)[n]);
                        break;
                    }
                    case 11: {
                        this.args[n] = new Expr(((double[][])this.val)[n]);
                        break;
                    }
                }
                ++n;
            }
        }
        return this.args;
    }

    public Object asArray(int n, int n2) throws ExprFormatException {
        this.prepareFromLoopback();
        switch (this.type) {
            case 8: {
                if (n2 != 1 || n != 1) {
                    throw new ExprFormatException();
                }
                return (int[])this.val;
            }
            case 9: {
                if (n2 != 1 || n != 2) {
                    throw new ExprFormatException();
                }
                return (double[])this.val;
            }
            case 10: {
                if (n2 != 2 || n != 1) {
                    throw new ExprFormatException();
                }
                return (int[][])this.val;
            }
            case 11: {
                if (n2 != 2 || n != 2) {
                    throw new ExprFormatException();
                }
                return (double[][])this.val;
            }
        }
        throw new ExprFormatException();
    }

    public double asDouble() throws ExprFormatException {
        this.prepareFromLoopback();
        if (this.type == 1 || this.type == 2) {
            return ((Number)this.val).doubleValue();
        }
        if (this.type == 5) {
            return this.args[0].asDouble() / this.args[1].asDouble();
        }
        throw new ExprFormatException();
    }

    public int asInt() throws ExprFormatException {
        this.prepareFromLoopback();
        if (this.type != 1) {
            throw new ExprFormatException();
        }
        return (Integer)this.val;
    }

    public String asString() throws ExprFormatException {
        this.prepareFromLoopback();
        if (this.type != 3 && this.type != 4) {
            throw new ExprFormatException();
        }
        return (String)this.val;
    }

    public boolean atomQ() {
        this.prepareFromLoopback();
        return this.type < 7;
    }

    public boolean complexQ() {
        this.prepareFromLoopback();
        return this.type == 6;
    }

    public int[] dimensions() {
        this.prepareFromLoopback();
        int[] nArray = null;
        if (this.type < 7) {
            nArray = new int[]{};
        } else {
            switch (this.type) {
                case 8: 
                case 9: {
                    nArray = new int[]{Array.getLength(this.val)};
                    break;
                }
                case 10: {
                    nArray = new int[]{Array.getLength(this.val), ((int[][])this.val)[0].length};
                    break;
                }
                case 11: {
                    nArray = new int[]{Array.getLength(this.val), ((double[][])this.val)[0].length};
                    break;
                }
                case 7: {
                    if (this.args.length == 0) {
                        nArray = new int[]{0};
                        break;
                    }
                    int[] nArray2 = new int[32];
                    nArray2[0] = this.args.length;
                    int[] nArray3 = this.args[0].dimensions();
                    System.arraycopy(nArray3, 0, nArray2, 1, nArray3.length);
                    int n = 1 + nArray3.length;
                    int n2 = 1;
                    while (n2 < this.args.length) {
                        if (n == 1) break;
                        int[] nArray4 = this.args[n2].dimensions();
                        n = Math.min(n, 1 + nArray4.length);
                        int n3 = 1;
                        while (n3 < n) {
                            if (nArray2[n3] != nArray4[n3 - 1]) {
                                n = n3;
                                break;
                            }
                            ++n3;
                        }
                        ++n2;
                    }
                    nArray = new int[n];
                    System.arraycopy(nArray2, 0, nArray, 0, n);
                    break;
                }
            }
        }
        return nArray;
    }

    public synchronized void dispose() {
        if (this.link != null) {
            this.link.close();
            this.link = null;
        } else if (!this.atomQ()) {
            if (this.head != null) {
                this.head.dispose();
            }
            if (this.args != null) {
                int n = 0;
                while (n < this.args.length) {
                    this.args[n].dispose();
                    ++n;
                }
            }
        }
    }

    private String dump() {
        this.prepareFromLoopback();
        return "";
    }

    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            Object var2_1 = null;
            if (this.link != null) {
                this.link.close();
                this.link = null;
            }
        }
    }

    public Expr head() {
        this.prepareFromLoopback();
        return this.type < 8 ? this.head : SYM_LIST;
    }

    public double im() {
        this.prepareFromLoopback();
        if (this.type != 6) {
            return 0.0;
        }
        this.args[1].prepareFromLoopback();
        return ((Number)this.args[1].val).doubleValue();
    }

    public boolean integerQ() {
        this.prepareFromLoopback();
        return this.type == 1;
    }

    public int length() {
        this.prepareFromLoopback();
        if (this.type >= 8) {
            return Array.getLength(this.val);
        }
        return this.args != null ? this.args.length : 0;
    }

    public boolean listQ() {
        this.prepareFromLoopback();
        return this.type >= 7 && this.head.type == 4 && this.head.val.equals("List");
    }

    public boolean matrixQ() {
        this.prepareFromLoopback();
        if (this.type == 10 || this.type == 11) {
            return true;
        }
        if (!this.listQ() || this.type == 8 || this.type == 9) {
            return false;
        }
        if (this.args.length == 0) {
            return false;
        }
        int n = 0;
        while (n < this.args.length) {
            if (!this.args[n].vectorQ()) {
                return false;
            }
            ++n;
        }
        return this.dimensions().length >= 2;
    }

    public boolean matrixQ(int n) {
        if (!this.matrixQ()) {
            return false;
        }
        if (n == 1 && this.type == 10 || n == 2 && this.type == 11) {
            return true;
        }
        int n2 = this.length();
        int n3 = 0;
        while (n3 < n2) {
            if (!this.args[n3].vectorQ(n)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public boolean numberQ() {
        this.prepareFromLoopback();
        return this.type == 2 || this.type == 1 || this.type == 6 || this.type == 5;
    }

    public Expr part(int n) {
        this.prepareFromLoopback();
        return n == 0 ? this.head : this.args()[n - 1];
    }

    public Expr part(int[] nArray) {
        int n = nArray.length;
        if (n == 1) {
            return this.part(nArray[0]);
        }
        int[] nArray2 = new int[n - 1];
        System.arraycopy(nArray, 0, nArray2, 0, n - 1);
        return this.part(nArray2).part(nArray[n - 1]);
    }

    protected synchronized void prepareFromLoopback() {
        if (this.link != null) {
            try {
                try {
                    this.readFromLink(this.link);
                }
                catch (MathLinkException mathLinkException) {
                }
                Object var2_1 = null;
                this.link.close();
                this.link = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.link.close();
                this.link = null;
                throw throwable;
            }
        }
    }

    public synchronized void put(MathLink mathLink) throws MathLinkException {
        if (this.link != null) {
            long l = this.link.createMark();
            try {
                mathLink.transferExpression(this.link);
            }
            finally {
                Object var5_4 = null;
                mathLink.clearError();
                this.link.seekMark(l);
                this.link.destroyMark(l);
            }
        } else if (this.val != null) {
            if (this.type == 4) {
                mathLink.putSymbol((String)this.val);
            } else {
                mathLink.put(this.val);
            }
        } else {
            mathLink.putNext(70);
            mathLink.putArgCount(this.args().length);
            mathLink.put(this.head());
            int n = 0;
            while (n < this.args.length) {
                mathLink.put(this.args[n]);
                ++n;
            }
        }
    }

    public boolean rationalQ() {
        this.prepareFromLoopback();
        return this.type == 5;
    }

    public double re() {
        this.prepareFromLoopback();
        switch (this.type) {
            case 1: 
            case 2: {
                return ((Number)this.val).doubleValue();
            }
            case 5: 
            case 6: {
                this.args[0].prepareFromLoopback();
                return ((Number)this.args[0].val).doubleValue();
            }
        }
        return 0.0;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void readFromLink(MathLink var1_1) throws MathLinkException {
        var2_2 = 0L;
        var4_3 = 0L;
        try {
            switch (var1_1.getNext()) {
                case 43: {
                    this.type = 1;
                    this.head = Expr.SYM_INTEGER;
                    this.val = new Integer(var1_1.getInteger());
                    return;
                }
                case 42: {
                    this.type = 2;
                    this.head = Expr.SYM_REAL;
                    this.val = new Double(var1_1.getDouble());
                    return;
                }
                case 34: {
                    this.type = 3;
                    this.head = Expr.SYM_STRING;
                    this.val = var1_1.getString();
                    return;
                }
                case 35: {
                    this.type = 4;
                    this.head = Expr.SYM_SYMBOL;
                    this.val = var1_1.getString();
                    return;
                }
                case 70: {
                    var2_2 = var1_1.createMark();
                    var8_4 = var1_1.getArgCount();
                    this.head = new Expr(var1_1);
                    this.head.prepareFromLoopback();
                    var4_3 = var1_1.createMark();
                    if (this.head.type == 4 && this.head.val.equals("Rational")) {
                        this.type = 5;
                        this.args = new Expr[2];
                        this.args[0] = new Expr(var1_1);
                        this.args[1] = new Expr(var1_1);
                        return;
                    }
                    if (this.head.type == 4 && this.head.val.equals("Complex")) {
                        this.type = 6;
                        this.args = new Expr[2];
                        this.args[0] = new Expr(var1_1);
                        this.args[1] = new Expr(var1_1);
                        return;
                    }
                    if (this.head.type == 4 && this.head.val.toString().equals("List")) ** GOTO lbl49
                    this.type = 7;
                    this.args = new Expr[var8_4];
                    var9_6 = 0;
                    if (true) ** GOTO lbl92
lbl49:
                    // 1 sources

                    try {
                        var1_1.seekMark(var4_3);
                        switch (var1_1.getNext()) {
                            case 43: {
                                var1_1.seekMark(var2_2);
                                this.val = var1_1.getIntArray1();
                                this.type = 8;
                                return;
                            }
                            case 42: {
                                var1_1.seekMark(var2_2);
                                this.val = var1_1.getDoubleArray1();
                                this.type = 9;
                                return;
                            }
                            case 70: {
                                var1_1.getArgCount();
                                var9_7 = var1_1.getSymbol();
                                if (var9_7.equals("List") == false) throw new MathLinkException(12345);
                                var10_9 = var1_1.getNext();
                                if (var10_9 == 43) {
                                    var1_1.seekMark(var2_2);
                                    this.val = var1_1.getIntArray2();
                                    this.type = 10;
                                    return;
                                }
                                if (var10_9 != 42) throw new MathLinkException(12345);
                                var1_1.seekMark(var2_2);
                                this.val = var1_1.getDoubleArray2();
                                this.type = 11;
                                return;
                            }
                        }
                        throw new MathLinkException(12345);
                    }
                    catch (MathLinkException v0) {
                        var1_1.clearError();
                        var1_1.seekMark(var4_3);
                        this.type = 7;
                        this.args = new Expr[var8_4];
                        var9_8 = 0;
                        if (true) ** GOTO lbl97
                    }
                }
                default: {
                    return;
                }
            }
            do {
                this.args[var9_6] = new Expr(var1_1);
                ++var9_6;
lbl92:
                // 2 sources

            } while (var9_6 < var8_4);
            return;
            do {
                this.args[var9_8] = new Expr(var1_1);
                ++var9_8;
lbl97:
                // 2 sources

            } while (var9_8 < var8_4);
            return;
        }
        finally {
            var7_10 = null;
            var1_1.clearError();
            if (var2_2 != 0L) {
                var1_1.destroyMark(var2_2);
            }
            if (var4_3 != 0L) {
                var1_1.destroyMark(var4_3);
            }
            var1_1.newPacket();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public boolean realQ() {
        this.prepareFromLoopback();
        return this.type == 2;
    }

    public boolean stringQ() {
        this.prepareFromLoopback();
        return this.type == 3;
    }

    public boolean symbolQ() {
        this.prepareFromLoopback();
        return this.type == 4;
    }

    public String toString() {
        String string = null;
        this.prepareFromLoopback();
        switch (this.type) {
            case 1: 
            case 2: 
            case 4: {
                string = this.val.toString();
                break;
            }
            case 3: {
                string = "\"" + this.val.toString() + "\"";
                break;
            }
            case 5: {
                string = "Rational[" + this.args[0].toString() + ", " + this.args[1].toString() + "]";
                break;
            }
            case 6: {
                string = "Complex[" + this.re() + ", " + this.im() + "]";
                break;
            }
            case 7: {
                boolean bl = this.listQ();
                string = bl ? "{" : String.valueOf(this.head.toString()) + "[";
                int n = this.length();
                int n2 = 0;
                while (n2 < n) {
                    string = String.valueOf(string) + this.args[n2].toString() + (n2 < n - 1 ? ", " : "");
                    ++n2;
                }
                string = String.valueOf(string) + (bl ? "}" : "]");
                break;
            }
            case 8: 
            case 9: {
                string = "{";
                int n = Array.getLength(this.val);
                int n3 = 0;
                while (n3 < n) {
                    string = String.valueOf(string) + (this.type == 8 ? String.valueOf(((int[])this.val)[n3]) : String.valueOf(((double[])this.val)[n3])) + (n3 < n - 1 ? ", " : "");
                    ++n3;
                }
                string = String.valueOf(string) + "}";
                break;
            }
            case 10: 
            case 11: {
                string = "{";
                int n = Array.getLength(this.val);
                int n4 = Array.getLength(Array.get(this.val, 0));
                int[][] nArray = this.type == 10 ? (int[][])this.val : null;
                double[][] dArray = this.type == 11 ? (double[][])this.val : null;
                int n5 = 0;
                while (n5 < n) {
                    string = String.valueOf(string) + "{";
                    int n6 = 0;
                    while (n6 < n4) {
                        string = String.valueOf(string) + (this.type == 10 ? String.valueOf(nArray[n5][n6]) : String.valueOf(dArray[n5][n6])) + (n6 < n4 - 1 ? ", " : "");
                        ++n6;
                    }
                    string = String.valueOf(string) + (n5 < n - 1 ? "}, " : "}");
                    ++n5;
                }
                string = String.valueOf(string) + "}";
                break;
            }
        }
        return string;
    }

    public boolean trueQ() {
        this.prepareFromLoopback();
        return this.type == 4 && this.val.equals("True");
    }

    protected int type() {
        this.prepareFromLoopback();
        return this.type;
    }

    public boolean vectorQ() {
        this.prepareFromLoopback();
        if (this.type == 8 || this.type == 9) {
            return true;
        }
        if (!this.listQ() || this.type == 10 || this.type == 11) {
            return false;
        }
        int n = 0;
        while (n < this.args.length) {
            if (this.args[n].listQ()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean vectorQ(int n) {
        if (!this.vectorQ()) {
            return false;
        }
        if (n == 1 && this.type == 8 || n == 2 && this.type == 9) {
            return true;
        }
        if (this.type == 10 || this.type == 11) {
            return false;
        }
        int n2 = this.length();
        int n3 = 0;
        while (n3 < n2) {
            if (this.args[n3].type() != n) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.link != null) {
            this.prepareFromLoopback();
        }
        objectOutputStream.defaultWriteObject();
    }
}

