/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.jlink;

import com.wolfram.jlink.COMUtilities;
import com.wolfram.jlink.Expr;
import com.wolfram.jlink.Install;
import com.wolfram.jlink.JLinkClassLoader;
import com.wolfram.jlink.KernelLink;
import com.wolfram.jlink.MLFunction;
import com.wolfram.jlink.MathLink;
import com.wolfram.jlink.MathLinkException;
import com.wolfram.jlink.MathLinkFactory;
import com.wolfram.jlink.MathLinkImpl;
import com.wolfram.jlink.NumberRangeException;
import com.wolfram.jlink.ObjectHandler;
import com.wolfram.jlink.Reader;
import com.wolfram.jlink.StdLink;
import com.wolfram.jlink.Utils;
import java.awt.Component;
import java.awt.Window;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.Vector;

public abstract class KernelLinkImpl
extends MathLinkImpl
implements KernelLink {
    private ObjectHandler objectHandler = new ObjectHandler();
    private Object msgSync = new Object();
    private int msg;
    protected boolean isManual = false;
    protected MathLink feServerLink = null;
    private boolean linkConnected = false;
    private String accumulatingPS = null;
    private boolean lastPktWasMsg = false;
    static final String PACKAGE_PRIVATE_CONTEXT = "JLink`Private`";
    static final String MMA_OBJECTSYMBOLPREFIX = "JLink`Objects`JavaObject";
    static final String MMA_LOADCLASSANDCREATEINSTANCEDEFS = "JLink`Private`loadClassAndCreateInstanceDefs";
    static final String MMA_CREATEINSTANCEDEFS = "JLink`Private`createInstanceDefs";
    static final String MMA_LOADCLASS = "JLink`Private`loadClassFromJava";
    static final String MMA_PREPAREFORMANUALRETURN = "JLink`Private`prepareForManualReturn";
    static final String MMA_HANDLECLEANEXCEPTION = "JLink`Private`handleCleanException";
    static final String MMA_AUTOEXCEPTION = "JLink`Private`autoException";
    static final String MMA_MANUALEXCEPTION = "JLink`Private`manualException";
    static final String MMA_NODEFAULTCTOR = "JLink`Private`issueNoDefaultCtorMessage";
    static final int TYPE_OBJECT = -14;
    static final int TYPE_FLOATORINT = -15;
    static final int TYPE_DOUBLEORINT = -16;
    static final int TYPE_ARRAY1 = -17;
    static final int TYPE_ARRAY2 = -34;
    static final int TYPE_ARRAY3 = -51;
    static final int TYPE_BAD = -10000;
    static /* synthetic */ Class class$java$lang$String;

    public KernelLinkImpl() {
        this.addMessageHandler(null, this, "msgHandler");
    }

    protected void allowRaggedArrays() throws MathLinkException {
        boolean bl = false;
        try {
            bl = this.getBoolean();
            this.newPacket();
        }
        catch (Exception exception) {
            this.handleCleanException(exception);
            return;
        }
        Utils.setRaggedArrays(bl);
        this.putSymbol("Null");
    }

    protected void allowUIComputations() throws MathLinkException {
        try {
            boolean bl = this.getSymbol().equals("True");
            boolean bl2 = this.getSymbol().equals("True");
            this.newPacket();
            StdLink.allowUIComputations(bl, bl2);
        }
        catch (Exception exception) {
            this.handleCleanException(exception);
            return;
        }
        this.putSymbol("Null");
    }

    public synchronized void beginManual() {
        this.setManual(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void callJava() throws MathLinkException {
        int n;
        boolean bl;
        int n2;
        int n3;
        Object object = null;
        int[] nArray = null;
        Object[] objectArray = null;
        try {
            this.checkFunction("List");
            n3 = this.getInteger();
            n2 = this.getInteger();
            object = this.getObject();
            nArray = this.getIntArray1();
            bl = this.getInteger() != 0;
            n = this.getInteger();
            objectArray = new Object[n];
            int n4 = 0;
            while (n4 < n) {
                objectArray[n4] = this.getTypeObjectPair();
                ++n4;
            }
            this.newPacket();
        }
        catch (Exception exception) {
            this.handleCleanException(exception);
            return;
        }
        try {
            switch (n2) {
                case 1: {
                    Object object2 = null;
                    try {
                        object2 = this.objectHandler.callCtor(n3, nArray, objectArray);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        this.putFunction("EvaluatePacket", 1);
                        this.putFunction(MMA_NODEFAULTCTOR, 1);
                        this.put(this.objectHandler.getComponentTypeName(n3));
                        this.endPacket();
                        this.discardAnswer();
                        this.handleCleanException(noSuchMethodException);
                        return;
                    }
                    catch (Exception exception) {
                        this.handleCleanException(exception);
                        return;
                    }
                    this.putReference(object2);
                    return;
                }
                case 2: {
                    n = this.isManual() ? 1 : 0;
                    this.setManual(false);
                    try {
                        try {
                            Object object3 = this.objectHandler.callMethod(n3, object, nArray, objectArray);
                            if (this.isManual()) {
                                this.putSymbol("Null");
                            } else if (bl) {
                                this.put(object3);
                            } else {
                                this.putReference(object3);
                            }
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            Throwable throwable = invocationTargetException.getTargetException();
                            if (this.isManual()) {
                                this.clearError();
                                throwable.printStackTrace();
                                String string = Utils.createExceptionMessage(throwable);
                                this.endPacket();
                                this.flush();
                                this.putFunction(MMA_MANUALEXCEPTION, 1);
                                this.put(string);
                            } else {
                                this.handleCleanException(throwable);
                                if (throwable instanceof Error) {
                                    throw (Error)throwable;
                                }
                            }
                        }
                        catch (Exception exception) {
                            this.handleCleanException(exception);
                        }
                        Object var9_21 = null;
                        this.setManual(n != 0);
                        return;
                    }
                    catch (Throwable throwable) {
                        Object var9_22 = null;
                        this.setManual(n != 0);
                        throw throwable;
                    }
                }
                case 3: {
                    n = nArray[nArray.length - 1];
                    try {
                        if (objectArray.length == 0) {
                            Object object4 = this.objectHandler.getField(n3, object, n);
                            if (bl) {
                                this.put(object4);
                                return;
                            } else {
                                this.putReference(object4);
                            }
                            return;
                        }
                        this.objectHandler.setField(n3, object, n, objectArray[0]);
                        this.putSymbol("Null");
                        return;
                    }
                    catch (Exception exception) {
                        this.handleCleanException(exception);
                    }
                    return;
                }
                default: {
                    return;
                }
            }
        }
        catch (MathLinkException mathLinkException) {
            System.err.println("Serious error: MathLinkException trying to report results of previous exception.");
            this.clearError();
            try {
                this.endPacket();
                return;
            }
            catch (MathLinkException mathLinkException2) {}
        }
    }

    protected void callOnLoadClass() throws MathLinkException {
        try {
            int n = this.getInteger();
            this.newPacket();
            this.objectHandler.callOnLoadClass(this, n);
        }
        catch (Exception exception) {
            this.handleCleanException(exception);
            return;
        }
        this.putFunction("ReturnPacket", 1);
        this.putSymbol("Null");
        this.endPacket();
    }

    protected void callOnUnloadClass() throws MathLinkException {
        try {
            int n = this.getInteger();
            this.newPacket();
            this.objectHandler.callOnUnloadClass(this, n);
        }
        catch (Exception exception) {
            this.handleCleanException(exception);
            return;
        }
        this.putFunction("ReturnPacket", 1);
        this.putSymbol("Null");
        this.endPacket();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void comGetObject() throws MathLinkException {
        String string = null;
        boolean bl = false;
        try {
            string = this.getString();
            bl = this.getSymbol().equals("True");
            this.newPacket();
        }
        catch (Exception exception) {
            this.handleCleanException(exception);
            return;
        }
        if (Utils.isMicrosoftVM()) {
            Object object = null;
            try {
                object = bl ? COMUtilities.getActiveObject(string) : COMUtilities.createObject(string);
            }
            catch (Exception exception) {
                this.handleCleanException(exception);
                return;
            }
            if (object != null) {
                this.putReference(object);
            } else {
                this.putSymbol("$Failed");
            }
        } else {
            this.putSymbol("$Failed");
        }
    }

    protected void comQueryInterface() throws MathLinkException {
        Object object = null;
        String string = null;
        try {
            object = this.getObject();
            string = this.getString();
            this.newPacket();
        }
        catch (Exception exception) {
            this.handleCleanException(exception);
            return;
        }
        if (Utils.isMicrosoftVM()) {
            Object var3_4 = null;
            if (var3_4 != null) {
                this.putReference(var3_4);
            } else {
                this.putSymbol("$Failed");
            }
        } else {
            this.putSymbol("$Failed");
        }
    }

    protected void connectToFEServer() throws MathLinkException {
        boolean bl;
        block6: {
            bl = false;
            try {
                String string = this.getString();
                this.newPacket();
                this.feServerLink = MathLinkFactory.createMathLink("-linkmode connect -linkname " + string);
                if (this.feServerLink == null) break block6;
                try {
                    this.feServerLink.connect();
                    this.feServerLink.putFunction("InputNamePacket", 1);
                    this.feServerLink.put("In[1]:=");
                    this.feServerLink.flush();
                    while (true) {
                        MLFunction mLFunction = this.feServerLink.getFunction();
                        this.feServerLink.newPacket();
                        if (mLFunction.name.equals("EnterTextPacket") || mLFunction.name.equals("EnterExpressionPacket")) {
                            bl = true;
                            break;
                        }
                        if (!mLFunction.name.equals("EvaluatePacket")) continue;
                        this.feServerLink.putFunction("ReturnPacket", 1);
                        this.feServerLink.putSymbol("Null");
                    }
                }
                catch (MathLinkException mathLinkException) {
                    this.feServerLink.close();
                    this.feServerLink = null;
                }
            }
            catch (Exception exception) {
                this.handleCleanException(exception);
                return;
            }
        }
        this.putFunction("ReturnPacket", 1);
        this.put(bl);
        this.endPacket();
    }

    public synchronized void discardAnswer() throws MathLinkException {
        int n = this.waitForAnswer();
        this.newPacket();
        while (n != 3 && n != 8) {
            n = this.waitForAnswer();
            this.newPacket();
        }
    }

    private void discardAnswerNoPacketListeners() throws MathLinkException {
        Vector vector = this.packetListeners;
        this.packetListeners = null;
        this.discardAnswer();
        this.packetListeners = vector;
    }

    protected void disconnectToFEServer() throws MathLinkException {
        this.feServerLink.close();
        this.feServerLink = null;
        this.putFunction("ReturnPacket", 1);
        this.putSymbol("Null");
        this.endPacket();
    }

    public synchronized void enableObjectReferences() throws MathLinkException {
        this.evaluate("Needs[\"JLink`\"]");
        this.discardAnswer();
        this.evaluate("InstallJava[$ParentLink]");
        this.flush();
        Install.install(this);
        this.discardAnswer();
    }

    private byte[] evalToImage(Object object, int n, int n2, int n3, boolean bl) {
        byte[] byArray = null;
        try {
            this.putFunction("EvaluatePacket", 1);
            this.putFunction("Needs", 1);
            this.put("JLink`");
            this.flush();
            this.discardAnswerNoPacketListeners();
            Utils.writeEvalToImageExpression(this, object, n, n2, n3, bl);
            this.flush();
            this.waitForAnswer();
        }
        catch (MathLinkException mathLinkException) {
            String string = System.getProperty("JLINK_SHOW_INTERNAL_EXCEPTIONS");
            if (string != null && string.equals("true")) {
                System.err.println("Exception in evaluateToImage: " + mathLinkException.toString());
            }
            this.clearError();
            this.newPacket();
            return null;
        }
        try {
            try {
                if (this.getNext() == 34) {
                    byArray = this.getByteString(0);
                }
            }
            catch (Throwable throwable) {
                String string = System.getProperty("JLINK_SHOW_INTERNAL_EXCEPTIONS");
                if (string != null && string.equals("true")) {
                    System.err.println("Exception in evaluateToImage: " + throwable.toString());
                }
                this.clearError();
            }
            Object var8_10 = null;
            this.newPacket();
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            this.newPacket();
            throw throwable;
        }
        return byArray;
    }

    private String evalToString(Object object, int n, boolean bl) {
        String string = null;
        try {
            try {
                Utils.writeEvalToStringExpression(this, object, n, bl);
                this.flush();
                this.waitForAnswer();
                string = this.getString();
            }
            catch (MathLinkException mathLinkException) {
                String string2 = System.getProperty("JLINK_SHOW_INTERNAL_EXCEPTIONS");
                if (string2 != null && string2.equals("true")) {
                    System.err.println("Exception in " + (bl ? "evaluateToOutputForm: " : "evaluateToInputForm: ") + mathLinkException.toString());
                }
                this.clearError();
            }
            Object var6_7 = null;
            this.newPacket();
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.newPacket();
            throw throwable;
        }
        return string;
    }

    private byte[] evalToTypeset(Object object, int n, boolean bl) {
        byte[] byArray = null;
        try {
            this.putFunction("EvaluatePacket", 1);
            this.putFunction("Needs", 1);
            this.put("JLink`");
            this.flush();
            this.discardAnswerNoPacketListeners();
            Utils.writeEvalToTypesetExpression(this, object, n, bl);
            this.flush();
            this.waitForAnswer();
        }
        catch (MathLinkException mathLinkException) {
            String string = System.getProperty("JLINK_SHOW_INTERNAL_EXCEPTIONS");
            if (string != null && string.equals("true")) {
                System.err.println("Exception in evaluateToTypeset: " + mathLinkException.toString());
            }
            this.clearError();
            this.newPacket();
            return null;
        }
        try {
            try {
                if (this.getNext() == 34) {
                    byArray = this.getByteString(0);
                }
            }
            catch (Throwable throwable) {
                String string = System.getProperty("JLINK_SHOW_INTERNAL_EXCEPTIONS");
                if (string != null && string.equals("true")) {
                    System.err.println("Exception in evaluateToTypeset: " + throwable.toString());
                }
                this.clearError();
            }
            Object var6_8 = null;
            this.newPacket();
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.newPacket();
            throw throwable;
        }
        return byArray;
    }

    public synchronized void evaluate(Expr expr) throws MathLinkException {
        this.putFunction("EvaluatePacket", 1);
        this.put(expr);
        this.endPacket();
        this.flush();
    }

    public synchronized void evaluate(String string) throws MathLinkException {
        this.putFunction("EvaluatePacket", 1);
        this.putFunction("ToExpression", 1);
        this.put(string);
        this.endPacket();
        this.flush();
    }

    public synchronized byte[] evaluateToImage(Expr expr, int n, int n2) {
        return this.evalToImage(expr, n, n2, 0, false);
    }

    public synchronized byte[] evaluateToImage(Expr expr, int n, int n2, int n3, boolean bl) {
        return this.evalToImage(expr, n, n2, n3, bl);
    }

    public synchronized byte[] evaluateToImage(String string, int n, int n2) {
        return this.evalToImage(string, n, n2, 0, false);
    }

    public synchronized byte[] evaluateToImage(String string, int n, int n2, int n3, boolean bl) {
        return this.evalToImage(string, n, n2, n3, bl);
    }

    public synchronized String evaluateToInputForm(Expr expr, int n) {
        return this.evalToString(expr, n, false);
    }

    public synchronized String evaluateToInputForm(String string, int n) {
        return this.evalToString(string, n, false);
    }

    public synchronized String evaluateToOutputForm(Expr expr, int n) {
        return this.evalToString(expr, n, true);
    }

    public synchronized String evaluateToOutputForm(String string, int n) {
        return this.evalToString(string, n, true);
    }

    public synchronized byte[] evaluateToTypeset(Expr expr, int n, boolean bl) {
        return this.evalToTypeset(expr, n, bl);
    }

    public synchronized byte[] evaluateToTypeset(String string, int n, boolean bl) {
        return this.evalToTypeset(string, n, bl);
    }

    protected void forcePolling() throws MathLinkException {
        try {
            boolean bl = this.getSymbol().equals("True");
            boolean bl2 = this.getSymbol().equals("True");
            this.newPacket();
            StdLink.forcePolling(bl);
            if (bl2) {
                this.setYieldFunction(null, null, null);
            }
        }
        catch (Exception exception) {
            this.handleCleanException(exception);
            return;
        }
        this.putSymbol("Null");
    }

    public synchronized Object getArray(int n, int n2) throws MathLinkException {
        Object object = null;
        if (n == -14) {
            Object object2;
            int n3;
            int n4;
            Object object3 = null;
            long l = this.createMark();
            try {
                this.getFunction();
                n4 = 1;
                while (n4 < 5) {
                    n3 = this.getNext();
                    if (n3 != 70) break;
                    this.getFunction();
                    ++n4;
                }
                object3 = this.getObject();
            }
            finally {
                object2 = null;
                this.seekMark(l);
                this.destroyMark(l);
            }
            Class<?> clazz = object3.getClass();
            if (n4 < n2) {
                throw new MathLinkException(1002);
            }
            if (n2 == 1) {
                object2 = this.getFunction();
                object = Array.newInstance(clazz, ((MLFunction)object2).argCount);
                n3 = 0;
                while (n3 < ((MLFunction)object2).argCount) {
                    Array.set(object, n3, this.getObject());
                    ++n3;
                }
            } else {
                object2 = "L" + clazz.getName() + ";";
                n3 = 1;
                while (n3 < n4) {
                    object2 = "[" + (String)object2;
                    ++n3;
                }
                Class clazz2 = null;
                try {
                    clazz2 = JLinkClassLoader.classFromName((String)object2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                object = this.getArraySlices(n, n2, clazz2);
            }
        } else {
            object = super.getArray(n, n2);
        }
        return object;
    }

    protected void getComplexCls() throws MathLinkException {
        String string = null;
        try {
            this.newPacket();
            Class clazz = this.getComplexClass();
            if (clazz != null) {
                string = clazz.getName();
            }
        }
        catch (Exception exception) {
            this.handleCleanException(exception);
            return;
        }
        if (string != null) {
            this.put(string);
        } else {
            this.putSymbol("Null");
        }
    }

    MathLink getFEServerLink() {
        return this.feServerLink;
    }

    public synchronized Object getObject() throws MathLinkException {
        return this.objectHandler.getObject(this.getSymbol());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object getTypeObjectPair() throws MathLinkException, NumberRangeException {
        long l;
        long l2;
        Object object = null;
        int n = this.getInteger();
        if (n % -17 == -15) {
            n = -7 + -17 * (n / -17);
        } else if (n % -17 == -16) {
            n = -8 + -17 * (n / -17);
        }
        switch (n) {
            case -5: {
                return new Integer(this.getInteger());
            }
            case -6: {
                return new Long(this.getLongInteger());
            }
            case -4: {
                int n2 = this.getInteger();
                if (n2 < Short.MIN_VALUE) throw new NumberRangeException(n2, "short");
                if (n2 <= Short.MAX_VALUE) return new Short((short)n2);
                throw new NumberRangeException(n2, "short");
            }
            case -2: {
                int n3 = this.getInteger();
                if (n3 < -128) throw new NumberRangeException(n3, "byte");
                if (n3 <= 127) return new Byte((byte)n3);
                throw new NumberRangeException(n3, "byte");
            }
            case -3: {
                int n4 = this.getInteger();
                if (n4 < 0) throw new NumberRangeException(n4, "char");
                if (n4 <= 65535) return new Character((char)n4);
                throw new NumberRangeException(n4, "char");
            }
            case -15: 
            case -7: {
                double d = this.getDouble();
                if (d < -3.4028234663852886E38) throw new NumberRangeException(d, "float");
                if (!(d > 3.4028234663852886E38)) return new Float((float)d);
                throw new NumberRangeException(d, "float");
            }
            case -16: 
            case -8: {
                return new Double(this.getDouble());
            }
            case -9: {
                int n5 = this.getType();
                if (n5 != 35) return this.getString();
                return this.getObject();
            }
            case -1: {
                String string = this.getSymbol();
                if (!string.equals("True")) return new Boolean(false);
                return new Boolean(true);
            }
            case -13: {
                l2 = this.createMark();
                try {
                    int n6 = this.getNext();
                    if (n6 == 35) {
                        object = this.getObject();
                    } else {
                        this.seekMark(l2);
                        object = this.getComplex();
                    }
                }
                catch (Throwable throwable) {
                    Object var7_17 = null;
                    this.destroyMark(l2);
                    throw throwable;
                }
            }
            Object var7_16 = null;
            this.destroyMark(l2);
            return object;
            case -10: {
                int n7 = this.getType();
                if (n7 != 35) return new BigInteger(this.getString());
                return this.getObject();
            }
            case -11: {
                int n8 = this.getType();
                if (n8 != 35) return Utils.bigDecimalFromString(this.getString());
                return this.getObject();
            }
            case -12: {
                l = this.createMark();
                try {
                    int n9 = this.getNext();
                    if (n9 == 35 && (object = this.getObject()) != null) {
                        Object var7_18 = null;
                        this.destroyMark(l);
                        return object;
                    }
                    this.seekMark(l);
                    object = this.getExpr();
                }
                catch (Throwable throwable) {
                    Object var7_20 = null;
                    this.destroyMark(l);
                    throw throwable;
                }
            }
            Object var7_19 = null;
            this.destroyMark(l);
            return object;
            case -14: {
                return this.getObject();
            }
            default: {
                int n10 = this.getNext();
                if (n10 == 35) {
                    return this.getObject();
                }
                if (n > -34) {
                    return this.getArray(n - -17, 1);
                }
                if (n <= -51) return this.getArray(n - -51, 3);
                return this.getArray(n - -34, 2);
            }
            case -10000: 
        }
        return object;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void handleCallPacket() {
        int n = 0;
        try {
            n = this.getInteger();
            this.checkFunction("List");
        }
        catch (MathLinkException mathLinkException) {
            this.handleCleanException(mathLinkException);
            return;
        }
        try {
            try {
                StdLink.setup(this);
                StdLink.lastPktWasAllowUIComputations(false);
                this.setInterrupted(0);
                switch (n) {
                    case 1: {
                        this.callJava();
                        return;
                    }
                    case 2: {
                        this.loadClass();
                        return;
                    }
                    case 3: {
                        this.throwFromMathematica();
                        return;
                    }
                    case 4: {
                        this.runGC();
                        return;
                    }
                    case 5: {
                        this.releaseInstance();
                        return;
                    }
                    case 6: {
                        this.releaseAllInstances();
                        return;
                    }
                    case 7: {
                        this.unloadClass();
                        return;
                    }
                    case 8: {
                        this.val();
                        return;
                    }
                    case 9: {
                        this.callOnLoadClass();
                        return;
                    }
                    case 10: {
                        this.callOnUnloadClass();
                        return;
                    }
                    case 11: {
                        this.setComplexCls();
                        return;
                    }
                    case 12: {
                        this.getComplexCls();
                        return;
                    }
                    case 13: {
                        this.reflect();
                        return;
                    }
                    case 14: {
                        this.showInFront();
                        return;
                    }
                    case 15: {
                        this.sameObjectQ();
                        return;
                    }
                    case 16: {
                        this.instanceOf();
                        return;
                    }
                    case 17: {
                        this.allowRaggedArrays();
                        return;
                    }
                    case 18: {
                        this.connectToFEServer();
                        return;
                    }
                    case 19: {
                        this.disconnectToFEServer();
                        return;
                    }
                    case 20: {
                        this.peekClasses();
                        return;
                    }
                    case 21: {
                        this.peekObjects();
                        return;
                    }
                    case 23: {
                        this.setSleep();
                        return;
                    }
                    case 22: {
                        this.setExtraDirs();
                        return;
                    }
                    case 25: {
                        this.uiThreadWaiting();
                        return;
                    }
                    case 24: {
                        this.allowUIComputations();
                        return;
                    }
                    case 26: {
                        this.forcePolling();
                        return;
                    }
                    case 27: {
                        this.yieldTime();
                        return;
                    }
                    case 28: {
                        this.comQueryInterface();
                        return;
                    }
                    case 29: {
                        this.comGetObject();
                        return;
                    }
                    default: {
                        return;
                    }
                }
            }
            catch (Exception exception) {
                return;
            }
        }
        finally {
            Object var3_7 = null;
            StdLink.remove();
            this.clearError();
            this.newPacket();
            try {
                this.endPacket();
                this.flush();
            }
            catch (MathLinkException mathLinkException) {}
        }
    }

    protected void handleCleanException(Throwable throwable) {
        try {
            this.clearError();
            this.newPacket();
            String string = Utils.createExceptionMessage(throwable);
            this.putFunction(MMA_HANDLECLEANEXCEPTION, 1);
            this.putFunction(MMA_AUTOEXCEPTION, 1);
            this.put(string);
            this.endPacket();
            this.flush();
        }
        catch (MathLinkException mathLinkException) {
            try {
                this.endPacket();
            }
            catch (MathLinkException mathLinkException2) {}
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void handlePacket(int var1_1) throws MathLinkException {
        switch (var1_1) {
            case 7: {
                this.handleCallPacket();
                break;
            }
            case 11: 
            case 12: {
                if (this.getFEServerLink() == null) break;
                if (this.accumulatingPS == null) {
                    this.accumulatingPS = new String("");
                }
                this.accumulatingPS = this.accumulatingPS.concat(this.getString());
                if (var1_1 != 12) break;
                var2_2 = this.getFEServerLink();
                var2_2.putFunction("FrontEnd`FrontEndExecute", 1);
                var2_2.putFunction("FrontEnd`NotebookWrite", 2);
                var2_2.putFunction("FrontEnd`SelectedNotebook", 0);
                var2_2.putFunction("Cell", 2);
                var2_2.putFunction("GraphicsData", 2);
                var2_2.put("PostScript");
                var2_2.put(this.accumulatingPS);
                var2_2.put("Graphics");
                var2_2.flush();
                this.accumulatingPS = null;
                break;
            }
            case 2: 
            case 101: {
                var2_3 = this.getFEServerLink();
                if (var2_3 == null) break;
                var2_3.putFunction("FrontEnd`FrontEndExecute", 1);
                var2_3.putFunction("FrontEnd`NotebookWrite", 2);
                var2_3.putFunction("FrontEnd`SelectedNotebook", 0);
                var2_3.putFunction("Cell", 2);
                var2_3.transferExpression(this);
                var2_3.put(this.lastPktWasMsg != false ? "Message" : "Print");
                var2_3.flush();
                break;
            }
            case 100: {
                var2_4 = this.getFEServerLink();
                if (var2_4 == null) ** GOTO lbl65
                var3_5 = this.createMark();
                try {
                    var7_6 = this.getFunction();
                    if (var7_6.name.equals("FrontEnd`FrontEndExecute")) ** GOTO lbl50
                    var2_4.putFunction("FrontEnd`FrontEndExecute", 1);
                }
                catch (Throwable var5_9) {
                    var6_8 = null;
                    this.seekMark(var3_5);
                    this.destroyMark(var3_5);
                    throw var5_9;
                }
lbl50:
                // 2 sources

                var6_7 = null;
                this.seekMark(var3_5);
                this.destroyMark(var3_5);
                var2_4.transferExpression(this);
                var2_4.flush();
                do {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException v0) {}
                } while (!var2_4.ready() && !this.ready());
                if (!var2_4.ready()) break;
                this.transferExpression(var2_4);
                this.flush();
                break;
lbl65:
                // 1 sources

                this.nextPacketExt();
                break;
            }
        }
        this.lastPktWasMsg = var1_1 == 5;
    }

    protected void instanceOf() throws MathLinkException {
        boolean bl;
        try {
            Object object = this.getObject();
            String string = this.getString();
            this.newPacket();
            Class clazz = JLinkClassLoader.classFromName(string);
            bl = clazz.isInstance(object);
        }
        catch (Exception exception) {
            this.handleCleanException(exception);
            return;
        }
        this.put(bl);
    }

    boolean isManual() {
        return this.isManual;
    }

    protected void loadClass() throws MathLinkException {
        int n;
        try {
            String string = this.getString();
            this.newPacket();
            n = this.objectHandler.loadClass(string);
        }
        catch (Throwable throwable) {
            this.handleCleanException(throwable);
            return;
        }
        this.objectHandler.putInfo(this, n);
    }

    public synchronized void message(String string, String string2) {
        String[] stringArray = new String[]{string2};
        this.message(string, stringArray);
    }

    public synchronized void message(String string, String[] stringArray) {
        try {
            this.putFunction("EvaluatePacket", 1);
            this.putFunction("Apply", 2);
            this.putFunction("ToExpression", 1);
            this.put("Function[Null, Message[#1, ##2], HoldFirst]");
            this.putFunction("Join", 2);
            this.putFunction("ToHeldExpression", 1);
            this.put(string);
            this.putFunction("Hold", stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                this.put(stringArray[n]);
                ++n;
            }
            this.endPacket();
            this.discardAnswer();
        }
        catch (MathLinkException mathLinkException) {
            this.clearError();
            this.newPacket();
        }
    }

    public void msgHandler(int n, int n2) {
        Object object = this.msgSync;
        synchronized (object) {
            this.msg = n;
        }
    }

    int nextPacketExt() throws MathLinkException {
        int n;
        long l = this.createMark();
        try {
            try {
                n = this.nextPacket();
            }
            catch (MathLinkException mathLinkException) {
                n = 100;
                this.clearError();
                this.seekMark(l);
                MLFunction mLFunction = this.getFunction();
                if (mLFunction.name.equals("ExpressionPacket")) {
                    n = 101;
                } else if (mLFunction.name.equals("BoxData")) {
                    this.seekMark(l);
                    n = 101;
                }
            }
            Object var5_5 = null;
            this.destroyMark(l);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.destroyMark(l);
            throw throwable;
        }
        return n;
    }

    protected void peekClasses() throws MathLinkException {
        this.objectHandler.peekClasses(this);
    }

    protected void peekObjects() throws MathLinkException {
        this.objectHandler.peekObjects(this);
    }

    public synchronized void print(String string) {
        try {
            this.putFunction("EvaluatePacket", 1);
            this.putFunction("Print", 1);
            this.put(string);
            this.endPacket();
            this.discardAnswer();
        }
        catch (MathLinkException mathLinkException) {
            this.clearError();
            this.newPacket();
        }
    }

    public synchronized void putReference(Object object) throws MathLinkException {
        if (object == null) {
            this.putSymbol("Null");
        } else {
            this.objectHandler.putReference(this, object);
        }
    }

    protected void reflect() throws MathLinkException {
        int n;
        int n2;
        boolean bl = true;
        int n3 = 0;
        try {
            n2 = this.getInteger();
            n = this.getInteger();
            bl = this.getSymbol().equals("True");
            this.newPacket();
            n3 = this.objectHandler.reflect(this, n2, n, bl, false);
        }
        catch (Exception exception) {
            this.handleCleanException(exception);
            return;
        }
        this.putFunction("List", n3);
        this.objectHandler.reflect(this, n2, n, bl, true);
    }

    protected void releaseAllInstances() throws MathLinkException {
        int n = 0;
        try {
            n = this.getInteger();
            this.newPacket();
            this.objectHandler.releaseAllInstances(n);
        }
        catch (Exception exception) {
            this.handleCleanException(exception);
            return;
        }
        this.put(n);
    }

    protected void releaseInstance() throws MathLinkException {
        try {
            String[] stringArray = this.getStringArray1();
            this.newPacket();
            this.objectHandler.releaseInstance(stringArray);
        }
        catch (Exception exception) {
            this.handleCleanException(exception);
            return;
        }
        this.putSymbol("Null");
    }

    protected void runGC() throws MathLinkException {
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.freeMemory();
        runtime.gc();
        this.put((int)(runtime.freeMemory() - l));
    }

    protected void sameObjectQ() throws MathLinkException {
        Object object = null;
        Object object2 = null;
        try {
            object = this.getObject();
            object2 = this.getObject();
            this.newPacket();
        }
        catch (Exception exception) {
            this.handleCleanException(exception);
            return;
        }
        this.put(object == object2);
    }

    protected void setComplexCls() throws MathLinkException {
        String string;
        try {
            int n = this.getInteger();
            this.newPacket();
            Class clazz = this.objectHandler.classFromIndex(n);
            string = this.setComplexClass(clazz) ? "Null" : "$Failed";
        }
        catch (Exception exception) {
            this.handleCleanException(exception);
            return;
        }
        this.putSymbol(string);
    }

    protected void setExtraDirs() throws MathLinkException {
        try {
            String[] stringArray = (String[])this.getArray(-9, 1);
            this.newPacket();
            JLinkClassLoader.setExtraDirs(stringArray);
        }
        catch (Exception exception) {
            this.handleCleanException(exception);
            return;
        }
        this.putSymbol("Null");
    }

    void setInterrupted(int n) {
        Object object = this.msgSync;
        synchronized (object) {
            this.msg = n;
        }
    }

    protected void setManual(boolean bl) {
        if (bl && !this.isManual) {
            try {
                this.putFunction(MMA_PREPAREFORMANUALRETURN, 1);
                this.putSymbol("$CurrentLink");
                this.flush();
            }
            catch (MathLinkException mathLinkException) {
                this.clearError();
            }
        }
        this.isManual = bl;
    }

    protected void setSleep() throws MathLinkException {
        try {
            int n = this.getInteger();
            this.newPacket();
            Reader.setSleepInterval(n);
        }
        catch (Exception exception) {
            this.handleCleanException(exception);
            return;
        }
        this.putSymbol("Null");
    }

    protected Window showInFront() throws MathLinkException {
        Object object = null;
        Window window = null;
        try {
            object = this.getObject();
            this.newPacket();
            window = (Window)object;
            ((Component)window).setVisible(true);
            window.toFront();
            if (Utils.isMicrosoftVM()) {
                window = null;
            }
        }
        catch (Exception exception) {
            this.handleCleanException(exception);
            return null;
        }
        this.putSymbol("Null");
        return window;
    }

    protected void throwFromMathematica() throws Exception {
        Exception exception = null;
        try {
            if (this.getType() == 35) {
                Object object = this.getObject();
                this.getString();
                this.newPacket();
                exception = (Exception)object;
            } else {
                String string = this.getString();
                String string2 = this.getString();
                this.newPacket();
                Class clazz = JLinkClassLoader.classFromName(string);
                Object[] objectArray = null;
                Constructor constructor = null;
                if (string2.length() == 0) {
                    constructor = clazz.getConstructor(new Class[0]);
                    objectArray = new Object[]{};
                } else {
                    constructor = clazz.getConstructor(class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = KernelLinkImpl.class$("java.lang.String")));
                    objectArray = new Object[]{string2};
                }
                exception = (Exception)constructor.newInstance(objectArray);
            }
        }
        catch (Exception exception2) {
            this.handleCleanException(exception2);
            return;
        }
        this.putSymbol("Null");
        throw exception;
    }

    protected void uiThreadWaiting() throws MathLinkException {
        this.newPacket();
        this.putSymbol(StdLink.uiThreadWaiting() ? "True" : "False");
    }

    protected void unloadClass() throws MathLinkException {
        int n = 0;
        try {
            n = this.getInteger();
            this.newPacket();
            this.objectHandler.unloadClass(n);
        }
        catch (Exception exception) {
            this.handleCleanException(exception);
            return;
        }
        this.put(n);
    }

    protected void val() throws MathLinkException {
        Object object = null;
        try {
            object = this.getObject();
            this.newPacket();
        }
        catch (Exception exception) {
            this.handleCleanException(exception);
            return;
        }
        this.put(object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int waitForAnswer() throws MathLinkException {
        int n = 0;
        if (!this.linkConnected) {
            this.connect();
            this.linkConnected = true;
        }
        while (true) {
            Object var5_3;
            long l = this.createMark();
            try {
                n = this.nextPacketExt();
                boolean bl = this.notifyPacketListeners(n);
                switch (n) {
                    case 3: 
                    case 4: 
                    case 8: 
                    case 16: {
                        if (bl) {
                            this.handlePacket(n);
                        }
                        var5_3 = null;
                        this.destroyMark(l);
                        return n;
                    }
                }
                if (n == 100) {
                    this.seekMark(l);
                }
                if (bl) {
                    this.handlePacket(n);
                }
                this.newPacket();
                continue;
            }
            finally {
                var5_3 = null;
                this.destroyMark(l);
                continue;
            }
            break;
        }
    }

    public boolean wasInterrupted() {
        int n = 0;
        Object object = this.msgSync;
        synchronized (object) {
            n = this.msg;
        }
        return n == 2 || n == 3;
    }

    protected void yieldTime() throws MathLinkException {
        try {
            int n = this.getInteger();
            this.newPacket();
            try {
                Thread.sleep(n);
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (Exception exception) {
            this.handleCleanException(exception);
            return;
        }
        this.putSymbol("Null");
    }
}

