/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.jlink;

import com.wolfram.jlink.InvalidMetafileException;
import com.wolfram.jlink.MetaObject;
import com.wolfram.jlink.MetafileHeader;
import com.wolfram.jlink.MetafileRecord;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.InputStream;

public abstract class Metafile {
    protected InputStream metaStream;
    private MetafileHeader header;
    private MetaObject[] objects;
    private int numObjects;
    private Color textColor;
    private Color penColor;
    private Color brushColor;
    private Font font;
    private double fontAngle;
    private int penWidth;
    private float xScale;
    private float yScale;
    private static Stroke strokeWidth1 = new BasicStroke(1.0f);
    private static String[] fontNames;
    private static final int DEBUGLEVEL = 0;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doRecord(MetafileRecord metafileRecord, Graphics graphics, Dimension dimension) {
        byte[] byArray = metafileRecord.getData();
        int n = byArray.length;
        switch (metafileRecord.getType()) {
            case 521: {
                int n2 = byArray[2];
                int n3 = byArray[1];
                int n4 = byArray[0];
                this.textColor = new Color(n2 >= 0 ? n2 : 256 + n2, n3 >= 0 ? n3 : 256 + n3, n4 >= 0 ? n4 : 256 + n4);
                return;
            }
            case 524: {
                this.xScale = (float)dimension.width / (float)Metafile.readUnsignedWordAtOffset(byArray, 0);
                this.yScale = (float)dimension.height / (float)Metafile.readUnsignedWordAtOffset(byArray, 2);
                return;
            }
            case 531: {
                System.out.println("GOT LINETO!!!!!!!!!");
                return;
            }
            case 532: {
                System.out.println("GOT MOVETO!!!!!!!!!");
                return;
            }
            case 1313: {
                int n5 = Metafile.readUnsignedWordAtOffset(byArray, 0);
                int n6 = this.scaleX(Metafile.readUnsignedWordAtOffset(byArray, n - 2));
                int n7 = this.scaleY(Metafile.readUnsignedWordAtOffset(byArray, n - 4));
                graphics.setColor(this.textColor);
                graphics.setFont(this.font);
                if (this.fontAngle != 0.0) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    AffineTransform affineTransform = graphics2D.getTransform();
                    AffineTransform affineTransform2 = (AffineTransform)affineTransform.clone();
                    affineTransform2.concatenate(AffineTransform.getRotateInstance(this.fontAngle, n6, n7));
                    graphics2D.setTransform(affineTransform2);
                    graphics2D.drawBytes(byArray, 2, n5, n6, n7);
                    graphics2D.setTransform(affineTransform);
                    return;
                }
                graphics.drawBytes(byArray, 2, n5, n6, n7);
                return;
            }
            case 804: {
                int n8 = Metafile.readUnsignedWordAtOffset(byArray, 0);
                int[] nArray = new int[n8];
                int[] nArray2 = new int[n8];
                int n9 = 0;
                while (n9 < n8) {
                    nArray[n9] = this.scaleX(Metafile.readUnsignedWordAtOffset(byArray, 2 + n9 * 4));
                    nArray2[n9] = this.scaleY(Metafile.readUnsignedWordAtOffset(byArray, 4 + n9 * 4));
                    ++n9;
                }
                graphics.setColor(this.brushColor);
                graphics.fillPolygon(nArray, nArray2, n8);
                return;
            }
            case 805: {
                int n10 = Metafile.readUnsignedWordAtOffset(byArray, 0);
                int[] nArray = new int[n10];
                int[] nArray3 = new int[n10];
                int n11 = 0;
                while (n11 < n10) {
                    nArray[n11] = this.scaleX(Metafile.readUnsignedWordAtOffset(byArray, 2 + n11 * 4));
                    nArray3[n11] = this.scaleY(Metafile.readUnsignedWordAtOffset(byArray, 4 + n11 * 4));
                    ++n11;
                }
                ((Graphics2D)graphics).setStroke(this.penWidth == 1 ? strokeWidth1 : new BasicStroke(this.penWidth));
                graphics.setColor(this.penColor);
                graphics.drawPolyline(nArray, nArray3, n10);
                return;
            }
            case 301: {
                int n12 = Metafile.readUnsignedWordAtOffset(byArray, 0);
                MetaObject metaObject = this.objects[n12];
                switch (metaObject.type) {
                    case 0: {
                        this.penWidth = metaObject.penWidth;
                        return;
                    }
                    case 2: {
                        this.font = metaObject.font;
                        this.fontAngle = metaObject.fontAngle;
                        return;
                    }
                    case 1: {
                        this.brushColor = metaObject.color;
                        return;
                    }
                    default: {
                        return;
                    }
                }
            }
            case 496: {
                int n13 = Metafile.readUnsignedWordAtOffset(byArray, 0);
                this.objects[n13] = null;
                return;
            }
            case 762: {
                MetaObject metaObject = new MetaObject(0, byArray, n, this.yScale);
                int n14 = 0;
                while (this.objects[n14] != null) {
                    ++n14;
                }
                this.objects[n14] = metaObject;
                this.penColor = metaObject.color;
                return;
            }
            case 763: {
                MetaObject metaObject = new MetaObject(2, byArray, n, this.yScale);
                int n15 = 0;
                while (this.objects[n15] != null) {
                    ++n15;
                }
                this.objects[n15] = metaObject;
                return;
            }
            case 764: {
                MetaObject metaObject = new MetaObject(1, byArray, n, this.yScale);
                int n16 = 0;
                while (this.objects[n16] != null) {
                    ++n16;
                }
                this.objects[n16] = metaObject;
                return;
            }
        }
    }

    private static void getFontNames() {
        if (fontNames != null) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            fontNames = graphicsEnvironment.getAvailableFontFamilyNames();
        }
    }

    public Dimension getIntendedSize() throws InvalidMetafileException {
        if (this.header == null) {
            try {
                this.rewind();
                this.header = new MetafileHeader(this);
            }
            catch (IOException iOException) {
                throw new InvalidMetafileException();
            }
        }
        if (!this.header.isAPMFile()) {
            throw new InvalidMetafileException();
        }
        return this.header.getIntendedSize();
    }

    public void play(Graphics graphics, Rectangle rectangle) throws InvalidMetafileException {
        MetafileRecord metafileRecord;
        try {
            this.rewind();
            this.header = new MetafileHeader(this);
        }
        catch (IOException iOException) {
            throw new InvalidMetafileException();
        }
        if (!this.header.isAPMFile()) {
            throw new InvalidMetafileException();
        }
        this.numObjects = this.header.maxObjects;
        this.objects = new MetaObject[this.numObjects];
        Metafile.getFontNames();
        graphics.translate(rectangle.x, rectangle.y);
        graphics.clearRect(0, 0, rectangle.width, rectangle.height);
        Dimension dimension = rectangle.getSize();
        while ((metafileRecord = new MetafileRecord(this)).getType() != -1) {
            this.doRecord(metafileRecord, graphics, dimension);
        }
        this.font = null;
    }

    int readByte() throws IOException {
        return this.metaStream.read();
    }

    int readBytes(byte[] byArray) throws IOException {
        return this.metaStream.read(byArray);
    }

    long readDWord() throws IOException {
        long l = this.readWord();
        long l2 = this.readWord();
        if (l == -1L || l2 == -1L) {
            return -1L;
        }
        return (l2 << 16) + l;
    }

    MetafileRecord readRecord() throws IOException {
        return new MetafileRecord(this);
    }

    static int readUnsignedWordAtOffset(byte[] byArray, int n) {
        int n2 = byArray[n];
        int n3 = byArray[n + 1];
        if (n2 < 0) {
            n2 += 256;
        }
        if (n3 < 0) {
            n3 += 256;
        }
        return (n3 << 8) + n2;
    }

    int readWord() throws IOException {
        int n = this.metaStream.read();
        int n2 = this.metaStream.read();
        if (n == -1 || n2 == -1) {
            return -1;
        }
        return (n2 << 8) + n;
    }

    public abstract void rewind() throws IOException;

    private int scaleX(int n) {
        return (int)((float)n * this.xScale);
    }

    private int scaleY(int n) {
        return (int)((float)n * this.yScale);
    }

    void skip(long l) throws IOException {
        this.metaStream.skip(l);
    }
}

