/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.jlink;

import com.wolfram.jlink.Expr;
import com.wolfram.jlink.LoopbackLink;
import com.wolfram.jlink.MLFunction;
import com.wolfram.jlink.MathLink;
import com.wolfram.jlink.MathLinkException;
import com.wolfram.jlink.MathLinkImpl;
import com.wolfram.jlink.NativeLoopbackLink;
import com.wolfram.jlink.Utils;
import com.wolfram.jlink.WrappedKernelLink;
import java.lang.reflect.Array;

public class NativeLink
extends MathLinkImpl {
    protected long link;
    protected int macSleepTime = 50;
    static final String LINK_NULL_MESSAGE = "Link is not open.";
    static final String CREATE_FAILED_MESSAGE = "Link failed to open.";
    private static Long holder = new Long(0L);
    private static Object mlEnvironmentLock = new Object();
    static /* synthetic */ Class class$java$lang$String;

    static {
        String string = "JLinkNativeLibrary";
        try {
            System.loadLibrary(string);
        }
        catch (SecurityException securityException) {
            System.err.println("Fatal error: security exception trying to load " + string + ". This thread does not have permission to load native libraries.");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println("Fatal error: cannot find the required native library named " + string + ".");
        }
    }

    protected NativeLink() {
        this.link = 0L;
    }

    public NativeLink(String string) throws MathLinkException {
        String string2 = Utils.determineLinkmode(string);
        if (string2 != null && string2.equals("exec")) {
            this.doExecMode(string, null);
        } else {
            Object object = mlEnvironmentLock;
            synchronized (object) {
                this.link = NativeLink.MLOpenString(string);
            }
        }
        if (this.link == 0L) {
            throw new MathLinkException(1004, CREATE_FAILED_MESSAGE);
        }
        if (Utils.isMacintosh()) {
            this.doMacSetup();
        }
    }

    public NativeLink(String[] stringArray) throws MathLinkException {
        String string = Utils.determineLinkmode(stringArray);
        if (string != null && string.equals("exec")) {
            this.doExecMode(null, stringArray);
        } else {
            Object object = mlEnvironmentLock;
            synchronized (object) {
                this.link = NativeLink.MLOpen(stringArray.length, stringArray);
            }
        }
        if (this.link == 0L) {
            throw new MathLinkException(1004, CREATE_FAILED_MESSAGE);
        }
        if (Utils.isMacintosh()) {
            this.doMacSetup();
        }
    }

    protected static native int MLBytesToGet(long var0);

    protected static native int MLBytesToPut(long var0);

    protected static native int MLCheckFunction(long var0, String var2);

    protected static native int MLCheckFunctionWithArgCount(long var0, String var2, int var3);

    protected static native boolean MLClearError(long var0);

    protected static native void MLClose(long var0);

    protected static native void MLConnect(long var0);

    protected static native long MLCreateMark(long var0);

    protected static native void MLDestroyMark(long var0, long var2);

    protected static native void MLEndPacket(long var0);

    protected static native int MLError(long var0);

    protected static native String MLErrorMessage(long var0);

    protected static native void MLFlush(long var0);

    protected static native int MLGetArgCount(long var0);

    protected static native Object MLGetArray(long var0, int var2, int var3);

    protected static native String[] MLGetArrayHeads();

    protected static native byte[] MLGetByteString(long var0, byte var2);

    protected static native byte[] MLGetData(long var0, int var2);

    protected static native double MLGetDouble(long var0);

    protected static native int MLGetInteger(long var0);

    protected static native int MLGetMessage(long var0);

    protected static native int MLGetNext(long var0);

    protected static native String MLGetString(long var0);

    protected static native String MLGetSymbol(long var0);

    protected static native int MLGetType(long var0);

    protected static native long MLLoopbackOpen();

    protected static native boolean MLMessageReady(long var0);

    protected static native String MLName(long var0);

    protected static native void MLNewPacket(long var0);

    protected static native int MLNextPacket(long var0);

    protected static native long MLOpen(int var0, String[] var1);

    protected static native long MLOpenString(String var0);

    protected static native void MLPutArgCount(long var0, int var2);

    protected static native void MLPutArray(long var0, int var2, Object var3, String var4);

    protected static native void MLPutArrayFlat(long var0, int var2, Object var3, String[] var4, int[] var5);

    protected static native void MLPutByteString(long var0, byte[] var2, int var3);

    protected static native void MLPutData(long var0, byte[] var2, int var3);

    protected static native void MLPutDouble(long var0, double var2);

    protected static native void MLPutInteger(long var0, int var2);

    protected static native void MLPutMessage(long var0, int var2);

    protected static native void MLPutNext(long var0, int var2);

    protected static native void MLPutSize(long var0, int var2);

    protected static native void MLPutString(long var0, String var2);

    protected static native void MLPutSymbol(long var0, String var2);

    protected static native boolean MLReady(long var0);

    protected static native void MLSeekMark(long var0, long var2);

    protected static native void MLSetError(long var0, int var2);

    protected native void MLSetMessageHandler(long var1);

    protected native void MLSetYieldFunction(long var1);

    protected static native void MLTransferExpression(long var0, long var2);

    protected static native void MLTransferToEndOfLoopbackLink(long var0, long var2);

    public synchronized void activate() throws MathLinkException {
        this.connect();
    }

    public synchronized boolean addMessageHandler(Class clazz, Object object, String string) {
        boolean bl = super.addMessageHandler(clazz, object, string);
        if (bl) {
            this.MLSetMessageHandler(this.link);
        }
        return bl;
    }

    public synchronized int bytesToGet() throws MathLinkException {
        if (this.link == 0L) {
            throw new MathLinkException(1000, LINK_NULL_MESSAGE);
        }
        int n = NativeLink.MLBytesToGet(this.link);
        int n2 = NativeLink.MLError(this.link);
        if (NativeLink.isException(n2)) {
            throw new MathLinkException(n2, NativeLink.MLErrorMessage(this.link));
        }
        return n;
    }

    public synchronized int bytesToPut() throws MathLinkException {
        if (this.link == 0L) {
            throw new MathLinkException(1000, LINK_NULL_MESSAGE);
        }
        int n = NativeLink.MLBytesToPut(this.link);
        int n2 = NativeLink.MLError(this.link);
        if (NativeLink.isException(n2)) {
            throw new MathLinkException(n2, NativeLink.MLErrorMessage(this.link));
        }
        return n;
    }

    public synchronized int checkFunction(String string) throws MathLinkException {
        if (this.link == 0L) {
            throw new MathLinkException(1000, LINK_NULL_MESSAGE);
        }
        int n = NativeLink.MLCheckFunction(this.link, string);
        int n2 = NativeLink.MLError(this.link);
        if (n2 == 0) {
            return n;
        }
        throw new MathLinkException(n2, NativeLink.MLErrorMessage(this.link));
    }

    public synchronized void checkFunctionWithArgCount(String string, int n) throws MathLinkException {
        if (this.link == 0L) {
            throw new MathLinkException(1000, LINK_NULL_MESSAGE);
        }
        int n2 = NativeLink.MLCheckFunctionWithArgCount(this.link, string, n);
        int n3 = NativeLink.MLError(this.link);
        if (NativeLink.isException(n3)) {
            throw new MathLinkException(n3, NativeLink.MLErrorMessage(this.link));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public synchronized boolean clearError() {
        if (this.link == 0L) {
            return false;
        }
        return NativeLink.MLClearError(this.link);
    }

    public synchronized void close() {
        if (this.link != 0L) {
            Object object = mlEnvironmentLock;
            synchronized (object) {
                NativeLink.MLClose(this.link);
            }
            this.link = 0L;
        }
    }

    public synchronized void connect() throws MathLinkException {
        if (this.link == 0L) {
            throw new MathLinkException(1000, LINK_NULL_MESSAGE);
        }
        NativeLink.MLConnect(this.link);
        int n = NativeLink.MLError(this.link);
        if (NativeLink.isException(n)) {
            throw new MathLinkException(n, NativeLink.MLErrorMessage(this.link));
        }
    }

    public synchronized long createMark() throws MathLinkException {
        if (this.link == 0L) {
            throw new MathLinkException(1000, LINK_NULL_MESSAGE);
        }
        long l = NativeLink.MLCreateMark(this.link);
        int n = NativeLink.MLError(this.link);
        if (!NativeLink.isException(n)) {
            return l;
        }
        throw new MathLinkException(n, NativeLink.MLErrorMessage(this.link));
    }

    public synchronized void destroyMark(long l) {
        if (this.link == 0L) {
            return;
        }
        NativeLink.MLDestroyMark(this.link, l);
    }

    private void doExecMode(String string, String[] stringArray) throws MathLinkException {
        Object object = mlEnvironmentLock;
        synchronized (object) {
            this.link = NativeLink.MLOpenString("-linkmode listen -linkprotocol tcp -linkoptions MLDontInteract");
        }
        if (this.link == 0L) {
            throw new MathLinkException(1004, "Link open failed for exec mode.");
        }
        try {
            object = NativeLink.MLName(this.link);
            Process process = null;
            if (string != null) {
                int n = string.indexOf("-linkmode exec");
                String string2 = String.valueOf(string.substring(0, n)) + string.substring(n + 14) + " -linkmode connect -linkprotocol tcp -linkname " + (String)object;
                process = Runtime.getRuntime().exec(string2);
            } else {
                String[] stringArray2 = new String[stringArray.length + 4];
                System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
                int n = 0;
                while (n < stringArray.length) {
                    if (stringArray2[n].equals("exec")) {
                        stringArray2[n] = "connect";
                    }
                    ++n;
                }
                stringArray2[stringArray2.length - 4] = "-linkprotocol";
                stringArray2[stringArray2.length - 3] = "tcp";
                stringArray2[stringArray2.length - 2] = "-linkname";
                stringArray2[stringArray2.length - 1] = object;
                process = Runtime.getRuntime().exec(stringArray2);
            }
            if (process == null) {
                throw new MathLinkException(1004, "Process was null");
            }
        }
        catch (Exception exception) {
            NativeLink.MLClose(this.link);
            throw new MathLinkException(1004, exception.toString());
        }
    }

    private void doMacSetup() {
        this.setYieldFunction(null, null, null);
    }

    public synchronized void endPacket() throws MathLinkException {
        if (this.link == 0L) {
            throw new MathLinkException(1000, LINK_NULL_MESSAGE);
        }
        NativeLink.MLEndPacket(this.link);
        int n = NativeLink.MLError(this.link);
        if (NativeLink.isException(n)) {
            throw new MathLinkException(n, NativeLink.MLErrorMessage(this.link));
        }
    }

    public synchronized int error() {
        if (this.link == 0L) {
            return 1000;
        }
        return NativeLink.MLError(this.link);
    }

    public synchronized String errorMessage() {
        if (this.link == 0L) {
            return LINK_NULL_MESSAGE;
        }
        if (this.error() >= 1000) {
            return MathLinkException.lookupMessageText(this.error());
        }
        return NativeLink.MLErrorMessage(this.link);
    }

    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            Object var2_1 = null;
            this.close();
        }
    }

    private static void flattenInto(Object object, int[] nArray, int n, Object object2, int n2, int n3) {
        int n4 = nArray[n];
        if (n == nArray.length - 1) {
            if (n3 == -2) {
                byte[] byArray = (byte[])object;
                int n5 = 0;
                while (n5 < n4) {
                    Array.setShort(object2, n2++, byArray[n5]);
                    ++n5;
                }
            } else if (n3 == -3) {
                char[] cArray = (char[])object;
                int n6 = 0;
                while (n6 < n4) {
                    Array.setInt(object2, n2++, cArray[n6]);
                    ++n6;
                }
            } else {
                System.arraycopy(object, 0, object2, n2, n4);
            }
        } else {
            int n7 = 1;
            int n8 = n + 1;
            while (n8 < nArray.length) {
                n7 *= nArray[n8];
                ++n8;
            }
            n8 = 0;
            while (n8 < n4) {
                NativeLink.flattenInto(Array.get(object, n8), nArray, n + 1, object2, n2 + n7 * n8, n3);
                ++n8;
            }
        }
    }

    public synchronized void flush() throws MathLinkException {
        if (this.link == 0L) {
            throw new MathLinkException(1000, LINK_NULL_MESSAGE);
        }
        NativeLink.MLFlush(this.link);
        int n = NativeLink.MLError(this.link);
        if (NativeLink.isException(n)) {
            throw new MathLinkException(n, NativeLink.MLErrorMessage(this.link));
        }
    }

    public synchronized int getArgCount() throws MathLinkException {
        if (this.link == 0L) {
            throw new MathLinkException(1000, LINK_NULL_MESSAGE);
        }
        int n = NativeLink.MLGetArgCount(this.link);
        int n2 = NativeLink.MLError(this.link);
        if (n2 == 0) {
            return n;
        }
        throw new MathLinkException(n2, NativeLink.MLErrorMessage(this.link));
    }

    public synchronized Object getArray(int n, int n2) throws MathLinkException {
        Object object = null;
        if (this.link == 0L) {
            throw new MathLinkException(1000, LINK_NULL_MESSAGE);
        }
        if (!(n < -9 || n2 != 1 && Utils.isRaggedArrays())) {
            object = NativeLink.MLGetArray(this.link, n, n2);
            int n3 = NativeLink.MLError(this.link);
            if (n3 > 1000) {
                throw new MathLinkException(n3);
            }
            if (n3 != 0) {
                throw new MathLinkException(n3, NativeLink.MLErrorMessage(this.link));
            }
        } else {
            object = super.getArray(n, n2);
        }
        return object;
    }

    public synchronized byte[] getByteString(int n) throws MathLinkException {
        if (this.link == 0L) {
            throw new MathLinkException(1000, LINK_NULL_MESSAGE);
        }
        byte[] byArray = NativeLink.MLGetByteString(this.link, (byte)n);
        int n2 = NativeLink.MLError(this.link);
        if (n2 == 0) {
            return byArray;
        }
        throw new MathLinkException(n2, NativeLink.MLErrorMessage(this.link));
    }

    public synchronized byte[] getData(int n) throws MathLinkException {
        if (this.link == 0L) {
            throw new MathLinkException(1000, LINK_NULL_MESSAGE);
        }
        byte[] byArray = NativeLink.MLGetData(this.link, n);
        int n2 = NativeLink.MLError(this.link);
        if (NativeLink.isException(n2)) {
            throw new MathLinkException(n2, NativeLink.MLErrorMessage(this.link));
        }
        return byArray;
    }

    public synchronized double getDouble() throws MathLinkException {
        if (this.link == 0L) {
            throw new MathLinkException(1000, LINK_NULL_MESSAGE);
        }
        double d = NativeLink.MLGetDouble(this.link);
        int n = NativeLink.MLError(this.link);
        if (n == 0) {
            return d;
        }
        throw new MathLinkException(n, NativeLink.MLErrorMessage(this.link));
    }

    public synchronized Expr getExpr() throws MathLinkException {
        return new Expr(this);
    }

    public synchronized MLFunction getFunction() throws MathLinkException {
        if (this.link == 0L) {
            throw new MathLinkException(1000, LINK_NULL_MESSAGE);
        }
        int n = NativeLink.MLGetType(this.link);
        if (n != 70) {
            NativeLink.MLSetError(this.link, 3);
            throw new MathLinkException(NativeLink.MLError(this.link), NativeLink.MLErrorMessage(this.link));
        }
        int n2 = NativeLink.MLGetArgCount(this.link);
        String string = NativeLink.MLGetSymbol(this.link);
        int n3 = NativeLink.MLError(this.link);
        if (n3 == 0) {
            return new MLFunction(string, n2);
        }
        throw new MathLinkException(n3, NativeLink.MLErrorMessage(this.link));
    }

    public synchronized int getInteger() throws MathLinkException {
        if (this.link == 0L) {
            throw new MathLinkException(1000, LINK_NULL_MESSAGE);
        }
        int n = NativeLink.MLGetInteger(this.link);
        int n2 = NativeLink.MLError(this.link);
        if (n2 == 0) {
            return n;
        }
        throw new MathLinkException(n2, NativeLink.MLErrorMessage(this.link));
    }

    synchronized long getLink() {
        return this.link;
    }

    public synchronized long getLongInteger() throws MathLinkException {
        if (this.link == 0L) {
            throw new MathLinkException(1000, LINK_NULL_MESSAGE);
        }
        String string = NativeLink.MLGetString(this.link);
        int n = NativeLink.MLError(this.link);
        if (n == 0) {
            return Long.parseLong(string);
        }
        throw new MathLinkException(n, NativeLink.MLErrorMessage(this.link));
    }

    synchronized int getMacSleepTime() {
        return this.macSleepTime;
    }

    public int getMessage() throws MathLinkException {
        if (this.link == 0L) {
            throw new MathLinkException(1000, LINK_NULL_MESSAGE);
        }
        return NativeLink.MLGetMessage(this.link);
    }

    protected static native int getMsg(long var0);

    public synchronized int getNext() throws MathLinkException {
        if (this.link == 0L) {
            throw new MathLinkException(1000, LINK_NULL_MESSAGE);
        }
        int n = NativeLink.MLGetNext(this.link);
        int n2 = NativeLink.MLError(this.link);
        if (n2 == 0) {
            return n;
        }
        throw new MathLinkException(n2, NativeLink.MLErrorMessage(this.link));
    }

    public synchronized String getString() throws MathLinkException {
        if (this.link == 0L) {
            throw new MathLinkException(1000, LINK_NULL_MESSAGE);
        }
        String string = NativeLink.MLGetString(this.link);
        int n = NativeLink.MLError(this.link);
        if (n == 0) {
            return string;
        }
        throw new MathLinkException(n, NativeLink.MLErrorMessage(this.link));
    }

    public synchronized String getSymbol() throws MathLinkException {
        if (this.link == 0L) {
            throw new MathLinkException(1000, LINK_NULL_MESSAGE);
        }
        String string = NativeLink.MLGetSymbol(this.link);
        int n = NativeLink.MLError(this.link);
        if (n == 0) {
            return string;
        }
        throw new MathLinkException(n, NativeLink.MLErrorMessage(this.link));
    }

    public synchronized int getType() throws MathLinkException {
        if (this.link == 0L) {
            throw new MathLinkException(1000, LINK_NULL_MESSAGE);
        }
        int n = NativeLink.MLGetType(this.link);
        int n2 = NativeLink.MLError(this.link);
        if (n2 == 0) {
            return n;
        }
        throw new MathLinkException(n2, NativeLink.MLErrorMessage(this.link));
    }

    static native void hideJavaWindow();

    protected static final boolean isException(int n) {
        return n != 0 && n != 10;
    }

    static native void javaLayerToFront();

    public boolean messageReady() throws MathLinkException {
        if (this.link == 0L) {
            throw new MathLinkException(1000, LINK_NULL_MESSAGE);
        }
        return NativeLink.MLMessageReady(this.link);
    }

    public synchronized String name() throws MathLinkException {
        if (this.link == 0L) {
            throw new MathLinkException(1000, LINK_NULL_MESSAGE);
        }
        String string = NativeLink.MLName(this.link);
        int n = NativeLink.MLError(this.link);
        if (NativeLink.isException(n)) {
            throw new MathLinkException(n, NativeLink.MLErrorMessage(this.link));
        }
        return string;
    }

    private void nativeMessageCallback(int n, int n2) {
        this.messageCallback(n, n2);
    }

    protected static native boolean nativeSizesMatch(int var0);

    private boolean nativeYielderCallback(boolean bl) {
        boolean bl2;
        block2: {
            bl2 = this.yielderCallback();
            if (bl2 || !Utils.isMacintosh() || this.macSleepTime < 0) break block2;
            try {
                Thread.sleep(bl ? this.macSleepTime : 0);
            }
            catch (InterruptedException interruptedException) {}
        }
        return bl2;
    }

    public synchronized void newPacket() {
        NativeLink.MLNewPacket(this.link);
    }

    public synchronized int nextPacket() throws MathLinkException {
        if (this.link == 0L) {
            throw new MathLinkException(1000, LINK_NULL_MESSAGE);
        }
        int n = NativeLink.MLNextPacket(this.link);
        int n2 = NativeLink.MLError(this.link);
        if (n2 == 0) {
            return n;
        }
        throw new MathLinkException(n2, NativeLink.MLErrorMessage(this.link));
    }

    public synchronized Expr peekExpr() throws MathLinkException {
        long l = this.createMark();
        try {
            Expr expr = new Expr(this);
            Object var5_3 = null;
            this.seekMark(l);
            this.destroyMark(l);
            return expr;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.seekMark(l);
            this.destroyMark(l);
            throw throwable;
        }
    }

    public synchronized void put(double d) throws MathLinkException {
        if (this.link == 0L) {
            throw new MathLinkException(1000, LINK_NULL_MESSAGE);
        }
        if (Double.isInfinite(d)) {
            NativeLink.MLPutSymbol(this.link, "Infinity");
        } else if (Double.isNaN(d)) {
            NativeLink.MLPutSymbol(this.link, "Indeterminate");
        } else {
            NativeLink.MLPutDouble(this.link, d);
        }
        int n = NativeLink.MLError(this.link);
        if (NativeLink.isException(n)) {
            throw new MathLinkException(n, NativeLink.MLErrorMessage(this.link));
        }
    }

    public synchronized void put(int n) throws MathLinkException {
        if (this.link == 0L) {
            throw new MathLinkException(1000, LINK_NULL_MESSAGE);
        }
        NativeLink.MLPutInteger(this.link, n);
        int n2 = NativeLink.MLError(this.link);
        if (NativeLink.isException(n2)) {
            throw new MathLinkException(n2, NativeLink.MLErrorMessage(this.link));
        }
    }

    public synchronized void put(long l) throws MathLinkException {
        if (this.link == 0L) {
            throw new MathLinkException(1000, LINK_NULL_MESSAGE);
        }
        NativeLink.MLPutNext(this.link, 43);
        byte[] byArray = String.valueOf(l).getBytes();
        NativeLink.MLPutSize(this.link, byArray.length);
        NativeLink.MLPutData(this.link, byArray, byArray.length);
        int n = NativeLink.MLError(this.link);
        if (NativeLink.isException(n)) {
            throw new MathLinkException(n, NativeLink.MLErrorMessage(this.link));
        }
    }

    public synchronized void put(boolean bl) throws MathLinkException {
        if (this.link == 0L) {
            throw new MathLinkException(1000, LINK_NULL_MESSAGE);
        }
        NativeLink.MLPutSymbol(this.link, bl ? "True" : "False");
        int n = NativeLink.MLError(this.link);
        if (NativeLink.isException(n)) {
            throw new MathLinkException(n, NativeLink.MLErrorMessage(this.link));
        }
    }

    public synchronized void putArgCount(int n) throws MathLinkException {
        if (this.link == 0L) {
            throw new MathLinkException(1000, LINK_NULL_MESSAGE);
        }
        NativeLink.MLPutArgCount(this.link, n);
        int n2 = NativeLink.MLError(this.link);
        if (NativeLink.isException(n2)) {
            throw new MathLinkException(n2, NativeLink.MLErrorMessage(this.link));
        }
    }

    protected void putArray(Object object, String[] stringArray) throws MathLinkException {
        int n;
        if (this.link == 0L) {
            throw new MathLinkException(1000, LINK_NULL_MESSAGE);
        }
        Class<?> clazz = object.getClass();
        Class clazz2 = Utils.getArrayComponentType(clazz);
        int n2 = 0;
        if (clazz2.isPrimitive()) {
            if (clazz2.equals(Integer.TYPE)) {
                n2 = -5;
            } else if (clazz2.equals(Double.TYPE)) {
                n2 = -8;
            } else if (clazz2.equals(Byte.TYPE)) {
                n2 = -2;
            } else if (clazz2.equals(Character.TYPE)) {
                n2 = -3;
            } else if (clazz2.equals(Short.TYPE)) {
                n2 = -4;
            } else if (clazz2.equals(Long.TYPE)) {
                n2 = -6;
            } else if (clazz2.equals(Float.TYPE)) {
                n2 = -7;
            } else if (clazz2.equals(Boolean.TYPE)) {
                n2 = -1;
            }
        } else if (clazz2.equals(class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = NativeLink.class$("java.lang.String")))) {
            n2 = -9;
        }
        if (n2 != 0) {
            n = clazz.getName().lastIndexOf(91) + 1;
            if (n == 1) {
                NativeLink.MLPutArray(this.link, n2, object, stringArray != null ? stringArray[0] : "List");
            } else if (n > 1 && n2 != -9 && n2 != -1 && !Utils.isRaggedArrays() && NativeLink.nativeSizesMatch(n2)) {
                int[] nArray = Utils.getArrayDims(object);
                int n3 = 1;
                int n4 = 0;
                while (n4 < nArray.length) {
                    n3 *= nArray[n4];
                    ++n4;
                }
                Object object2 = n2 == -2 ? Array.newInstance(Short.TYPE, n3) : (n2 == -3 ? Array.newInstance(Integer.TYPE, n3) : Array.newInstance(clazz2, n3));
                NativeLink.flattenInto(object, nArray, 0, object2, 0, n2);
                NativeLink.MLPutArrayFlat(this.link, n2, object2, stringArray, nArray);
            } else {
                String[] stringArray2;
                if (stringArray != null && stringArray.length == n) {
                    stringArray2 = stringArray;
                } else {
                    stringArray2 = new String[n];
                    int n5 = 0;
                    while (n5 < n) {
                        stringArray2[n5] = "List";
                        ++n5;
                    }
                }
                this.putArraySlices(object, n2, stringArray2, 0);
            }
        } else {
            this.putArrayPiecemeal(object, stringArray, 0);
        }
        n = NativeLink.MLError(this.link);
        if (NativeLink.isException(n)) {
            throw new MathLinkException(n, NativeLink.MLErrorMessage(this.link));
        }
    }

    private void putArraySlices(Object object, int n, String[] stringArray, int n2) throws MathLinkException {
        if (n2 == stringArray.length - 1) {
            NativeLink.MLPutArray(this.link, n, object, stringArray[n2]);
        } else {
            int n3 = Array.getLength(object);
            this.putFunction(stringArray[n2], n3);
            int n4 = 0;
            while (n4 < n3) {
                this.putArraySlices(Array.get(object, n4), n, stringArray, n2 + 1);
                ++n4;
            }
        }
    }

    public synchronized void putByteString(byte[] byArray) throws MathLinkException {
        if (this.link == 0L) {
            throw new MathLinkException(1000, LINK_NULL_MESSAGE);
        }
        NativeLink.MLPutByteString(this.link, byArray, byArray.length);
        int n = NativeLink.MLError(this.link);
        if (NativeLink.isException(n)) {
            throw new MathLinkException(n, NativeLink.MLErrorMessage(this.link));
        }
    }

    public synchronized void putData(byte[] byArray, int n) throws MathLinkException {
        if (this.link == 0L) {
            throw new MathLinkException(1000, LINK_NULL_MESSAGE);
        }
        NativeLink.MLPutData(this.link, byArray, n);
        int n2 = NativeLink.MLError(this.link);
        if (NativeLink.isException(n2)) {
            throw new MathLinkException(n2, NativeLink.MLErrorMessage(this.link));
        }
    }

    public synchronized void putFunction(String string, int n) throws MathLinkException {
        if (this.link == 0L) {
            throw new MathLinkException(1000, LINK_NULL_MESSAGE);
        }
        NativeLink.MLPutNext(this.link, 70);
        NativeLink.MLPutArgCount(this.link, n);
        NativeLink.MLPutSymbol(this.link, string);
        int n2 = NativeLink.MLError(this.link);
        if (NativeLink.isException(n2)) {
            throw new MathLinkException(n2, NativeLink.MLErrorMessage(this.link));
        }
    }

    public void putMessage(int n) throws MathLinkException {
        if (this.link == 0L) {
            throw new MathLinkException(1000, LINK_NULL_MESSAGE);
        }
        NativeLink.MLPutMessage(this.link, n);
    }

    public synchronized void putNext(int n) throws MathLinkException {
        if (this.link == 0L) {
            throw new MathLinkException(1000, LINK_NULL_MESSAGE);
        }
        NativeLink.MLPutNext(this.link, n);
        int n2 = NativeLink.MLError(this.link);
        if (NativeLink.isException(n2)) {
            throw new MathLinkException(n2, NativeLink.MLErrorMessage(this.link));
        }
    }

    public synchronized void putSize(int n) throws MathLinkException {
        if (this.link == 0L) {
            throw new MathLinkException(1000, LINK_NULL_MESSAGE);
        }
        NativeLink.MLPutSize(this.link, n);
        int n2 = NativeLink.MLError(this.link);
        if (NativeLink.isException(n2)) {
            throw new MathLinkException(n2, NativeLink.MLErrorMessage(this.link));
        }
    }

    protected void putString(String string) throws MathLinkException {
        if (this.link == 0L) {
            throw new MathLinkException(1000, LINK_NULL_MESSAGE);
        }
        NativeLink.MLPutString(this.link, string);
        int n = NativeLink.MLError(this.link);
        if (NativeLink.isException(n)) {
            throw new MathLinkException(n, NativeLink.MLErrorMessage(this.link));
        }
    }

    public synchronized void putSymbol(String string) throws MathLinkException {
        if (this.link == 0L) {
            throw new MathLinkException(1000, LINK_NULL_MESSAGE);
        }
        NativeLink.MLPutSymbol(this.link, string);
        int n = NativeLink.MLError(this.link);
        if (NativeLink.isException(n)) {
            throw new MathLinkException(n, NativeLink.MLErrorMessage(this.link));
        }
    }

    public synchronized boolean ready() throws MathLinkException {
        if (this.link == 0L) {
            throw new MathLinkException(1000, LINK_NULL_MESSAGE);
        }
        return NativeLink.MLReady(this.link);
    }

    public synchronized void seekMark(long l) {
        if (this.link == 0L) {
            return;
        }
        NativeLink.MLSeekMark(this.link, l);
    }

    public synchronized void setError(int n) {
        NativeLink.MLSetError(this.link, n);
    }

    synchronized void setMacSleepTime(int n) {
        this.macSleepTime = n;
    }

    protected static native void setMsg(long var0, int var2);

    public synchronized boolean setYieldFunction(Class clazz, Object object, String string) {
        boolean bl = super.setYieldFunction(clazz, object, string);
        if (bl) {
            this.MLSetYieldFunction(this.link);
        }
        return bl;
    }

    public synchronized void transferExpression(MathLink mathLink) throws MathLinkException {
        if (this.link == 0L || mathLink == null) {
            throw new MathLinkException(1000, LINK_NULL_MESSAGE);
        }
        if (mathLink instanceof NativeLink) {
            NativeLink.MLTransferExpression(this.link, ((NativeLink)mathLink).link);
        } else if (mathLink instanceof WrappedKernelLink) {
            this.transferExpression(((WrappedKernelLink)mathLink).getMathLink());
        } else {
            this.put(mathLink.getExpr());
        }
        int n = NativeLink.MLError(this.link);
        if (NativeLink.isException(n)) {
            throw new MathLinkException(n, NativeLink.MLErrorMessage(this.link));
        }
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void transferToEndOfLoopbackLink(LoopbackLink var1_1) throws MathLinkException {
        block3: {
            if (this.link == 0L || var1_1 == null) {
                throw new MathLinkException(1000, "Link is not open.");
            }
            if (!(var1_1 instanceof NativeLoopbackLink)) ** GOTO lbl7
            NativeLink.MLTransferToEndOfLoopbackLink(this.link, ((NativeLoopbackLink)var1_1).getLink());
            break block3;
lbl-1000:
            // 1 sources

            {
                this.transferExpression(var1_1);
lbl7:
                // 2 sources

                ** while (var1_1.ready())
            }
        }
        var2_2 = NativeLink.MLError(this.link);
        if (NativeLink.isException(var2_2)) {
            throw new MathLinkException(var2_2, NativeLink.MLErrorMessage(this.link));
        }
    }
}

