/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import java.awt.Color;
import java.io.Serializable;
import java.util.Vector;
import jv.geom.PgBndConstraint;
import jv.geom.PgBndPolygon;
import jv.geom.PgElementEdge;
import jv.geom.PgPointSet;
import jv.geom.PgPolygon;
import jv.geom.PgUtil;
import jv.geom.PgVectorField;
import jv.number.PdColor;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.objectGui.PsImage;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.project.PvGeometryIf;
import jv.project.PvPickEvent;
import jv.vecmath.P_Vector;
import jv.vecmath.PdBary;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;

public class PgElementSet
extends PgPointSet {
    protected boolean m_bShowEdgeLabels;
    protected boolean m_bShowElementLabels;
    protected int m_dimOfElements;
    protected int m_numElements;
    protected int m_maxNumElements;
    protected PiVector[] m_element;
    protected Color[] m_elementColor;
    protected Color[] m_elementBackColor;
    protected PdVector[] m_elementNormal;
    protected PiVector[] m_neighbour;
    protected PgBndPolygon[] m_bndList;
    protected boolean m_bShowBoundaries;
    protected boolean m_bShowTaggedBoundaries;
    protected PdColor m_globalBndColor;
    protected PdColor m_globalBndTagColor;
    protected PuDouble m_globalBndSize;
    protected boolean m_bConforming = true;
    protected PiVector[] m_elementSaved;
    protected int m_savedNumVertices;
    protected boolean m_bShowElementTexture;
    protected PdVector[][] m_elementTexture;
    protected boolean m_bShowOutline;
    protected int m_numEdges;
    protected PiVector[] m_edge;
    protected boolean m_bShowEdges;
    protected boolean m_bShowTaggedEdges;
    protected Color[] m_edgeColor;
    protected boolean m_bShowEdgeColors;
    protected PdColor m_globalEdgeColor;
    protected PdColor m_globalEdgeTagColor;
    protected PuDouble m_globalEdgeSize;
    protected boolean m_bShowElements;
    protected boolean m_bShowTaggedElements;
    protected boolean m_bShowBackface;
    protected boolean m_bShowElementNormals;
    protected boolean m_bShowElementNormalArrow;
    protected PuDouble m_globalElementNormalLength;
    protected PuDouble m_globalElementNormalSize;
    protected PdColor m_globalElementNormalColor;
    protected boolean m_bShowElementColors;
    protected PdColor m_globalElementColor;
    protected PdColor m_globalElementTagColor;
    protected PdColor m_globalElementBackColor;
    protected boolean m_bShowElementBackColor;
    protected boolean m_bShowElementBackColors;
    private static /* synthetic */ Class class$jv$geom$PgElementSet;

    public boolean refineGlobalIntoFour() {
        int n;
        Object object;
        Serializable serializable;
        int n2;
        int n3;
        int n4;
        Serializable serializable2;
        int n5;
        int n6;
        int n7;
        int[][] nArrayArray = new int[4][];
        nArrayArray[0] = new int[]{3, 4, 5};
        int[] nArray = new int[3];
        nArray[1] = 5;
        nArray[2] = 4;
        nArrayArray[1] = nArray;
        nArrayArray[2] = new int[]{1, 3, 5};
        nArrayArray[3] = new int[]{2, 4, 3};
        int[][] nArrayArray2 = nArrayArray;
        int[] nArray2 = new int[6];
        if (this.m_dimOfElements != 3 && (n7 = PgElementSet.triangulate(this)) == 0) {
            PsDebug.error("initial triangulation failed", this);
            return false;
        }
        this.makeNeighbour();
        int n8 = this.m_numVertices;
        int n9 = this.m_numElements;
        n7 = this.m_numVertices + this.getNumEdges();
        this.setNumVertices(n7);
        PdVector[][] pdVectorArray = this.hasElementTextures() ? this.getElementTextures() : new PdVector[1][1];
        this.setNumElements(4 * n9);
        if (this.m_bndList != null) {
            n6 = 0;
            while (n6 < this.m_bndList.length) {
                if (!this.m_bndList[n6].hasTag(2)) {
                    n5 = this.m_bndList[n6].getNumVertices();
                    serializable2 = this.m_bndList[n6];
                    ((PgPointSet)serializable2).setNumVertices(2 * n5 - 1);
                    n4 = n5 - 1;
                    while (n4 >= 0) {
                        ((PgBndPolygon)serializable2).m_vertexInd.m_data[2 * n4] = ((PgBndPolygon)serializable2).m_vertexInd.m_data[n4];
                        --n4;
                    }
                }
                ++n6;
            }
        }
        serializable2 = new PiVector(n7 - n8);
        PiVector piVector = new PiVector(n7 - n8);
        int n10 = n8 - 1;
        n6 = n9 - 1;
        while (n6 >= 0) {
            n4 = 0;
            do {
                if (this.m_neighbour[n6].m_data[n4] >= n6) continue;
                if (++n10 == this.m_numVertices) {
                    PsDebug.error("internal error", this);
                    return false;
                }
                n3 = this.m_element[n6].m_data[(n4 + 3 - 1) % 3];
                n2 = this.m_element[n6].m_data[(n4 + 1) % 3];
                ((PiVector)serializable2).setEntry(n10 - n8, n3);
                piVector.setEntry(n10 - n8, n2);
                this.m_vertex[n10].blend(0.5, this.m_vertex[n3], 0.5, this.m_vertex[n2]);
            } while (++n4 < 3);
            --n6;
        }
        if (this.hasVertexColors()) {
            n10 = n8 - 1;
            n6 = n9 - 1;
            while (n6 >= 0) {
                n4 = 0;
                do {
                    if (this.m_neighbour[n6].m_data[n4] >= n6) continue;
                    Color color = this.getVertexColor(this.m_element[n6].m_data[(n4 + 3 - 1) % 3]);
                    Color color2 = this.getVertexColor(this.m_element[n6].m_data[(n4 + 1) % 3]);
                    serializable = PdColor.blend(0.5, color, 0.5, color2);
                    this.setVertexColor(++n10, (Color)serializable);
                } while (++n4 < 3);
                --n6;
            }
        }
        if (this.hasVertexNormals()) {
            n10 = n8 - 1;
            n6 = n9 - 1;
            while (n6 >= 0) {
                n4 = 0;
                do {
                    if (this.m_neighbour[n6].m_data[n4] >= n6) continue;
                    PdVector pdVector = this.getVertexNormal(this.m_element[n6].m_data[(n4 + 3 - 1) % 3]);
                    PdVector pdVector2 = this.getVertexNormal(this.m_element[n6].m_data[(n4 + 1) % 3]);
                    serializable = PdVector.blendNew(0.5, pdVector, 0.5, pdVector2);
                    this.setVertexNormal(++n10, (PdVector)serializable);
                } while (++n4 < 3);
                --n6;
            }
        }
        if (this.hasVertexTextures()) {
            PdVector[] pdVectorArray2 = this.getVertexTextures();
            n10 = n8 - 1;
            n6 = n9 - 1;
            while (n6 >= 0) {
                n4 = 0;
                do {
                    if (this.m_neighbour[n6].m_data[n4] >= n6) continue;
                    PdVector pdVector = pdVectorArray2[this.m_element[n6].m_data[(n4 + 3 - 1) % 3]];
                    serializable = pdVectorArray2[this.m_element[n6].m_data[(n4 + 1) % 3]];
                    object = new PdVector(this.getDimOfTextures());
                    ((PdVector)object).blend(0.5, pdVector, 0.5, (PdVector)serializable);
                    pdVectorArray2[++n10] = object;
                } while (++n4 < 3);
                --n6;
            }
        }
        n3 = this.hasBoundary();
        n10 = n8 - 1;
        n6 = n9 - 1;
        while (n6 >= 0) {
            n4 = 0;
            block11: do {
                int n11;
                nArray2[n4] = this.m_element[n6].m_data[n4];
                if (this.m_neighbour[n6].m_data[n4] < n6) {
                    n2 = this.m_element[n6].m_data[(n4 + 3 - 1) % 3];
                    int n12 = this.m_element[n6].m_data[(n4 + 1) % 3];
                    nArray2[n4 + 3] = ++n10;
                    if (this.m_neighbour[n6].m_data[n4] != -1 || n3 == 0) continue;
                    boolean bl = false;
                    n = 0;
                    while (n < this.m_bndList.length && !bl) {
                        if (!this.m_bndList[n].hasTag(2)) {
                            n5 = this.m_bndList[n].getNumVertices();
                            n11 = 0;
                            while (n11 < n5 - 2) {
                                if (this.m_bndList[n].m_vertexInd.m_data[n11] == n2 && this.m_bndList[n].m_vertexInd.m_data[n11 + 2] == n12 || this.m_bndList[n].m_vertexInd.m_data[n11] == n12 && this.m_bndList[n].m_vertexInd.m_data[n11 + 2] == n2) {
                                    this.m_bndList[n].m_vertexInd.m_data[n11 + 1] = n10;
                                    bl = true;
                                    break;
                                }
                                n11 += 2;
                            }
                        }
                        ++n;
                    }
                    if (bl) continue;
                    PsDebug.warning("boundary edge not found\n\tEdge = (" + n2 + ", " + n12 + ")");
                    continue;
                }
                n2 = this.m_neighbour[n6].m_data[n4];
                n11 = 0;
                do {
                    if (this.m_neighbour[n2].m_data[n11] != n6) continue;
                    nArray2[n4 + 3] = this.m_element[n2].m_data[n11];
                    continue block11;
                } while (++n11 < 3);
            } while (++n4 < 3);
            n4 = 0;
            do {
                n = 0;
                do {
                    this.m_element[n6 + n4 * n9].m_data[n] = nArray2[nArrayArray2[n4][n]];
                } while (++n < 3);
            } while (++n4 < 4);
            --n6;
        }
        n6 = 0;
        while (n6 < n9) {
            n4 = 0;
            do {
                n2 = n6 + (n4 + 1) * n9;
                int n13 = n6 + ((n4 + 1) % 3 + 1) * n9;
                int n14 = this.m_neighbour[n6].m_data[(n4 + 2) % 3];
                if (n14 == -1) {
                    this.m_neighbour[n2].m_data[2] = -1;
                    this.m_neighbour[n13].m_data[1] = -1;
                    continue;
                }
                n = 1;
                while (this.m_element[n14 + n * n9].m_data[0] != this.m_element[n2].m_data[0] && ++n < 4) {
                }
                this.m_neighbour[n2].m_data[2] = n14 + n * n9;
                this.m_neighbour[n13].m_data[1] = n14 + ((n + 1) % 3 + 1) * n9;
            } while (++n4 < 3);
            ++n6;
        }
        n6 = 0;
        while (n6 < n9) {
            n4 = 0;
            do {
                this.m_neighbour[n6].m_data[n4] = n6 + (n4 + 1) * n9;
                this.m_neighbour[n6 + (n4 + 1) * n9].m_data[0] = n6;
            } while (++n4 < 3);
            ++n6;
        }
        if (this.hasElementColors()) {
            Color[] colorArray = this.getElementColors();
            n6 = 0;
            while (n6 < n9) {
                this.setElementColor(n6 + n9, colorArray[n6]);
                this.setElementColor(n6 + 2 * n9, colorArray[n6]);
                this.setElementColor(n6 + 3 * n9, colorArray[n6]);
                ++n6;
            }
        }
        if (this.m_elementBackColor != null) {
            Color[] colorArray = this.getElementBackColors();
            n6 = 0;
            while (n6 < n9) {
                this.setElementBackColor(n6 + n9, colorArray[n6]);
                this.setElementBackColor(n6 + 2 * n9, colorArray[n6]);
                this.setElementBackColor(n6 + 3 * n9, colorArray[n6]);
                ++n6;
            }
        }
        if (this.hasElementNormals()) {
            PdVector[] pdVectorArray3 = this.getElementNormals();
            n6 = 0;
            while (n6 < n9) {
                this.setElementNormal(n6 + n9, pdVectorArray3[n6]);
                this.setElementNormal(n6 + 2 * n9, pdVectorArray3[n6]);
                this.setElementNormal(n6 + 3 * n9, pdVectorArray3[n6]);
                ++n6;
            }
        }
        int n15 = this.getNumVectorFields();
        n6 = 0;
        while (n6 < n15) {
            PgVectorField pgVectorField = this.getVectorField(n6);
            if (pgVectorField.getBasedOn() == 0) {
                pgVectorField.setNumVectors(n7);
                object = pgVectorField.getVectors();
                n4 = n8;
                while (n4 < n7) {
                    ((PdVector)object[n4]).blend(0.5, (PdVector)object[((PiVector)serializable2).getEntry(n4 - n8)], 0.5, (PdVector)object[piVector.getEntry(n4 - n8)]);
                    ++n4;
                }
            } else {
                pgVectorField.setNumVectors(n9 * 4);
                n4 = 0;
                while (n4 < n9) {
                    object = pgVectorField.getVector(n4);
                    pgVectorField.setVector(n4 + n9, (PdVector)object);
                    pgVectorField.setVector(n4 + 2 * n9, (PdVector)object);
                    pgVectorField.setVector(n4 + 3 * n9, (PdVector)object);
                    ++n4;
                }
            }
            ++n6;
        }
        if (this.hasElementTextures()) {
            PdVector[][] pdVectorArray4 = this.getElementTextures();
            object = new PdVector[6];
            n6 = 0;
            do {
                object[n6] = new PdVector();
            } while (++n6 < 6);
            n6 = 0;
            while (n6 < n9) {
                ((PdVector)object[0]).copy(pdVectorArray[n6][0]);
                ((PdVector)object[1]).copy(pdVectorArray[n6][1]);
                ((PdVector)object[2]).copy(pdVectorArray[n6][2]);
                ((PdVector)object[3]).blend(0.5, pdVectorArray[n6][1], 0.5, pdVectorArray[n6][2]);
                ((PdVector)object[4]).blend(0.5, pdVectorArray[n6][2], 0.5, pdVectorArray[n6][0]);
                ((PdVector)object[5]).blend(0.5, pdVectorArray[n6][0], 0.5, pdVectorArray[n6][1]);
                n4 = 0;
                do {
                    if (n4 != 0) {
                        pdVectorArray4[n4 * n9 + n6] = new PdVector[3];
                    }
                    n = 0;
                    do {
                        pdVectorArray4[n4 * n9 + n6][n] = PdVector.copyNew((PdVector)object[nArrayArray2[n4][n]]);
                    } while (++n < 3);
                } while (++n4 < 4);
                ++n6;
            }
        }
        if (this.m_bndList != null) {
            n = 0;
            while (n < this.m_bndList.length) {
                if (!this.m_bndList[n].hasTag(2) && !this.m_bndList[n].makeElementInd()) {
                    this.removeBoundaries();
                    break;
                }
                ++n;
            }
        }
        return true;
    }

    public void computePlane(int n, int n2, double d, double d2, double d3, double d4) {
        if (this.m_dim < 2) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        super.computePlane(n, n2, d, d2, d3, d4);
        this.makeQuadrConn(n, n2);
        this.makeQuadrBnd(n, n2);
    }

    public static boolean triangulate(PgElementSet pgElementSet) {
        int n;
        Object object;
        int n2 = 0;
        int n3 = 0;
        while (n3 < pgElementSet.m_numElements) {
            n2 += pgElementSet.m_element[n3].m_data.length;
            ++n3;
        }
        PiVector piVector = new PiVector(n2 -= 2 * pgElementSet.getNumElements());
        PiVector[] piVectorArray = new PiVector[n2];
        boolean bl = pgElementSet.hasElementTextures();
        PdVector[][] pdVectorArray = null;
        if (bl) {
            pdVectorArray = new PdVector[n2][3];
        }
        int n4 = 0;
        n3 = 0;
        while (n3 < pgElementSet.m_numElements) {
            int n5 = pgElementSet.m_element[n3].getSize();
            if (n4 + n5 - 2 > n2) {
                PsDebug.warning("too many triangles, programming error");
            }
            PdVector[] pdVectorArray2 = pgElementSet.getElementVertices(n3);
            object = PgUtil.triangulate(pdVectorArray2);
            n = 0;
            while (n < n5 - 2) {
                int n6;
                if (bl) {
                    n6 = 0;
                    do {
                        pdVectorArray[n4 + n][n6] = PdVector.copyNew(pgElementSet.m_elementTexture[n3][((PiVector)object[n]).m_data[n6]]);
                    } while (++n6 < 3);
                }
                n6 = 0;
                do {
                    ((PiVector)object[n]).m_data[n6] = pgElementSet.m_element[n3].m_data[((PiVector)object[n]).m_data[n6]];
                } while (++n6 < 3);
                piVectorArray[n4 + n] = object[n];
                piVector.m_data[n4 + n] = n3;
                ++n;
            }
            n4 += n5 - 2;
            ++n3;
        }
        pgElementSet.setDimOfElements(3);
        pgElementSet.setNumElements(n2);
        pgElementSet.setElements(piVectorArray);
        if (pgElementSet.hasElementColors()) {
            n3 = n2 - 1;
            while (n3 >= 0) {
                pgElementSet.setElementColor(n3, pgElementSet.getElementColor(piVector.m_data[n3]));
                --n3;
            }
        }
        if (pgElementSet.getElementBackColors() != null) {
            n3 = n2 - 1;
            while (n3 >= 0) {
                pgElementSet.setElementBackColor(n3, pgElementSet.getElementBackColor(piVector.m_data[n3]));
                --n3;
            }
        }
        if (pgElementSet.hasElementNormals()) {
            n3 = n2 - 1;
            while (n3 >= 0) {
                pgElementSet.setElementNormal(n3, pgElementSet.getElementNormal(piVector.m_data[n3]));
                --n3;
            }
        }
        if (bl) {
            pgElementSet.setElementTextures(pdVectorArray);
        }
        int n7 = pgElementSet.getNumVectorFields();
        n3 = 0;
        while (n3 < n7) {
            object = pgElementSet.getVectorField(n3);
            if (((PgVectorField)object).getBasedOn() != 0) {
                ((PgVectorField)object).setNumVectors(n2);
                n = n2 - 1;
                while (n >= 0) {
                    ((PgVectorField)object).setVector(n, ((PgVectorField)object).getVector(piVector.m_data[n]));
                    --n;
                }
            }
            ++n3;
        }
        int n8 = pgElementSet.getNumBoundaries();
        n3 = 0;
        while (n3 < n8) {
            if (!pgElementSet.m_bndList[n3].makeElementInd()) {
                pgElementSet.removeBoundaries();
                break;
            }
            ++n3;
        }
        pgElementSet.makeNeighbour();
        return true;
    }

    public PvPickEvent intersectionWithLine(PdVector pdVector, PdVector pdVector2) {
        if (this.m_dim != 2 && this.m_dim != 3) {
            return null;
        }
        PdVector pdVector3 = new PdVector(3);
        PdVector pdVector4 = new PdVector(3);
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        PdVector pdVector5 = new PdVector(3);
        PdVector pdVector6 = this.m_dim == 2 ? new PdVector(2) : pdVector5;
        PdVector pdVector7 = new PdVector(3);
        PdBary pdBary = new PdBary(3);
        PdBary pdBary2 = new PdBary(3);
        PdVector pdVector8 = null;
        if (this.m_dim == 2) {
            pdVector8 = new PdVector(3);
        }
        int n4 = 0;
        while (n4 < this.m_numElements) {
            PdVector[] pdVectorArray = this.getElementVertices(n4);
            if (pdVectorArray != null && pdVectorArray.length >= 3) {
                if (this.m_dim == 2) {
                    pdVector8.copyArray(pdVectorArray[0]);
                } else {
                    pdVector8 = pdVectorArray[0];
                }
                int n5 = 1;
                while (n5 < pdVectorArray.length - 1) {
                    if (pdVector3.normalOfPlane(pdVectorArray[0], pdVectorArray[n5], pdVectorArray[n5 + 1]) && !((d = PuVectorGeom.intersectionOfLineAndPlane(pdVector5, pdVector, pdVector2, pdVector8, pdVector3)) >= d2)) {
                        if (this.m_dim == 2) {
                            pdVector6.m_data[0] = pdVector5.m_data[0];
                            pdVector6.m_data[1] = pdVector5.m_data[1];
                        }
                        PdBary.getBary(pdBary, pdVector6, pdVectorArray[0], pdVectorArray[n5], pdVectorArray[n5 + 1]);
                        if (pdBary.isInside()) {
                            d2 = d;
                            n2 = n4;
                            n3 = n5;
                            pdBary2.copy(pdBary);
                            pdVector4.copy(pdVector3);
                            pdVector7.copy(pdVector5);
                            if (Math.abs(1.0 - pdBary.getEntry(0)) < 0.1) {
                                n = this.m_element[n4].getEntry(0);
                            } else if (Math.abs(1.0 - pdBary.getEntry(1)) < 0.1) {
                                n = this.m_element[n4].getEntry(n5);
                            } else if (Math.abs(1.0 - pdBary.getEntry(2)) < 0.1) {
                                n = this.m_element[n4].getEntry(n5 + 1);
                            }
                        }
                    }
                    ++n5;
                }
            }
            ++n4;
        }
        if (n2 == -1) {
            return null;
        }
        PvPickEvent pvPickEvent = new PvPickEvent(this.m_dim);
        pvPickEvent.setVertex(pdVector7);
        pvPickEvent.setDistance(d2);
        pvPickEvent.setElementInd(n2);
        pvPickEvent.setElementSubInd(n3);
        pvPickEvent.setBary(pdBary2);
        pvPickEvent.setVertexInd(n);
        pvPickEvent.setViewBase(pdVector);
        pvPickEvent.setViewDir(pdVector2);
        pvPickEvent.setNormal(pdVector4);
        return pvPickEvent;
    }

    public boolean hasElementNormals() {
        return this.m_elementNormal != null && this.m_elementNormal.length == this.m_maxNumElements;
    }

    public boolean makeElementNormals() {
        int n;
        if (this.m_numElements < 1) {
            return false;
        }
        this.assureElementNormals();
        if ((this.m_dim == 1 || this.m_dim == 2) && this.m_dimOfVectors == 3) {
            int n2 = 0;
            while (n2 < this.m_numElements) {
                this.m_elementNormal[n2].set(0.0, 0.0, 1.0);
                ++n2;
            }
            return true;
        }
        if (this.m_dim == 3 && this.m_dimOfVectors == 3) {
            PdVector pdVector = new PdVector(this.m_dim);
            PdVector pdVector2 = new PdVector(this.m_dim);
            PdVector pdVector3 = new PdVector(this.m_dimOfVectors);
            PdVector.setConstant(this.m_elementNormal, 0.0);
            n = 0;
            while (n < this.m_numElements) {
                int n3 = this.m_element[n].getSize();
                if (n3 >= 2) {
                    PdVector pdVector4 = this.m_vertex[this.m_element[n].m_data[(-2 + n3) % n3]];
                    PdVector pdVector5 = this.m_vertex[this.m_element[n].m_data[(-1 + n3) % n3]];
                    pdVector.sub(pdVector5, pdVector4);
                    int n4 = 0;
                    while (n4 < n3) {
                        PdVector pdVector6 = pdVector4;
                        pdVector4 = pdVector5;
                        pdVector5 = this.m_vertex[this.m_element[n].m_data[n4]];
                        pdVector2.sub(pdVector5, pdVector4);
                        boolean bl = pdVector3.cross(pdVector, pdVector2);
                        pdVector.copyArray(pdVector2);
                        if (bl && pdVector3.normalize()) {
                            this.m_elementNormal[n].add(pdVector3);
                        }
                        ++n4;
                    }
                }
                ++n;
            }
        }
        n = 0;
        while (n < this.m_numElements) {
            this.m_elementNormal[n].normalize();
            ++n;
        }
        return true;
    }

    public boolean makeVertexNormals() {
        this.assureVertexNormals();
        PdVector.setConstant(this.m_vertexNormal, 0.0);
        if ((this.m_dim == 1 || this.m_dim == 2) && this.m_dimOfVectors == 3) {
            int n = 0;
            while (n < this.m_numVertices) {
                this.m_vertexNormal[n].set(0.0, 0.0, 1.0);
                ++n;
            }
            return true;
        }
        if (this.m_dim == 3 && this.m_dimOfVectors == 3) {
            PdVector pdVector = new PdVector(this.m_dim);
            PdVector pdVector2 = new PdVector(this.m_dim);
            PdVector pdVector3 = new PdVector(this.m_dimOfVectors);
            PdVector.setConstant(this.m_vertexNormal, 0.0);
            int n = 0;
            while (n < this.m_numElements) {
                int n2 = this.m_element[n].getSize();
                if (n2 >= 2) {
                    PdVector pdVector4 = this.m_vertex[this.m_element[n].m_data[(-2 + n2) % n2]];
                    PdVector pdVector5 = this.m_vertex[this.m_element[n].m_data[(-1 + n2) % n2]];
                    pdVector.sub(pdVector5, pdVector4);
                    int n3 = 0;
                    while (n3 < n2) {
                        int n4 = this.m_element[n].m_data[(n3 - 1 + n2) % n2];
                        PdVector pdVector6 = pdVector4;
                        pdVector4 = pdVector5;
                        pdVector5 = this.m_vertex[this.m_element[n].m_data[n3]];
                        pdVector2.sub(pdVector5, pdVector4);
                        boolean bl = pdVector3.cross(pdVector, pdVector2);
                        pdVector.copyArray(pdVector2);
                        if (bl && pdVector3.normalize()) {
                            this.m_vertexNormal[n4].add(pdVector3);
                        }
                        ++n3;
                    }
                }
                ++n;
            }
        }
        int n = 0;
        while (n < this.m_numVertices) {
            this.m_vertexNormal[n].normalize();
            ++n;
        }
        return true;
    }

    public PiVector getNeighbour(int n) {
        if (n < 0 || n >= this.m_numElements) {
            return null;
        }
        return this.m_neighbour[n];
    }

    public PiVector getEdge(int n) {
        if (n < 0 || n >= this.m_numEdges) {
            return null;
        }
        return this.m_edge[n];
    }

    public boolean setEdge(int n, PiVector piVector) {
        if (n < 0 || piVector == null) {
            PsDebug.error("index out of range, corrupt argument", this);
            return false;
        }
        if (n >= this.m_numEdges) {
            PsDebug.warning("index=" + n + " > " + this.m_numEdges + "=m_numEdges, bad programming style", this);
            this.setNumEdges(n + 1, -1);
        }
        this.m_edge[n].copy(piVector);
        return true;
    }

    public PgElementEdge[] getEdgeList() {
        int n;
        int n2;
        int n3;
        if (this.m_numElements < 1) {
            return null;
        }
        PgElementEdge pgElementEdge = null;
        int[] nArray = new int[2];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < this.m_numElements) {
            int n7 = this.m_element[n6].getSize();
            n3 = 0;
            while (n3 < n7) {
                if (this.m_element[n6].m_data[n3] >= n5) {
                    n5 = this.m_element[n6].m_data[n3] + 1;
                }
                ++n3;
            }
            ++n6;
        }
        Vector[] vectorArray = new Vector[n5];
        n6 = 0;
        while (n6 < this.m_numElements) {
            int n8 = this.m_element[n6].getSize();
            n3 = 0;
            while (n3 < n8) {
                nArray[0] = this.m_element[n6].m_data[n3];
                nArray[1] = this.m_element[n6].m_data[(n3 + 1) % n8];
                if (nArray[0] > nArray[1]) {
                    n2 = nArray[0];
                    nArray[0] = nArray[1];
                    nArray[1] = n2;
                }
                boolean bl = false;
                if (vectorArray[nArray[0]] == null) {
                    vectorArray[nArray[0]] = new Vector();
                } else {
                    n2 = vectorArray[nArray[0]].size();
                    n = 0;
                    while (n < n2) {
                        pgElementEdge = (PgElementEdge)vectorArray[nArray[0]].elementAt(n);
                        if (pgElementEdge.getEdgeInd(1) == nArray[1]) {
                            bl = true;
                            break;
                        }
                        ++n;
                    }
                }
                if (bl) {
                    pgElementEdge.addElement(n6, (n3 - 1 + n8) % n8);
                } else {
                    ++n4;
                    pgElementEdge = new PgElementEdge(nArray[0], nArray[1]);
                    pgElementEdge.addElement(n6, (n3 - 1 + n8) % n8);
                    vectorArray[nArray[0]].addElement(pgElementEdge);
                }
                ++n3;
            }
            ++n6;
        }
        PgElementEdge[] pgElementEdgeArray = new PgElementEdge[n4];
        n2 = 0;
        n6 = 0;
        while (n6 < n5) {
            if (vectorArray[n6] != null) {
                n = 0;
                while (n < vectorArray[n6].size()) {
                    pgElementEdgeArray[n2] = (PgElementEdge)vectorArray[n6].elementAt(n);
                    ++n2;
                    ++n;
                }
            }
            ++n6;
        }
        if (n2 != n4) {
            PsDebug.warning("numEdges is wrong, edge list is void");
            PsDebug.warning("\t numEdges = " + n4 + ", countEdges = " + n2);
        }
        return pgElementEdgeArray;
    }

    public PgElementEdge getEdge(int n, int n2) {
        PgElementEdge pgElementEdge = null;
        int n3 = 0;
        while (n3 < this.m_numElements) {
            block6: {
                int[] nArray = this.m_element[n3].m_data;
                if (nArray == null) break block6;
                int n4 = nArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    block7: {
                        int n6;
                        block9: {
                            int n7;
                            block8: {
                                if (nArray[n5] != n) break block7;
                                int n8 = (n5 + 1) % n4;
                                n7 = (n5 - 1 + n4) % n4;
                                if (nArray[n8] != n2) break block8;
                                n6 = n7;
                                break block9;
                            }
                            if (nArray[n7] != n2) break block7;
                            n6 = (n5 - 2 + n4) % n4;
                        }
                        if (pgElementEdge == null) {
                            pgElementEdge = new PgElementEdge(n, n2);
                        }
                        pgElementEdge.addElement(n3, n6);
                    }
                    ++n5;
                }
            }
            ++n3;
        }
        return pgElementEdge;
    }

    public Color getGlobalBndTagColor() {
        return this.m_globalBndTagColor.getColor();
    }

    public void setGlobalBndTagColor(Color color) {
        this.m_globalBndTagColor.setColor(color);
    }

    public boolean isShowingElementBackColor() {
        return this.m_bShowElementBackColor;
    }

    public void showElementBackColor(boolean bl) {
        this.m_globalElementBackColor.setEnabled(bl);
        this.m_bShowElementBackColor = bl;
    }

    public Color getElementBackColor(int n) {
        if (n < 0 || n >= this.m_numElements) {
            return null;
        }
        return this.m_elementBackColor[n];
    }

    public boolean setElementBackColor(int n, Color color) {
        if (n < 0 || n >= this.m_numElements) {
            PsDebug.warning("index=" + n + " out of range");
            return false;
        }
        if (color == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        if (this.m_elementBackColor == null || n >= this.m_elementBackColor.length) {
            this.assureElementBackColors();
        }
        this.m_elementBackColor[n] = color;
        return true;
    }

    public void computeSphere(int n, int n2, double d) {
        if (this.m_dim < 3) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        super.computeSphere(n, n2, d);
        this.makeQuadrConn(n, n2);
        this.makeQuadrBnd(n, n2);
    }

    public Object clone() {
        PgElementSet pgElementSet = (PgElementSet)super.clone();
        if (pgElementSet == null) {
            return null;
        }
        pgElementSet.m_globalElementColor = (PdColor)this.m_globalElementColor.clone();
        pgElementSet.m_globalElementBackColor = (PdColor)this.m_globalElementBackColor.clone();
        pgElementSet.m_globalElementTagColor = (PdColor)this.m_globalElementTagColor.clone();
        pgElementSet.m_globalElementColor.setParent(pgElementSet);
        pgElementSet.m_globalElementTagColor.setParent(pgElementSet);
        pgElementSet.m_globalBndSize = (PuDouble)this.m_globalBndSize.clone();
        pgElementSet.m_globalBndColor = (PdColor)this.m_globalBndColor.clone();
        pgElementSet.m_globalBndTagColor = (PdColor)this.m_globalBndTagColor.clone();
        pgElementSet.m_globalBndSize.setParent(pgElementSet);
        pgElementSet.m_globalBndColor.setParent(pgElementSet);
        pgElementSet.m_globalBndTagColor.setParent(pgElementSet);
        pgElementSet.m_globalEdgeSize = (PuDouble)this.m_globalEdgeSize.clone();
        pgElementSet.m_globalEdgeColor = (PdColor)this.m_globalEdgeColor.clone();
        pgElementSet.m_globalEdgeTagColor = (PdColor)this.m_globalEdgeTagColor.clone();
        pgElementSet.m_globalEdgeSize.setParent(pgElementSet);
        pgElementSet.m_globalEdgeColor.setParent(pgElementSet);
        pgElementSet.m_globalEdgeTagColor.setParent(pgElementSet);
        pgElementSet.m_globalElementNormalLength = (PuDouble)this.m_globalElementNormalLength.clone();
        pgElementSet.m_globalElementNormalSize = (PuDouble)this.m_globalElementNormalSize.clone();
        pgElementSet.m_globalElementNormalColor = (PdColor)this.m_globalElementNormalColor.clone();
        pgElementSet.m_globalElementNormalLength.setParent(pgElementSet);
        pgElementSet.m_globalElementNormalSize.setParent(pgElementSet);
        pgElementSet.m_globalElementNormalColor.setParent(pgElementSet);
        if (this.m_element != null) {
            pgElementSet.m_element = (PiVector[])P_Vector.clone(this.m_element);
        }
        if (this.m_elementColor != null) {
            pgElementSet.m_elementColor = (Color[])this.m_elementColor.clone();
        }
        if (this.m_elementBackColor != null) {
            pgElementSet.m_elementBackColor = (Color[])this.m_elementBackColor.clone();
        }
        if (this.m_elementNormal != null) {
            pgElementSet.m_elementNormal = (PdVector[])P_Vector.clone(this.m_elementNormal);
        }
        if (this.m_elementTexture != null) {
            pgElementSet.m_elementTexture = (PdVector[][])P_Vector.clone(this.m_elementTexture);
        }
        if (this.m_neighbour != null) {
            pgElementSet.m_neighbour = (PiVector[])P_Vector.clone(this.m_neighbour);
        }
        if (this.m_bndList != null) {
            pgElementSet.removeBoundaries();
            int n = this.getNumBoundaries();
            if (n > 0) {
                PgBndPolygon[] pgBndPolygonArray = (PgBndPolygon[])this.m_bndList.clone();
                int n2 = 0;
                while (n2 < n) {
                    pgBndPolygonArray[n2] = (PgBndPolygon)pgBndPolygonArray[n2].clone();
                    ++n2;
                }
                pgElementSet.setBoundary(pgBndPolygonArray);
            }
        }
        if (this.m_elementSaved != null) {
            pgElementSet.m_elementSaved = (PiVector[])P_Vector.clone(this.m_elementSaved);
        }
        if (this.m_edge != null) {
            pgElementSet.m_edge = (PiVector[])P_Vector.clone(this.m_edge);
        }
        if (this.m_edgeColor != null) {
            pgElementSet.m_edgeColor = (Color[])this.m_edgeColor.clone();
        }
        return pgElementSet;
    }

    public void buildTriangle(PdVector[] pdVectorArray, int n) {
        if (pdVectorArray == null || pdVectorArray.length < 3) {
            PsDebug.warning("no initial vertices or wrong number");
            return;
        }
        int n2 = n * (n + 1) / 2;
        int n3 = (n - 1) * (n - 1);
        this.setNumVertices(n2);
        this.setNumElements(n3);
        PdVector pdVector = new PdVector(this.m_dim);
        PdVector pdVector2 = new PdVector(this.m_dim);
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            double d = (double)n5 / (double)(n - 1);
            pdVector.blend(1.0 - d, pdVectorArray[0], d, pdVectorArray[1]);
            pdVector2.blend(1.0 - d, pdVectorArray[2], d, pdVectorArray[1]);
            this.m_vertex[n4++].copy(pdVector);
            int n6 = 1;
            while (n6 < n - n5) {
                double d2 = (double)n6 / (double)(n - 1 - n5);
                this.m_vertex[n4++].blend(1.0 - d2, pdVector, d2, pdVector2);
                ++n6;
            }
            ++n5;
        }
        this.makeTriangleConn(n);
        this.makeTriangleBnd(n);
    }

    public void setNumEdges(int n, int n2) {
        if (this.m_numEdges == n) {
            return;
        }
        this.m_edge = n2 > -1 ? PiVector.realloc(this.m_edge, n, n2) : PiVector.realloc(this.m_edge, n);
        this.m_numEdges = n;
        if (this.m_edgeColor != null) {
            this.assureEdgeColors();
        }
    }

    public boolean isShowingBackface() {
        return this.m_bShowBackface;
    }

    public boolean isShowingTaggedEdges() {
        return this.m_bShowTaggedEdges;
    }

    public void showBackface(boolean bl) {
        this.m_bShowBackface = bl;
        if (this.m_bShowBackface && this.m_elementNormal == null) {
            this.makeElementNormals();
        }
    }

    public void showTaggedEdges(boolean bl) {
        this.m_bShowTaggedEdges = bl;
    }

    public void flipEdges() {
        int n;
        if (this.m_dimOfElements != 3) {
            PsDebug.warning("valid for triangulations only");
            return;
        }
        PdVector[] pdVectorArray = new PdVector[4];
        PdVector[] pdVectorArray2 = PdVector.realloc(null, 4, this.m_dim);
        boolean bl = true;
        double[] dArray = new double[4];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        PdVector pdVector = new PdVector(3);
        PdVector pdVector2 = new PdVector(3);
        PdVector pdVector3 = new PdVector(3);
        while (bl) {
            if (++n3 > 10) {
                PsDebug.warning("too many passes");
                break;
            }
            bl = false;
            int n5 = 0;
            while (n5 < this.m_numElements) {
                n = 0;
                do {
                    int n6;
                    if ((n6 = this.m_neighbour[n5].m_data[n]) == -1 || n6 > n5) continue;
                    int n7 = n;
                    int n8 = (n + 1) % 3;
                    int n9 = (n + 2) % 3;
                    int n10 = this.getOppVertexLocInd(n5, n);
                    int n11 = (n10 + 1) % 3;
                    int n12 = (n10 + 2) % 3;
                    if (this.m_neighbour[n5].m_data[n8] == this.m_neighbour[n6].m_data[n12] && this.m_neighbour[n5].m_data[n8] > -1 || this.m_neighbour[n5].m_data[n9] == this.m_neighbour[n6].m_data[n11] && this.m_neighbour[n5].m_data[n9] > -1) {
                        ++n4;
                        continue;
                    }
                    pdVectorArray[0] = this.m_vertex[this.m_element[n5].m_data[n7]];
                    pdVectorArray[1] = this.m_vertex[this.m_element[n5].m_data[n8]];
                    pdVectorArray[2] = this.m_vertex[this.m_element[n6].m_data[n10]];
                    pdVectorArray[3] = this.m_vertex[this.m_element[n5].m_data[n9]];
                    int n13 = 0;
                    do {
                        pdVectorArray2[n13].sub(pdVectorArray[(n13 + 1) % 4], pdVectorArray[n13]);
                    } while (++n13 < 4);
                    pdVector.cross(pdVectorArray2[3], pdVectorArray2[0]);
                    pdVector.normalize();
                    pdVector2.cross(pdVectorArray2[1], pdVectorArray2[2]);
                    pdVector2.normalize();
                    pdVector3.add(pdVector, pdVector2);
                    pdVector3.normalize();
                    n13 = 0;
                    do {
                        dArray[n13] = Math.PI - PdVector.angleWithOrientation(pdVectorArray2[(n13 - 1 + 4) % 4], pdVectorArray2[n13], pdVector3);
                    } while (++n13 < 4);
                    if (!(dArray[0] + dArray[2] > dArray[1] + dArray[3])) continue;
                    ++n2;
                    bl = true;
                    int n14 = this.m_neighbour[n5].m_data[n8];
                    if (n14 > -1) {
                        this.m_neighbour[n14].m_data[this.getOppVertexLocInd((int)n5, (int)n8)] = n6;
                    }
                    if ((n14 = this.m_neighbour[n6].m_data[n11]) > -1) {
                        this.m_neighbour[n14].m_data[this.getOppVertexLocInd((int)n6, (int)n11)] = n5;
                    }
                    this.m_element[n5].m_data[n9] = this.m_element[n6].m_data[n10];
                    this.m_element[n6].m_data[n12] = this.m_element[n5].m_data[n7];
                    this.m_neighbour[n5].m_data[n7] = this.m_neighbour[n6].m_data[n11];
                    this.m_neighbour[n6].m_data[n10] = this.m_neighbour[n5].m_data[n8];
                    this.m_neighbour[n5].m_data[n8] = n6;
                    this.m_neighbour[n6].m_data[n11] = n5;
                } while (++n < 3);
                ++n5;
            }
        }
        n = 0;
        while (this.m_bndList != null && n < this.m_bndList.length) {
            if (!this.m_bndList[n].hasTag(2)) {
                this.m_bndList[n].makeElementInd();
            }
            ++n;
        }
    }

    public int getNumBoundaryEdges() {
        int n = 0;
        if (this.m_neighbour == null) {
            int n2 = 0;
            while (n2 < this.m_numElements) {
                n += this.m_element[n2].getSize();
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < this.m_numElements) {
                int n4 = 0;
                while (n4 < this.m_element[n3].getSize()) {
                    if (this.m_neighbour[n3].m_data[n4] == -1) {
                        ++n;
                    }
                    ++n4;
                }
                ++n3;
            }
        }
        return n;
    }

    public int getNumEdges() {
        int n = 0;
        if (this.m_neighbour == null) {
            int n2 = 0;
            while (n2 < this.m_numElements) {
                n += this.m_element[n2].getSize();
                ++n2;
            }
            return n;
        }
        int n3 = 0;
        while (n3 < this.m_numElements) {
            int n4 = 0;
            while (n4 < this.m_element[n3].getSize()) {
                if (this.m_neighbour[n3].m_data[n4] < n3) {
                    ++n;
                }
                ++n4;
            }
            ++n3;
        }
        return n;
    }

    public int getNumBoundaryVertices() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_numVertices) {
            if (this.m_vertex[n2].hasTag(13)) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public void setConforming(boolean bl) {
        this.m_bConforming = bl;
        if (this.m_bndList != null) {
            int n = 0;
            while (n < this.m_bndList.length) {
                if (this.m_bndList[n] != null) {
                    this.m_bndList[n].m_bConforming = bl;
                }
                ++n;
            }
        }
    }

    public void makeQuadrConn(int n, int n2) {
        if (n < 2 || n2 < 2) {
            return;
        }
        if (this.m_dimOfElements == 3) {
            this.setNumElements(2 * (n - 1) * (n2 - 1));
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while (n5 < n - 1) {
                int n6 = 0;
                while (n6 < n2 - 1) {
                    this.m_element[n3++].set(n5 * n2 + n6, (n5 + 1) * n2 + n6, n5 * n2 + n6 + 1);
                    this.m_element[n3++].set(n5 * n2 + n6 + 1, (n5 + 1) * n2 + n6, (n5 + 1) * n2 + n6 + 1);
                    this.m_neighbour[n4].set(n4 + 1, n4 - 2 * (n2 - 1) + 1, n4 - 1);
                    this.m_neighbour[++n4].set(n4 + 2 * (n2 - 1) - 1, n4 + 1, n4 - 1);
                    ++n4;
                    ++n6;
                }
                ++n5;
            }
            n4 = 0;
            n5 = 0;
            while (n5 < n - 1) {
                this.m_neighbour[n4].m_data[2] = -1;
                this.m_neighbour[n4 += 2 * (n2 - 1) - 1].m_data[1] = -1;
                ++n4;
                ++n5;
            }
            n4 = 0;
            n5 = 0;
            while (n5 < n2 - 1) {
                this.m_neighbour[n4].m_data[1] = -1;
                n4 += 2;
                ++n5;
            }
            n4 = 2 * (n2 - 1) * (n - 2) + 1;
            n5 = 0;
            while (n5 < n2 - 1) {
                this.m_neighbour[n4].m_data[0] = -1;
                n4 += 2;
                ++n5;
            }
            return;
        }
        this.setDimOfElements(4);
        this.setNumElements((n - 1) * (n2 - 1));
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        while (n9 < n - 1) {
            int n10 = 0;
            while (n10 < n2 - 1) {
                this.m_element[n7++].set(n9 * n2 + n10, (n9 + 1) * n2 + n10, (n9 + 1) * n2 + n10 + 1, n9 * n2 + n10 + 1);
                this.m_neighbour[n8].set(n8 + (n2 - 1), n8 + 1, n8 - (n2 - 1), n8 - 1);
                ++n8;
                ++n10;
            }
            ++n9;
        }
        n8 = 0;
        n9 = 0;
        while (n9 < n - 1) {
            this.m_neighbour[n8].m_data[3] = -1;
            this.m_neighbour[n8 += n2 - 1 - 1].m_data[1] = -1;
            ++n8;
            ++n9;
        }
        n8 = 0;
        n9 = 0;
        while (n9 < n2 - 1) {
            this.m_neighbour[n8].m_data[2] = -1;
            ++n8;
            ++n9;
        }
        n8 = (n2 - 1) * (n - 2);
        n9 = 0;
        while (n9 < n2 - 1) {
            this.m_neighbour[n8].m_data[0] = -1;
            ++n8;
            ++n9;
        }
    }

    public void makeAlternatingQuadrConn(int n, int n2, boolean bl) {
        if (n < 2 || n2 < 2) {
            return;
        }
        this.setDimOfElements(3);
        this.setNumElements(2 * (n - 1) * (n2 - 1));
        int n3 = 0;
        int n4 = 0;
        while (n4 < n - 1) {
            int n5 = 0;
            while (n5 < n2 - 1) {
                if (!bl) {
                    if (n5 % 2 == 0) {
                        this.m_element[n3++].set(n4 * n2 + n5, (n4 + 1) * n2 + n5, n4 * n2 + n5 + 1);
                        this.m_element[n3++].set(n4 * n2 + n5 + 1, (n4 + 1) * n2 + n5, (n4 + 1) * n2 + n5 + 1);
                    } else {
                        this.m_element[n3++].set(n4 * n2 + n5, (n4 + 1) * n2 + n5 + 1, n4 * n2 + n5 + 1);
                        this.m_element[n3++].set(n4 * n2 + n5, (n4 + 1) * n2 + n5, (n4 + 1) * n2 + n5 + 1);
                    }
                } else if (n4 % 2 == 0) {
                    this.m_element[n3++].set(n4 * n2 + n5, (n4 + 1) * n2 + n5, n4 * n2 + n5 + 1);
                    this.m_element[n3++].set(n4 * n2 + n5 + 1, (n4 + 1) * n2 + n5, (n4 + 1) * n2 + n5 + 1);
                } else {
                    this.m_element[n3++].set(n4 * n2 + n5, (n4 + 1) * n2 + n5 + 1, n4 * n2 + n5 + 1);
                    this.m_element[n3++].set(n4 * n2 + n5, (n4 + 1) * n2 + n5, (n4 + 1) * n2 + n5 + 1);
                }
                ++n5;
            }
            ++n4;
        }
        this.makeNeighbour();
    }

    public boolean isShowingTaggedBoundaries() {
        return this.m_bShowTaggedBoundaries;
    }

    public void showTaggedBoundaries(boolean bl) {
        this.m_bShowTaggedBoundaries = bl;
    }

    public void buildPolygon(PdVector[] pdVectorArray, int n) {
        PsDebug.error("empty method", this);
    }

    public int getNumBoundaries() {
        if (this.m_bndList == null) {
            return 0;
        }
        return this.m_bndList.length;
    }

    public void computeSnail(int n, int n2, double d) {
        if (this.m_dim < 3) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        super.computeSnail(n, n2, d);
        this.makeQuadrConn(n, n2);
        this.makeQuadrBnd(n, n2);
    }

    public void markBoundary() {
        int n = 0;
        while (n < this.m_numVertices) {
            this.m_vertex[n].clearTag(13);
            ++n;
        }
        if (this.m_neighbour == null || this.m_neighbour.length != this.m_element.length) {
            PsDebug.warning("void neighbour connectivity", this);
            return;
        }
        n = 0;
        while (n < this.m_numElements) {
            int n2 = this.m_neighbour[n].getSize();
            int n3 = 0;
            while (n3 < n2) {
                if (this.m_neighbour[n].m_data[n3] < 0) {
                    if (this.isConforming()) {
                        this.m_vertex[this.m_element[n].m_data[(n3 + 1) % n2]].setTag(13);
                        this.m_vertex[this.m_element[n].m_data[(n3 + 2) % n2]].setTag(13);
                    } else {
                        this.m_vertex[this.m_element[n].m_data[n3]].setTag(13);
                    }
                }
                ++n3;
            }
            ++n;
        }
    }

    public boolean makeNeighbour() {
        if (this.m_numElements < 1 || !this.m_bConforming) {
            return true;
        }
        this.assureNeighbours();
        PgElementEdge[] pgElementEdgeArray = this.getEdgeList();
        if (pgElementEdgeArray == null) {
            return false;
        }
        int n = 0;
        while (n < pgElementEdgeArray.length) {
            int[] nArray = pgElementEdgeArray[n].getElements();
            if (nArray != null) {
                int n2 = pgElementEdgeArray[n].getSize();
                if (n2 == 1) {
                    this.m_neighbour[nArray[0]].m_data[pgElementEdgeArray[n].m_neighbourLocInd[0]] = -1;
                } else if (n2 == 2) {
                    this.m_neighbour[nArray[0]].m_data[pgElementEdgeArray[n].m_neighbourLocInd[0]] = nArray[1];
                    this.m_neighbour[nArray[1]].m_data[pgElementEdgeArray[n].m_neighbourLocInd[1]] = nArray[0];
                } else if (n2 > 2) {
                    int n3 = 0;
                    while (n3 < n2) {
                        this.m_neighbour[nArray[n3]].m_data[pgElementEdgeArray[n].m_neighbourLocInd[n3]] = -1;
                        ++n3;
                    }
                }
            }
            ++n;
        }
        return true;
    }

    public int getNumBoundaryComponents() {
        int n = this.m_numVertices;
        int n2 = this.m_numElements;
        if (this.m_dimOfElements == 3) {
            int n3 = this.getNumBoundaryEdges();
            int n4 = n - n3;
            return (n2 - 2 * n4 - n3 + 2) / 2 + 1;
        }
        int n5 = this.getNumEdges();
        return 2 - (n - n5 + n2);
    }

    public PgGeometry reflect(PdMatrix pdMatrix, boolean bl, boolean bl2) {
        int n;
        int n2;
        int n3;
        Object object;
        P_Vector[] p_VectorArray;
        if (pdMatrix == null || pdMatrix.getSize() != this.getDimOfVertices() + 1) {
            PsDebug.warning("missing or wrong transformation matrix mat = " + pdMatrix);
            return null;
        }
        PgElementSet pgElementSet = (PgElementSet)super.reflect(pdMatrix, bl, bl2);
        if (!bl) {
            p_VectorArray = pgElementSet.getElements();
            int n4 = 0;
            while (n4 < this.m_numElements) {
                ((PiVector)p_VectorArray[n4]).invert();
                ++n4;
            }
            object = pgElementSet.getNeighbours();
            if (object != null) {
                n3 = 0;
                while (n3 < this.m_numElements) {
                    ((PiVector)object[n3]).invert();
                    n2 = ((PiVector)object[n3]).getSize();
                    n = 3;
                    while (n < n2) {
                        ((PiVector)object[n3]).shift(1);
                        ++n;
                    }
                    ++n3;
                }
            }
        }
        if (this.hasElementNormals()) {
            p_VectorArray = this.getElementNormals();
            object = pgElementSet.getElementNormals();
            n3 = 0;
            while (n3 < this.m_numElements) {
                ((PdVector)object[n3]).leftMultAffin(pdMatrix, (PdVector)p_VectorArray[n3], false);
                if (!bl2) {
                    ((PdVector)object[n3]).multScalar(-1.0);
                }
                ((PdVector)object[n3]).normalize();
                ++n3;
            }
        }
        if (!bl && this.hasElementTextures()) {
            p_VectorArray = pgElementSet.getElementTextures();
            n3 = 0;
            while (n3 < this.m_numElements) {
                n2 = ((P_Vector)p_VectorArray[n3]).length;
                n = n2 / 2;
                int n5 = 0;
                while (n5 < n) {
                    object = p_VectorArray[n3][n5];
                    p_VectorArray[n3][n5] = p_VectorArray[n3][n2 - 1 - n5];
                    p_VectorArray[n3][n2 - 1 - n5] = object;
                    ++n5;
                }
                ++n3;
            }
        }
        return pgElementSet;
    }

    public int addEdge(PiVector piVector) {
        this.setEdge(this.m_numEdges, piVector);
        return this.m_numEdges - 1;
    }

    public double getArea() {
        double d = 0.0;
        int n = 0;
        while (n < this.m_numElements) {
            d += this.getAreaOfElement(n);
            ++n;
        }
        return d;
    }

    public boolean hasElementTextures() {
        return this.m_elementTexture != null && this.m_elementTexture.length == this.m_maxNumElements;
    }

    public Color[] getEdgeColors() {
        return this.m_edgeColor;
    }

    public void init() {
        super.init();
        this.m_bShowEdgeLabels = false;
        this.m_bShowElementLabels = false;
        this.m_bShowVertices = false;
        this.m_elementNormal = null;
        this.m_elementColor = null;
        this.m_elementBackColor = null;
        this.m_bShowElementColors = false;
        this.m_bShowElementBackColor = false;
        this.m_bShowElementBackColors = false;
        this.m_edgeColor = null;
        this.m_bShowEdgeColors = false;
        this.m_edge = null;
        this.m_dimOfElements = -1;
        this.setMaxNumElements(0);
        this.m_bShowElements = true;
        this.m_bShowTaggedElements = true;
        this.m_bShowBackface = true;
        this.m_globalElementColor.setColor(new Color(200, 255, 0));
        this.m_globalElementBackColor.setColor(new Color(255, 200, 0));
        this.m_globalElementBackColor.setEnabled(this.m_bShowElementBackColor);
        this.m_globalElementTagColor.setColor(Color.magenta);
        this.m_bShowElementNormals = false;
        this.m_bShowElementNormalArrow = false;
        this.m_globalElementNormalSize.setDefBounds(1.0, 10.0, 1.0, 2.0);
        this.m_globalElementNormalSize.setDefValue(1.0);
        this.m_globalElementNormalSize.init();
        this.m_globalElementNormalLength.setDefBounds(0.0, 5.0, 0.1, 1.0);
        this.m_globalElementNormalLength.setDefValue(0.5);
        this.m_globalElementNormalLength.init();
        this.m_globalElementNormalColor.setColor(Color.yellow);
        this.m_bShowOutline = false;
        this.m_bShowEdges = true;
        this.m_bShowTaggedEdges = false;
        this.m_globalEdgeColor.setColor(Color.black);
        this.m_globalEdgeTagColor.setColor(Color.red);
        this.m_globalEdgeSize.setDefBounds(1.0, 10.0, 1.0, 2.0);
        this.m_globalEdgeSize.setDefValue(1.0);
        this.m_globalEdgeSize.init();
        this.m_bShowBoundaries = false;
        this.m_bShowTaggedBoundaries = false;
        this.m_bndList = null;
        this.m_globalBndColor.setColor(Color.blue);
        this.m_globalBndTagColor.setColor(Color.magenta);
        this.m_globalBndSize.setDefBounds(1.0, 10.0, 1.0, 2.0);
        this.m_globalBndSize.setDefValue(3.0);
        this.m_globalBndSize.init();
        this.m_bShowElementTexture = false;
    }

    public void assureEdgeColors() {
        if (this.m_edgeColor == null || this.m_edgeColor.length != this.m_numEdges) {
            this.m_edgeColor = PdColor.realloc(this.m_edgeColor, this.m_numEdges);
        }
    }

    public void setEdgeColors(Color[] colorArray) {
        if (colorArray == null) {
            this.m_edgeColor = null;
            return;
        }
        if (colorArray.length < this.m_numEdges) {
            PsDebug.warning("void length of color array");
            return;
        }
        this.assureEdgeColors();
        PdColor.copy(this.m_edgeColor, 0, colorArray, 0, this.m_numEdges);
    }

    public Color[] getElementColors() {
        return this.m_elementColor;
    }

    public void setBoundary(PgBndPolygon[] pgBndPolygonArray) {
        this.m_bndList = pgBndPolygonArray;
        int n = this.getNumBoundaries();
        int n2 = 0;
        while (n2 < n) {
            this.m_bndList[n2].setElementSet(this);
            ++n2;
        }
    }

    public void assureBoundary(int n) {
        int n2;
        if (this.m_bndList != null && this.m_bndList.length == n) {
            return;
        }
        PgBndPolygon[] pgBndPolygonArray = this.m_bndList;
        this.m_bndList = new PgBndPolygon[n];
        int n3 = 0;
        if (pgBndPolygonArray != null) {
            n3 = pgBndPolygonArray.length;
            n2 = 0;
            while (n2 < Math.min(n3, n)) {
                this.m_bndList[n2] = pgBndPolygonArray[n2];
                ++n2;
            }
        }
        n2 = n3;
        while (n2 < n) {
            this.m_bndList[n2] = new PgBndPolygon(this.m_dim);
            this.m_bndList[n2].setElementSet(this);
            this.m_bndList[n2].setDimOfVectors(this.getDimOfVectors());
            ++n2;
        }
    }

    public boolean isShowingElementColors() {
        return this.m_bShowElementColors;
    }

    public boolean isShowingEdgeColors() {
        return this.m_bShowEdgeColors;
    }

    public void showElementColors(boolean bl) {
        this.m_bShowElementColors = bl;
    }

    public void showEdgeColors(boolean bl) {
        this.m_bShowEdgeColors = bl;
    }

    public void showElementTexture(boolean bl) {
        this.m_bShowElementTexture = bl;
    }

    public void setDimOfColors(int n) {
        if (n < 0 || this.m_dimOfColors == n) {
            return;
        }
        super.setDimOfColors(n);
    }

    public void setDimOfVectors(int n) {
        int n2;
        if (n < 0 || n == this.m_dim) {
            return;
        }
        super.setDimOfVectors(n);
        if (this.m_elementNormal != null) {
            n2 = 0;
            while (n2 < this.m_maxNumElements) {
                this.m_elementNormal[n2].setSize(n);
                ++n2;
            }
        }
        if (this.hasBoundary()) {
            n2 = 0;
            while (n2 < this.m_bndList.length) {
                if (this.m_bndList[n2] != null) {
                    this.m_bndList[n2].setDimOfVectors(n);
                }
                ++n2;
            }
        }
    }

    public void assureElementColors() {
        if (this.m_elementColor == null || this.m_elementColor.length != this.m_maxNumElements) {
            this.m_elementColor = PdColor.realloc(this.m_elementColor, this.m_maxNumElements);
        }
    }

    public void buildTriangleFromCurve(PgPolygon[] pgPolygonArray, PgBndConstraint[] pgBndConstraintArray) {
        int n;
        double d;
        int n2;
        int n3;
        PdVector pdVector;
        PdVector pdVector2;
        if (pgPolygonArray == null || pgBndConstraintArray == null) {
            PsDebug.warning("missing argument", this);
            return;
        }
        if (pgPolygonArray.length != 3 || pgBndConstraintArray.length != 3) {
            PsDebug.warning("wrong argument array list", this);
            return;
        }
        int n4 = pgPolygonArray[0].getNumVertices();
        int n5 = n4 * (n4 + 1) / 2;
        int n6 = (n4 - 1) * (n4 - 1);
        this.setNumVertices(n5);
        this.setNumElements(n6);
        int n7 = n4;
        int n8 = 1;
        while (n8 < n4 - 1) {
            pdVector2 = pgPolygonArray[0].m_vertex[n8];
            pdVector = pgPolygonArray[1].m_vertex[n4 - 1 - n8];
            n3 = 1;
            n2 = 1;
            while (n2 < n4 - 1 - n8) {
                d = (double)n2 / (double)(n4 - 1 - n8);
                n = 0;
                while (n < this.m_dim) {
                    this.m_vertex[n7 + n3].m_data[n] = pdVector2.m_data[n] + d * (pdVector.m_data[n] - pdVector2.m_data[n]);
                    ++n;
                }
                ++n3;
                ++n2;
            }
            n7 += n4 - n8;
            ++n8;
        }
        --n7;
        n8 = 1;
        while (n8 < n4 - 1) {
            pdVector2 = pgPolygonArray[1].m_vertex[n8];
            pdVector = pgPolygonArray[2].m_vertex[n4 - 1 - n8];
            n3 = -n8 - 2;
            n2 = 1;
            while (n2 < n4 - 1 - n8) {
                d = (double)n2 / (double)(n4 - 1 - n8);
                n = 0;
                while (n < this.m_dim) {
                    int n9 = n;
                    this.m_vertex[n7 + n3].m_data[n9] = this.m_vertex[n7 + n3].m_data[n9] + (pdVector2.m_data[n] + d * (pdVector.m_data[n] - pdVector2.m_data[n]));
                    ++n;
                }
                n3 -= n8 + n2 + 2;
                ++n2;
            }
            n7 -= n8 + 1;
            ++n8;
        }
        --n7;
        n8 = 1;
        while (n8 < n4 - 1) {
            pdVector2 = pgPolygonArray[2].m_vertex[n8];
            pdVector = pgPolygonArray[0].m_vertex[n4 - 1 - n8];
            n3 = n4 - 1;
            n2 = 1;
            while (n2 < n4 - 1 - n8) {
                d = (double)n2 / (double)(n4 - 1 - n8);
                n = 0;
                while (n < this.m_dim) {
                    int n10 = n;
                    this.m_vertex[n7 + n3].m_data[n10] = this.m_vertex[n7 + n3].m_data[n10] + (pdVector2.m_data[n] + d * (pdVector.m_data[n] - pdVector2.m_data[n]));
                    ++n;
                }
                n3 += n4 - 1 - n2;
                ++n2;
            }
            --n7;
            ++n8;
        }
        n7 = n4;
        n8 = 1;
        while (n8 < n4 - 1) {
            n3 = 1;
            n2 = 1;
            while (n2 < n4 - n8 - 1) {
                n = 0;
                while (n < this.m_dim) {
                    int n11 = n++;
                    this.m_vertex[n7 + n3].m_data[n11] = this.m_vertex[n7 + n3].m_data[n11] / 3.0;
                }
                ++n3;
                ++n2;
            }
            n7 += n4 - n8;
            ++n8;
        }
        n7 = 0;
        n8 = 0;
        while (n8 < n4) {
            this.m_vertex[n7].copy(pgPolygonArray[0].m_vertex[n8]);
            n7 += n4 - n8;
            ++n8;
        }
        --n7;
        n8 = 0;
        while (n8 < n4) {
            this.m_vertex[n7].copy(pgPolygonArray[1].m_vertex[n8]);
            n7 -= n8 + 1;
            ++n8;
        }
        n7 += n4;
        n8 = 0;
        while (n8 < n4) {
            this.m_vertex[n7].copy(pgPolygonArray[2].m_vertex[n8]);
            --n7;
            ++n8;
        }
        this.makeTriangleConn(n4);
        this.makeTriangleBnd(n4);
        n8 = 0;
        while (n8 < pgBndConstraintArray.length) {
            this.m_bndList[n8].m_bndConstraint = pgBndConstraintArray[n8];
            ++n8;
        }
    }

    public boolean setElementTexture(int n, PdVector[] pdVectorArray) {
        if (n < 0 || n >= this.m_numElements) {
            PsDebug.warning("index=" + n + " out of range");
            return false;
        }
        if (pdVectorArray == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        if (this.m_elementTexture == null || n >= this.m_elementTexture.length) {
            this.assureElementTextures();
        }
        this.m_elementTexture[n] = PdVector.copyNew(pdVectorArray, pdVectorArray.length);
        return true;
    }

    public void setElementColors(Color[] colorArray) {
        if (colorArray == null) {
            this.m_elementColor = null;
            return;
        }
        if (colorArray.length < this.m_numElements) {
            PsDebug.warning("void length of color array");
            return;
        }
        if (this.m_elementColor == null || this.m_numElements > this.m_elementColor.length) {
            this.assureElementColors();
        }
        PdColor.copy(this.m_elementColor, 0, colorArray, 0, this.m_numElements);
    }

    public double getVolumeOfElement(int n) {
        PdVector[] pdVectorArray = this.getElementVertices(n);
        if (pdVectorArray == null || pdVectorArray.length < 3) {
            return 0.0;
        }
        PdVector pdVector = new PdVector(this.m_dim);
        PdVector pdVector2 = new PdVector(this.m_dim);
        pdVector.setConstant(0.0);
        pdVector2.normalOfPlane(pdVectorArray[0], pdVectorArray[1], pdVectorArray[2]);
        double d = PuVectorGeom.distOfPointToPlane(pdVector, pdVectorArray[0], pdVector2);
        double d2 = PdVector.area(pdVectorArray);
        return d2 * d / 3.0;
    }

    public boolean makeElementFromVertexColors() {
        if (!this.hasVertexColors()) {
            PsDebug.warning("missing vertex colors");
            return false;
        }
        if (this.m_numElements == 0) {
            return true;
        }
        this.assureElementColors();
        int n = 0;
        while (n < this.m_numElements) {
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            int n2 = this.m_element[n].getSize();
            int n3 = 0;
            while (n3 < n2) {
                f += (float)this.m_vertexColor[this.m_element[n].m_data[n3]].getRed();
                f2 += (float)this.m_vertexColor[this.m_element[n].m_data[n3]].getGreen();
                f3 += (float)this.m_vertexColor[this.m_element[n].m_data[n3]].getBlue();
                ++n3;
            }
            this.setElementColor(n, new Color((int)(f /= (float)n2), (int)(f2 /= (float)n2), (int)(f3 /= (float)n2)));
            ++n;
        }
        return true;
    }

    public boolean makeVertexFromElementColors() {
        if (!this.hasElementColors()) {
            PsDebug.warning("missing element colors");
            return false;
        }
        if (this.m_numVertices == 0 || this.m_numElements == 0) {
            return true;
        }
        this.assureVertexColors();
        PdVector[] pdVectorArray = PdVector.realloc(null, this.m_numVertices, 3);
        int[] nArray = new int[this.m_numVertices];
        int n = 0;
        while (n < this.m_numElements) {
            int n2 = this.m_element[n].getSize();
            int n3 = 0;
            while (n3 < n2) {
                int n4 = this.m_element[n].m_data[n3];
                pdVectorArray[n4].m_data[0] = pdVectorArray[n4].m_data[0] + (double)this.m_elementColor[n].getRed();
                pdVectorArray[n4].m_data[1] = pdVectorArray[n4].m_data[1] + (double)this.m_elementColor[n].getGreen();
                pdVectorArray[n4].m_data[2] = pdVectorArray[n4].m_data[2] + (double)this.m_elementColor[n].getBlue();
                int n5 = n4;
                nArray[n5] = nArray[n5] + 1;
                ++n3;
            }
            ++n;
        }
        n = 0;
        while (n < this.m_numVertices) {
            pdVectorArray[n].multScalar(1.0 / (double)nArray[n]);
            this.setVertexColor(n, new Color((float)pdVectorArray[n].m_data[0], (float)pdVectorArray[n].m_data[1], (float)pdVectorArray[n].m_data[2]));
            ++n;
        }
        return true;
    }

    public double getGlobalElementNormalLength() {
        return this.m_globalElementNormalLength.getValue();
    }

    public void setGlobalElementNormalLength(double d) {
        this.m_globalElementNormalLength.setValue(d);
    }

    public void buildQuadr(PdVector[] pdVectorArray, int n, int n2) {
        if (pdVectorArray == null || pdVectorArray.length < 4) {
            PsDebug.warning("no initial vertices or wrong number");
            return;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = (1 + (n - 1) * (n3 + 1)) * (1 + (n2 - 1) * (n4 + 1));
        int n6 = 4 + 2 * n3 + 2 * n4 - 2;
        int n7 = (n - 1) * (n2 - 1) * n6;
        this.setNumVertices(n5);
        this.setNumElements(n7);
        PdVector pdVector = new PdVector(this.m_dim);
        PdVector pdVector2 = new PdVector(this.m_dim);
        int n8 = 0;
        int n9 = 0;
        while (n9 < n) {
            double d = (double)n9 / ((double)n - 1.0);
            pdVector.blend(1.0 - d, pdVectorArray[0], d, pdVectorArray[1]);
            pdVector2.blend(1.0 - d, pdVectorArray[3], d, pdVectorArray[2]);
            int n10 = 0;
            while (n10 < n2) {
                double d2 = (double)n10 / ((double)n2 - 1.0);
                this.m_vertex[n8++].blend(1.0 - d2, pdVector, d2, pdVector2);
                ++n10;
            }
            ++n9;
        }
        this.makeQuadrConn(n, n2);
        this.makeQuadrBnd(n, n2);
    }

    public PdVector[] getElementNormals() {
        return this.m_elementNormal;
    }

    public boolean isShowingElementNormals() {
        return this.m_bShowElementNormals;
    }

    public void showElementNormals(boolean bl) {
        this.m_bShowElementNormals = bl;
    }

    public void assureElementNormals() {
        if (this.m_elementNormal == null || this.m_elementNormal.length != this.m_maxNumElements) {
            this.m_elementNormal = PdVector.realloc(this.m_elementNormal, this.m_maxNumElements, this.m_dim);
        }
    }

    public void setElementNormals(PdVector[] pdVectorArray) {
        if (pdVectorArray == null) {
            this.m_elementNormal = null;
            return;
        }
        if (pdVectorArray.length < this.m_numElements) {
            PsDebug.warning("void length of normal array");
            return;
        }
        if (this.m_elementNormal == null || this.m_numElements > this.m_elementNormal.length) {
            this.assureElementNormals();
        }
        PdVector.copy(this.m_elementNormal, 0, pdVectorArray, 0, this.m_numElements);
    }

    public boolean resetBoundaryNormals() {
        if (!this.hasVertexNormals()) {
            PsDebug.warning("missing vertex normals");
            return false;
        }
        int n = 0;
        while (n < this.m_numElements) {
            int n2 = this.m_element[n].getSize();
            int n3 = 0;
            while (n3 < n2) {
                if (this.m_neighbour[n].m_data[n3] == -1) {
                    this.m_vertexNormal[this.m_element[n].m_data[(n3 + 1) % n2]].setConstant(0.0);
                    this.m_vertexNormal[this.m_element[n].m_data[(n3 + 2) % n2]].setConstant(0.0);
                }
                ++n3;
            }
            ++n;
        }
        return true;
    }

    public PgElementSet() {
        this(3);
    }

    public PgElementSet(int n) {
        super(n);
        this.setTag(6);
        this.setDimOfSimplex(2);
        this.m_element = new PiVector[0];
        this.m_neighbour = new PiVector[0];
        this.m_elementSaved = null;
        this.m_elementTexture = null;
        this.m_globalElementColor = new PdColor(PsConfig.getMessage("Face"), this);
        this.m_globalElementBackColor = new PdColor(PsConfig.getMessage("FaceBack"), this);
        this.m_globalElementTagColor = new PdColor(PsConfig.getMessage("FaceTag"), this);
        this.m_globalElementNormalLength = new PuDouble(PsConfig.getMessage("globalElementNormalLength"), this);
        this.m_globalElementNormalSize = new PuDouble(PsConfig.getMessage("globalElementNormalSize"), this);
        this.m_globalElementNormalColor = new PdColor(PsConfig.getMessage("globalElementNormalColor"), this);
        this.m_globalEdgeColor = new PdColor(PsConfig.getMessage("Edge"), this);
        this.m_globalEdgeTagColor = new PdColor(PsConfig.getMessage("EdgeTag"), this);
        this.m_globalEdgeSize = new PuDouble(PsConfig.getMessage("EdgeSize"), this);
        this.m_globalBndColor = new PdColor(PsConfig.getMessage("Boundary"), this);
        this.m_globalBndTagColor = new PdColor(PsConfig.getMessage("BoundaryTag"), this);
        this.m_globalBndSize = new PuDouble(PsConfig.getMessage("BoundarySize"), this);
        if (this.getClass() == (class$jv$geom$PgElementSet != null ? class$jv$geom$PgElementSet : (class$jv$geom$PgElementSet = PgElementSet.class$("jv.geom.PgElementSet")))) {
            this.init();
        }
    }

    public Color getGlobalBndColor() {
        return this.m_globalBndColor.getColor();
    }

    public void setGlobalBndColor(Color color) {
        this.m_globalBndColor.setColor(color);
    }

    public void paint(PvGeometryIf pvGeometryIf) {
        super.paint(pvGeometryIf);
        pvGeometryIf.setState(83, this.isShowingEdgeLabels());
        pvGeometryIf.setState(84, this.isShowingElementLabels());
        pvGeometryIf.setState(68, this.m_bShowBackface);
        pvGeometryIf.setState(87, this.m_bShowOutline);
        pvGeometryIf.setState(52, this.m_bShowEdges);
        pvGeometryIf.setState(53, this.m_bShowTaggedEdges);
        pvGeometryIf.setState(93, this.m_bShowEdgeColors);
        if (this.m_bShowEdges || this.m_bShowOutline) {
            if (this.m_globalEdgeSize != null) {
                pvGeometryIf.setGlobalEdgeSize(this.m_globalEdgeSize.getValue());
            }
            if (this.m_globalEdgeColor != null) {
                pvGeometryIf.setGlobalEdgeColor(this.m_globalEdgeColor.getColor());
            }
            if (this.m_globalEdgeTagColor != null) {
                pvGeometryIf.setGlobalEdgeTagColor(this.m_globalEdgeTagColor.getColor());
            }
        }
        pvGeometryIf.setState(58, this.m_bShowBoundaries);
        pvGeometryIf.setState(59, this.m_bShowTaggedBoundaries);
        if (this.m_bShowBoundaries || this.m_bShowOutline) {
            if (this.m_globalBndSize != null) {
                pvGeometryIf.setGlobalBndSize(this.m_globalBndSize.getValue());
            }
            if (this.m_globalBndColor != null) {
                pvGeometryIf.setGlobalBndColor(this.m_globalBndColor.getColor());
            }
            if (this.m_globalBndColor != null) {
                pvGeometryIf.setGlobalBndTagColor(this.m_globalBndTagColor.getColor());
            }
        }
        pvGeometryIf.setState(56, this.m_bShowElements);
        pvGeometryIf.setState(57, this.m_bShowTaggedElements);
        pvGeometryIf.setState(94, this.m_bShowElementColors);
        pvGeometryIf.setState(99, this.m_bShowElementBackColor);
        pvGeometryIf.setState(100, this.m_bShowElementBackColors);
        pvGeometryIf.setNumElements(this.m_numElements);
        pvGeometryIf.setElements(this.m_element);
        if (this.isConforming()) {
            pvGeometryIf.setNeighbours(this.m_neighbour);
        } else {
            pvGeometryIf.setNeighbours(null);
        }
        pvGeometryIf.setElementColors(this.m_elementColor);
        pvGeometryIf.setElementBackColors(this.m_elementBackColor);
        pvGeometryIf.setState(62, this.m_bShowElementNormals);
        pvGeometryIf.setState(63, this.m_bShowElementNormalArrow);
        pvGeometryIf.setElementNormals(this.m_elementNormal);
        if (this.m_globalElementNormalSize != null) {
            pvGeometryIf.setGlobalElementNormalSize(this.m_globalElementNormalSize.getValue());
        }
        if (this.m_globalElementNormalLength != null) {
            pvGeometryIf.setGlobalElementNormalLength(this.m_globalElementNormalLength.getValue());
        }
        if (this.m_globalElementNormalColor != null) {
            pvGeometryIf.setGlobalElementNormalColor(this.m_globalElementNormalColor.getColor());
        }
        pvGeometryIf.setState(72, this.m_bShowElementTexture);
        if (this.m_bShowElementTexture && this.m_texture != null) {
            pvGeometryIf.setTexture(PsImage.getPixels(this.m_texture.getImage()), this.m_texture.getWidth(), this.m_texture.getHeight());
            pvGeometryIf.setElementTextures(this.m_elementTexture);
        }
        if (this.m_globalElementColor != null) {
            pvGeometryIf.setGlobalElementColor(this.m_globalElementColor.getColor());
        }
        if (this.m_globalElementBackColor != null) {
            pvGeometryIf.setGlobalElementBackColor(this.m_globalElementBackColor.getColor());
        }
        if (this.m_globalElementTagColor != null) {
            pvGeometryIf.setGlobalElementTagColor(this.m_globalElementTagColor.getColor());
        }
    }

    public int[] removeElement(int n) {
        this.m_element[n].setTag(2);
        return this.removeMarkedElements();
    }

    public void setTagElement(int n, int n2) {
        if (n < 0 || n > this.m_numElements - 1) {
            PsDebug.warning("index=" + n + " out of range");
            return;
        }
        this.m_element[n].setTag(n2);
    }

    public Color getElementColor(int n) {
        if (n < 0 || n >= this.m_numElements) {
            return null;
        }
        return this.m_elementColor[n];
    }

    public boolean setElementColor(int n, Color color) {
        if (n < 0 || n >= this.m_numElements) {
            PsDebug.warning("index=" + n + " out of range");
            return false;
        }
        if (color == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        if (this.m_elementColor == null || n >= this.m_elementColor.length) {
            this.assureElementColors();
        }
        this.m_elementColor[n] = color;
        return true;
    }

    public double getAreaOfElement(int n) {
        PdVector[] pdVectorArray = this.getElementVertices(n);
        double d = PdVector.area(pdVectorArray);
        return d;
    }

    public boolean isShowingElementNormalArrow() {
        return this.m_bShowElementNormalArrow;
    }

    public void showElementNormalArrow(boolean bl) {
        this.m_bShowElementNormalArrow = bl;
    }

    public PdVector getElementNormal(int n) {
        if (n < 0 || n >= this.m_numElements) {
            return null;
        }
        return this.m_elementNormal[n];
    }

    public boolean setElementNormal(int n, PdVector pdVector) {
        if (n < 0 || n >= this.m_numElements) {
            PsDebug.warning("index=" + n + " out of range");
            return false;
        }
        if (pdVector == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        if (this.m_elementNormal == null || n >= this.m_elementNormal.length) {
            this.assureElementNormals();
        }
        this.m_elementNormal[n].copy(pdVector);
        return true;
    }

    public int getSavedNumVertices() {
        return this.m_savedNumVertices;
    }

    public void setSavedNumVertices(int n) {
        this.m_savedNumVertices = n;
    }

    public PgJvxSrc getJvx() {
        PgJvxSrc pgJvxSrc = super.getJvx();
        pgJvxSrc.showEdgeLabels(this.isShowingEdgeLabels());
        pgJvxSrc.showElementLabels(this.isShowingElementLabels());
        pgJvxSrc.showBackface(this.isShowingBackface());
        pgJvxSrc.showOutline(this.isShowingOutline());
        pgJvxSrc.setType(33);
        pgJvxSrc.showElements(this.isShowingElements());
        pgJvxSrc.setDimOfElements(this.getDimOfElements());
        pgJvxSrc.setNumElements(this.getNumElements());
        pgJvxSrc.setElements(this.getElements());
        pgJvxSrc.setNeighbours(this.getNeighbours());
        pgJvxSrc.showElementColors(this.isShowingElementColors());
        pgJvxSrc.setElementColors(this.getElementColors());
        pgJvxSrc.showElementBackColors(this.isShowingElementBackColors());
        pgJvxSrc.setElementBackColors(this.getElementBackColors());
        pgJvxSrc.setGlobalElementColor(this.getGlobalElementColor());
        pgJvxSrc.setGlobalElementTagColor(this.getGlobalElementTagColor());
        pgJvxSrc.setGlobalElementBackColor(this.getGlobalElementBackColor());
        pgJvxSrc.showElementBackColor(this.isShowingElementBackColor());
        if (this.hasElementNormals()) {
            pgJvxSrc.showElementNormals(this.isShowingElementNormals());
            pgJvxSrc.setElementNormals(this.getElementNormals());
        } else {
            pgJvxSrc.showElementNormals(false);
        }
        pgJvxSrc.showElementNormalArrow(this.isShowingElementNormalArrow());
        pgJvxSrc.setGlobalElementNormalColor(this.getGlobalElementNormalColor());
        pgJvxSrc.setGlobalElementNormalLength(this.getGlobalElementNormalLength());
        pgJvxSrc.setGlobalElementNormalSize(this.getGlobalElementNormalSize());
        if (this.hasElementTextures()) {
            pgJvxSrc.showElementTexture(this.isShowingElementTextures());
            pgJvxSrc.setElementTextures(this.getElementTextures());
        } else {
            pgJvxSrc.showElementTexture(false);
        }
        pgJvxSrc.showEdges(this.isShowingEdges());
        if (this.hasEdgeColors()) {
            pgJvxSrc.showEdgeColors(this.isShowingEdgeColors());
            pgJvxSrc.setEdgeColors(this.getEdgeColors());
        } else {
            pgJvxSrc.showEdgeColors(false);
        }
        pgJvxSrc.setGlobalEdgeColor(this.getGlobalEdgeColor());
        pgJvxSrc.setGlobalEdgeTagColor(this.getGlobalEdgeTagColor());
        pgJvxSrc.setGlobalEdgeSize(this.getGlobalEdgeSize());
        pgJvxSrc.showBoundaries(this.isShowingBoundaries());
        pgJvxSrc.setGlobalBndColor(this.getGlobalBndColor());
        pgJvxSrc.setGlobalBndTagColor(this.getGlobalBndTagColor());
        pgJvxSrc.setGlobalBndSize(this.getGlobalBndSize());
        return pgJvxSrc;
    }

    public void setJvx(PgJvxSrc pgJvxSrc) {
        super.setJvx(pgJvxSrc);
        this.showEdgeLabels(pgJvxSrc.isShowingEdgeLabels());
        this.showElementLabels(pgJvxSrc.isShowingElementLabels());
        this.showOutline(pgJvxSrc.isShowingOutline());
        this.showBackface(pgJvxSrc.isShowingBackface());
        this.showElements(pgJvxSrc.isShowingElements());
        int n = PiVector.getSameSize(pgJvxSrc.getElements(), pgJvxSrc.getNumElements());
        this.setDimOfElements(n);
        this.setNumElements(pgJvxSrc.getNumElements());
        this.setElements(pgJvxSrc.getElements());
        if (pgJvxSrc.getNeighbours() != null) {
            this.setNeighbours(pgJvxSrc.getNeighbours());
        } else {
            this.makeNeighbour();
        }
        if (pgJvxSrc.getGlobalElementColor() != null) {
            this.setGlobalElementColor(pgJvxSrc.getGlobalElementColor());
        }
        if (pgJvxSrc.getGlobalElementTagColor() != null) {
            this.setGlobalElementTagColor(pgJvxSrc.getGlobalElementTagColor());
        }
        this.setElementColors(pgJvxSrc.getElementColors());
        this.showElementColors(pgJvxSrc.isShowingElementColors());
        this.setElementBackColors(pgJvxSrc.getElementBackColors());
        this.showElementBackColors(pgJvxSrc.isShowingElementBackColors());
        this.setGlobalElementBackColor(pgJvxSrc.getGlobalElementBackColor());
        this.showElementBackColor(pgJvxSrc.isShowingElementBackColor());
        this.showElementNormals(pgJvxSrc.isShowingElementNormals());
        this.showElementNormalArrow(pgJvxSrc.isShowingElementNormalArrow());
        if (pgJvxSrc.getElementNormals() != null) {
            this.setElementNormals(pgJvxSrc.getElementNormals());
        } else {
            this.makeElementNormals();
        }
        if (pgJvxSrc.getVertexNormals() == null) {
            this.makeVertexNormals();
        }
        if (pgJvxSrc.getGlobalElementNormalColor() != null) {
            this.setGlobalElementNormalColor(pgJvxSrc.getGlobalElementNormalColor());
        }
        if (pgJvxSrc.getGlobalElementNormalLength() != 0.0) {
            this.setGlobalElementNormalLength(pgJvxSrc.getGlobalElementNormalLength());
        }
        if (pgJvxSrc.getGlobalElementNormalSize() != 0.0) {
            this.setGlobalElementNormalSize(pgJvxSrc.getGlobalElementNormalSize());
        }
        this.setElementTextures(pgJvxSrc.getElementTextures());
        this.showElementTexture(pgJvxSrc.isShowingElementTexture());
        this.showEdges(pgJvxSrc.isShowingEdges());
        if (pgJvxSrc.getEdges() != null) {
            this.setEdges(pgJvxSrc.getEdges());
        }
        if (pgJvxSrc.getEdgeColors() != null) {
            this.setEdgeColors(pgJvxSrc.getEdgeColors());
            this.showEdgeColors(true);
        } else {
            this.showEdgeColors(false);
        }
        if (pgJvxSrc.getGlobalEdgeColor() != null) {
            this.setGlobalEdgeColor(pgJvxSrc.getGlobalEdgeColor());
        }
        if (pgJvxSrc.getGlobalEdgeTagColor() != null) {
            this.setGlobalEdgeTagColor(pgJvxSrc.getGlobalEdgeTagColor());
        }
        if (pgJvxSrc.getGlobalEdgeSize() != 0.0) {
            this.setGlobalEdgeSize(pgJvxSrc.getGlobalEdgeSize());
        }
        this.showBoundaries(pgJvxSrc.isShowingBoundaries());
        if (pgJvxSrc.getGlobalBndColor() != null) {
            this.setGlobalBndColor(pgJvxSrc.getGlobalBndColor());
        }
        if (pgJvxSrc.getGlobalBndTagColor() != null) {
            this.setGlobalBndTagColor(pgJvxSrc.getGlobalBndTagColor());
        }
        if (pgJvxSrc.getGlobalBndSize() != 0.0) {
            this.setGlobalBndSize(pgJvxSrc.getGlobalBndSize());
        }
        if (pgJvxSrc.getNumVectorFields() > 0) {
            int n2 = pgJvxSrc.getNumVectorFields();
            int n3 = 0;
            while (n3 < n2) {
                PdVector[] pdVectorArray;
                if (pgJvxSrc.isVectorElementBased(n3) && (pdVectorArray = pgJvxSrc.getVectors(n3)) != null && pdVectorArray.length != 0) {
                    int n4 = pdVectorArray.length;
                    PgVectorField pgVectorField = new PgVectorField(pgJvxSrc.getDimOfVectors(n3));
                    pgVectorField.setName(pgJvxSrc.getVectorFieldName(n3));
                    pgVectorField.setGeometry(this);
                    pgVectorField.setBasedOn(1);
                    pgVectorField.setNumVectors(n4);
                    if (pgVectorField.setVectors(pdVectorArray)) {
                        this.addVectorField(pgVectorField);
                    }
                    this.showVectorArrow(pgJvxSrc.isShowingVectorArrows(n3));
                    if (pgJvxSrc.getGlobalVectorSize(n3) != 0.0) {
                        this.setGlobalVectorSize(pgJvxSrc.getGlobalVectorSize(n3));
                    }
                    if (pgJvxSrc.getGlobalVectorLength(n3) != 0.0) {
                        this.setGlobalVectorLength(pgJvxSrc.getGlobalVectorLength(n3));
                    }
                    if (pgJvxSrc.getGlobalVectorColor(n3) != null) {
                        this.setGlobalVectorColor(pgJvxSrc.getGlobalVectorColor(n3));
                    }
                }
                ++n3;
            }
        }
    }

    public int getNeighbourLocInd(int n, int n2, int n3) {
        int n4 = this.m_element[n].getSize();
        int n5 = 0;
        while (n5 < n4) {
            if (this.m_element[n].m_data[n5] == n2 && this.m_element[n].m_data[(n5 + 1) % n4] == n3) {
                return (n5 + n4 - 1) % n4;
            }
            if (this.m_element[n].m_data[n5] == n3 && this.m_element[n].m_data[(n5 + 1) % n4] == n2) {
                return (n5 + n4 - 1) % n4;
            }
            ++n5;
        }
        PsDebug.error("cannot find edge (" + n2 + "," + n3 + ") in element[" + n + "]", this);
        return -1;
    }

    public boolean isShowingTaggedElements() {
        return this.m_bShowTaggedElements;
    }

    public void showTaggedElements(boolean bl) {
        this.m_bShowTaggedElements = bl;
    }

    public int getNumElements() {
        return this.m_numElements;
    }

    public void setNumElements(int n) {
        int n2;
        if (n > this.m_maxNumElements) {
            this.setMaxNumElements(n);
        } else if (n < this.m_numElements && this.m_dimOfElements == -1) {
            n2 = n;
            while (n2 < this.m_numElements) {
                this.m_element[n2].setSize(0);
                this.m_neighbour[n2].setSize(0);
                ++n2;
            }
        }
        n2 = 0;
        while (n2 < this.m_numElements) {
            int n3 = this.m_neighbour[n2].getSize() - 1;
            while (n3 >= 0) {
                if (this.m_neighbour[n2].m_data[n3] >= n) {
                    this.m_neighbour[n2].m_data[n3] = -1;
                }
                --n3;
            }
            ++n2;
        }
        n2 = this.m_numElements;
        while (n2 < n) {
            this.m_neighbour[n2].setConstant(-1);
            ++n2;
        }
        this.m_numElements = n;
    }

    public String printEdgeList() {
        PgElementEdge[] pgElementEdgeArray = this.getEdgeList();
        if (pgElementEdgeArray == null) {
            return "missing edge list";
        }
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("\t Number of edges    = " + pgElementEdgeArray.length + "\n");
        stringBuffer.append("\t Number of vertices = " + this.getNumVertices() + "\n");
        stringBuffer.append("\t Number of elements = " + this.getNumElements() + "\n");
        int n = 0;
        while (n < pgElementEdgeArray.length) {
            stringBuffer.append("\t Edge[" + n + "] = (" + pgElementEdgeArray[n].getEdgeInd(0) + ", " + pgElementEdgeArray[n].getEdgeInd(1) + ")");
            stringBuffer.append("   Adj.Elements = {");
            int n2 = pgElementEdgeArray[n].getSize();
            stringBuffer.append(String.valueOf(pgElementEdgeArray[n].getElementInd(0)));
            int n3 = 1;
            while (n3 < n2) {
                stringBuffer.append(", " + pgElementEdgeArray[n].getElementInd(n3));
                ++n3;
            }
            stringBuffer.append("}\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    public boolean isShowingOutline() {
        return this.m_bShowOutline;
    }

    public void showOutline(boolean bl) {
        this.m_bShowOutline = bl;
    }

    public void makeTriangleBnd(int n) {
        int n2 = 3;
        this.assureBoundary(n2);
        int n3 = 0;
        while (n3 < n2) {
            this.m_bndList[n3].setNumVertices(n);
            this.m_bndList[n3].clearTag(2);
            ++n3;
        }
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            this.m_bndList[0].m_vertexInd.m_data[n5] = n4;
            n4 += n - n5;
            ++n5;
        }
        n4 = 0;
        n5 = 0;
        while (n5 < n) {
            this.m_bndList[1].m_vertexInd.m_data[n5] = (n4 += n - n5) - 1;
            ++n5;
        }
        n5 = 0;
        while (n5 < n) {
            this.m_bndList[2].m_vertexInd.m_data[n5] = n - 1 - n5;
            ++n5;
        }
        n3 = 0;
        while (n3 < n2) {
            this.m_bndList[n3].makeElementInd();
            ++n3;
        }
    }

    public int addElement(PiVector piVector) {
        if (piVector == null || piVector.getSize() < 3) {
            PsDebug.warning("argument element too small.");
            return -1;
        }
        int n = this.getNumElements();
        this.setNumElements(n + 1);
        this.setElement(n, piVector);
        return n;
    }

    public boolean addElement(PiVector piVector, int n) {
        if (n < 0 || n > this.m_numElements) {
            PsDebug.warning("index=" + n + " out of range.");
            return false;
        }
        if (piVector == null || piVector.getSize() < 3) {
            PsDebug.warning("argument element too small.");
            return false;
        }
        int n2 = piVector.getSize();
        if (this.m_numElements == 0) {
            this.m_dimOfElements = n2;
        } else if (this.m_dimOfElements != n2) {
            this.m_dimOfElements = -1;
        }
        this.setNumElements(this.m_numElements + 1);
        if (n == this.m_numElements - 1) {
            this.m_element[this.m_numElements - 1].setSize(n2);
            this.m_element[this.m_numElements - 1].copy(piVector);
            return true;
        }
        int n3 = this.m_numElements - 2;
        while (n3 >= n) {
            this.m_element[n3 + 1].setSize(this.m_element[n3].getSize());
            this.m_element[n3 + 1].copy(this.m_element[n3]);
            --n3;
        }
        this.m_element[n].setSize(n2);
        this.m_element[n].copy(piVector);
        return true;
    }

    public boolean hasTagElement(int n, int n2) {
        if (n < 0 || n > this.m_numElements - 1) {
            PsDebug.warning("index=" + n + " out of range");
            return false;
        }
        return this.m_element[n].hasTag(n2);
    }

    public boolean isShowingEdgeLabels() {
        return this.m_bShowEdgeLabels;
    }

    public boolean isShowingElementLabels() {
        return this.m_bShowElementLabels;
    }

    public void showEdgeLabels(boolean bl) {
        this.m_bShowEdgeLabels = bl;
    }

    public void showElementLabels(boolean bl) {
        this.m_bShowElementLabels = bl;
    }

    public Color getGlobalElementColor() {
        return this.m_globalElementColor.getColor();
    }

    public void setGlobalElementColor(Color color) {
        this.m_globalElementColor.setColor(color);
    }

    public Color getGlobalElementNormalColor() {
        return this.m_globalElementNormalColor.getColor();
    }

    public void setGlobalElementNormalColor(Color color) {
        this.m_globalElementNormalColor.setColor(color);
    }

    public Color getGlobalEdgeColor() {
        return this.m_globalEdgeColor.getColor();
    }

    public void setGlobalEdgeColor(Color color) {
        this.m_globalEdgeColor.setColor(color);
    }

    public PdVector[][] getElementTextures() {
        return this.m_elementTexture;
    }

    public PdVector[] getVertexTextures() {
        if (this.hasVertexTextures()) {
            return super.getVertexTextures();
        }
        if (!this.hasElementTextures()) {
            return null;
        }
        int n = this.getNumElementIndices();
        PdVector[] pdVectorArray = new PdVector[n];
        n = 0;
        int n2 = 0;
        while (n2 < this.m_numElements) {
            int n3 = this.m_element[n2].getSize();
            int n4 = 0;
            while (n4 < n3) {
                pdVectorArray[n++] = this.m_elementTexture[n2][n4];
                ++n4;
            }
            ++n2;
        }
        return pdVectorArray;
    }

    public double getGlobalBndSize() {
        return this.m_globalBndSize.getValue();
    }

    public void setGlobalBndSize(double d) {
        this.m_globalBndSize.setValue(d);
    }

    public void setVertexTextures(PdVector[] pdVectorArray) {
        if (this.hasVertexTextures()) {
            super.setVertexTextures(pdVectorArray);
            return;
        }
        if (pdVectorArray == null) {
            this.m_elementTexture = null;
            return;
        }
        if (pdVectorArray.length < this.getNumElementIndices()) {
            PsDebug.warning("void length of argument array");
            return;
        }
        this.assureElementTextures();
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_numElements) {
            int n3 = this.m_element[n2].getSize();
            int n4 = 0;
            while (n4 < n3) {
                this.m_elementTexture[n2][n4].copy(pdVectorArray[n++]);
                ++n4;
            }
            ++n2;
        }
    }

    public boolean isShowingElementTextures() {
        return this.m_bShowElementTexture;
    }

    public void assureElementTextures() {
        if (this.m_elementTexture == null || this.m_elementTexture.length != this.m_maxNumElements) {
            this.m_elementTexture = new PdVector[this.m_maxNumElements][];
        }
        int n = 0;
        while (n < this.m_maxNumElements) {
            this.m_elementTexture[n] = PdVector.realloc(this.m_elementTexture[n], this.m_element[n].getSize(), this.m_dimOfTextures);
            ++n;
        }
    }

    public void setElementTextures(PdVector[][] pdVectorArray) {
        if (pdVectorArray == null) {
            this.m_elementTexture = null;
            return;
        }
        if (pdVectorArray.length < this.m_numElements) {
            PsDebug.warning("void length of tex array");
            return;
        }
        int n = 0;
        while (n < this.m_numElements) {
            if (pdVectorArray[n] == null || pdVectorArray[n].length != this.m_element[n].getSize()) {
                PsDebug.warning("void length of texCoords[" + n + "]");
                return;
            }
            ++n;
        }
        this.assureElementTextures();
        n = 0;
        while (n < this.m_numElements) {
            PdVector.copy(this.m_elementTexture[n], 0, pdVectorArray[n], 0, this.m_element[n].getSize());
            ++n;
        }
    }

    public double getEdgeLength(int n, int n2) {
        int[] nArray = this.m_element[n].m_data;
        double d = PdVector.dist(this.m_vertex[nArray[(n2 + 1) % nArray.length]], this.m_vertex[nArray[(n2 + 2) % nArray.length]]);
        return d;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(super.toString());
        stringBuffer.append("\t ******* PgElementSet *********\n");
        stringBuffer.append("\t m_numElements    = " + this.m_numElements + "\n");
        stringBuffer.append("\t m_numBndSegments = " + this.getNumBoundaries() + "\n");
        stringBuffer.append("\t m_bConforming    = " + this.isConforming() + "\n");
        stringBuffer.append("\t ******* m_element *******\n");
        if (this.m_element != null) {
            n = 0;
            while (n < this.m_numElements) {
                stringBuffer.append("\t [" + n + "] = " + this.m_element[n].toShortString());
                ++n;
            }
        } else {
            stringBuffer.append("\t m_element = null\n");
        }
        stringBuffer.append("\t ******* m_neighbour *******\n");
        if (this.m_neighbour != null) {
            n = 0;
            while (n < this.m_numElements) {
                stringBuffer.append("\t [" + n + "] = " + this.m_neighbour[n].toShortString());
                ++n;
            }
        } else {
            stringBuffer.append("\t m_neighbour = null\n");
        }
        stringBuffer.append("\t ******* m_elementTexture *******\n");
        if (this.m_elementTexture != null && this.m_numElements > 0) {
            n = 0;
            while (n < this.m_numElements) {
                if (this.m_elementTexture[n] == null) {
                    stringBuffer.append("\t [" + n + "] = null");
                } else {
                    int n2 = 0;
                    while (n < this.m_elementTexture[n].length) {
                        stringBuffer.append("\t [" + n + "][" + n2 + "] = " + this.m_elementTexture[n][n2].toShortString());
                        ++n;
                    }
                }
                ++n;
            }
        } else {
            stringBuffer.append("\t m_elementTexture = null\n");
        }
        return stringBuffer.toString();
    }

    public int getOppVertexInd(int n, int n2) {
        int n3 = this.getOppVertexLocInd(n, n2);
        if (n3 == -1) {
            return -1;
        }
        if (this.m_neighbour[n].m_data[n2] < 0) {
            return -1;
        }
        return this.m_element[this.m_neighbour[n].m_data[n2]].m_data[n3];
    }

    public PiVector[] getElements() {
        return this.m_element;
    }

    public boolean isShowingElements() {
        return this.m_bShowElements;
    }

    public void showElements(boolean bl) {
        this.m_bShowElements = bl;
    }

    public int getMaxNumElements() {
        return this.m_maxNumElements;
    }

    protected void setMaxNumElements(int n) {
        if (this.m_maxNumElements == n) {
            return;
        }
        if (this.m_dimOfElements > -1) {
            this.m_element = PiVector.realloc(this.m_element, n, this.m_dimOfElements);
            if (this.m_maxNumElements < n) {
                this.m_neighbour = PiVector.realloc(this.m_neighbour, n, this.m_dimOfElements);
                int n2 = this.m_maxNumElements;
                while (n2 < n) {
                    this.m_neighbour[n2].setConstant(-1);
                    ++n2;
                }
            }
        } else {
            this.m_element = PiVector.realloc(this.m_element, n);
            if (this.m_maxNumElements < n) {
                this.m_neighbour = PiVector.realloc(this.m_neighbour, n);
            }
        }
        this.m_maxNumElements = n;
        this.assureNeighbours();
        if (this.m_elementNormal != null) {
            this.assureElementNormals();
        }
        if (this.m_elementColor != null) {
            this.assureElementColors();
        }
        if (this.m_elementBackColor != null) {
            this.assureElementBackColors();
        }
        if (this.m_maxNumElements < this.m_numElements) {
            this.m_numElements = this.m_maxNumElements;
        }
        if (this.m_elementTexture != null) {
            this.assureElementTextures();
        }
    }

    public int getDimOfElements() {
        return this.m_dimOfElements;
    }

    public void setDimOfElements(int n) {
        if (n == this.m_dimOfElements) {
            return;
        }
        if (n != -1 && n < 3) {
            PsDebug.warning("argument aSize=" + n + " out of range.");
            return;
        }
        this.m_dimOfElements = n;
        if (n == -1) {
            int n2 = this.m_numElements;
            while (n2 < this.m_maxNumElements) {
                this.m_element[n2].setSize(0);
                this.m_neighbour[n2].setSize(0);
                ++n2;
            }
            return;
        }
        int n3 = 0;
        while (n3 < this.m_maxNumElements) {
            this.m_element[n3].setSize(n);
            this.m_neighbour[n3].setSize(n);
            this.m_neighbour[n3].setConstant(-1);
            ++n3;
        }
    }

    public void copyElementSet(PgElementSet pgElementSet) {
        int n;
        this.setDimOfElements(pgElementSet.getDimOfElements());
        this.setNumElements(pgElementSet.getNumElements());
        this.m_bConforming = pgElementSet.m_bConforming;
        this.m_savedNumVertices = pgElementSet.m_savedNumVertices;
        if (pgElementSet.m_elementSaved != null) {
            this.m_elementSaved = PiVector.copyNew(pgElementSet.m_elementSaved, pgElementSet.m_elementSaved.length);
        }
        if (this.m_dimOfElements == -1) {
            int n2 = 0;
            while (n2 < this.m_numElements) {
                this.m_element[n2].setSize(pgElementSet.getElement(n2).getSize());
                ++n2;
            }
        }
        PiVector.copy(this.m_element, 0, pgElementSet.getElements(), 0, this.m_numElements);
        PiVector[] piVectorArray = pgElementSet.getNeighbours();
        if (piVectorArray != null) {
            if (this.m_dimOfElements == -1) {
                n = 0;
                while (n < this.m_numElements) {
                    this.m_neighbour[n].setSize(pgElementSet.getNeighbour(n).getSize());
                    ++n;
                }
            }
            PiVector.copy(this.m_neighbour, 0, piVectorArray, 0, this.m_numElements);
        } else {
            this.m_neighbour = null;
        }
        if (pgElementSet.m_edge != null) {
            this.setNumEdges(pgElementSet.getNumEdges(), -1);
            PiVector.copy(this.m_edge, 0, pgElementSet.getEdges(), 0, this.m_numEdges);
        } else {
            this.m_edge = null;
        }
        if (pgElementSet.m_edgeColor != null) {
            this.assureEdgeColors();
            PdColor.copy(this.m_edgeColor, 0, pgElementSet.getEdgeColors(), 0, this.m_numEdges);
        } else {
            this.m_edgeColor = null;
        }
        if (pgElementSet.m_elementNormal != null) {
            this.assureElementNormals();
            PdVector.copy(this.m_elementNormal, 0, pgElementSet.getElementNormals(), 0, this.m_numElements);
        } else {
            this.m_elementNormal = null;
        }
        if (pgElementSet.m_elementColor != null) {
            this.assureElementColors();
            PdColor.copy(this.m_elementColor, 0, pgElementSet.getElementColors(), 0, this.m_numElements);
        } else {
            this.m_elementColor = null;
        }
        if (pgElementSet.m_elementBackColor != null) {
            this.assureElementBackColors();
            PdColor.copy(this.m_elementBackColor, 0, pgElementSet.getElementBackColors(), 0, this.m_numElements);
        } else {
            this.m_elementBackColor = null;
        }
        if (pgElementSet.m_elementTexture != null) {
            this.assureElementTextures();
            n = 0;
            while (n < this.m_numElements) {
                PdVector.copy(this.m_elementTexture[n], 0, pgElementSet.m_elementTexture[n], 0, pgElementSet.m_elementTexture[n].length);
                ++n;
            }
        } else {
            this.m_elementTexture = null;
        }
        if (pgElementSet.hasBoundary()) {
            PgBndPolygon[] pgBndPolygonArray = pgElementSet.getBoundaries();
            this.assureBoundary(pgBndPolygonArray.length);
            int n3 = 0;
            while (n3 < this.m_bndList.length) {
                this.m_bndList[n3].copy(pgBndPolygonArray[n3]);
                ++n3;
            }
            return;
        }
        this.m_bndList = null;
    }

    public boolean assureDimOfElements() {
        int n = PiVector.getSameSize(this.m_element, this.m_numElements);
        if (n != this.m_dimOfElements) {
            this.setDimOfElements(n);
            return false;
        }
        return true;
    }

    public int[] removeMarkedElements() {
        int n;
        int n2;
        int n3 = 1;
        int n4 = -1;
        PiVector piVector = new PiVector(this.m_numElements);
        piVector.setConstant(n4);
        int[] nArray = piVector.m_data;
        int n5 = 0;
        while (n5 < this.m_numElements) {
            if (!this.m_element[n5].hasTag(2)) {
                nArray[n5] = n3;
            }
            ++n5;
        }
        int n6 = 0;
        n5 = 0;
        while (n5 < this.m_numElements) {
            if (nArray[n5] == n3) {
                nArray[n5] = n6++;
            }
            ++n5;
        }
        n5 = 0;
        while (n5 < this.m_numElements) {
            if (nArray[n5] != n4) {
                n2 = 0;
                while (n2 < this.m_element[n5].m_data.length) {
                    if (this.m_neighbour[n5].m_data[n2] > -1) {
                        this.m_neighbour[n5].m_data[n2] = nArray[this.m_neighbour[n5].m_data[n2]];
                    }
                    ++n2;
                }
            }
            ++n5;
        }
        n5 = 0;
        while (n5 < this.m_numElements) {
            if (nArray[n5] != n4 && nArray[n5] < n5) {
                this.m_element[nArray[n5]].setSize(this.m_element[n5].getSize());
                this.m_element[nArray[n5]].copy(this.m_element[n5]);
                this.m_neighbour[nArray[n5]].setSize(this.m_neighbour[n5].getSize());
                this.m_neighbour[nArray[n5]].copy(this.m_neighbour[n5]);
            }
            ++n5;
        }
        if (this.m_elementNormal != null) {
            n5 = 0;
            while (n5 < this.m_numElements) {
                if (nArray[n5] != n4 && nArray[n5] < n5) {
                    this.m_elementNormal[nArray[n5]].setSize(this.m_elementNormal[n5].getSize());
                    this.m_elementNormal[nArray[n5]].copy(this.m_elementNormal[n5]);
                }
                ++n5;
            }
        }
        if (this.m_elementColor != null) {
            n5 = 0;
            while (n5 < this.m_numElements) {
                if (nArray[n5] != n4 && nArray[n5] < n5) {
                    this.m_elementColor[nArray[n5]] = this.m_elementColor[n5];
                }
                ++n5;
            }
        }
        if (this.m_elementBackColor != null) {
            n5 = 0;
            while (n5 < this.m_numElements) {
                if (nArray[n5] != n4 && nArray[n5] < n5) {
                    this.m_elementBackColor[nArray[n5]] = this.m_elementBackColor[n5];
                }
                ++n5;
            }
        }
        if (this.m_elementTexture != null) {
            n5 = 0;
            while (n5 < this.m_numElements) {
                if (nArray[n5] != n4 && nArray[n5] < n5) {
                    this.m_elementTexture[nArray[n5]] = PdVector.copyNew(this.m_elementTexture[n5]);
                }
                ++n5;
            }
        }
        if (this.m_bndList != null) {
            n5 = 0;
            while (n5 < this.m_bndList.length) {
                if (!this.m_bndList[n5].hasTag(2)) {
                    n = this.m_bndList[n5].getNumElements();
                    n2 = 0;
                    while (n2 < n) {
                        if (nArray[this.m_bndList[n5].m_elementInd.m_data[n2]] == n4) {
                            this.m_bndList[n5].setTag(2);
                            break;
                        }
                        this.m_bndList[n5].m_elementInd.m_data[n2] = nArray[this.m_bndList[n5].m_elementInd.m_data[n2]];
                        ++n2;
                    }
                }
                ++n5;
            }
        }
        n = this.getNumVectorFields();
        n5 = 0;
        while (n5 < n) {
            PgVectorField pgVectorField = this.getVectorField(n5);
            if (pgVectorField.getBasedOn() != 0) {
                n2 = 0;
                while (n2 < this.m_numElements) {
                    if (nArray[n2] != n4 && nArray[n2] < n2) {
                        pgVectorField.setVector(nArray[n2], pgVectorField.getVector(n2));
                    }
                    ++n2;
                }
                pgVectorField.setNumVectors(n6);
            }
            ++n5;
        }
        this.setNumElements(n6);
        this.setMaxNumElements(n6);
        return nArray;
    }

    public void setElements(PiVector[] piVectorArray) {
        if ((piVectorArray == null || piVectorArray.length == 0) && this.m_numElements == 0) {
            return;
        }
        if (piVectorArray.length < this.m_numElements) {
            PsDebug.warning("void length of element array");
            return;
        }
        int n = piVectorArray[0].getSize();
        int n2 = 0;
        while (n2 < this.m_numElements) {
            int n3 = piVectorArray[n2].getSize();
            this.m_element[n2].setSize(n3);
            if (n != -1 && n3 != n) {
                n = -1;
            }
            ++n2;
        }
        if (this.m_dimOfElements != n) {
            this.setDimOfElements(n);
        }
        PiVector.copy(this.m_element, 0, piVectorArray, 0, this.m_numElements);
        if (this.m_dimOfElements == -1) {
            this.assureNeighbours();
        }
    }

    public double getVolume() {
        double d = 0.0;
        int n = 0;
        while (n < this.m_numElements) {
            d += this.getVolumeOfElement(n);
            ++n;
        }
        return d;
    }

    public void computeTorus(int n, int n2, double d, double d2) {
        if (this.m_dim < 3) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        super.computeTorus(n, n2, d, d2);
        this.makeQuadrConn(n, n2);
        this.makeQuadrBnd(n, n2);
    }

    public void copy(PgGeometry pgGeometry) {
        super.copy(pgGeometry);
        if (!(pgGeometry instanceof PgElementSet)) {
            return;
        }
        this.copyElementSet((PgElementSet)pgGeometry);
        int n = this.getNumVectorFields();
        int n2 = 0;
        while (n2 < n) {
            PgVectorField pgVectorField = this.getVectorField(n2);
            if (pgVectorField.getBasedOn() == 1) {
                pgVectorField.setGeometry(this);
            }
            ++n2;
        }
    }

    private void schemeButterfly(PdVector pdVector, int n, int n2, int n3, int n4, double[] dArray) {
        int[] nArray = new int[10];
        nArray[0] = -1;
        nArray[1] = this.getOppVertexInd(n, (n2 + 3 - 1) % 3);
        nArray[2] = this.m_element[n].m_data[n2];
        nArray[3] = this.getOppVertexInd(n, (n2 + 1) % 3);
        nArray[4] = this.m_element[n].m_data[(n2 + 1) % 3];
        nArray[5] = this.m_element[n].m_data[(n2 + 3 - 1) % 3];
        if (n3 != -1) {
            nArray[6] = this.getOppVertexInd(n3, (n4 + 1) % 3);
            nArray[7] = this.m_element[n3].m_data[n2];
            nArray[8] = this.getOppVertexInd(n3, (n4 + 3 - 1) % 3);
        } else {
            nArray[8] = -1;
            nArray[7] = -1;
            nArray[6] = -1;
        }
        nArray[9] = -1;
        pdVector.setConstant(0.0);
        int n5 = 0;
        do {
            if (nArray[n5] == -1) continue;
            pdVector.blendBase(pdVector, dArray[n5], this.m_vertex[nArray[n5]]);
        } while (++n5 < 10);
    }

    public void computeCylinder(int n, int n2, double d, double d2) {
        if (this.m_dim < 3) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        super.computeCylinder(n, n2, d, d2);
        this.makeQuadrConn(n, n2);
        this.makeQuadrBnd(n, n2);
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public PgBndPolygon[] getBoundaries() {
        if (this.m_bndList == null) {
            this.assureBoundary(0);
        }
        return this.m_bndList;
    }

    public boolean isShowingBoundaries() {
        return this.m_bShowBoundaries;
    }

    public void showBoundaries(boolean bl) {
        this.m_bShowBoundaries = bl;
    }

    public void flipOrientation() {
        super.flipOrientation();
        int n = 100;
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < this.m_numElements) {
            this.m_element[n2].invert();
            int n3 = this.m_element[n2].m_data.length;
            if (n3 > n) {
                n = 2 * n3;
                nArray = new int[n];
            }
            int n4 = 0;
            while (n4 < n3) {
                nArray[n4] = this.m_neighbour[n2].m_data[n4];
                ++n4;
            }
            n4 = 0;
            while (n4 < n3) {
                this.m_neighbour[n2].m_data[n4] = nArray[(n3 - 4 - n4 + n3) % n3];
                ++n4;
            }
            ++n2;
        }
        if (this.m_elementNormal != null) {
            n2 = 0;
            while (n2 < this.m_numElements) {
                this.m_elementNormal[n2].multScalar(-1.0);
                ++n2;
            }
        }
    }

    public Color getGlobalEdgeTagColor() {
        return this.m_globalEdgeTagColor.getColor();
    }

    public void setGlobalEdgeTagColor(Color color) {
        this.m_globalEdgeTagColor.setColor(color);
    }

    public Color getGlobalElementBackColor() {
        return this.m_globalElementBackColor.getColor();
    }

    public Color getGlobalElementTagColor() {
        return this.m_globalElementTagColor.getColor();
    }

    public void setGlobalElementBackColor(Color color) {
        this.m_globalElementBackColor.setColor(color);
    }

    public void setGlobalElementTagColor(Color color) {
        this.m_globalElementTagColor.setColor(color);
    }

    public int getElementWithVertex(int n) {
        int n2 = 0;
        while (n2 < this.m_numElements) {
            if (this.m_element[n2].getIndexOf(n) > -1) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public boolean merge(PgGeometryIf pgGeometryIf) {
        int n;
        int n2;
        int n3;
        int n4 = this.m_numVertices;
        if (!super.merge(pgGeometryIf)) {
            return false;
        }
        if (!(pgGeometryIf instanceof PgElementSet)) {
            return false;
        }
        PgElementSet pgElementSet = (PgElementSet)pgGeometryIf;
        if (this.m_numElements == 0) {
            this.setDimOfElements(pgElementSet.m_dimOfElements);
        } else if (pgElementSet.m_dimOfElements != this.m_dimOfElements) {
            this.setDimOfElements(-1);
        }
        int n5 = this.m_numElements;
        int n6 = this.m_numElements + pgElementSet.m_numElements;
        this.setNumElements(n6);
        PiVector.copy(this.m_element, n5, pgElementSet.m_element, 0, pgElementSet.m_numElements);
        int n7 = 0;
        while (n7 < pgElementSet.m_numElements) {
            n3 = pgElementSet.m_element[n7].getSize();
            if (this.m_dimOfElements == -1) {
                this.m_element[n5 + n7].setSize(n3);
            }
            n2 = 0;
            while (n2 < n3) {
                int n8 = n2++;
                this.m_element[n5 + n7].m_data[n8] = this.m_element[n5 + n7].m_data[n8] + n4;
            }
            ++n7;
        }
        if (pgElementSet.m_neighbour != null) {
            this.assureNeighbours();
            PiVector.copy(this.m_neighbour, n5, pgElementSet.m_neighbour, 0, pgElementSet.m_numElements);
            n7 = 0;
            while (n7 < pgElementSet.m_numElements) {
                n3 = pgElementSet.m_element[n7].getSize();
                if (this.m_dimOfElements == -1) {
                    this.m_neighbour[n5 + n7].setSize(n3);
                }
                n2 = 0;
                while (n2 < n3) {
                    if (pgElementSet.m_neighbour[n7].m_data[n2] > -1) {
                        int n9 = n2;
                        this.m_neighbour[n5 + n7].m_data[n9] = this.m_neighbour[n5 + n7].m_data[n9] + n5;
                    }
                    ++n2;
                }
                ++n7;
            }
        }
        if (pgElementSet.m_elementNormal != null) {
            this.assureElementNormals();
            PdVector.copy(this.m_elementNormal, n5, pgElementSet.m_elementNormal, 0, pgElementSet.m_numElements);
        }
        if (pgElementSet.m_elementColor != null) {
            if (this.m_elementColor == null) {
                this.showElementColors(pgElementSet.isShowingElementColors());
                this.assureElementColors();
                n = this.getGlobalElementColor().getRGB();
                n7 = 0;
                while (n7 < n5) {
                    this.setElementColor(n7, new Color(n));
                    ++n7;
                }
            } else {
                this.assureElementColors();
            }
            PdColor.copy(this.m_elementColor, n5, pgElementSet.m_elementColor, 0, pgElementSet.m_numElements);
        } else if (this.m_elementColor != null) {
            n = pgElementSet.getGlobalElementColor().getRGB();
            n7 = n5;
            while (n7 < n6) {
                this.setElementColor(n7, new Color(n));
                ++n7;
            }
        }
        if (pgElementSet.m_elementBackColor != null) {
            if (this.m_elementBackColor == null) {
                this.showElementBackColors(pgElementSet.isShowingElementBackColors());
                this.assureElementBackColors();
                n = this.getGlobalElementBackColor().getRGB();
                n7 = 0;
                while (n7 < n5) {
                    this.setElementBackColor(n7, new Color(n));
                    ++n7;
                }
            } else {
                this.assureElementBackColors();
            }
            PdColor.copy(this.m_elementBackColor, n5, pgElementSet.m_elementBackColor, 0, pgElementSet.m_numElements);
        } else if (this.m_elementBackColor != null) {
            n = pgElementSet.getGlobalElementBackColor().getRGB();
            n7 = n5;
            while (n7 < n6) {
                this.setElementBackColor(n7, new Color(n));
                ++n7;
            }
        }
        if (pgElementSet.m_elementTexture != null) {
            this.assureElementTextures();
            n7 = 0;
            while (n7 < pgElementSet.m_numElements) {
                n3 = pgElementSet.m_element[n7].getSize();
                PdVector.copy(this.m_elementTexture[n5 + n7], 0, pgElementSet.m_elementTexture[n7], 0, n3);
                ++n7;
            }
        }
        if (pgElementSet.m_bndList != null) {
            PgBndPolygon[] pgBndPolygonArray = this.getBoundaries();
            this.m_bndList = new PgBndPolygon[pgBndPolygonArray.length + pgElementSet.m_bndList.length];
            n7 = 0;
            while (n7 < pgBndPolygonArray.length) {
                this.m_bndList[n7] = pgBndPolygonArray[n7];
                ++n7;
            }
            n7 = 0;
            while (n7 < pgElementSet.m_bndList.length) {
                this.m_bndList[pgBndPolygonArray.length + n7] = pgElementSet.m_bndList[n7];
                ++n7;
            }
            n7 = pgBndPolygonArray.length;
            while (n7 < this.m_bndList.length) {
                if (this.m_bndList[n7].m_vertexInd != null) {
                    n2 = 0;
                    while (n2 < this.m_bndList[n7].m_numVertices) {
                        int n10 = n2++;
                        this.m_bndList[n7].m_vertexInd.m_data[n10] = this.m_bndList[n7].m_vertexInd.m_data[n10] + n4;
                    }
                }
                if (this.m_bndList[n7].m_elementInd != null) {
                    n2 = 0;
                    while (n2 < this.m_bndList[n7].m_numVertices - 1) {
                        int n11 = n2++;
                        this.m_bndList[n7].m_elementInd.m_data[n11] = this.m_bndList[n7].m_elementInd.m_data[n11] + n5;
                    }
                }
                this.m_bndList[n7].m_triang = this;
                this.m_bndList[n7].assignVertices();
                ++n7;
            }
        }
        return true;
    }

    public void copyConnectivity(PgElementSet pgElementSet) {
        this.setDimOfElements(pgElementSet.getDimOfElements());
        this.setNumElements(pgElementSet.getNumElements());
        this.m_bConforming = pgElementSet.m_bConforming;
        PiVector.copy(this.m_element, 0, pgElementSet.getElements(), 0, this.m_numElements);
        PiVector[] piVectorArray = pgElementSet.getNeighbours();
        if (piVectorArray != null) {
            PiVector.copy(this.m_neighbour, 0, piVectorArray, 0, this.m_numElements);
        }
    }

    public void computeDisk(int n, int n2, double d) {
        if (this.m_dim < 2) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        super.computeDisk(n, n2, d);
        this.makeQuadrConn(n, n2);
        this.makeQuadrBnd(n, n2);
    }

    protected void setDimOfElement(int n, int n2) {
        if (this.m_dimOfElements == n2) {
            return;
        }
        if (n < 0 || this.m_numElements <= n) {
            PsDebug.warning("index out of range, ind = " + n);
            return;
        }
        if (n2 < 3) {
            PsDebug.warning("argument aSize=" + n2 + " out of range.");
            return;
        }
        if (this.m_numElements == 1) {
            this.setDimOfElements(n2);
        } else if (this.m_dimOfElements != -1) {
            this.setDimOfElements(-1);
        }
        this.m_element[n].setSize(n2);
        this.m_neighbour[n].setSize(n2);
        this.m_neighbour[n].setConstant(-1);
    }

    public void clearTagElement(int n, int n2) {
        if (n < 0 || n > this.m_numElements - 1) {
            PsDebug.warning("index=" + n + " out of range");
            return;
        }
        this.m_element[n].clearTag(n2);
    }

    public PiVector getElement(int n) {
        if (n < 0 || n >= this.m_numElements) {
            return null;
        }
        return this.m_element[n];
    }

    public void setElement(int n, int n2, int n3, int n4) {
        if (n < 0) {
            PsDebug.warning("index out of range, corrupt argument");
            return;
        }
        if (n >= this.m_numElements) {
            this.setNumElements(n + 1);
        }
        this.setDimOfElement(n, 3);
        this.m_element[n].set(n2, n3, n4);
    }

    public PiVector[] getNeighbours() {
        return this.m_neighbour;
    }

    protected void assureNeighbours() {
        int n;
        boolean bl = false;
        if (this.m_neighbour != null && this.m_neighbour.length == this.m_maxNumElements) {
            n = 0;
            while (n < this.m_maxNumElements) {
                if (this.m_neighbour[n].m_data == null || this.m_element[n].m_data == null || this.m_neighbour[n].m_data.length != this.m_element[n].m_data.length) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                return;
            }
        }
        if (this.m_dimOfElements != -1) {
            this.m_neighbour = PiVector.realloc(this.m_neighbour, this.m_maxNumElements, this.m_dimOfElements);
        } else {
            this.m_neighbour = PiVector.realloc(this.m_neighbour, this.m_maxNumElements);
            n = 0;
            while (n < this.m_maxNumElements) {
                this.m_neighbour[n].setSize(this.m_element[n].getSize());
                ++n;
            }
        }
        if (bl) {
            n = 0;
            while (n < this.m_maxNumElements) {
                this.m_neighbour[n].setConstant(-1);
                ++n;
            }
        }
    }

    public void setElement(int n, int n2, int n3, int n4, int n5) {
        if (n < 0) {
            PsDebug.warning("index out of range, corrupt argument");
            return;
        }
        if (n >= this.m_numElements) {
            this.setNumElements(n + 1);
        }
        this.setDimOfElement(n, 4);
        this.m_element[n].set(n2, n3, n4, n5);
    }

    public boolean setElement(int n, int[] nArray) {
        if (n >= this.m_numElements) {
            this.setNumElements(n + 1);
        }
        int n2 = nArray.length;
        this.setDimOfElement(n, n2);
        this.m_element[n].copy(nArray, n2);
        return true;
    }

    public boolean setElement(int n, PiVector piVector) {
        if (n < 0 || piVector == null) {
            PsDebug.warning("index out of range, corrupt argument");
            return false;
        }
        if (n >= this.m_numElements) {
            PsDebug.warning("index=" + n + " > " + this.m_numElements + "=m_numElements, bad programming style");
            this.setNumElements(n + 1);
        }
        this.setDimOfElement(n, piVector.getSize());
        this.m_element[n].copy(piVector);
        return true;
    }

    public void setNeighbours(PiVector[] piVectorArray) {
        if (piVectorArray == null) {
            this.m_neighbour = null;
            return;
        }
        if (piVectorArray.length < this.m_numElements) {
            PsDebug.warning("void length of neighbour array");
            return;
        }
        this.assureNeighbours();
        int n = 0;
        while (n < this.m_numElements) {
            this.m_neighbour[n].setSize(piVectorArray[n].getSize());
            ++n;
        }
        PiVector.copy(this.m_neighbour, 0, piVectorArray, 0, this.m_numElements);
    }

    public boolean isConforming() {
        return this.m_bConforming;
    }

    public PiVector[] getEdges() {
        return this.m_edge;
    }

    public void setEdges(PiVector[] piVectorArray) {
        if (piVectorArray == null || piVectorArray.length == 0 || piVectorArray.length < this.m_numEdges) {
            PsDebug.warning("void length of edge array");
            return;
        }
        PiVector.copy(this.m_edge, 0, piVectorArray, 0, this.m_numEdges);
    }

    public boolean isShowingEdges() {
        return this.m_bShowEdges;
    }

    public void showEdges(boolean bl) {
        this.m_bShowEdges = bl;
    }

    public int getNumElementIndices() {
        if (this.m_dimOfElements != -1) {
            return this.m_dimOfElements * this.m_numElements;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_numElements) {
            n += this.m_element[n2].getSize();
            ++n2;
        }
        return n;
    }

    public boolean removeUnusedVertices() {
        int n;
        int n2 = 1;
        int n3 = -1;
        PiVector piVector = new PiVector(this.m_numVertices);
        piVector.setConstant(n3);
        int[] nArray = piVector.m_data;
        int n4 = 0;
        while (n4 < this.m_numElements) {
            n = 0;
            while (n < this.m_element[n4].m_data.length) {
                nArray[this.m_element[n4].m_data[n]] = n2;
                ++n;
            }
            ++n4;
        }
        int n5 = 0;
        n4 = 0;
        while (n4 < this.m_numVertices) {
            if (nArray[n4] == n2) {
                nArray[n4] = n5++;
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < this.m_numVertices) {
            if (nArray[n4] != n3 && nArray[n4] < n4) {
                this.m_vertex[nArray[n4]] = this.m_vertex[n4];
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < this.m_numElements) {
            n = 0;
            while (n < this.m_element[n4].m_data.length) {
                this.m_element[n4].m_data[n] = nArray[this.m_element[n4].m_data[n]];
                ++n;
            }
            ++n4;
        }
        if (this.m_vertexNormal != null) {
            n4 = 0;
            while (n4 < this.m_numVertices) {
                if (nArray[n4] != n3 && nArray[n4] < n4) {
                    this.m_vertexNormal[nArray[n4]] = this.m_vertexNormal[n4];
                }
                ++n4;
            }
        }
        if (this.m_vertexColor != null) {
            n4 = 0;
            while (n4 < this.m_numVertices) {
                if (nArray[n4] != n3 && nArray[n4] < n4) {
                    this.m_vertexColor[nArray[n4]] = this.m_vertexColor[n4];
                }
                ++n4;
            }
        }
        if (this.m_vertexTexture != null) {
            n4 = 0;
            while (n4 < this.m_numVertices) {
                if (nArray[n4] != n3 && nArray[n4] < n4) {
                    this.m_vertexTexture[nArray[n4]] = this.m_vertexTexture[n4];
                }
                ++n4;
            }
        }
        int n6 = this.getNumVectorFields();
        n4 = 0;
        while (n4 < n6) {
            PgVectorField pgVectorField = this.getVectorField(n4);
            if (pgVectorField.getBasedOn() != 1) {
                n = 0;
                while (n < this.m_numVertices) {
                    if (nArray[n] != n3 && nArray[n] < n) {
                        pgVectorField.setVector(nArray[n], pgVectorField.getVector(n));
                    }
                    ++n;
                }
                pgVectorField.setNumVectors(n5);
            }
            ++n4;
        }
        if (this.m_bndList != null) {
            n4 = 0;
            while (n4 < this.m_bndList.length) {
                if (!this.m_bndList[n4].hasTag(2)) {
                    int n7 = this.m_bndList[n4].getNumVertices();
                    boolean bl = true;
                    n = 0;
                    while (n < n7) {
                        if (this.m_bndList[n4].m_vertexInd.m_data[n] == -1 || this.m_bndList[n4].m_vertexInd.m_data[n] >= this.m_numVertices) {
                            this.m_bndList[n4].setTag(2);
                            bl = false;
                            break;
                        }
                        ++n;
                    }
                    if (bl) {
                        n = 0;
                        while (n < n7) {
                            this.m_bndList[n4].m_vertexInd.m_data[n] = nArray[this.m_bndList[n4].m_vertexInd.m_data[n]];
                            ++n;
                        }
                        this.m_bndList[n4].assignVertices();
                    }
                }
                ++n4;
            }
        }
        this.setNumVertices(n5);
        this.setMaxNumVertices(n5);
        return true;
    }

    public int[] removeMarkedVertices() {
        int n = -1;
        int[] nArray = super.removeMarkedVertices();
        int n2 = 0;
        while (n2 < this.m_numElements) {
            int n3 = this.m_element[n2].getSize() - 1;
            while (n3 >= 0) {
                if (nArray[this.m_element[n2].m_data[n3]] == n) {
                    this.m_element[n2].setTag(2);
                    break;
                }
                this.m_element[n2].m_data[n3] = nArray[this.m_element[n2].m_data[n3]];
                --n3;
            }
            ++n2;
        }
        this.removeMarkedElements();
        return nArray;
    }

    public boolean update(Object object) {
        if (object == null) {
            return super.update(null);
        }
        if (object == this.m_globalBndColor) {
            return super.update(null);
        }
        if (object == this.m_globalBndTagColor) {
            return super.update(null);
        }
        if (object == this.m_globalBndSize) {
            return super.update(null);
        }
        if (object == this.m_globalEdgeColor) {
            return super.update(null);
        }
        if (object == this.m_globalEdgeTagColor) {
            return super.update(null);
        }
        if (object == this.m_globalEdgeSize) {
            return super.update(null);
        }
        if (object == this.m_globalElementColor) {
            return super.update(null);
        }
        if (object == this.m_globalElementBackColor) {
            return super.update(null);
        }
        if (object == this.m_globalElementTagColor) {
            return super.update(null);
        }
        if (object == this.m_globalElementNormalColor) {
            return super.update(null);
        }
        if (object == this.m_globalElementNormalLength) {
            return super.update(null);
        }
        if (object == this.m_globalElementNormalSize) {
            return super.update(null);
        }
        if (object == this.m_globalVertexNormalColor) {
            this.m_globalElementNormalColor.setColor(this.m_globalVertexNormalColor.getColor());
            return super.update(object);
        }
        if (object == this.m_globalVertexNormalLength) {
            this.m_globalElementNormalLength.copy(this.m_globalVertexNormalLength);
            return super.update(object);
        }
        if (object == this.m_globalVertexNormalSize) {
            this.m_globalElementNormalSize.copy(this.m_globalVertexNormalSize);
            return super.update(object);
        }
        return super.update(object);
    }

    public PdVector[] getElementVertices(int n) {
        if (n < 0 || this.m_numElements <= n) {
            PsDebug.warning("elemInd out of bounds, elemInd = " + n);
            return null;
        }
        if (this.m_element[n].getSize() == 0) {
            return null;
        }
        int n2 = this.m_element[n].getSize();
        PdVector[] pdVectorArray = new PdVector[n2];
        --n2;
        while (n2 >= 0) {
            pdVectorArray[n2] = this.m_vertex[this.m_element[n].m_data[n2]];
            --n2;
        }
        return pdVectorArray;
    }

    public boolean setElementVertices(int n, PdVector[] pdVectorArray) {
        PiVector piVector = this.m_element[n];
        int n2 = piVector.getSize();
        if (n2 != pdVectorArray.length) {
            PsDebug.warning("element and array have different length");
            return false;
        }
        --n2;
        while (n2 >= 0) {
            this.setVertex(piVector.m_data[n2], pdVectorArray[n2]);
            --n2;
        }
        return true;
    }

    public int getOppVertexLocInd(int n, int n2) {
        if (this.m_neighbour == null) {
            PsDebug.error("missing neighbour variable", this);
            return -1;
        }
        if (n == -1 || n2 == -1) {
            return -1;
        }
        int n3 = this.m_neighbour[n].m_data[n2];
        if (n3 == -1) {
            return -1;
        }
        int n4 = this.m_neighbour[n3].getSize() - 1;
        while (n4 >= 0) {
            if (this.m_neighbour[n3].m_data[n4] == n) {
                return n4;
            }
            --n4;
        }
        PsDebug.error("error in neighb. connectivity", this);
        return -1;
    }

    public double getL2Norm() {
        double d = 0.0;
        int n = 0;
        while (n < this.m_numElements) {
            PdVector[] pdVectorArray = this.getElementVertices(n);
            double d2 = 0.0;
            int n2 = this.m_element[n].getSize();
            int n3 = 1;
            while (n3 < n2 - 1) {
                d2 += pdVectorArray[0].sqrLength() + PdVector.dot(pdVectorArray[0], pdVectorArray[n3]);
                d2 += pdVectorArray[n3].sqrLength() + PdVector.dot(pdVectorArray[n3], pdVectorArray[n3 + 1]);
                double d3 = PdVector.area(pdVectorArray[0], pdVectorArray[n3], pdVectorArray[n3 + 1]);
                d += 2.0 * d3 * (d2 += pdVectorArray[n3 + 1].sqrLength() + PdVector.dot(pdVectorArray[n3 + 1], pdVectorArray[0])) / 12.0;
                ++n3;
            }
            ++n;
        }
        return d;
    }

    public boolean hasEdges() {
        return this.m_edge != null;
    }

    public boolean makeElementColorsFromXYZ() {
        if (this.m_numElements == 0) {
            return true;
        }
        this.assureElementColors();
        Color[] colorArray = this.getElementColors();
        PdVector[] pdVectorArray = this.getAmbientBounds();
        double[] dArray = PdVector.subNew((PdVector)pdVectorArray[1], (PdVector)pdVectorArray[0]).m_data;
        PdVector pdVector = new PdVector(this.m_dim);
        PdVector pdVector2 = new PdVector(this.m_dim);
        int n = 0;
        while (n < this.m_numElements) {
            pdVector.sub(PgGeometry.getCenterOfElement(pdVector2, this.m_vertex, this.m_element[n].m_data), pdVectorArray[0]);
            if (this.m_dim == 1) {
                colorArray[n] = new Color((float)(pdVector.m_data[0] / dArray[0]), 0.0f, 0.0f);
            } else if (this.m_dim == 2) {
                colorArray[n] = new Color((float)(pdVector.m_data[0] / dArray[0]), (float)(pdVector.m_data[1] / dArray[1]), 0.0f);
            } else if (this.m_dim >= 3) {
                colorArray[n] = new Color((float)(pdVector.m_data[0] / dArray[0]), (float)(pdVector.m_data[1] / dArray[1]), (float)(pdVector.m_data[2] / dArray[2]));
            }
            ++n;
        }
        return true;
    }

    public void removeBoundaries() {
        this.m_bndList = null;
    }

    public void fixBoundaries() {
        PgBndPolygon[] pgBndPolygonArray = this.getBoundaries();
        int n = 0;
        while (n < pgBndPolygonArray.length) {
            PgBndConstraint pgBndConstraint = new PgBndConstraint(this.getDimOfVertices());
            pgBndConstraint.setShape(3);
            pgBndPolygonArray[n].setBndConstraint(pgBndConstraint);
            ++n;
        }
    }

    public void makeCylinderConn(int n, int n2) {
        if (n < 1 || n2 < 1) {
            return;
        }
        if (this.m_dimOfElements == 3) {
            if (n2 > 2) {
                this.setNumElements(2 * (n - 1) * n2);
                int n3 = 0;
                int n4 = 0;
                while (n4 < n - 1) {
                    int n5 = 0;
                    while (n5 < n2 - 1) {
                        this.m_element[n3++].set(n4 * n2 + n5, (n4 + 1) * n2 + n5, n4 * n2 + n5 + 1);
                        this.m_element[n3++].set(n4 * n2 + n5 + 1, (n4 + 1) * n2 + n5, (n4 + 1) * n2 + n5 + 1);
                        ++n5;
                    }
                    this.m_element[n3++].set(n4 * n2 + n2 - 1, (n4 + 1) * n2 + n2 - 1, n4 * n2);
                    this.m_element[n3++].set(n4 * n2, (n4 + 1) * n2 + n2 - 1, (n4 + 1) * n2);
                    ++n4;
                }
            } else if (n2 == 2) {
                this.setNumElements(2 * (n - 1));
                int n6 = 0;
                int n7 = 0;
                while (n7 < n - 1) {
                    this.m_element[n6++].set(n7 * n2, (n7 + 1) * n2, n7 * n2 + 1);
                    this.m_element[n6++].set(n7 * n2 + 1, (n7 + 1) * n2, (n7 + 1) * n2 + 1);
                    ++n7;
                }
            }
        } else {
            this.setDimOfElements(4);
            if (n2 > 2) {
                this.setNumElements((n - 1) * n2);
                int n8 = 0;
                int n9 = 0;
                while (n9 < n - 1) {
                    int n10 = 0;
                    while (n10 < n2 - 1) {
                        this.m_element[n8++].set(n9 * n2 + n10, (n9 + 1) * n2 + n10, (n9 + 1) * n2 + n10 + 1, n9 * n2 + n10 + 1);
                        ++n10;
                    }
                    this.m_element[n8++].set(n9 * n2 + n2 - 1, (n9 + 1) * n2 + n2 - 1, (n9 + 1) * n2, n9 * n2);
                    ++n9;
                }
            } else if (n2 == 2) {
                this.setNumElements(n - 1);
                int n11 = 0;
                int n12 = 0;
                while (n12 < n - 1) {
                    this.m_element[n11++].set(n12 * n2, (n12 + 1) * n2, (n12 + 1) * n2 + 1, n12 * n2 + 1);
                    ++n12;
                }
            }
        }
        this.makeNeighbour();
    }

    public void makeQuadrBnd(int n, int n2) {
        int n3;
        int n4 = 4;
        this.assureBoundary(n4);
        int n5 = 0;
        while (n5 < n4) {
            this.m_bndList[n5].clearTag(2);
            ++n5;
        }
        this.m_bndList[0].setNumVertices(n);
        this.m_bndList[1].setNumVertices(n2);
        this.m_bndList[2].setNumVertices(n);
        this.m_bndList[3].setNumVertices(n2);
        n5 = 0;
        while (n5 < n) {
            this.m_bndList[0].m_vertexInd.m_data[n5] = n5 * n2;
            this.m_bndList[2].m_vertexInd.m_data[n5] = (n - n5) * n2 - 1;
            ++n5;
        }
        int n6 = 0;
        while (n6 < n2) {
            this.m_bndList[3].m_vertexInd.m_data[n6] = n2 - 1 - n6;
            this.m_bndList[1].m_vertexInd.m_data[n6] = (n - 1) * n2 + n6;
            ++n6;
        }
        if (this.m_dimOfElements == 3) {
            n3 = 0;
            n5 = 0;
            while (n5 < n - 1) {
                this.m_bndList[0].m_elementInd.m_data[n5] = n3;
                this.m_bndList[0].m_neighbourLocInd.m_data[n5] = 2;
                n3 += 2 * (n2 - 1);
                ++n5;
            }
            n3 = 2 * (n - 2) * (n2 - 1) + 1;
            n5 = 0;
            while (n5 < n2 - 1) {
                this.m_bndList[1].m_elementInd.m_data[n5] = n3;
                this.m_bndList[1].m_neighbourLocInd.m_data[n5] = 0;
                n3 += 2;
                ++n5;
            }
            n3 = 2 * (n - 1) * (n2 - 1) - 1;
            n5 = 0;
            while (n5 < n - 1) {
                this.m_bndList[2].m_elementInd.m_data[n5] = n3;
                this.m_bndList[2].m_neighbourLocInd.m_data[n5] = 1;
                n3 -= 2 * (n2 - 1);
                ++n5;
            }
            n3 = 2 * (n2 - 1) - 2;
            n5 = 0;
            while (n5 < n2 - 1) {
                this.m_bndList[3].m_elementInd.m_data[n5] = n3;
                this.m_bndList[3].m_neighbourLocInd.m_data[n5] = 1;
                n3 -= 2;
                ++n5;
            }
        } else {
            n3 = 0;
            n5 = 0;
            while (n5 < n - 1) {
                this.m_bndList[0].m_elementInd.m_data[n5] = n3;
                this.m_bndList[0].m_neighbourLocInd.m_data[n5] = 3;
                n3 += n2 - 1;
                ++n5;
            }
            n3 = (n - 2) * (n2 - 1);
            n5 = 0;
            while (n5 < n2 - 1) {
                this.m_bndList[1].m_elementInd.m_data[n5] = n3++;
                this.m_bndList[1].m_neighbourLocInd.m_data[n5] = 0;
                ++n5;
            }
            n3 = (n - 1) * (n2 - 1) - 1;
            n5 = 0;
            while (n5 < n - 1) {
                this.m_bndList[2].m_elementInd.m_data[n5] = n3;
                this.m_bndList[2].m_neighbourLocInd.m_data[n5] = 1;
                n3 -= n2 - 1;
                ++n5;
            }
            n3 = n2 - 1 - 1;
            n5 = 0;
            while (n5 < n2 - 1) {
                this.m_bndList[3].m_elementInd.m_data[n5] = n3--;
                this.m_bndList[3].m_neighbourLocInd.m_data[n5] = 2;
                ++n5;
            }
        }
        n5 = 0;
        while (n5 < n4) {
            this.m_bndList[n5].assignVertices();
            ++n5;
        }
    }

    public void makeTriangleConn(int n) {
        if (n < 1) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        this.setDimOfElements(3);
        this.setNumElements((n - 1) * (n - 1));
        int n4 = 0;
        while (n4 < n - 1) {
            int n5 = 0;
            while (n5 < n - 1 - n4) {
                this.m_element[n2++].set(n3 + n5, n3 + (n - n4) + n5, n3 + n5 + 1);
                if (n5 != n - 2 - n4) {
                    this.m_element[n2++].set(n3 + n5 + 1, n3 + (n - n4) + n5, n3 + (n - n4) + n5 + 1);
                }
                ++n5;
            }
            n3 += n - n4;
            ++n4;
        }
        this.makeNeighbour();
    }

    public void makePatchConn(int n) {
        PsDebug.error("missing method.", this);
    }

    public boolean hasEdgeColors() {
        return this.m_edgeColor != null && this.m_edgeColor.length == this.m_numEdges;
    }

    public Color[] getElementBackColors() {
        return this.m_elementBackColor;
    }

    public boolean hasBoundary() {
        return this.m_bndList != null && this.m_bndList.length != 0;
    }

    public boolean isShowingElementBackColors() {
        return this.m_bShowElementBackColors;
    }

    public void showElementBackColors(boolean bl) {
        this.m_bShowElementBackColors = bl;
    }

    public boolean hasElementColors() {
        return this.m_elementColor != null && this.m_elementColor.length == this.m_maxNumElements;
    }

    public void assureElementBackColors() {
        if (this.m_elementBackColor == null || this.m_elementBackColor.length != this.m_maxNumElements) {
            this.m_elementBackColor = PdColor.realloc(this.m_elementBackColor, this.m_maxNumElements);
        }
    }

    public void setElementBackColors(Color[] colorArray) {
        if (colorArray == null) {
            this.m_elementBackColor = null;
            return;
        }
        if (colorArray.length < this.m_numElements) {
            PsDebug.warning("void length of color array");
            return;
        }
        if (this.m_elementBackColor == null || this.m_numElements > this.m_elementBackColor.length) {
            this.assureElementBackColors();
        }
        PdColor.copy(this.m_elementBackColor, 0, colorArray, 0, this.m_numElements);
    }

    public boolean checkNeighbour() {
        if (this.m_neighbour == null) {
            PsDebug.warning("missing neighbour information");
            return false;
        }
        int n = -1;
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = 0;
        while (n2 < this.m_numElements) {
            int n3 = this.m_element[n2].getSize();
            if (n3 != this.m_neighbour[n2].getSize()) {
                bl = false;
                stringBuffer.append("neighbour array has different length than element array\n");
                stringBuffer.append("\t element = " + n2 + " has length = " + n3 + "\n");
                stringBuffer.append("\t neighbour has length = " + this.m_neighbour[n2].getSize() + "\n");
            }
            int n4 = 0;
            while (n4 < n3) {
                int n5 = this.m_neighbour[n2].m_data[n4];
                if (n5 != -1) {
                    int n6;
                    if (n5 == n2) {
                        bl = false;
                        stringBuffer.append("element has itself as neighbour\n");
                        stringBuffer.append("\t element = " + n2 + " at vertex = " + this.m_element[n2].m_data[n4] + "\n");
                        n6 = 0;
                        while (n6 < n3) {
                            stringBuffer.append("\t element[" + n2 + "][" + n6 + "] = " + this.m_element[n2].m_data[n6] + ", neighbour[" + n2 + "][" + n6 + "] = " + this.m_neighbour[n2].m_data[n6] + "\n");
                            ++n6;
                        }
                    } else if (n5 >= this.m_numElements) {
                        bl = false;
                        stringBuffer.append("neighbour references non-existing element\n");
                        stringBuffer.append("\t element = " + n2 + " at vertex = " + this.m_element[n2].m_data[n4] + " >= m_numElements.\n");
                        n6 = 0;
                        while (n6 < n3) {
                            stringBuffer.append("\t element[" + n2 + "][" + n6 + "] = " + this.m_element[n2].m_data[n6] + ", neighbour[" + n2 + "][" + n6 + "] = " + this.m_neighbour[n2].m_data[n6] + "\n");
                            ++n6;
                        }
                    } else {
                        int n7 = this.m_neighbour[n5].getSize();
                        boolean bl2 = false;
                        int n8 = 0;
                        while (n8 < n7) {
                            if (this.m_neighbour[n5].m_data[n8] == n2) {
                                bl2 = true;
                                n = n8;
                                break;
                            }
                            ++n8;
                        }
                        if (!(bl2 && (this.m_element[n2].m_data[(n4 + 1) % n3] == this.m_element[n5].m_data[(n8 + 2) % n7] && this.m_element[n2].m_data[(n4 + 2) % n3] == this.m_element[n5].m_data[(n8 + 1) % n7] || this.m_element[n2].m_data[(n4 + 1) % n3] == this.m_element[n5].m_data[(n8 + 1) % n7] && this.m_element[n2].m_data[(n4 + 2) % n3] == this.m_element[n5].m_data[(n8 + 2) % n7]))) {
                            bl = false;
                            if (!bl2) {
                                stringBuffer.append("two adjacent triangles do not reference\n");
                            } else {
                                stringBuffer.append("two adjacent triangles reference but have no common edge\n");
                            }
                            stringBuffer.append("\t element = " + n2 + " at vertex = " + this.m_element[n2].m_data[n4] + "\n");
                            n6 = 0;
                            while (n6 < n3) {
                                stringBuffer.append("\t element[" + n2 + "][" + n6 + "] = " + this.m_element[n2].m_data[n6] + ", neighbour[" + n2 + "][" + n6 + "] = " + this.m_neighbour[n2].m_data[n6] + "\n");
                                ++n6;
                            }
                            if (bl2) {
                                stringBuffer.append("\t element = " + n5 + " at vertex = " + this.m_element[n5].m_data[n] + "\n");
                            } else {
                                stringBuffer.append("\t element = " + n5 + " does not reference back\n");
                            }
                            n6 = 0;
                            while (n6 < n7) {
                                stringBuffer.append("\t element[" + n5 + "][" + n6 + "] = " + this.m_element[n5].m_data[n6] + ", neighbour[" + n5 + "][" + n6 + "] = " + this.m_neighbour[n5].m_data[n6] + "\n");
                                ++n6;
                            }
                        }
                    }
                }
                ++n4;
            }
            ++n2;
        }
        if (!bl) {
            PsDebug.message(stringBuffer.toString());
        } else {
            PsDebug.message("neighbour is correct");
        }
        return bl;
    }

    public PiVector[] getSavedElements() {
        return this.m_elementSaved;
    }

    public void setSavedElements(PiVector[] piVectorArray) {
        if (piVectorArray == null) {
            this.m_elementSaved = null;
            return;
        }
        if (this.m_elementSaved == null) {
            this.m_elementSaved = PiVector.copyNew(piVectorArray, this.m_numElements);
            return;
        }
        this.m_elementSaved = PiVector.realloc(this.m_elementSaved, piVectorArray.length);
        PiVector.copy(this.m_elementSaved, 0, piVectorArray, 0, piVectorArray.length);
    }

    public boolean makeElementColorsFromZ() {
        if (this.m_dim == 0) {
            return false;
        }
        if (this.m_numElements == 0) {
            return true;
        }
        int n = Math.min(2, this.m_dim - 1);
        this.assureElementColors();
        Color[] colorArray = this.getElementColors();
        PdVector[] pdVectorArray = this.getAmbientBounds();
        float f = (float)(pdVectorArray[1].m_data[n] - pdVectorArray[0].m_data[n]);
        PdVector pdVector = new PdVector(this.m_dim);
        PdVector pdVector2 = new PdVector(this.m_dim);
        int n2 = 0;
        while (n2 < this.m_numElements) {
            pdVector.sub(PgGeometry.getCenterOfElement(pdVector2, this.m_vertex, this.m_element[n2].m_data), pdVectorArray[0]);
            float f2 = (float)pdVector.m_data[n] / f;
            colorArray[n2] = new Color(1.0f - f2, 0.0f, f2);
            ++n2;
        }
        return true;
    }

    public boolean close() {
        int n;
        if (this.m_bndList == null || this.m_bndList.length == 0) {
            return false;
        }
        if (this.m_numVertices < 2) {
            PsDebug.warning("less than 2 vertices in " + this.getName());
            return false;
        }
        double d = 0.01;
        boolean bl = true;
        int n2 = this.m_bndList.length;
        double[] dArray = new double[n2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            if (!this.m_bndList[n4].hasTag(2)) {
                ++n3;
                dArray[n4] = this.m_bndList[n4].getLength();
                if (dArray[n4] > 1.0) {
                    dArray[n4] = 1.0;
                }
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < n2) {
            if (!this.m_bndList[n4].hasTag(2)) {
                n = n4 + 1;
                while (n < n2) {
                    int n5;
                    if (!this.m_bndList[n].hasTag(2) && (n5 = this.m_bndList[n4].bndcmp(this.m_bndList[n], Math.min(dArray[n4], dArray[n]) * d)) != 0) {
                        this.m_bndList[n4].bnd_id(this.m_bndList[n], n5);
                        this.m_bndList[n4].setTag(2);
                        this.m_bndList[n].setTag(2);
                    }
                    ++n;
                }
            }
            ++n4;
        }
        if (bl) {
            n4 = 0;
            while (n4 < n2) {
                if (!this.m_bndList[n4].hasTag(2) && this.m_bndList[n4].bndtst(d) == 1) {
                    this.m_bndList[n4].bnd_shrink();
                    this.m_bndList[n4].setTag(2);
                }
                ++n4;
            }
        }
        n4 = 0;
        while (n4 < n2) {
            if (this.m_bndList[n4] != null && !this.m_bndList[n4].hasTag(2)) {
                this.m_bndList[n4].assignVertices();
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < n2) {
            if (!this.m_bndList[n4].hasTag(2)) {
                n = 0;
                while (n < n4) {
                    int n6;
                    if (!this.m_bndList[n].hasTag(2) && (n6 = this.m_bndList[n4].bnd_cmp_paste(this.m_bndList[n], Math.min(dArray[n4], dArray[n]) * d)) != 0 && this.m_bndList[n4].bnd_paste(this.m_bndList[n], n6)) {
                        this.m_bndList[n].setTag(2);
                    }
                    ++n;
                }
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < n2) {
            if (this.m_bndList[n4] != null && !this.m_bndList[n4].hasTag(2)) {
                this.m_bndList[n4].assignVertices();
            }
            ++n4;
        }
        int n7 = n2;
        n4 = 0;
        while (n4 < n2) {
            if (this.m_bndList[n4] != null && this.m_bndList[n4].hasTag(2)) {
                --n7;
            }
            ++n4;
        }
        if (n7 < n2) {
            PgBndPolygon[] pgBndPolygonArray = new PgBndPolygon[n7];
            int n8 = 0;
            n4 = 0;
            while (n4 < n2) {
                if (this.m_bndList[n4] != null && !this.m_bndList[n4].hasTag(2)) {
                    pgBndPolygonArray[n8++] = this.m_bndList[n4];
                }
                ++n4;
            }
            this.m_bndList = pgBndPolygonArray;
        }
        if (n7 != n3) {
            // empty if block
        }
        this.removeUnusedVertices();
        return true;
    }

    public void computeRotation(PgPolygon pgPolygon, int n) {
        if (this.m_dim < 3) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        super.computeRotation(pgPolygon, n);
        int n2 = pgPolygon.getNumVertices();
        this.makeQuadrConn(n, n2);
        this.makeQuadrBnd(n, n2);
    }

    public boolean makeElementColorsFromZHue() {
        if (this.m_dim == 0) {
            return false;
        }
        if (this.m_numElements == 0) {
            return true;
        }
        int n = Math.min(2, this.m_dim - 1);
        this.assureElementColors();
        Color[] colorArray = this.getElementColors();
        PdVector[] pdVectorArray = this.getAmbientBounds();
        float f = (float)(pdVectorArray[1].m_data[n] - pdVectorArray[0].m_data[n]);
        PdVector pdVector = new PdVector(this.m_dim);
        PdVector pdVector2 = new PdVector(this.m_dim);
        int n2 = 0;
        while (n2 < this.m_numElements) {
            pdVector.sub(PgGeometry.getCenterOfElement(pdVector2, this.m_vertex, this.m_element[n2].m_data), pdVectorArray[0]);
            float f2 = (float)pdVector.m_data[n] / f;
            colorArray[n2] = new Color(Color.HSBtoRGB(1.0f - f2, 1.0f, 1.0f));
            ++n2;
        }
        return true;
    }

    public boolean hasElementBackColors() {
        return this.m_elementBackColor != null && this.m_elementBackColor.length == this.m_maxNumElements;
    }

    public boolean blend(double d, PgGeometry pgGeometry, double d2, PgGeometry pgGeometry2) {
        if (!super.blend(d, pgGeometry, d2, pgGeometry2)) {
            return false;
        }
        if (!(pgGeometry instanceof PgElementSet)) {
            return false;
        }
        PgElementSet pgElementSet = (PgElementSet)pgGeometry;
        PgElementSet pgElementSet2 = (PgElementSet)pgGeometry2;
        if (pgElementSet.m_numElements != pgElementSet2.m_numElements) {
            PsDebug.warning("unequal number of elements");
            return false;
        }
        this.setNumElements(pgElementSet.m_numElements);
        int n = 0;
        while (n < this.m_numElements) {
            this.m_element[n].copy(pgElementSet.m_element[n]);
            if (pgElementSet.m_neighbour != null) {
                this.m_neighbour[n].copy(pgElementSet.m_neighbour[n]);
            }
            ++n;
        }
        if (pgElementSet.m_elementNormal != null && pgElementSet2.m_elementNormal != null) {
            this.m_elementNormal = PdVector.realloc(this.m_elementNormal, this.m_numElements, this.m_dim);
            n = 0;
            while (n < this.m_numElements) {
                this.m_elementNormal[n].blend(d, pgElementSet.m_elementNormal[n], d2, pgElementSet2.m_elementNormal[n]);
                this.m_elementNormal[n].normalize();
                ++n;
            }
        }
        if (pgElementSet.m_elementColor != null && pgElementSet2.m_elementColor != null) {
            this.m_elementColor = PdColor.realloc(this.m_elementColor, this.m_numElements);
            n = 0;
            while (n < this.m_numElements) {
                this.m_elementColor[n] = PdColor.blend(d, pgElementSet.m_elementColor[n], d2, pgElementSet2.m_elementColor[n]);
                ++n;
            }
        }
        if (pgElementSet.m_elementBackColor != null && pgElementSet2.m_elementBackColor != null) {
            this.m_elementBackColor = PdColor.realloc(this.m_elementBackColor, this.m_numElements);
            n = 0;
            while (n < this.m_numElements) {
                this.m_elementBackColor[n] = PdColor.blend(d, pgElementSet.m_elementBackColor[n], d2, pgElementSet2.m_elementBackColor[n]);
                ++n;
            }
        }
        if (pgElementSet.hasBoundary() && pgElementSet2.hasBoundary()) {
            this.assureBoundary(pgElementSet.m_bndList.length);
            n = 0;
            while (n < this.m_bndList.length) {
                this.m_bndList[n].blend(d, pgElementSet.m_bndList[n], d2, pgElementSet2.m_bndList[n]);
                ++n;
            }
        }
        this.m_bConforming = pgElementSet.m_bConforming;
        return true;
    }

    public void makeQuadrVertexTexture(int n, int n2) {
        if (n < 2 || n2 < 2) {
            return;
        }
        this.assureVertexTextures();
        double d = 1.0 / (-1.0 + (double)n);
        double d2 = 1.0 / (-1.0 + (double)n2);
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            double d3 = d * (double)n4;
            int n5 = 0;
            while (n5 < n2) {
                double d4 = d2 * (double)n5;
                this.m_vertexTexture[n3].m_data[0] = d3;
                this.m_vertexTexture[n3].m_data[1] = d4;
                ++n3;
                ++n5;
            }
            ++n4;
        }
    }

    public void makeQuadrElementTexture(int n, int n2) {
        if (n < 2 || n2 < 2) {
            return;
        }
        this.assureElementTextures();
        double d = 1.0 / (-1.0 + (double)n);
        double d2 = 1.0 / (-1.0 + (double)n2);
        if (this.m_dimOfElements == 3) {
            int n3 = 0;
            int n4 = 0;
            while (n4 < n - 1) {
                int n5 = 0;
                while (n5 < n2 - 1) {
                    this.m_elementTexture[n3][0].m_data[0] = (double)n4 * d;
                    this.m_elementTexture[n3][0].m_data[1] = (double)n5 * d2;
                    this.m_elementTexture[n3][1].m_data[0] = (double)(n4 + 1) * d;
                    this.m_elementTexture[n3][1].m_data[1] = (double)n5 * d2;
                    this.m_elementTexture[n3][2].m_data[0] = (double)n4 * d;
                    this.m_elementTexture[n3][2].m_data[1] = (double)(n5 + 1) * d2;
                    this.m_elementTexture[++n3][0].m_data[0] = (double)n4 * d;
                    this.m_elementTexture[n3][0].m_data[1] = (double)(n5 + 1) * d2;
                    this.m_elementTexture[n3][1].m_data[0] = (double)(n4 + 1) * d;
                    this.m_elementTexture[n3][1].m_data[1] = (double)n5 * d2;
                    this.m_elementTexture[n3][2].m_data[0] = (double)(n4 + 1) * d;
                    this.m_elementTexture[n3][2].m_data[1] = (double)(n5 + 1) * d2;
                    ++n3;
                    ++n5;
                }
                ++n4;
            }
            return;
        }
        this.setDimOfElements(4);
        this.setNumElements((n - 1) * (n2 - 1));
        int n6 = 0;
        int n7 = 0;
        while (n7 < n - 1) {
            int n8 = 0;
            while (n8 < n2 - 1) {
                this.m_elementTexture[n6][0].m_data[0] = (double)n7 * d;
                this.m_elementTexture[n6][0].m_data[1] = (double)n8 * d2;
                this.m_elementTexture[n6][1].m_data[0] = (double)(n7 + 1) * d;
                this.m_elementTexture[n6][1].m_data[1] = (double)n8 * d2;
                this.m_elementTexture[n6][2].m_data[0] = (double)(n7 + 1) * d;
                this.m_elementTexture[n6][2].m_data[1] = (double)(n8 + 1) * d2;
                this.m_elementTexture[n6][3].m_data[0] = (double)n7 * d;
                this.m_elementTexture[n6][3].m_data[1] = (double)(n8 + 1) * d2;
                ++n6;
                ++n8;
            }
            ++n7;
        }
    }

    public void buildQuadrFromCurve(PgPolygon[] pgPolygonArray, PgBndConstraint[] pgBndConstraintArray) {
        if (pgPolygonArray == null || pgBndConstraintArray == null) {
            PsDebug.warning("missing argument", this);
            return;
        }
        if (pgPolygonArray.length != 4 || pgBndConstraintArray.length != 4) {
            PsDebug.warning("wrong argument array list", this);
            return;
        }
        int n = pgPolygonArray[0].getNumVertices();
        int n2 = pgPolygonArray[1].getNumVertices();
        int n3 = 0;
        int n4 = 0;
        int n5 = (1 + (n - 1) * (n3 + 1)) * (1 + (n2 - 1) * (n4 + 1));
        int n6 = 4 + 2 * n3 + 2 * n4 - 2;
        int n7 = (n - 1) * (n2 - 1) * n6;
        this.setNumVertices(n5);
        this.setNumElements(n7);
        int n8 = 0;
        int n9 = 0;
        while (n9 < n) {
            double d = (double)n9 / ((double)n - 1.0);
            PdVector pdVector = pgPolygonArray[0].m_vertex[n9];
            PdVector pdVector2 = pgPolygonArray[2].m_vertex[n - 1 - n9];
            int n10 = 0;
            while (n10 < n2) {
                double d2 = (double)n10 / ((double)n2 - 1.0);
                PdVector pdVector3 = pgPolygonArray[1].m_vertex[n10];
                PdVector pdVector4 = pgPolygonArray[3].m_vertex[n2 - 1 - n10];
                int n11 = 0;
                while (n11 < this.m_dim) {
                    double d3 = pdVector.m_data[n11] + d2 * (pdVector2.m_data[n11] - pdVector.m_data[n11]);
                    double d4 = pdVector4.m_data[n11] + d * (pdVector3.m_data[n11] - pdVector4.m_data[n11]);
                    this.m_vertex[n8].m_data[n11] = n9 == 0 || n9 == n - 1 ? d4 : (n10 == 0 || n10 == n2 - 1 ? d3 : (d3 + d4) / 2.0);
                    ++n11;
                }
                ++n8;
                ++n10;
            }
            ++n9;
        }
        this.makeQuadrConn(n, n2);
        this.makeQuadrBnd(n, n2);
        n9 = 0;
        while (n9 < pgBndConstraintArray.length) {
            this.m_bndList[n9].m_bndConstraint = pgBndConstraintArray[n9];
            ++n9;
        }
    }

    public void buildPolygonFromCurve(PgPolygon[] pgPolygonArray) {
        PsDebug.error("empty method", this);
    }

    public double getGlobalElementNormalSize() {
        return this.m_globalElementNormalSize.getValue();
    }

    public void setGlobalElementNormalSize(double d) {
        this.m_globalElementNormalSize.setValue(d);
    }

    public double getGlobalEdgeSize() {
        return this.m_globalEdgeSize.getValue();
    }

    public void setGlobalEdgeSize(double d) {
        this.m_globalEdgeSize.setValue(d);
    }

    public double getVertexAngle(int n, int n2) {
        int n3 = this.m_element[n].getSize();
        PdVector pdVector = this.m_vertex[this.m_element[n].m_data[n2]];
        PdVector pdVector2 = this.m_vertex[this.m_element[n].m_data[(n2 + 1) % n3]];
        PdVector pdVector3 = this.m_vertex[this.m_element[n].m_data[(n2 - 1 + n3) % n3]];
        return PdVector.angle(pdVector, pdVector2, pdVector3);
    }

    public PdMatrix getL2Matrix(PdMatrix pdMatrix) {
        int n;
        Object[] objectArray;
        double d;
        if (this.m_dimOfElements != 3) {
            PsDebug.warning("elements must be triangular.");
            return null;
        }
        if (pdMatrix == null) {
            pdMatrix = new PdMatrix(this.m_numVertices);
        } else if (pdMatrix.getSize() != this.m_numVertices) {
            pdMatrix.setSize(this.m_numVertices);
        }
        int n2 = 0;
        while (n2 < this.m_numElements) {
            d = this.getAreaOfElement(n2) / 12.0;
            objectArray = this.m_element[n2].m_data;
            n = 0;
            do {
                double[] dArray = pdMatrix.m_data[objectArray[n]];
                double d2 = objectArray[n];
                dArray[d2] = dArray[d2] + (d + d);
                double[] dArray2 = pdMatrix.m_data[objectArray[n]];
                double d3 = objectArray[(n + 1) % 3];
                dArray2[d3] = dArray2[d3] + d;
                double[] dArray3 = pdMatrix.m_data[objectArray[(n + 1) % 3]];
                double d4 = objectArray[n];
                dArray3[d4] = dArray3[d4] + d;
            } while (++n < 3);
            ++n2;
        }
        d = 0.0;
        objectArray = new double[3];
        n2 = 0;
        while (n2 < this.m_numVertices) {
            int n3 = 0;
            do {
                objectArray[n3] = 0.0;
            } while (++n3 < 3);
            n = 0;
            while (n < this.m_numVertices) {
                n3 = 0;
                do {
                    int n4 = n3;
                    objectArray[n4] = objectArray[n4] + pdMatrix.m_data[n2][n] * this.m_vertex[n].m_data[n3];
                } while (++n3 < 3);
                ++n;
            }
            n3 = 0;
            do {
                d += this.m_vertex[n2].m_data[n3] * objectArray[n3];
            } while (++n3 < 3);
            ++n2;
        }
        if (Math.abs(d - this.getL2Norm()) > 1.0E-10) {
            PsDebug.warning("different L2-norms:\n\t getL2Norm()   = " + this.getL2Norm() + "\n\t getL2Matrix() = " + d);
        }
        return pdMatrix;
    }
}

