/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import java.awt.CheckboxMenuItem;
import java.awt.Image;
import java.util.Enumeration;
import jv.geom.PgPointSet;
import jv.geom.PgTexture;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.objectGui.PsMethodMenu;
import jv.project.PgGeometry_Menu;
import jv.project.PvDisplayIf;
import jv.vecmath.PdVector;

public class PgPointSet_Menu
extends PgGeometry_Menu {
    public static final int MTHD_PRINT_CENTER = 0;
    public static final int MTHD_PRINT_BNDBOX = 1;
    public static final int MTHD_REMOVE_VECTOR_FIELDS = 2;
    public static final int MTHD_MOVE_TO_ORIGIN = 3;
    public static final int MTHD_PROJECT_TO_SPHERE = 4;
    public static final int MTHD_FLIP_ORIENTATION = 5;
    public static final int MTHD_SHOW_VECTOR_ARROWS = 6;
    public static final int MTHD_MARK_VERTICES = 7;
    public static final int MTHD_UNMARK_VERTICES = 8;
    public static final int MTHD_REMOVE_MARKED_VERTICES = 9;
    public static final int MTHD_SHOW_MARKED_VERTICES = 10;
    public static final int MTHD_SHOW_TITLE = 11;
    public static final int MTHD_SHOW_VERTEX_LABELS = 12;
    public static final int MTHD_ENABLE_DEFAULT_LABEL = 13;
    public static final int MTHD_SHOW_GLOBAL_VERTEX_COLOR = 14;
    public static final int MTHD_VERTEX_COLOR_FROM_VECTOR = 15;
    public static final int MTHD_VERTEX_COLOR_FROM_XYZ = 16;
    public static final int MTHD_VERTEX_COLOR_FROM_Z = 17;
    public static final int MTHD_VERTEX_COLOR_FROM_Z_HUE = 18;
    public static final int MTHD_SHOW_VERTEX_NORMAL_ARROW = 19;
    public static final int MTHD_MAKE_VERTEX_TEXTURE_XY = 20;
    public static final int MTHD_MAKE_VERTEX_TEXTURE_XZ = 21;
    public static final int MTHD_MAKE_VERTEX_TEXTURE_YZ = 22;
    public static final int MTHD_MAKE_VERTEX_TEXTURE_CYL = 23;
    public static final int MTHD_MAKE_VERTEX_TEXTURE_SPH = 24;
    public static final int MTHD_ADD_TEXTURE = 25;
    public static final int MTHD_REMOVE_TEXTURE = 26;
    public static final int MTHD_INCREMENT_DIMENSION = 27;
    public static final int MTHD_DECREMENT_DIMENSION = 28;
    public static final int MTHD_SHOW_VERTEX_TEXTURE = 29;
    public static final int MTHD_MARK_ALL_VERTICES = 30;
    public static final int MTHD_UNMARK_ALL_VERTICES = 31;
    public static final int MTHD_REMOVE_VERTEX_NORMALS = 32;
    public static final String[] m_pointSetMethod = new String[]{PsConfig.getMessage("PrintCenter"), PsConfig.getMessage("PrintBndBox"), PsConfig.getMessage("RemoveAllVectorFields"), PsConfig.getMessage("MoveToOrigin"), PsConfig.getMessage("ProjectToSphere1"), PsConfig.getMessage("FlipOrientation"), PsConfig.getMessage("ShowVectorArrows"), PsConfig.getMessage("MarkVertices"), PsConfig.getMessage("UnmarkVertices"), PsConfig.getMessage("RemoveMarkedVertices"), PsConfig.getMessage("ShowMarkedVertices"), PsConfig.getMessage("ShowTitle"), PsConfig.getMessage("ShowVertexLabels"), PsConfig.getMessage("EnableDefaultLabel"), PsConfig.getMessage("ShowGlobalVertexColor"), PsConfig.getMessage("MakeVertexColorFromVector"), PsConfig.getMessage("MakeVertexColorFromXYZ"), PsConfig.getMessage("MakeVertexColorFromZ"), PsConfig.getMessage("MakeVertexColorFromZHue"), PsConfig.getMessage("ShowVertexNormalArrow"), PsConfig.getMessage("MakeVertexTextureFromXY"), PsConfig.getMessage("MakeVertexTextureFromXZ"), PsConfig.getMessage("MakeVertexTextureFromYZ"), PsConfig.getMessage("MakeVertexTextureFromCylinder"), PsConfig.getMessage("MakeVertexTextureFromSphere"), PsConfig.getMessage("AddTexture"), PsConfig.getMessage("RemoveTexture"), PsConfig.getMessage("IncrementDimension"), PsConfig.getMessage("DecrementDimension"), PsConfig.getMessage("ShowVertexTexture"), PsConfig.getMessage("MarkAllVertices"), PsConfig.getMessage("UnmarkAllVertices"), PsConfig.getMessage("RemoveVertexNormals")};
    protected PgPointSet m_pointSet;

    public boolean applyMethod(String string) {
        if (super.applyMethod(string)) {
            return true;
        }
        int n = PsMethodMenu.getIndexOfMethod(m_pointSetMethod, string);
        switch (n) {
            case 0: {
                PsDebug.message("PgPointSet = " + this.m_pointSet.getName() + "\n\tCenter: ");
                PdVector pdVector = this.m_pointSet.getCenter();
                if (pdVector == null) {
                    PsDebug.message("\t missing center");
                    return true;
                }
                PsDebug.message(pdVector.toShortString());
                return true;
            }
            case 1: {
                PsDebug.message("PgPointSet = " + this.m_pointSet.getName() + "\n\tBounding Box: ");
                PdVector[] pdVectorArray = this.m_pointSet.getBounds();
                if (pdVectorArray == null) {
                    PsDebug.message("\t missing bounding box");
                    return true;
                }
                PsDebug.message(pdVectorArray[0].toShortString());
                PsDebug.message(pdVectorArray[1].toShortString());
                return true;
            }
            case 11: {
                this.m_pointSet.showTitle(!this.m_pointSet.isShowingTitle());
                break;
            }
            case 13: {
                this.m_pointSet.setDefaultLabelEnabled(!this.m_pointSet.isDefaultLabelEnabled());
                break;
            }
            case 12: {
                this.m_pointSet.showVertexLabels(!this.m_pointSet.isShowingVertexLabels());
                break;
            }
            case 10: {
                this.m_pointSet.showTaggedVertices(!this.m_pointSet.isShowingTaggedVertices());
                break;
            }
            case 19: {
                this.m_pointSet.showVertexNormalArrow(!this.m_pointSet.isShowingVertexNormalArrow());
                return true;
            }
            case 6: {
                this.m_pointSet.showVectorArrows(!this.m_pointSet.isShowingVectorArrows());
                return true;
            }
            case 29: {
                this.m_pointSet.showVertexTexture(!this.m_pointSet.isShowingVertexTexture());
                return true;
            }
            case 7: {
                Enumeration enumeration = this.m_pointSet.getDisplays();
                while (enumeration != null && enumeration.hasMoreElements()) {
                    PvDisplayIf pvDisplayIf = (PvDisplayIf)enumeration.nextElement();
                    pvDisplayIf.setMajorMode(9);
                }
                break;
            }
            case 30: {
                int n2 = this.m_pointSet.getNumVertices();
                int n3 = 0;
                while (n3 < n2) {
                    this.m_pointSet.getVertex(n3).setTag(1);
                    ++n3;
                }
                break;
            }
            case 8: {
                Enumeration enumeration = this.m_pointSet.getDisplays();
                while (enumeration != null && enumeration.hasMoreElements()) {
                    PvDisplayIf pvDisplayIf = (PvDisplayIf)enumeration.nextElement();
                    pvDisplayIf.setMajorMode(11);
                }
                break;
            }
            case 31: {
                int n4 = this.m_pointSet.getNumVertices();
                int n5 = 0;
                while (n5 < n4) {
                    this.m_pointSet.getVertex(n5).clearTag(1);
                    ++n5;
                }
                break;
            }
            case 9: {
                PdVector[] pdVectorArray = this.m_pointSet.getVertices();
                int n6 = this.m_pointSet.getNumVertices() - 1;
                while (n6 >= 0) {
                    if (pdVectorArray[n6].hasTag(1)) {
                        pdVectorArray[n6].setTag(2);
                    }
                    --n6;
                }
                this.m_pointSet.removeMarkedVertices();
                break;
            }
            case 32: {
                this.m_pointSet.showVertexNormals(false);
                this.m_pointSet.setVertexNormals(null);
                break;
            }
            case 2: {
                this.m_pointSet.removeAllVectorFields();
                break;
            }
            case 26: {
                if (this.m_pointSet.getTexture() == null) {
                    return true;
                }
                this.m_pointSet.setTexture(null);
                this.m_pointSet.setVertexTextures(null);
                this.m_pointSet.showVertexTexture(false);
                return true;
            }
            case 14: {
                this.m_pointSet.showVertexColors(!this.m_pointSet.isShowingVertexColors());
                break;
            }
            case 16: {
                this.m_pointSet.makeVertexColorsFromXYZ();
                this.m_pointSet.showVertexColors(true);
                this.m_pointSet.showVertices(true);
                CheckboxMenuItem checkboxMenuItem = (CheckboxMenuItem)this.getMenuItem(PsConfig.getMessage("Color"), m_pointSetMethod[14]);
                if (checkboxMenuItem == null) break;
                checkboxMenuItem.setState(false);
                break;
            }
            case 17: {
                this.m_pointSet.makeVertexColorsFromZ();
                this.m_pointSet.showVertexColors(true);
                this.m_pointSet.showVertices(true);
                CheckboxMenuItem checkboxMenuItem = (CheckboxMenuItem)this.getMenuItem(PsConfig.getMessage("Color"), m_pointSetMethod[14]);
                if (checkboxMenuItem == null) break;
                checkboxMenuItem.setState(false);
                break;
            }
            case 18: {
                this.m_pointSet.makeVertexColorsFromZHue();
                this.m_pointSet.showVertexColors(true);
                this.m_pointSet.showVertices(true);
                CheckboxMenuItem checkboxMenuItem = (CheckboxMenuItem)this.getMenuItem(PsConfig.getMessage("Color"), m_pointSetMethod[14]);
                if (checkboxMenuItem == null) break;
                checkboxMenuItem.setState(false);
                break;
            }
            case 15: {
                boolean bl = this.m_pointSet.makeColorFromVectorLength();
                if (!bl) break;
                this.m_pointSet.showVertices(true);
                this.m_pointSet.showVertexColors(bl);
                break;
            }
            case 20: {
                this.assureTexture();
                this.m_pointSet.makeVertexTextureFromBndBox(0, 1);
                this.m_pointSet.showVertexTexture(true);
                return true;
            }
            case 21: {
                this.assureTexture();
                this.m_pointSet.makeVertexTextureFromBndBox(0, 2);
                this.m_pointSet.showVertexTexture(true);
                return true;
            }
            case 22: {
                this.assureTexture();
                this.m_pointSet.makeVertexTextureFromBndBox(1, 2);
                this.m_pointSet.showVertexTexture(true);
                return true;
            }
            case 23: {
                this.assureTexture();
                PdVector pdVector = new PdVector(this.m_pointSet.getDimOfVertices());
                pdVector.setEntry(this.m_pointSet.getDimOfVertices() - 1, 1.0);
                this.m_pointSet.makeVertexTextureFromCylinder(this.m_pointSet.getCenterOfBndBox(), pdVector);
                this.m_pointSet.showVertexTexture(true);
                return true;
            }
            case 24: {
                this.assureTexture();
                this.m_pointSet.makeVertexTextureFromSphere(this.m_pointSet.getCenterOfBndBox());
                this.m_pointSet.showVertexTexture(true);
                return true;
            }
            case 27: {
                this.m_pointSet.setDimOfVertices(this.m_pointSet.getDimOfVertices() + 1);
                break;
            }
            case 28: {
                this.m_pointSet.setDimOfVertices(this.m_pointSet.getDimOfVertices() - 1);
                break;
            }
            case 3: {
                PdVector pdVector = new PdVector(this.m_pointSet.getDimOfVertices());
                this.m_pointSet.setCenterOfBndBox(pdVector);
                break;
            }
            case 4: {
                this.m_pointSet.projectToSphere(this.m_pointSet.getCenter(), 1.0);
                break;
            }
            case 5: {
                this.m_pointSet.flipOrientation();
                break;
            }
            case -1: {
                return false;
            }
            default: {
                PsDebug.warning("method string = " + string + " does not match a constant");
                return false;
            }
        }
        return true;
    }

    public boolean update(Object object) {
        CheckboxMenuItem checkboxMenuItem;
        if (object == null || object != this.m_pointSet) {
            return false;
        }
        String string = PsConfig.getMessage("Show");
        if (this.hasMenu(string)) {
            checkboxMenuItem = (CheckboxMenuItem)this.getMenuItem(string, m_pointSetMethod[11]);
            if (checkboxMenuItem != null && checkboxMenuItem.getState() != this.m_pointSet.isShowingTitle()) {
                checkboxMenuItem.setState(this.m_pointSet.isShowingTitle());
            }
            if ((checkboxMenuItem = (CheckboxMenuItem)this.getMenuItem(string, m_pointSetMethod[13])) != null && checkboxMenuItem.getState() != this.m_pointSet.isDefaultLabelEnabled()) {
                checkboxMenuItem.setState(this.m_pointSet.isDefaultLabelEnabled());
            }
            if ((checkboxMenuItem = (CheckboxMenuItem)this.getMenuItem(string, m_pointSetMethod[12])) != null && checkboxMenuItem.getState() != this.m_pointSet.isShowingVertexLabels()) {
                checkboxMenuItem.setState(this.m_pointSet.isShowingVertexLabels());
            }
            if ((checkboxMenuItem = (CheckboxMenuItem)this.getMenuItem(string, m_pointSetMethod[10])) != null && checkboxMenuItem.getState() != this.m_pointSet.isShowingTaggedVertices()) {
                checkboxMenuItem.setState(this.m_pointSet.isShowingTaggedVertices());
            }
            if ((checkboxMenuItem = (CheckboxMenuItem)this.getMenuItem(string, m_pointSetMethod[19])) != null && checkboxMenuItem.getState() != this.m_pointSet.isShowingVertexNormalArrow()) {
                checkboxMenuItem.setState(this.m_pointSet.isShowingVertexNormalArrow());
            }
            if ((checkboxMenuItem = (CheckboxMenuItem)this.getMenuItem(string, m_pointSetMethod[6])) != null && checkboxMenuItem.getState() != this.m_pointSet.isShowingVectorArrow()) {
                checkboxMenuItem.setState(this.m_pointSet.isShowingVectorArrow());
            }
            if ((checkboxMenuItem = (CheckboxMenuItem)this.getMenuItem(string, m_pointSetMethod[29])) != null && checkboxMenuItem.getState() != this.m_pointSet.isShowingVertexTexture()) {
                checkboxMenuItem.setState(this.m_pointSet.isShowingVertexTexture());
            }
        }
        if (this.hasMenu(PsConfig.getMessage("Color")) && (checkboxMenuItem = (CheckboxMenuItem)this.getMenuItem(PsConfig.getMessage("Color"), m_pointSetMethod[14])) != null) {
            if (checkboxMenuItem.isEnabled() != this.m_pointSet.hasVertexColors()) {
                checkboxMenuItem.setEnabled(this.m_pointSet.hasVertexColors());
            }
            if (checkboxMenuItem.getState() != !this.m_pointSet.isShowingVertexColors()) {
                checkboxMenuItem.setState(!this.m_pointSet.isShowingVertexColors());
            }
        }
        return super.update(object);
    }

    public void init(PsObject psObject) {
        super.init(psObject);
        this.m_pointSet = (PgPointSet)psObject;
        String string = PsConfig.getMessage("Info");
        this.addMenu(string);
        this.addMenuItem(string, m_pointSetMethod[0]);
        this.addMenuItem(string, m_pointSetMethod[1]);
        String string2 = PsConfig.getMessage("Show");
        this.addMenu(string2);
        this.addMenuItem(string2, m_pointSetMethod[11], this.m_pointSet.isShowingTitle());
        this.addMenuItem(string2, m_pointSetMethod[13], this.m_pointSet.isDefaultLabelEnabled());
        this.getMenu(string2).addSeparator();
        this.addMenuItem(string2, m_pointSetMethod[12], this.m_pointSet.isShowingVertexLabels());
        this.addMenuItem(string2, m_pointSetMethod[10], this.m_pointSet.isShowingTaggedVertices());
        this.addMenuItem(string2, m_pointSetMethod[19], this.m_pointSet.isShowingVertexNormalArrow());
        this.getMenu(string2).addSeparator();
        this.addMenuItem(string2, m_pointSetMethod[6], this.m_pointSet.isShowingVectorArrow());
        String string3 = PsConfig.getMessage("Mark");
        this.addMenu(string3);
        this.addMenuItem(string3, m_pointSetMethod[7]);
        this.addMenuItem(string3, m_pointSetMethod[30]);
        this.addMenuItem(string3, m_pointSetMethod[8]);
        this.addMenuItem(string3, m_pointSetMethod[31]);
        String string4 = PsConfig.getMessage("Delete");
        this.addMenu(string4);
        this.addMenuItem(string4, m_pointSetMethod[9]);
        this.addMenuItem(string4, m_pointSetMethod[32]);
        this.addMenuItem(string4, m_pointSetMethod[2]);
        this.addMenuItem(string4, m_pointSetMethod[26]);
        String string5 = PsConfig.getMessage("Color");
        this.addMenu(string5);
        CheckboxMenuItem checkboxMenuItem = this.addMenuItem(string5, m_pointSetMethod[14], !this.m_pointSet.isShowingVertexColors());
        if (!this.m_pointSet.hasVertexColors()) {
            checkboxMenuItem.setEnabled(false);
        }
        this.getMenu(string5).addSeparator();
        this.addMenuItem(string5, m_pointSetMethod[16]);
        this.addMenuItem(string5, m_pointSetMethod[17]);
        this.addMenuItem(string5, m_pointSetMethod[18]);
        this.addMenuItem(string5, m_pointSetMethod[15]);
        String string6 = PsConfig.getMessage("Texture");
        this.addMenu(string6);
        this.addMenuItem(string6, m_pointSetMethod[20]);
        this.addMenuItem(string6, m_pointSetMethod[21]);
        this.addMenuItem(string6, m_pointSetMethod[22]);
        this.addMenuItem(string6, m_pointSetMethod[23]);
        this.addMenuItem(string6, m_pointSetMethod[24]);
        String string7 = PsConfig.getMessage("Modeling");
        this.addMenu(string7);
        this.addMenuItem(string7, m_pointSetMethod[27]);
        this.addMenuItem(string7, m_pointSetMethod[28]);
        this.addMenuItem(string7, m_pointSetMethod[3]);
        this.addMenuItem(string7, m_pointSetMethod[4]);
        this.addMenuItem(string7, m_pointSetMethod[5]);
    }

    private boolean assureTexture() {
        if (this.m_pointSet.getTexture() != null) {
            return true;
        }
        PgTexture pgTexture = new PgTexture();
        pgTexture.setImageName(PsConfig.getCodeBase() + "images/JavaViewLogo.gif");
        Image image = pgTexture.loadImage(null);
        if (image == null) {
            return false;
        }
        this.m_pointSet.setTexture(pgTexture);
        return true;
    }
}

