/*
 * Decompiled with CFR 0.152.
 */
package jv.object;

import java.io.Serializable;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.object.PsUtil;

public abstract class PsObject
implements PsUpdateIf,
Cloneable,
Serializable {
    private static int m_numObjects = 0;
    protected String m_name;
    protected transient PsUpdateIf m_parent;
    protected transient Vector m_updateList;
    protected transient Hashtable m_panelList;
    protected transient PsPanel m_infoPanel;
    protected BitSet m_tag;
    public static final int NUM_TAGS = 32;
    public static final int IS_USED = 0;
    public static final int IS_SELECTED = 1;
    public static final int IS_DELETED = 2;
    public static final int IS_FIXED = 3;
    public static final int HAS_INFO_PANEL = 4;
    public static final int HAS_MATERIAL_PANEL = 5;
    public static final int HAS_TEXTURE_PANEL = 6;
    public static final int HAS_CONFIG_PANEL = 7;
    public static final String INSPECTOR_INFO_EXT = "_IP";
    public static final String INSPECTOR_INFO = "Info";

    public boolean hasUpdateListener(PsUpdateIf psUpdateIf) {
        if (this.m_updateList == null) {
            return false;
        }
        return this.m_updateList.contains(psUpdateIf);
    }

    public boolean removeUpdateListener(PsUpdateIf psUpdateIf) {
        if (this.m_updateList == null) {
            return false;
        }
        return this.m_updateList.removeElement(psUpdateIf);
    }

    public PsPanel getInfoPanel() {
        return this.assureInspector(INSPECTOR_INFO, INSPECTOR_INFO_EXT);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("PsObject.toString(): " + super.toString() + "\n");
        stringBuffer.append("\t ******* jv.object.PsObject *************\n");
        stringBuffer.append("\t Name = " + this.m_name + "  Version = " + PsConfig.getVersion() + " by " + PsConfig.getAuthors() + "\n");
        stringBuffer.append("\t m_tag = " + this.m_tag + "\n");
        return stringBuffer.toString();
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        this.m_parent = psUpdateIf;
    }

    public PsObject() {
        ++m_numObjects;
        this.m_tag = null;
        this.m_parent = null;
        this.m_updateList = null;
        this.m_panelList = null;
        this.m_infoPanel = null;
    }

    public void clearTag(int n) {
        if (this.m_tag == null) {
            return;
        }
        this.m_tag.clear(n);
    }

    public void setTag(int n) {
        if (this.m_tag == null) {
            this.m_tag = new BitSet(32);
        }
        this.m_tag.set(n);
    }

    public PsUpdateIf getFather() {
        return this.m_parent;
    }

    public boolean addUpdateListener(PsUpdateIf psUpdateIf) {
        if (this.m_updateList == null) {
            this.m_updateList = new Vector();
        } else if (this.hasUpdateListener(psUpdateIf)) {
            PsDebug.warning("name = " + psUpdateIf.getName() + " of listener already used.");
            return false;
        }
        this.m_updateList.addElement(psUpdateIf);
        return true;
    }

    public boolean update(Object object) {
        if (object == this || object != null && this.m_panelList != null && this.m_panelList.contains(object)) {
            this.updatePanels(object);
        } else if (object != null) {
            String string = "could not handle event:\n\tthis     = " + this.getClass().getName() + ", name " + this.getName() + "\n\tevent    = " + object.getClass().getName();
            if (object instanceof PsUpdateIf) {
                string = string + ", name=" + ((PsUpdateIf)object).getName();
            }
            string = string + "\n\tmissing implementation of update(Object)";
            PsDebug.warning(string);
            return false;
        }
        if (this.m_updateList != null) {
            Enumeration enumeration = this.m_updateList.elements();
            while (enumeration.hasMoreElements()) {
                PsUpdateIf psUpdateIf = (PsUpdateIf)enumeration.nextElement();
                psUpdateIf.update(this);
            }
        }
        if (this.m_parent != null) {
            return this.m_parent.update(this);
        }
        return true;
    }

    public PsPanel getInspector(String string) {
        if (this.m_panelList == null) {
            return null;
        }
        return (PsPanel)this.m_panelList.get(string);
    }

    public PsPanel assureInspector(String string, String string2) {
        PsPanel psPanel;
        if (this.hasInspector(string)) {
            psPanel = this.getInspector(string);
            if (psPanel.getLanguage().equals(PsConfig.getLanguage())) {
                return psPanel;
            }
            this.removeInspector(string);
        }
        if ((psPanel = (PsPanel)PsUtil.newInstance(this.getClass(), string2)) == null) {
            return null;
        }
        this.addInspector(string, psPanel);
        return psPanel;
    }

    public boolean updatePanels(Object object) {
        if (this.m_panelList == null) {
            return true;
        }
        if (object == null) {
            PsDebug.warning("unknown event==null");
            object = this;
        }
        if (object == this || this.m_panelList.contains(object)) {
            Enumeration enumeration = this.m_panelList.elements();
            while (enumeration.hasMoreElements()) {
                PsPanel psPanel = (PsPanel)enumeration.nextElement();
                if (psPanel == object) continue;
                if (psPanel.isShowing()) {
                    psPanel.update(this);
                    continue;
                }
                psPanel.setOutOfDate(true);
            }
        } else {
            String string = "could not handle event:\n\tthis     = " + this.getClass().getName() + ", name " + this.getName() + "\n\tevent    = " + object.getClass().getName();
            if (object instanceof PsUpdateIf) {
                string = string + ", name=" + ((PsUpdateIf)object).getName();
            }
            string = string + "\n\tmissing implementation of updatePanel(Object)";
            PsDebug.warning(string);
            return false;
        }
        return true;
    }

    public boolean hasTag(int n) {
        if (this.m_tag == null) {
            return false;
        }
        return this.m_tag.get(n);
    }

    public void copy(PsObject psObject) {
        if (this.m_name == null || this.m_name.equals(psObject.getName())) {
            String string;
            this.m_name = string = psObject.getName();
        }
        if (psObject.m_tag != null) {
            this.m_tag = (BitSet)psObject.m_tag.clone();
        }
    }

    public boolean hasInspector(String string) {
        if (this.m_panelList == null) {
            return false;
        }
        return this.m_panelList.containsKey(string);
    }

    public boolean removeInspector(String string) {
        if (!this.hasInspector(string)) {
            return false;
        }
        this.m_panelList.remove(string);
        if (INSPECTOR_INFO.equals(string)) {
            this.m_infoPanel = null;
        }
        return true;
    }

    public static int getNumObjects() {
        return m_numObjects;
    }

    public String getName() {
        if (this.m_name == null) {
            return "";
        }
        return this.m_name;
    }

    public void setName(String string) {
        if (string == null) {
            PsDebug.warning("missing name");
            return;
        }
        this.m_name = string;
    }

    public final boolean instanceOf(String string) {
        String string2 = this.getClass().getName();
        return string2.endsWith(string);
    }

    public static boolean instanceOf(Object object, Class clazz) {
        Object object2;
        if (object == null || clazz == null) {
            return false;
        }
        Class<?> clazz2 = object.getClass();
        if (clazz2.equals(clazz)) {
            return true;
        }
        if (!clazz.isInterface()) {
            object2 = clazz.getInterfaces();
            int n = 0;
            while (n < ((Class<?>[])object2).length) {
                if (PsObject.instanceOf(object, object2[n])) {
                    return true;
                }
                ++n;
            }
        }
        return (object2 = clazz.getSuperclass()) != null && PsObject.instanceOf(object, object2);
    }

    public void init() {
        if (this.m_name == null) {
            this.m_name = "object_" + m_numObjects;
        }
    }

    public static PsObject[][] clone(PsObject[][] psObjectArray) {
        PsObject[][] psObjectArray2 = (PsObject[][])psObjectArray.clone();
        if (psObjectArray2 == null) {
            return null;
        }
        int n = 0;
        while (n < psObjectArray.length) {
            psObjectArray2[n] = PsObject.clone(psObjectArray[n]);
            ++n;
        }
        return psObjectArray2;
    }

    public static PsObject[] clone(PsObject[] psObjectArray) {
        PsObject[] psObjectArray2 = (PsObject[])psObjectArray.clone();
        if (psObjectArray2 == null) {
            return null;
        }
        int n = 0;
        while (n < psObjectArray.length) {
            psObjectArray2[n] = (PsObject)psObjectArray[n].clone();
            ++n;
        }
        return psObjectArray2;
    }

    public Object clone() {
        String string;
        PsObject psObject = null;
        try {
            psObject = (PsObject)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return null;
        }
        if (this.m_tag != null) {
            psObject.m_tag = (BitSet)this.m_tag.clone();
        }
        psObject.m_parent = null;
        psObject.m_updateList = null;
        psObject.m_panelList = null;
        psObject.m_infoPanel = null;
        psObject.m_name = string = this.getName();
        return psObject;
    }

    public boolean addInspector(String string, PsPanel psPanel) {
        if (this.m_panelList == null) {
            this.m_panelList = new Hashtable();
        } else if (this.hasInspector(string)) {
            PsDebug.warning("name = " + string + " of panel already used.");
            return false;
        }
        psPanel.setParent(this);
        psPanel.update(this);
        this.m_panelList.put(string, psPanel);
        if (INSPECTOR_INFO.equals(string)) {
            this.m_infoPanel = psPanel;
        }
        return true;
    }
}

