/*
 * Decompiled with CFR 0.152.
 */
package jv.rsrc;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class JarResources {
    public boolean debugOn = false;
    private Hashtable htSizes = new Hashtable();
    private Hashtable htJarContents = new Hashtable();
    private boolean isApplication = true;
    private String jarFileName;

    public byte[] getResource(String string) {
        return (byte[])this.htJarContents.get(string);
    }

    public JarResources(String string) {
        this.jarFileName = string;
        this.init();
    }

    public JarResources(String string, boolean bl) {
        this.jarFileName = string;
        this.isApplication = bl;
        this.init();
    }

    public static void main(String[] stringArray) throws IOException {
        JarResources jarResources;
        byte[] byArray;
        if (stringArray.length != 2) {
            System.err.println("usage: java JarResources <jar file name> <resource name>");
            System.exit(1);
        }
        if ((byArray = (jarResources = new JarResources(stringArray[0])).getResource(stringArray[1])) == null) {
            System.out.println("Could not find " + stringArray[1] + ".");
            return;
        }
        System.out.println("Found " + stringArray[1] + " (length=" + byArray.length + ").");
    }

    private String dumpZipEntry(ZipEntry zipEntry) {
        StringBuffer stringBuffer = new StringBuffer();
        if (zipEntry.isDirectory()) {
            stringBuffer.append("d ");
        } else {
            stringBuffer.append("f ");
        }
        if (zipEntry.getMethod() == 0) {
            stringBuffer.append("stored   ");
        } else {
            stringBuffer.append("defalted ");
        }
        stringBuffer.append(zipEntry.getName());
        stringBuffer.append("\t");
        stringBuffer.append("" + zipEntry.getSize());
        if (zipEntry.getMethod() == 8) {
            stringBuffer.append("/" + zipEntry.getCompressedSize());
        }
        return stringBuffer.toString();
    }

    private void init() {
        try {
            BufferedInputStream bufferedInputStream;
            Object object;
            if (this.isApplication) {
                object = new FileInputStream(this.jarFileName);
                bufferedInputStream = new BufferedInputStream((InputStream)object);
            } else {
                object = new URL(this.jarFileName);
                bufferedInputStream = new BufferedInputStream(((URL)object).openStream());
            }
            object = new ZipInputStream(bufferedInputStream);
            ZipEntry zipEntry = null;
            int n = ((FilterInputStream)object).available();
            if (this.debugOn) {
                System.out.println("available " + n);
            }
            if (n < 0) {
                return;
            }
            int n2 = 10000;
            int n3 = Math.min(n, n2);
            byte[] byArray = new byte[n3];
            while ((zipEntry = ((ZipInputStream)object).getNextEntry()) != null) {
                if (zipEntry.isDirectory()) continue;
                if (this.debugOn) {
                    System.out.println("ze.getName()=" + zipEntry.getName() + "," + "getSize()=" + zipEntry.getSize());
                }
                int n4 = 0;
                int n5 = 0;
                while (n - n4 > 0) {
                    n5 = ((ZipInputStream)object).read(byArray, n4, n3 - n4);
                    if (n5 == -1) break;
                    if ((n4 += n5) != n3) continue;
                    byte[] byArray2 = byArray;
                    byArray = new byte[n3 + n2];
                    System.arraycopy(byArray2, 0, byArray, 0, n3);
                    n3 += n2;
                }
                int n6 = n4;
                byte[] byArray3 = new byte[n6];
                System.arraycopy(byArray, 0, byArray3, 0, n6);
                this.htJarContents.put(zipEntry.getName(), byArray3);
                if (!this.debugOn) continue;
                System.out.println(zipEntry.getName() + "  rb=" + n4 + ",size=" + n6 + ",csize=" + zipEntry.getCompressedSize());
            }
            return;
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("done.");
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return;
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
    }
}

