/*
 * Decompiled with CFR 0.152.
 */
package jv.rsrc;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jv.object.PsDebug;

public class PsXmlNode
implements Serializable {
    protected String m_type;
    protected Hashtable m_attribute;
    protected String m_content;
    protected Vector m_mixedContent;
    protected PsXmlNode m_father;
    protected PsXmlNode m_sibling;
    protected PsXmlNode m_child;
    private PsXmlNode m_lastChild;
    private boolean m_isExpanded;
    protected boolean m_bMixedMode;

    public PsXmlNode getChild(String string) {
        Object object;
        PsXmlNode psXmlNode = this.m_child;
        while (psXmlNode != null) {
            object = psXmlNode.getType();
            if (object != null && ((String)object).equals(string)) {
                return psXmlNode;
            }
            psXmlNode = psXmlNode.getSibling();
        }
        psXmlNode = this.m_child;
        while (psXmlNode != null) {
            object = psXmlNode.getChild(string);
            if (object != null) {
                return object;
            }
            psXmlNode = psXmlNode.getSibling();
        }
        return null;
    }

    public PsXmlNode getChild() {
        return this.m_child;
    }

    public void setChild(PsXmlNode psXmlNode) {
        if (psXmlNode != null) {
            psXmlNode.setFather(this);
        }
        this.m_child = psXmlNode;
        this.m_lastChild = psXmlNode;
    }

    public Enumeration getMixedContent() {
        if (this.m_mixedContent == null) {
            return null;
        }
        return this.m_mixedContent.elements();
    }

    public String getContent() {
        return this.m_content;
    }

    public void setContent(String string) {
        this.m_content = string;
    }

    public String appendContent(String string) {
        this.m_content = this.m_content == null ? string : this.m_content.concat(string);
        return this.m_content;
    }

    public int getNumChildren() {
        int n = 0;
        PsXmlNode psXmlNode = this.m_child;
        while (psXmlNode != null) {
            ++n;
            psXmlNode = psXmlNode.getSibling();
        }
        return n;
    }

    public boolean isExpanded() {
        return this.m_isExpanded;
    }

    public PsXmlNode getSibling() {
        return this.m_sibling;
    }

    public void setSibling(PsXmlNode psXmlNode) {
        if (psXmlNode == null) {
            this.m_sibling = null;
            return;
        }
        this.m_sibling = psXmlNode;
        psXmlNode.setFather(this.m_father);
    }

    public PsXmlNode getFather() {
        return this.m_father;
    }

    public void setFather(PsXmlNode psXmlNode) {
        this.m_father = psXmlNode;
    }

    public void addMixedContent(Object object) {
        if (this.m_mixedContent == null) {
            this.m_mixedContent = new Vector();
        }
        this.m_mixedContent.addElement(object);
    }

    public PsXmlNode[] getChildren() {
        int n = this.getNumChildren();
        if (n == 0) {
            return null;
        }
        PsXmlNode[] psXmlNodeArray = new PsXmlNode[n];
        PsXmlNode psXmlNode = this.m_child;
        int n2 = 0;
        while (n2 < n) {
            psXmlNodeArray[n2] = psXmlNode;
            psXmlNode = psXmlNode.getSibling();
            ++n2;
        }
        return psXmlNodeArray;
    }

    public PsXmlNode[] getChildren(String string) {
        Vector<PsXmlNode> vector = null;
        PsXmlNode psXmlNode = this.m_child;
        while (psXmlNode != null) {
            if (psXmlNode.getType().equals(string)) {
                if (vector == null) {
                    vector = new Vector<PsXmlNode>();
                }
                vector.addElement(psXmlNode);
            }
            psXmlNode = psXmlNode.getSibling();
        }
        if (vector != null) {
            Object[] objectArray = new PsXmlNode[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    public void addAttribute(String string, String string2) {
        if (string2 == null || string2.equals("")) {
            return;
        }
        if (this.m_attribute == null) {
            this.m_attribute = new Hashtable();
        }
        this.m_attribute.put(string, string2);
    }

    public PsXmlNode addChild(String string, String string2) {
        PsXmlNode psXmlNode = this.addChild(string);
        if (psXmlNode == null) {
            return null;
        }
        psXmlNode.setContent(string2);
        return psXmlNode;
    }

    public PsXmlNode addChild(String string, boolean bl) {
        return this.addChild(string, String.valueOf(bl));
    }

    public PsXmlNode addChild(String string, double d) {
        return this.addChild(string, String.valueOf(d));
    }

    public PsXmlNode addChild(String string, float f) {
        return this.addChild(string, String.valueOf(f));
    }

    public PsXmlNode addChild(String string, int n) {
        return this.addChild(string, String.valueOf(n));
    }

    public PsXmlNode addChild(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        return this.addChild(new PsXmlNode(string));
    }

    public PsXmlNode addChild(PsXmlNode psXmlNode) {
        if (psXmlNode == null) {
            PsDebug.warning("missing child argument");
            return null;
        }
        psXmlNode.setFather(this);
        if (this.m_child == null) {
            this.m_child = psXmlNode;
            this.m_lastChild = psXmlNode;
        } else {
            this.m_lastChild.m_sibling = psXmlNode;
            this.m_lastChild = psXmlNode;
        }
        return psXmlNode;
    }

    public String getType() {
        return this.m_type;
    }

    public void setType(String string) {
        this.m_type = string;
    }

    public String getAttribute(String string) {
        if (this.m_attribute == null) {
            return null;
        }
        return (String)this.m_attribute.get(string);
    }

    public PsXmlNode(String string) {
        this.m_type = string;
        this.m_isExpanded = true;
        this.m_bMixedMode = false;
    }

    public void setMixedMode(boolean bl) {
        this.m_bMixedMode = bl;
    }

    public void expand(boolean bl) {
        this.m_isExpanded = bl;
    }

    public boolean hasContent() {
        return this.m_content != null;
    }

    public void removeAttribute(String string) {
        if (this.m_attribute == null) {
            return;
        }
        this.m_attribute.remove(string);
    }

    public boolean hasChild(String string) {
        PsXmlNode psXmlNode = this.m_child;
        while (psXmlNode != null) {
            String string2 = psXmlNode.getType();
            if (string2 != null && string2.equals(string)) {
                return true;
            }
            psXmlNode = psXmlNode.getSibling();
        }
        return false;
    }

    public Hashtable getAttributes() {
        return this.m_attribute;
    }

    public boolean isMixedMode() {
        return this.m_bMixedMode;
    }

    public static StringBuffer writeNode(StringBuffer stringBuffer, PsXmlNode psXmlNode, String string) {
        String string2;
        Object object;
        Object object2;
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer("");
        }
        if (psXmlNode == null) {
            return stringBuffer;
        }
        stringBuffer.append(string + "<" + psXmlNode.getType());
        Hashtable hashtable = psXmlNode.getAttributes();
        if (hashtable != null) {
            object2 = hashtable.keys();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                string2 = psXmlNode.getAttribute((String)object);
                stringBuffer.append(" " + (String)object + "=\"" + string2 + "\"");
            }
        }
        if (!psXmlNode.isMixedMode()) {
            object2 = psXmlNode.getContent();
            object = psXmlNode.getChild();
            if ((object2 == null || ((String)object2).equals("")) && object == null) {
                stringBuffer.append("/>\n");
            } else {
                stringBuffer.append(">");
                boolean bl = true;
                int n = -1;
                if (object2 != null) {
                    n = ((String)object2).indexOf(10);
                }
                if (object2 != null && n > -1 || object != null) {
                    bl = false;
                    stringBuffer.append("\n");
                }
                if (object2 != null) {
                    int n2 = 0;
                    String string3 = string + "\t";
                    if (n != -1) {
                        do {
                            stringBuffer.append(string3 + ((String)object2).substring(n2, n + 1));
                            n2 = n + 1;
                        } while ((n = ((String)object2).indexOf(10, n + 1)) != -1);
                        if (n2 < ((String)object2).length()) {
                            stringBuffer.append(string3 + ((String)object2).substring(n2, ((String)object2).length()) + "\n");
                        }
                    } else {
                        if (!bl) {
                            stringBuffer.append(string3);
                        }
                        stringBuffer.append((String)object2);
                        if (!bl) {
                            stringBuffer.append("\n");
                        }
                    }
                }
                if (object != null) {
                    stringBuffer = PsXmlNode.writeNode(stringBuffer, (PsXmlNode)object, string + "\t");
                    PsXmlNode psXmlNode2 = ((PsXmlNode)object).getSibling();
                    while (psXmlNode2 != null) {
                        stringBuffer = PsXmlNode.writeNode(stringBuffer, psXmlNode2, string + "\t");
                        psXmlNode2 = psXmlNode2.getSibling();
                    }
                }
                if (!bl) {
                    stringBuffer.append(string);
                }
                stringBuffer.append("</" + psXmlNode.getType() + ">\n");
            }
        } else {
            object2 = psXmlNode.getMixedContent();
            if (object2 == null || !object2.hasMoreElements()) {
                stringBuffer.append("/>\n");
            } else {
                stringBuffer.append(">");
                boolean bl = true;
                string2 = "";
                while (object2.hasMoreElements()) {
                    Object object3;
                    Object e = object2.nextElement();
                    if (e instanceof String) {
                        object3 = (String)e;
                        int n = -1;
                        if (object3 != null) {
                            n = ((String)object3).indexOf(10);
                        }
                        if (object3 != null && n > -1 || psXmlNode.getChild() != null) {
                            bl = false;
                        }
                        if (object3 == null) continue;
                        int n3 = 0;
                        String string4 = string + string2;
                        if (n != -1) {
                            do {
                                stringBuffer.append(string4 + ((String)object3).substring(n3, n + 1));
                                n3 = n + 1;
                            } while ((n = ((String)object3).indexOf(10, n + 1)) != -1);
                            if (n3 >= ((String)object3).length()) continue;
                            stringBuffer.append(string4 + ((String)object3).substring(n3, ((String)object3).length()) + "\n");
                            continue;
                        }
                        if (((String)object3).length() == 1 && (((String)object3).equals(".") || ((String)object3).equals(",") || ((String)object3).equals("?") || ((String)object3).equals("!") || ((String)object3).equals(";") || ((String)object3).equals(":"))) {
                            if (stringBuffer.charAt(stringBuffer.length() - 1) == '\n') {
                                stringBuffer.setLength(stringBuffer.length() - 1);
                            }
                            stringBuffer.append((String)object3 + "\n");
                            continue;
                        }
                        if (!bl) {
                            stringBuffer.append(string4);
                        }
                        stringBuffer.append((String)object3);
                        stringBuffer.append(" ");
                        continue;
                    }
                    object3 = (PsXmlNode)e;
                    if (object3 == null) continue;
                    stringBuffer = PsXmlNode.writeNode(stringBuffer, (PsXmlNode)object3, string + string2);
                }
                if (!bl) {
                    stringBuffer.append(string);
                }
                stringBuffer.append("</" + psXmlNode.getType() + ">\n");
            }
        }
        return stringBuffer;
    }

    public static boolean writeNode(Writer writer, PsXmlNode psXmlNode, String string) throws IOException {
        String string2;
        Object object;
        Object object2;
        if (writer == null) {
            PsDebug.warning("Missing writer to save data to.");
            return false;
        }
        if (psXmlNode == null) {
            return true;
        }
        writer.write(string + "<" + psXmlNode.getType());
        Hashtable hashtable = psXmlNode.getAttributes();
        if (hashtable != null) {
            object2 = hashtable.keys();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                string2 = psXmlNode.getAttribute((String)object);
                writer.write(" " + (String)object + "=\"" + string2 + "\"");
            }
        }
        if (!psXmlNode.isMixedMode()) {
            object2 = psXmlNode.getContent();
            object = psXmlNode.getChild();
            if ((object2 == null || ((String)object2).equals("")) && object == null) {
                writer.write("/>\n");
            } else {
                writer.write(">");
                boolean bl = true;
                int n = -1;
                if (object2 != null) {
                    n = ((String)object2).indexOf(10);
                }
                if (object2 != null && n > -1 || object != null) {
                    bl = false;
                    writer.write("\n");
                }
                if (object2 != null) {
                    int n2 = 0;
                    String string3 = string + "\t";
                    if (n != -1) {
                        do {
                            writer.write(string3 + ((String)object2).substring(n2, n + 1));
                            n2 = n + 1;
                        } while ((n = ((String)object2).indexOf(10, n + 1)) != -1);
                        if (n2 < ((String)object2).length()) {
                            writer.write(string3 + ((String)object2).substring(n2, ((String)object2).length()) + "\n");
                        }
                    } else {
                        if (!bl) {
                            writer.write(string3);
                        }
                        writer.write((String)object2);
                        if (!bl) {
                            writer.write("\n");
                        }
                    }
                }
                if (object != null) {
                    PsXmlNode.writeNode(writer, (PsXmlNode)object, string + "\t");
                    PsXmlNode psXmlNode2 = ((PsXmlNode)object).getSibling();
                    while (psXmlNode2 != null) {
                        PsXmlNode.writeNode(writer, psXmlNode2, string + "\t");
                        psXmlNode2 = psXmlNode2.getSibling();
                    }
                }
                if (!bl) {
                    writer.write(string);
                }
                writer.write("</" + psXmlNode.getType() + ">\n");
            }
        } else {
            object2 = psXmlNode.getMixedContent();
            if (object2 == null || !object2.hasMoreElements()) {
                writer.write("/>\n");
            } else {
                writer.write(">");
                boolean bl = true;
                string2 = "";
                while (object2.hasMoreElements()) {
                    Object object3;
                    Object e = object2.nextElement();
                    if (e instanceof String) {
                        object3 = (String)e;
                        int n = -1;
                        if (object3 != null) {
                            n = ((String)object3).indexOf(10);
                        }
                        if (object3 != null && n > -1 || psXmlNode.getChild() != null) {
                            bl = false;
                        }
                        if (object3 == null) continue;
                        int n3 = 0;
                        String string4 = string + string2;
                        if (n != -1) {
                            do {
                                writer.write(string4 + ((String)object3).substring(n3, n + 1));
                                n3 = n + 1;
                            } while ((n = ((String)object3).indexOf(10, n + 1)) != -1);
                            if (n3 >= ((String)object3).length()) continue;
                            writer.write(string4 + ((String)object3).substring(n3, ((String)object3).length()) + "\n");
                            continue;
                        }
                        if (!bl) {
                            writer.write(string4);
                        }
                        writer.write((String)object3);
                        writer.write(" ");
                        continue;
                    }
                    object3 = (PsXmlNode)e;
                    if (object3 == null) continue;
                    PsXmlNode.writeNode(writer, (PsXmlNode)object3, string + string2);
                }
                if (!bl) {
                    writer.write(string);
                }
                writer.write("</" + psXmlNode.getType() + ">\n");
            }
        }
        return true;
    }

    public void removeChildren() {
        this.m_child = null;
        this.m_lastChild = null;
    }
}

