/*
 * Decompiled with CFR 0.152.
 */
package jv.thirdParty.ruler;

import java.util.Enumeration;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.project.PgGeometry;
import jv.project.PvDisplayIf;
import jv.thirdParty.ruler.PgRuler;
import jv.vecmath.PdVector;

public final class PgAxes
extends PgGeometry {
    public static final int AXES_3DCENTRAL = 0;
    public static final int AXES_3DCORNER = 1;
    public static final int AXES_3DBOUNDINGBOX = 2;
    public static final int AXES_2DXY_CENTER = 3;
    public static final int AXES_2DYZ_CENTER = 4;
    public static final int AXES_2DZX_CENTER = 5;
    public static final int AXES_2DXY_CORNER = 6;
    public static final int AXES_2DYZ_CORNER = 7;
    public static final int AXES_2DZX_CORNER = 8;
    protected final int XN = 0;
    protected final int XUP = 1;
    protected final int YN = 2;
    protected final int YUP = 3;
    protected final int ZN = 4;
    protected final int ZUP = 5;
    protected final int MIN = 0;
    protected final int MAX = 1;
    protected final int X = 0;
    protected final int Y = 1;
    protected final int Z = 2;
    protected final int N = 0;
    protected final int U = 1;
    protected final int NEGN = -1;
    protected final int NEGU = -2;
    protected final double defScale = 5.0;
    protected final int xoff = 7;
    protected final int yoff = 3;
    protected final int[] stdAlignmnt;
    protected boolean[] m_showHashingFlags;
    protected boolean m_bFixedMode;
    protected boolean m_bShowAllMajors;
    protected boolean m_bShowAllMinors;
    protected boolean m_bShowLabels;
    protected boolean m_bShowTitles;
    protected PuInteger m_numMajorHashings;
    protected PuInteger m_numMinorHashings;
    protected PuDouble m_majorHashUnits;
    protected PuDouble m_minorHashUnits;
    protected PdVector[] m_bndBox;
    protected PdVector m_viewVect;
    protected PgRuler[] m_axis;
    protected int m_numAxis;
    protected PgRuler m_xaxis;
    protected PgRuler m_yaxis;
    protected PgRuler m_zaxis;
    protected int m_mode;
    protected double m_scale;
    protected boolean m_bAutoConfigure;
    private String[] m_defAxisLabel;

    public void setTitleAlignments(int[] nArray, int[] nArray2, int[] nArray3) {
        this.m_xaxis.setNameAlignment(nArray[0], nArray[1], nArray[2], nArray[3]);
        this.m_yaxis.setNameAlignment(nArray2[0], nArray2[1], nArray2[2], nArray2[3]);
        this.m_zaxis.setNameAlignment(nArray3[0], nArray3[1], nArray3[2], nArray3[3]);
    }

    public boolean isShowingXYGrid() {
        return this.m_showHashingFlags[0] && this.m_showHashingFlags[3];
    }

    public boolean isShowingZXGrid() {
        return this.m_showHashingFlags[4] && this.m_showHashingFlags[1];
    }

    public void showXYGrid(boolean bl) {
        this.m_showHashingFlags[0] = bl;
        this.m_showHashingFlags[3] = bl;
    }

    public void showZXGrid(boolean bl) {
        this.m_showHashingFlags[4] = bl;
        this.m_showHashingFlags[1] = bl;
    }

    public boolean isShowingMinorHashings() {
        return this.m_bShowAllMinors;
    }

    public void showMinorHashings(boolean bl) {
        int n = 0;
        while (n < this.m_numAxis) {
            this.m_axis[n].showMinorHashings(bl);
            ++n;
        }
        this.m_bShowAllMinors = bl;
    }

    public boolean update(Object object) {
        if (object == this) {
            this.constructAxes();
            this.m_xaxis.update(this.m_xaxis);
            this.m_yaxis.update(this.m_yaxis);
            this.m_zaxis.update(this.m_zaxis);
            return super.update(this);
        }
        if (object == this.m_majorHashUnits || object == this.m_minorHashUnits) {
            this.setFixedHashings(this.m_majorHashUnits.getValue(), this.m_minorHashUnits.getValue());
            return this.update(this);
        }
        if (object == this.m_numMajorHashings || object == this.m_numMinorHashings) {
            this.setPartitionedHashing(this.m_numMajorHashings.getValue(), this.m_numMinorHashings.getValue());
            return this.update(this);
        }
        return super.update(object);
    }

    public boolean isShowingYZGrid() {
        return this.m_showHashingFlags[2] && this.m_showHashingFlags[5];
    }

    public void showYZGrid(boolean bl) {
        this.m_showHashingFlags[2] = bl;
        this.m_showHashingFlags[5] = bl;
    }

    public boolean isShowingLabels() {
        return this.m_bShowLabels;
    }

    public void showLabels(boolean bl) {
        int n = 0;
        while (n < this.m_numAxis) {
            this.m_axis[n].showLabels(bl);
            ++n;
        }
        this.m_bShowLabels = bl;
    }

    public void setAutoConfigure(boolean bl) {
        this.m_bAutoConfigure = bl;
    }

    protected void constructAxes() {
        this.m_xaxis.setHashOffsetInNormalDir(0.0, 0.0, 0.0);
        this.m_xaxis.setHashOffsetInUpDir(0.0, 0.0, 0.0);
        this.m_yaxis.setHashOffsetInNormalDir(0.0, 0.0, 0.0);
        this.m_yaxis.setHashOffsetInUpDir(0.0, 0.0, 0.0);
        this.m_zaxis.setHashOffsetInNormalDir(0.0, 0.0, 0.0);
        this.m_zaxis.setHashOffsetInUpDir(0.0, 0.0, 0.0);
        this.m_xaxis.showHashingsInUpDir(this.m_showHashingFlags[1]);
        this.m_yaxis.showHashingsInUpDir(this.m_showHashingFlags[3]);
        this.m_zaxis.showHashingsInUpDir(this.m_showHashingFlags[5]);
        this.m_xaxis.showHashingsInNormalDir(this.m_showHashingFlags[0]);
        this.m_yaxis.showHashingsInNormalDir(this.m_showHashingFlags[2]);
        this.m_zaxis.showHashingsInNormalDir(this.m_showHashingFlags[4]);
        switch (this.m_mode) {
            case 0: {
                this.setVisibleAxes(true, true, true);
                this.modeCentral();
                return;
            }
            case 1: {
                this.setVisibleAxes(true, true, true);
                this.modeCorner();
                return;
            }
            case 2: {
                this.setVisibleAxes(true, true, true);
                this.modeBoundingBox();
                return;
            }
            case 3: {
                this.setVisibleAxes(true, true, false);
                this.modeCentral();
                this.setTitleAlignments(this.stdAlignmnt, this.stdAlignmnt, this.stdAlignmnt);
                return;
            }
            case 4: {
                this.setVisibleAxes(false, true, true);
                this.modeCentral();
                this.setTitleAlignments(this.stdAlignmnt, this.stdAlignmnt, this.stdAlignmnt);
                this.setHashingsForUninvolvedAxes(0, 0, 1);
                return;
            }
            case 5: {
                this.setVisibleAxes(true, false, true);
                this.modeCentral();
                this.setTitleAlignments(this.stdAlignmnt, this.stdAlignmnt, this.stdAlignmnt);
                this.setHashingsForUninvolvedAxes(1, 0, 0);
                return;
            }
            case 6: {
                this.setVisibleAxes(true, true, false);
                this.modeCorner();
                this.setTitleAlignments(this.stdAlignmnt, this.stdAlignmnt, this.stdAlignmnt);
                return;
            }
            case 7: {
                this.setVisibleAxes(false, true, true);
                this.modeCorner();
                this.setTitleAlignments(this.stdAlignmnt, this.stdAlignmnt, this.stdAlignmnt);
                this.setHashingsForUninvolvedAxes(0, 0, 1);
                return;
            }
            case 8: {
                this.setVisibleAxes(true, false, true);
                this.modeCorner();
                this.setTitleAlignments(this.stdAlignmnt, this.stdAlignmnt, this.stdAlignmnt);
                this.setHashingsForUninvolvedAxes(1, 0, 0);
                return;
            }
        }
        this.setVisibleAxes(true, true, true);
        this.modeCentral();
    }

    protected void setVisibleAxes(boolean bl, boolean bl2, boolean bl3) {
        if (!bl) {
            this.showXYGrid(bl);
            this.showZXGrid(bl);
        }
        if (!bl2) {
            this.showXYGrid(bl2);
            this.showYZGrid(bl2);
        }
        if (!bl3) {
            this.showYZGrid(bl3);
            this.showZXGrid(bl3);
        }
        this.m_xaxis.setVisible(bl);
        this.m_yaxis.setVisible(bl2);
        this.m_zaxis.setVisible(bl3);
    }

    public PgGeometry[] getAxes() {
        return this.m_axis;
    }

    protected void setHashingsForUninvolvedAxes(int n, int n2, int n3) {
        double d = this.m_bndBox[1].getEntry(0) - this.m_bndBox[0].getEntry(0);
        double d2 = this.m_bndBox[1].getEntry(1) - this.m_bndBox[0].getEntry(1);
        double d3 = this.m_bndBox[1].getEntry(2) - this.m_bndBox[0].getEntry(2);
        double d4 = this.nonZeroMin(d, d2, d3);
        double d5 = 0.06 * d4;
        double d6 = 0.03 * d4;
        if (!this.m_showHashingFlags[1] && !this.m_showHashingFlags[0]) {
            switch (n) {
                case 0: {
                    this.m_xaxis.setMajorHashSize(0.0, d5, 0);
                    this.m_xaxis.setMinorHashSize(0.0, d6, 0);
                    this.m_xaxis.showHashingsInNormalDir(true);
                    break;
                }
                case -1: {
                    this.m_xaxis.setMajorHashSize(0.0, -d5, 0);
                    this.m_xaxis.setMinorHashSize(0.0, -d6, 0);
                    this.m_xaxis.showHashingsInNormalDir(true);
                    break;
                }
                case 1: {
                    this.m_xaxis.setMajorHashSize(0.0, d5, 1);
                    this.m_xaxis.setMinorHashSize(0.0, d6, 1);
                    this.m_xaxis.showHashingsInUpDir(true);
                    break;
                }
                case -2: {
                    this.m_xaxis.setMajorHashSize(0.0, -d5, 1);
                    this.m_xaxis.setMinorHashSize(0.0, -d6, 1);
                    this.m_xaxis.showHashingsInUpDir(true);
                }
            }
        }
        if (!this.m_showHashingFlags[3] && !this.m_showHashingFlags[2]) {
            switch (n2) {
                case 0: {
                    this.m_yaxis.setMajorHashSize(0.0, d5, 0);
                    this.m_yaxis.setMinorHashSize(0.0, d6, 0);
                    this.m_yaxis.showHashingsInNormalDir(true);
                    break;
                }
                case -1: {
                    this.m_yaxis.setMajorHashSize(0.0, -d5, 0);
                    this.m_yaxis.setMinorHashSize(0.0, -d6, 0);
                    this.m_yaxis.showHashingsInNormalDir(true);
                    break;
                }
                case 1: {
                    this.m_yaxis.setMajorHashSize(0.0, d5, 1);
                    this.m_yaxis.setMinorHashSize(0.0, d6, 1);
                    this.m_yaxis.showHashingsInUpDir(true);
                    break;
                }
                case -2: {
                    this.m_yaxis.setMajorHashSize(0.0, -d5, 1);
                    this.m_yaxis.setMinorHashSize(0.0, -d6, 1);
                    this.m_yaxis.showHashingsInUpDir(true);
                }
            }
        }
        if (!this.m_showHashingFlags[5] && !this.m_showHashingFlags[4]) {
            switch (n3) {
                case 0: {
                    this.m_zaxis.setMajorHashSize(0.0, d5, 0);
                    this.m_zaxis.setMinorHashSize(0.0, d6, 0);
                    this.m_zaxis.showHashingsInNormalDir(true);
                    return;
                }
                case -1: {
                    this.m_zaxis.setMajorHashSize(0.0, -d5, 0);
                    this.m_zaxis.setMinorHashSize(0.0, -d6, 0);
                    this.m_zaxis.showHashingsInNormalDir(true);
                    return;
                }
                case 1: {
                    this.m_zaxis.setMajorHashSize(0.0, d5, 1);
                    this.m_zaxis.setMinorHashSize(0.0, d6, 1);
                    this.m_zaxis.showHashingsInUpDir(true);
                    return;
                }
                case -2: {
                    this.m_zaxis.setMajorHashSize(0.0, -d5, 1);
                    this.m_zaxis.setMinorHashSize(0.0, -d6, 1);
                    this.m_zaxis.showHashingsInUpDir(true);
                    return;
                }
            }
        }
    }

    protected void modeBoundingBox() {
        int n = 0;
        while (n < this.m_numAxis) {
            this.m_axis[n].setMinMax(this.m_bndBox[0].getEntry(n), this.m_bndBox[1].getEntry(n));
            ++n;
        }
        double d = this.m_xaxis.getMaxParameter() - this.m_xaxis.getMinParameter();
        double d2 = this.m_yaxis.getMaxParameter() - this.m_yaxis.getMinParameter();
        double d3 = this.m_zaxis.getMaxParameter() - this.m_zaxis.getMinParameter();
        if (this.m_showHashingFlags[0] && this.m_showHashingFlags[3]) {
            this.m_xaxis.setMinorHashSize(0.0, d2, 0);
            this.m_yaxis.setMinorHashSize(0.0, d, 1);
            this.m_xaxis.setMajorHashSize(0.0, d2, 0);
            this.m_yaxis.setMajorHashSize(0.0, d, 1);
        }
        if (this.m_showHashingFlags[2] && this.m_showHashingFlags[5]) {
            this.m_yaxis.setMinorHashSize(0.0, d3, 0);
            this.m_zaxis.setMinorHashSize(0.0, d2, 1);
            this.m_yaxis.setMajorHashSize(0.0, d3, 0);
            this.m_zaxis.setMajorHashSize(0.0, d2, 1);
        }
        if (this.m_showHashingFlags[4] && this.m_showHashingFlags[1]) {
            this.m_zaxis.setMinorHashSize(0.0, d, 0);
            this.m_xaxis.setMinorHashSize(0.0, d3, 1);
            this.m_zaxis.setMajorHashSize(0.0, d, 0);
            this.m_xaxis.setMajorHashSize(0.0, d3, 1);
        }
        int n2 = new Double(2.0 * Math.ceil(5.0)).intValue();
        double d4 = this.m_viewVect.getEntry(0);
        double d5 = this.m_viewVect.getEntry(1);
        this.m_viewVect.getEntry(2);
        if (d4 <= 0.0 && d5 <= 0.0) {
            this.m_xaxis.setOrigin(new PdVector(0.0, this.m_bndBox[1].getEntry(1), this.m_bndBox[0].getEntry(2)));
            this.m_yaxis.setOrigin(new PdVector(this.m_bndBox[1].getEntry(0), 0.0, this.m_bndBox[0].getEntry(2)));
            this.m_zaxis.setOrigin(new PdVector(this.m_bndBox[1].getEntry(0), this.m_bndBox[0].getEntry(1), 0.0));
            int[] nArray = new int[4];
            nArray[0] = 2;
            nArray[2] = n2;
            nArray[3] = n2;
            int[] nArray2 = nArray;
            int[] nArray3 = new int[]{2, 2, -n2, n2};
            int[] nArray4 = new int[]{2, 2, -n2, n2};
            this.setTitleAlignments(nArray2, nArray3, nArray4);
            if (this.m_showHashingFlags[0] && this.m_showHashingFlags[3]) {
                this.m_xaxis.setHashOffsetInNormalDir(0.0, -d2, 0.0);
                this.m_yaxis.setHashOffsetInUpDir(-d, 0.0, 0.0);
            }
            if (this.m_showHashingFlags[4] && this.m_showHashingFlags[1]) {
                this.m_zaxis.setHashOffsetInNormalDir(-d, d2, 0.0);
            }
            this.setHashingsForUninvolvedAxes(-1, -2, 1);
            return;
        }
        if (d4 <= 0.0 && d5 > 0.0) {
            this.m_xaxis.setOrigin(new PdVector(0.0, this.m_bndBox[0].getEntry(1), this.m_bndBox[0].getEntry(2)));
            this.m_yaxis.setOrigin(new PdVector(this.m_bndBox[1].getEntry(0), 0.0, this.m_bndBox[0].getEntry(2)));
            this.m_zaxis.setOrigin(new PdVector(this.m_bndBox[0].getEntry(0), this.m_bndBox[0].getEntry(1), 0.0));
            int[] nArray = new int[]{2, 2, -n2, n2};
            int[] nArray5 = new int[4];
            nArray5[0] = 2;
            nArray5[2] = n2;
            nArray5[3] = n2;
            int[] nArray6 = nArray5;
            int[] nArray7 = new int[]{2, 2, -n2, n2};
            this.setTitleAlignments(nArray, nArray6, nArray7);
            if (this.m_showHashingFlags[0] && this.m_showHashingFlags[3]) {
                this.m_yaxis.setHashOffsetInUpDir(-d, 0.0, 0.0);
            }
            if (this.m_showHashingFlags[2] && this.m_showHashingFlags[5]) {
                this.m_zaxis.setHashOffsetInUpDir(d, 0.0, 0.0);
            }
            this.setHashingsForUninvolvedAxes(0, -2, 0);
            return;
        }
        if (d4 > 0.0 && d5 <= 0.0) {
            this.m_xaxis.setOrigin(new PdVector(0.0, this.m_bndBox[1].getEntry(1), this.m_bndBox[0].getEntry(2)));
            this.m_yaxis.setOrigin(new PdVector(this.m_bndBox[0].getEntry(0), 0.0, this.m_bndBox[0].getEntry(2)));
            this.m_zaxis.setOrigin(new PdVector(this.m_bndBox[1].getEntry(0), this.m_bndBox[1].getEntry(1), 0.0));
            int[] nArray = new int[]{2, 2, -n2, n2};
            int[] nArray8 = new int[4];
            nArray8[0] = 2;
            nArray8[2] = n2;
            nArray8[3] = n2;
            int[] nArray9 = nArray8;
            int[] nArray10 = new int[]{2, 2, -n2, n2};
            this.setTitleAlignments(nArray, nArray9, nArray10);
            if (this.m_showHashingFlags[0] && this.m_showHashingFlags[3]) {
                this.m_xaxis.setHashOffsetInNormalDir(0.0, -d2, 0.0);
            }
            if (this.m_showHashingFlags[4] && this.m_showHashingFlags[1]) {
                this.m_zaxis.setHashOffsetInNormalDir(-d, 0.0, 0.0);
            }
            if (this.m_showHashingFlags[2] && this.m_showHashingFlags[5]) {
                this.m_zaxis.setHashOffsetInUpDir(-d, -d2, 0.0);
            }
            this.setHashingsForUninvolvedAxes(-1, 1, -1);
            return;
        }
        this.m_xaxis.setOrigin(new PdVector(0.0, this.m_bndBox[0].getEntry(1), this.m_bndBox[0].getEntry(2)));
        this.m_yaxis.setOrigin(new PdVector(this.m_bndBox[0].getEntry(0), 0.0, this.m_bndBox[0].getEntry(2)));
        this.m_zaxis.setOrigin(new PdVector(this.m_bndBox[0].getEntry(0), this.m_bndBox[1].getEntry(1), 0.0));
        int[] nArray = new int[4];
        nArray[0] = 2;
        nArray[2] = n2;
        nArray[3] = n2;
        int[] nArray11 = nArray;
        int[] nArray12 = new int[]{2, 2, -n2, n2};
        int[] nArray13 = new int[]{2, 2, -n2, n2};
        this.setTitleAlignments(nArray11, nArray12, nArray13);
        if (this.m_showHashingFlags[4] && this.m_showHashingFlags[1]) {
            this.m_zaxis.setHashOffsetInNormalDir(0.0, -d2, 0.0);
        }
        if (this.m_showHashingFlags[2] && this.m_showHashingFlags[5]) {
            this.m_zaxis.setHashOffsetInUpDir(0.0, -d2, 0.0);
        }
        this.setHashingsForUninvolvedAxes(0, 1, -2);
    }

    protected void modeCentral() {
        int n = 0;
        while (n < this.m_numAxis) {
            this.m_axis[n].setOrigin(new PdVector(0.0, 0.0, 0.0));
            this.m_axis[n].setMinMax(this.m_bndBox[0].getEntry(n), this.m_bndBox[1].getEntry(n));
            ++n;
        }
        if (this.m_showHashingFlags[0] && this.m_showHashingFlags[3]) {
            this.m_xaxis.setMinorHashSize(this.m_yaxis.getMaxParameter(), this.m_yaxis.getMinParameter(), 0);
            this.m_yaxis.setMinorHashSize(this.m_xaxis.getMaxParameter(), this.m_xaxis.getMinParameter(), 1);
            this.m_xaxis.setMajorHashSize(this.m_yaxis.getMaxParameter(), this.m_yaxis.getMinParameter(), 0);
            this.m_yaxis.setMajorHashSize(this.m_xaxis.getMaxParameter(), this.m_xaxis.getMinParameter(), 1);
        }
        if (this.m_showHashingFlags[2] && this.m_showHashingFlags[5]) {
            this.m_yaxis.setMinorHashSize(this.m_zaxis.getMaxParameter(), this.m_zaxis.getMinParameter(), 0);
            this.m_zaxis.setMinorHashSize(this.m_yaxis.getMaxParameter(), this.m_yaxis.getMinParameter(), 1);
            this.m_yaxis.setMajorHashSize(this.m_zaxis.getMaxParameter(), this.m_zaxis.getMinParameter(), 0);
            this.m_zaxis.setMajorHashSize(this.m_yaxis.getMaxParameter(), this.m_yaxis.getMinParameter(), 1);
        }
        if (this.m_showHashingFlags[4] && this.m_showHashingFlags[1]) {
            this.m_zaxis.setMinorHashSize(this.m_xaxis.getMaxParameter(), this.m_xaxis.getMinParameter(), 0);
            this.m_xaxis.setMinorHashSize(this.m_zaxis.getMaxParameter(), this.m_zaxis.getMinParameter(), 1);
            this.m_zaxis.setMajorHashSize(this.m_xaxis.getMaxParameter(), this.m_xaxis.getMinParameter(), 0);
            this.m_xaxis.setMajorHashSize(this.m_zaxis.getMaxParameter(), this.m_zaxis.getMinParameter(), 1);
        }
        double d = this.m_viewVect.getEntry(0);
        double d2 = this.m_viewVect.getEntry(1);
        double d3 = this.m_viewVect.getEntry(2);
        if (d <= 0.0 && d2 <= 0.0) {
            int[] nArray = new int[]{1, 2, -7, 3};
            int[] nArray2 = new int[4];
            nArray2[0] = 1;
            nArray2[2] = 7;
            nArray2[3] = 3;
            int[] nArray3 = nArray2;
            int[] nArray4 = new int[4];
            nArray4[0] = 1;
            nArray4[2] = -3;
            nArray4[3] = -7;
            int[] nArray5 = nArray4;
            if (d3 > 0.0) {
                nArray5[0] = 0;
                nArray5[3] = 14;
            }
            this.setTitleAlignments(nArray, nArray3, nArray5);
        } else if (d <= 0.0 && d2 > 0.0) {
            int[] nArray = new int[4];
            nArray[0] = 1;
            nArray[2] = 7;
            nArray[3] = 3;
            int[] nArray6 = nArray;
            int[] nArray7 = new int[4];
            nArray7[1] = 2;
            nArray7[2] = -7;
            nArray7[3] = 3;
            int[] nArray8 = nArray7;
            int[] nArray9 = new int[4];
            nArray9[0] = 1;
            nArray9[2] = -3;
            nArray9[3] = -7;
            int[] nArray10 = nArray9;
            if (d3 > 0.0) {
                nArray10[0] = 0;
                nArray10[3] = 14;
            }
            this.setTitleAlignments(nArray6, nArray8, nArray10);
        } else if (d > 0.0 && d2 <= 0.0) {
            int[] nArray = new int[4];
            nArray[2] = 7;
            nArray[3] = 3;
            int[] nArray11 = nArray;
            int[] nArray12 = new int[]{1, 2, -7, 3};
            int[] nArray13 = new int[4];
            nArray13[0] = 1;
            nArray13[2] = -3;
            nArray13[3] = -7;
            int[] nArray14 = nArray13;
            if (d3 > 0.0) {
                nArray14[0] = 0;
                nArray14[3] = 14;
            }
            this.setTitleAlignments(nArray11, nArray12, nArray14);
        } else {
            int[] nArray = new int[4];
            nArray[1] = 2;
            nArray[2] = -7;
            nArray[3] = 3;
            int[] nArray15 = nArray;
            int[] nArray16 = new int[4];
            nArray16[2] = 7;
            nArray16[3] = 3;
            int[] nArray17 = nArray16;
            int[] nArray18 = new int[4];
            nArray18[0] = 1;
            nArray18[2] = -3;
            nArray18[3] = -7;
            int[] nArray19 = nArray18;
            if (d3 > 0.0) {
                nArray19[0] = 0;
                nArray19[3] = 14;
            }
            this.setTitleAlignments(nArray15, nArray17, nArray19);
        }
        this.setHashingsForUninvolvedAxes(0, 1, 0);
    }

    public boolean isShowingMajorHashings() {
        return this.m_bShowAllMajors;
    }

    public void showMajorHashings(boolean bl) {
        int n = 0;
        while (n < this.m_numAxis) {
            this.m_axis[n].showMajorHashings(bl);
            ++n;
        }
        this.m_bShowAllMajors = bl;
    }

    public void setFixedHashings(double d, double d2) {
        int n = 0;
        while (n < this.m_numAxis) {
            this.m_axis[n].setFixedHashing(d, d2);
            ++n;
        }
        if (d >= this.m_majorHashUnits.getMax() - 0.5) {
            this.m_majorHashUnits.setBounds(0.1, 2.0 * d);
        }
        if (d2 >= this.m_minorHashUnits.getMax() - 0.5) {
            this.m_minorHashUnits.setBounds(0.1, 2.0 * d2);
        }
        this.m_majorHashUnits.setValue(d);
        this.m_minorHashUnits.setValue(d2);
    }

    private double nonZeroMin(double d, double d2, double d3) {
        double d4 = Double.MAX_VALUE;
        if (d > 0.0 && d < d4) {
            d4 = d;
        }
        if (d2 > 0.0 && d2 < d4) {
            d4 = d2;
        }
        if (d3 > 0.0 && d3 < d4) {
            d4 = d3;
        }
        if (d4 == Double.MAX_VALUE) {
            d4 = d3;
        }
        return d4;
    }

    public void setPartitionedHashing(int n, int n2) {
        int n3 = 0;
        while (n3 < this.m_numAxis) {
            this.m_axis[n3].setPartitionedHashing(n, n2);
            ++n3;
        }
        this.m_numMajorHashings.setValue(n);
        this.m_numMinorHashings.setValue(n2);
    }

    public PgAxes(int n) {
        super(n);
        int[] nArray = new int[4];
        nArray[0] = 1;
        nArray[2] = 7;
        nArray[3] = 3;
        this.stdAlignmnt = nArray;
        this.m_showHashingFlags = new boolean[6];
        this.m_defAxisLabel = new String[]{"x", "y", "z"};
        this.setTag(7);
        this.setName("Axes");
        this.m_viewVect = new PdVector(0.0, 0.0, -1.0);
        this.m_bndBox = new PdVector[2];
        this.m_bndBox[0] = new PdVector(3);
        this.m_bndBox[1] = new PdVector(3);
        PdVector pdVector = new PdVector(1.0, 0.0, 0.0);
        PdVector pdVector2 = new PdVector(0.0, 1.0, 0.0);
        PdVector pdVector3 = new PdVector(0.0, 0.0, 1.0);
        this.m_xaxis = new PgRuler(pdVector, pdVector2);
        this.m_yaxis = new PgRuler(pdVector2, pdVector3);
        this.m_zaxis = new PgRuler(pdVector3, pdVector);
        this.m_numAxis = 3;
        this.m_axis = new PgRuler[]{this.m_xaxis, this.m_yaxis, this.m_zaxis};
        this.m_majorHashUnits = new PuDouble("Major Units", this);
        this.m_minorHashUnits = new PuDouble("Minor Units", this);
        this.m_numMajorHashings = new PuInteger("Major Hashings", this);
        this.m_numMinorHashings = new PuInteger("Minor Hashings", this);
        this.init();
    }

    public void setMode(int n) {
        this.m_mode = n;
        Enumeration enumeration = this.getDisplays();
        if (enumeration == null) {
            return;
        }
        int n2 = 1;
        if (this.m_mode == 1) {
            n2 = -1;
        }
        while (enumeration.hasMoreElements()) {
            PvDisplayIf pvDisplayIf = (PvDisplayIf)enumeration.nextElement();
            int n3 = 0;
            while (n3 < this.m_numAxis) {
                pvDisplayIf.setDrawingOrder(n2, this.m_axis[n3]);
                ++n3;
            }
        }
    }

    public int getMode() {
        return this.m_mode;
    }

    public boolean isShowingTitles() {
        return this.m_bShowTitles;
    }

    public void showTitles(boolean bl) {
        int n = 0;
        while (n < this.m_numAxis) {
            this.m_axis[n].showRulerName(bl);
            ++n;
        }
        this.m_bShowTitles = bl;
    }

    public void setTitles(String[] stringArray) {
        int n = 0;
        while (n < this.m_numAxis) {
            this.m_axis[n].setRulerName(stringArray[n]);
            ++n;
        }
    }

    public void showFixedMode(boolean bl) {
        int n = 0;
        while (n < this.m_numAxis) {
            this.m_axis[n].showFixedMode(bl);
            ++n;
        }
        this.m_bFixedMode = bl;
    }

    private double nonZeroMax(double d, double d2, double d3) {
        return Math.max(Math.max(d, d2), d3);
    }

    protected void modeCorner() {
        int n = 0;
        while (n < this.m_numAxis) {
            this.m_axis[n].setMinMax(this.m_bndBox[0].getEntry(n), this.m_bndBox[1].getEntry(n));
            ++n;
        }
        double d = this.m_xaxis.getMaxParameter() - this.m_xaxis.getMinParameter();
        double d2 = this.m_yaxis.getMaxParameter() - this.m_yaxis.getMinParameter();
        double d3 = this.m_zaxis.getMaxParameter() - this.m_zaxis.getMinParameter();
        if (this.m_showHashingFlags[0] && this.m_showHashingFlags[3]) {
            this.m_xaxis.setMinorHashSize(0.0, d2, 0);
            this.m_yaxis.setMinorHashSize(0.0, d, 1);
            this.m_xaxis.setMajorHashSize(0.0, d2, 0);
            this.m_yaxis.setMajorHashSize(0.0, d, 1);
        }
        if (this.m_showHashingFlags[2] && this.m_showHashingFlags[5]) {
            this.m_yaxis.setMinorHashSize(0.0, d3, 0);
            this.m_zaxis.setMinorHashSize(0.0, d2, 1);
            this.m_yaxis.setMajorHashSize(0.0, d3, 0);
            this.m_zaxis.setMajorHashSize(0.0, d2, 1);
        }
        if (this.m_showHashingFlags[4] && this.m_showHashingFlags[1]) {
            this.m_zaxis.setMinorHashSize(0.0, d, 0);
            this.m_xaxis.setMinorHashSize(0.0, d3, 1);
            this.m_zaxis.setMajorHashSize(0.0, d, 0);
            this.m_xaxis.setMajorHashSize(0.0, d3, 1);
        }
        double d4 = this.m_viewVect.getEntry(0);
        double d5 = this.m_viewVect.getEntry(1);
        if (d4 <= 0.0 && d5 <= 0.0) {
            this.m_xaxis.setOrigin(new PdVector(0.0, this.m_bndBox[0].getEntry(1), this.m_bndBox[0].getEntry(2)));
            this.m_yaxis.setOrigin(new PdVector(this.m_bndBox[0].getEntry(0), 0.0, this.m_bndBox[0].getEntry(2)));
            this.m_zaxis.setOrigin(new PdVector(this.m_bndBox[0].getEntry(0), this.m_bndBox[0].getEntry(1), 0.0));
            int[] nArray = new int[]{1, 1, -7, 3};
            int[] nArray2 = new int[4];
            nArray2[0] = 1;
            nArray2[2] = 7;
            nArray2[3] = 3;
            int[] nArray3 = nArray2;
            int[] nArray4 = new int[4];
            nArray4[0] = 1;
            nArray4[2] = -3;
            nArray4[3] = -7;
            int[] nArray5 = nArray4;
            this.setTitleAlignments(nArray, nArray3, nArray5);
            this.setHashingsForUninvolvedAxes(0, 1, 1);
            return;
        }
        if (d4 <= 0.0 && d5 > 0.0) {
            this.m_xaxis.setOrigin(new PdVector(0.0, this.m_bndBox[1].getEntry(1), this.m_bndBox[0].getEntry(2)));
            this.m_yaxis.setOrigin(new PdVector(this.m_bndBox[0].getEntry(0), 0.0, this.m_bndBox[0].getEntry(2)));
            this.m_zaxis.setOrigin(new PdVector(this.m_bndBox[0].getEntry(0), this.m_bndBox[1].getEntry(1), 0.0));
            int[] nArray = new int[4];
            nArray[0] = 1;
            nArray[2] = 7;
            nArray[3] = 3;
            int[] nArray6 = nArray;
            int[] nArray7 = new int[4];
            nArray7[1] = 1;
            nArray7[2] = -7;
            nArray7[3] = 3;
            int[] nArray8 = nArray7;
            int[] nArray9 = new int[4];
            nArray9[0] = 1;
            nArray9[2] = -3;
            nArray9[3] = -7;
            int[] nArray10 = nArray9;
            this.setTitleAlignments(nArray6, nArray8, nArray10);
            if (this.m_showHashingFlags[0] && this.m_showHashingFlags[3]) {
                this.m_xaxis.setHashOffsetInNormalDir(0.0, -d2, 0.0);
            }
            if (this.m_showHashingFlags[2] && this.m_showHashingFlags[5]) {
                this.m_zaxis.setHashOffsetInUpDir(0.0, -d2, 0.0);
            }
            this.setHashingsForUninvolvedAxes(-1, 1, 0);
            return;
        }
        if (d4 > 0.0 && d5 <= 0.0) {
            this.m_xaxis.setOrigin(new PdVector(0.0, this.m_bndBox[0].getEntry(1), this.m_bndBox[0].getEntry(2)));
            this.m_yaxis.setOrigin(new PdVector(this.m_bndBox[1].getEntry(0), 0.0, this.m_bndBox[0].getEntry(2)));
            this.m_zaxis.setOrigin(new PdVector(this.m_bndBox[1].getEntry(0), this.m_bndBox[0].getEntry(1), 0.0));
            int[] nArray = new int[4];
            nArray[2] = 7;
            nArray[3] = 3;
            int[] nArray11 = nArray;
            int[] nArray12 = new int[]{1, 1, -7, 3};
            int[] nArray13 = new int[4];
            nArray13[0] = 1;
            nArray13[2] = -3;
            nArray13[3] = -7;
            int[] nArray14 = nArray13;
            this.setTitleAlignments(nArray11, nArray12, nArray14);
            if (this.m_showHashingFlags[0] && this.m_showHashingFlags[3]) {
                this.m_yaxis.setHashOffsetInUpDir(-d, 0.0, 0.0);
            }
            if (this.m_showHashingFlags[4] && this.m_showHashingFlags[1]) {
                this.m_zaxis.setHashOffsetInNormalDir(-d, 0.0, 0.0);
            }
            this.setHashingsForUninvolvedAxes(0, -2, -1);
            return;
        }
        this.m_xaxis.setOrigin(new PdVector(0.0, this.m_bndBox[1].getEntry(1), this.m_bndBox[0].getEntry(2)));
        this.m_yaxis.setOrigin(new PdVector(this.m_bndBox[1].getEntry(0), 0.0, this.m_bndBox[0].getEntry(2)));
        this.m_zaxis.setOrigin(new PdVector(this.m_bndBox[1].getEntry(0), this.m_bndBox[1].getEntry(1), 0.0));
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = -7;
        nArray[3] = 3;
        int[] nArray15 = nArray;
        int[] nArray16 = new int[4];
        nArray16[2] = 7;
        nArray16[3] = 3;
        int[] nArray17 = nArray16;
        int[] nArray18 = new int[4];
        nArray18[0] = 1;
        nArray18[2] = -3;
        nArray18[3] = -7;
        int[] nArray19 = nArray18;
        this.setTitleAlignments(nArray15, nArray17, nArray19);
        if (this.m_showHashingFlags[0] && this.m_showHashingFlags[3]) {
            this.m_xaxis.setHashOffsetInNormalDir(0.0, -d2, 0.0);
            this.m_yaxis.setHashOffsetInUpDir(-d, 0.0, 0.0);
        }
        if (this.m_showHashingFlags[4] && this.m_showHashingFlags[1]) {
            this.m_zaxis.setHashOffsetInNormalDir(-d, 0.0, 0.0);
        }
        if (this.m_showHashingFlags[2] && this.m_showHashingFlags[5]) {
            this.m_zaxis.setHashOffsetInUpDir(0.0, -d2, 0.0);
        }
        this.setHashingsForUninvolvedAxes(-1, -2, -2);
    }

    public void init() {
        super.init();
        int n = 0;
        while (n < this.m_showHashingFlags.length) {
            this.m_showHashingFlags[n] = false;
            ++n;
        }
        this.setMode(2);
        this.m_scale = 5.0;
        this.m_bAutoConfigure = true;
        this.m_xaxis.init();
        this.m_yaxis.init();
        this.m_zaxis.init();
        this.m_xaxis.setHashLabel(0, 3, 1, 2);
        this.m_yaxis.setHashLabel(0, 3, 1, 2);
        this.m_zaxis.setHashLabel(-5, 0, 2, 1);
        this.setTitles(this.m_defAxisLabel);
        this.showTitles(true);
        this.setFixedHashings(1.0, 0.5);
        this.m_majorHashUnits.init();
        this.m_minorHashUnits.init();
        this.m_numMajorHashings.init();
        this.m_numMinorHashings.init();
        this.m_majorHashUnits.setValue(this.m_xaxis.getMajorUnit());
        this.m_minorHashUnits.setValue(this.m_xaxis.getMinorUnit());
        this.m_numMajorHashings.setValue(this.m_xaxis.getNumMajorPartitions());
        this.m_numMinorHashings.setValue(this.m_xaxis.getNumMinorPartitions());
        this.m_majorHashUnits.setBounds(0.1, 60.0, 0.1, 1.0);
        this.m_minorHashUnits.setBounds(0.1, 30.0, 0.1, 1.0);
        this.m_numMajorHashings.setBounds(0, 60, 1, 2);
        this.m_numMinorHashings.setBounds(0, 30, 1, 2);
        this.m_bFixedMode = this.m_xaxis.isShowingFixedMode();
        this.m_bShowAllMajors = this.m_xaxis.isShowingMajorHashings();
        this.m_bShowAllMinors = this.m_xaxis.isShowingMinorHashings();
        this.m_bShowLabels = this.m_xaxis.isShowingLabels();
        this.m_bShowTitles = this.m_xaxis.isShowingRulerName();
    }

    public void configure(PdVector[] pdVectorArray, PdVector pdVector) {
        double d;
        PdVector.copy(this.m_bndBox, 0, pdVectorArray, 0, 2);
        this.m_viewVect.copy(pdVector);
        if (!this.m_bAutoConfigure) {
            return;
        }
        double d2 = this.nonZeroMax(this.m_bndBox[1].getEntry(0) - this.m_bndBox[0].getEntry(0), this.m_bndBox[1].getEntry(1) - this.m_bndBox[0].getEntry(1), this.m_bndBox[1].getEntry(2) - this.m_bndBox[0].getEntry(2));
        if (d2 > 4.0 * (d = 8.0) * this.m_scale) {
            do {
                this.m_scale *= 5.0;
            } while (d2 > 4.0 * d * this.m_scale && this.m_scale < 1000000.0);
            this.m_majorHashUnits.setBounds(0.1, 2.0 * d2);
            this.m_minorHashUnits.setBounds(0.1, 2.0 * d2);
            this.setFixedHashings(this.m_scale, this.m_scale / 2.0);
        }
        if (d2 < d / 2.0 * this.m_scale) {
            do {
                this.m_scale /= 5.0;
            } while (d2 < d / 2.0 * this.m_scale && this.m_scale > 1.0E-4);
            this.m_majorHashUnits.setBounds(d2 / 100.0, 2.0 * d2);
            this.m_minorHashUnits.setBounds(d2 / 300.0, 2.0 * d2);
            this.setFixedHashings(this.m_scale, this.m_scale / 2.0);
        }
    }
}

