/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import jv.anim.PsAnimation;
import jv.anim.PsTimeEvent;
import jv.anim.PsTimeListenerIf;
import jv.geom.PgPointSet;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.vecmath.PdVector;
import jvx.geom.PwEvolve;

public class PjEvolve
extends PjProject {
    protected PgPointSet m_geom;
    protected int m_direction;
    protected PuDouble m_offsetFactor = new PuDouble(PsConfig.getMessage((String)"OffsetFactor"), (PsUpdateIf)this);
    protected PdVector[] m_vertexSave;
    protected boolean m_bUpdateSender;
    private static /* synthetic */ Class class$jvx$geom$PjEvolve;

    public int setDirection(int n) {
        if (n < 0 || n > 3) {
            PsDebug.warning((String)("void direction = " + n));
            return -1;
        }
        this.m_direction = n;
        return n;
    }

    public void evolve() {
        if (this.m_geom == null) {
            PsDebug.warning((String)"missing geometry.");
            return;
        }
        this.restoreGeometry();
        double d = this.m_offsetFactor.getValue();
        switch (this.m_direction) {
            case 0: {
                PwEvolve.evolveParallel(this.m_geom, d);
                break;
            }
            case 1: {
                PwEvolve.evolveVectorField(this.m_geom, d);
                break;
            }
            case 2: {
                PwEvolve.evolveParallel(this.m_geom, d);
                break;
            }
            case 3: {
                PwEvolve.evolveParallel(this.m_geom, d);
            }
        }
        this.m_geom.update((Object)this.m_geom);
    }

    public void stop() {
        if (this.m_anim != null) {
            if (this.m_anim.hasAnimationPanel()) {
                this.m_anim.getAnimationPanel().setVisible(false);
            }
            this.m_anim.stop();
            this.m_anim = null;
        }
        super.stop();
    }

    public PjEvolve() {
        super("Evolve");
        if (((Object)((Object)this)).getClass() == (class$jvx$geom$PjEvolve != null ? class$jvx$geom$PjEvolve : (class$jvx$geom$PjEvolve = PjEvolve.class$("jvx.geom.PjEvolve")))) {
            this.init();
        }
    }

    public boolean setTime(PsTimeEvent psTimeEvent) {
        this.m_offsetFactor.setValue(psTimeEvent.getTime());
        this.evolve();
        return true;
    }

    public boolean update(Object object) {
        if (object == this.m_geom) {
            if (!this.m_bUpdateSender) {
                this.init();
            }
            return true;
        }
        if (object == this) {
            this.m_bUpdateSender = true;
            this.m_geom.update((Object)this.m_geom);
            super.update((Object)this);
            this.m_bUpdateSender = false;
            return true;
        }
        if (object == this.m_offsetFactor) {
            if (this.m_anim != null) {
                this.m_anim.setTimeInterval(this.m_offsetFactor.getMin(), this.m_offsetFactor.getMax(), this.m_offsetFactor.getLineIncr(), this.m_offsetFactor.getPageIncr());
                this.m_anim.setTime(this.m_offsetFactor.getValue());
            }
            this.evolve();
            return super.update(null);
        }
        return super.update(object);
    }

    public PgGeometryIf getGeometry() {
        return this.m_geom;
    }

    public PgPointSet setGeometry(PgPointSet pgPointSet) {
        super.removeGeometries();
        super.addGeometry((PgGeometryIf)pgPointSet);
        PdVector[] pdVectorArray = pgPointSet.getVertices();
        int n = pgPointSet.getNumVertices();
        this.m_vertexSave = PdVector.realloc((PdVector[])this.m_vertexSave, (int)n, (int)pgPointSet.getDimOfVertices());
        PdVector.copy((PdVector[])this.m_vertexSave, (int)0, (PdVector[])pdVectorArray, (int)0, (int)n);
        this.m_geom = pgPointSet;
        return pgPointSet;
    }

    public void start() {
        if (this.m_anim == null) {
            this.m_anim = new PsAnimation();
            this.m_anim.setName(PsConfig.getMessage((String)"AnimatedEvolution"));
            this.m_anim.setTimeInterval(this.m_offsetFactor.getMin(), this.m_offsetFactor.getMax(), this.m_offsetFactor.getLineIncr(), this.m_offsetFactor.getPageIncr());
            this.m_anim.setTime(this.m_offsetFactor.getValue());
            this.m_anim.addTimeListener((PsTimeListenerIf)this);
        }
        this.m_anim.start();
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void init() {
        this.m_direction = 0;
        this.m_offsetFactor.setDefBounds(-5.0, 5.0, 0.005, 0.1);
        this.m_offsetFactor.setDefValue(0.0);
        this.m_offsetFactor.init();
        this.m_bUpdateSender = false;
        super.init();
    }

    public boolean restoreGeometry() {
        if (this.m_geom == null || this.m_vertexSave == null) {
            PsDebug.warning((String)"missing vertex data to reset geometry.");
            return false;
        }
        if (this.m_geom.getNumVertices() > this.m_vertexSave.length) {
            PsDebug.warning((String)"saved vertex array too short.");
            return false;
        }
        this.m_geom.setVertices(this.m_vertexSave);
        return true;
    }

    public int getDirection() {
        return this.m_direction;
    }
}

