/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import java.awt.Color;
import java.awt.Dialog;
import java.util.Enumeration;
import jv.geom.PgElementSet;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvDisplayIf;
import jv.project.PvPickEvent;
import jv.project.PvPickListenerIf;
import jv.vecmath.PiVector;
import jvx.geom.PgVertexStar;
import jvx.geom.PnCellOperator_Dialog;
import jvx.geom.PnCellOperator_IP;

public class PnCellOperator
extends PjProject
implements Runnable {
    public static final int LIFE = 0;
    public static final int MAJORITY = 1;
    protected int rule = 0;
    public static final int NEIGHBOUR = 0;
    public static final int CORONA = 1;
    protected int influence = 1;
    protected int m_sleepTime;
    protected PgElementSet m_geom;
    protected Color[] m_color;
    protected static final int SET_ELEMENT_TAG = 0;
    protected static final int SET_COLOR = 1;
    protected int m_outputType = 0;
    protected PiVector m_markI;
    protected int m_numStates;
    protected PiVector[] m_infCell;
    protected PgVertexStar m_vertexStar;
    protected PiVector[] m_geomElement;
    protected PiVector[] m_geomNeighbour;
    protected Thread m_thread;
    protected int m_numLoops;
    protected int m_currLoop;
    protected PnCellOperator_IP m_panel;
    protected PnCellOperator_Dialog m_dialog;
    protected boolean m_bUpdateSender = false;
    protected boolean m_bMarkGlider = false;
    protected boolean m_bUseGlobalElementColor;
    protected boolean m_bHasElementColors;
    protected boolean m_bShowTaggedElements;
    protected Color[] m_originalColors;
    private static /* synthetic */ Class class$jvx$geom$PnCellOperator;

    public void setRule(String string) {
        if (string.equals(PsConfig.getMessage((String)"LIFE"))) {
            this.rule = 0;
            return;
        }
        if (string.equals(PsConfig.getMessage((String)"MAJORITY"))) {
            this.rule = 1;
        }
    }

    public void stop() {
        this.m_thread = null;
        if (this.m_dialog != null) {
            ((Dialog)((Object)this.m_dialog)).setModal(false);
        }
    }

    public void setNumStates(int n) {
        if (n > 0) {
            this.m_numStates = n;
        }
    }

    public int getNumStates() {
        return this.m_numStates;
    }

    public PnCellOperator_Dialog getDialog() {
        if (this.m_dialog == null) {
            this.m_dialog = new PnCellOperator_Dialog(this);
        }
        return this.m_dialog;
    }

    public void requestPick() {
        Enumeration enumeration = this.m_geom.getDisplays();
        while (enumeration != null && enumeration.hasMoreElements()) {
            PvDisplayIf pvDisplayIf = (PvDisplayIf)enumeration.nextElement();
            pvDisplayIf.addPickListener((PvPickListenerIf)this);
            pvDisplayIf.requestPickFocus((PvPickListenerIf)this);
        }
    }

    public int getState(int n) {
        if (n > -1) {
            return this.m_markI.m_data[n];
        }
        return -1;
    }

    public void setNumLoops(int n) {
        this.m_numLoops = n;
    }

    public void setCurrLoop(int n) {
        this.m_currLoop = n;
    }

    public void makeInfluence() {
        if (this.influence == 0) {
            this.makeNeighbourInfluence();
        }
        if (this.influence == 1) {
            this.makeCoronaInfluence();
        }
    }

    public void evaluate() {
        if (this.m_outputType == 1) {
            this.setColors();
            return;
        }
        if (this.m_outputType == 0) {
            this.setElementTags();
        }
    }

    public boolean update(Object object) {
        if (object == this.m_geom) {
            if (!this.m_bUpdateSender) {
                this.init();
            }
            return true;
        }
        if (object == this) {
            this.m_bUpdateSender = true;
            this.m_geom.update((Object)this.m_geom);
            super.update((Object)this);
            this.m_bUpdateSender = false;
            return true;
        }
        if (object == this.m_dialog) {
            return true;
        }
        return super.update(object);
    }

    public int cellOperator(int n) {
        if (this.rule == 0) {
            return this.ruleOfLife(n);
        }
        if (this.rule == 1) {
            return this.ruleOfMajority(n);
        }
        return 0;
    }

    public void start() {
        if (this.m_currLoop >= this.m_numLoops) {
            return;
        }
        if (this.m_dialog != null) {
            ((Dialog)((Object)this.m_dialog)).setModal(true);
        }
        this.m_thread = new Thread((Runnable)this, "JavaView: " + PsConfig.getMessage((String)"CellOperator"));
        this.m_thread.setPriority(5);
        this.m_thread.start();
    }

    public void setOutputType(int n) {
        this.m_outputType = n;
        if (n == 1) {
            this.m_bUseGlobalElementColor = !this.m_geom.isShowingElementColors();
            this.m_bHasElementColors = this.m_geom.hasElementColors();
            if (this.m_geom.hasElementColors()) {
                this.m_originalColors = this.m_geom.getElementColors();
            }
            this.m_color = new Color[2];
            this.m_color[0] = !this.m_geom.isShowingElementColors() ? new Color(this.m_geom.getGlobalElementColor().getRed(), this.m_geom.getGlobalElementColor().getGreen(), this.m_geom.getGlobalElementColor().getBlue()) : new Color(0, 95, 159);
            this.m_color[1] = new Color(255, 0, 0);
            this.m_geom.assureElementColors();
            this.m_geom.showElementColors(true);
            return;
        }
        if (n == 0) {
            this.m_geom.showTaggedElements(true);
        }
    }

    public void pickInitial(PvPickEvent pvPickEvent) {
        this.markElement(pvPickEvent.getElementInd());
        this.evaluate();
        this.update(this);
    }

    public void setInfluence(String string) {
        if (string.equals(PsConfig.getMessage((String)"NEIGHBOUR"))) {
            this.influence = 0;
            return;
        }
        if (string.equals(PsConfig.getMessage((String)"CORONA"))) {
            this.influence = 1;
        }
    }

    public void restoreColors() {
        this.m_geom.showElementColors(!this.m_bUseGlobalElementColor);
        if (this.m_bHasElementColors) {
            this.m_geom.setElementColors(this.m_originalColors);
        }
    }

    public PnCellOperator(PgElementSet pgElementSet) {
        super("CellOperator");
        this.m_geom = pgElementSet;
        this.addGeometry((PgGeometryIf)this.m_geom);
        this.setName(PsConfig.getMessage((String)"CellOperatorOf") + " " + this.m_geom.getName());
        this.m_markI = new PiVector(this.m_geom.getNumElements());
        this.m_markI.setConstant(0);
        this.m_numStates = 2;
        this.m_bShowTaggedElements = this.m_geom.isShowingTaggedElements();
        if (this.getClass() == (class$jvx$geom$PnCellOperator != null ? class$jvx$geom$PnCellOperator : (class$jvx$geom$PnCellOperator = PnCellOperator.class$("jvx.geom.PnCellOperator")))) {
            this.init();
        }
    }

    public Color getColor(int n) {
        return this.m_color[n];
    }

    public void setColor(int n, Color color) {
        this.m_color[n] = color;
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void releasePick() {
        Enumeration enumeration = this.m_geom.getDisplays();
        while (enumeration != null && enumeration.hasMoreElements()) {
            PvDisplayIf pvDisplayIf = (PvDisplayIf)enumeration.nextElement();
            pvDisplayIf.releasePickFocus();
            pvDisplayIf.removePickListener((PvPickListenerIf)this);
        }
    }

    public void makeNeighbourInfluence() {
        int n = this.m_geom.getNumElements();
        int n2 = 0;
        while (n2 < n) {
            this.m_infCell[n2] = new PiVector(this.m_geomNeighbour[n2].m_data.length + 1);
            this.m_infCell[n2].m_data[0] = n2;
            int n3 = this.m_geomNeighbour[n2].m_data.length;
            int n4 = 0;
            while (n4 < n3) {
                this.m_infCell[n2].m_data[n4 + 1] = this.m_geomNeighbour[n2].m_data[n4];
                ++n4;
            }
            ++n2;
        }
    }

    public void markGlider(int n, int n2) {
        if (this.m_infCell[n].getSize() != 9) {
            PsDebug.warning((String)("Can't generate glider at Cell " + n + " - wrong number of Influence Cells"));
            return;
        }
        this.m_markI.m_data[this.m_infCell[n].m_data[0]] = 0;
        if (this.m_infCell[n].m_data[(1 + n2) % 4 + 1] != -1) {
            this.m_markI.m_data[this.m_infCell[n].m_data[(1 + n2) % 4 + 1]] = 1;
        }
        if (this.m_infCell[n].m_data[(2 + n2) % 4 + 1] != -1) {
            this.m_markI.m_data[this.m_infCell[n].m_data[(2 + n2) % 4 + 1]] = 1;
        }
        if (this.m_infCell[n].m_data[(3 + n2) % 4 + 1] != -1) {
            this.m_markI.m_data[this.m_infCell[n].m_data[(3 + n2) % 4 + 1]] = 1;
        }
        if (this.m_infCell[n].m_data[(4 + n2) % 4 + 1] != -1) {
            this.m_markI.m_data[this.m_infCell[n].m_data[(4 + n2) % 4 + 1]] = 0;
        }
        if (n2 % 8 < 4) {
            if (this.m_infCell[n].m_data[(1 + n2) % 4 + 5] != -1) {
                this.m_markI.m_data[this.m_infCell[n].m_data[(1 + n2) % 4 + 5]] = 1;
            }
            if (this.m_infCell[n].m_data[(2 + n2) % 4 + 5] != -1) {
                this.m_markI.m_data[this.m_infCell[n].m_data[(2 + n2) % 4 + 5]] = 0;
            }
            if (this.m_infCell[n].m_data[(3 + n2) % 4 + 5] != -1) {
                this.m_markI.m_data[this.m_infCell[n].m_data[(3 + n2) % 4 + 5]] = 0;
            }
            if (this.m_infCell[n].m_data[(4 + n2) % 4 + 5] != -1) {
                this.m_markI.m_data[this.m_infCell[n].m_data[(4 + n2) % 4 + 5]] = 1;
                return;
            }
        } else {
            if (this.m_infCell[n].m_data[(1 + n2) % 4 + 5] != -1) {
                this.m_markI.m_data[this.m_infCell[n].m_data[(1 + n2) % 4 + 5]] = 0;
            }
            if (this.m_infCell[n].m_data[(2 + n2) % 4 + 5] != -1) {
                this.m_markI.m_data[this.m_infCell[n].m_data[(2 + n2) % 4 + 5]] = 1;
            }
            if (this.m_infCell[n].m_data[(3 + n2) % 4 + 5] != -1) {
                this.m_markI.m_data[this.m_infCell[n].m_data[(3 + n2) % 4 + 5]] = 1;
            }
            if (this.m_infCell[n].m_data[(4 + n2) % 4 + 5] != -1) {
                this.m_markI.m_data[this.m_infCell[n].m_data[(4 + n2) % 4 + 5]] = 0;
            }
        }
    }

    public void clear() {
        int n = this.m_markI.m_data.length;
        int n2 = 0;
        while (n2 < n) {
            this.m_markI.m_data[n2] = 0;
            ++n2;
        }
        this.evaluate();
    }

    public void makeCoronaInfluence() {
        this.m_vertexStar = new PgVertexStar();
        PiVector piVector = new PiVector();
        int n = this.m_geom.getNumElements();
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.m_geomElement[n2].m_data.length;
            this.m_infCell[n2] = new PiVector(n3 + 1);
            this.m_infCell[n2].m_data[0] = n2;
            int n4 = this.m_geomNeighbour[n2].m_data[n3 - 2];
            int n5 = n3 + 1;
            int n6 = 0;
            while (n6 < n3) {
                int n7;
                int n8;
                this.m_infCell[n2].m_data[n6 + 1] = this.m_geomNeighbour[n2].m_data[n6];
                this.m_vertexStar.makeVertexStar(this.m_geom, this.m_geomElement[n2].m_data[n6], -1);
                piVector.setSize(this.m_vertexStar.getElement().getSize());
                piVector.copy(this.m_vertexStar.getElement());
                int n9 = n4;
                n4 = this.m_geomNeighbour[n2].m_data[(n6 + n3 - 1) % n3];
                if (this.m_vertexStar.getLink().m_data.length == piVector.m_data.length) {
                    this.m_infCell[n2].setSize(this.m_infCell[n2].getSize() + piVector.m_data.length - 3);
                    n8 = piVector.m_data.length;
                    n7 = 0;
                    while (n7 < n8) {
                        if (piVector.m_data[n7] != n2 && piVector.m_data[n7] != n9 && piVector.m_data[n7] != n4) {
                            this.m_infCell[n2].m_data[n5] = piVector.m_data[n7];
                            ++n5;
                        }
                        ++n7;
                    }
                } else {
                    n8 = piVector.m_data.length;
                    n7 = 0;
                    while (n7 < n8) {
                        if (piVector.m_data[n7] != n2 && piVector.m_data[n7] != n9 && piVector.m_data[n7] != n4) {
                            this.m_infCell[n2].setSize(this.m_infCell[n2].getSize() + 1);
                            this.m_infCell[n2].m_data[n5] = piVector.m_data[n7];
                            ++n5;
                        }
                        ++n7;
                    }
                }
                ++n6;
            }
            ++n2;
        }
    }

    public void setColors() {
        int n = this.m_geom.getNumElements();
        int n2 = 0;
        while (n2 < n) {
            this.m_geom.setElementColor(n2, this.m_color[this.m_markI.m_data[n2]]);
            ++n2;
        }
    }

    public void run() {
        while (this.m_thread != null) {
            this.compute();
            ++this.m_currLoop;
            if (this.m_currLoop >= this.m_numLoops) {
                this.stop();
                this.m_panel.m_bOperator.setLabel(PsConfig.getMessage((String)"Start"));
                this.m_panel.m_bSuspend.setEnabled(false);
            }
            this.update(this);
            try {
                Thread.sleep(this.m_sleepTime);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void init() {
        super.init();
        this.m_geom.showTaggedElements(true);
        this.m_markI.setSize(this.m_geom.getNumElements());
        this.m_infCell = new PiVector[this.m_geom.getNumElements()];
        this.m_geomElement = this.m_geom.getElements();
        this.m_geomNeighbour = this.m_geom.getNeighbours();
        this.setNumLoops(1000);
        this.m_sleepTime = 50;
        this.makeInfluence();
        this.evaluate();
        this.update(this);
    }

    public void markElement(int n) {
        if (this.m_bMarkGlider) {
            this.markGlider(n, 1);
            return;
        }
        this.m_markI.m_data[n] = (this.m_markI.m_data[n] + 1) % this.m_numStates;
    }

    public void markElement(int n, int n2) {
        if (n2 > -1 && n2 < this.m_numStates) {
            this.m_markI.m_data[n] = n2;
        }
    }

    public void compute() {
        PiVector piVector = new PiVector(this.m_markI.m_data.length);
        piVector.copy(this.m_markI);
        int n = this.m_markI.m_data.length;
        int n2 = 0;
        while (n2 < n) {
            piVector.m_data[n2] = this.cellOperator(n2);
            ++n2;
        }
        this.m_markI = piVector;
        this.evaluate();
    }

    public int ruleOfMajority(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = this.m_infCell[n].m_data.length;
        int n5 = 0;
        while (n5 < n4) {
            if (this.getState(this.m_infCell[n].m_data[n5]) > -1) {
                n2 += this.getState(this.m_infCell[n].m_data[n5]);
                ++n3;
            }
            ++n5;
        }
        n2 = 2 * n2 > n3 ? 1 : 0;
        return n2;
    }

    public void setElementTags() {
        int n = this.m_geom.getNumElements();
        int n2 = 0;
        while (n2 < n) {
            if (this.m_markI.m_data[n2] > 0) {
                this.m_geom.setTagElement(n2, 1);
            } else {
                this.m_geom.clearTagElement(n2, 1);
            }
            ++n2;
        }
    }

    public int ruleOfLife(int n) {
        int n2 = 0;
        int n3 = this.m_infCell[n].m_data.length;
        int n4 = 0;
        while (n4 < n3) {
            if (this.getState(this.m_infCell[n].m_data[n4]) > 0) {
                n2 += this.getState(this.m_infCell[n].m_data[n4]);
            }
            ++n4;
        }
        n2 = this.m_markI.m_data[this.m_infCell[n].m_data[0]] == 1 ? (n2 > 2 && n2 < 5 ? 1 : 0) : (n2 == 3 ? 1 : 0);
        return n2;
    }
}

