/*
 * Decompiled with CFR 0.152.
 */
package jvx.geom;

import jv.geom.PgElementSet;
import jv.geom.PgPolygon;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.project.PvPickEvent;
import jv.project.PvPickListenerIf;
import jv.vecmath.PdBary;
import jv.vecmath.PdBaryDir;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgPolygonOnElementSet;
import jvx.geom.PgVertexStar;
import jvx.geom.PwBary;
import jvx.geom.PwGeodesic_IP;
import jvx.thirdParty.acmeGui.ErrorBox;
import jvx.thirdParty.acmeGui.OkDialog;

public class PwGeodesic
extends PsObject
implements PvPickListenerIf {
    protected PgElementSet m_geom = null;
    protected boolean m_isShowingElements = false;
    protected PgElementSet m_copy = null;
    protected PvDisplayIf m_disp = null;
    protected PuInteger m_startElem;
    protected PuInteger m_endElem;
    protected PuDouble m_len;
    protected PuDouble m_angle;
    protected PdBary m_startbary = new PdBary(0.3333333333333333, 0.3333333333333333, 0.3333333333333333);
    protected PdBary m_endbary = new PdBary(0.3333333333333333, 0.3333333333333333, 0.3333333333333333);
    protected PgPolygonOnElementSet m_polyOnEs = null;
    protected PgPolygon m_poly = null;
    protected boolean m_pickFirst = true;
    protected boolean m_pick = false;
    private PdVector m_edge = new PdVector(3);
    private PdVector m_dir = new PdVector(3);
    protected static final int SHORTEST = 0;
    protected static final int STRAIGHTEST = 1;
    protected int m_method = 0;
    private static /* synthetic */ Class class$jvx$geom$PwGeodesic;

    public void setPickFirst() {
        this.m_pickFirst = true;
        PwGeodesic_IP pwGeodesic_IP = (PwGeodesic_IP)this.getInfoPanel();
        if (pwGeodesic_IP != null) {
            pwGeodesic_IP.m_cFirst.setState(true);
        }
    }

    protected void setMethodShortest() {
        this.m_method = 0;
        this.m_len.setEnabled(false);
        this.m_angle.setEnabled(false);
        this.m_endElem.setEnabled(true);
        PwGeodesic_IP pwGeodesic_IP = (PwGeodesic_IP)this.getInfoPanel();
        if (pwGeodesic_IP != null) {
            pwGeodesic_IP.m_cLast.setEnabled(true);
        }
        this.showWay(this.m_startElem.getValue(), this.m_startbary, this.m_endElem.getValue(), this.m_endbary);
    }

    public void setStartBary(PdBary pdBary) {
        if (pdBary == null) {
            return;
        }
        this.m_startbary.copy(pdBary);
        this.update(this.m_startElem);
    }

    protected void showWay(int n, PdBary pdBary, int n2, PdBary pdBary2) {
        Object object;
        if (this.m_geom == null) {
            return;
        }
        this.m_polyOnEs = null;
        if (this.m_method == 0) {
            this.m_polyOnEs = PwGeodesic.getShortest(this.m_geom, pdBary, n, pdBary2, n2);
        } else {
            this.m_polyOnEs = new PgPolygonOnElementSet(this.m_geom);
            object = new PdBaryDir(-1.0, 1.0, 0.0);
            PwBary.rotateInElement(this.m_geom, n, (PdBaryDir)object, this.m_angle.getValue() / 180.0 * Math.PI, (PdBaryDir)object, false);
            object.multScalar(1.0 / PwBary.norm(this.m_geom, n, (PdBaryDir)object, false));
            this.m_polyOnEs.exp(n, pdBary, (PdBaryDir)object, this.m_len.getValue());
        }
        if (this.m_polyOnEs != null) {
            this.m_polyOnEs.getPolygon(this.m_poly);
            this.m_poly.setVisible(true);
            this.m_poly.update(null);
            this.m_len.setValue(this.m_poly.getLength());
            if (this.m_method == 0) {
                this.m_dir.copy(this.m_poly.getVertex(1));
                this.m_dir.sub(this.m_poly.getVertex(0));
                object = this.m_geom.getElement(n);
                this.m_edge.copy(this.m_geom.getVertex(object.getEntry(1)));
                this.m_edge.sub(this.m_geom.getVertex(object.getEntry(0)));
                double d = PdVector.angle((PdVector)this.m_dir, (PdVector)this.m_edge);
                if (PdVector.dot((PdVector)this.m_geom.getElementNormal(n), (PdVector)PdVector.crossNew((PdVector)this.m_edge, (PdVector)this.m_dir)) < 0.0) {
                    d *= -1.0;
                }
                this.m_angle.setValue(d);
                return;
            }
            this.m_endElem.setValue(this.m_polyOnEs.getElemInd(this.m_polyOnEs.getNumVertices() - 1));
            this.m_endbary.copy(this.m_polyOnEs.getBary(this.m_polyOnEs.getNumVertices() - 1));
            return;
        }
        this.m_poly.setVisible(false);
        this.m_poly.update(null);
        object = new ErrorBox(PsConfig.getFrame(), "Geodesic computation failed.", "Could not compute a connecting geodesic. Possible reasons: Neighbourhood information (use Method->Apply->Make Neighbour).");
        ((OkDialog)object).show();
    }

    public boolean update(Object object) {
        if (object == null) {
            return super.update(null);
        }
        if (object == this.m_geom) {
            int n = this.m_geom.getNumElements();
            this.m_startElem.setBounds(0, n - 1, 1, 2);
            this.m_endElem.setBounds(0, n - 1, 1, 2);
            this.showWay(this.m_startElem.getValue(), this.m_startbary, this.m_endElem.getValue(), this.m_endbary);
            return super.update(null);
        }
        if (object == this.m_startElem) {
            this.showWay(this.m_startElem.getValue(), this.m_startbary, this.m_endElem.getValue(), this.m_endbary);
            return super.update(null);
        }
        if (object == this.m_endElem) {
            this.showWay(this.m_startElem.getValue(), this.m_startbary, this.m_endElem.getValue(), this.m_endbary);
            return super.update(null);
        }
        if (object == this.m_len) {
            this.showWay(this.m_startElem.getValue(), this.m_startbary, this.m_endElem.getValue(), this.m_endbary);
            return super.update(null);
        }
        if (object == this.m_angle) {
            this.showWay(this.m_startElem.getValue(), this.m_startbary, this.m_endElem.getValue(), this.m_endbary);
            return super.update(null);
        }
        return super.update(object);
    }

    public void setStartElement(int n) {
        this.m_startElem.setValue(n);
        this.update(this.m_startElem);
    }

    public void dragInitial(PvPickEvent pvPickEvent) {
        this.pickInitial(pvPickEvent);
    }

    protected static int[] getConnectingStrip(PgElementSet pgElementSet, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = pgElementSet.getNumElements();
        if (n < 0 || n >= n6 || n2 < 0 || n2 >= n6) {
            PsDebug.warning((String)("Wrong start=" + n + " or end=" + n2 + " element."));
            return null;
        }
        int[] nArray = new int[n6];
        int n7 = 0;
        int n8 = 0;
        int[] nArray2 = new int[n6];
        int[] nArray3 = new int[n6];
        nArray[0] = n;
        nArray2[n] = 1;
        ++n8;
        boolean bl = false;
        if (n == n2) {
            bl = true;
        }
        PiVector[] piVectorArray = pgElementSet.getNeighbours();
        while (!bl && n7 < n8) {
            n5 = nArray[n7];
            int n9 = nArray2[n5];
            PiVector piVector = piVectorArray[n5];
            n4 = piVector.getSize();
            n3 = 0;
            while (n3 < n4) {
                int n10 = piVector.getEntry(n3);
                if (n10 >= 0 && nArray2[n10] == 0) {
                    nArray2[n10] = n9 + 1;
                    nArray[n8] = n10;
                    nArray3[n10] = n5;
                    ++n8;
                    if (n10 == n2) {
                        bl = true;
                        break;
                    }
                }
                ++n3;
            }
            ++n7;
        }
        if (!bl) {
            return null;
        }
        n5 = nArray2[n2];
        int[] nArray4 = new int[n5];
        n4 = n2;
        n3 = n5 - 1;
        while (n3 >= 0) {
            nArray4[n3] = n4;
            if (n4 != n) {
                n4 = nArray3[n4];
            }
            --n3;
        }
        if (nArray4[0] != n) {
            PsDebug.warning((String)"Broken neighbourhood information!");
            return null;
        }
        return nArray4;
    }

    /*
     * Unable to fully structure code
     */
    private static int nextVertexOfShortestInStrip(PdVector var0, PdVector var1_1, PdVector var2_2, PdVector var3_3) {
        var4_4 = new PdVector(2);
        var4_4.set(var0.getEntry(1) - var0.getEntry(0), var1_1.getEntry(1) - var1_1.getEntry(0));
        var4_4.normalize();
        var5_5 = new PdVector[2];
        var6_6 = new PdVector[2];
        var5_5[0] = var0;
        var5_5[1] = var2_2;
        var6_6[0] = var1_1;
        var6_6[1] = var3_3;
        var7_7 = new int[]{var0.getSize(), var2_2.getSize()};
        var8_8 = new PdVector[2];
        var9_9 = new PdVector[2];
        var10_10 = new PdVector(2);
        var11_11 = new PdVector(2);
        var12_12 = 0;
        do {
            var8_8[var12_12] = new PdVector(var7_7[var12_12]);
            var9_9[var12_12] = new PdVector(var7_7[var12_12]);
            var13_13 = 1;
            while (var13_13 < var7_7[var12_12]) {
                block32: {
                    block33: {
                        block34: {
                            block31: {
                                var10_10.set(var5_5[var12_12].getEntry(var13_13) - var5_5[var12_12].getEntry(0), var6_6[var12_12].getEntry(var13_13) - var6_6[var12_12].getEntry(0));
                                var14_14 = var10_10.length();
                                var9_9[var12_12].setEntry(var13_13, var14_14);
                                if (var14_14 != 0.0) break block31;
                                var8_8[var12_12].setEntry(var13_13, 0.0);
                                break block32;
                            }
                            var16_16 = PdVector.dot((PdVector)var10_10, (PdVector)var4_4);
                            if ((var16_16 /= var14_14) < -1.0) {
                                var16_16 = -1.0;
                            } else if (var16_16 > 1.0) {
                                var16_16 = 1.0;
                            }
                            var16_16 = Math.acos(var16_16);
                            if (var4_4.getEntry(0) * var10_10.getEntry(1) - var4_4.getEntry(1) * var10_10.getEntry(0) < 0.0) {
                                var16_16 *= -1.0;
                            }
                            if (var13_13 <= 1) break block33;
                            var18_18 = false;
                            var19_21 = false;
                            var10_10.set(var5_5[var12_12].getEntry(var13_13 - 1) - var5_5[var12_12].getEntry(0), var6_6[var12_12].getEntry(var13_13 - 1) - var6_6[var12_12].getEntry(0));
                            var20_22 = -var10_10.getEntry(1);
                            var22_24 = var10_10.getEntry(0);
                            var11_11.set(var5_5[var12_12].getEntry(var13_13) - var5_5[var12_12].getEntry(var13_13 - 1), var6_6[var12_12].getEntry(var13_13) - var6_6[var12_12].getEntry(var13_13 - 1));
                            var24_26 = var11_11.getEntry(0) * var20_22 + var11_11.getEntry(1) * var22_24;
                            if (var24_26 < -1.0E-10) {
                                var18_18 = true;
                            } else if (var24_26 > 1.0E-10) {
                                var19_21 = true;
                            }
                            var26_27 = var8_8[var12_12].getEntry(var13_13 - 1);
                            if (!var18_18) break block34;
                            while (var16_16 > var26_27 + 1.0E-10) {
                                var16_16 -= 6.283185307179586;
                            }
                            while (var16_16 + 6.283185307179586 < var26_27 + 1.0E-10) {
                                var16_16 += 6.283185307179586;
                            }
                            break block33;
                        }
                        if (!var19_21) ** GOTO lbl70
                        while (var16_16 < var26_27 - 1.0E-10) {
                            var16_16 += 6.283185307179586;
                        }
                        while (var16_16 - 6.283185307179586 > var26_27 - 1.0E-10) {
                            var16_16 -= 6.283185307179586;
                        }
                        break block33;
lbl-1000:
                        // 1 sources

                        {
                            var16_16 -= 6.283185307179586;
lbl70:
                            // 2 sources

                            ** while (Math.abs((double)(var16_16 - 6.283185307179586 - var26_27)) < Math.abs((double)(var16_16 - var26_27)))
                        }
lbl71:
                        // 2 sources

                        while (Math.abs(var16_16 + 6.283185307179586 - var26_27) < Math.abs(var16_16 - var26_27)) {
                            var16_16 += 6.283185307179586;
                        }
                    }
                    var8_8[var12_12].setEntry(var13_13, var16_16);
                }
                ++var13_13;
            }
        } while (++var12_12 < 2);
        var12_12 = 1;
        var13_13 = 0;
        var14_15 = 0;
        var15_28 = 1;
        var16_17 = 1;
        var17_29 = 0;
        while (var13_13 == 0) {
            if (var17_29 > 3) {
                PsDebug.error((String)"Caught in loop.");
            }
            if (var17_29 > 3) break;
            do {
                if (var12_12 == var7_7[var14_15] - 1) {
                    var13_13 = 1;
                    continue;
                }
                if ((double)var16_17 * var8_8[var14_15].getEntry(var12_12) > (double)var16_17 * var8_8[var14_15].getEntry(var12_12 + 1)) {
                    ++var12_12;
                    continue;
                }
                var13_13 = 1;
            } while (var13_13 == 0);
            var18_20 = var8_8[var14_15].getEntry(var12_12);
            var20_23 = -1;
            var21_30 = var12_12 + 1;
            var13_13 = 0;
            while (var21_30 < var7_7[var14_15] && var13_13 == 0) {
                if ((double)var16_17 * var8_8[var14_15].getEntry(var21_30) < (double)var16_17 * var18_20) {
                    var13_13 = 1;
                    continue;
                }
                ++var21_30;
            }
            if (var13_13 != 0) {
                var20_23 = var21_30;
            }
            var22_25 = -1;
            var21_30 = 1;
            var13_13 = 0;
            do {
                if ((double)var16_17 * var8_8[var15_28].getEntry(var21_30) > (double)var16_17 * var18_20) {
                    var13_13 = 1;
                    continue;
                }
                ++var21_30;
            } while (var21_30 < var7_7[var15_28] && var13_13 == 0);
            if (var13_13 != 0) {
                var22_25 = var21_30;
            }
            var13_13 = 0;
            var23_31 = var9_9[var14_15].getEntry(var12_12);
            var25_32 = var8_8[var14_15].getEntry(var12_12);
            var27_33 = 0.0;
            if (var20_23 > 0) {
                var27_33 = (var8_8[var14_15].getEntry(var12_12) - var8_8[var14_15].getEntry(var20_23 - 1)) / (var8_8[var14_15].getEntry(var20_23) - var8_8[var14_15].getEntry(var20_23 - 1)) * (var9_9[var14_15].getEntry(var20_23) - var9_9[var14_15].getEntry(var20_23 - 1)) + var9_9[var14_15].getEntry(var20_23 - 1);
            }
            var29_34 = 0.0;
            if (var22_25 > 0) {
                var29_34 = (var8_8[var14_15].getEntry(var12_12) - var8_8[var15_28].getEntry(var22_25 - 1)) / (var8_8[var15_28].getEntry(var22_25) - var8_8[var15_28].getEntry(var22_25 - 1)) * (var9_9[var15_28].getEntry(var22_25) - var9_9[var15_28].getEntry(var22_25 - 1)) + var9_9[var15_28].getEntry(var22_25 - 1);
            }
            if (var20_23 < 0 && var22_25 < 0 || var22_25 == var7_7[var15_28] - 1 && var12_12 == var7_7[var14_15] - 1) {
                var12_12 *= var16_17;
                var13_13 = 1;
                continue;
            }
            if (var20_23 >= 0 && (var22_25 < 0 || var27_33 < var29_34)) {
                var12_12 = var20_23;
                continue;
            }
            if (var22_25 >= 0 && (var23_31 > var29_34 || (double)var16_17 * var25_32 < (double)var16_17 * var8_8[var15_28].getEntry(1))) {
                var14_15 = (var14_15 + 1) % 2;
                var15_28 = (var15_28 + 1) % 2;
                var16_17 *= -1;
                var12_12 = 1;
                ++var17_29;
                continue;
            }
            var12_12 *= var16_17;
            var13_13 = 1;
        }
        return var12_12;
    }

    public void dragVertex(PgGeometryIf pgGeometryIf, int n, PdVector pdVector) {
    }

    public String getName() {
        return "PwGeodesic";
    }

    public PgPolygon getPolygon() {
        return this.m_poly;
    }

    public void setPickLast() {
        this.m_pickFirst = false;
        PwGeodesic_IP pwGeodesic_IP = (PwGeodesic_IP)this.getInfoPanel();
        if (pwGeodesic_IP != null) {
            pwGeodesic_IP.m_cLast.setState(true);
        }
    }

    public void setMethodStraightest() {
        this.m_method = 1;
        this.m_endElem.setEnabled(false);
        this.m_len.setEnabled(true);
        this.m_angle.setEnabled(true);
        PwGeodesic_IP pwGeodesic_IP = (PwGeodesic_IP)this.getInfoPanel();
        if (pwGeodesic_IP != null) {
            pwGeodesic_IP.m_cLast.setEnabled(false);
            pwGeodesic_IP.m_cFirst.setState(true);
        }
        this.setPickFirst();
        this.showWay(this.m_startElem.getValue(), this.m_startbary, this.m_endElem.getValue(), this.m_endbary);
    }

    public void unmarkVertices(PvPickEvent pvPickEvent) {
    }

    /*
     * Unable to fully structure code
     */
    public static PgPolygon[] getShortestInStrip(PgElementSet var0, PdBary var1_1, PdBary var2_2, int[] var3_3, PiVector var4_4, PiVector var5_5, PdBaryDir var6_6) {
        if (var0 == null || var0.getDimOfElements() != 3) {
            PsDebug.warning((String)"Geometry not triangulated.");
            return null;
        }
        if (var3_3 == null || var3_3.length == 0) {
            PsDebug.warning((String)"Not a valid strip.");
            return null;
        }
        if (var4_4 != null) {
            var4_4.setSize(0);
        }
        if (var5_5 != null) {
            var5_5.setSize(0);
        }
        if ((var7_7 = var3_3.length) == 1) {
            return null;
        }
        var8_8 = var0.getElements();
        var9_9 = var0.getNeighbour(var3_3[0]);
        var10_10 = -1;
        var11_11 = 0;
        do {
            if (var9_9.getEntry(var11_11) != var3_3[1]) continue;
            var10_10 = var11_11;
        } while (++var11_11 < 3);
        if (var10_10 == -1) {
            PsDebug.warning((String)"Not a valid strip (not connected).");
            return null;
        }
        var11_12 = new PdBaryDir(3);
        var12_13 = new PdBaryDir(3);
        var13_14 = new PdBary(3);
        var14_15 = new PdBary(3);
        var15_16 = new PdVector[2];
        var16_17 = new PdVector[2];
        var17_18 = new PiVector[2];
        var18_19 = 0;
        var19_20 = 0;
        do {
            var15_16[var19_20] = new PdVector(3 * var7_7);
            var16_17[var19_20] = new PdVector(3 * var7_7);
            var17_18[var19_20] = new PiVector(3 * var7_7);
            var20_22 = 2;
            var21_23 = 1;
            if (var19_20 == 1) {
                var20_22 = 1;
                var21_23 = 2;
            }
            var13_14.m_data[(var10_10 + var20_22) % 3] = 1.0;
            var13_14.m_data[var10_10] = 0.0;
            var13_14.m_data[(var10_10 + var21_23) % 3] = 0.0;
            var11_12.sub(var1_1, var13_14);
            var14_15.m_data[(var10_10 + var20_22) % 3] = 0.0;
            var14_15.m_data[var10_10] = 0.0;
            var14_15.m_data[(var10_10 + var21_23) % 3] = 1.0;
            var12_13.sub(var14_15, var13_14);
            var22_24 = Math.abs(PwBary.getOrientedAngle(var0, var3_3[0], var11_12, var12_13, false));
            var24_27 = PwBary.norm(var0, var3_3[0], var11_12, false);
            var26_31 = 0.0;
            if (var19_20 == 1) {
                var11_12.multScalar(-1.0);
                var12_13.sub(var14_15, var1_1);
                var26_31 = -Math.abs(PwBary.getOrientedAngle(var0, var3_3[0], var12_13, var11_12, false));
                var28_35 = new PdVector(var24_27 * Math.cos(var26_31), var24_27 * Math.sin(var26_31));
            } else {
                var28_35 = new PdVector(var24_27, 0.0);
            }
            var29_38 = new PdVector(2);
            var29_38.copy(var28_35);
            var29_38.multScalar(-1.0);
            var30_40 = (var10_10 + var20_22) % 3;
            var31_41 = var8_8[var3_3[0]].getEntry(var30_40);
            var15_16[var19_20].setEntry(0, 0.0);
            var16_17[var19_20].setEntry(0, 0.0);
            var17_18[var19_20].setEntry(0, -1);
            var15_16[var19_20].setEntry(1, var28_35.getEntry(0));
            var16_17[var19_20].setEntry(1, var28_35.getEntry(1));
            var17_18[var19_20].setEntry(1, var31_41);
            var18_19 = 2;
            var32_42 = 0;
            while (var32_42 + 1 < var7_7) {
                var33_43 = 1;
                var34_44 = var32_42;
                while (var33_43 != 0) {
                    if (++var32_42 >= var7_7) {
                        var33_43 = 0;
                        break;
                    }
                    var33_43 = 0;
                    var35_46 = 0;
                    while (var35_46 < 3 && var33_43 == 0) {
                        if (var8_8[var3_3[var32_42]].getEntry(var35_46) == var31_41) {
                            var33_43 = 1;
                            var30_40 = var35_46;
                        }
                        ++var35_46;
                    }
                    if (var33_43 == 0) continue;
                    var11_12.m_data[var30_40] = -1.0;
                    var11_12.m_data[(var30_40 + var20_22) % 3] = 0.0;
                    var11_12.m_data[(var30_40 + var21_23) % 3] = 1.0;
                    if (var32_42 != var7_7 - 1) {
                        var12_13.m_data[var30_40] = -1.0;
                        var12_13.m_data[(var30_40 + var20_22) % 3] = 1.0;
                        var12_13.m_data[(var30_40 + var21_23) % 3] = 0.0;
                    } else {
                        var13_14.m_data[var30_40] = 1.0;
                        var13_14.m_data[(var30_40 + var20_22) % 3] = 0.0;
                        var13_14.m_data[(var30_40 + var21_23) % 3] = 0.0;
                        var12_13.sub(var2_2, var13_14);
                    }
                    var22_24 += Math.abs(PwBary.getOrientedAngle(var0, var3_3[var32_42], var11_12, var12_13, false));
                    var24_27 = PwBary.norm(var0, var3_3[var32_42], var12_13, false);
                }
                if (--var32_42 == var34_44) {
                    PsDebug.warning((String)"Not a valid strip (not connected).");
                    return null;
                }
                if (var19_20 == 1) {
                    var22_24 *= -1.0;
                }
                var29_38.normalize();
                var35_45 = var29_38.getEntry(0);
                var37_48 = var29_38.getEntry(1);
                var29_38.setEntry(0, Math.cos(var22_24) * var35_45 - Math.sin(var22_24) * var37_48);
                var29_38.setEntry(1, Math.sin(var22_24) * var35_45 + Math.cos(var22_24) * var37_48);
                var29_38.multScalar(var24_27);
                var28_35.add(var29_38);
                var29_38.multScalar(-1.0);
                var15_16[var19_20].setEntry(var18_19, var28_35.getEntry(0));
                var16_17[var19_20].setEntry(var18_19, var28_35.getEntry(1));
                var30_40 = (var30_40 + var20_22) % 3;
                var31_41 = var8_8[var3_3[var32_42]].getEntry(var30_40);
                var17_18[var19_20].setEntry(var18_19, var31_41);
                ++var18_19;
                var11_12.m_data[var30_40] = -1.0;
                var11_12.m_data[(var30_40 + var20_22) % 3] = 0.0;
                var11_12.m_data[(var30_40 + var21_23) % 3] = 1.0;
                var12_13.m_data[var30_40] = -1.0;
                var12_13.m_data[(var30_40 + var20_22) % 3] = 1.0;
                var12_13.m_data[(var30_40 + var21_23) % 3] = 0.0;
                var22_24 = Math.abs(PwBary.getOrientedAngle(var0, var3_3[var32_42], var11_12, var12_13, false));
            }
            var15_16[var19_20].setSize(var18_19);
            var16_17[var19_20].setSize(var18_19);
            var17_18[var19_20].setEntry(var18_19 - 1, -1);
            var17_18[var19_20].setSize(var18_19);
        } while (++var19_20 < 2);
        var19_21 = new PgPolygon[3];
        var20_22 = 0;
        do {
            var19_21[var20_22] = new PgPolygon(2);
            var21_23 = var17_18[var20_22].getSize();
            var19_21[var20_22].setNumVertices(var21_23);
            var22_26 = 0;
            while (var22_26 < var21_23) {
                var23_50 = new PdVector(var15_16[var20_22].getEntry(var22_26), var16_17[var20_22].getEntry(var22_26));
                var19_21[var20_22].setVertex(var22_26, var23_50);
                ++var22_26;
            }
        } while (++var20_22 < 2);
        var20_22 = 1;
        var21_23 = 0;
        var23_51 = false;
        var19_21[2] = new PgPolygon(2);
        var19_21[2].setDimOfVectors(2);
        var19_21[2].setNumVertices(1);
        var19_21[2].setVertex(0, new PdVector(var15_16[0].getEntry(0), var16_17[0].getEntry(0)));
        do {
            block48: {
                ++var20_22;
                var22_26 = PwGeodesic.nextVertexOfShortestInStrip(var15_16[0], var16_17[0], var15_16[1], var16_17[1]);
                var24_29 = 0;
                var25_52 = false;
                if (var22_26 < 0) {
                    var24_29 = 1;
                    if ((var22_26 *= -1) == var15_16[1].getSize() - 1) {
                        var23_51 = true;
                    } else if (var22_26 == var15_16[1].getSize() - 2) {
                        var23_51 = true;
                        var25_52 = true;
                    }
                } else if (var22_26 == var15_16[0].getSize() - 1) {
                    var23_51 = true;
                } else if (var22_26 == var15_16[0].getSize() - 2) {
                    var23_51 = true;
                    var25_52 = true;
                }
                var19_21[2].setNumVertices(var20_22);
                var19_21[2].setVertex(var20_22 - 1, new PdVector(var15_16[var24_29].getEntry(var22_26), var16_17[var24_29].getEntry(var22_26)));
                if (var25_52) {
                    var19_21[2].setNumVertices(++var20_22);
                    var19_21[2].setVertex(var20_22 - 1, new PdVector(var15_16[0].getEntry(var15_16[0].getSize() - 1), var16_17[0].getEntry(var16_17[0].getSize() - 1)));
                }
                var26_33 = var17_18[var24_29].getEntry(var22_26);
                if (var25_52 || !var23_51) {
                    ++var21_23;
                    if (var5_5 != null) {
                        var5_5.setSize(var21_23);
                        var5_5.setEntry(var21_23 - 1, var26_33);
                    }
                    if (var4_4 != null) {
                        var4_4.setSize(var21_23);
                        var4_4.setEntry(var21_23 - 1, var24_29);
                    }
                }
                if (var23_51) continue;
                var27_53 = 0;
                var28_37 = (var24_29 + 1) % 2;
                if (var24_29 == 0) {
                    var29_39 = 2;
                    var30_40 = 1;
                } else {
                    var29_39 = 1;
                    var30_40 = 2;
                }
                var31_41 = var17_18[var24_29].getEntry(var22_26 + 1);
                var32_42 = -1;
                var33_43 = 0;
                var34_44 = 0;
                while (var34_44 < var7_7) {
                    var33_43 = 0;
                    while (var33_43 < 3 && var8_8[var3_3[var34_44]].getEntry(var33_43) != var26_33) {
                        ++var33_43;
                    }
                    if (var33_43 < 3 && var8_8[var3_3[var34_44]].getEntry((var33_43 + var29_39) % 3) == var31_41) {
                        var32_42 = var34_44;
                        break;
                    }
                    ++var34_44;
                }
                var34_44 = var8_8[var3_3[var32_42]].getEntry((var33_43 + var30_40) % 3);
                var35_47 = 0;
                do {
                    ++var35_47;
                    var36_54 = 0;
                    while (var36_54 < 3 && var8_8[var3_3[var32_42 + var35_47]].getEntry(var36_54) != var34_44) {
                        ++var36_54;
                    }
                    if (var36_54 >= 3) continue;
                    var33_43 = var36_54;
                } while (var36_54 < 3 && var32_42 + var35_47 < var7_7 - 1);
                if (var36_54 >= 3) {
                    --var35_47;
                }
                var37_49 = var8_8[var3_3[var32_42 + var35_47]].getEntry((var33_43 + var30_40) % 3);
                if (var32_42 + var35_47 != var7_7 - 1) ** GOTO lbl243
                var27_53 = var15_16[var28_37].getSize() - 2;
                break block48;
lbl-1000:
                // 1 sources

                {
                    ++var27_53;
lbl243:
                    // 2 sources

                    ** while (var27_53 < var15_16[var28_37].getSize() - 1 && (var17_18[var28_37].getEntry((int)var27_53) != var34_44 || var17_18[var28_37].getEntry((int)(var27_53 + 1)) != var37_49))
                }
            }
            var38_55 = var22_26;
            while (var38_55 < var15_16[var24_29].getSize()) {
                var15_16[var24_29].setEntry(var38_55 - var22_26, var15_16[var24_29].getEntry(var38_55));
                var16_17[var24_29].setEntry(var38_55 - var22_26, var16_17[var24_29].getEntry(var38_55));
                var17_18[var24_29].setEntry(var38_55 - var22_26, var17_18[var24_29].getEntry(var38_55));
                ++var38_55;
            }
            var15_16[var24_29].setSize(var15_16[var24_29].getSize() - var22_26);
            var16_17[var24_29].setSize(var16_17[var24_29].getSize() - var22_26);
            var17_18[var24_29].setSize(var17_18[var24_29].getSize() - var22_26);
            var15_16[var28_37].setEntry(0, var15_16[var24_29].getEntry(0));
            var16_17[var28_37].setEntry(0, var16_17[var24_29].getEntry(0));
            var17_18[var28_37].setEntry(0, var17_18[var24_29].getEntry(0));
            var38_55 = var27_53;
            while (var38_55 < var15_16[var28_37].getSize()) {
                var15_16[var28_37].setEntry(var38_55 - var27_53 + 1, var15_16[var28_37].getEntry(var38_55));
                var16_17[var28_37].setEntry(var38_55 - var27_53 + 1, var16_17[var28_37].getEntry(var38_55));
                var17_18[var28_37].setEntry(var38_55 - var27_53 + 1, var17_18[var28_37].getEntry(var38_55));
                ++var38_55;
            }
            var15_16[var28_37].setSize(var15_16[var28_37].getSize() - var27_53 + 1);
            var16_17[var28_37].setSize(var16_17[var28_37].getSize() - var27_53 + 1);
            var17_18[var28_37].setSize(var17_18[var28_37].getSize() - var27_53 + 1);
        } while (!var23_51);
        if (var6_6 != null) {
            var24_30 = -PdVector.angle((PdVector)new PdVector(1.0, 0.0), (PdVector)var19_21[2].getVertex(1)) / 180.0 * 3.141592653589793;
            var13_14.m_data[(var10_10 + 2) % 3] = 1.0;
            var13_14.m_data[var10_10] = 0.0;
            var13_14.m_data[(var10_10 + 1) % 3] = 0.0;
            var11_12.sub(var13_14, var1_1);
            PwBary.rotateInElement(var0, var3_3[0], var11_12, var24_30, var6_6, false);
            var26_34 = PwBary.norm(var0, var3_3[0], var6_6, false);
            if (var26_34 > 1.0E-10) {
                var6_6.multScalar(1.0 / var26_34);
            }
        }
        return var19_21;
    }

    public static PgPolygonOnElementSet getShortest(PgElementSet pgElementSet, PdBary pdBary, int n, PdBary pdBary2, int n2) {
        int n3;
        PdBaryDir pdBaryDir;
        int n4;
        if (pgElementSet == null) {
            PsDebug.warning((String)"No valid geometry.");
            return null;
        }
        if (n2 >= pgElementSet.getNumElements() || n >= pgElementSet.getNumElements() || n < 0 || n2 < 0) {
            PsDebug.warning((String)("No valid start and/or end element,start=" + n + ",end=" + n2 + "."));
            return null;
        }
        int[] nArray = PwGeodesic.getConnectingStrip(pgElementSet, n, n2);
        if (nArray == null) {
            return null;
        }
        if (nArray.length == 1) {
            PgPolygonOnElementSet pgPolygonOnElementSet = new PgPolygonOnElementSet(pgElementSet);
            pgPolygonOnElementSet.setNumVertices(2);
            pgPolygonOnElementSet.setVertex(0, n, pdBary);
            pgPolygonOnElementSet.setVertex(1, n2, pdBary2);
            return pgPolygonOnElementSet;
        }
        boolean bl = false;
        PiVector piVector = new PiVector(1);
        PiVector piVector2 = new PiVector(1);
        PgPolygon pgPolygon = null;
        PgPolygon[] pgPolygonArray = null;
        PdBaryDir pdBaryDir2 = new PdBaryDir(3);
        PdVector pdVector = new PdVector(0);
        int n5 = 0;
        while (!bl) {
            if (++n5 > 2000) {
                PsDebug.error((String)"Caught in loop.");
            }
            if (n5 > 2005) break;
            pgPolygonArray = PwGeodesic.getShortestInStrip(pgElementSet, pdBary, pdBary2, nArray, piVector2, piVector, pdBaryDir2);
            if (pgPolygonArray == null || pgPolygonArray.length < 3 || pgPolygonArray[2] == null) {
                PsDebug.warning((String)"Could not compute straightest way, fatal error!");
                return null;
            }
            pgPolygon = pgPolygonArray[2];
            int n6 = piVector.getSize();
            pdVector.setSize(n6);
            bl = true;
            double d = 1.5E-5 * (double)(nArray.length - 1) + 1.0E-10;
            n4 = 0;
            while (n4 < n6 && bl) {
                pdBaryDir = new PdVector(2);
                pdBaryDir.sub(pgPolygon.getVertex(n4 + 1), pgPolygon.getVertex(n4));
                PdVector pdVector2 = new PdVector(2);
                pdVector2.sub(pgPolygon.getVertex(n4 + 1), pgPolygon.getVertex(n4 + 2));
                double d2 = PdVector.angle((PdVector)pdBaryDir, (PdVector)pdVector2) / 180.0 * Math.PI;
                if (piVector2.getEntry(n4) == 0) {
                    if (pdBaryDir.getEntry(0) * pdVector2.getEntry(1) - pdBaryDir.getEntry(1) * pdVector2.getEntry(0) < 0.0) {
                        d2 = Math.PI * 2 - d2;
                    }
                    pdVector.setEntry(n4, d2);
                } else {
                    if (pdVector2.getEntry(0) * pdBaryDir.getEntry(1) - pdVector2.getEntry(1) * pdBaryDir.getEntry(0) < 0.0) {
                        d2 = Math.PI * 2 - d2;
                    }
                    pdVector.setEntry(n4, -d2);
                }
                int n7 = piVector.getEntry(n4);
                PiVector[] piVectorArray = pgElementSet.getElements();
                n3 = -1;
                int n8 = -1;
                int n9 = 0;
                while (n9 < nArray.length && n3 == -1) {
                    int n10 = 0;
                    do {
                        if (piVectorArray[nArray[n9]].getEntry(n10) != n7) continue;
                        n8 = n9;
                        n3 = nArray[n9];
                        break;
                    } while (++n10 < 3);
                    ++n9;
                }
                PgVertexStar pgVertexStar = new PgVertexStar();
                pgVertexStar.makeVertexStar(pgElementSet, piVector.getEntry(n4), n3);
                if (pgVertexStar.isClosed()) {
                    double d3 = PwBary.getVertexAngles(pgVertexStar, pgElementSet, new PdVector());
                    pdVector.setEntry(n4, pdVector.getEntry(n4) / d3 * 2.0 * Math.PI);
                    double d4 = d3 - Math.PI * 2;
                    if (d4 < -d || d2 < (d3 - d4) / 2.0 - d || d2 > (d3 + d4) / 2.0 + d) {
                        bl = false;
                        int n11 = pgVertexStar.getSize();
                        PiVector piVector3 = pgVertexStar.getElement();
                        int n12 = n8 + 1;
                        int n13 = nArray[n12];
                        int n14 = 0;
                        int n15 = 1;
                        if (piVector3.getEntry(1) != n13) {
                            n15 = -1;
                        }
                        n14 += n15;
                        while (n12 < nArray.length - 1 && piVector3.getEntry((n14 + n11) % n11) == nArray[n12]) {
                            n14 += n15;
                            ++n12;
                        }
                        if (piVector3.getEntry((n14 + n11) % n11) != nArray[n12]) {
                            --n12;
                            n14 -= n15;
                        }
                        int n16 = n8 + 1 + (nArray.length - n12) + (n11 - Math.abs(n14) - 1);
                        int[] nArray2 = new int[n16];
                        int n17 = 0;
                        while (n17 <= n8) {
                            nArray2[n17] = nArray[n17];
                            ++n17;
                        }
                        n15 *= -1;
                        n17 = n11 - Math.abs(n14) - 1;
                        int n18 = 1;
                        while (n18 <= n17) {
                            nArray2[n8 + n18] = piVector3.getEntry((n18 * n15 + n11) % n11);
                            ++n18;
                        }
                        n18 = 0;
                        while (n18 < nArray.length - n12) {
                            nArray2[n8 + n17 + n18 + 1] = nArray[n12 + n18];
                            ++n18;
                        }
                        nArray = nArray2;
                    }
                }
                ++n4;
            }
        }
        PgPolygonOnElementSet pgPolygonOnElementSet = new PgPolygonOnElementSet(pgElementSet);
        PgPolygonOnElementSet pgPolygonOnElementSet2 = new PgPolygonOnElementSet(pgElementSet);
        pgPolygonOnElementSet2.setAccuracy(1.0000000000000001E-11);
        PdBary pdBary3 = new PdBary(3);
        pdBary3.copy(pdBary);
        n4 = nArray[0];
        pdBaryDir = new PdBaryDir(3);
        pdBaryDir.copy(pdBaryDir2);
        pgPolygonOnElementSet.setNumVertices(1);
        pgPolygonOnElementSet.setVertex(0, n4, pdBary3);
        int n19 = pgPolygon.getNumVertices() - 1;
        int n20 = 1;
        int n21 = 0;
        while (n21 < n19) {
            double d = PdVector.dist((PdVector)pgPolygon.getVertex(n21), (PdVector)pgPolygon.getVertex(n21 + 1));
            if (n21 < n19 - 1) {
                d -= PgPolygonOnElementSet.BARYEPS;
            }
            pdBaryDir = pgPolygonOnElementSet2.exp(n4, pdBary3, pdBaryDir, d);
            pdBaryDir.multScalar(-1.0);
            pgPolygonOnElementSet.setNumVertices(n20 - 1);
            pgPolygonOnElementSet.addPolygon(pgPolygonOnElementSet2);
            if (n21 < n19 - 1) {
                n20 = pgPolygonOnElementSet.getNumVertices();
                n4 = pgPolygonOnElementSet.getElemInd(n20 - 1);
                pdBary3 = pgPolygonOnElementSet.getBary(n20 - 1);
                n3 = 0;
                double d5 = 0.0;
                int n22 = 0;
                do {
                    if (!(pdBary3.m_data[n22] > d5)) continue;
                    d5 = pdBary3.m_data[n22];
                    n3 = n22;
                } while (++n22 < 3);
                pdBary3.m_data[n3] = 1.0;
                pdBary3.m_data[(n3 + 1) % 3] = 0.0;
                pdBary3.m_data[(n3 + 2) % 3] = 0.0;
                pgPolygonOnElementSet.setVertex(n20 - 1, n4, pdBary3);
                n4 = PwBary.rotateAtVertex(pgElementSet, n4, n3, pdBaryDir, pdBaryDir, pdBary3, pdVector.getEntry(n21));
            }
            ++n21;
        }
        return pgPolygonOnElementSet;
    }

    public void pickInitial(PvPickEvent pvPickEvent) {
        if (!this.m_pick || pvPickEvent.getElemInd() < 0 || pvPickEvent.getElementSubInd() < 0) {
            return;
        }
        if (this.m_pickFirst) {
            this.m_startbary = pvPickEvent.getBary();
            this.m_startElem.setValue(pvPickEvent.getElemInd());
        } else {
            this.m_endbary = pvPickEvent.getBary();
            this.m_endElem.setValue(pvPickEvent.getElemInd());
        }
        this.showWay(this.m_startElem.getValue(), this.m_startbary, this.m_endElem.getValue(), this.m_endbary);
    }

    public void setEndBary(PdBary pdBary) {
        if (pdBary == null) {
            return;
        }
        this.m_endbary.copy(pdBary);
        this.update(this.m_endElem);
    }

    public void cancel() {
        if (this.m_geom != null) {
            this.m_geom.copy((PgGeometry)this.m_copy);
            this.m_geom.showElements(this.m_isShowingElements);
            this.m_geom.update((Object)this.m_geom);
        }
        this.close();
    }

    public void markVertices(PvPickEvent pvPickEvent) {
    }

    public void close() {
        this.setGeometry(null);
        if (this.m_disp != null && this.m_poly != null) {
            this.m_disp.removeGeometry((PgGeometryIf)this.m_poly);
            this.m_disp.removePickListener((PvPickListenerIf)this);
            this.m_disp.update(null);
        }
    }

    public void setDisplay(PvDisplayIf pvDisplayIf) {
        if (this.m_disp != null) {
            this.m_disp.removePickListener((PvPickListenerIf)this);
            this.m_disp.removeGeometry((PgGeometryIf)this.m_poly);
        }
        this.m_disp = pvDisplayIf;
        if (pvDisplayIf == null) {
            return;
        }
        this.m_disp.addPickListener((PvPickListenerIf)this);
        this.m_disp.addGeometry((PgGeometryIf)this.m_poly);
    }

    public PvDisplayIf getDisplay() {
        return this.m_disp;
    }

    public PwGeodesic() {
        this.m_startElem = new PuInteger("From Element", (PsUpdateIf)this);
        this.m_endElem = new PuInteger("To Element", (PsUpdateIf)this);
        this.m_len = new PuDouble("Length", (PsUpdateIf)this);
        this.m_angle = new PuDouble("Angle (degree)", (PsUpdateIf)this);
        this.m_poly = new PgPolygon(3);
        this.m_poly.setName("Shortest Geodesic");
        this.m_poly.setGlobalPolygonSize(2.0);
        this.m_startElem.setDefBounds(0, 0, 1, 2);
        this.m_startElem.setDefValue(0);
        this.m_startElem.init();
        this.m_endElem.setDefBounds(0, 0, 1, 2);
        this.m_endElem.setDefValue(0);
        this.m_endElem.init();
        if (((Object)((Object)this)).getClass() == (class$jvx$geom$PwGeodesic != null ? class$jvx$geom$PwGeodesic : (class$jvx$geom$PwGeodesic = PwGeodesic.class$("jvx.geom.PwGeodesic")))) {
            this.init();
        }
    }

    public void setEndElement(int n) {
        this.m_endElem.setValue(n);
        this.update(this.m_endElem);
    }

    protected void fixpolygon() {
        this.m_poly = new PgPolygon(3);
        this.m_poly.setName("Shortest Geodesic");
        if (this.m_disp != null) {
            this.m_disp.addGeometry((PgGeometryIf)this.m_poly);
        }
        this.init();
    }

    public PgPolygonOnElementSet getPolygonOnElementSet() {
        return this.m_polyOnEs;
    }

    public void selectGeometry(PgGeometryIf pgGeometryIf) {
        if (pgGeometryIf == this.m_geom) {
            this.m_pick = true;
            return;
        }
        this.m_pick = false;
    }

    public void setGeometry(PgElementSet pgElementSet) {
        if (pgElementSet == null) {
            if (this.m_geom != null) {
                this.m_geom.removeUpdateListener((PsUpdateIf)this);
                if (!this.m_geom.isShowingElements()) {
                    this.m_geom.showElements(this.m_isShowingElements);
                    this.m_geom.update((Object)this.m_geom);
                }
            }
            this.m_geom = null;
            this.m_pick = false;
            return;
        }
        if (pgElementSet.getDimOfElements() != 3) {
            PsDebug.warning((String)"Not triangulated.");
            this.m_pick = false;
            return;
        }
        this.m_pick = true;
        if (this.m_geom != null) {
            this.m_geom.removeUpdateListener((PsUpdateIf)this);
        }
        this.m_geom = pgElementSet;
        this.m_copy = (PgElementSet)this.m_geom.clone();
        this.m_isShowingElements = this.m_geom.isShowingElements();
        this.m_geom.showElements(false);
        this.m_geom.addUpdateListener((PsUpdateIf)this);
        this.m_geom.makeElementNormals();
        this.update(this.m_geom);
        double d = this.m_geom.getDiameter() * 5.0;
        this.m_len.setBounds(0.0, d, d / 100.0, d / 50.0);
        this.m_len.setValue(d / 50.0);
        int n = this.m_geom.getNumElements();
        this.m_startElem.setValue(n / 3);
        this.m_endElem.setValue(2 * n / 3);
    }

    public PgElementSet getGeometry() {
        return this.m_geom;
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void dragDisplay(PvPickEvent pvPickEvent) {
    }

    public void pickDisplay(PvPickEvent pvPickEvent) {
    }

    public void init() {
        super.init();
        this.m_len.setDefBounds(0.0, 200.0, 0.5, 5.0);
        this.m_len.setDefValue(0.1);
        this.m_len.init();
        this.m_angle.setDefBounds(-180.0, 180.0, 1.0, 10.0);
        this.m_angle.setDefValue(0.0);
        this.m_angle.init();
        this.update(this.m_geom);
        this.setMethodShortest();
    }

    public void pickVertex(PgGeometryIf pgGeometryIf, int n, PdVector pdVector) {
    }
}

