/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

public class PnNoise {
    private static final int TABSIZE = 256;
    private float[] gradTab = new float[512];
    private float[] valueTab = new float[256];
    private int[] perm = new int[256];

    public PnNoise() {
        int n = 0;
        do {
            this.perm[n] = (int)(Math.random() * 255.0 + 0.5);
        } while (++n < 256);
        n = 0;
        do {
            this.valueTab[n] = (float)Math.random() * 2.0f - 1.0f;
        } while (++n < 256);
        n = 0;
        do {
            float f = (float)(Math.PI * 2 * Math.random());
            this.gradTab[n * 2] = (float)Math.cos(f);
            this.gradTab[n * 2 + 1] = (float)Math.sin(f);
        } while (++n < 256);
    }

    protected int index(int n, int n2) {
        return this.perm[(n + this.perm[n2]) % 256];
    }

    public float noise(float f, float f2) {
        int n = (int)f;
        int n2 = (int)f2;
        float f3 = f - (float)n;
        float f4 = 1.0f - f3;
        float f5 = f2 - (float)n2;
        float f6 = 1.0f - f5;
        float f7 = this.glattice(n %= 255, n2 %= 255, f3, f5);
        float f8 = this.glattice(n + 1, n2, f4, f5);
        float f9 = this.glattice(n, n2 + 1, f3, f6);
        float f10 = this.glattice(n + 1, n2 + 1, f4, f6);
        float f11 = f7 + this.smoothstep(f3) * (f8 - f7);
        float f12 = f9 + this.smoothstep(f3) * (f10 - f9);
        float f13 = f11 + this.smoothstep(f5) * (f12 - f11);
        float f14 = this.valueTab[this.index(n, n2)];
        float f15 = this.valueTab[this.index(n + 1, n2)];
        float f16 = this.valueTab[this.index(n, n2 + 1)];
        float f17 = this.valueTab[this.index(n + 1, n2 + 1)];
        float f18 = f14 + this.smoothstep(f3) * (f15 - f14);
        float f19 = f16 + this.smoothstep(f3) * (f17 - f16);
        float f20 = f18 + this.smoothstep(f5) * (f19 - f18);
        f13 += 2.0f * f20;
        return f13 /= 3.0f;
    }

    protected float smoothstep(float f) {
        return f * f * (3.0f - 2.0f * f);
    }

    protected float glattice(int n, int n2, float f, float f2) {
        int n3 = 2 * this.index(n, n2);
        return this.gradTab[n3] * f + this.gradTab[n3 + 1] * f2;
    }
}

