/*
 * Decompiled with CFR 0.152.
 */
package jvx.surface;

import jv.function.PuFunction;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.vecmath.PdVector;
import jvx.geom.PnConjugate;

public class PgGraph
extends PgElementSet {
    protected int m_dimOfDomain;
    protected int m_dimOfSurface;
    protected PgElementSet m_domain;
    protected PuFunction m_function;
    protected PgElementSet m_surface;
    private static /* synthetic */ Class class$jvx$surface$PgGraph;

    public void setSurfaces(PgElementSet pgElementSet, PgElementSet pgElementSet2) {
        if (pgElementSet.getDimOfVertices() + pgElementSet2.getDimOfVertices() != ((PgGeometry)this).m_dim) {
            PsDebug.error((String)"dimension of domain and surface unequal to m_dim", (Object)((Object)this));
            return;
        }
        this.m_domain = pgElementSet;
        this.m_surface = pgElementSet2;
        this.m_dimOfDomain = this.m_domain.getDimOfVertices();
        this.m_dimOfSurface = this.m_surface.getDimOfVertices();
        this.setNumVertices(this.m_domain.getNumVertices());
        this.copyConnectivity(this.m_domain);
    }

    public PgElementSet getSurface() {
        PdVector[] pdVectorArray = this.m_surface.getVertices();
        int n = 0;
        while (n < ((PgPointSet)this).m_numVertices) {
            int n2 = 0;
            while (n2 < this.m_dimOfSurface) {
                pdVectorArray[n].m_data[n2] = ((PgPointSet)this).m_vertex[n].m_data[this.m_dimOfDomain + n2];
                ++n2;
            }
            ++n;
        }
        return this.m_surface;
    }

    public PgElementSet getDomain() {
        PdVector[] pdVectorArray = this.m_domain.getVertices();
        int n = 0;
        while (n < ((PgPointSet)this).m_numVertices) {
            int n2 = 0;
            while (n2 < this.m_dimOfDomain) {
                pdVectorArray[n].m_data[n2] = ((PgPointSet)this).m_vertex[n].m_data[n2];
                ++n2;
            }
            ++n;
        }
        return this.m_domain;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(super.toString());
        stringBuffer.append("\t ******* PgGraph *********\n");
        stringBuffer.append("\t m_domain    = " + this.m_domain.getName() + "\n");
        stringBuffer.append("\t m_surface    = " + this.m_surface.getName() + "\n");
        stringBuffer.append(this.m_domain.toString());
        stringBuffer.append(this.m_surface.toString());
        return stringBuffer.toString();
    }

    public PgGraph(int n) {
        super(n);
        if (((Object)((Object)this)).getClass() == (class$jvx$surface$PgGraph != null ? class$jvx$surface$PgGraph : (class$jvx$surface$PgGraph = PgGraph.class$("jvx.surface.PgGraph")))) {
            this.init();
        }
    }

    public boolean setVertex(int n, PdVector pdVector) {
        if (n < 0 || n > ((PgPointSet)this).m_numVertices - 1) {
            PsDebug.warning((String)("index=" + n + " out of range"));
            return false;
        }
        if (pdVector == null) {
            PsDebug.warning((String)"missing argument");
            return false;
        }
        PdVector[] pdVectorArray = this.m_surface.getVertices();
        int n2 = this.m_dimOfDomain;
        while (n2 < ((PgGeometry)this).m_dim) {
            pdVectorArray[n].m_data[n2 - this.m_dimOfDomain] = pdVector.m_data[n2];
            ((PgPointSet)this).m_vertex[n].m_data[n2] = pdVector.m_data[n2];
            ++n2;
        }
        return true;
    }

    public void makeSurface() {
        if (this.m_domain == null || this.m_surface == null || this.m_function == null) {
            return;
        }
        if (this.m_domain.getNumVertices() != this.m_surface.getNumVertices()) {
            PsDebug.warning((String)("domain and surface differ in numVertices.\n\tdomain  = " + this.m_domain.getName() + " numVertices = " + this.m_domain.getNumVertices() + "\n\tsurface = " + this.m_surface.getName() + " numVertices = " + this.m_surface.getNumVertices()));
            return;
        }
        PdVector[] pdVectorArray = this.m_domain.getVertices();
        PdVector[] pdVectorArray2 = this.m_surface.getVertices();
        int n = 0;
        while (n < ((PgPointSet)this).m_numVertices) {
            this.m_function.eval(pdVectorArray2[n].m_data, pdVectorArray[n].m_data);
            ++n;
        }
    }

    public boolean update(Object object) {
        if (object == this.m_domain) {
            if (this.m_domain.isConforming()) {
                PnConjugate.makeNonConforming(this.m_domain);
                PnConjugate.makeConforming(this.m_domain);
            }
            this.m_surface.setNumVertices(this.m_domain.getNumVertices());
            this.m_surface.copyElementSet(this.m_domain);
            this.setNumVertices(this.m_domain.getNumVertices());
            this.copyConnectivity(this.m_domain);
            this.makeSurface();
            this.makeVertices();
            return super.update(null);
        }
        if (object == this.m_surface) {
            this.makeVertices();
            return super.update(null);
        }
        if (this.m_function != null && object == this.m_function) {
            this.makeSurface();
            this.makeVertices();
            return super.update(null);
        }
        return super.update(object);
    }

    public void copy(PgGeometry pgGeometry) {
        super.copy(pgGeometry);
        if (!(pgGeometry instanceof PgGraph)) {
            return;
        }
        PgGraph pgGraph = (PgGraph)pgGeometry;
        this.m_domain = pgGraph.getDomain();
        this.m_surface = pgGraph.getSurface();
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void makeVertices() {
        if (this.m_domain == null || this.m_surface == null) {
            return;
        }
        if (this.m_domain.getNumVertices() != this.m_surface.getNumVertices()) {
            PsDebug.warning((String)("domain and surface differ in numVertices.\n\tdomain  = " + this.m_domain.getName() + " numVertices = " + this.m_domain.getNumVertices() + "\n\tsurface = " + this.m_surface.getName() + " numVertices = " + this.m_surface.getNumVertices()));
            return;
        }
        PdVector[] pdVectorArray = this.m_domain.getVertices();
        PdVector[] pdVectorArray2 = this.m_surface.getVertices();
        int n = 0;
        while (n < ((PgPointSet)this).m_numVertices) {
            int n2 = 0;
            while (n2 < this.m_dimOfDomain) {
                ((PgPointSet)this).m_vertex[n].m_data[n2] = pdVectorArray[n].m_data[n2];
                ++n2;
            }
            n2 = 0;
            while (n2 < this.m_dimOfSurface) {
                ((PgPointSet)this).m_vertex[n].m_data[this.m_dimOfDomain + n2] = pdVectorArray2[n].m_data[n2];
                ++n2;
            }
            ++n;
        }
        this.makeVertexNormals();
    }

    public PuFunction getFunction() {
        return this.m_function;
    }

    public void setFunction(PuFunction puFunction) {
        if (puFunction == null) {
            PsDebug.warning((String)"missing function");
            return;
        }
        if (this.m_dimOfSurface != 0 && puFunction.getNumFunctions() != this.m_dimOfSurface) {
            PsDebug.warning((String)("number of functions unequal to m_dim\n\tnumFunctions = " + puFunction.getNumFunctions() + " != " + this.m_dimOfSurface));
            return;
        }
        this.m_function = puFunction;
        this.m_function.setParent((PsUpdateIf)this);
        this.makeSurface();
        this.makeVertices();
    }

    public void init() {
        super.init();
    }
}

