/*
 * Decompiled with CFR 0.152.
 */
package vgp.surface.common;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import jv.object.PsConfig;
import jv.object.PsMainFrame;
import jv.project.PjProject;
import jv.viewer.PvViewer;
import vgp.surface.common.PjSurface;

public class PaSurface
extends Applet
implements Runnable {
    protected Frame m_frame = null;
    protected PvViewer m_viewer;
    private String m_drawString = "Initializing ...";
    protected String[][] m_parm = new String[][]{{"ProjectPanel", "String", "Show", "Show models selection panel, i.e. project panel"}, {"SurfaceName", "String", "HyperbolicHelicoid", "Name of surface, must exist corresponding descriptor class vgp.surface.common.PgSurface_NAME.java"}, {"Console", "String", "Hide", "Show/Hide VGP-console for debugging"}, {"Control", "String", "Hide", "Show/Hide control panel"}, {"Frame", "String", "Hide", "Show/Hide frame around applet"}, {"Panel", "String", "Project", "Name of initial panel if control panel is showing"}, {"Select", "String", "Import Model", "Name of default project"}, {"Project1", "String", "Import Model; jv.loader.PjImportModel", "Default project"}};

    public void stop() {
        if (this.m_viewer != null) {
            this.m_viewer.stop();
        }
    }

    public void startFromThread() {
        if (this.m_viewer != null) {
            this.m_viewer.start();
        }
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.blue);
        graphics.drawString(PsConfig.getProgram() + " v." + PsConfig.getVersion(), 20, 40);
        graphics.drawString(this.m_drawString, 20, 60);
    }

    public String[][] getParameterInfo() {
        return this.m_parm;
    }

    public void destroy() {
        if (this.m_viewer != null) {
            this.m_viewer.destroy();
        }
    }

    private void drawMessage(String string) {
        this.m_drawString = string;
        this.repaint();
    }

    public static void main(String[] stringArray) {
        PaSurface paSurface = new PaSurface();
        PsMainFrame psMainFrame = new PsMainFrame((Component)paSurface, stringArray);
        psMainFrame.pack();
        paSurface.m_frame = psMainFrame;
        paSurface.init();
        psMainFrame.setBounds(new Rectangle(375, 5, 640, 512));
        psMainFrame.setVisible(true);
    }

    public String getAppletInfo() {
        return "Name: " + this.getClass().getName() + "\r\n" + "Author: Samy Khadem-Al-Charieh\r\n" + "Version: " + PsConfig.getVersion() + "\r\n" + "Applet showing parametrized surfaces" + "\r\n";
    }

    public void run() {
        this.drawMessage("Loading viewer ...");
        this.m_viewer = new PvViewer((Applet)this, this.m_frame);
        this.drawMessage("Loading project ...");
        PjSurface pjSurface = new PjSurface();
        if (this.m_frame == null) {
            pjSurface.setSurfaceNames(this.getParameter("SurfaceName"), this.getParameter("SurfaceParams"), this.getParameter("SurfaceColors"));
        } else {
            pjSurface.setSurfaceNames(this.m_viewer.getParameter("SurfaceName"), this.m_viewer.getParameter("SurfaceParams"), this.m_viewer.getParameter("SurfaceColors"));
        }
        this.m_viewer.addProject((PjProject)pjSurface);
        this.m_viewer.selectProject(pjSurface.getName());
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)this.m_viewer.getDisplay());
        if ("Show".equals(this.m_viewer.getParameter("ProjectPanel"))) {
            this.add("East", this.m_viewer.getPanel(10));
        }
        this.validate();
        this.m_viewer.showPanel(13);
        this.startFromThread();
    }

    public void init() {
        Thread thread = new Thread((Runnable)this, "JavaView: inititialize applet");
        thread.setPriority(5);
        thread.start();
    }
}

