/*
 * Decompiled with CFR 0.152.
 */
package vgp.surface.common;

import jv.function.PuFunction;
import jv.number.PuDouble;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.vecmath.PdVector;
import vgp.surface.common.PgSurfaceDescr;

public class PgSurface_KleinBottle
extends PgSurfaceDescr {
    private double m_defHandle = 0.4;
    private double m_defRadius = 1.0;
    private double m_defOpulence = 0.1;
    private double m_defBreadth = 2.0;
    private double m_defLength = 10.0;
    protected PuDouble handle;
    protected PuDouble radius;
    protected PuDouble opulence;
    protected PuDouble breadth;
    protected PuDouble length;
    private static /* synthetic */ Class class$vgp$surface$common$PgSurface_KleinBottle;

    public PgSurface_KleinBottle() {
        this.setName("KleinBottle");
        this.handle = new PuDouble("Handle", (PsUpdateIf)this);
        this.radius = new PuDouble("Radius", (PsUpdateIf)this);
        this.opulence = new PuDouble("Opulence", (PsUpdateIf)this);
        this.breadth = new PuDouble("Breadth", (PsUpdateIf)this);
        this.length = new PuDouble("Length", (PsUpdateIf)this);
        this.m_function = new PuFunction(2, 3);
        if (((Object)((Object)this)).getClass() == (class$vgp$surface$common$PgSurface_KleinBottle != null ? class$vgp$surface$common$PgSurface_KleinBottle : (class$vgp$surface$common$PgSurface_KleinBottle = PgSurface_KleinBottle.class$("vgp.surface.common.PgSurface_KleinBottle")))) {
            this.init();
        }
    }

    public boolean update(Object object) {
        if (object == this.handle) {
            this.m_function.setParameter("h", this.handle.getValue());
            return super.update(null);
        }
        if (object == this.radius) {
            this.m_function.setParameter("r", this.radius.getValue());
            return super.update(null);
        }
        if (object == this.opulence) {
            this.m_function.setParameter("o", this.opulence.getValue());
            return super.update(null);
        }
        if (object == this.breadth) {
            this.m_function.setParameter("b", this.breadth.getValue());
            return super.update(null);
        }
        if (object == this.length) {
            this.m_function.setParameter("l", this.length.getValue());
            return super.update(null);
        }
        if (object == this.m_numULines && this.getNumULines() < 10) {
            this.m_numULines.setValue(10);
        } else if (object == this.m_numVLines && this.getNumVLines() < 5) {
            this.m_numVLines.setValue(5);
        } else if (object == this.m_numVLines && this.getNumVLines() - 2 * (this.getNumVLines() / 2) == 0) {
            this.m_numVLines.setValue(this.m_numVLines.getValue() + 1);
        }
        return super.update(object);
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void init() {
        super.init();
        this.setSize(0.0, 0.0, 1.0, Math.PI * 2);
        this.setDiscr(65, 33);
        this.handle.setDefBounds(0.0, 0.5, 0.02, 0.1);
        this.handle.setDefValue(this.m_defHandle);
        this.handle.init();
        this.addParameter((PsObject)this.handle);
        this.radius.setDefBounds(0.0, 2.0, 0.01, 0.05);
        this.radius.setDefValue(this.m_defRadius);
        this.radius.init();
        this.addParameter((PsObject)this.radius);
        this.opulence.setDefBounds(0.0, 0.2, 0.01, 0.05);
        this.opulence.setDefValue(this.m_defOpulence);
        this.opulence.init();
        this.addParameter((PsObject)this.opulence);
        this.breadth.setDefBounds(0.0, 10.0, 0.1, 0.5);
        this.breadth.setDefValue(this.m_defBreadth);
        this.breadth.init();
        this.addParameter((PsObject)this.breadth);
        this.length.setDefBounds(5.0, 20.0, 0.2, 1.0);
        this.length.setDefValue(this.m_defLength);
        this.length.init();
        this.addParameter((PsObject)this.length);
        this.m_function.setName("Coordinate Functions");
        this.m_function.setExpression("r*(1-(2*(u+h*(sin(pi*u))^2)-1)*((u+h*(sin(pi*u))^2)-(u+h*(sin(pi*u))^2)^2)^0.25)*cos(v)*cos(pi*(u-o*sin(2*pi*u)^3))+b*(-2*u^3+3*u^2)*sin(2*pi*(-2*u^3+3*u^2))", 0);
        this.m_function.setExpression("r*(1-(2*(u+h*(sin(pi*u))^2)-1)*((u+h*(sin(pi*u))^2)-(u+h*(sin(pi*u))^2)^2)^0.25)*sin(v)", 1);
        this.m_function.setExpression("r*(1-(2*(u+h*(sin(pi*u))^2)-1)*((u+h*(sin(pi*u))^2)-(u+h*(sin(pi*u))^2)^2)^0.25)*cos(v)*sin(pi*(u-o*sin(2*pi*u)^3))+l*(1-(2*(-2*u^3+3*u^2)-1)^2)^0.5", 2);
        this.m_function.addParameter("h", this.handle.getValue());
        this.m_function.addParameter("r", this.radius.getValue());
        this.m_function.addParameter("o", this.opulence.getValue());
        this.m_function.addParameter("b", this.breadth.getValue());
        this.m_function.addParameter("l", this.length.getValue());
        this.setFunction(this.m_function);
        this.useFunctionExpression(false);
    }

    public boolean calc_f(PdVector pdVector, double d, double d2) {
        double d3 = this.handle.getValue();
        double d4 = this.radius.getValue();
        double d5 = this.opulence.getValue();
        double d6 = this.breadth.getValue();
        double d7 = this.length.getValue();
        double d8 = d + d3 * Math.pow(Math.sin(Math.PI * d), 2.0);
        if (d8 > 1.0) {
            d8 = 1.0;
        }
        double d9 = d4 * (1.0 - (2.0 * d8 - 1.0) * Math.pow(d8 * (1.0 - d8), 0.25));
        double d10 = Math.PI * (d - d5 * Math.pow(Math.sin(Math.PI * 2 * d), 3.0));
        double d11 = d * (3.0 * d - 2.0 * d * d);
        if (d11 > 1.0) {
            d11 = 1.0;
        }
        pdVector.set(d9 * Math.cos(d2) * Math.cos(d10) + d6 * d11 * Math.sin(Math.PI * 2 * d11), d9 * Math.sin(d2), d9 * Math.cos(d2) * Math.sin(d10) + d7 * Math.sqrt(1.0 - (2.0 * d11 - 1.0) * (2.0 * d11 - 1.0)));
        return true;
    }
}

