/*
 * Decompiled with CFR 0.152.
 */
package vgp.surface.common;

import jv.function.PuFunction;
import jv.number.PuDouble;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.vecmath.PdVector;
import vgp.surface.common.PgSurfaceDescr;

public class PgSurface_Torus
extends PgSurfaceDescr {
    private double m_defInnerRadius = 2.0;
    private double m_defTubeRadius = 1.0;
    protected PuDouble m_innerRadius;
    protected PuDouble m_tubeRadius;
    private static /* synthetic */ Class class$vgp$surface$common$PgSurface_Torus;

    protected PdVector calc_ddf_dUdU(double d, double d2) {
        PdVector pdVector = new PdVector(3);
        double d3 = this.m_tubeRadius.getValue();
        double d4 = this.m_innerRadius.getValue();
        pdVector.set(-Math.cos(d) * (d3 * Math.cos(d2) + d4), -Math.sin(d) * (d3 * Math.cos(d2) + d4), 0.0);
        return pdVector;
    }

    public boolean isUPeriodic() {
        return this.getUMax() - this.getUMin() >= Math.PI * 2;
    }

    public boolean isVPeriodic() {
        return this.getVMax() - this.getVMin() >= Math.PI * 2;
    }

    public PgSurface_Torus() {
        this.setName("Torus");
        this.m_innerRadius = new PuDouble("Inner Radius", (PsUpdateIf)this);
        this.m_tubeRadius = new PuDouble("Tube Radius", (PsUpdateIf)this);
        this.m_function = new PuFunction(2, 3);
        if (((Object)((Object)this)).getClass() == (class$vgp$surface$common$PgSurface_Torus != null ? class$vgp$surface$common$PgSurface_Torus : (class$vgp$surface$common$PgSurface_Torus = PgSurface_Torus.class$("vgp.surface.common.PgSurface_Torus")))) {
            this.init();
        }
    }

    protected PdVector calc_df_dU(double d, double d2) {
        PdVector pdVector = new PdVector(3);
        double d3 = this.m_tubeRadius.getValue();
        double d4 = this.m_innerRadius.getValue();
        pdVector.set(-Math.sin(d) * (d3 * Math.cos(d2) + d4), Math.cos(d) * (d3 * Math.cos(d2) + d4), 0.0);
        return pdVector;
    }

    protected PdVector calc_ddf_dVdV(double d, double d2) {
        PdVector pdVector = new PdVector(3);
        double d3 = this.m_tubeRadius.getValue();
        pdVector.set(-Math.cos(d) * d3 * Math.cos(d2), -Math.sin(d) * d3 * Math.cos(d2), -d3 * Math.sin(d2));
        return pdVector;
    }

    protected PdVector calc_ddf_dUdV(double d, double d2) {
        PdVector pdVector = new PdVector(3);
        double d3 = this.m_tubeRadius.getValue();
        pdVector.set(Math.sin(d) * d3 * Math.sin(d2), -Math.cos(d) * d3 * Math.sin(d2), 0.0);
        return pdVector;
    }

    public boolean update(Object object) {
        if (object == this.m_innerRadius) {
            this.m_function.setParameter("ir", this.m_innerRadius.getValue());
            return super.update(null);
        }
        if (object == this.m_tubeRadius) {
            this.m_function.setParameter("tr", this.m_tubeRadius.getValue());
            return super.update(null);
        }
        return super.update(object);
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected PdVector calc_df_dV(double d, double d2) {
        PdVector pdVector = new PdVector(3);
        double d3 = this.m_tubeRadius.getValue();
        pdVector.set(-Math.cos(d) * d3 * Math.sin(d2), -Math.sin(d) * d3 * Math.sin(d2), d3 * Math.cos(d2));
        return pdVector;
    }

    public void init() {
        super.init();
        this.setSize(0.0, 0.0, Math.PI * 2, Math.PI * 2);
        this.setDiscr(17, 17);
        this.m_innerRadius.setDefBounds(0.0, 4.0 * this.m_defInnerRadius, 0.1, 0.2);
        this.m_innerRadius.setDefValue(this.m_defInnerRadius);
        this.m_innerRadius.init();
        this.addParameter((PsObject)this.m_innerRadius);
        this.m_tubeRadius.setDefBounds(0.0, 4.0 * this.m_defTubeRadius, 0.1, 0.2);
        this.m_tubeRadius.setDefValue(this.m_defTubeRadius);
        this.m_tubeRadius.init();
        this.addParameter((PsObject)this.m_tubeRadius);
        this.m_function.setName("Coordinate Functions");
        this.m_function.setExpression("cos(u)*(tr*cos(v)+ir)", 0);
        this.m_function.setExpression("sin(u)*(tr*cos(v)+ir)", 1);
        this.m_function.setExpression("tr*sin(v)", 2);
        this.m_function.addParameter("ir", this.m_innerRadius.getValue());
        this.m_function.addParameter("tr", this.m_tubeRadius.getValue());
        this.setFunction(this.m_function);
        this.useFunctionExpression(false);
    }

    public boolean calc_f(PdVector pdVector, double d, double d2) {
        double d3 = this.m_tubeRadius.getValue();
        double d4 = this.m_innerRadius.getValue();
        pdVector.set(Math.cos(d) * (d3 * Math.cos(d2) + d4), Math.sin(d) * (d3 * Math.cos(d2) + d4), d3 * Math.sin(d2));
        return true;
    }
}

