/*
 * Decompiled with CFR 0.152.
 */
package vgp.tutor.lsystem;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Rectangle;
import java.util.Stack;
import jv.geom.PgPolygonSet;
import jv.number.PuDouble;
import jv.object.PsMainFrame;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PvDisplayIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.viewer.PvViewer;
import vgp.tutor.lsystem.LSystem;

public class PaLSystem
extends Applet
implements PsUpdateIf {
    protected Frame m_frame;
    protected PuDouble m_delta;
    protected PgPolygonSet m_polySet;
    protected String m_descr;

    private void makePolygonSet(double d) {
        this.m_polySet.init();
        Stack<PdVector> stack = new Stack<PdVector>();
        Stack<PiVector> stack2 = new Stack<PiVector>();
        int n = this.m_descr.length();
        double d2 = 0.2;
        PdVector pdVector = new PdVector(3);
        PiVector piVector = new PiVector(3);
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 1.5707963267948966;
        pdVector.set(d3, d4, d5);
        int n2 = this.m_polySet.addVertex(pdVector);
        piVector.setEntry(0, n2);
        int n3 = 0;
        while (n3 < n) {
            switch (this.m_descr.charAt(n3)) {
                case 'F': {
                    d5 = pdVector.getEntry(2);
                    d3 = pdVector.getEntry(0) + d2 * Math.cos(d5);
                    d4 = pdVector.getEntry(1) + d2 * Math.sin(d5);
                    pdVector.set(d3, d4, d5);
                    n2 = this.m_polySet.addVertex(pdVector);
                    piVector.setEntry(piVector.getSize(), n2);
                    break;
                }
                case '[': {
                    stack.push(pdVector);
                    pdVector = PdVector.copyNew((PdVector)pdVector);
                    stack2.push(piVector);
                    piVector = new PiVector();
                    piVector.setEntry(0, n2);
                    break;
                }
                case ']': {
                    this.m_polySet.addPolygon(piVector);
                    pdVector = (PdVector)stack.pop();
                    piVector = (PiVector)stack2.pop();
                    n2 = piVector.getEntry(piVector.getSize() - 1);
                    break;
                }
                case '+': {
                    pdVector.set(d3, d4, pdVector.getEntry(2) + d);
                    break;
                }
                case '-': {
                    pdVector.set(d3, d4, pdVector.getEntry(2) - d);
                }
            }
            ++n3;
        }
        this.m_polySet.addPolygon(piVector);
    }

    public void setParent(PsUpdateIf psUpdateIf) {
    }

    public PsUpdateIf getFather() {
        return null;
    }

    public boolean update(Object object) {
        if (object != null && object == this.m_delta) {
            this.makePolygonSet(this.m_delta.getValue());
            this.m_polySet.update((Object)this.m_polySet);
        }
        return true;
    }

    public static void main(String[] stringArray) {
        PaLSystem paLSystem = new PaLSystem();
        PsMainFrame psMainFrame = new PsMainFrame((Component)paLSystem, stringArray);
        psMainFrame.pack();
        paLSystem.m_frame = psMainFrame;
        paLSystem.init();
        psMainFrame.setBounds(new Rectangle(420, 5, 640, 550));
        psMainFrame.setVisible(true);
    }

    public void init() {
        LSystem lSystem = new LSystem();
        lSystem.iterate(200);
        this.m_descr = lSystem.getTree();
        Label label = new Label();
        label.setText(this.m_descr);
        this.m_polySet = new PgPolygonSet(2);
        this.m_polySet.setName("My LSystem");
        this.m_delta = new PuDouble("Delta", (PsUpdateIf)this);
        this.m_delta.setValue(0.4485496177625427);
        this.makePolygonSet(this.m_delta.getValue());
        PvViewer pvViewer = new PvViewer((Applet)this, this.m_frame);
        PvDisplayIf pvDisplayIf = pvViewer.getDisplay();
        pvDisplayIf.addGeometry((PgGeometryIf)this.m_polySet);
        pvDisplayIf.selectGeometry((PgGeometryIf)this.m_polySet);
        this.setLayout(new BorderLayout());
        this.add("North", label);
        this.add("Center", (Component)pvDisplayIf);
        this.add("South", (Component)this.m_delta.getInfoPanel());
        this.validate();
        pvViewer.start();
    }
}

