/*
 * Decompiled with CFR 0.152.
 */
package vgp.tutor.ode;

import java.awt.Color;
import jv.geom.PgPointSet;
import jv.geom.PgPolygon;
import jv.geom.PgVectorField;
import jv.loader.PsXmlLoader;
import jv.number.PdVector_IP;
import jv.number.PuDouble;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvPickEvent;
import jv.project.PvViewerIf;
import jv.vecmath.PdVector;
import jvx.numeric.PnOdeExpr;

public class PjExprOde
extends PjProject {
    protected boolean m_bShowInitialPoint;
    protected PgPointSet m_initialPoint;
    protected PgPolygon m_solution;
    protected boolean m_bShowVectorField;
    protected PgPointSet m_vectorField;
    protected PnOdeExpr m_exprOde;
    protected String m_equation;
    private String m_defaultEquation = "-dy/2-y";
    protected int m_order;
    private int m_defaultOrder = 2;
    protected PuDouble m_h;
    protected PuDouble m_length;
    protected PuDouble m_xStart;
    protected double m_defaultXStart = -8.0;
    protected PdVector m_yStart;
    protected PdVector m_defaultYStart = new PdVector(6.0, 1.0);
    protected PdVector_IP m_pYStart;
    private static /* synthetic */ Class class$vgp$tutor$ode$PjExprOde;

    public void showInitialPoint(boolean bl) {
        this.m_bShowInitialPoint = bl;
        if (this.m_initialPoint == null) {
            return;
        }
        if (this.m_bShowInitialPoint) {
            this.addGeometry((PgGeometryIf)this.m_initialPoint);
            return;
        }
        this.removeGeometry((PgGeometryIf)this.m_initialPoint);
    }

    public PjExprOde() {
        super("Differential Equation");
        this.m_exprOde = new PnOdeExpr();
        this.m_initialPoint = new PgPointSet(2);
        this.m_solution = new PgPolygon(3);
        this.m_h = new PuDouble("Step Size", (PsUpdateIf)this);
        this.m_length = new PuDouble("Length", (PsUpdateIf)this);
        this.m_xStart = new PuDouble("Initial x", (PsUpdateIf)this);
        this.m_yStart = new PdVector(this.m_defaultOrder);
        this.m_pYStart = new PdVector_IP();
        this.m_pYStart.setTitle("Initial y");
        this.m_pYStart.setParent((PsUpdateIf)this);
        this.m_pYStart.setVector(this.m_yStart);
        if (((Object)((Object)this)).getClass() == (class$vgp$tutor$ode$PjExprOde != null ? class$vgp$tutor$ode$PjExprOde : (class$vgp$tutor$ode$PjExprOde = PjExprOde.class$("vgp.tutor.ode.PjExprOde")))) {
            this.init();
        }
    }

    public boolean isShowingVectorField() {
        return this.m_bShowVectorField;
    }

    public void showVectorField(boolean bl) {
        this.m_bShowVectorField = bl;
        if (this.m_bShowVectorField) {
            if (this.m_vectorField == null) {
                this.m_vectorField = new PgPointSet(2);
                this.m_vectorField.setName("Vectors");
                this.m_vectorField.showVertices(false);
            }
            double d = this.m_xStart.getMax() - this.m_xStart.getMin();
            int n = (int)(d / this.m_xStart.getPageIncr());
            this.m_vectorField.setNumVertices(++n * n);
            PgVectorField pgVectorField = this.m_vectorField.getVectorField(0);
            if (pgVectorField == null) {
                pgVectorField = new PgVectorField(2);
                pgVectorField.setGeometry(this.m_vectorField);
                pgVectorField.setBasedOn(0);
                this.m_vectorField.addVectorField(pgVectorField);
                this.m_vectorField.setGlobalVectorColor(Color.blue);
                this.m_vectorField.showVectorField(true);
            }
            pgVectorField.setNumVectors(n * n);
            double d2 = this.m_xStart.getMin();
            PdVector pdVector = new PdVector(this.m_yStart.getSize());
            pdVector.copy(this.m_yStart);
            PdVector pdVector2 = new PdVector(this.m_yStart.getSize());
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                double d3 = this.m_xStart.getMin();
                int n4 = 0;
                while (n4 < n) {
                    pdVector.setEntry(0, d3);
                    this.m_vectorField.setVertex(n2, d2, d3);
                    this.m_exprOde.diffEquation(d2, pdVector.m_data, pdVector2.m_data);
                    pgVectorField.setVector(n2, 1.0, pdVector2.m_data[0]);
                    ++n2;
                    d3 += d / (double)n;
                    ++n4;
                }
                d2 += this.m_xStart.getPageIncr();
                ++n3;
            }
            this.addGeometry((PgGeometryIf)this.m_vectorField);
            this.m_vectorField.update((Object)this.m_vectorField);
            return;
        }
        if (this.m_vectorField != null) {
            this.removeGeometry((PgGeometryIf)this.m_vectorField);
        }
    }

    public void setOrder(int n) {
        this.m_order = n;
        this.m_yStart.setSize(n);
        this.m_pYStart.setVector(this.m_yStart);
        this.m_exprOde.setOrder(n);
        if (n != 1) {
            this.showVectorField(false);
        }
    }

    public void setEquation(String string) {
        this.m_equation = string;
        this.m_exprOde.setEquation(this.m_equation);
        if (this.isShowingVectorField()) {
            this.showVectorField(true);
        }
    }

    public void setEquation(String string, String[] stringArray) {
        this.m_equation = string;
        this.m_exprOde.setEquation(this.m_equation, stringArray);
        if (this.isShowingVectorField()) {
            this.showVectorField(true);
        }
    }

    public boolean update(Object object) {
        if (object == this.m_h) {
            this.solve();
            return true;
        }
        if (object == this.m_length) {
            this.solve();
            return true;
        }
        if (object == this.m_xStart) {
            this.solve();
            return true;
        }
        if (object == this.m_pYStart) {
            this.solve();
            return true;
        }
        return false;
    }

    public void dragInitial(PvPickEvent pvPickEvent) {
        this.pickInitial(pvPickEvent);
    }

    public void start() {
        String string;
        PvViewerIf pvViewerIf = this.getViewer();
        if (pvViewerIf != null) {
            String string2;
            String string3;
            string = pvViewerIf.getParameter("vgp.tutor.ode.PjExprOde#equation");
            if (string != null) {
                this.m_defaultEquation = string;
                this.setEquation(this.m_defaultEquation);
            }
            if ((string3 = pvViewerIf.getParameter("vgp.tutor.ode.PjExprOde#order")) != null) {
                try {
                    int n;
                    this.m_defaultOrder = n = Integer.parseInt(string3);
                    this.setOrder(this.m_defaultOrder);
                }
                catch (NumberFormatException numberFormatException) {
                    PsDebug.warning((String)("wrong format = " + string3));
                }
            }
            if ((string2 = pvViewerIf.getParameter("vgp.tutor.ode.PjExprOde#initial")) != null) {
                PdVector pdVector = PsXmlLoader.parsePdVector((String)string2);
                if (pdVector != null) {
                    if (pdVector.getSize() - 1 != this.m_defaultOrder) {
                        PsDebug.warning((String)("number of initial values incompatible with current order = " + this.m_defaultOrder));
                    } else {
                        double d = pdVector.getEntry(0);
                        this.m_xStart.setDefValue(d);
                        this.m_xStart.setDefBounds(-20.0, 20.0, 0.1, 1.0);
                        this.m_xStart.init();
                        this.m_defaultYStart.setSize(pdVector.getSize() - 1);
                        int n = 1;
                        while (n < pdVector.getSize()) {
                            this.m_defaultYStart.setEntry(n - 1, pdVector.getEntry(n));
                            ++n;
                        }
                        this.m_yStart.setSize(pdVector.getSize() - 1);
                        this.m_yStart.copy(this.m_defaultYStart);
                        this.m_pYStart.update((Object)this.m_yStart);
                    }
                } else {
                    PsDebug.warning((String)("wrong format = " + string2));
                }
            }
        }
        this.solve();
        this.update((Object)this);
        this.addGeometry((PgGeometryIf)this.m_initialPoint);
        this.addGeometry((PgGeometryIf)this.m_solution);
        this.selectGeometry((PgGeometryIf)this.m_solution);
        string = this.getDisplay();
        if (string != null) {
            string.showGrid(true);
            string.selectCamera(1);
            string.setMajorMode(6);
        }
        super.start();
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void init() {
        super.init();
        this.setOrder(this.m_defaultOrder);
        this.m_h.setDefValue(0.2);
        this.m_h.setDefBounds(0.01, 2.0, 0.1, 1.0);
        this.m_h.init();
        this.m_length.setDefValue(15.0);
        this.m_length.setDefBounds(1.0, 50.0, 0.1, 1.0);
        this.m_length.init();
        this.m_xStart.setDefValue(this.m_defaultXStart);
        this.m_xStart.setDefBounds(-20.0, 20.0, 0.1, 1.0);
        this.m_xStart.init();
        this.m_yStart.copy(this.m_defaultYStart);
        this.m_pYStart.update((Object)this.m_yStart);
        this.setEquation(this.m_defaultEquation);
        this.m_initialPoint.init();
        this.m_initialPoint.setName("Initial Point");
        this.m_initialPoint.showTitle(true);
        this.m_initialPoint.setGlobalVertexSize(3);
        this.m_initialPoint.setGlobalVertexColor(Color.blue);
        this.m_initialPoint.setNumVertices(1);
        this.m_initialPoint.setVertex(0, this.m_xStart.getValue(), this.m_yStart.getEntry(0));
        this.showInitialPoint(true);
        this.m_solution.init();
        this.m_solution.setName("ODE solution");
        this.showVectorField(false);
    }

    public void pickInitial(PvPickEvent pvPickEvent) {
        PdVector pdVector = pvPickEvent.getVertex();
        this.m_xStart.setValue(pdVector.m_data[0]);
        this.m_yStart.setEntry(0, pdVector.m_data[1]);
        this.m_pYStart.update((Object)this.m_yStart);
        this.solve();
    }

    public void solve() {
        this.m_initialPoint.setVertex(0, this.m_xStart.getValue(), this.m_yStart.getEntry(0));
        this.m_initialPoint.update((Object)this.m_initialPoint);
        this.m_exprOde.setInitialData(this.m_xStart.getValue(), this.m_yStart.m_data, this.m_h.getValue(), this.m_length.getValue());
        this.m_exprOde.solve(this.m_solution);
        this.m_solution.update((Object)this.m_solution);
    }
}

