/*
 * Decompiled with CFR 0.152.
 */
package vgp.vector.vectorField;

import java.awt.Button;
import java.awt.Frame;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.MemoryImageSource;
import java.util.Date;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygon;
import jv.geom.PgTexture;
import jv.geom.PgVectorField;
import jv.loader.PjImportModel;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PvPickEvent;
import jv.vecmath.PdBary;
import jv.vecmath.PdBaryDir;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jvx.geom.PgPolygonOnElementSet;
import jvx.geom.PwBary;
import jvx.numeric.PnGeodesicRK;
import jvx.numeric.PnLIC;
import jvx.numeric.PnTranslationRK;
import jvx.numeric.PnVertexRK;

public class PjVectorField
extends PjImportModel
implements Runnable,
ActionListener {
    protected PjImportModel m_import;
    protected PgElementSet m_geom;
    protected PuDouble m_length;
    protected PuInteger m_discr;
    protected PdBaryDir[][] m_altvec = null;
    protected int m_method;
    public static final int PROJECTION = 1;
    public static final int GEODESIC = 2;
    public static final int GEODESIC2 = 3;
    public static final int GEODESIC3 = 4;
    protected PuInteger m_LICSize;
    protected PdBaryDir[] m_origvec;
    protected int[] m_origelem;
    protected int[] m_origlocvertind;
    protected PgPolygon m_poly;
    protected int m_elemInd = 0;
    protected PdBary m_bary = new PdBary(1.0, 0.0, 0.0);
    protected PgVectorField m_vec;
    private boolean m_curveallreadythere = false;
    protected Thread m_LIC;
    protected Button m_LICButton;
    protected boolean m_fast = false;
    protected PnGeodesicRK m_ode;
    protected Label m_time;
    private String m_origLabel = null;
    private static /* synthetic */ Class class$vgp$vector$vectorField$PjVectorField;

    public PjVectorField() {
        this.m_import = new PjImportModel();
        this.m_import.setTypeOfInfoPanel(PjImportModel.FULL_INFO_PANEL);
        this.m_import.setParent((PsUpdateIf)this);
        this.m_length = new PuDouble("Length", (PsUpdateIf)this);
        this.m_discr = new PuInteger("Discr", (PsUpdateIf)this);
        this.m_vec = new PgVectorField(3);
        this.m_vec.setName("VectorField");
        this.m_poly = new PgPolygon(3);
        this.m_poly.setName("curve");
        this.m_LICButton = new Button("calculate LIC texture");
        this.m_LICSize = new PuInteger("LIC size", null);
        this.m_time = new Label("LIC time: --");
        if (this.getClass() == (class$vgp$vector$vectorField$PjVectorField != null ? class$vgp$vector$vectorField$PjVectorField : (class$vgp$vector$vectorField$PjVectorField = PjVectorField.class$("vgp.vector.vectorField.PjVectorField")))) {
            this.init();
        }
    }

    public void computeLIC() {
        if (this.m_LIC == null || !this.m_LIC.isAlive()) {
            this.startLIC();
            return;
        }
        this.stopLIC();
    }

    public void setFast(boolean bl) {
        this.m_fast = bl;
        if (this.m_curveallreadythere) {
            this.calculateCurve();
            this.m_poly.update(null);
        }
    }

    public void setMethod(int n) {
        this.m_method = n;
        this.calculateRepresentations();
        if (this.m_curveallreadythere) {
            this.calculateCurve();
            this.m_poly.update(null);
        }
    }

    private void startLIC() {
        this.m_LIC = new Thread(this);
        this.m_LIC.start();
    }

    private void stopLIC() {
        this.m_LIC.interrupt();
        this.m_LIC = null;
        System.gc();
        this.m_LICButton.setLabel(this.m_origLabel);
    }

    public boolean update(Object object) {
        if (object == null) {
            return super.update(null);
        }
        if (object != null && object == this.m_geom) {
            return super.update(null);
        }
        if (object == this.m_length) {
            this.calculateCurve();
            this.m_poly.update(null);
            return super.update(null);
        }
        if (object == this.m_discr) {
            this.calculateCurve();
            this.m_poly.update(null);
            return super.update(null);
        }
        if (object == this.m_import) {
            this.load();
            return super.update(null);
        }
        return super.update(object);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_LICButton) {
            this.computeLIC();
        }
    }

    public boolean load(String string) {
        boolean bl = this.m_import.load(string);
        if (bl) {
            bl = this.load();
        }
        return bl;
    }

    public boolean load() {
        PgGeometryIf pgGeometryIf;
        if (this.m_LIC != null) {
            this.stopLIC();
        }
        if ((pgGeometryIf = this.m_import.getGeometry(0)) == null || !(pgGeometryIf instanceof PgElementSet)) {
            return false;
        }
        if (this.m_geom != null) {
            this.removeGeometry((PgGeometryIf)this.m_geom);
        }
        this.m_geom = (PgElementSet)pgGeometryIf;
        this.m_geom.makeNeighbour();
        PgElementSet.triangulate((PgElementSet)this.m_geom);
        this.m_geom.makeNeighbour();
        this.m_vec.setGeometry((PgPointSet)this.m_geom);
        this.calculateVectorField();
        this.calculateRepresentations();
        this.m_vec.update(null);
        this.m_geom.addVectorField(this.m_vec);
        this.m_geom.showElements(false);
        this.m_geom.showVertices(false);
        this.m_curveallreadythere = false;
        this.m_poly.setNumVertices(0);
        this.m_poly.update(null);
        this.removeGeometry((PgGeometryIf)this.m_poly);
        this.addGeometry((PgGeometryIf)this.m_poly);
        this.addGeometry((PgGeometryIf)this.m_geom);
        this.m_geom.update(null);
        this.selectGeometry((PgGeometryIf)this.m_geom);
        this.fitDisplays();
        this.update(null);
        return true;
    }

    public void start() {
    }

    public void calculateVectorField() {
        if (this.m_geom == null) {
            PsDebug.warning((String)"No valid geometry.");
            return;
        }
        this.m_origvec = new PdBaryDir[this.m_geom.getNumVertices()];
        this.m_origelem = new int[this.m_geom.getNumVertices()];
        this.m_origlocvertind = new int[this.m_geom.getNumVertices()];
        PiVector[] piVectorArray = this.m_geom.getElements();
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        int n = 0;
        while (n < this.m_geom.getNumVertices()) {
            int n2;
            this.m_origvec[n] = new PdBaryDir(3);
            int n3 = 0;
            boolean bl = false;
            int n4 = 0;
            while (!bl && n3 < this.m_geom.getNumElements()) {
                n2 = 0;
                do {
                    if (piVectorArray[n3].m_data[n2] != n) continue;
                    n4 = n2;
                    bl = true;
                    break;
                } while (++n2 < 3);
                ++n3;
            }
            if (bl) {
                this.m_origelem[n] = --n3;
                this.m_origlocvertind[n] = n4;
                this.m_origvec[n].m_data[(n4 + 1) % 3] = (Math.random() + (n == 9 ? 0.3 : 0.0)) / (double)(n == 3 || n == 14 ? 2 : 1);
                this.m_origvec[n].m_data[(n4 + 2) % 3] = (Math.random() + (n == 9 ? 0.3 : 0.0)) / (n == 3 ? 0.5 : 1.0) / (double)(n == 14 ? 2 : 1);
                this.m_origvec[n].m_data[n4] = -(this.m_origvec[n].m_data[(n4 + 1) % 3] + this.m_origvec[n].m_data[(n4 + 2) % 3]);
                PdVector pdVector = new PdVector(0.0, 0.0, 0.0);
                n2 = 0;
                do {
                    int n5 = 0;
                    do {
                        int n6 = n2;
                        pdVector.m_data[n6] = pdVector.m_data[n6] + this.m_origvec[n].m_data[n5] * pdVectorArray[piVectorArray[n3].m_data[n5]].m_data[n2];
                    } while (++n5 < 3);
                } while (++n2 < 3);
                if (this.m_vec.getNumVectors() <= n) {
                    System.err.println(this.m_vec.getNumVectors());
                }
                this.m_vec.setVector(n, pdVector);
            }
            ++n;
        }
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void calculateRepresentations() {
        if (this.m_geom == null) {
            PsDebug.warning((String)"No valid geometry");
            return;
        }
        if (this.m_method == 4) {
            this.m_ode = new PnTranslationRK(this.m_geom);
            ((PnTranslationRK)this.m_ode).setVectorField(this.m_origelem, this.m_origvec, this.m_origlocvertind);
            return;
        }
        if (this.m_geom.getNumElements() < 1) {
            return;
        }
        this.m_altvec = new PdBaryDir[this.m_geom.getNumElements()][3];
        PiVector piVector = new PiVector();
        PiVector piVector2 = new PiVector();
        int n = 0;
        while (n < this.m_geom.getNumVertices()) {
            PdBaryDir[] pdBaryDirArray = this.m_method == 2 ? PwBary.getGeodRepresentation((PgElementSet)this.m_geom, (int)this.m_origelem[n], (PdBaryDir)this.m_origvec[n], (int)this.m_origlocvertind[n], (PiVector)piVector, (PiVector)piVector2) : (this.m_method == 3 ? PwBary.getTransRepresentation((PgElementSet)this.m_geom, (int)this.m_origelem[n], (PdBaryDir)this.m_origvec[n], (int)this.m_origlocvertind[n], (PiVector)piVector, (PiVector)piVector2) : PwBary.getProjRepresentation((PgElementSet)this.m_geom, (int)this.m_origelem[n], (PdBaryDir)this.m_origvec[n], (int)this.m_origlocvertind[n], (PiVector)piVector, (PiVector)piVector2));
            int n2 = piVector.getSize();
            int n3 = 0;
            while (n3 < n2) {
                this.m_altvec[piVector.m_data[n3]][piVector2.m_data[n3]] = pdBaryDirArray[n3];
                ++n3;
            }
            ++n;
        }
        this.m_ode = new PnVertexRK(this.m_geom);
        ((PnVertexRK)this.m_ode).setVectorField(this.m_altvec);
    }

    public void run() {
        PnTranslationRK pnTranslationRK;
        this.m_origLabel = this.m_LICButton.getLabel();
        this.m_LICButton.setLabel("preparing LIC");
        PgElementSet pgElementSet = this.m_geom;
        pgElementSet.showElements(true);
        pgElementSet.showElementTexture(true);
        if (this.getDisplay() != null) {
            this.getDisplay().showDepthcue(false);
        }
        if (this.m_method == 4) {
            pnTranslationRK = new PnTranslationRK(pgElementSet);
            pnTranslationRK.setVectorField(this.m_origelem, this.m_origvec, this.m_origlocvertind);
        } else {
            pnTranslationRK = new PnVertexRK(pgElementSet);
            ((PnVertexRK)pnTranslationRK).setVectorField(this.m_altvec);
        }
        pnTranslationRK.setFirstOrder(this.m_fast);
        PgTexture pgTexture = new PgTexture();
        Frame frame = PsConfig.getFrame();
        int n = this.m_LICSize.getValue();
        PnLIC pnLIC = new PnLIC(pgElementSet, n, 0.0, (PnGeodesicRK)pnTranslationRK);
        n = pnLIC.getTextureWidth();
        int n2 = pnLIC.getTextureHeight();
        int[] nArray = new int[n * n2];
        long l = new Date().getTime();
        int n3 = pgElementSet.getNumElements();
        this.m_LICButton.setLabel("LIC 0%");
        int n4 = n3 - 1;
        while (n4 >= 0) {
            pnLIC.makeElement(n4);
            if (n3 >= 10 && n4 % (n3 / 10) == 0) {
                this.m_LICButton.setLabel("LIC " + (100 - (int)((double)n4 / ((double)n3 / 10.0) * 10.0)) + "%");
                pnLIC.getPixArray(nArray);
                pgTexture.setImage(frame.createImage(new MemoryImageSource(n, n2, nArray, 0, n)));
                pgElementSet.setTexture(pgTexture);
                pgElementSet.update(null);
            } else if (n3 < 10) {
                this.m_LICButton.setLabel("LIC " + (double)(n3 - 1 - n4) * 100.0 / (double)n3 + "%");
                pnLIC.getPixArray(nArray);
                pgTexture.setImage(frame.createImage(new MemoryImageSource(n, n2, nArray, 0, n)));
                pgElementSet.setTexture(pgTexture);
                pgElementSet.update(null);
            }
            if (this.m_LIC == null || this.m_LIC.isInterrupted()) {
                return;
            }
            --n4;
        }
        long l2 = new Date().getTime() - l;
        this.m_LICButton.setLabel(this.m_origLabel);
        pnLIC.getPixArray(nArray);
        pgTexture.setImage(frame.createImage(new MemoryImageSource(n, n2, nArray, 0, n)));
        pgElementSet.setTexture(pgTexture);
        pgElementSet.update(null);
        this.m_time.setText("LIC time: " + l2 + " ms");
        System.gc();
    }

    public void init() {
        super.init();
        this.addGeometry((PgGeometryIf)this.m_poly);
        this.m_method = 1;
        this.m_length.setDefBounds(0.05, 10.0, 0.5, 1.0);
        this.m_length.setDefValue(1.0);
        this.m_length.init();
        this.m_discr.setDefBounds(2, 100, 5, 10);
        this.m_discr.setDefValue(20);
        this.m_discr.init();
        this.m_LICSize.setDefBounds(10, 500, 10, 50);
        this.m_LICSize.setDefValue(130);
        this.m_LICSize.init();
    }

    public void pickInitial(PvPickEvent pvPickEvent) {
        if (pvPickEvent.getElementInd() < 0) {
            return;
        }
        this.m_bary = pvPickEvent.getBary();
        this.m_elemInd = pvPickEvent.getElementInd();
        this.calculateCurve();
        this.m_poly.update(null);
    }

    public void calculateCurve() {
        if (this.m_geom == null) {
            PsDebug.warning((String)"No valid geometry");
            return;
        }
        this.m_curveallreadythere = true;
        PgPolygonOnElementSet pgPolygonOnElementSet = new PgPolygonOnElementSet(this.m_geom);
        this.m_ode.setFirstOrder(this.m_fast);
        this.m_ode.solve(pgPolygonOnElementSet, this.m_elemInd, this.m_bary, this.m_length.getValue() / (double)this.m_discr.getValue(), this.m_discr.getValue());
        pgPolygonOnElementSet.getPolygon(this.m_poly);
    }
}

