/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;

class DrawControls
extends Panel {
    DrawPanel target;
    CheckboxGroup mouse_group = new CheckboxGroup();
    CheckboxGroup fineness_group = new CheckboxGroup();

    public DrawControls(DrawPanel drawPanel) {
        this.target = drawPanel;
        this.setLayout(new FlowLayout());
        this.setBackground(Color.lightGray);
        drawPanel.setForeground(Color.red);
        Checkbox checkbox = new Checkbox("Rotate", this.mouse_group, true);
        this.add(checkbox);
        checkbox = new Checkbox("Translate", this.mouse_group, false);
        this.add(checkbox);
        checkbox = new Checkbox("Scale", this.mouse_group, false);
        this.add(checkbox);
        checkbox = new Checkbox("Spin", this.mouse_group, false);
        this.add(checkbox);
        this.add(new Label("Fineness: "));
        checkbox = new Checkbox("1", this.fineness_group, false);
        this.add(checkbox);
        checkbox = new Checkbox("2", this.fineness_group, true);
        this.add(checkbox);
        checkbox = new Checkbox("4", this.fineness_group, false);
        this.add(checkbox);
        checkbox = new Checkbox("8", this.fineness_group, false);
        this.add(checkbox);
        checkbox = new Checkbox("16", this.fineness_group, false);
        this.add(checkbox);
        drawPanel.setForeground(checkbox.getForeground());
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle = this.bounds();
        graphics.setColor(Color.lightGray);
        graphics.draw3DRect(0, 0, rectangle.width, rectangle.height, false);
    }

    public boolean action(Event event, Object object) {
        if (event.target instanceof Checkbox) {
            Checkbox checkbox = (Checkbox)event.target;
            String string = checkbox.getLabel();
            if (checkbox.getCheckboxGroup() == this.fineness_group) {
                if (string.equals("1")) {
                    this.target.setFineness(1);
                } else if (string.equals("2")) {
                    this.target.setFineness(2);
                } else if (string.equals("4")) {
                    this.target.setFineness(4);
                } else if (string.equals("8")) {
                    this.target.setFineness(8);
                } else if (string.equals("16")) {
                    this.target.setFineness(16);
                }
            } else if (checkbox.getCheckboxGroup() == this.mouse_group) {
                if (string.equals("Rotate")) {
                    this.target.setMouseMode(2);
                } else if (string.equals("Translate")) {
                    this.target.setMouseMode(4);
                } else if (string.equals("Scale")) {
                    this.target.setMouseMode(3);
                } else if (string.equals("Spin")) {
                    this.target.setMouseMode(1);
                }
            }
        }
        return true;
    }
}

