/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.util.Vector;

class DrawPanel
extends Panel {
    static final int TRIPLE = 1;
    static final int BOUNDARY = 2;
    public static final int MM_SPIN = 1;
    public static final int MM_ROTATE = 2;
    public static final int MM_SCALE = 3;
    public static final int MM_TRANSLATE = 4;
    Retract applet;
    static final int HOMDIM = 4;
    double xscale = 1.0;
    double yscale = 1.0;
    int mouse_mode = 2;
    Vector lines = new Vector();
    Vector colors = new Vector();
    int x1;
    int y1;
    int x2;
    int y2;
    int xl;
    int yl;
    Point3 leftcenter = new Point3();
    Point3 rightcenter = new Point3();
    public static final double majorR = 1.0;
    public static final double minorR = 0.3;
    double RingHeight = 0.2;
    double RingRadius = 1.0;
    double RingTripleRadius = 0.8 * this.RingRadius;
    double TorusPhi = 1.0471975511965976;
    double RingStart = Math.asin(0.3 * Math.sin(this.TorusPhi) / this.RingRadius);
    double RingStop = Math.PI * 2 - this.RingStart;
    double TorusStart = Math.asin(this.RingHeight / (1.0 + 0.3 * Math.cos(this.TorusPhi)));
    double RingOffset = this.RingRadius * Math.cos(this.RingStart) + (1.0 + 0.3 * Math.cos(this.TorusPhi)) * Math.cos(this.TorusStart);
    double TetraOffset = (1.0 + this.RingOffset - this.RingRadius) / 2.0;
    double RingTripleStart = Math.acos(this.RingTripleRadius / (this.RingOffset - this.TetraOffset));
    double TorusTripleStart = Math.acos(1.0 / this.TetraOffset);
    double curveParam;
    public Transform view = new Transform();
    double oldx;
    double oldy;
    double newx;
    double newy;
    double basex;
    double basey;
    Graphics gg;
    Graphics workGraphic;
    Image workImage;
    Point3[] BdryPoints = new Point3[2000];
    Point3[] TriplePoints = new Point3[2000];
    Point3[] CurvePoints = new Point3[2000];
    Facet[] quads = new Facet[2000];
    Facet[] sortedquads = new Facet[2000];
    int quadcount;
    int stripquadcount;
    int BdryPointCount;
    int TriplePointCount;
    int CurvePointCount;
    public int fineness = 2;
    boolean view_changed = true;
    int w = 800;
    int h = 400;
    int retract_stage = -250;
    Point3[] DragPoints = new Point3[100];
    int DragPointCount = 100;
    final double stage1 = 0.2;
    int rustart;
    int ruend;
    int lustart;
    int luend;
    int mid;
    int rlstart;
    int rlend;
    int llstart;
    int llend;

    public DrawPanel() {
        this.view.a[0][1] = 100.0;
        this.view.a[1][2] = -100.0;
        this.view.a[0][3] = this.w / 2;
        this.view.a[1][3] = this.h / 2;
        this.view.a[2][0] = 100.0;
        this.view.a[3][3] = 1.0;
        this.view.to_focus[0][0] = 1.0;
        this.view.to_focus[0][3] = -this.w / 2;
        this.view.to_focus[1][1] = 1.0;
        this.view.to_focus[1][3] = -this.h / 2;
        this.view.to_focus[2][2] = 1.0;
        this.view.to_focus[3][3] = 1.0;
        this.view.from_focus[0][0] = 1.0;
        this.view.from_focus[0][3] = this.w / 2;
        this.view.from_focus[1][1] = 1.0;
        this.view.from_focus[1][3] = this.h / 2;
        this.view.from_focus[2][2] = 1.0;
        this.view.from_focus[3][3] = 1.0;
        this.leftcenter.x = 0.0;
        this.leftcenter.y = -this.RingOffset;
        this.leftcenter.z = 0.0;
        this.rightcenter.x = 0.0;
        this.rightcenter.y = this.RingOffset;
        this.rightcenter.z = 0.0;
        this.setBackground(Color.white);
        this.generate_retract();
        this.prepare_view();
        this.repaint();
    }

    public void resize(int n, int n2) {
        super.resize(n, n2);
    }

    public void setFineness(int n) {
        this.fineness = n;
        this.generate_retract();
        this.repaint();
    }

    public void setMouseMode(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.mouse_mode = n;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 501: {
                this.oldx = event.x;
                this.oldy = event.y;
                this.repaint();
                return true;
            }
            case 502: {
                this.basex = this.newx;
                this.basey = this.newy;
                this.repaint();
                return true;
            }
            case 506: {
                this.newx = event.x;
                this.newy = event.y;
                switch (this.mouse_mode) {
                    case 2: {
                        this.view.mult(this.view.to_focus);
                        this.view.fix_ctm(this.newx - this.oldx, -(this.newy - this.oldy));
                        this.view.mult(this.view.from_focus);
                        break;
                    }
                    case 3: {
                        this.view.mult(this.view.to_focus);
                        int n = 0;
                        while (n < 3) {
                            int n2 = 0;
                            while (n2 < 4) {
                                double[] dArray = this.view.a[n];
                                int n3 = n2++;
                                dArray[n3] = dArray[n3] * (1.0 + 0.002 * (this.newx - this.oldx));
                            }
                            ++n;
                        }
                        this.view.mult(this.view.from_focus);
                        break;
                    }
                    case 4: {
                        double[] dArray = this.view.a[0];
                        dArray[3] = dArray[3] + (this.newx - this.oldx) * this.xscale;
                        double[] dArray2 = this.view.a[1];
                        dArray2[3] = dArray2[3] + (this.newy - this.oldy) * this.yscale;
                        double[] dArray3 = this.view.to_focus[0];
                        dArray3[3] = dArray3[3] - (this.newx - this.oldx) * this.xscale;
                        double[] dArray4 = this.view.to_focus[1];
                        dArray4[3] = dArray4[3] - (this.newy - this.oldy) * this.yscale;
                        double[] dArray5 = this.view.from_focus[0];
                        dArray5[3] = dArray5[3] + (this.newx - this.oldx) * this.xscale;
                        double[] dArray6 = this.view.from_focus[1];
                        dArray6[3] = dArray6[3] + (this.newy - this.oldy) * this.yscale;
                        break;
                    }
                    case 1: {
                        double[][] dArray = new double[4][4];
                        int n = 0;
                        while (n < 4) {
                            int n4 = 0;
                            while (n4 < 4) {
                                dArray[n][n4] = 0.0;
                                ++n4;
                            }
                            dArray[n][n] = 1.0;
                            ++n;
                        }
                        double d = (this.newx - this.oldx) / 300.0 * Math.PI;
                        double d2 = Math.cos(d);
                        dArray[0][0] = d2;
                        dArray[1][1] = d2;
                        double d3 = Math.sin(d);
                        dArray[0][1] = d3;
                        dArray[1][0] = -d3;
                        this.view.mult(this.view.to_focus);
                        this.view.mult(dArray);
                        this.view.mult(this.view.from_focus);
                        break;
                    }
                }
                this.oldx = this.newx;
                this.oldy = this.newy;
                this.view_changed = true;
                this.repaint();
                return true;
            }
            case 201: {
                System.exit(0);
                return true;
            }
        }
        return super.handleEvent(event);
    }

    /*
     * Unable to fully structure code
     */
    void QuickSort(Facet[] var1_1, int var2_2, int var3_3) {
        block5: {
            var4_4 = var2_2;
            var5_5 = var3_3;
            if (var3_3 <= var2_2) break block5;
            var6_6 = var1_1[(var2_2 + var3_3) / 2].midz;
            ** GOTO lbl18
            {
                ++var4_4;
                do {
                    if (var4_4 < var3_3 && var1_1[var4_4].midz < var6_6) continue block0;
                    while (var5_5 > var2_2 && var1_1[var5_5].midz > var6_6) {
                        --var5_5;
                    }
                    if (var4_4 > var5_5) continue;
                    var8_7 = var1_1[var4_4];
                    var1_1[var4_4] = var1_1[var5_5];
                    var1_1[var5_5] = var8_7;
                    ++var4_4;
                    --var5_5;
lbl18:
                    // 3 sources

                } while (var4_4 <= var5_5);
            }
            if (var2_2 < var5_5) {
                this.QuickSort(var1_1, var2_2, var5_5);
            }
            if (var4_4 < var3_3) {
                this.QuickSort(var1_1, var4_4, var3_3);
            }
        }
    }

    void draw_quad(Facet facet) {
        if (facet.retract_stage >= this.retract_stage && facet.type != 4) {
            if (this.retract_stage > -250) {
                this.gg.setColor(facet.c);
            } else if ((this.curveParam == 0.0 || this.curveParam == 1.0) && facet.type == 2) {
                this.gg.setColor(Color.green);
            } else if (this.curveParam == 0.5 && facet.type == 3) {
                this.gg.setColor(Color.green);
            } else {
                this.gg.setColor(facet.c);
            }
            this.gg.fillPolygon(facet.x, facet.y, 4);
        }
        if (facet.type == 1) {
            this.gg.setColor(Color.black);
            this.gg.drawLine(facet.x[0], facet.y[0], facet.x[3], facet.y[3]);
            if (this.retract_stage == -250) {
                this.gg.setColor(Color.green);
                if (facet.curve_tail[0] != null && facet.curve_head[0] != null) {
                    this.gg.drawLine(facet.curve_tail[0].ix, facet.curve_tail[0].iy, facet.curve_head[0].ix, facet.curve_head[0].iy);
                }
                if (facet.curve_tail[1] != null && facet.curve_head[1] != null) {
                    this.gg.drawLine(facet.curve_tail[1].ix, facet.curve_tail[1].iy, facet.curve_head[1].ix, facet.curve_head[1].iy);
                }
            }
        }
        if (facet.type == 4 && this.curveParam == 0.0 && this.retract_stage > -250) {
            this.gg.setColor(Color.black);
            this.gg.drawLine(facet.curve_tail[0].ix, facet.curve_tail[0].iy, facet.curve_head[0].ix, facet.curve_head[0].iy);
        }
    }

    void seg_points(Point3 point3, Point3 point32, int n, int n2) {
        n *= this.fineness;
        int n3 = 1;
        while (n3 <= n) {
            Point3 point33;
            if (n2 == 1) {
                if (this.TriplePoints[this.TriplePointCount] == null) {
                    point33 = new Point3();
                    this.TriplePoints[this.TriplePointCount++] = point33;
                } else {
                    point33 = this.TriplePoints[this.TriplePointCount++];
                }
            } else if (this.BdryPoints[this.BdryPointCount] == null) {
                point33 = new Point3();
                this.BdryPoints[this.BdryPointCount++] = point33;
            } else {
                point33 = this.BdryPoints[this.BdryPointCount++];
            }
            point33.x = ((double)(n - n3) * point3.x + (double)n3 * point32.x) / (double)n;
            point33.y = ((double)(n - n3) * point3.y + (double)n3 * point32.y) / (double)n;
            point33.z = ((double)(n - n3) * point3.z + (double)n3 * point32.z) / (double)n;
            ++n3;
        }
    }

    void torus_arc_points(double d, double d2, double d3, double d4, double d5, int n, int n2) {
        double d6 = (d5 - d4) / (double)(n *= this.fineness);
        double d7 = (d3 - d2) / (double)n;
        double d8 = d4;
        double d9 = d2;
        d8 += d6;
        d9 += d7;
        int n3 = 0;
        while (n3 < n) {
            Point3 point3;
            if (n2 == 1) {
                if (this.TriplePoints[this.TriplePointCount] == null) {
                    point3 = new Point3();
                    this.TriplePoints[this.TriplePointCount++] = point3;
                } else {
                    point3 = this.TriplePoints[this.TriplePointCount++];
                }
            } else if (this.BdryPoints[this.BdryPointCount] == null) {
                point3 = new Point3();
                this.BdryPoints[this.BdryPointCount++] = point3;
            } else {
                point3 = this.BdryPoints[this.BdryPointCount++];
            }
            point3.x = d * Math.sin(d9);
            point3.y = (1.0 + d * Math.cos(d9)) * Math.cos(d8);
            point3.z = (1.0 + d * Math.cos(d9)) * Math.sin(d8);
            d8 += d6;
            d9 += d7;
            ++n3;
        }
    }

    void side_ring_points(double d, double d2, double d3, double d4, double d5, int n, int n2) {
        double d6 = (d5 - d4) / (double)(n *= this.fineness);
        double d7 = d4;
        d7 = d4 + d6;
        int n3 = 0;
        while (n3 < n) {
            Point3 point3;
            if (n2 == 1) {
                if (this.TriplePoints[this.TriplePointCount] == null) {
                    point3 = new Point3();
                    this.TriplePoints[this.TriplePointCount++] = point3;
                } else {
                    point3 = this.TriplePoints[this.TriplePointCount++];
                }
            } else if (this.BdryPoints[this.BdryPointCount] == null) {
                point3 = new Point3();
                this.BdryPoints[this.BdryPointCount++] = point3;
            } else {
                point3 = this.BdryPoints[this.BdryPointCount++];
            }
            point3.x = d3 * Math.sin(d7);
            point3.y = d2 - d3 * Math.cos(d7);
            point3.z = d;
            d7 += d6;
            ++n3;
        }
    }

    void generate_points() {
        Point3 point3 = new Point3();
        Point3 point32 = new Point3();
        Point3 point33 = new Point3();
        this.BdryPointCount = 0;
        this.TriplePointCount = 0;
        if (this.BdryPoints[0] == null) {
            this.BdryPoints[0] = new Point3();
        }
        this.BdryPoints[0].x = 0.0;
        this.BdryPoints[0].y = -0.7;
        this.BdryPoints[0].z = 0.0;
        ++this.BdryPointCount;
        this.torus_arc_points(0.3, Math.PI, 1.0471975511965976, Math.PI, this.TorusStart, 10, 2);
        this.rustart = this.BdryPointCount - 1;
        this.side_ring_points(this.RingHeight, this.RingOffset, this.RingRadius, this.RingStart, this.RingStop, 10, 2);
        this.ruend = this.BdryPointCount - 1;
        this.torus_arc_points(0.3, 5.235987755982989, 7.330382858376184, this.TorusStart, Math.PI - this.TorusStart, 10, 2);
        this.lustart = this.BdryPointCount - 1;
        this.side_ring_points(this.RingHeight, -this.RingOffset, -this.RingRadius, this.RingStop, this.RingStart, 10, 2);
        this.luend = this.BdryPointCount - 1;
        this.torus_arc_points(0.3, 5.235987755982989, Math.PI, Math.PI - this.TorusStart, 0.0, 10, 2);
        this.mid = this.BdryPointCount - 1;
        this.torus_arc_points(0.3, Math.PI, 5.235987755982989, Math.PI * 2, Math.PI + this.TorusStart, 10, 2);
        this.llstart = this.BdryPointCount - 1;
        this.side_ring_points(-this.RingHeight, -this.RingOffset, -this.RingRadius, this.RingStart, this.RingStop, 10, 2);
        this.llend = this.BdryPointCount - 1;
        this.torus_arc_points(0.3, 7.330382858376184, 5.235987755982989, Math.PI + this.TorusStart, Math.PI * 2 - this.TorusStart, 10, 2);
        this.rlstart = this.BdryPointCount - 1;
        this.side_ring_points(-this.RingHeight, this.RingOffset, this.RingRadius, this.RingStop, this.RingStart, 10, 2);
        this.rlend = this.BdryPointCount - 1;
        this.torus_arc_points(0.3, 1.0471975511965976, Math.PI, Math.PI * 2 - this.TorusStart, Math.PI, 10, 2);
        point3.x = 0.0;
        point3.y = -this.TetraOffset;
        point3.z = 0.0;
        if (this.TriplePoints[0] == null) {
            this.TriplePoints[0] = new Point3();
        }
        this.TriplePoints[0].x = 0.0;
        this.TriplePoints[0].y = -this.TetraOffset;
        this.TriplePoints[0].z = 0.0;
        ++this.TriplePointCount;
        point33.x = 0.0;
        point33.y = -1.0 * Math.cos(this.TorusTripleStart);
        point33.z = Math.sin(this.TorusTripleStart);
        this.seg_points(point3, point33, 1, 1);
        this.torus_arc_points(0.0, 0.0, 0.0, Math.PI - this.TorusTripleStart, this.TorusTripleStart, 8, 1);
        point33.y *= -1.0;
        point3.y *= -1.0;
        this.seg_points(point33, point3, 1, 1);
        point32.x = this.RingTripleRadius * Math.sin(this.RingTripleStart);
        point32.y = this.RingOffset - this.RingTripleRadius * Math.cos(this.RingTripleStart);
        point32.z = 0.0;
        this.seg_points(point3, point32, 1, 1);
        this.side_ring_points(0.0, this.RingOffset, this.RingTripleRadius, this.RingTripleStart, Math.PI * 2 - this.RingTripleStart, 8, 1);
        point32.x = -point32.x;
        this.seg_points(point32, point3, 1, 1);
        this.seg_points(point3, point33, 1, 1);
        this.torus_arc_points(0.0, 0.0, 0.0, this.TorusTripleStart, Math.PI - this.TorusTripleStart, 8, 1);
        point33.y *= -1.0;
        point3.y *= -1.0;
        this.seg_points(point33, point3, 1, 1);
        point32.x *= -1.0;
        point32.y *= -1.0;
        this.seg_points(point3, point32, 1, 1);
        this.side_ring_points(0.0, -this.RingOffset, -this.RingTripleRadius, Math.PI * 2 - this.RingTripleStart, this.RingTripleStart, 8, 1);
        point32.x *= -1.0;
        this.seg_points(point32, point3, 1, 1);
        this.seg_points(point3, point33, 1, 1);
        this.torus_arc_points(0.0, 0.0, 0.0, Math.PI - this.TorusTripleStart, this.TorusTripleStart, 8, 1);
        point33.y *= -1.0;
        point3.y *= -1.0;
        this.seg_points(point33, point3, 1, 1);
        point33.z *= -1.0;
        this.seg_points(point3, point33, 1, 1);
        this.torus_arc_points(0.0, 0.0, 0.0, Math.PI * 2 - this.TorusTripleStart, Math.PI + this.TorusTripleStart, 8, 1);
        point33.y *= -1.0;
        point3.y *= -1.0;
        this.seg_points(point33, point3, 1, 1);
        this.seg_points(point3, point32, 1, 1);
        this.side_ring_points(0.0, -this.RingOffset, -this.RingTripleRadius, this.RingTripleStart, Math.PI * 2 - this.RingTripleStart, 8, 1);
        point32.x *= -1.0;
        this.seg_points(point32, point3, 1, 1);
        this.seg_points(point3, point33, 1, 1);
        this.torus_arc_points(0.0, 0.0, 0.0, Math.PI + this.TorusTripleStart, Math.PI * 2 - this.TorusTripleStart, 8, 1);
        point33.y *= -1.0;
        point3.y *= -1.0;
        this.seg_points(point33, point3, 1, 1);
        point32.x *= -1.0;
        point32.y *= -1.0;
        this.seg_points(point3, point32, 1, 1);
        this.side_ring_points(0.0, this.RingOffset, this.RingTripleRadius, Math.PI * 2 - this.RingTripleStart, this.RingTripleStart, 8, 1);
        point32.x *= -1.0;
        this.seg_points(point32, point3, 1, 1);
        this.seg_points(point3, point33, 1, 1);
        this.torus_arc_points(0.0, 0.0, 0.0, Math.PI * 2 - this.TorusTripleStart, Math.PI + this.TorusTripleStart, 8, 1);
        point33.y *= -1.0;
        point3.y *= -1.0;
        this.seg_points(point33, point3, 1, 1);
        double d = 0.0;
        int n = 0;
        while (n < this.BdryPointCount - 1) {
            Point3 point34 = this.BdryPoints[n];
            Point3 point35 = this.BdryPoints[n + 1];
            point34.level = d;
            d += Math.sqrt((point35.x - point34.x) * (point35.x - point34.x) + (point35.y - point34.y) * (point35.y - point34.y) + (point35.z - point34.z) * (point35.z - point34.z));
            ++n;
        }
        this.BdryPoints[this.BdryPointCount - 1].level = d;
        n = 0;
        while (n < 30 * this.fineness) {
            this.TriplePoints[n].level = this.BdryPoints[this.BdryPointCount / 2].level;
            ++n;
        }
        while (n <= 40 * this.fineness) {
            this.TriplePoints[n].level = this.BdryPoints[0].level;
            ++n;
        }
        while (n < 60 * this.fineness) {
            this.TriplePoints[n].level = this.BdryPoints[this.BdryPointCount / 2].level;
            ++n;
        }
        while (n <= 70 * this.fineness) {
            this.TriplePoints[n].level = this.BdryPoints[this.BdryPointCount - 1].level;
            ++n;
        }
        while (n < 100 * this.fineness) {
            this.TriplePoints[n].level = this.BdryPoints[this.BdryPointCount / 2].level;
            ++n;
        }
    }

    void generate_curve() {
        int n;
        double d;
        double d2;
        double d3;
        double d4 = this.BdryPoints[this.BdryPointCount - 1].level;
        double d5 = this.curveParam * d4;
        int n2 = 0;
        while (n2 < this.CurvePointCount) {
            this.CurvePoints[n2] = null;
            ++n2;
        }
        this.CurvePointCount = 0;
        int n3 = 0;
        while (n3 < this.quadcount) {
            this.quads[n3].curve_head[0] = null;
            this.quads[n3].curve_tail[0] = null;
            this.quads[n3].curve_head[1] = null;
            this.quads[n3].curve_tail[1] = null;
            ++n3;
        }
        n2 = 0;
        n3 = 0;
        while (n3 < this.BdryPointCount) {
            block46: {
                block48: {
                    double d6;
                    block50: {
                        block51: {
                            block49: {
                                block47: {
                                    block45: {
                                        if ((n3 < this.lustart || n3 > this.luend) && (n3 < this.llstart || n3 > this.llend)) break block45;
                                        d6 = (d5 - this.BdryPoints[n3].level) / (d4 / 2.0 - this.BdryPoints[n3].level);
                                        if (d6 < 1.0 && d6 > 0.0) {
                                            d3 = (1.0 - (d6 /= 2.0)) * this.BdryPoints[n3].x + d6 * this.TriplePoints[n3].x;
                                            d2 = (1.0 - d6) * this.BdryPoints[n3].y + d6 * this.TriplePoints[n3].y;
                                            d = (1.0 - d6) * this.BdryPoints[n3].z + d6 * this.TriplePoints[n3].z;
                                            if (n2 >= this.CurvePointCount) {
                                                this.CurvePoints[n2] = new Point3();
                                                ++this.CurvePointCount;
                                            }
                                            this.CurvePoints[n2].x = d3;
                                            this.CurvePoints[n2].y = d2;
                                            this.CurvePoints[n2].z = d;
                                            if (n3 < this.BdryPointCount - 1) {
                                                this.quads[n3].curve_tail[0] = this.CurvePoints[n2];
                                            }
                                            if (n3 > 0) {
                                                this.quads[n3 - 1].curve_head[0] = this.CurvePoints[n2];
                                            }
                                            ++n2;
                                        }
                                        if ((d6 = (d5 - d4 / 2.0) / (this.TriplePoints[n3].level - d4 / 2.0)) <= 1.0 && d6 >= 0.0) {
                                            d6 = d6 / 2.0 + 0.5;
                                            d3 = (1.0 - d6) * this.BdryPoints[n3].x + d6 * this.TriplePoints[n3].x;
                                            d2 = (1.0 - d6) * this.BdryPoints[n3].y + d6 * this.TriplePoints[n3].y;
                                            d = (1.0 - d6) * this.BdryPoints[n3].z + d6 * this.TriplePoints[n3].z;
                                            if (n2 >= this.CurvePointCount) {
                                                this.CurvePoints[n2] = new Point3();
                                                ++this.CurvePointCount;
                                            }
                                            this.CurvePoints[n2].x = d3;
                                            this.CurvePoints[n2].y = d2;
                                            this.CurvePoints[n2].z = d;
                                            if (n3 < this.BdryPointCount - 1) {
                                                this.quads[n3].curve_tail[1] = this.CurvePoints[n2];
                                            }
                                            if (n3 > 0) {
                                                this.quads[n3 - 1].curve_head[1] = this.CurvePoints[n2];
                                            }
                                            ++n2;
                                        }
                                        break block46;
                                    }
                                    if (n3 <= 0 || !(d5 >= this.BdryPoints[n3 - 1].level) || !(d5 < this.BdryPoints[n3].level)) break block47;
                                    d6 = (d5 - this.BdryPoints[n3].level) / (this.BdryPoints[n3 - 1].level - this.BdryPoints[n3].level);
                                    d3 = d6 * this.BdryPoints[n3 - 1].x + (1.0 - d6) * this.BdryPoints[n3].x;
                                    d2 = d6 * this.BdryPoints[n3 - 1].y + (1.0 - d6) * this.BdryPoints[n3].y;
                                    d = d6 * this.BdryPoints[n3 - 1].z + (1.0 - d6) * this.BdryPoints[n3].z;
                                    break block48;
                                }
                                if (this.curveParam != 0.5) break block49;
                                d6 = 1.0;
                                break block50;
                            }
                            if (n3 != this.mid) break block51;
                            d6 = 0.0;
                            break block50;
                        }
                        d6 = (d5 - this.BdryPoints[n3].level) / (this.TriplePoints[n3].level - this.BdryPoints[n3].level);
                        if (d6 > 1.0 || d6 < 0.0) break block46;
                    }
                    d3 = (1.0 - d6) * this.BdryPoints[n3].x + d6 * this.TriplePoints[n3].x;
                    d2 = (1.0 - d6) * this.BdryPoints[n3].y + d6 * this.TriplePoints[n3].y;
                    d = (1.0 - d6) * this.BdryPoints[n3].z + d6 * this.TriplePoints[n3].z;
                }
                if (n2 >= this.CurvePointCount) {
                    this.CurvePoints[n2] = new Point3();
                    ++this.CurvePointCount;
                }
                this.CurvePoints[n2].x = d3;
                this.CurvePoints[n2].y = d2;
                this.CurvePoints[n2].z = d;
                if (n3 < this.BdryPointCount - 1) {
                    this.quads[n3].curve_tail[0] = this.CurvePoints[n2];
                }
                if (n3 > 0) {
                    this.quads[n3 - 1].curve_head[0] = this.CurvePoints[n2];
                }
                ++n2;
            }
            ++n3;
        }
        if (this.curveParam > 0.0 && this.curveParam <= 0.5) {
            double d7;
            d3 = this.quads[this.lustart].curve_tail[1].z;
            n = 0;
            while (n < 20) {
                if (this.quads[n].curve_head[0] == null || this.quads[n].curve_head[0].z > d3) break;
                ++n;
            }
            d2 = this.TriplePoints[n + 1].z;
            d = d3 / d2;
            this.quads[n].curve_tail[0].y = (1.0 - d) * this.TriplePoints[0].y + d * this.TriplePoints[n + 1].y;
            this.quads[n].curve_tail[0].z = d3;
            int n4 = 0;
            while (n4 <= n) {
                this.quads[this.lustart - 1 - n4].curve_tail[1] = this.quads[n].curve_tail[0];
                this.quads[this.lustart - 1 - n4].curve_head[1] = this.quads[this.lustart].curve_tail[1];
                this.quads[this.luend + n4].curve_tail[1] = this.quads[n].curve_tail[0];
                this.quads[this.luend + n4].curve_head[1] = this.quads[this.luend - 1].curve_tail[1];
                ++n4;
            }
            n4 = 0;
            while (n4 < n) {
                this.quads[n4].curve_tail[0] = this.quads[n].curve_tail[0];
                this.quads[n4].curve_head[0] = this.quads[this.lustart].curve_tail[1];
                ++n4;
            }
            if (this.quads[this.lustart].curve_tail[0] != null) {
                d7 = this.quads[this.lustart].curve_tail[0].z;
                n4 = this.lustart - 1;
                while (n4 > 0) {
                    if (this.quads[n4].curve_tail[0].z > d7) break;
                    --n4;
                }
                n3 = n4;
                while (n3 < this.lustart) {
                    this.quads[n3].curve_tail[0] = this.quads[n4].curve_tail[0];
                    this.quads[n3].curve_head[0] = this.quads[this.lustart].curve_tail[0];
                    ++n3;
                }
            }
            if (this.quads[this.luend - 1].curve_head[0] != null) {
                d7 = this.quads[this.luend - 1].curve_head[0].z;
                n4 = this.luend;
                while (n4 < this.luend + 20) {
                    if (this.quads[n4].curve_head[0].z > d7) break;
                    ++n4;
                }
                n3 = this.luend;
                while (n3 <= n4) {
                    this.quads[n3].curve_head[0] = this.quads[n4].curve_head[0];
                    this.quads[n3].curve_tail[0] = this.quads[this.luend - 1].curve_head[0];
                    ++n3;
                }
            }
        }
        if (this.curveParam >= 0.5 && this.curveParam < 1.0) {
            double d8 = this.quads[this.llstart].curve_tail[1].z;
            int n5 = 0;
            n = this.stripquadcount - 1;
            while (n > this.stripquadcount - 20) {
                if (this.quads[n].curve_tail[0] == null || this.quads[n].curve_tail[0].z < d8) break;
                --n;
                ++n5;
            }
            double d9 = this.TriplePoints[n - 1].z;
            double d10 = d8 / d9;
            this.quads[n].curve_head[0].y = (1.0 - d10) * this.TriplePoints[0].y + d10 * this.TriplePoints[n - 1].y;
            this.quads[n].curve_head[0].z = d8;
            int n6 = 0;
            while (n6 <= n5) {
                this.quads[this.llstart - 1 - n6].curve_tail[1] = this.quads[n].curve_head[0];
                this.quads[this.llstart - 1 - n6].curve_head[1] = this.quads[this.llstart].curve_tail[1];
                this.quads[this.llend + n6].curve_head[1] = this.quads[n].curve_head[0];
                this.quads[this.llend + n6].curve_tail[1] = this.quads[this.llend - 1].curve_head[1];
                ++n6;
            }
            n6 = this.stripquadcount - 1;
            while (n6 > n) {
                this.quads[n6].curve_tail[0] = this.quads[n].curve_head[0];
                this.quads[n6].curve_head[0] = this.quads[this.llstart].curve_tail[1];
                --n6;
            }
            if (this.quads[this.llstart].curve_tail[0] != null) {
                double d11 = this.quads[this.llstart].curve_tail[0].z;
                n6 = this.llstart - 1;
                while (n6 > 0) {
                    if (this.quads[n6].curve_tail[0] == null || this.quads[n6].curve_tail[0].z < d11) break;
                    --n6;
                }
                n3 = n6;
                while (n3 < this.llstart) {
                    this.quads[n3].curve_tail[0] = this.quads[n6].curve_tail[0];
                    this.quads[n3].curve_head[0] = this.quads[this.llstart].curve_tail[0];
                    ++n3;
                }
                d11 = this.quads[this.llend - 1].curve_head[0].z;
                n6 = this.llend;
                while (n6 < this.llend + 20) {
                    if (this.quads[n6].curve_head[0].z < d11) break;
                    ++n6;
                }
                n3 = this.llend;
                while (n3 <= n6) {
                    this.quads[n3].curve_head[0] = this.quads[n6].curve_head[0];
                    this.quads[n3].curve_tail[0] = this.quads[this.llend - 1].curve_head[0];
                    ++n3;
                }
            }
            if (this.curveParam > 0.99) {
                this.quads[this.stripquadcount - 1].curve_tail[0] = null;
            }
        }
        if (this.curveParam == 0.5) {
            this.quads[this.mid - 1].curve_tail[0] = this.TriplePoints[this.mid];
            this.quads[this.mid - 1].curve_head[0] = this.BdryPoints[this.mid];
            this.quads[this.mid].curve_tail[0] = this.TriplePoints[this.mid];
            this.quads[this.mid].curve_head[0] = this.BdryPoints[this.mid];
            int n7 = 0;
            while (n7 < 10) {
                if (this.quads[n7].curve_tail[0].z < this.RingHeight / 2.0) {
                    this.quads[n7].curve_tail[0].z = this.RingHeight / 2.0;
                }
                if (this.quads[n7].curve_head[0].z < this.RingHeight / 2.0) {
                    this.quads[n7].curve_head[0].z = this.RingHeight / 2.0;
                }
                if (this.quads[this.stripquadcount - 1 - n7].curve_tail[0].z > -this.RingHeight / 2.0) {
                    this.quads[this.stripquadcount - 1 - n7].curve_tail[0].z = -this.RingHeight / 2.0;
                }
                if (this.quads[this.stripquadcount - 1 - n7].curve_head[0].z > -this.RingHeight / 2.0) {
                    this.quads[this.stripquadcount - 1 - n7].curve_head[0].z = -this.RingHeight / 2.0;
                }
                ++n7;
            }
        }
        if (this.curveParam == 0.0) {
            this.quads[0].curve_head[0] = this.BdryPoints[0];
            this.quads[0].curve_tail[0] = this.TriplePoints[0];
            this.quads[this.stripquadcount - 1].curve_head[0] = this.BdryPoints[0];
            this.quads[this.stripquadcount - 1].curve_tail[0] = this.TriplePoints[0];
        }
        this.prepare_view();
    }

    void regenerate_dragline() {
        double d = this.retract_stage < 0 ? this.BdryPoints[0].y + 2.5 * this.RingRadius * (double)this.retract_stage / 250.0 : this.BdryPoints[0].y;
        int n = 0;
        while (n < this.DragPointCount) {
            if (this.DragPoints[n] == null) {
                this.DragPoints[n] = new Point3();
            }
            this.DragPoints[n].y = d;
            this.DragPoints[n].x = 1.3 * (double)(2 * n - this.DragPointCount) * this.RingRadius / (double)this.DragPointCount;
            this.DragPoints[n].z = 0.0;
            ++n;
        }
    }

    void generate_dragline() {
        this.regenerate_dragline();
        int n = 0;
        while (n < this.DragPointCount - 1) {
            if (this.quads[this.quadcount] == null) {
                this.quads[this.quadcount] = new Facet();
            }
            this.quads[this.quadcount].type = 4;
            this.quads[this.quadcount].retract_stage = 0;
            this.quads[this.quadcount].curve_tail[0] = this.DragPoints[n];
            this.quads[this.quadcount].curve_head[0] = this.DragPoints[n + 1];
            ++this.quadcount;
            ++n;
        }
    }

    void generate_retract() {
        this.RingStart = Math.asin(0.3 * Math.sin(this.TorusPhi) / this.RingRadius);
        this.RingStop = Math.PI * 2 - this.RingStart;
        this.TorusStart = Math.asin(this.RingHeight / (1.0 + 0.3 * Math.cos(this.TorusPhi)));
        this.RingOffset = this.RingRadius * Math.cos(this.RingStart) + (1.0 + 0.3 * Math.cos(this.TorusPhi)) * Math.cos(this.TorusStart);
        this.generate_points();
        this.quadcount = this.stripquadcount = this.BdryPointCount - 1;
        int n = 0;
        while (n < this.stripquadcount) {
            if (this.quads[n] == null) {
                this.quads[n] = new Facet();
            }
            this.quads[n].type = 1;
            this.quads[n].vertex[0] = this.BdryPoints[n];
            this.quads[n].vertex[1] = this.TriplePoints[n];
            this.quads[n].vertex[2] = this.TriplePoints[n + 1];
            this.quads[n].vertex[3] = this.BdryPoints[n + 1];
            this.quads[n].retract_stage = n < this.mid ? n : this.BdryPointCount - n - 2;
            ++n;
        }
        int n2 = 0;
        n = this.rustart;
        while (n < this.ruend) {
            if (this.quads[this.quadcount] == null) {
                this.quads[this.quadcount] = new Facet();
            }
            this.quads[this.quadcount].type = 3;
            this.quads[this.quadcount].vertex[0] = this.rightcenter;
            this.quads[this.quadcount].vertex[1] = this.rightcenter;
            this.quads[this.quadcount].vertex[2] = this.TriplePoints[n];
            this.quads[this.quadcount].vertex[3] = this.TriplePoints[n + 1];
            this.quads[this.quadcount].retract_stage = n++;
            ++this.quadcount;
            ++n2;
        }
        n2 = 0;
        n = this.lustart;
        while (n < this.luend) {
            if (this.quads[this.quadcount] == null) {
                this.quads[this.quadcount] = new Facet();
            }
            this.quads[this.quadcount].type = 2;
            this.quads[this.quadcount].vertex[0] = this.leftcenter;
            this.quads[this.quadcount].vertex[1] = this.leftcenter;
            this.quads[this.quadcount].vertex[2] = this.TriplePoints[n];
            this.quads[this.quadcount].vertex[3] = this.TriplePoints[n + 1];
            this.quads[this.quadcount].retract_stage = n++;
            ++this.quadcount;
            ++n2;
        }
        this.generate_curve();
        this.generate_dragline();
        this.prepare_view();
    }

    void prepare_view() {
        this.leftcenter.transform(this.view);
        this.rightcenter.transform(this.view);
        int n = 0;
        while (n < this.TriplePointCount) {
            this.TriplePoints[n].transform(this.view);
            ++n;
        }
        n = 0;
        while (n < this.BdryPointCount) {
            this.BdryPoints[n].transform(this.view);
            ++n;
        }
        n = 0;
        while (n < this.CurvePointCount) {
            this.CurvePoints[n].transform(this.view);
            ++n;
        }
        n = 0;
        while (n < this.DragPointCount) {
            if (this.DragPoints[n] != null) {
                this.DragPoints[n].transform(this.view);
            }
            ++n;
        }
        n = 0;
        while (n < this.quadcount) {
            if (this.quads[n].type == 4) {
                if (this.quads[n].curve_head[0] != null) {
                    this.quads[n].midz = this.view.a[2][0] * (this.quads[n].curve_head[0].x + this.quads[n].curve_tail[0].x) + this.view.a[2][1] * (this.quads[n].curve_head[0].y + this.quads[n].curve_tail[0].y) + this.view.a[2][2] * (this.quads[n].curve_head[0].z + this.quads[n].curve_tail[0].z);
                }
            } else {
                this.quads[n].midz = this.view.a[2][0] * (this.quads[n].vertex[0].x + this.quads[n].vertex[2].x) + this.view.a[2][1] * (this.quads[n].vertex[0].y + this.quads[n].vertex[2].y) + this.view.a[2][2] * (this.quads[n].vertex[0].z + this.quads[n].vertex[2].z);
            }
            ++n;
        }
        n = 0;
        while (n < this.quadcount) {
            this.sortedquads[n] = this.quads[n];
            ++n;
        }
        this.QuickSort(this.sortedquads, 0, this.quadcount - 1);
        n = 0;
        while (n < this.quadcount) {
            if (this.quads[n].type != 4) {
                Point3 point3 = this.quads[n].vertex[0];
                Point3 point32 = this.quads[n].vertex[1];
                Point3 point33 = this.quads[n].vertex[2];
                Point3 point34 = this.quads[n].vertex[3];
                double d = (point34.y - point32.y) * (point3.z - point33.z) - (point34.z - point32.z) * (point3.y - point33.y);
                double d2 = (point34.z - point32.z) * (point3.x - point33.x) - (point34.x - point32.x) * (point3.z - point33.z);
                double d3 = (point34.x - point32.x) * (point3.y - point33.y) - (point34.y - point32.y) * (point3.x - point33.x);
                double d4 = this.view.a[0][0] * d + this.view.a[0][1] * d2 + this.view.a[0][2] * d3;
                double d5 = this.view.a[1][0] * d + this.view.a[1][1] * d2 + this.view.a[1][2] * d3;
                double d6 = this.view.a[2][0] * d + this.view.a[2][1] * d2 + this.view.a[2][2] * d3;
                if (d6 > 0.0) {
                    d5 = -d5;
                }
                float f = (float)(1.0 + d5 / Math.sqrt(d4 * d4 + d5 * d5 + d6 * d6)) / 2.0f;
                f = (float)(0.4 + (double)(f / 2.0f));
                this.quads[n].c = new Color(f, f, f);
                this.quads[n].x[0] = this.quads[n].vertex[0].ix;
                this.quads[n].x[1] = this.quads[n].vertex[1].ix;
                this.quads[n].x[2] = this.quads[n].vertex[2].ix;
                this.quads[n].x[3] = this.quads[n].vertex[3].ix;
                this.quads[n].y[0] = this.quads[n].vertex[0].iy;
                this.quads[n].y[1] = this.quads[n].vertex[1].iy;
                this.quads[n].y[2] = this.quads[n].vertex[2].iy;
                this.quads[n].y[3] = this.quads[n].vertex[3].iy;
            }
            ++n;
        }
        this.view_changed = false;
    }

    void draw_retract() {
        double d = (double)this.applet.retractSlider.getValue() / (double)(this.applet.retractSlider.getMaximum() - 1 - this.applet.retractSlider.getMinimum());
        this.retract_stage = (d = (d - 0.2) / 0.8) > 0.0 ? (int)(d * (double)this.mid) : (int)(d * 1000.0);
        this.regenerate_dragline();
        if (this.view_changed) {
            this.prepare_view();
        }
        int n = 0;
        while (n < this.quadcount) {
            this.draw_quad(this.sortedquads[n]);
            ++n;
        }
    }

    public void paint(Graphics graphics) {
        this.mypaint(this.workGraphic);
        graphics.drawImage(this.workImage, 0, 0, this);
    }

    public void update(Graphics graphics) {
        this.mypaint(this.workGraphic);
        graphics.drawImage(this.workImage, 0, 0, this);
    }

    void mypaint(Graphics graphics) {
        this.lines.size();
        this.gg = graphics;
        graphics.setColor(this.getForeground());
        graphics.setPaintMode();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.w, this.h);
        graphics.setColor(Color.black);
        this.draw_retract();
    }
}

