/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.StringReader;
import jv.geom.PgElementSet;
import jv.loader.PgLoader;
import jv.loader.PjImportModel;
import jv.loader.PvDisplayLoader;
import jv.loader.PvDisplayOption;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsMainFrame;
import jv.object.PsObject;
import jv.objectGui.GuiStackLayout;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvDisplayIf;
import jv.project.PvPickListenerIf;
import jv.viewer.PvViewer;

public class javaview
extends Applet
implements Runnable {
    protected Frame m_frame = null;
    protected Point m_framePosition = null;
    protected Dimension m_frameSize = null;
    protected PvViewer m_viewer;
    protected PvDisplayIf m_disp;
    protected PvDisplayOption[] m_dispOption = null;
    private String m_drawString = "Initializing ...";

    public void stop() {
        if (this.m_viewer != null) {
            this.m_viewer.stop();
        }
    }

    public void startFromThread() {
        if (this.m_viewer != null) {
            this.m_viewer.start();
        }
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.blue);
        graphics.drawString(PsConfig.getProgram() + " v." + PsConfig.getVersion(), 20, 40);
        graphics.drawString(this.m_drawString, 20, 60);
    }

    public void destroy() {
        if (this.m_viewer != null) {
            this.m_viewer.destroy();
        }
    }

    public PvViewer getViewer() {
        return this.m_viewer;
    }

    public boolean removePickListener(PvPickListenerIf pvPickListenerIf) {
        if (this.m_disp == null) {
            PsDebug.warning("missing display, could not remove listener");
            return false;
        }
        return this.m_disp.removePickListener(pvPickListenerIf);
    }

    private void drawMessage(String string) {
        this.m_drawString = string;
        this.repaint();
    }

    public static void main(String[] stringArray) {
        String string;
        javaview javaview2 = new javaview();
        PsMainFrame psMainFrame = new PsMainFrame(javaview2, stringArray);
        psMainFrame.pack();
        javaview2.m_frame = psMainFrame;
        javaview2.m_viewer = new PvViewer(javaview2, psMainFrame);
        javaview2.m_frameSize = new Dimension(640, 512);
        String string2 = javaview2.m_viewer.getParameter("displayFile");
        if (string2 != null) {
            javaview2.m_dispOption = PvDisplayLoader.read(PsConfig.getCodeBase() + string2);
            if (javaview2.m_dispOption == null || javaview2.m_dispOption.length == 0 || javaview2.m_dispOption[0] == null) {
                javaview2.m_dispOption = null;
                PsDebug.warning("reading of display configuration failed, file = " + string2);
            } else {
                javaview2.m_framePosition = javaview2.m_dispOption[0].getWindowPosition();
                javaview2.m_frameSize = javaview2.m_dispOption[0].getWindowSize();
            }
        } else {
            string = System.getProperty("os.name");
            if (string != null && string.toLowerCase().startsWith("win")) {
                javaview2.m_framePosition = new Point(375, 5);
            }
        }
        if (javaview2.m_viewer != null) {
            try {
                int n;
                int n2;
                String[] stringArray2;
                string = javaview2.m_viewer.getParameter("Size");
                if (string != null) {
                    stringArray2 = PuString.splitString(string, 'x');
                    if (stringArray2 != null && stringArray2.length == 2) {
                        n2 = Integer.parseInt(stringArray2[0]);
                        n = Integer.parseInt(stringArray2[1]);
                        javaview2.m_frameSize = new Dimension(n2, n);
                        if (javaview2.m_dispOption != null) {
                            javaview2.m_dispOption[0].setWindowSize(n2, n);
                        }
                    } else {
                        PsDebug.warning("wrong format in size of display = " + string);
                    }
                }
                if ((string = javaview2.m_viewer.getParameter("Position")) != null) {
                    stringArray2 = PuString.splitString(string, 'x');
                    if (stringArray2 != null && stringArray2.length == 2) {
                        n2 = Integer.parseInt(stringArray2[0]);
                        n = Integer.parseInt(stringArray2[1]);
                        javaview2.m_framePosition = new Point(n2, n);
                        if (javaview2.m_dispOption != null) {
                            javaview2.m_dispOption[0].setWindowPosition(n2, n);
                        }
                    } else {
                        PsDebug.warning("wrong format in size of display = " + string);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                PsDebug.warning("wrong format in size/position of display");
            }
        }
        if (javaview2.m_framePosition != null) {
            ((Component)psMainFrame).setBounds(new Rectangle(javaview2.m_framePosition, javaview2.m_frameSize));
        } else {
            ((Component)psMainFrame).setSize(javaview2.m_frameSize);
        }
        javaview2.init();
        ((Component)psMainFrame).setVisible(true);
    }

    public void addPickListener(PvPickListenerIf pvPickListenerIf) {
        try {
            int n = 100;
            int n2 = 5000;
            int n3 = 0;
            while (this.m_disp == null && n3 < n2 / n) {
                Thread.sleep(n);
                ++n3;
            }
        }
        catch (InterruptedException interruptedException) {}
        if (this.m_disp == null) {
            PsDebug.warning("missing display, could not register pick listener.");
            return;
        }
        this.m_disp.addPickListener(pvPickListenerIf);
    }

    public String getAppletInfo() {
        return "Name: " + this.getClass().getName() + "\r\n" + "Author: " + "Konrad Polthier\r\n" + "Version: " + "3.50\r\n" + "Applet/Application for loading most JavaView projects,\r\n" + "and optional Mathematica/Maple/DXF/WRL/etc parsing" + "\r\n";
    }

    public synchronized void run() {
        PsObject psObject;
        boolean bl;
        boolean bl2;
        String string;
        block24: {
            String string2;
            block23: {
                if (this.m_viewer == null) {
                    PsDebug.error("must call init() before invoking this method, viewer not instantiated.");
                    return;
                }
                String string3 = this.m_viewer.getParameter("CodeBase");
                if (string3 != null && !string3.equals("")) {
                    PsDebug.message("encountered external parameter: codebase = " + string3, false);
                    PsConfig.setCodeBase(string3);
                }
                string = this.m_viewer.getParameter("displayFile");
                this.m_disp = this.m_viewer.getDisplay();
                if (string != null) {
                    this.m_disp.setAutoCenter(false);
                }
                bl2 = true;
                bl = true;
                string2 = this.m_viewer.getParameter("Model");
                if (string2 == null) break block23;
                psObject = new PjImportModel();
                if (string != null) {
                    ((PjProject)psObject).setEnabledAutoFit(false);
                }
                this.m_viewer.addProject((PjProject)psObject);
                this.m_viewer.selectProject(psObject.getName());
                this.drawMessage("Loading " + string2 + " ...");
                if (!PsConfig.isApplication()) {
                    if (!(string2.startsWith("http:") || string2.startsWith("ftp:") || string2.startsWith("file:"))) {
                        string2 = PsConfig.getCodeBase() + string2;
                    }
                    ((PjImportModel)psObject).setFileName(string2);
                    if ("Show".equalsIgnoreCase(this.getParameter("ProjectPanel"))) {
                        if ("Small".equalsIgnoreCase(this.getParameter("ProjectPanelType"))) {
                            ((PjImportModel)psObject).setTypeOfInfoPanel(PjImportModel.SMALL_INFO_PANEL);
                            this.setLayout(new BorderLayout());
                            this.add("Center", (Component)((Object)this.m_disp));
                            this.add("South", this.m_viewer.getPanel(10));
                        } else {
                            this.setLayout(new GuiStackLayout(0));
                            this.add("FILL WIDE*5", (Component)((Object)this.m_disp));
                            this.add("FILL WIDE*4", this.m_viewer.getPanel(10));
                        }
                        this.m_viewer.showPanel(13);
                        bl = false;
                    }
                } else {
                    ((PjImportModel)psObject).setFileName(string2);
                    if (((PjImportModel)psObject).load(string2)) {
                        PsConfig.getFrame().setTitle(string2);
                    }
                    ((PjImportModel)psObject).setFileName(null);
                }
                bl2 = false;
                break block24;
            }
            psObject = new String[][]{{"file", "mgs"}, {"mathematica", "mgs"}, {"maple", "mpl"}, {"javaview", "jvx"}};
            int n = 0;
            while (n < ((PsObject)psObject).length) {
                block27: {
                    BufferedReader bufferedReader;
                    block25: {
                        block26: {
                            bufferedReader = null;
                            string2 = this.m_viewer.getParameter((String)((Object)psObject[n][0]));
                            if (string2 == null) break block25;
                            if (!((String)((Object)psObject[n][0])).equalsIgnoreCase("file")) break block26;
                            if (this.m_frame == null) break block27;
                            bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                            break block25;
                        }
                        bufferedReader = new BufferedReader(new StringReader(string2));
                    }
                    if (bufferedReader != null) {
                        PgGeometry[] pgGeometryArray;
                        String string4 = this.m_viewer.getParameter("Animate");
                        if (string4 != null && string4.equalsIgnoreCase("show")) {
                            PsDebug.message("Animation encountered...", false);
                            PgLoader.setAnimation(true);
                        }
                        if ((pgGeometryArray = PgLoader.load(null, bufferedReader, (String)((Object)psObject[n][1]))) != null) {
                            int n2 = 0;
                            while (n2 < pgGeometryArray.length) {
                                this.m_disp.addGeometry(pgGeometryArray[n2]);
                                ++n2;
                            }
                            bl2 = false;
                            PvDisplayOption pvDisplayOption = PgLoader.getDisplayOption();
                            if (pvDisplayOption != null) {
                                pvDisplayOption.configure(this.m_disp);
                            }
                        }
                    }
                }
                ++n;
            }
        }
        if (bl2) {
            psObject = new PgElementSet(3);
            psObject.setName("Snail");
            ((PgElementSet)psObject).computeSnail(20, 15, 2.0);
            ((PgElementSet)psObject).makeElementNormals();
            ((PgElementSet)psObject).makeElementColorsFromXYZ();
            ((PgElementSet)psObject).showElementColors(true);
            this.m_disp.addGeometry((PgGeometryIf)((Object)psObject));
            this.m_disp.selectGeometry((PgGeometryIf)((Object)psObject));
        }
        if (bl) {
            this.setLayout(new BorderLayout());
            this.add("Center", (Component)((Object)this.m_disp));
        }
        if (string != null) {
            if (this.m_dispOption == null) {
                this.m_dispOption = PvDisplayLoader.read(PsConfig.getCodeBase() + string);
            }
            if (this.m_dispOption == null || this.m_dispOption.length == 0 || this.m_dispOption[0] == null) {
                PsDebug.warning("reading of display configuration failed, file = " + string);
            } else {
                this.m_dispOption[0].configure(this.m_disp);
                this.m_disp.update(this.m_disp);
            }
        }
        this.validate();
        this.m_viewer.showPanel(13);
        this.startFromThread();
    }

    public void init() {
        if (this.m_frame == null) {
            this.repaint();
        }
        this.drawMessage("Loading viewer ...");
        if (this.m_viewer == null) {
            this.m_viewer = new PvViewer(this, this.m_frame);
        }
        Thread thread = new Thread((Runnable)this, "JavaView: inititialize applet");
        thread.setPriority(5);
        thread.start();
    }
}

