/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import java.awt.Color;
import jv.geom.PgPointSet;
import jv.geom.PgUtil;
import jv.number.PdColor;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.project.PgGeometry;
import jv.project.PgJvxSrc;
import jv.project.PvGeometryIf;
import jv.project.PvPickEvent;
import jv.vecmath.PdBary;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;

public class PgPolygon
extends PgPointSet {
    protected boolean m_bShowEdgeLabels;
    protected boolean m_bClosed;
    protected boolean m_bShowEdges;
    protected boolean m_bShowTaggedEdges;
    protected boolean m_bShowPolygonStartArrow;
    protected boolean m_bShowPolygonEndArrow;
    protected boolean m_bShowEdgeNormals;
    protected boolean m_bShowEdgeColors;
    protected boolean m_bShowPolygonColors;
    protected boolean m_useGlobalPolygonSize;
    protected PdColor m_globalPolygonColor;
    protected PdColor m_globalPolygonTagColor;
    protected PuDouble m_globalPolygonSize;
    public int NORMAL = 100;
    public int BINORMAL = 101;
    public int OFFSET_NORMAL = 102;
    public int CURVATURE_NORMAL = 103;
    private static /* synthetic */ Class class$jv$geom$PgPolygon;

    public boolean isShowingPolygonStartArrow() {
        return this.m_bShowPolygonStartArrow;
    }

    public void showPolygonStartArrow(boolean bl) {
        this.m_bShowPolygonStartArrow = bl;
    }

    public PiVector[] triangulate() {
        if (this.m_numVertices < 3) {
            PsDebug.warning("number of vertices < 3");
            return null;
        }
        PiVector[] piVectorArray = PgUtil.triangulate(this.m_vertex);
        if (piVectorArray == null) {
            PsDebug.warning("triangulation failed");
            return null;
        }
        return piVectorArray;
    }

    public PvPickEvent intersectionWithLine(PdVector pdVector, PdVector pdVector2) {
        if (this.m_dim != 2 && this.m_dim != 3) {
            return null;
        }
        PdVector pdVector3 = new PdVector(this.m_dim);
        PdVector pdVector4 = new PdVector(this.m_dim);
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MAX_VALUE;
        double d4 = Double.MAX_VALUE;
        PdVector pdVector5 = new PdVector(3);
        PdVector pdVector6 = this.m_dim == 2 ? new PdVector(2) : pdVector5;
        PdVector pdVector7 = new PdVector(3);
        PdBary pdBary = new PdBary(2);
        PdBary pdBary2 = new PdBary(2);
        PdVector pdVector8 = null;
        PdVector pdVector9 = null;
        if (this.m_dim == 2) {
            pdVector8 = new PdVector(3);
            pdVector9 = new PdVector(3);
        }
        PdVector pdVector10 = null;
        if (this.m_dim == 2) {
            pdVector10 = new PdVector(3);
        }
        pdVector2.normalize();
        PdVector[] pdVectorArray = this.m_vertex;
        int n4 = 1;
        while (n4 < this.m_numVertices) {
            pdVector3.sub(pdVectorArray[n4], pdVectorArray[n4 - 1]);
            if (!(pdVector3.sqrLength() < 1.0E-10)) {
                if (this.m_dim == 2) {
                    pdVector8.copyArray(pdVectorArray[n4 - 1]);
                    pdVector9.copyArray(pdVectorArray[n4]);
                    pdVector10.copyArray(pdVector3);
                } else {
                    pdVector8 = pdVectorArray[n4 - 1];
                    pdVector9 = pdVectorArray[n4];
                    pdVector10 = pdVector3;
                }
                pdVector10.normalize();
                d3 = PuVectorGeom.distOfLineToLine(pdVector, pdVector2, pdVector8, pdVector10);
                if (!(d3 >= d4) && !(d3 > 0.1)) {
                    d = PuVectorGeom.intersectionOfLineAndLine(pdVector5, pdVector, pdVector2, pdVector8, pdVector10);
                    if (this.m_dim == 2) {
                        pdVector6.m_data[0] = pdVector5.m_data[0];
                        pdVector6.m_data[1] = pdVector5.m_data[1];
                    }
                    PdBary.getBary(pdBary, pdVector5, pdVector8, pdVector9);
                    boolean bl = pdBary.isInside();
                    if (bl || Math.abs(1.0 - pdBary.getEntry(0)) < 0.1 || Math.abs(1.0 - pdBary.getEntry(1)) < 0.1) {
                        d4 = d3;
                        d2 = d;
                        n2 = n4;
                        pdVector4.copyArray(pdVector3);
                        n = -1;
                        if (bl) {
                            pdBary2.copy(pdBary);
                            pdVector7.blend(pdBary.getEntry(0), pdVector8, pdBary.getEntry(1), pdVector9);
                        } else if (Math.abs(1.0 - pdBary.getEntry(0)) < 0.1) {
                            pdBary2.setEntry(0, 1.0);
                            pdBary2.setEntry(1, 0.0);
                            pdVector7.copyArray(pdVector8);
                            n = n4 - 1;
                        } else if (Math.abs(1.0 - pdBary.getEntry(1)) < 0.1) {
                            pdBary2.setEntry(0, 0.0);
                            pdBary2.setEntry(1, 1.0);
                            pdVector7.copyArray(pdVector9);
                            n = n4;
                        }
                    }
                }
            }
            ++n4;
        }
        if (n2 == -1) {
            return null;
        }
        PvPickEvent pvPickEvent = new PvPickEvent(this.m_dim);
        pvPickEvent.setVertex(pdVector7);
        pvPickEvent.setDistance(d2);
        pvPickEvent.setElementInd(n2);
        pvPickEvent.setElementSubInd(n3);
        pvPickEvent.setBary(pdBary2);
        pvPickEvent.setVertexInd(n);
        pvPickEvent.setViewBase(pdVector);
        pvPickEvent.setViewDir(pdVector2);
        pvPickEvent.setNormal(pdVector4);
        return pvPickEvent;
    }

    public void makeNormals() {
        this.makeNormals(this.NORMAL, 1.0);
    }

    public void makeNormals(int n, double d) {
        int n2;
        int n3;
        int n4;
        this.assureVertexNormals();
        PdVector pdVector = new PdVector(this.m_dim);
        PdVector pdVector2 = new PdVector(this.m_dim);
        PdVector pdVector3 = new PdVector(this.m_dim);
        PdVector pdVector4 = new PdVector(this.m_dim);
        PdVector pdVector5 = new PdVector(3);
        PdVector pdVector6 = new PdVector(3);
        int n5 = this.getNumVertices();
        boolean bl = this.isClosed();
        PiVector piVector = new PiVector(n5);
        int n6 = 0;
        while (n6 < n5) {
            piVector.setEntry(n6, n6);
            ++n6;
        }
        if (piVector == null || n5 < 3) {
            PsDebug.warning("polygon[" + n6 + "] null or less than 3 vertices");
            return;
        }
        int n7 = 0;
        int n8 = 1;
        int n9 = piVector.getEntry(n7);
        do {
            n4 = piVector.getEntry(n8);
            pdVector.sub(this.m_vertex[n4], this.m_vertex[n9]);
        } while (pdVector.sqrLength() < 1.0E-10 && ++n8 < n5);
        if (n8 >= n5) {
            PsDebug.warning("polygon[" + n6 + "] is degenerated to a point");
            pdVector3.setEntry(this.m_dim - 1, 1.0);
            PdVector.setConstant(this.m_vertexNormal, pdVector3);
            return;
        }
        int n10 = n5 - 2;
        if (bl) {
            n10 = n8 - 1;
        }
        pdVector3.normalToVector(pdVector);
        if (n8 >= n5 - 1) {
            PsDebug.warning("polygon is a line");
            PdVector.setConstant(this.m_vertexNormal, pdVector3);
            return;
        }
        pdVector4.copy(pdVector3);
        pdVector.normalize();
        pdVector6.cross(pdVector, pdVector3);
        pdVector3.setLength(d);
        int n11 = -1;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            bl3 = true;
        }
        int n12 = n8;
        int n13 = n4;
        while (n8 != n10) {
            double d2;
            n8 = n12;
            n12 = (n12 + 1) % n5;
            n4 = n13;
            n13 = piVector.getEntry(n12);
            pdVector2.sub(this.m_vertex[n13], this.m_vertex[n4]);
            if (pdVector2.sqrLength() < 1.0E-10) {
                bl2 = true;
                if (n11 != -1) continue;
                n11 = n8;
                continue;
            }
            pdVector2.sub(this.m_vertex[n13], this.m_vertex[n4]);
            pdVector2.normalize();
            pdVector3.sub(pdVector2, pdVector);
            if (!pdVector3.normalize()) {
                n11 = -1;
                bl3 = true;
                continue;
            }
            pdVector5.cross(pdVector, pdVector3);
            if (n == this.NORMAL) {
                pdVector3.setLength(d);
            } else if (n == this.BINORMAL) {
                pdVector3.copy(pdVector5);
                pdVector3.setLength(d);
            } else if (n == this.OFFSET_NORMAL) {
                double d3 = PdVector.angleWithOrientation(pdVector, pdVector2, pdVector5);
                d2 = d / Math.cos(d3 / 2.0);
                pdVector3.setLength(d2);
            } else if (n == this.CURVATURE_NORMAL) {
                double d4 = PdVector.angleWithOrientation(pdVector, pdVector2, pdVector5);
                d2 = d * d4;
                pdVector3.setLength(d2);
            }
            if (PdVector.dot(pdVector5, pdVector6) < 0.0) {
                pdVector3.multScalar(-1.0);
                pdVector5.multScalar(-1.0);
            }
            if (bl3) {
                int n14 = (n7 + 1) % n5;
                if (!bl && n7 == 0) {
                    n14 = 0;
                }
                bl3 = false;
                pdVector4.cross(pdVector5, pdVector);
                pdVector4.normalize();
                if (n == this.NORMAL) {
                    pdVector4.setLength(d);
                } else if (n == this.BINORMAL) {
                    pdVector4.copy(pdVector5);
                    pdVector4.setLength(d);
                } else if (n == this.OFFSET_NORMAL) {
                    pdVector4.setLength(d);
                } else if (n == this.CURVATURE_NORMAL) {
                    pdVector4.setConstant(0.0);
                }
                n3 = n14;
                while (n3 != n8) {
                    this.m_vertexNormal[piVector.getEntry(n3)].copy(pdVector4);
                    n3 = (n3 + 1) % n5;
                }
            }
            pdVector4.copy(pdVector3);
            if (n == this.NORMAL) {
                pdVector4.setLength(d);
            } else if (n == this.BINORMAL) {
                pdVector4.copy(pdVector5);
                pdVector4.setLength(d);
            } else if (n == this.OFFSET_NORMAL) {
                double d5 = PdVector.angleWithOrientation(pdVector, pdVector2, pdVector5);
                d2 = d / Math.cos(d5 / 2.0);
                pdVector4.setLength(d2);
            } else if (n == this.CURVATURE_NORMAL) {
                double d6 = PdVector.angleWithOrientation(pdVector, pdVector2, pdVector5);
                d2 = d * d6;
                pdVector4.setLength(d2);
            }
            if (bl2) {
                bl2 = false;
                n3 = n11;
                n11 = -1;
                while (n3 != n8) {
                    this.m_vertexNormal[piVector.getEntry(n3)].copy(pdVector4);
                    n3 = (n3 + 1) % n5;
                }
            }
            this.m_vertexNormal[piVector.getEntry(n8)].copy(pdVector4);
            pdVector.copy(pdVector2);
            pdVector4.copy(pdVector3);
            pdVector6.copy(pdVector5);
            n9 = n4;
            n7 = n8;
        }
        if (!bl && (n2 = (n7 + 1) % n5) < n5) {
            pdVector4.cross(pdVector6, pdVector);
            pdVector4.normalize();
            if (n == this.NORMAL) {
                pdVector4.setLength(d);
            } else if (n == this.BINORMAL) {
                pdVector4.copy(pdVector5);
                pdVector4.setLength(d);
            } else if (n == this.OFFSET_NORMAL) {
                pdVector4.setLength(d);
            } else if (n == this.CURVATURE_NORMAL) {
                pdVector4.setConstant(0.0);
            }
            n3 = n2;
            while (n3 < n5) {
                this.m_vertexNormal[piVector.getEntry(n3)].copy(pdVector4);
                ++n3;
            }
        }
    }

    public void computeCircle(int n, double d) {
        this.setNumVertices(n);
        this.assureVertexNormals();
        if (this.m_dim > 2) {
            PdVector.setConstant(this.m_vertex, 0.0);
            if (this.m_vertexNormal != null) {
                PdVector.setConstant(this.m_vertexNormal, 0.0);
            }
        }
        double d2 = Math.PI * 2 / (double)this.m_numVertices;
        int n2 = 0;
        while (n2 < this.m_numVertices) {
            this.m_vertex[n2].m_data[0] = d * Math.cos(d2 * (double)n2);
            this.m_vertex[n2].m_data[1] = d * Math.sin(d2 * (double)n2);
            ++n2;
        }
        if (this.m_vertexNormal != null) {
            n2 = 0;
            while (n2 < this.m_numVertices) {
                this.m_vertexNormal[n2].m_data[0] = Math.cos(d2 * (double)n2);
                this.m_vertexNormal[n2].m_data[1] = Math.sin(d2 * (double)n2);
                ++n2;
            }
        }
        this.m_bClosed = true;
    }

    public boolean isShowingEdges() {
        return this.m_bShowEdges;
    }

    public void showEdges(boolean bl) {
        this.m_bShowEdges = bl;
    }

    public boolean update(Object object) {
        if (object == null) {
            return super.update(null);
        }
        if (object == this.m_globalPolygonSize) {
            return super.update(null);
        }
        if (object == this.m_globalPolygonColor) {
            return super.update(null);
        }
        return super.update(object);
    }

    public boolean isShowingEdgeLabels() {
        return this.m_bShowEdgeLabels;
    }

    public void showEdgeLabels(boolean bl) {
        this.m_bShowEdgeLabels = bl;
    }

    public PiVector getPolygon() {
        int n = this.m_numVertices;
        if (this.isClosed()) {
            ++n;
        }
        PiVector piVector = new PiVector(n);
        int n2 = 0;
        while (n2 < this.m_numVertices) {
            piVector.m_data[n2] = n2;
            ++n2;
        }
        if (this.isClosed()) {
            piVector.m_data[n - 1] = 0;
        }
        return piVector;
    }

    public void useGlobalPolygonSize(boolean bl) {
        this.m_useGlobalPolygonSize = bl;
    }

    public Object clone() {
        PgPolygon pgPolygon = (PgPolygon)super.clone();
        if (pgPolygon == null) {
            return null;
        }
        pgPolygon.m_globalPolygonSize = (PuDouble)this.m_globalPolygonSize.clone();
        pgPolygon.m_globalPolygonColor = (PdColor)this.m_globalPolygonColor.clone();
        pgPolygon.m_globalPolygonTagColor = (PdColor)this.m_globalPolygonTagColor.clone();
        pgPolygon.m_globalPolygonSize.setParent(pgPolygon);
        pgPolygon.m_globalPolygonColor.setParent(pgPolygon);
        pgPolygon.m_globalPolygonTagColor.setParent(pgPolygon);
        return pgPolygon;
    }

    public boolean isClosed() {
        return this.m_bClosed;
    }

    public void showPolygonColors(boolean bl) {
        this.m_bShowPolygonColors = bl;
    }

    public boolean isShowingEdgeNormals() {
        return this.m_bShowEdgeNormals;
    }

    public boolean isShowingPolygonColors() {
        return this.m_bShowPolygonColors;
    }

    public void showEdgeNormals(boolean bl) {
        this.m_bShowEdgeNormals = bl;
    }

    public double getLength() {
        double d = 0.0;
        int n = 1;
        while (n < this.m_numVertices) {
            d += this.m_vertex[n - 1].dist(this.m_vertex[n]);
            ++n;
        }
        if (this.isClosed()) {
            d += PdVector.dist(this.m_vertex[0], this.m_vertex[this.m_numVertices - 1]);
        }
        return d;
    }

    public void makeOffsetNormals() {
        this.makeNormals(this.OFFSET_NORMAL, 1.0);
    }

    public void makeCurvatureNormals() {
        this.makeNormals(this.CURVATURE_NORMAL, 1.0);
    }

    public boolean checkTriangleCut(int n, PdVector pdVector) {
        PdVector[] pdVectorArray = new PdVector[3];
        PdVector[] pdVectorArray2 = new PdVector[3];
        PdVector[] pdVectorArray3 = new PdVector[3];
        double[] dArray = new double[3];
        n = (n + this.m_numVertices - 1) % this.m_numVertices;
        int n2 = 0;
        do {
            pdVectorArray[n2] = this.m_vertex[(n + n2) % this.m_numVertices];
        } while (++n2 < 3);
        n2 = 0;
        do {
            pdVectorArray2[n2] = PdVector.subNew(pdVectorArray[(n + n2 + 1) % this.m_numVertices], pdVectorArray[(n + n2) % this.m_numVertices]);
            pdVectorArray3[n2] = PdVector.crossNew(pdVector, pdVectorArray2[n2]);
            boolean bl = pdVectorArray3[n2].normalize();
            if (!bl) {
                PsDebug.warning("two vertices may be identical");
                return false;
            }
            dArray[n2] = -PdVector.dot(pdVectorArray3[n2], pdVectorArray[n2]);
        } while (++n2 < 3);
        int n3 = (n + 2) % n;
        while (n3 != n) {
            if (PdVector.dot(this.m_vertex[n3], pdVectorArray3[0]) + dArray[0] > 0.0 && PdVector.dot(this.m_vertex[n3], pdVectorArray3[1]) + dArray[1] > 0.0 && PdVector.dot(this.m_vertex[n3], pdVectorArray3[2]) + dArray[2] > 0.0) {
                return false;
            }
            n3 = n3++ % n;
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(super.toString());
        stringBuffer.append("\t ******* PgPolygon ***********\n");
        stringBuffer.append("\t m_bClosed = " + this.m_bClosed + "\n");
        return stringBuffer.toString();
    }

    public PgPolygon() {
        this(3);
    }

    public PgPolygon(int n) {
        super(n);
        this.setDimOfSimplex(1);
        this.m_globalPolygonColor = new PdColor(PsConfig.getMessage("globalPolygonColor"), this);
        this.m_globalPolygonTagColor = new PdColor(PsConfig.getMessage("globalPolygonTagColor"), this);
        this.m_globalPolygonSize = new PuDouble(PsConfig.getMessage("globalPolygonSize"), this);
        if (this.getClass() == (class$jv$geom$PgPolygon != null ? class$jv$geom$PgPolygon : (class$jv$geom$PgPolygon = PgPolygon.class$("jv.geom.PgPolygon")))) {
            this.init();
        }
    }

    public Color getGlobalPolygonTagColor() {
        return this.m_globalPolygonTagColor.getColor();
    }

    public void setGlobalPolygonTagColor(Color color) {
        this.m_globalPolygonTagColor.setColor(color);
    }

    public void useGlobalPolygonColor(boolean bl) {
        this.showPolygonColors(!bl);
    }

    public void paint(PvGeometryIf pvGeometryIf) {
        super.paint(pvGeometryIf);
        pvGeometryIf.setState(83, this.isShowingEdgeLabels());
        pvGeometryIf.setState(54, this.m_bShowEdges);
        pvGeometryIf.setState(52, this.m_bShowEdges);
        pvGeometryIf.setState(53, this.m_bShowTaggedEdges);
        pvGeometryIf.setState(88, this.m_bShowPolygonStartArrow);
        pvGeometryIf.setState(89, this.m_bShowPolygonEndArrow);
        pvGeometryIf.setState(92, this.m_bShowPolygonColors);
        if (this.m_bShowEdges) {
            if (this.m_globalPolygonSize != null) {
                pvGeometryIf.setGlobalPolygonSize(this.m_globalPolygonSize.getValue());
            }
            if (this.m_globalPolygonColor != null) {
                pvGeometryIf.setGlobalPolygonColor(this.m_globalPolygonColor.getColor());
            }
            if (this.m_globalPolygonTagColor != null) {
                pvGeometryIf.setGlobalPolygonTagColor(this.m_globalPolygonTagColor.getColor());
            }
        }
        pvGeometryIf.setNumPolygons(1);
        pvGeometryIf.setPolygon(0, this.getPolygon());
    }

    public boolean blend(double d, PgPolygon pgPolygon, double d2, PgPolygon pgPolygon2) {
        if (pgPolygon == null || pgPolygon.m_numVertices == 0) {
            PsDebug.warning("empty first argument", this);
            return false;
        }
        if (pgPolygon2 == null || pgPolygon.m_numVertices != pgPolygon2.m_numVertices) {
            PsDebug.warning("wrong second argument", this);
            return false;
        }
        if (Math.abs(d) < 1.0E-10) {
            d = 0.0;
        }
        if (Math.abs(d2) < 1.0E-10) {
            d2 = 0.0;
        }
        if (!super.blend(d, pgPolygon, d2, pgPolygon2)) {
            return false;
        }
        this.m_bClosed = pgPolygon.m_bClosed == pgPolygon2.m_bClosed ? pgPolygon.m_bClosed : false;
        return true;
    }

    public void setClosed(boolean bl) {
        this.m_bClosed = bl;
    }

    public void makeBiNormals() {
        this.makeNormals(this.BINORMAL, 1.0);
    }

    public void copy(PgGeometry pgGeometry) {
        super.copy(pgGeometry);
        if (!(pgGeometry instanceof PgPolygon)) {
            return;
        }
        PgPolygon pgPolygon = (PgPolygon)pgGeometry;
        this.m_bClosed = pgPolygon.m_bClosed;
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public double getGlobalPolygonSize() {
        return this.m_globalPolygonSize.getValue();
    }

    public void setGlobalPolygonSize(double d) {
        this.m_globalPolygonSize.setValue(d);
    }

    public void computeEight(int n) {
        this.setNumVertices(n);
        if (this.m_dim > 2) {
            PdVector.setConstant(this.m_vertex, 0.0);
            if (this.m_vertexNormal != null) {
                PdVector.setConstant(this.m_vertexNormal, 0.0);
            }
        }
        double d = Math.PI * 2 / (double)this.m_numVertices;
        int n2 = 0;
        while (n2 < this.m_numVertices) {
            this.m_vertex[n2].m_data[0] = 2.0 * Math.cos(d * (double)n2);
            this.m_vertex[n2].m_data[1] = 2.0 * Math.sin(2.0 * d * (double)n2);
            ++n2;
        }
        this.setClosed(true);
        this.makeNormals();
    }

    public PgJvxSrc getJvx() {
        PgJvxSrc pgJvxSrc = super.getJvx();
        pgJvxSrc.setType(31);
        pgJvxSrc.showEdgeLabels(this.isShowingEdgeLabels());
        pgJvxSrc.showPolygons(this.m_bShowEdges);
        pgJvxSrc.showPolygonStartArrow(this.isShowingPolygonStartArrow());
        pgJvxSrc.showPolygonEndArrow(this.isShowingPolygonEndArrow());
        pgJvxSrc.setDimOfPolygons(this.getNumVertices());
        pgJvxSrc.setNumPolygons(1);
        pgJvxSrc.setPolygon(0, this.getPolygon());
        pgJvxSrc.setPolygonColors(new Color[]{this.getGlobalPolygonColor()});
        pgJvxSrc.setGlobalPolygonColor(this.getGlobalPolygonColor());
        pgJvxSrc.setGlobalPolygonTagColor(this.getGlobalPolygonTagColor());
        pgJvxSrc.setGlobalPolygonSize(this.getGlobalPolygonSize());
        return pgJvxSrc;
    }

    public void setJvx(PgJvxSrc pgJvxSrc) {
        super.setJvx(pgJvxSrc);
        this.showEdgeLabels(pgJvxSrc.isShowingEdgeLabels());
        this.showEdges(pgJvxSrc.isShowingPolygons());
        this.showPolygonStartArrow(pgJvxSrc.isShowingPolygonStartArrow());
        this.showPolygonEndArrow(pgJvxSrc.isShowingPolygonEndArrow());
        this.showPolygonColors(false);
        if (pgJvxSrc.getGlobalPolygonColor() != null) {
            this.setGlobalPolygonColor(pgJvxSrc.getGlobalPolygonColor());
        }
        if (pgJvxSrc.getGlobalPolygonTagColor() != null) {
            this.setGlobalPolygonTagColor(pgJvxSrc.getGlobalPolygonTagColor());
        }
        if (pgJvxSrc.getGlobalPolygonSize() != 0.0) {
            this.setGlobalPolygonSize(pgJvxSrc.getGlobalPolygonSize());
        }
    }

    public boolean isShowingEdgeColors() {
        return this.m_bShowEdgeColors;
    }

    public void init() {
        super.init();
        this.m_bClosed = false;
        this.m_bShowEdges = true;
        this.m_bShowTaggedEdges = true;
        this.m_bShowEdgeNormals = false;
        this.m_bShowEdgeColors = false;
        this.m_bShowPolygonStartArrow = false;
        this.m_bShowPolygonEndArrow = false;
        this.m_bShowPolygonColors = false;
        this.m_useGlobalPolygonSize = true;
        this.m_globalPolygonColor.setColor(Color.black);
        this.m_globalPolygonTagColor.setColor(Color.red);
        this.m_globalPolygonSize.setDefBounds(1.0, 10.0, 1.0, 2.0);
        this.m_globalPolygonSize.setDefValue(1.0);
        this.m_globalPolygonSize.init();
    }

    public boolean isShowingPolygonEndArrow() {
        return this.m_bShowPolygonEndArrow;
    }

    public void showEdgeColors(boolean bl) {
        this.m_bShowEdgeColors = bl;
    }

    public void showPolygonEndArrow(boolean bl) {
        this.m_bShowPolygonEndArrow = bl;
    }

    public Color getGlobalPolygonColor() {
        return this.m_globalPolygonColor.getColor();
    }

    public void setGlobalPolygonColor(Color color) {
        this.m_globalPolygonColor.setColor(color);
    }
}

