/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.geom.PgElementSet;
import jv.geom.PgTexture;
import jv.loader.PgFileDialog;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.objectGui.GuiStackLayout;
import jv.project.PvDisplayIf;
import jv.project.PvViewerIf;
import jv.vecmath.PiVector;

public class PgTexture_IP
extends PsPanel
implements ActionListener,
ItemListener {
    protected PgTexture m_texture;
    protected Panel m_pSize;
    protected Checkbox m_cShowImage;
    protected TextField m_tImage;
    protected String m_fileName;
    protected String m_dirName;
    protected Button m_bBrowse;
    protected Choice m_cImageFit;
    protected Button m_bReset;
    protected PvDisplayIf m_display;
    protected PgElementSet m_texGeom;
    protected PgElementSet m_imgGeom;
    private static /* synthetic */ Class class$jv$geom$PgTexture_IP;

    public PgTexture_IP() {
        if (this.getClass() == (class$jv$geom$PgTexture_IP != null ? class$jv$geom$PgTexture_IP : (class$jv$geom$PgTexture_IP = PgTexture_IP.class$("jv.geom.PgTexture_IP")))) {
            this.init();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object != this.m_cImageFit && object == this.m_cShowImage) {
            if (this.m_cShowImage.getState()) {
                PvViewerIf pvViewerIf = (PvViewerIf)PsConfig.getViewer();
                this.m_display = pvViewerIf.newDisplay("Texture", true);
                PgElementSet pgElementSet = (PgElementSet)this.m_texture.getFather();
                this.m_texGeom = (PgElementSet)pgElementSet.clone();
                this.m_texGeom.setName("TexCoords of " + pgElementSet.getName());
                this.m_texGeom.setParent(this);
                this.m_texGeom.setDimOfVertices(pgElementSet.getDimOfTextures());
                this.m_texGeom.removeAllVectorFields();
                this.m_texGeom.setElementTextures(null);
                this.m_texGeom.setVertexTextures(null);
                if (pgElementSet.hasVertexTextures()) {
                    this.m_texGeom.setVertices(pgElementSet.getVertexTextures());
                } else if (pgElementSet.hasElementTextures()) {
                    this.m_texGeom.setNumVertices(pgElementSet.getNumElementIndices());
                    this.m_texGeom.setVertices(pgElementSet.getVertexTextures());
                    PiVector[] piVectorArray = this.m_texGeom.getElements();
                    int n = pgElementSet.getNumElements();
                    int n2 = 0;
                    int n3 = 0;
                    while (n3 < n) {
                        int n4 = piVectorArray[n3].getSize();
                        int n5 = 0;
                        while (n5 < n4) {
                            piVectorArray[n3].m_data[n5] = n2++;
                            ++n5;
                        }
                        ++n3;
                    }
                } else {
                    return;
                }
                this.m_imgGeom = new PgElementSet(2);
                this.m_imgGeom.setName("TexImage of " + pgElementSet.getName());
                this.m_imgGeom.computePlane(2, 2, 0.0, 0.0, 1.0, 1.0);
                this.m_imgGeom.makeVertexTextureFromBndBox(0, 1);
                this.m_imgGeom.setTexture((PgTexture)this.m_texture.clone());
                this.m_imgGeom.showVertexTexture(true);
                this.m_texGeom.showVertexTexture(false);
                this.m_texGeom.setTexture(null);
                this.m_texGeom.showElementTexture(false);
                this.m_texGeom.showElements(false);
                this.m_texGeom.showEdges(true);
                this.m_display.addGeometry(this.m_texGeom);
                this.m_display.addGeometry(this.m_imgGeom);
                this.m_display.setBackgroundColor(Color.red);
                this.m_display.setDrawingOrder(-1, this.m_imgGeom);
                this.m_display.selectCamera(1);
                ((Component)this.m_display.getFrame()).setVisible(true);
            } else {
                PvViewerIf pvViewerIf = (PvViewerIf)PsConfig.getViewer();
                if (pvViewerIf.hasDisplay(this.m_display)) {
                    pvViewerIf.removeDisplay(this.m_display);
                }
                this.m_display = null;
                this.m_texGeom = null;
                this.m_imgGeom = null;
            }
        }
        this.m_texture.update(this);
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        super.setParent(psUpdateIf);
        this.m_texture = (PgTexture)psUpdateIf;
        this.m_pSize.add(this.m_texture.m_uMin.getInfoPanel());
        this.m_pSize.add(this.m_texture.m_vMin.getInfoPanel());
        this.m_pSize.add(this.m_texture.m_uMax.getInfoPanel());
        this.m_pSize.add(this.m_texture.m_vMax.getInfoPanel());
    }

    public boolean update(Object object) {
        if (this.m_texture == null) {
            PsDebug.warning("missing texture");
            return false;
        }
        if (object == this.m_texture) {
            String string = this.m_texture.getName();
            if (string != null && this.getTitle() != null && !string.equals(this.getTitle())) {
                this.setTitle(string);
            }
            if (this.m_texture.getImageName() != null) {
                ((TextComponent)this.m_tImage).setText(this.m_texture.getImageName());
            }
            if (this.m_imgGeom != null) {
                this.m_imgGeom.setTexture(this.m_texture);
                this.m_imgGeom.update(this.m_imgGeom);
            }
            return true;
        }
        if (object == this.m_texGeom) {
            PgElementSet pgElementSet = (PgElementSet)this.m_texture.getFather();
            pgElementSet.setVertexTextures(this.m_texGeom.getVertices());
            pgElementSet.update(pgElementSet);
            return true;
        }
        return super.update(object);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.m_texture == null) {
            return;
        }
        Object object = actionEvent.getSource();
        if (object == this.m_tImage) {
            this.m_fileName = this.m_tImage.getText();
            this.m_fileName.trim();
            this.m_texture.setImageName(this.m_fileName);
            Image image = this.m_texture.loadImage(this);
            if (image == null) {
                this.m_texture.setImageName(null);
                return;
            }
            this.m_texture.update(this.m_texture);
            return;
        }
        if (object == this.m_bBrowse) {
            Object object2;
            if (!PsConfig.isApplication()) {
                this.m_fileName = this.m_tImage.getText();
                this.m_fileName.trim();
            } else {
                object2 = new PgFileDialog(PsConfig.getFrame(), PsConfig.getMessage("OpenImage"), 0);
                if (this.m_dirName == null) {
                    this.m_dirName = PsConfig.getCodeBase() + "images";
                }
                ((FileDialog)object2).setDirectory(this.m_dirName);
                ((Component)object2).setVisible(true);
                String string = ((FileDialog)object2).getFile();
                if (string == null) {
                    return;
                }
                this.m_dirName = ((FileDialog)object2).getDirectory();
                this.m_fileName = this.m_dirName + string;
                this.m_fileName.trim();
                ((TextComponent)this.m_tImage).setText(this.m_fileName);
            }
            this.m_texture.setImageName(this.m_fileName);
            object2 = this.m_texture.loadImage(this);
            if (object2 == null) {
                return;
            }
            this.m_texture.update(this.m_texture);
            return;
        }
        if (object == this.m_bReset) {
            this.m_texture.init();
            this.m_texture.update(this.m_texture);
        }
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void init() {
        super.init();
        PsPanel psPanel = new PsPanel();
        psPanel.setLayout(new GridLayout(3, 2));
        psPanel.addTitle(PsConfig.getMessage("textureImage"));
        this.m_cShowImage = new Checkbox(PsConfig.getMessage("ShowTexture"));
        this.m_cShowImage.addItemListener(this);
        psPanel.add(this.m_cShowImage);
        psPanel.add(new Label(PsConfig.getMessage("Tiling")));
        this.m_cImageFit = new Choice();
        this.m_cImageFit.addItemListener(this);
        this.m_cImageFit.addItem(PsConfig.getMessage("cCenter"));
        this.m_cImageFit.addItem(PsConfig.getMessage("cTesselate"));
        this.m_cImageFit.addItem(PsConfig.getMessage("cResize"));
        this.m_cImageFit.setEnabled(false);
        psPanel.add(this.m_cImageFit);
        Panel panel = new Panel();
        panel.setLayout(new GuiStackLayout(0, 0));
        panel.add("WIDE*2", new Label(PsConfig.getMessage("ImageFile")));
        this.m_bBrowse = new Button(PsConfig.getMessage("Load"));
        this.m_bBrowse.addActionListener(this);
        panel.add("FILL*1", this.m_bBrowse);
        psPanel.add(panel);
        this.m_tImage = new TextField();
        this.m_tImage.addActionListener(this);
        psPanel.add(this.m_tImage);
        this.add(psPanel);
        this.addSubTitle(PsConfig.getMessage("textureSize"));
        this.m_pSize = new Panel();
        this.m_pSize.setLayout(new GridLayout(4, 1));
        this.add(this.m_pSize);
        panel = new Panel();
        panel.setLayout(new FlowLayout());
        this.add(panel);
        this.m_bReset = new Button(PsConfig.getMessage("bReset"));
        this.m_bReset.addActionListener(this);
        panel.add(this.m_bReset);
    }
}

