/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.Component;
import java.awt.Image;
import java.awt.List;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import jv.anim.PsAnimation;
import jv.anim.PsKeyframe;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygonSet;
import jv.loader.PgExport_Dialog;
import jv.loader.PgJvxLoader;
import jv.loader.PgLoaderIf;
import jv.loader.PgMapleLoader;
import jv.loader.PgMathLoader;
import jv.loader.PgObjLoader;
import jv.loader.PsXmlLoader;
import jv.loader.PvDisplayLoader;
import jv.loader.PvDisplayOption;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.objectGui.PsImage;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.rsrc.PsXmlNode;
import jv.rsrc.PsXmlSrc;
import jv.thirdParty.acmeEncoders.GifEncoder;
import jv.thirdParty.acmeEncoders.ImageEncoder;
import jv.thirdParty.acmeEncoders.PpmEncoder;

public final class PgLoader {
    protected static boolean m_bShowAnimationPanel = true;
    protected static PvDisplayOption m_displayOption;
    protected static boolean m_bIsAnimation;
    protected static boolean m_bIsEnabledSmallSize;

    public static void setEnabledSmallSize(boolean bl) {
        m_bIsEnabledSmallSize = bl;
    }

    public static PgGeometry[] read(PgJvxSrc[] pgJvxSrcArray, boolean bl, boolean bl2) {
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0) {
            PsDebug.warning("missing geometry animation");
            return null;
        }
        int n = pgJvxSrcArray.length;
        PgJvxSrc[][] pgJvxSrcArray2 = new PgJvxSrc[n][1];
        int n2 = 0;
        while (n2 < n) {
            pgJvxSrcArray2[n2][0] = pgJvxSrcArray[n2];
            ++n2;
        }
        return PgLoader.read(pgJvxSrcArray2, bl, bl2);
    }

    public static PgGeometry[] read(PgJvxSrc[][] pgJvxSrcArray, boolean bl, boolean bl2) {
        int n;
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0) {
            PsDebug.warning("missing geometry animation");
            return null;
        }
        int n2 = pgJvxSrcArray.length;
        int n3 = pgJvxSrcArray[0].length;
        PgGeometry[] pgGeometryArray = new PgGeometry[n3];
        PsKeyframe[] psKeyframeArray = new PsKeyframe[n3];
        int n4 = 0;
        while (n4 < n3) {
            n = pgJvxSrcArray[0][n4].getType();
            int n5 = pgJvxSrcArray[0][n4].getDimOfVertices();
            psKeyframeArray[n4] = new PsKeyframe();
            int n6 = 0;
            while (n6 < n2) {
                PgGeometry pgGeometry;
                if (n != pgJvxSrcArray[n6][n4].getType()) {
                    PsDebug.warning("geometry type changes among key frames");
                    return null;
                }
                if (n5 != pgJvxSrcArray[n6][n4].getDimOfVertices()) {
                    PsDebug.warning("dimension of vertices changes among key frames");
                    return null;
                }
                switch (n) {
                    case 33: {
                        pgGeometry = new PgElementSet(n5);
                        break;
                    }
                    case 30: {
                        pgGeometry = new PgPointSet(n5);
                        break;
                    }
                    case 32: {
                        pgGeometry = new PgPolygonSet(n5);
                        break;
                    }
                    default: {
                        pgGeometry = pgJvxSrcArray[n6][n4];
                    }
                }
                pgGeometry.setJvx(pgJvxSrcArray[n6][n4]);
                double d = n2 == 1 ? 0.0 : 100.0 * (double)n6 / ((double)n2 - 1.0);
                psKeyframeArray[n4].addKey(pgGeometry, d);
                ++n6;
            }
            psKeyframeArray[n4].setTime(0.0);
            pgGeometryArray[n4] = psKeyframeArray[n4].getDynamic();
            if (pgGeometryArray[n4] != null) {
                pgGeometryArray[n4].setName("Interpol[" + n4 + "]");
            }
            ++n4;
        }
        PsAnimation psAnimation = new PsAnimation();
        psAnimation.setName("Keyframe Animation");
        n = 0;
        while (n < n3) {
            psAnimation.addTimeListener(psKeyframeArray[n]);
            ++n;
        }
        psAnimation.enableKeys(true);
        if (bl2) {
            psAnimation.getAnimationPanel().show();
        }
        if (bl) {
            psAnimation.setTimeInterval(0.0, 100.0, 100.0 / ((double)n2 - 1.0), 100.0 / ((double)n2 - 1.0));
        } else {
            psAnimation.setTimeInterval(0.0, 100.0, 10.0 / ((double)n2 - 1.0), 50.0 / ((double)n2 - 1.0));
        }
        return pgGeometryArray;
    }

    public static String saveToString(PgGeometryIf[] pgGeometryIfArray, String string) {
        if (pgGeometryIfArray == null || pgGeometryIfArray.length == 0) {
            PsDebug.warning("missing geometry to save.");
            return null;
        }
        if (string == null) {
            PsDebug.warning("missing file name extension.");
            return null;
        }
        if (string.equalsIgnoreCase("byu") || string.equalsIgnoreCase("dxf") || string.equalsIgnoreCase("fe") || string.equalsIgnoreCase("mgs") || string.equalsIgnoreCase("mpl") || string.equalsIgnoreCase("obj") || string.equalsIgnoreCase("off") || string.equalsIgnoreCase("stl")) {
            if (pgGeometryIfArray.length > 1) {
                PsDebug.warning("only the active geometry of the scene is saved\n\tbecause restriction of the file format resp. export module\n\tUse JVX format to save more geometries in a single file.");
            }
            if ((string.equalsIgnoreCase("byu") || string.equalsIgnoreCase("stl")) && !(pgGeometryIfArray[0] instanceof PgJvxSrc) && !(pgGeometryIfArray[0] instanceof PgElementSet)) {
                PsDebug.warning("format does not save other geometries besides surfaces, ext = " + string);
                return null;
            }
        }
        PgJvxSrc[] pgJvxSrcArray = PgLoader.assureJvx(pgGeometryIfArray);
        StringWriter stringWriter = new StringWriter();
        boolean bl = false;
        if (string.equalsIgnoreCase("mgs")) {
            try {
                PgMathLoader pgMathLoader = new PgMathLoader();
                bl = pgMathLoader.write(stringWriter, pgJvxSrcArray);
                if (!bl) {
                    PsDebug.warning("error during export.");
                    return null;
                }
            }
            catch (IOException iOException) {
                PsDebug.warning("failed writing to writer,", iOException);
            }
        } else {
            PgLoaderIf pgLoaderIf = PgLoader.getLoader(string);
            if (pgLoaderIf == null) {
                PsDebug.warning("unknown file extension, no loader found");
                return null;
            }
            if (string.equalsIgnoreCase("jvx")) {
                PgJvxLoader cfr_ignored_0 = (PgJvxLoader)pgLoaderIf;
                PgJvxLoader.setEnabledSmallSize(PgLoader.isEnabledSmallSize());
            }
            try {
                bl = pgLoaderIf.write(stringWriter, pgJvxSrcArray);
                if (!bl) {
                    PsDebug.warning("error during export.");
                    return null;
                }
            }
            catch (IOException iOException) {
                PsDebug.warning("failed writing to writer,", iOException);
            }
        }
        return stringWriter.toString();
    }

    public static boolean readAll(List list, String string) throws IOException {
        PsXmlNode psXmlNode;
        Object object;
        if (string == null) {
            PsDebug.warning("missing fileName");
            return false;
        }
        PsXmlSrc psXmlSrc = PsXmlLoader.read(string);
        if (psXmlSrc == null) {
            PsDebug.warning("failed to read list from file = " + string, list);
            return false;
        }
        PsXmlNode psXmlNode2 = psXmlSrc.getRootNode();
        if (psXmlNode2 == null) {
            PsDebug.warning("missing root node when reading list from file = " + string, list);
            return false;
        }
        list.removeAll();
        PsXmlNode psXmlNode3 = psXmlNode2.getChild("directories");
        if (psXmlNode3 == null) {
            PsDebug.warning("directory contains no directory section, dir = " + string);
            return false;
        }
        PsXmlNode[] psXmlNodeArray = psXmlNode3.getChildren("directory");
        if (psXmlNodeArray != null) {
            PsDebug.message("directory contains no subdirectories, dir = " + string, false);
            int n = 0;
            while (n < psXmlNodeArray.length) {
                object = psXmlNodeArray[n].getChild("name");
                if (object == null) {
                    PsDebug.warning("directory has no name, dir = " + string);
                }
                list.add(((PsXmlNode)object).getContent());
                ++n;
            }
        }
        if ((psXmlNode = psXmlNode2.getChild("models")) == null) {
            PsDebug.warning("directory contains no directory section, model = " + string);
            return false;
        }
        object = psXmlNode.getChildren("model");
        if (object != null) {
            int n = 0;
            while (n < ((PsXmlNode[])object).length) {
                list.add(object[n].getContent());
                ++n;
            }
        }
        return true;
    }

    public static PvDisplayOption getDisplayOption() {
        return m_displayOption;
    }

    protected static void setDisplayOption(PvDisplayOption pvDisplayOption) {
        m_displayOption = pvDisplayOption;
    }

    public static void setAnimation(boolean bl) {
        m_bIsAnimation = bl;
    }

    public static boolean isEnabledSmallSize() {
        return m_bIsEnabledSmallSize;
    }

    public static PgGeometry[] load(PgGeometry[] pgGeometryArray, String string, String string2) {
        if (string == null) {
            PsDebug.warning("missing argument: data");
            return null;
        }
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        pgGeometryArray = PgLoader.load(pgGeometryArray, bufferedReader, string2);
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {}
        return pgGeometryArray;
    }

    public static PgGeometry[] load(String string) {
        if (string == null) {
            PsDebug.warning("missing fileName");
            return null;
        }
        return PgLoader.load(null, string);
    }

    public static PgGeometry[] load(PgGeometry[] pgGeometryArray, String string) {
        if (string == null) {
            PsDebug.warning("missing fileName");
            return null;
        }
        String string2 = PsUtil.getFileExtension(string);
        if (string2 == null) {
            PsDebug.warning("missing extension in file=" + string);
            return null;
        }
        BufferedReader bufferedReader = PsUtil.open(string);
        if (bufferedReader == null) {
            PsDebug.warning("could not open file = " + string);
            return null;
        }
        pgGeometryArray = PgLoader.load(pgGeometryArray, bufferedReader, string2);
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {}
        if (pgGeometryArray == null) {
            PsDebug.warning("error when reading file = " + string);
            return null;
        }
        int n = 0;
        while (n < pgGeometryArray.length) {
            if (pgGeometryArray[n] != null && (pgGeometryArray[n].getName() == null || pgGeometryArray[n].getName().startsWith("object_"))) {
                if (n == 0) {
                    pgGeometryArray[n].setName(PsUtil.getFileBaseName(string));
                } else {
                    pgGeometryArray[n].setName(PsUtil.getFileBaseName(string) + "[" + n + "]");
                }
            }
            ++n;
        }
        if (string2.indexOf("jvx") != -1) {
            n = 0;
            while (n < pgGeometryArray.length) {
                Image image;
                String string3 = pgGeometryArray[n].getTextureImageName();
                if (string3 != null && (image = PsImage.getImage(PsUtil.getFilePath(string) + string3)) != null) {
                    if (!PsImage.loadImage(PsConfig.getFrame(), image)) {
                        PsDebug.warning("failed loading image = " + string3);
                    } else {
                        pgGeometryArray[n].setTextureImage(image);
                    }
                }
                ++n;
            }
        }
        return pgGeometryArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PgGeometry[] load(PgGeometry[] pgGeometryArray, BufferedReader bufferedReader, String string) {
        if (bufferedReader == null) {
            PsDebug.warning("missing buffered reader");
            return null;
        }
        if (string == null) {
            PsDebug.warning("missing format type");
            return null;
        }
        string = string.toLowerCase();
        PgLoader.setDisplayOption(null);
        try {
            if (!bufferedReader.ready()) {
                return null;
            }
        }
        catch (Exception exception) {
            PsDebug.warning("exception = " + exception.toString());
            PsDebug.message("failed reading from reader.", false);
            return null;
        }
        if (string.indexOf("mgs") != -1) {
            PgJvxSrc[][] pgJvxSrcArray;
            PgMathLoader pgMathLoader = new PgMathLoader();
            if (PgLoader.isAnimation()) {
                pgMathLoader.setKeyAnimation(PgLoader.isAnimation());
            }
            if ((pgJvxSrcArray = pgMathLoader.read(bufferedReader)) == null || pgJvxSrcArray.length == 0 || pgJvxSrcArray[0] == null || pgJvxSrcArray[0].length == 0) {
                PsDebug.warning("reading failed");
                return null;
            }
            PgLoader.setDisplayOption(pgMathLoader.getDisplayOption());
            if (pgMathLoader.isAnimation()) return PgLoader.read(pgJvxSrcArray, pgMathLoader.isAnimation(), m_bShowAnimationPanel);
            if (pgMathLoader.isKeyAnimation()) {
                return PgLoader.read(pgJvxSrcArray, pgMathLoader.isAnimation(), m_bShowAnimationPanel);
            }
            PgJvxSrc[] pgJvxSrcArray2 = pgJvxSrcArray[0];
            pgGeometryArray = PgLoader.assureLength(pgGeometryArray, pgJvxSrcArray2.length);
            int n = 0;
            while (n < pgJvxSrcArray2.length) {
                pgGeometryArray[n] = PgLoader.assureType(pgGeometryArray[n], pgJvxSrcArray2[n].getType(), pgJvxSrcArray2[n].getDimOfVertices());
                pgGeometryArray[n].setJvx(pgJvxSrcArray2[n]);
                ++n;
            }
            return pgGeometryArray;
        }
        if (string.indexOf("mpl") != -1) {
            PgMapleLoader pgMapleLoader = new PgMapleLoader();
            PgJvxSrc[] pgJvxSrcArray = pgMapleLoader.read(bufferedReader);
            if (pgJvxSrcArray == null) return null;
            if (pgJvxSrcArray.length == 0) {
                return null;
            }
            if (pgMapleLoader.isAnimation()) {
                return PgLoader.read(pgJvxSrcArray, !pgMapleLoader.isAnimation(), m_bShowAnimationPanel);
            }
            pgGeometryArray = PgLoader.assureLength(pgGeometryArray, pgJvxSrcArray.length);
            int n = 0;
            while (n < pgJvxSrcArray.length) {
                pgGeometryArray[n] = PgLoader.assureType(pgGeometryArray[n], pgJvxSrcArray[n].getType(), pgJvxSrcArray[n].getDimOfVertices());
                pgGeometryArray[n].setJvx(pgJvxSrcArray[n]);
                switch (pgJvxSrcArray[n].getType()) {
                    case 30: {
                        PgPointSet pgPointSet = (PgPointSet)pgGeometryArray[n];
                        pgPointSet.makeVertexColorsFromXYZ();
                        pgPointSet.showVertexColors(true);
                        break;
                    }
                    case 33: {
                        PgElementSet pgElementSet = (PgElementSet)pgGeometryArray[n];
                        pgElementSet.makeElementColorsFromXYZ();
                        pgElementSet.showElementColors(true);
                        break;
                    }
                    case 32: {
                        PgPolygonSet pgPolygonSet = (PgPolygonSet)pgGeometryArray[n];
                        pgPolygonSet.makePolygonColorsFromXYZ();
                        pgPolygonSet.showPolygonColors(true);
                    }
                }
                ++n;
            }
            return pgGeometryArray;
        }
        if (string.indexOf("obj") != -1 || string.indexOf("edg") != -1) {
            PgObjLoader pgObjLoader = new PgObjLoader();
            PgJvxSrc[] pgJvxSrcArray = pgObjLoader.read(bufferedReader);
            PgJvxSrc pgJvxSrc = pgJvxSrcArray[0];
            if (pgJvxSrc == null) return null;
            pgGeometryArray = PgLoader.assureLength(pgGeometryArray, 1);
            pgGeometryArray[0] = PgLoader.assureType(pgGeometryArray[0], pgJvxSrc.getType(), pgJvxSrc.getDimOfVertices());
            pgGeometryArray[0].setJvx(pgJvxSrc);
            switch (pgJvxSrc.getType()) {
                case 33: {
                    int[] nArray = pgObjLoader.m_meshType;
                    if (pgObjLoader.m_numMeshType <= 0) return pgGeometryArray;
                    if (nArray[0] != 1) return pgGeometryArray;
                    if (nArray[1] != 2) return pgGeometryArray;
                    PgElementSet pgElementSet = (PgElementSet)pgGeometryArray[0];
                    pgElementSet.makeQuadrConn(nArray[3], nArray[2]);
                    return pgGeometryArray;
                }
                default: {
                    return pgGeometryArray;
                }
            }
        }
        if (string.indexOf("jvd") != -1) {
            PvDisplayOption[] pvDisplayOptionArray = PvDisplayLoader.read(bufferedReader);
            if (pvDisplayOptionArray != null) {
                if (pvDisplayOptionArray.length != 0) return null;
            }
            PsDebug.warning("reading of display configuration failed");
            return null;
        }
        PgLoaderIf pgLoaderIf = PgLoader.getLoader(string);
        if (pgLoaderIf == null) {
            PsDebug.warning("unknown file extension, no loader found");
            return null;
        }
        PgJvxSrc[] pgJvxSrcArray = pgLoaderIf.read(bufferedReader);
        if (pgJvxSrcArray == null) return null;
        if (pgJvxSrcArray.length == 0) {
            return null;
        }
        if (pgLoaderIf.isAnimation()) {
            return PgLoader.read(pgJvxSrcArray, false, m_bShowAnimationPanel);
        }
        pgGeometryArray = PgLoader.assureLength(pgGeometryArray, pgJvxSrcArray.length);
        int n = 0;
        while (n < pgJvxSrcArray.length) {
            pgGeometryArray[n] = PgLoader.assureType(pgGeometryArray[n], pgJvxSrcArray[n].getType(), pgJvxSrcArray[n].getDimOfVertices());
            pgGeometryArray[n].setJvx(pgJvxSrcArray[n]);
            if (!string.equalsIgnoreCase("jvx")) {
                switch (pgJvxSrcArray[n].getType()) {
                    case 33: {
                        PgElementSet pgElementSet = (PgElementSet)pgGeometryArray[n];
                        pgElementSet.makeNeighbour();
                    }
                }
            }
            ++n;
        }
        return pgGeometryArray;
    }

    public static PvDisplayOption[] load(BufferedReader bufferedReader, String string) {
        if (bufferedReader == null) {
            PsDebug.warning("missing buffered reader");
            return null;
        }
        if (string == null) {
            PsDebug.warning("missing format type");
            return null;
        }
        string = string.toLowerCase();
        try {
            if (!bufferedReader.ready()) {
                return null;
            }
        }
        catch (IOException iOException) {
            PsDebug.warning("exception = " + iOException.toString());
            PsDebug.message("failed reading from reader.", false);
            return null;
        }
        PvDisplayOption[] pvDisplayOptionArray = null;
        if (string.indexOf("jvd") != -1) {
            pvDisplayOptionArray = PvDisplayLoader.read(bufferedReader);
        }
        if (pvDisplayOptionArray == null || pvDisplayOptionArray.length == 0) {
            PsDebug.warning("reading of display from reader");
            return null;
        }
        PgLoader.setDisplayOption(pvDisplayOptionArray[0]);
        return pvDisplayOptionArray;
    }

    public static boolean readDirs(List list, String string) throws IOException {
        if (string == null) {
            PsDebug.warning("missing fileName");
            return false;
        }
        list.removeAll();
        list.add("..");
        String[] stringArray = PgLoader.readDirs(string);
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                list.add(stringArray[n]);
                ++n;
            }
        }
        return true;
    }

    public static String[] readDirs(String string) throws IOException {
        if (string == null) {
            PsDebug.warning("missing fileName");
            return null;
        }
        PsXmlSrc psXmlSrc = PsXmlLoader.read(string);
        if (psXmlSrc == null) {
            PsDebug.warning("failed to read list from file = " + string);
            return null;
        }
        PsXmlNode psXmlNode = psXmlSrc.getRootNode();
        if (psXmlNode == null) {
            PsDebug.warning("could not read list from file = " + string);
            return null;
        }
        PsXmlNode psXmlNode2 = psXmlNode.getChild("directories");
        if (psXmlNode2 == null) {
            PsDebug.warning("directory contains no directory section, dir = " + string);
            return null;
        }
        PsXmlNode[] psXmlNodeArray = psXmlNode2.getChildren("directory");
        if (psXmlNodeArray == null) {
            return null;
        }
        String[] stringArray = new String[psXmlNodeArray.length];
        int n = 0;
        while (n < psXmlNodeArray.length) {
            PsXmlNode psXmlNode3 = psXmlNodeArray[n].getChild("name");
            if (psXmlNode3 == null) {
                PsDebug.warning("directory has no name, dir = " + string);
            }
            stringArray[n] = psXmlNode3.getContent();
            ++n;
        }
        return stringArray;
    }

    static {
        m_bIsAnimation = false;
        m_bIsEnabledSmallSize = false;
    }

    public static boolean save(PgGeometryIf[] pgGeometryIfArray, String string) {
        Object object;
        Object object2;
        if (pgGeometryIfArray == null) {
            PsDebug.warning("missing geometries");
            return false;
        }
        if (string == null) {
            PsDebug.warning("missing fileName");
            return false;
        }
        String string2 = PsUtil.getFileExtension(string);
        if (string2 == null) {
            PsDebug.warning("missing extension in file name.");
            return false;
        }
        string2 = string2.toLowerCase();
        String string3 = null;
        String string4 = null;
        int n = 0;
        while (n < pgGeometryIfArray.length) {
            if (pgGeometryIfArray[n].isVisible()) {
                if (string3 == null) {
                    string3 = PsUtil.getFilePath(string);
                    string4 = PsUtil.getFileBaseName(string);
                }
                if (string3 == null || string4 == null) {
                    PsDebug.warning("unable to extract path or base name of file name = " + string);
                    break;
                }
                object2 = pgGeometryIfArray[n].getTextureImage();
                if (object2 != null) {
                    String string5;
                    if (!string2.equalsIgnoreCase("jvx")) {
                        PsDebug.warning("geometry format does not know about texture. Texture saved anyway.");
                    }
                    if ((string5 = pgGeometryIfArray[n].getTextureImageName()) == null) {
                        string5 = string4 + "_" + pgGeometryIfArray[n].getName() + ".gif";
                        pgGeometryIfArray[n].setTextureImageName(string5);
                    } else {
                        if (!(string5 = PsUtil.getFileName(string5)).endsWith(".gif")) {
                            PsDebug.warning("currently, texture is always saved in GIF format.");
                            string5 = string5 + ".gif";
                        }
                        pgGeometryIfArray[n].setTextureImageName(string5);
                    }
                    object = string3 + string5;
                    PgLoader.save((Image)object2, (String)object);
                }
            }
            ++n;
        }
        if (PsConfig.isApplication()) {
            PgJvxSrc[] pgJvxSrcArray = PgLoader.assureJvx(pgGeometryIfArray);
            object2 = PsUtil.writeFile(string);
            if (object2 == null) {
                PsDebug.warning("could not open file = " + string);
                return false;
            }
            boolean bl = false;
            if (string2.equalsIgnoreCase("mgs")) {
                try {
                    object = new PgMathLoader();
                    bl = ((PgMathLoader)object).write((Writer)object2, pgJvxSrcArray);
                    if (!bl) {
                        PsDebug.warning("error during export.");
                        ((PrintWriter)object2).close();
                        return false;
                    }
                }
                catch (IOException iOException) {
                    PsDebug.warning("failed writing to writer,", iOException);
                }
            } else {
                object = PgLoader.getLoader(string2);
                if (object == null) {
                    PsDebug.warning("unknown file extension, no loader found");
                    ((PrintWriter)object2).close();
                    return false;
                }
                if (string2.equalsIgnoreCase("jvx")) {
                    PgJvxLoader cfr_ignored_0 = (PgJvxLoader)object;
                    PgJvxLoader.setEnabledSmallSize(PgLoader.isEnabledSmallSize());
                }
                try {
                    bl = object.write((Writer)object2, pgJvxSrcArray);
                    if (!bl) {
                        PsDebug.warning("error during export.");
                    }
                }
                catch (IOException iOException) {
                    PsDebug.warning("failed writing to writer,", iOException);
                }
            }
            ((PrintWriter)object2).close();
            return bl;
        }
        String string6 = PgLoader.saveToString(pgGeometryIfArray, string2);
        if (string6 == null) {
            PsDebug.warning("error during export.");
            return false;
        }
        return PgLoader.save(string6, string);
    }

    public static boolean save(String string, String string2) {
        if (string == null) {
            PsDebug.warning("missing data to save.");
            return false;
        }
        if (string2 == null) {
            PsDebug.warning("missing fileName");
            return false;
        }
        if (PsConfig.isApplication()) {
            PrintWriter printWriter = PsUtil.writeFile(string2);
            if (printWriter == null) {
                PsDebug.warning("could not open file = " + string2);
                return false;
            }
            printWriter.println(string);
            printWriter.close();
        } else {
            PgExport_Dialog pgExport_Dialog = new PgExport_Dialog(PsConfig.getFrame(), "JavaView " + PsConfig.getMessage("Export"), false);
            String string3 = PsUtil.getFileExtension(string2);
            if (string3 != null) {
                pgExport_Dialog.setFilenameExtension(string3);
            }
            pgExport_Dialog.setText(string);
            ((Component)pgExport_Dialog).setVisible(true);
        }
        return true;
    }

    public static boolean save(PvDisplayOption[] pvDisplayOptionArray, String string) {
        if (pvDisplayOptionArray == null) {
            PsDebug.warning("missing option to save.");
            return false;
        }
        if (string == null) {
            PsDebug.warning("missing fileName");
            return false;
        }
        String string2 = string.substring(string.lastIndexOf(46) + 1, string.length());
        if (string2 == null) {
            PsDebug.warning("missing extension in file name.");
            return false;
        }
        if (!string2.equalsIgnoreCase("jvd")) {
            PsDebug.warning("unknown option file ext = " + string2);
            return false;
        }
        String string3 = PvDisplayLoader.write(pvDisplayOptionArray);
        return PgLoader.save(string3, string);
    }

    public static boolean save(Image image, String string) {
        if (image == null) {
            PsDebug.warning("missing image to save.");
            return false;
        }
        if (string == null) {
            PsDebug.warning("missing fileName");
            return false;
        }
        String string2 = string.substring(string.lastIndexOf(46) + 1, string.length());
        if (string2 == null) {
            PsDebug.warning("missing extension in file name.");
            return false;
        }
        if (!string2.equalsIgnoreCase("gif") && !string2.equalsIgnoreCase("ppm")) {
            PsDebug.warning("unknown image file ext = " + string2);
            return false;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            if (fileOutputStream == null) {
                PsDebug.warning("could not open file = " + string);
                return false;
            }
            ImageEncoder imageEncoder = null;
            if (string2.equalsIgnoreCase("gif")) {
                imageEncoder = new GifEncoder(image, (OutputStream)fileOutputStream);
            } else if (string2.equalsIgnoreCase("ppm")) {
                imageEncoder = new PpmEncoder(image, (OutputStream)fileOutputStream);
            }
            if (imageEncoder == null) {
                PsDebug.warning("Failed to create an encoder, ext = " + string2 + "\n\t file = " + string);
                return false;
            }
            imageEncoder.encode();
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            PsDebug.error("Failed to save image: Exception = " + iOException.toString() + "\n\t file = " + string);
            return false;
        }
        return true;
    }

    public static double parseDouble(StreamTokenizer streamTokenizer) throws IOException {
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype != -2) {
            PsDebug.warning("called with tokenType different to TT_NUMBER, st = " + streamTokenizer.toString());
            return 0.0;
        }
        double d = streamTokenizer.nval;
        if (streamTokenizer.nextToken() != -3 || !streamTokenizer.sval.startsWith("e") && !streamTokenizer.sval.startsWith("E")) {
            streamTokenizer.pushBack();
            return d;
        }
        if (streamTokenizer.sval.equals("e") || streamTokenizer.sval.equals("E")) {
            double d2;
            streamTokenizer.nextToken();
            if (streamTokenizer.ttype == 43) {
                streamTokenizer.nextToken();
                d2 = streamTokenizer.nval;
            } else if (streamTokenizer.ttype == 45) {
                streamTokenizer.nextToken();
                d2 = -streamTokenizer.nval;
            } else {
                d2 = streamTokenizer.nval;
            }
            if (streamTokenizer.ttype != -2) {
                PsDebug.warning("Number expected.");
                return 0.0;
            }
            return d * Math.pow(10.0, d2);
        }
        String string = "1." + streamTokenizer.sval;
        return d * Double.valueOf(string);
    }

    public static boolean isAnimation() {
        return m_bIsAnimation;
    }

    private static PgGeometry assureType(PgGeometry pgGeometry, int n, int n2) {
        if (pgGeometry != null && pgGeometry.getDimOfVertices() != n2) {
            pgGeometry = null;
        }
        switch (n) {
            case 32: {
                if (pgGeometry != null && pgGeometry instanceof PgPolygonSet) break;
                pgGeometry = new PgPolygonSet(n2);
                break;
            }
            case 33: {
                if (pgGeometry != null && pgGeometry instanceof PgElementSet) break;
                pgGeometry = new PgElementSet(n2);
                break;
            }
            default: {
                if (pgGeometry != null && pgGeometry instanceof PgPointSet) break;
                pgGeometry = new PgPointSet(n2);
            }
        }
        return pgGeometry;
    }

    private static PgLoaderIf getLoader(String string) {
        String string2 = String.valueOf(string.charAt(0)).toUpperCase() + string.substring(1, string.length());
        String string3 = "Pg" + string2 + "Loader";
        PgLoaderIf pgLoaderIf = null;
        if (string.equalsIgnoreCase("mpl")) {
            pgLoaderIf = new PgMapleLoader();
        } else {
            pgLoaderIf = (PgLoaderIf)PsUtil.newInstance("jv.loader." + string3);
            if (pgLoaderIf == null) {
                pgLoaderIf = (PgLoaderIf)PsUtil.newInstance("jvx.loader." + string3);
            }
        }
        return pgLoaderIf;
    }

    private static PgJvxSrc[] assureJvx(PgGeometryIf[] pgGeometryIfArray) {
        PgJvxSrc[] pgJvxSrcArray = new PgJvxSrc[pgGeometryIfArray.length];
        int n = 0;
        while (n < pgGeometryIfArray.length) {
            if (pgGeometryIfArray[n] == null) {
                PsDebug.warning("null geometry found at index i = " + n);
            } else if (pgGeometryIfArray[n] instanceof PgJvxSrc) {
                pgJvxSrcArray[n] = (PgJvxSrc)pgGeometryIfArray[n];
            } else {
                pgJvxSrcArray[n] = pgGeometryIfArray[n].getJvx();
                if (pgJvxSrcArray[n] == null) {
                    PsDebug.warning("failed to create jvx source of geom = " + pgGeometryIfArray[n].getName());
                }
            }
            ++n;
        }
        return pgJvxSrcArray;
    }

    public static double parseDouble(String string) {
        try {
            return new Double(string);
        }
        catch (NumberFormatException numberFormatException) {
            PsDebug.warning("wrong format = " + string);
            return 0.0;
        }
    }

    public static void showAnimationPanel(boolean bl) {
        m_bShowAnimationPanel = bl;
    }

    private static PgGeometry[] assureLength(PgGeometry[] pgGeometryArray, int n) {
        if (pgGeometryArray == null) {
            return new PgGeometry[n];
        }
        if (n == pgGeometryArray.length) {
            return pgGeometryArray;
        }
        PgGeometry[] pgGeometryArray2 = new PgGeometry[n];
        int n2 = 0;
        while (n2 < Math.min(n, pgGeometryArray.length)) {
            pgGeometryArray2[n2] = pgGeometryArray[n2];
            ++n2;
        }
        return pgGeometryArray2;
    }
}

